/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.contacts.ModifyContactListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class NamingAttributeListener
extends ModifyContactListener {
    public NamingAttributeListener() {
        this.reportId = new Integer(3005);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1074L})) {
            return this.rb.getString("admp.mgmt.contact_mgmt.delete_contacts.access_denied");
        }
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        StringBuffer errorMessage = new StringBuffer();
        String guid = this.getValue(result, 10050);
        String dn = this.getValue(result, 10004);
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        boolean fullNameSuccess = false;
        String[] selectedAttributes = new String[]{"displayNameFormat", "fullNameFormat"};
        BeanMap props = (BeanMap)bean.get("props");
        for (int j = 0; j < selectedAttributes.length; ++j) {
            String value = props.getProperty(selectedAttributes[j]);
            if (value.equalsIgnoreCase("--") || value.equalsIgnoreCase("0")) continue;
            if ((value = FormatClientUtil.getFormatValue(new Long(value), result, domainName, "contact")) == null || value.equalsIgnoreCase("") || value.equals(".") || value.equals("..")) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(", ");
                }
                String str = MessageFormat.format(this.rb.getString("admp.mgmt.contact_mgmt.naming_attr.stat_msg_is_empty_string"), this.ldapNameVsDisplayName.get(selectedAttributes[j]));
                errorMessage.append(str);
                continue;
            }
            if (selectedAttributes[j].equals("fullNameFormat")) {
                try {
                    fullNameSuccess = true;
                    logger.log(Level.INFO, "MODIFY Full Name :  " + dn + " value : " + value + " ATTRIBUTELIST : " + attributeList);
                    ADHandlerForMgmt.modifyUserFullName((String)domainName, (Long)loginId, (String)dn, (String)value, (ArrayList)attributeList);
                    ADHandler.updateContact((String)domainName, (Long)loginId, (String)guid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                }
                catch (LocalizedException le) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append(le.getMessage(this.rb));
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append(e.getMessage());
                }
                TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, this.rb.getString("admp.mgmt.cont_mgmt.naming_attribs.mgmtname.naming_attribs_full_name"), this.getValue(result, 10004), domainName, this.rb.getString("admp.common.attribldapname.fullname"), value, errorMessage.toString(), this.rb.getString("admp.mgmt.cont_mgmt.mgmtcategory.cont_modification"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                continue;
            }
            setAttributeList.add(this.getAttributeProps(selectedAttributes[j], value));
        }
        logger.log(Level.INFO, " dnDomainNameMap and the LIST : " + domainName);
        logger.log(Level.INFO, "MODIFY Contact , DOMAIN :  " + domainName + " Guid : " + guid + " ATTRIBUTELIST : " + setAttributeList);
        if (setAttributeList.size() == 0) {
            if (!fullNameSuccess) {
                errorMessage.insert(0, this.rb.getString("client.contacts.NamingAttributeListener.unable_to_modify_the_contact_error") + " : ");
            }
        } else {
            try {
                ADHandler.modifyContact((String)domainName, (Long)loginId, (String)guid, (String)dn, setAttributeList, (ArrayList)attributeList, (NativeListener)listener);
                if (errorMessage.length() > 0) {
                    errorMessage.insert(0, this.rb.getString("client.contacts.NamingAttributeListener.successfully_modified_error") + " : ");
                }
            }
            catch (LocalizedException le) {
                errorMessage.insert(0, this.rb.getString("client.contacts.NamingAttributeListener.unable_to_modify_the_contact") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                errorMessage.insert(0, this.rb.getString("client.contacts.NamingAttributeListener.unable_to_modify_the_contact") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditContactModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_naming_attribs"), this.getValue(result, 10004), domainName, setAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        if (errorMessage.length() == 0) {
            return this.rb.getString("client.contacts.NamingAttributeListener.successfully_modified");
        }
        return errorMessage.toString();
    }
}

