/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CSVContactListener
extends CSVUserListener {
    public CSVContactListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        super(loginId, ids, domainVsIds, groupList);
    }

    @Override
    public AddUserHandler returnHandler() {
        ContactUserHandler handler = ContactUserHandler.getInstance();
        return handler;
    }

    @Override
    protected String[][] getMessages() {
        String[] messageKeys = new String[]{"heading", "query.string", "message.body", "message.match.criteria", "message.error_occured", "error.no.object", "link.sample"};
        String[] messages = new String[]{this.rb.getString("client.csv.CSVContactListener.modify_contacts_using_CSV"), "(&(objectClass=contact)(objectCategory=contact))", this.rb.getString("client.csv.CSVContactListener.you_can_modify_contacts_by_importing_data_from_csv_files"), this.rb.getString("client.csv.CSVContactListener.match_criteria_for_contacts_in_AD"), this.rb.getString("client.csv.CSVContactListener.show_the_error_occured_contacts_only"), this.rb.getString("client.csv.CSVContactListener.please_select_the_contact"), "/help/csv-import-management/active-directory-modify-contacts-csv.html"};
        String[][] mess = new String[][]{messageKeys, messages};
        return mess;
    }

    @Override
    protected void performADSync() {
        DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"CONTACT"}, (boolean)false);
    }

    @Override
    protected void modifyObject(String defaultNamingContext, Hashtable hashtable, Hashtable customAttributesList, boolean isLicenseExceeded, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Properties prop;
        String distinguishedName;
        block83: {
            String userName;
            Long userIndex;
            block80: {
                boolean removeMemberOf;
                String objectName;
                Properties removeProps;
                ArrayList<String> groupList;
                ArrayList customList;
                ArrayList<Hashtable> propList;
                block78: {
                    userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    propList = new ArrayList<Hashtable>();
                    customList = new ArrayList();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    removeProps = new Properties();
                    String searchString = "(&(objectClass=contact)(objectCategory=contact)";
                    for (int i = 0; i < valuesList.size(); ++i) {
                        Hashtable prop2 = (Hashtable)valuesList.get(i);
                        if (this.validSelectedValues != null) {
                            for (int k = 0; k < this.validSelectedValues.length; ++k) {
                                String index;
                                String attributeName = (String)prop2.get("ATTRIB_LDAP_NAME");
                                if (!attributeName.equals(index = this.validSelectedValues[k]) || !attributeName.equals(index)) continue;
                                Object attributeObjVal = prop2.get("ATTRIB_VALUE");
                                int relationalType = (Integer)prop2.get("RELATIONAL_TYPE");
                                String attributeValue = "";
                                if (relationalType == 1) continue;
                                attributeValue = (String)attributeObjVal;
                                Long dataType = (Long)prop2.get("DATA_HANDLER_TYPE");
                                if (dataType == 6L) {
                                    attributeValue = attributeValue.toUpperCase();
                                }
                                attributeValue = attributeName.equalsIgnoreCase("objectGUID") ? CSVContactListener.convertGuidToHexDecimal(attributeValue) : CommonUtil.escapeSpecialCharacters((String)attributeValue);
                                searchString = searchString + "(" + attributeName + "=" + attributeValue + ")";
                            }
                            continue;
                        }
                        searchString = searchString + "(" + this.keyLdapName + "=" + this.keyLdapValue + ")";
                    }
                    searchString = searchString + ")";
                    mgmtLog.log(Level.INFO, "SearchString in the Contact Updation : " + searchString);
                    objectName = "";
                    objectName = this.getObjectName(valuesList);
                    this.removeUnAuthorizedProps(valuesList);
                    this.getProperties("modify", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "Contact");
                    String name = "";
                    distinguishedName = "";
                    if (props.get("distinguishedName") != null) {
                        distinguishedName = props.getProperty("distinguishedName");
                    }
                    removeMemberOf = false;
                    if (props.get("removeMemberOf") != null && props.getProperty("removeMemberOf").equals("true")) {
                        removeMemberOf = true;
                    }
                    userName = "";
                    if (props.get("userName") != null) {
                        userName = props.getProperty("userName");
                    }
                    String manager = "";
                    if (props.get("manager") != null) {
                        manager = props.getProperty("manager");
                    }
                    Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
                    mgmtLog.log(Level.INFO, "Bulk Contact modification Custom Attributes : " + customAttributesList);
                    if (nameVsValues != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            String attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            if (attributeName.equalsIgnoreCase("removeMemberOf")) {
                                removeProps.put("removeMemberOf", this.splitMultiValues(values));
                                continue;
                            }
                            if (attributeName.equalsIgnoreCase("removeProxyAddresses")) {
                                removeProps.put("removeProxyAddresses", this.splitMultiValues(values));
                                continue;
                            }
                            if (!this.isClearEmptyValue && values != null && values.size() == 0) continue;
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", 1L);
                            boolean bl = false;
                            Hashtable attribDetails = this.returnHandler().getAttributeDetailsFromMap("ATTRIB_LDAP_NAME", (Object)attributeName);
                            if (attribDetails != null && attribDetails.get("RELATIONAL_TYPE") != null) {
                                boolean bl2 = bl = ((Integer)attribDetails.get("RELATIONAL_TYPE")).compareTo(1) == 0;
                            }
                            if (this.isAppendMultiValue && bl) {
                                customTable.put("DW_CONTROL_CODE", 3L);
                            } else {
                                customTable.put("DW_CONTROL_CODE", 2L);
                            }
                            if (values != null && values.size() > 1) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (Object string : values) {
                                    list.add(string.toString().trim());
                                }
                                customTable.put("ATTRIB_VALUE", list);
                                customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            } else if (values != null && values.size() == 1) {
                                customTable.put("ATTRIB_VALUE", values.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", "");
                                customTable.put("DW_CONTROL_CODE", 1L);
                            }
                            customList.add(customTable);
                        }
                    }
                    for (String string : UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) {
                        if (!userName.contains(string)) continue;
                        mgmtLog.log(Level.FINE, "replacing.... " + string);
                        userName = userName.replaceAll(string, "\\\\" + string);
                        mgmtLog.log(Level.FINE, "replaced userName " + userName);
                    }
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    logProps.put("domainName", this.domainName);
                    logProps.put("userName", userName);
                    logProps.put("propList", propList);
                    logProps.put("modifyList", modifyList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    logProps.put("groupList", groupList);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (String)objectName, (String)this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    audit_info.put("objectName", objectName);
                    if (props.get("manager") != null) {
                        audit_info.put("manager", manager);
                    }
                    if (removeMemberOf) {
                        removeProps.put("isClearIfEmpty", (Object)removeMemberOf);
                    }
                    prop = new Properties();
                    if (isLicenseExceeded) break block80;
                    try {
                        StringBuffer message;
                        String CREATION_STATUS;
                        block81: {
                            ArrayList arrayList;
                            block82: {
                                this.removeUnAuthorizedProps(customList);
                                this.checkRemovePropsSelected(removeProps);
                                if (propList.size() == 0 && groupList.size() == 0 && customList.size() == 0 && !removeMemberOf && removeProps != null && !removeProps.isEmpty()) {
                                    removeProps.put("HasRemoveProps", (Object)true);
                                }
                                CREATION_STATUS = "SUCCESS";
                                if (distinguishedName.equals("")) {
                                    Properties domainDetails;
                                    boolean bl;
                                    String value;
                                    boolean bl3 = false;
                                    ArrayList userAttributeList = new ArrayList();
                                    userAttributeList.add("distinguishedName");
                                    userAttributeList.add("name");
                                    if (removeProps.containsKey("removeProxyAddresses")) {
                                        userAttributeList.add("proxyAddresses");
                                    }
                                    if (removeProps.containsKey("removeMemberOf") && (value = (String)((ArrayList)removeProps.get("removeMemberOf")).get(0)).equalsIgnoreCase("true")) {
                                        bl = true;
                                        userAttributeList.add("memberOf");
                                    }
                                    if ((userAttributeList = ADHandler.getObjectsWithOutListener((Properties)(domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId)), (String)defaultNamingContext, userAttributeList, (String)searchString)) != null && userAttributeList.size() > 0) {
                                        Properties dnProp = (Properties)userAttributeList.get(0);
                                        if (removeProps.containsKey("removeProxyAddresses")) {
                                            this.checkAndRemovePrimaryProxyAddr(removeProps, dnProp);
                                        }
                                        if (removeProps.containsKey("removeMemberOf") && bl) {
                                            this.removeUnAuthorizedGroups(removeProps, dnProp, this.loginId, this.domainName);
                                        }
                                        distinguishedName = StrUtil.getString((Properties)dnProp, (String)"distinguishedName");
                                        name = StrUtil.getString((Properties)dnProp, (String)"name");
                                    } else {
                                        prop.setProperty("CREATION_STATUS", "SEVERE");
                                        prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
                                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                    }
                                }
                                arrayList = (ArrayList)this.authorizedDomainOUHash.get(this.domainName);
                                if (propList.size() <= 0 && groupList.size() <= 0 && customList.size() <= 0 && !removeMemberOf && removeProps.size() <= 0) break block81;
                                mgmtLog.log(Level.INFO, "propList after authorize check " + propList);
                                logProps.put("customList", customList);
                                if (arrayList != null && arrayList.size() != 0) break block82;
                                NativeError error = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), propList, groupList, (Properties)removeProps);
                                prop = this.getBulkUserErrorMessage(this.domainName, searchString, groupList, error, userName, distinguishedName);
                                CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                if (CREATION_STATUS.equalsIgnoreCase("SEVERE") || customList.isEmpty()) break block81;
                                NativeError customError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), customList, new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                break block81;
                            }
                            for (int i = 0; i < arrayList.size(); ++i) {
                                NativeError error = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)((String)arrayList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), propList, groupList, (Properties)removeProps);
                                prop = this.getBulkUserErrorMessage(this.domainName, searchString, groupList, error, userName, distinguishedName);
                                CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) continue;
                                if (customList.isEmpty()) break;
                                NativeError customError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)((String)arrayList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), customList, new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                break;
                            }
                        }
                        if (objectName.equals("")) {
                            HDTAuditUtil.updateAuditData((Long)object_id, (String)name, (String)"OBJECT_NAME", (DataObject)auditDataObj);
                            objectName = name;
                        }
                        if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) break block78;
                        try {
                            if (props.get("preventDeletion") != null) {
                                Properties grpList = new Properties();
                                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                                    grpList.put("ATTRIB_VALUE", "true");
                                    String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                                    this.updatePreventDeletion(distinguishedName, "add");
                                    if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                                        this.updateParent(rootName);
                                    }
                                } else {
                                    grpList.put("ATTRIB_VALUE", "false");
                                    this.updatePreventDeletion(distinguishedName, "delete");
                                }
                                propList.add(grpList);
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            }
                        }
                        catch (Exception e) {
                            prop.setProperty("CREATION_MESSAGE", e.getMessage());
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        if (this.checkSelected("name") && userName != null && !userName.equals("")) {
                            Properties nameProp;
                            mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + userName + " for the Contact : " + distinguishedName);
                            try {
                                ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)userName, null);
                                name = userName;
                                distinguishedName = StrUtil.updateFullNameToExistingDN((String)distinguishedName, (String)userName);
                                nameProp = new Properties();
                                nameProp.put("ATTRIB_LDAP_NAME", "name");
                                nameProp.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                                nameProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                                nameProp.put("ATTRIB_VALUE", userName);
                                propList.add(nameProp);
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                if (prop.getProperty("CREATION_MESSAGE") == null) {
                                    prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVContactListener.sucessfully_updated_the_contact"));
                                }
                                prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                            }
                            catch (LocalizedException le) {
                                le.printStackTrace();
                                message = new StringBuffer();
                                if (prop.getProperty("CREATION_MESSAGE") != null) {
                                    message.append(prop.getProperty("CREATION_MESSAGE"));
                                    if (message.length() > 0) {
                                        message.append(" , ");
                                    }
                                }
                                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                                prop.setProperty("CREATION_MESSAGE", message.toString());
                                prop.setProperty("CREATION_STATUS", "SEVERE");
                                prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            nameProp = new Properties();
                            nameProp.put("ATTRIB_LDAP_NAME", "name");
                            nameProp.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                            nameProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                            nameProp.put("ATTRIB_VALUE", userName);
                            propList.add(nameProp);
                        }
                        if (this.checkSelected("ouName") && !distinguishedName.equals("")) {
                            String OUName = props.getProperty("OUName");
                            if (OUName != null && !OUName.equals("")) {
                                String newdistinguishedName;
                                String processedOUName;
                                String oldDistinguishedName = null;
                                boolean isCreateNewOUActionAuthorized = false;
                                if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)DelegationUtil.CREATE_OU_ACTION_ID)) {
                                    isCreateNewOUActionAuthorized = true;
                                }
                                if ((processedOUName = MgmtUtil.checkAndCreateParent(this.domainName, OUName, this.loginId, isCreateNewOUActionAuthorized)) != null) {
                                    OUName = processedOUName;
                                } else {
                                    mgmtLog.log(Level.INFO, "Seems given dn format is not valid DN or logged user doesn't have to create new option, so Move to container option might be fail " + isCreateNewOUActionAuthorized);
                                }
                                if (name.equals("")) {
                                    name = StrUtil.getNameFromDN((String)distinguishedName);
                                }
                                if (!distinguishedName.equals(newdistinguishedName = "CN=" + name + "," + OUName)) {
                                    oldDistinguishedName = newdistinguishedName;
                                    try {
                                        mgmtLog.log(Level.INFO, "Move container option selected - SourceDN " + distinguishedName + " Destination DN : " + OUName);
                                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)OUName);
                                        prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                                        prop.setProperty("CREATION_STATUS", "SUCCESS");
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                        ArrayList<String> moveUserAudit = new ArrayList<String>();
                                        if (oldDistinguishedName != null) {
                                            String ouname = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                                            String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + " : </B><br/>" + ouname;
                                            ouname = DirectoryObjectUtil.getOUNameFromDN((String)oldDistinguishedName);
                                            String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + " : </B><br/>" + ouname;
                                            moveUserAudit.add(movedFrom);
                                            moveUserAudit.add(movedTo);
                                        }
                                        if (!moveUserAudit.isEmpty()) {
                                            Properties movedList = new Properties();
                                            movedList.put("ATTRIB_LDAP_NAME", "container");
                                            movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                                            movedList.put("ATTRIB_VALUE", moveUserAudit);
                                            propList.add(movedList);
                                        }
                                    }
                                    catch (LocalizedException le) {
                                        le.printStackTrace();
                                        StringBuffer message2 = new StringBuffer();
                                        if (prop.getProperty("CREATION_MESSAGE") != null) {
                                            message2.append(prop.getProperty("CREATION_MESSAGE"));
                                            if (message2.length() > 0) {
                                                message2.append(" , ");
                                            }
                                        }
                                        message2.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_moving_objects"), le.getMessage(this.rb)));
                                        prop.setProperty("CREATION_MESSAGE", message2.toString());
                                        prop.setProperty("CREATION_STATUS", "SEVERE");
                                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            } else {
                                mgmtLog.log(Level.INFO, "OUName is selected as toBeUpdateAttributeList but value might not be provided in csv file or HDT is not authorized to use this OU");
                                message = new StringBuffer();
                                if (prop.getProperty("CREATION_MESSAGE") != null) {
                                    message.append(prop.getProperty("CREATION_MESSAGE"));
                                    if (message.length() > 0) {
                                        message.append(" , ");
                                    }
                                }
                                message.append(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_unauth_OU"));
                                prop.setProperty("CREATION_MESSAGE", message.toString());
                                prop.setProperty("CREATION_STATUS", "SEVERE");
                                prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                        }
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        prop.setProperty("userName", userName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        prop.setProperty("CREATION_MESSAGE", e.getMessage());
                        prop.setProperty("CREATION_STATUS", "SEVERE");
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                }
                prop.put("USER_INDEX", userIndex);
                if (prop.getProperty("CREATION_MESSAGE") == null) {
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_on_attribute"));
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                if (groupList != null && !groupList.isEmpty()) {
                    Properties grpList = new Properties();
                    grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                    grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                    grpList.put("ATTRIB_VALUE", groupList);
                    propList.add(grpList);
                }
                if (groupList != null && groupList.isEmpty() && removeMemberOf) {
                    Properties grpMemberOfList = new Properties();
                    grpMemberOfList.put("ATTRIB_LDAP_NAME", "memberOf");
                    grpMemberOfList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    grpMemberOfList.put("ATTRIB_VALUE", "");
                    propList.add(grpMemberOfList);
                }
                if (removeProps != null && !removeProps.isEmpty()) {
                    Properties hdtRemoveProps = new Properties();
                    if (removeProps.containsKey("removeMemberOf")) {
                        hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeMemberOf");
                        hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.user_mgmt.grp_attribs.input.remove_frm_grp");
                        ArrayList arrayList = (ArrayList)removeProps.get("removeMemberOf");
                        if (arrayList.contains("true")) {
                            hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeMemberOf").toString());
                        }
                        propList.add(hdtRemoveProps);
                    }
                    hdtRemoveProps = new Properties();
                    if (removeProps.containsKey("removeProxyAddresses")) {
                        hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeProxyAddresses");
                        hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.csv_import.common.text.remove_proxy_addresses");
                        ArrayList arrayList = (ArrayList)removeProps.get("removeProxyAddresses");
                        if (arrayList.contains("true")) {
                            hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeProxyAddresses").toString());
                        }
                        propList.add(hdtRemoveProps);
                    }
                }
                for (Hashtable hashtable2 : customList) {
                    hashtable2.put("ATTRIB_VALUE_COUNT", 1L);
                }
                TechAuditAPI.getInstance().auditContactModification(this.loginId, this.rb.getString("admp.mgmt.csv_imp.mod_contacts.mgmtname.mod_cont_csv"), objectName, this.domainName, propList, null, null, null, customList, prop.getProperty("CREATION_MESSAGE"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                this.addRow(prop);
                break block83;
            }
            prop.setProperty("CREATION_STATUS", "WARNING");
            if (LicenseMgr.getInstance().isFreeEdition() || LicenseMgr.getInstance().isTrailEdition()) {
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
            } else {
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.this_module_is_not_licensed"));
            }
            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
            prop.put("USER_INDEX", userIndex);
            prop.setProperty("userName", userName);
            this.addRow(prop);
        }
        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
        String objectOUName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
        audit_info.put("OUName", objectOUName);
        mgmtLog.log(Level.INFO, "After Contact Updation");
    }
}

