/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.GroupUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CSVGroupListener
extends CSVUserListener {
    public CSVGroupListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList userCreationGroupList) {
        super(loginId, ids, domainVsIds, userCreationGroupList);
    }

    @Override
    public AddUserHandler returnHandler() {
        GroupUserHandler handler = GroupUserHandler.getInstance();
        return handler;
    }

    @Override
    protected String[][] getMessages() {
        String[] messageKeys = new String[]{"heading", "query.string", "message.body", "message.match.criteria", "message.error_occured", "error.no.object", "link.sample"};
        String[] messages = new String[]{this.rb.getString("client.csv.CSVGroupListener.modify_groups_using_CSV"), "(&(objectClass=Group)(objectCategory=group))", this.rb.getString("client.csv.CSVGroupListener.you_can_modify_groups_by_importing_data_from_csv_files"), this.rb.getString("client.csv.CSVGroupListener.match_criteria_for_groups_in_AD"), this.rb.getString("client.csv.CSVGroupListener.show_the_error_occured_groups_only"), this.rb.getString("client.csv.CSVGroupListener.please_select_the_group"), "help/csv-import-management/active-directory-modify-groups.html"};
        String[][] mess = new String[][]{messageKeys, messages};
        return mess;
    }

    @Override
    protected void performADSync() {
        DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"Group"}, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void modifyObject(String defaultNamingContext, Hashtable hashtable, Hashtable customAttributesList, boolean isLicenseExceeded, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Long userIndex = (Long)hashtable.get("USER_INDEX");
        ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
        ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
        ArrayList customList = new ArrayList();
        ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
        ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
        ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
        ArrayList<String> groupList = new ArrayList<String>();
        ArrayList<String> crossForestMembersList = new ArrayList<String>();
        Properties props = new Properties();
        Properties removeProps = new Properties();
        String searchString = "(&(objectClass=Group)(objectCategory=Group)";
        for (int i = 0; i < valuesList.size(); ++i) {
            Hashtable prop = (Hashtable)valuesList.get(i);
            if (this.validSelectedValues != null) {
                for (int k = 0; k < this.validSelectedValues.length; ++k) {
                    String index;
                    String attributeName = (String)prop.get("ATTRIB_LDAP_NAME");
                    if (!attributeName.equals(index = this.validSelectedValues[k])) continue;
                    Object attributeObjVal = prop.get("ATTRIB_VALUE");
                    int relationalType = (Integer)prop.get("RELATIONAL_TYPE");
                    String attributeValue = "";
                    if (relationalType == 1) continue;
                    attributeValue = (String)attributeObjVal;
                    Long dataType = (Long)prop.get("DATA_HANDLER_TYPE");
                    if (dataType == 6L) {
                        attributeValue = attributeValue.toUpperCase();
                    }
                    attributeValue = attributeName.equalsIgnoreCase("objectGUID") ? CSVGroupListener.convertGuidToHexDecimal(attributeValue) : CommonUtil.escapeSpecialCharacters((String)attributeValue);
                    searchString = searchString + "(" + attributeName + "=" + attributeValue + ")";
                }
                continue;
            }
            searchString = searchString + "(" + this.keyLdapName + "=" + this.keyLdapValue + ")";
        }
        searchString = searchString + ")";
        mgmtLog.log(Level.INFO, "SearchString in the Group Updation : " + searchString);
        String objectName = "";
        objectName = this.getObjectName(valuesList);
        this.removeUnAuthorizedProps(valuesList);
        this.getProperties("modify", (ArrayList<Hashtable>)valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, crossForestMembersList, props, "Group");
        String samAccountName = "";
        String distinguishedName = "";
        String fullName = "";
        if (props.get("distinguishedName") != null) {
            distinguishedName = props.getProperty("distinguishedName");
        }
        boolean removeMemberOf = false;
        if (props.get("removeMemberOf") != null && props.getProperty("removeMemberOf").equals("true")) {
            removeMemberOf = true;
        }
        String userName = "";
        if (props.get("userName") != null) {
            userName = props.getProperty("userName");
        }
        String managedBy = "";
        if (props.get("managedBy") != null) {
            managedBy = props.getProperty("managedBy");
        }
        Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
        mgmtLog.log(Level.INFO, "Bulk Group modification Custom Attributes : " + customAttributesList);
        if (nameVsValues != null) {
            Enumeration e = nameVsValues.keys();
            while (e.hasMoreElements()) {
                String attributeName = (String)e.nextElement();
                ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                if (attributeName.equalsIgnoreCase("removeMemberOf")) {
                    removeProps.put("removeMemberOf", this.splitMultiValues(values));
                    continue;
                }
                if (attributeName.equalsIgnoreCase("removeProxyAddresses")) {
                    removeProps.put("removeProxyAddresses", this.splitMultiValues(values));
                    continue;
                }
                if (!this.isClearEmptyValue && values != null && values.size() == 0) continue;
                Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                customTable.put("ATTRIB_LDAP_NAME", attributeName);
                customTable.put("DATA_HANDLER_TYPE", 3L);
                customTable.put("ATTRIB_VALUE_COUNT", 1L);
                boolean bl = false;
                Hashtable attribDetails = this.returnHandler().getAttributeDetailsFromMap("ATTRIB_LDAP_NAME", (Object)attributeName);
                if (attribDetails != null && attribDetails.get("RELATIONAL_TYPE") != null) {
                    boolean bl2 = bl = ((Integer)attribDetails.get("RELATIONAL_TYPE")).compareTo(1) == 0;
                }
                if (this.isAppendMultiValue && bl) {
                    customTable.put("DW_CONTROL_CODE", 3L);
                } else {
                    customTable.put("DW_CONTROL_CODE", 2L);
                }
                if (values != null && values.size() > 1) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Object string : values) {
                        list.add(string.toString().trim());
                    }
                    customTable.put("ATTRIB_VALUE", list);
                    customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                } else if (values != null && values.size() == 1) {
                    customTable.put("ATTRIB_VALUE", values.get(0));
                } else {
                    customTable.put("ATTRIB_VALUE", "");
                    customTable.put("DW_CONTROL_CODE", 1L);
                }
                customList.add(customTable);
            }
        }
        mgmtLog.log(Level.FINE, "replacing.... " + userName);
        userName = CommonUtil.escapeString((String)userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
        mgmtLog.log(Level.FINE, "replaced userName " + userName);
        Hashtable<String, Object> logProps = new Hashtable<String, Object>();
        logProps.put("domainName", this.domainName);
        logProps.put("userName", userName);
        logProps.put("propList", propList);
        logProps.put("modifyList", modifyList);
        logProps.put("winNTAttributeList", winNTAttributeList);
        logProps.put("groupList", groupList);
        logProps.put("crossForestMembersList", crossForestMembersList);
        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (String)objectName, (String)this.domainName, (DataObject)auditDataObj);
        audit_info.put("object_id", object_id);
        audit_info.put("objectName", objectName);
        if (props.get("manager") != null) {
            audit_info.put("manager", managedBy);
        }
        Properties prop = new Properties();
        if (!isLicenseExceeded) {
            block101: {
                try {
                    StringBuffer message;
                    String CREATION_STATUS = "SUCCESS";
                    if (distinguishedName.equals("") || managedBy.equals("") && props.get("managerCanUpdateMembers") != null) {
                        Properties domainDetails;
                        boolean bl;
                        String value;
                        boolean bl3 = false;
                        ArrayList userAttributeList = new ArrayList();
                        userAttributeList.add("distinguishedName");
                        userAttributeList.add("sAMAccountName");
                        userAttributeList.add("managedBy");
                        userAttributeList.add("name");
                        if (removeProps.containsKey("removeProxyAddresses")) {
                            userAttributeList.add("proxyAddresses");
                        }
                        if (removeProps.containsKey("removeMemberOf") && (value = (String)((ArrayList)removeProps.get("removeMemberOf")).get(0)).equalsIgnoreCase("true")) {
                            bl = true;
                            userAttributeList.add("memberOf");
                        }
                        if ((userAttributeList = ADHandler.getObjectsWithOutListener((Properties)(domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId)), (String)defaultNamingContext, userAttributeList, (String)searchString)) != null && userAttributeList.size() > 0) {
                            Properties dnProp = (Properties)userAttributeList.get(0);
                            distinguishedName = StrUtil.getString((Properties)dnProp, (String)"distinguishedName");
                            samAccountName = StrUtil.getString((Properties)dnProp, (String)"sAMAccountName");
                            fullName = StrUtil.getString((Properties)dnProp, (String)"name");
                            if (removeProps.containsKey("removeProxyAddresses")) {
                                this.checkAndRemovePrimaryProxyAddr(removeProps, dnProp);
                            }
                            if (removeProps.containsKey("removeMemberOf") && bl) {
                                this.removeUnAuthorizedGroups(removeProps, dnProp, this.loginId, this.domainName);
                            }
                            if (dnProp.get("managedBy") != null) {
                                ArrayList managedByProps = (ArrayList)dnProp.get("managedBy");
                                Properties managedByProp = (Properties)managedByProps.get(0);
                                if (managedBy.equals("")) {
                                    managedBy = (String)managedByProp.get("distinguishedName");
                                }
                            }
                        } else {
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        }
                    }
                    if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                        if (!this.isAuthorizedGroup(distinguishedName)) {
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("groupmanagement.messages.not_authorized_group"));
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        } else {
                            this.removeUnAuthorizedProps(customList);
                            this.checkRemovePropsSelected(removeProps);
                            if (propList.size() == 0 && groupList.size() == 0 && !removeMemberOf && removeProps != null && !removeProps.isEmpty()) {
                                removeProps.put("HasRemoveProps", (Object)true);
                            }
                            if (removeMemberOf) {
                                removeProps.put("isClearIfEmpty", (Object)removeMemberOf);
                            }
                            if (propList.size() > 0 || groupList.size() > 0 || customList.size() > 0 || removeMemberOf || removeProps.size() > 0) {
                                mgmtLog.log(Level.INFO, "propList after authorize check " + propList);
                                logProps.put("customList", customList);
                                NativeError nativeError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), propList, groupList, (Properties)removeProps);
                                prop = this.getBulkgroupErrorMessage(this.domainName, searchString, groupList, nativeError, userName, distinguishedName);
                                CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                                    NativeError customError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), customList, new ArrayList(), (boolean)false);
                                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                }
                            }
                        }
                    }
                    if (objectName.equals("")) {
                        HDTAuditUtil.updateAuditData((Long)object_id, (String)samAccountName, (String)"OBJECT_NAME", (DataObject)auditDataObj);
                        objectName = samAccountName;
                    }
                    if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) break block101;
                    mgmtLog.log(Level.INFO, "crossForestMembersList " + crossForestMembersList);
                    if (!crossForestMembersList.isEmpty()) {
                        NativeError nativeError = ADHandler.addCrossForestMembers((String)this.domainName, (Long)this.loginId, (String)distinguishedName, crossForestMembersList);
                        String errorMsg = this.getCrossForestErrorMsg(nativeError, distinguishedName, this.rb);
                        if (errorMsg != null) {
                            prop.setProperty("CREATION_STATUS", "WARNING");
                            StringBuilder messageBuilder = new StringBuilder();
                            if (prop.getProperty("CREATION_MESSAGE") != null) {
                                messageBuilder.append(prop.getProperty("CREATION_MESSAGE"));
                            }
                            messageBuilder.append(errorMsg);
                            prop.setProperty("CREATION_MESSAGE", messageBuilder.toString());
                            prop.setProperty("CREATION_IMAGE", "/images/alert.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                        } else {
                            prop.setProperty("CREATION_STATUS", "SUCCESS");
                            if (prop.getProperty("CREATION_MESSAGE") == null) {
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.sucessfully_updated_the_group"));
                            }
                            prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                        }
                    }
                    try {
                        if (props.get("preventDeletion") != null) {
                            Properties properties = new Properties();
                            properties.put("ATTRIB_LDAP_NAME", "preventDeletion");
                            properties.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                            properties.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                                properties.put("ATTRIB_VALUE", "true");
                                String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                                this.updatePreventDeletion(distinguishedName, "add");
                                if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                                    this.updateParent(rootName);
                                }
                            } else {
                                properties.put("ATTRIB_VALUE", "false");
                                this.updatePreventDeletion(distinguishedName, "delete");
                            }
                            propList.add(properties);
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                            prop.setProperty("CREATION_STATUS", "SUCCESS");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                        }
                    }
                    catch (Exception exception) {
                        prop.setProperty("CREATION_MESSAGE", exception.getMessage());
                        prop.setProperty("CREATION_STATUS", "SEVERE");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                    if (this.checkSelected("name") && userName != null && !userName.equals("")) {
                        mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + userName + " for the Group : " + distinguishedName);
                        try {
                            ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)userName, null);
                            fullName = userName;
                            distinguishedName = StrUtil.updateFullNameToExistingDN((String)distinguishedName, (String)fullName);
                            Properties properties = new Properties();
                            properties.put("ATTRIB_LDAP_NAME", "name");
                            properties.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                            properties.put("ATTRIB_VALUE_COUNT", (Object)1L);
                            properties.put("ATTRIB_VALUE", userName);
                            propList.add(properties);
                            if (prop.getProperty("CREATION_MESSAGE") == null) {
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.sucessfully_updated_the_group"));
                                prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                            }
                        }
                        catch (LocalizedException localizedException) {
                            localizedException.printStackTrace();
                            message = new StringBuffer();
                            if (prop.getProperty("CREATION_MESSAGE") != null) {
                                message.append(prop.getProperty("CREATION_MESSAGE"));
                                if (message.length() > 0) {
                                    message.append(" , ");
                                }
                            }
                            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_grps.statmsg.error_modifying_fullname"), localizedException.getMessage(this.rb)));
                            prop.setProperty("CREATION_MESSAGE", message.toString());
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        Properties properties = new Properties();
                        properties.put("ATTRIB_LDAP_NAME", "name");
                        properties.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                        properties.put("ATTRIB_VALUE_COUNT", (Object)1L);
                        properties.put("ATTRIB_VALUE", userName);
                        propList.add(properties);
                    }
                    if (props.get("managerCanUpdateMembers") != null) {
                        String string = (String)props.get("managerCanUpdateMembers");
                        String operation = "delete";
                        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1")) {
                            operation = "add";
                        }
                        if (!managedBy.equals("")) {
                            this.updateManagerCanUpdateMembers(managedBy, distinguishedName, operation);
                            Properties managerProp = new Properties();
                            managerProp.put("ATTRIB_LDAP_NAME", "managerCanUpdateMembers");
                            managerProp.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.managerCanUpdateMembers"));
                            managerProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                            managerProp.put("ATTRIB_VALUE", string);
                            propList.add(managerProp);
                        }
                        if (prop.getProperty("CREATION_MESSAGE") == null) {
                            prop.setProperty("CREATION_STATUS", "SUCCESS");
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.sucessfully_updated_the_group"));
                            prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                        }
                    }
                    if (this.checkSelected("ouName") && !distinguishedName.equals("")) {
                        String string = props.getProperty("OUName");
                        if (string != null && !string.equals("")) {
                            void var31_53;
                            String newdistinguishedName;
                            String processedOUName;
                            String oldDistinguishedName = null;
                            boolean isCreateNewOUActionAuthorized = false;
                            if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)DelegationUtil.CREATE_OU_ACTION_ID)) {
                                isCreateNewOUActionAuthorized = true;
                            }
                            if ((processedOUName = MgmtUtil.checkAndCreateParent(this.domainName, string, this.loginId, isCreateNewOUActionAuthorized)) != null) {
                                String string2 = processedOUName;
                            } else {
                                mgmtLog.log(Level.INFO, "Seems given dn format is not valid DN or logged user doesn't have to create new option, so Move to container option might be fail " + isCreateNewOUActionAuthorized);
                            }
                            if (fullName.equals("")) {
                                fullName = StrUtil.getNameFromDN((String)distinguishedName);
                            }
                            if (!distinguishedName.equals(newdistinguishedName = "CN=" + fullName + "," + (String)var31_53)) {
                                oldDistinguishedName = newdistinguishedName;
                                try {
                                    mgmtLog.log(Level.INFO, "Move container option selected - SourceDN " + distinguishedName + " Destination DN : " + (String)var31_53);
                                    ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)var31_53);
                                    if (prop.getProperty("CREATION_MESSAGE") == null) {
                                        prop.setProperty("CREATION_STATUS", "SUCCESS");
                                        prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.sucessfully_updated_the_group"));
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                                    }
                                    ArrayList<String> moveUserAudit = new ArrayList<String>();
                                    if (oldDistinguishedName != null) {
                                        String ouname = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                                        String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + " : </B><br/>" + ouname;
                                        ouname = DirectoryObjectUtil.getOUNameFromDN((String)oldDistinguishedName);
                                        String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + " : </B><br/>" + ouname;
                                        moveUserAudit.add(movedFrom);
                                        moveUserAudit.add(movedTo);
                                    }
                                    if (!moveUserAudit.isEmpty()) {
                                        Properties movedList = new Properties();
                                        movedList.put("ATTRIB_LDAP_NAME", "container");
                                        movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                                        movedList.put("ATTRIB_VALUE", moveUserAudit);
                                        propList.add(movedList);
                                    }
                                }
                                catch (LocalizedException le) {
                                    le.printStackTrace();
                                    StringBuffer message2 = new StringBuffer();
                                    if (prop.getProperty("CREATION_MESSAGE") != null) {
                                        message2.append(prop.getProperty("CREATION_MESSAGE"));
                                        if (message2.length() > 0) {
                                            message2.append(" , ");
                                        }
                                    }
                                    message2.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_moving_objects"), le.getMessage(this.rb)));
                                    prop.setProperty("CREATION_MESSAGE", message2.toString());
                                    prop.setProperty("CREATION_STATUS", "SEVERE");
                                    prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            mgmtLog.log(Level.INFO, "OUName is selected as toBeUpdateAttributeList but value might not be provided in csv file or HDT is not authorized to use this OU");
                            message = new StringBuffer();
                            if (prop.getProperty("CREATION_MESSAGE") != null) {
                                message.append(prop.getProperty("CREATION_MESSAGE"));
                                if (message.length() > 0) {
                                    message.append(" , ");
                                }
                            }
                            message.append(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_unauth_OU"));
                            prop.setProperty("CREATION_MESSAGE", message.toString());
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                    }
                    mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                    prop.setProperty("userName", userName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    prop.setProperty("CREATION_MESSAGE", e.getMessage());
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
            }
            prop.put("USER_INDEX", userIndex);
            if (prop.getProperty("CREATION_MESSAGE") == null) {
                prop.setProperty("CREATION_STATUS", "SEVERE");
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_on_attribute"));
                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            }
            if (groupList != null && !groupList.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", groupList);
                propList.add(grpList);
            }
            if (groupList != null && groupList.isEmpty() && removeMemberOf) {
                Properties grpMemberOfList = new Properties();
                grpMemberOfList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpMemberOfList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                grpMemberOfList.put("ATTRIB_VALUE", "");
                propList.add(grpMemberOfList);
            }
            if (removeProps != null && !removeProps.isEmpty()) {
                Properties hdtRemoveProps = new Properties();
                if (removeProps.containsKey("removeMemberOf")) {
                    hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeMemberOf");
                    hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.user_mgmt.grp_attribs.input.remove_frm_grp");
                    ArrayList arrayList = (ArrayList)removeProps.get("removeMemberOf");
                    if (arrayList.contains("true")) {
                        hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                    } else {
                        hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeMemberOf").toString());
                    }
                    propList.add(hdtRemoveProps);
                }
                hdtRemoveProps = new Properties();
                if (removeProps.containsKey("removeProxyAddresses")) {
                    hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeProxyAddresses");
                    hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.csv_import.common.text.remove_proxy_addresses");
                    ArrayList arrayList = (ArrayList)removeProps.get("removeProxyAddresses");
                    if (arrayList.contains("true")) {
                        hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                    } else {
                        hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeProxyAddresses").toString());
                    }
                    propList.add(hdtRemoveProps);
                }
            }
            if (!crossForestMembersList.isEmpty()) {
                void var31_57;
                boolean propAdded = false;
                boolean bl = false;
                while (var31_57 < propList.size()) {
                    Hashtable attHash = propList.get((int)var31_57);
                    if (((String)attHash.get("ATTRIB_LDAP_NAME")).equalsIgnoreCase("member")) {
                        ArrayList memberValues = new ArrayList();
                        if (((Long)attHash.get("ATTRIB_VALUE_COUNT")).equals(1L)) {
                            memberValues.add((String)attHash.get("ATTRIB_VALUE"));
                        } else {
                            memberValues = (ArrayList)attHash.get("ATTRIB_VALUE");
                        }
                        memberValues.addAll(crossForestMembersList);
                        attHash.put("ATTRIB_VALUE", memberValues);
                        attHash.put("ATTRIB_VALUE_COUNT", new Long(memberValues.size()));
                        propAdded = true;
                    }
                    ++var31_57;
                }
                if (!propAdded) {
                    Properties properties = new Properties();
                    properties.put("ATTRIB_LDAP_NAME", "member");
                    properties.put("ATTRIB_VALUE_COUNT", new Long(crossForestMembersList.size()));
                    properties.put("ATTRIB_VALUE", crossForestMembersList);
                    propList.add(properties);
                }
            }
            for (Hashtable hashtable2 : customList) {
                hashtable2.put("ATTRIB_VALUE_COUNT", 1L);
            }
            TechAuditAPI.getInstance().auditGroupModification(this.loginId, this.rb.getString("admp.mgmt.csv_imp.mod_grps.mgmtname.mod_grps_csv"), objectName, this.domainName, propList, customList, prop.getProperty("CREATION_MESSAGE"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            this.addRow(prop);
        } else {
            prop.setProperty("CREATION_STATUS", "WARNING");
            if (LicenseMgr.getInstance().isFreeEdition() || LicenseMgr.getInstance().isTrailEdition()) {
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.could_not_update_more_than_100_objects_license_level_exceeded"));
            } else {
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.this_module_is_not_licensed"));
            }
            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
            prop.put("USER_INDEX", userIndex);
            prop.setProperty("userName", userName);
            this.addRow(prop);
        }
        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
        String objectOUName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
        audit_info.put("OUName", objectOUName);
        mgmtLog.log(Level.INFO, "After Group Updation");
    }

    private Properties getBulkgroupErrorMessage(String domainName, String searchString, ArrayList groupList, NativeError errHdlr, String userName, String distinguishedName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        Hashtable errors = errHdlr.getErrors();
        ArrayList<String> errorKeys = new ArrayList<String>();
        if (errors != null) {
            Enumeration e = errors.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                errorKeys.add(key.toLowerCase());
                message = errHdlr.getErrorMessage((Object)key, this.rb);
                errorSeverity = errHdlr.getSeverityLevel((Object)key);
                if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                    statusProps.setProperty("CREATION_STATUS", errorSeverity);
                    statusProps.setProperty("CREATION_MESSAGE", message);
                    statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    return statusProps;
                }
                messageBuilder.append(message);
            }
        }
        for (Object object : groupList) {
            if (errorKeys.contains(object.toString().toLowerCase()) || errHdlr.getErrorMessage(object, this.rb) == null) continue;
            messageBuilder.append(errHdlr.getErrorMessage(object, this.rb));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVGroupListener.sucessfully_updated_the_group"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private void updateManagerCanUpdateMembers(String managerDN, String groupDN, String operation) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        String sid = UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)managerDN), (String)managerDN);
        if (sid != null) {
            everyOneTrusteeList.add(sid);
            ArrayList aceList = new ArrayList();
            Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
            aceHash.put("ACCESS_MASK", 32L);
            aceHash.put("PERMISSION_GUID", "{BF9679C0-0DE6-11D0-A285-00AA003049E2}");
            aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
            aceHash.put("ACE_ID", new Long(1L));
            aceHash.put("ACE_TYPE", 5L);
            aceHash.put("operation", operation);
            aceList.add(aceHash);
            ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)groupDN);
        }
    }

    private boolean isAuthorizedGroup(String distinguishedName) {
        try {
            Properties properties = UserMgmtUtil.getPropertiesfromDN((String)distinguishedName, (ArrayList)this.userCreationGroupList);
            return properties != null && properties.get("Distinguished_Name") != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

