/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ComputerUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.GroupUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.OUUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserBean;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.JRArrayList;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ListUserDataProvider;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.CustomAttribUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class CSVUserAction
extends DispatchAction {
    Logger out = Logger.getLogger("ADMangLogger");
    private static String USER_ATTRIBUTE_TABLE = "ADSMAUNamingAttributes";
    private static Integer REMOVE_MEMBER_OF_ATTRIB_ID = 1197;

    public ActionForward bulkUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(this.bulkUser(form, request, response, AddUserHandler.getInstance()));
    }

    public String bulkUser(ActionForm form, HttpServletRequest request, HttpServletResponse response, AddUserHandler userHandler) {
        String forward = "bulkUser";
        try {
            CSVUserBean bean = (CSVUserBean)form;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long count1 = (Long)bean.get("ImportCount");
            String init = request.getParameter("init");
            if (init != null && init.equals("true")) {
                bean.init(request);
            }
            if (request.getAttribute("actionId") != null && !ClientAuthorizationUtil.isAuthorized(request, (Long)request.getAttribute("actionId")).booleanValue()) {
                return null;
            }
            String operation = (String)bean.get("operation");
            this.checkAndSetSelectAllObjectUsers(request, bean);
            String isNavigate = request.getParameter("isNavigate");
            if (isNavigate != null && isNavigate.equals("false")) {
                bean.setRange(loginId);
            }
            Long startIndex = (Long)bean.get("FROM_INDEX");
            Long count = null;
            if (operation.equals("Remove")) {
                this.deleteUser(bean);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
            } else if (operation.equals("Update AD")) {
                bean.modifyUser(request);
                bean.set("FROM_INDEX", new Long(1L));
                CSVUserListener listener = (CSVUserListener)bean.getListener();
                if (!listener.isCompleted()) {
                    request.setAttribute("listener", (Object)listener);
                }
                ArrayList userDetailsList = (ArrayList)request.getAttribute("userDetailsList");
                count = new Long(userDetailsList.size());
                forward = "modifyResult";
            } else if (operation.equals("ShowResult")) {
                Criteria crit = bean.getUserOperationCriteria();
                ArrayList userDetailsList = userHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), ((Integer)bean.get("RANGE")).intValue(), crit);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID"), crit).intValue());
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("Stop")) {
                Criteria crit = bean.getUserOperationCriteria();
                CSVUserListener listener = (CSVUserListener)bean.getListener();
                if (!listener.isCompleted()) {
                    listener.stop();
                }
                ArrayList userDetailsList = userHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), ((Integer)bean.get("RANGE")).intValue(), crit);
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID"), crit).intValue());
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("ReCreate")) {
                bean.reCreateList(request);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
            } else {
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
            }
            request.setAttribute("totalCount", (Object)count1);
            request.setAttribute("count", (Object)count);
            request.setAttribute("domainList", (Object)HDTDomainHandler.getConfiguredList((Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forward;
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Integer actionId;
            CSVUserBean userBean = (CSVUserBean)form;
            ContactUserHandler handler = null;
            String action = "";
            String objectClass = (String)userBean.get("objectClass");
            if (objectClass != null && objectClass.equalsIgnoreCase("CSVContactListener")) {
                handler = ContactUserHandler.getInstance();
                action = "jsp.UserManagement.UseAdmin.bulk_contact_modification";
                actionId = ReportsUtil.BULK_CONTACT_MODIFICATION_REPORT_ID;
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVGroupListener")) {
                handler = GroupUserHandler.getInstance();
                action = "jsp.UserManagement.UseAdmin.bulk_group_modification";
                actionId = ReportsUtil.BULK_GROUP_MODIFICATION_REPORT_ID;
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVComputerListener")) {
                handler = ComputerUserHandler.getInstance();
                action = "admp.mgmt.comp_mgmt.mgmtname.bulk_comp_modification";
                actionId = ReportsUtil.BULK_COMPUTER_MODIFICATION_REPORT_ID;
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVOUListener")) {
                handler = OUUserHandler.getInstance();
                action = "admp.deleg.hdt_deleg.cre_role.action_name.bulk_ou_modify";
                actionId = ReportsUtil.BULK_OU_MODIFICATION_REPORT_ID;
            } else {
                handler = AddUserHandler.getInstance();
                action = "admp.deleg.hdt_deleg.cre_role.action_name.bulk_user_modify";
                actionId = ReportsUtil.BULK_USER_MODIFICATION_REPORT_ID;
            }
            HttpSession session = request.getSession();
            String sessionID = session.getId();
            String domainName = (String)userBean.get("domainName");
            Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Users," + defaultNamingContext;
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            Long userCreationID = handler.addNewUserList(sessionID, domainName, containerName, null, loginId);
            userBean.set("userCreationID", userCreationID);
            ArrayList customAttributesList = new ArrayList();
            request.setAttribute("isModification", (Object)"true");
            userBean.set("isModification", "true");
            FormFile formFile = (FormFile)userBean.get("browse");
            ArrayList userDetailsList = this.csvImport(request, userBean, (AddUserHandler)handler, customAttributesList);
            if (userDetailsList != null) {
                ArrayList attributeList = (ArrayList)userBean.get("attributeList");
                if (!userDetailsList.isEmpty()) {
                    handler.addUserDetailsList(userCreationID, userDetailsList, attributeList, customAttributesList);
                }
                Integer count = handler.getCount(userCreationID);
                request.setAttribute("count", (Object)new Long(count.intValue()));
                userBean.set("ImportCount", new Long(count.intValue()));
                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)action, (Integer)actionId, (String)"-", (Boolean)Boolean.TRUE, (String)formFile.getFileName(), (String)"csv", (String)"-", (Integer)count);
                }
            }
        }
        catch (DataAccessException dAE) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.groups.CSVGroupAction.db_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
            dAE.printStackTrace();
        }
        catch (Exception e) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.csv.CSVUserAction.unknown_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
            e.printStackTrace();
        }
        return mapping.findForward("bulkUser");
    }

    public ActionForward getUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList attributeList;
            HttpSession session = request.getSession();
            CSVUserBean bean = (CSVUserBean)form;
            String operation = (String)bean.get("operation");
            if (operation.equals("UpdateColumns")) {
                bean.updateColumns(request);
            }
            if ((attributeList = (ArrayList)bean.get("attributeList")) == null) {
                attributeList = new ArrayList();
            }
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList((Long)bean.get("userCreationID"), attributeList, (int)startIndex.longValue(), range.intValue(), null);
            int attribSize = 0;
            attribSize = attributeList.size();
            request.setAttribute("attribSize", (Object)attribSize);
            request.setAttribute("userDetailsList", (Object)userDetailsList);
            request.setAttribute("customAttributes", (Object)AddUserHandler.getInstance().getCustomAttributesList((Long)bean.get("userCreationID")));
            if (userDetailsList.isEmpty()) {
                request.setAttribute("listEmpty", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("userDetails");
    }

    public ActionForward modifyAttribute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        CSVUserBean userBean = (CSVUserBean)form;
        try {
            String index = request.getParameter("index");
            String attribute = request.getParameter("attribute");
            String value = request.getParameter("value");
            ArrayList attributeList = (ArrayList)userBean.get("attributeList");
            Hashtable attributeDetails = AddUserHandler.getInstance().getAttributeDetails(attribute, attributeList);
            String tableName = (String)attributeDetails.get("AU_TABLE_NAME");
            String ldapName = (String)attributeDetails.get("ATTRIB_LDAP_NAME");
            Long actionId = (Long)attributeDetails.get("MODIFY_ID");
            HttpSession session = request.getSession();
            String domainName = (String)userBean.get("domainName");
            if (actionId == null || userBean.checkAuthorization(request, ldapName, actionId, domainName)) {
                Long longIndex = new Long(index);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)longIndex, 0);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn(attribute, (Object)value);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
            }
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        if (saveFlag) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ArrayList csvImport(HttpServletRequest request, CSVUserBean userBean, AddUserHandler userHandler, ArrayList customAttributesList) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList userDetailsList = new ArrayList();
        try {
            FormFile formFile = (FormFile)userBean.get("browse");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String fileName = formFile.getFileName();
            Boolean header = true;
            InputStream stream = null;
            Integer headerSize = 0;
            Vector valuesVector = new Vector();
            StringBuilder message = new StringBuilder();
            if (fileName != null) {
                try {
                    stream = formFile.getInputStream();
                }
                catch (Exception e) {
                    message.append(e.getMessage());
                    request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)message.toString()));
                    return null;
                }
            }
            String fileEncoding = request.getParameter("fileEncoding");
            CSVReader csvReader = new CSVReader(stream, fileEncoding, rb);
            ArrayList<Vector> list = new ArrayList<Vector>();
            Vector headerVector = new Vector();
            try {
                headerVector = csvReader.getAllFieldsInLine();
                headerSize = headerVector.size();
            }
            catch (Exception headerVectorException) {
                if (headerVectorException instanceof EOFException) {
                    csvReader.close();
                }
                csvReader.close();
                request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.open_csv_in_notepad_and_save_in_correct_format")));
                return null;
            }
            if (headerVector.isEmpty() || headerSize == 1 && headerVector.get(0).toString().equals("")) {
                request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.empty_file_provide_ldap_attrib_values_separate_rows")));
                return null;
            }
            try {
                while (true) {
                    if ((valuesVector = csvReader.getAllFieldsInLine()).size() != headerSize.intValue()) {
                        csvReader.close();
                        JSONObject errorString = new JSONObject();
                        errorString.put("errorMsg", (Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal"));
                        errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal_reasons"));
                        request.setAttribute("importErrorMessage", (Object)errorString);
                        return null;
                    }
                    list.add(valuesVector);
                }
            }
            catch (Exception valuesVectorException) {
                JSONObject statusObject;
                if (!(valuesVectorException instanceof EOFException)) {
                    int fieldIndex = csvReader.getFieldIndex();
                    JSONObject errorDetailsObj = new JSONObject();
                    if (fieldIndex >= headerSize) {
                        errorDetailsObj.put("errorMsg", (Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal"));
                        errorDetailsObj.put("errorInfo", (Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal_reasons"));
                    } else {
                        String errorMessage = MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.incorrect_format_specified_for_attribute"), (String)headerVector.get(fieldIndex), csvReader.getLineCount());
                        errorDetailsObj.put("errorMsg", (Object)errorMessage);
                        errorDetailsObj.put("errorInfo", (Object)valuesVectorException.getMessage());
                    }
                    csvReader.close();
                    request.setAttribute("importErrorMessage", (Object)errorDetailsObj);
                    return null;
                }
                csvReader.close();
                if (list.isEmpty()) {
                    request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.one_row_available_provide_both_ldap_attrib_header_values_in_consecutive_rows")));
                    return null;
                }
                ArrayList attributeList = (ArrayList)userBean.get("attributeList");
                attributeList = new ArrayList();
                ArrayList configuredCustomAttrList = new ArrayList();
                ArrayList<String> customAttributeNames = new ArrayList<String>();
                ArrayList cMAList = new ArrayList();
                String objectClass = (String)userBean.get("objectClass");
                Vector tempHeaderVector = (Vector)headerVector.clone();
                Collections.sort(tempHeaderVector, new ObjectEqualsComparision());
                if (objectClass != null && objectClass.equalsIgnoreCase("CSVGroupListener")) {
                    if (Collections.binarySearch(tempHeaderVector, "groupType", new ObjectEqualsComparision()) < 0) {
                        userBean.set("isGroupType", "true");
                    } else {
                        userBean.set("isGroupType", "false");
                    }
                    if (Collections.binarySearch(tempHeaderVector, "managerCanUpdateMembers", new ObjectEqualsComparision()) >= 0 && "true".equals((String)request.getAttribute("isCreation")) && Collections.binarySearch(tempHeaderVector, "managedBy", new ObjectEqualsComparision()) < 0) {
                        message = new StringBuilder();
                        message.append(rb.getString("client.csv.CSVUserAction.managerCanUpdateMembers_no_manager_error"));
                        request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)message.toString()));
                        return null;
                    }
                }
                if (Collections.binarySearch(tempHeaderVector, "OUName", new ObjectEqualsComparision()) < 0) {
                    userBean.set("containsOU", "false");
                } else {
                    userBean.set("containsOU", "true");
                }
                Set extendedLdapList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_LDAP_NAME");
                if (headerVector != null) {
                    ArrayList unAuthorizedAttributeList = new ArrayList();
                    unAuthorizedAttributeList = this.checkAuthorization(request, userBean, userHandler, headerVector, attributeList, customAttributeNames, configuredCustomAttrList, cMAList);
                    if (request.getAttribute("importErrorMessage") != null) {
                        return null;
                    }
                    if (!unAuthorizedAttributeList.isEmpty()) {
                        message = new StringBuilder();
                        message.append(rb.getString("client.csv.CSVUserAction.the_following_attributes") + " ");
                        ArrayList l = null;
                        String str = " " + rb.getString("client.csv.CSVUserAction.in_the_header_is_are_not_authorized_for_this_user");
                        l = unAuthorizedAttributeList;
                        for (Object object : l) {
                            if (l.indexOf(object) != 0) {
                                message.append(", ");
                            }
                            message.append(object);
                        }
                        message.append(str);
                        request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)message.toString()));
                        return null;
                    }
                }
                if ((statusObject = FcLayoutAuth.convertNameToDN(list, (Vector)headerVector, (String)((String)userBean.get("domainName")), (Long)loginId)) == null || statusObject.length() == 0) {
                    JSONObject errorString = new JSONObject();
                    errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_dn_format_or_samaccountname"), new Object[0]));
                    errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return null;
                }
                if (statusObject.has("ERROR_KEY")) {
                    JSONObject errorString = new JSONObject();
                    Object[] params = (Object[])statusObject.get("ERROR_KEY_PARAMS");
                    errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString(statusObject.getString("ERROR_KEY")), params));
                    errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return null;
                }
                JSONObject duplicateStatus = new JSONObject();
                if (FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf") != -1 && FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeMemberOf") != -1) {
                    duplicateStatus = FcLayoutAuth.checkForDuplicates(list, (Vector)headerVector, (String)"memberOf", (String)"removeMemberOf", (boolean)true);
                }
                if (duplicateStatus.has("ERROR_LINE")) {
                    JSONObject errorString = new JSONObject();
                    int errorLine = (Integer)duplicateStatus.get("ERROR_LINE");
                    Object[] params = new Object[]{errorLine, "memberOf"};
                    errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.add_remove_same_value"), params));
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return null;
                }
                if (FcExecuteFormFlow.getLdapNameIndex(headerVector, "proxyAddresses") != -1 && FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeProxyAddresses") != -1) {
                    duplicateStatus = FcLayoutAuth.checkForDuplicates(list, (Vector)headerVector, (String)"proxyAddresses", (String)"removeProxyAddresses", (boolean)true);
                }
                if (duplicateStatus.has("ERROR_LINE")) {
                    JSONObject errorString = new JSONObject();
                    int errorLine = (Integer)duplicateStatus.get("ERROR_LINE");
                    Object[] params = new Object[]{errorLine, "proxyAddresses"};
                    errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.add_remove_same_value"), params));
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return null;
                }
                String[] dnFormatAttributes = new String[]{"ouName", "member"};
                for (int i = 0; i < dnFormatAttributes.length; ++i) {
                    int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, dnFormatAttributes[i]);
                    if (index == -1) continue;
                    try {
                        Hashtable nonDNValues = new Hashtable();
                        Hashtable memberOfDNPositions = new Hashtable();
                        boolean isMemberOf = false;
                        for (Vector vector : list) {
                            String value = vector.get(index).toString();
                            if (!dnFormatAttributes[i].equalsIgnoreCase("member")) {
                                if (dnFormatAttributes[i].equalsIgnoreCase("ouName") && value.equals("") && (request.getAttribute("isModification") == null || !((String)request.getAttribute("isModification")).equals("true"))) {
                                    JSONObject errorString = new JSONObject();
                                    errorString.put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.creation.ouname_empty"));
                                    request.setAttribute("importErrorMessage", (Object)errorString);
                                    return null;
                                }
                                LdapName ldap = new LdapName(value);
                                continue;
                            }
                            String[] multiValuesArray = FcLayoutUtil.getMultiValuesFromCSV((String)value);
                            for (int j = 0; j < multiValuesArray.length; ++j) {
                                String groupDN = multiValuesArray[j];
                                groupDN = groupDN.replaceAll("(^\"+)|(\"+$)", "");
                                LdapName ldap = new LdapName(groupDN);
                            }
                        }
                        continue;
                    }
                    catch (InvalidNameException e) {
                        JSONObject errorString = new JSONObject();
                        errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_dn_format"), dnFormatAttributes[i]));
                        errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                        request.setAttribute("importErrorMessage", (Object)errorString);
                        return null;
                    }
                    catch (Exception e) {
                        request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                        return null;
                    }
                }
                String[] checkBoxAttributes = new String[]{"preventDeletion"};
                for (int i = 0; i < checkBoxAttributes.length; ++i) {
                    int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, checkBoxAttributes[i]);
                    if (index == -1) continue;
                    for (Vector vector : list) {
                        String value = vector.get(index).toString();
                        boolean flag = false;
                        try {
                            if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false")) continue;
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.automation.robo.error_code.incorrect_prevent_deletion")));
                            return null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                            return null;
                        }
                    }
                }
                String[] longFormatAttributes = new String[]{"accountExpires"};
                for (int i = 0; i < longFormatAttributes.length; ++i) {
                    int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, longFormatAttributes[i]);
                    if (index == -1) continue;
                    for (Vector vector : list) {
                        String value = vector.get(index).toString();
                        boolean flag = false;
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
                            Date date = dateFormat.parse(value);
                            long systemTime = DateTimeUtil.getFileTimeFromSystemTime((Long)date.getTime());
                            vector.set(index, systemTime);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                            flag = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                            return null;
                        }
                        if (!flag) continue;
                        try {
                            Long.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            JSONObject errorString = new JSONObject();
                            errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_long_format"), longFormatAttributes[i]));
                            errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.long_value_example"));
                            request.setAttribute("importErrorMessage", (Object)errorString);
                            return null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                            return null;
                        }
                    }
                }
                String[] boolAttributes = new String[]{"msNPAllowDialin"};
                for (int i = 0; i < boolAttributes.length; ++i) {
                    int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, boolAttributes[i]);
                    if (index == -1) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        Vector vector = list.get(j);
                        String value = vector.get(index).toString();
                        try {
                            if (value.equals("")) continue;
                            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                vector.set(index, value.toUpperCase());
                                continue;
                            }
                            if (value.equals("-1")) {
                                vector.set(index, "");
                                continue;
                            }
                            if (value.equals("0")) {
                                vector.set(index, "FALSE");
                                continue;
                            }
                            if (value.equals("1")) {
                                vector.set(index, "TRUE");
                                continue;
                            }
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.incorrect_format_specified_for_attribute"), (String)headerVector.get(index), String.valueOf(j + 1))));
                            return null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                            return null;
                        }
                    }
                }
                String domainName = (String)userBean.get("domainName");
                if (!this.isAuthorizedMemberOf(headerVector, list, request, domainName, rb)) {
                    return null;
                }
                if (!this.isAuthorizedMember(headerVector, list, request, domainName, rb)) {
                    return null;
                }
                if (!this.isAuthorizedUser(headerVector, list, request, domainName, loginId, rb)) {
                    return null;
                }
                if (!this.isAuthorizedOUName(headerVector, list, request, domainName, loginId, rb)) {
                    return null;
                }
                if (!this.isAuthorizedMemberOf(headerVector, list, request, domainName, rb, true)) {
                    return null;
                }
                userBean.set("attributeList", attributeList);
                userBean.set("customAttributeList", customAttributeNames);
                userBean.initAttributeLists();
                ArrayList customDateAttributes = CustomAttribUtil.getFieldLdapNames("DATETIME");
                for (Vector vector : list) {
                    try {
                        Hashtable userDetails = new Hashtable();
                        ArrayList arrayList = new ArrayList();
                        for (int i = 0; i < vector.size(); ++i) {
                            Integer relationalType;
                            String ldapName;
                            Object object = vector.get(i);
                            String headerObject = (String)headerVector.get(i);
                            if (customAttributeNames.contains(headerObject)) {
                                String str = (String)object;
                                str.trim();
                                Properties properties = new Properties();
                                properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                                properties.setProperty("CUSTOM_ATTRIB_VALUE", str);
                                arrayList.add(properties);
                                continue;
                            }
                            boolean isNotAdded = true;
                            for (Hashtable hashtable : attributeList) {
                                ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                                relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                                int attribId = (Integer)hashtable.get("ATTRIB_ID");
                                Long dataHandlerType = (Long)hashtable.get("DATA_HANDLER_TYPE");
                                if (extendedLdapList.contains(headerObject) && !ExtendedAttributesUtil.isAuthorizedValue(request, headerObject, object, "MODIFY_ID", userBean.get("domainName").toString())) {
                                    String str = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attribute_have_restricted_permission"), headerObject);
                                    request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)str));
                                    return null;
                                }
                                if (customDateAttributes != null && userHandler.isCustomAttribute(Integer.valueOf(attribId)) && ldapName.equalsIgnoreCase(headerObject)) {
                                    for (String attrib : customDateAttributes) {
                                        JSONObject errorString;
                                        if (!attrib.equalsIgnoreCase(headerObject)) continue;
                                        long systemTime = 0L;
                                        String value = object.toString();
                                        if (value == null || value.equals("")) continue;
                                        boolean flag = false;
                                        try {
                                            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
                                            dateFormat.setTimeZone(TimeZone.getTimeZone((String)DateTimeUtil.getDateTimeFormats((Long)loginId).get("timeZone")));
                                            Date date = dateFormat.parse(value);
                                            systemTime = DateTimeUtil.getFileTime((Long)date.getTime());
                                            object = Long.toString(systemTime);
                                        }
                                        catch (ParseException e) {
                                            e.printStackTrace();
                                            flag = true;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            errorString = new JSONObject();
                                            errorString.put("errorMsg", (Object)e.getMessage());
                                            errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.long_value_custom_date_format"));
                                            request.setAttribute("importErrorMessage", (Object)errorString);
                                            return null;
                                        }
                                        if (!flag) continue;
                                        try {
                                            Long.valueOf(value);
                                        }
                                        catch (NumberFormatException e) {
                                            e.printStackTrace();
                                            errorString = new JSONObject();
                                            errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_long_format"), attrib));
                                            errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.long_value_custom_example"));
                                            request.setAttribute("importErrorMessage", (Object)errorString);
                                            return null;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                                            return null;
                                        }
                                    }
                                }
                                if (relationalType == 1) {
                                    String[] multiValuesArray;
                                    ArrayList<String> l = new ArrayList<String>();
                                    String str = String.valueOf(object);
                                    for (String string : multiValuesArray = str.split("(?<!\\\\);")) {
                                        l.add(string);
                                    }
                                    if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                    userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), l);
                                    isNotAdded = false;
                                    continue;
                                }
                                if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                if (dataHandlerType == 9L) {
                                    String userValue = object.toString().toUpperCase();
                                    if (userValue != null && userValue.contains("Z") && userValue.indexOf("Z") == userValue.length() - 1) {
                                        try {
                                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.S");
                                            Date date = dateFormat.parse(userValue.replace("Z", ""));
                                            SimpleDateFormat ldapSearchDateFormat = new SimpleDateFormat("yyMMddHHmmss");
                                            object = ldapSearchDateFormat.format(date) + "Z";
                                        }
                                        catch (ParseException pe) {
                                            pe.printStackTrace();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            JSONObject errorString = new JSONObject();
                                            errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_long_format"), headerObject));
                                            errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.long_value_custom_example"));
                                            request.setAttribute("importErrorMessage", (Object)errorString);
                                            return null;
                                        }
                                    } else if (userValue != null) {
                                        try {
                                            Long longValue = Long.valueOf(userValue);
                                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
                                            object = dateFormat.format(new Date(DateTimeUtil.getSystemTimeFromFileTime((Long)longValue))) + "Z";
                                        }
                                        catch (NumberFormatException pe) {
                                            pe.printStackTrace();
                                            JSONObject errorString = new JSONObject();
                                            errorString.put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_long_format"), headerObject));
                                            errorString.put("errorInfo", (Object)rb.getString("admp.mgmt.csv_import.common.text.long_value_custom_example"));
                                            request.setAttribute("importErrorMessage", (Object)errorString);
                                            return null;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)e.getMessage()));
                                            return null;
                                        }
                                    }
                                }
                                userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                                isNotAdded = false;
                            }
                            if (!isNotAdded) continue;
                            for (Hashtable hashtable : cMAList) {
                                String[] multiValuesArray;
                                ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                                relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                                if (relationalType != 1) continue;
                                ArrayList<String> l = new ArrayList<String>();
                                String str = (String)object;
                                for (String string : multiValuesArray = str.split("(?<!\\\\);")) {
                                    l.add(string);
                                }
                                if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                                ht.put("CUSTOM_ATTRIB_NAME", headerObject);
                                ht.put("CUSTOM_ATTRIB_VALUE", l);
                                arrayList.add(ht);
                            }
                        }
                        if (userDetails.size() > 0) {
                            userDetailsList.add(userDetails);
                        }
                        if (customAttributesList == null) continue;
                        customAttributesList.add(arrayList);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Integer vectorIndex = list.indexOf(vector);
                        Integer vectorSize = vector.size();
                        vectorIndex = header != false ? Integer.valueOf(vectorIndex + 2) : Integer.valueOf(vectorIndex + 1);
                        request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.valus_are_found_against_header"), new Integer(vectorIndex), new Integer(vectorSize), new Integer(headerSize))));
                        return null;
                    }
                }
                for (Hashtable hashtable : cMAList) {
                    String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    customAttributeNames.add(ldapName);
                }
                if (userDetailsList.isEmpty()) {
                    request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.provided_ldap_attrib_not_match_with_object_ldap_names")));
                    return null;
                }
            }
        }
        catch (Exception exception) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.check_imported_file")));
            exception.printStackTrace();
            return null;
        }
        return userDetailsList;
    }

    public ArrayList checkAuthorization(HttpServletRequest request, CSVUserBean userBean, AddUserHandler userHandler, Vector headerVector, ArrayList attributeList, ArrayList customAttributeNames) throws Exception {
        return this.checkAuthorization(request, userBean, userHandler, headerVector, attributeList, customAttributeNames, null, null);
    }

    public ArrayList checkAuthorization(HttpServletRequest request, CSVUserBean userBean, AddUserHandler userHandler, Vector headerVector, ArrayList attributeList, ArrayList customAttributeNames, ArrayList configuredCustomAttrList, ArrayList cMAList) throws Exception {
        Locale locale = request.getLocale();
        String operation = request.getParameter("csvImportFor") != null ? request.getParameter("csvImportFor") : "creation";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList unAuthorizedAttributeList = new ArrayList();
        Set extendedLdapList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_LDAP_NAME");
        String domainName = (String)userBean.get("domainName");
        for (Object object : headerVector) {
            if (object.toString() == "") {
                request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.csv.CSVUserAction.an_empty_header_is_detected_please_remove_the_empty_header_and_import_again")));
                return null;
            }
            Hashtable attributesdetails = userHandler.getAttributeDetails("ATTRIB_LDAP_NAME", object);
            if (!attributesdetails.isEmpty() && !REMOVE_MEMBER_OF_ATTRIB_ID.equals((Integer)attributesdetails.get("ATTRIB_ID"))) {
                Long authActionId = null;
                Integer attribId = (Integer)attributesdetails.get("ATTRIB_ID");
                String ldapName = (String)attributesdetails.get("ATTRIB_LDAP_NAME");
                authActionId = request.getAttribute("isModification") != null && ((String)request.getAttribute("isModification")).equals("true") ? (Long)attributesdetails.get("MODIFY_ID") : (Long)attributesdetails.get("ACTION_ID");
                if (authActionId != null && !userBean.checkAuthorization(request, ldapName, authActionId, domainName)) {
                    unAuthorizedAttributeList.add(object);
                    continue;
                }
                if (extendedLdapList.contains(ldapName)) {
                    if (!ExtendedAttributesUtil.isAuthorized(request, ldapName, "MODIFY_ID", domainName)) {
                        unAuthorizedAttributeList.add(object);
                        continue;
                    }
                    if (attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    continue;
                }
                if (!userHandler.isCustomAttribute(attribId)) {
                    if (attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    continue;
                }
                if (userHandler.isCustomAttribute(attribId) && !userHandler.isCustomMultiValueAttribute(attribId, ldapName, operation)) {
                    if (attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    continue;
                }
                if (cMAList != null && userHandler.isCustomMultiValueAttribute(attribId, ldapName, operation)) {
                    if (cMAList.contains(attributesdetails)) continue;
                    cMAList.add(attributesdetails);
                    continue;
                }
                customAttributeNames.add(object);
                configuredCustomAttrList.add(object);
                continue;
            }
            if (object.toString().equalsIgnoreCase("removeMemberOf")) {
                String objectClass = (String)userBean.get("objectClass");
                if (objectClass.equalsIgnoreCase("CSVOUListener")) {
                    unAuthorizedAttributeList.add(object);
                    continue;
                }
                Object authActionId = null;
                Boolean isRemAuthorized = false;
                boolean isModify = request.getAttribute("isModification") != null && ((String)request.getAttribute("isModification")).equals("true");
                switch (objectClass) {
                    case "CSVGroupListener": {
                        if (isModify) {
                            isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1099L);
                            break;
                        }
                        isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)5610L);
                        break;
                    }
                    case "CSVComputerListener": {
                        if (isModify) {
                            isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1702L);
                            break;
                        }
                        isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)6007L);
                        break;
                    }
                    case "CSVContactListener": {
                        if (isModify) {
                            isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)5138L);
                            break;
                        }
                        isRemAuthorized = ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)5051L);
                        break;
                    }
                    case "CSVUserListener": {
                        isRemAuthorized = isModify ? ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1234L) : ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1433L);
                    }
                }
                if (!isRemAuthorized.booleanValue()) {
                    unAuthorizedAttributeList.add(object);
                    continue;
                }
                if (customAttributeNames.contains(object)) continue;
                customAttributeNames.add(object);
                continue;
            }
            if (customAttributeNames.contains(object)) continue;
            customAttributeNames.add(object);
        }
        return unAuthorizedAttributeList;
    }

    public boolean isAuthorizedMemberOf(Vector headerVector, ArrayList<Vector> list, HttpServletRequest request, String domainName, AdventNetResourceBundle rb) {
        return this.isAuthorizedMemberOf(headerVector, list, request, domainName, rb, false);
    }

    public boolean isAuthorizedMemberOf(Vector headerVector, ArrayList<Vector> list, HttpServletRequest request, String domainName, AdventNetResourceBundle rb, boolean isRemoveAttr) {
        try {
            HttpSession session;
            Long loginId;
            JSONObject groupAuthorizationDetails;
            boolean isAllGroupsAuthorized;
            int memberOfHeaderIndex = -1;
            memberOfHeaderIndex = isRemoveAttr ? FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeMemberOf") : FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf");
            if (memberOfHeaderIndex != -1 && !(isAllGroupsAuthorized = (groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)memberOfHeaderIndex, list, (Long)(loginId = (Long)(session = request.getSession()).getAttribute("ADMP_SESSION_LOGIN_ID")), (String)domainName, (boolean)false, (boolean)isRemoveAttr)).getBoolean("isAllGroupsAuthorized"))) {
                JSONObject errorString = new JSONObject();
                String groupName = groupAuthorizationDetails.getString("groupName");
                int rowIndex = groupAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName, rowIndex);
                errorString.put("errorMsg", (Object)error);
                request.setAttribute("importErrorMessage", (Object)errorString);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean isAuthorizedMember(Vector headerVector, ArrayList<Vector> list, HttpServletRequest request, String domainName, AdventNetResourceBundle rb) {
        int memberHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "member");
        try {
            JSONObject memberAuthorizationDetails;
            boolean isAllMembersAuthorized;
            if (memberHeaderIndex != -1 && !(isAllMembersAuthorized = (memberAuthorizationDetails = FcLayoutAuth.isAuthorizedMember((int)memberHeaderIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), (boolean)false, null)).getBoolean("isAllMembersAuthorized"))) {
                JSONObject errorString = new JSONObject();
                String memberName = memberAuthorizationDetails.getString("memberName");
                int rowIndex = memberAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.member_name_is_not_authorized"), memberName, rowIndex);
                errorString.put("errorMsg", (Object)error);
                request.setAttribute("importErrorMessage", (Object)errorString);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean isAuthorizedUser(Vector headerVector, ArrayList<Vector> list, HttpServletRequest request, String domainName, Long loginId, AdventNetResourceBundle rb) {
        try {
            JSONObject managedByAuthorizationDetails;
            boolean isAuthorized;
            int managedByIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "managedBy");
            if (managedByIndex != -1 && !(isAuthorized = (managedByAuthorizationDetails = FcLayoutAuth.isAuthorizedMember((int)managedByIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), (boolean)false, (Long)loginId)).getBoolean("isAllMembersAuthorized"))) {
                JSONObject errorString = new JSONObject();
                String memberName = managedByAuthorizationDetails.getString("memberName");
                int rowIndex = managedByAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.managedBy_name_is_not_authorized"), memberName, rowIndex);
                errorString.put("errorMsg", (Object)error);
                request.setAttribute("importErrorMessage", (Object)errorString);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] csvHeaders = new String[]{"manager", "authOrig", "unauthOrig", "altRecipient", "publicDelegates"};
        try {
            Hashtable domainOUList = new Hashtable();
            for (int headers = 0; headers < csvHeaders.length; ++headers) {
                int managerHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, csvHeaders[headers]);
                if (managerHeaderIndex == -1) continue;
                if (csvHeaders[headers].equalsIgnoreCase("authOrig") || csvHeaders[headers].equalsIgnoreCase("unauthOrig")) {
                    JSONObject objectAuthorizationDetails = FcLayoutAuth.isAuthorizedMember((int)managerHeaderIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), (boolean)false, (Long)loginId);
                    boolean isAllObjectsAuthorized = objectAuthorizationDetails.getBoolean("isAllMembersAuthorized");
                    if (isAllObjectsAuthorized) continue;
                    JSONObject errorString = new JSONObject();
                    String objectName = objectAuthorizationDetails.getString("memberName");
                    int rowIndex = objectAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.object_name_is_not_authorized"), objectName, csvHeaders[headers], rowIndex);
                    errorString.put("errorMsg", (Object)error);
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return false;
                }
                JSONObject userAuthorizationDetails = FcLayoutAuth.isAuthorizedUser((int)managerHeaderIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), domainOUList, (boolean)false, (Long)loginId);
                boolean isAllUsersAuthorized = userAuthorizationDetails.getBoolean("isAllUsersAuthorized");
                if (isAllUsersAuthorized) continue;
                JSONObject errorString = new JSONObject();
                String userName = userAuthorizationDetails.getString("userName");
                int rowIndex = userAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.user_name_is_not_authorized"), userName, csvHeaders[headers], rowIndex);
                errorString.put("errorMsg", (Object)error);
                request.setAttribute("importErrorMessage", (Object)errorString);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean isAuthorizedOUName(Vector headerVector, ArrayList<Vector> list, HttpServletRequest request, String domainName, Long loginId, AdventNetResourceBundle rb) {
        try {
            int OUNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "OUName");
            if (OUNameHeaderIndex != -1) {
                String defaultDomainNamingContext;
                JSONObject OUNameAuthorizationDetails;
                boolean isAllOusAuthorized;
                ADMPAuthObject authObject = FcExecuteFormFlow.getAuthObject(request);
                ArrayList ouList = null;
                if (authObject != null) {
                    Hashtable authorizedDomainOUHash = authObject.getDomainOUsMap();
                    ouList = (ArrayList)authorizedDomainOUHash.get(domainName);
                } else {
                    ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
                }
                if (ouList != null && ouList.size() != 0 && !(isAllOusAuthorized = (OUNameAuthorizationDetails = FcLayoutAuth.isAuthorizedOUNames((int)OUNameHeaderIndex, list, (ArrayList)ouList, (String)(defaultDomainNamingContext = DomainUtil.getDefaultNamingContext((String)domainName)), (boolean)true, (boolean)false)).getBoolean("isAllOusAuthorized"))) {
                    JSONObject errorString = new JSONObject();
                    String ouName = OUNameAuthorizationDetails.getString("ouName");
                    int rowIndex = OUNameAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.ou_name_is_not_authorized"), ouName, rowIndex);
                    errorString.put("errorMsg", (Object)error);
                    request.setAttribute("importErrorMessage", (Object)errorString);
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void deleteUser(CSVUserBean bean) {
        try {
            Criteria crit = bean.getUserOperationCriteria();
            Long userCreationID = (Long)bean.get("userCreationID");
            String tableName = USER_ATTRIBUTE_TABLE;
            if (crit == null) {
                tableName = "ADSMAUUserCreation";
                crit = new Criteria(new Column(tableName, "USER_CREATION_ID"), (Object)userCreationID, 0);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkAndSetSelectAllObjectUsers(HttpServletRequest request, CSVUserBean bean) {
        try {
            String selectAllUsers = request.getParameter("selectAllUsersStr");
            ArrayList deSelectedSIDs = (ArrayList)bean.get("deSelectedSIDs");
            ArrayList selectedSIDs = (ArrayList)bean.get("selectedSIDs");
            if (selectAllUsers != null && !selectAllUsers.equals("")) {
                if (selectAllUsers.equals("true")) {
                    deSelectedSIDs.clear();
                } else if (selectAllUsers.equals("false")) {
                    selectedSIDs.clear();
                }
                bean.set("selectAllUsers", selectAllUsers);
            }
            String[] selectedSIDsStr = request.getParameterValues("userIndex");
            ArrayList<Long> currentlySelected = new ArrayList<Long>();
            for (int i = 0; selectedSIDsStr != null && i < selectedSIDsStr.length; ++i) {
                int index;
                Long userIndex = new Long(selectedSIDsStr[i]);
                currentlySelected.add(userIndex);
                if (!selectedSIDs.contains(userIndex)) {
                    selectedSIDs.add(userIndex);
                }
                if ((index = deSelectedSIDs.indexOf(userIndex)) == -1) continue;
                deSelectedSIDs.remove(index);
            }
            String deSelectedSIDsStr = request.getParameter("deSelectedSIDsStr");
            if (deSelectedSIDsStr != null) {
                StringTokenizer token = new StringTokenizer(deSelectedSIDsStr, ",");
                while (token.hasMoreTokens()) {
                    String str = (String)token.nextElement();
                    Long objectGuid = new Long(str);
                    if (currentlySelected.contains(objectGuid)) continue;
                    if (!deSelectedSIDs.contains(objectGuid)) {
                        deSelectedSIDs.add(objectGuid);
                    }
                    if (!selectedSIDs.contains(objectGuid)) continue;
                    selectedSIDs.remove(objectGuid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward sampleCSV(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ServletOutputStream out;
            FileInputStream in;
            String path = request.getParameter("path");
            if ((path.startsWith("/help/") || path.startsWith("/webapps/adsm/html/")) && !path.contains("..")) {
                int length;
                String fileName = request.getParameter("fileName");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                Properties prop = System.getProperties();
                in = new FileInputStream(new File(prop.getProperty("server.dir") + path));
                out = response.getOutputStream();
                byte[] outputByte = new byte[4096];
                while ((length = in.read(outputByte)) > 0) {
                    out.write(outputByte, 0, length);
                }
            } else {
                return new ActionForward("/403Error.do");
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward exportBulkLayoutMgmtStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Integer actionId;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            CSVUserBean userBean = (CSVUserBean)form;
            String domainName = (String)userBean.get("domainName");
            Long userCreationID = (Long)userBean.get("userCreationID");
            ArrayList resultAttributeList = (ArrayList)userBean.get("resultAttributeList");
            ArrayList attrLst = (ArrayList)userBean.get("attributeList");
            CSVUserListener listener = (CSVUserListener)userBean.getListener();
            List<String> validSelectedList = Arrays.asList(listener.getValidSelected());
            String keyLdapName = listener.getKeyLdapName() != null ? listener.getKeyLdapName() : "";
            ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
            for (Object obj : attrLst) {
                Hashtable attrTable = (Hashtable)obj;
                String ldapName = (String)attrTable.get("ATTRIB_LDAP_NAME");
                if (!validSelectedList.contains(ldapName) && !ldapName.equalsIgnoreCase(keyLdapName)) continue;
                attributeList.add(attrTable);
            }
            for (Hashtable attribTable : resultAttributeList) {
                String attribColName = (String)attribTable.get("ATTRIB_COLUMN_NAME");
                if (!attribColName.equalsIgnoreCase("CREATION_STATUS") && !attribColName.equalsIgnoreCase("CREATION_MESSAGE")) continue;
                attributeList.add(attribTable);
            }
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = "";
            boolean isModify = false;
            if (userBean.get("isModification") != null && ((String)userBean.get("isModification")).equals("true")) {
                isModify = true;
            }
            System.out.println("isMod: " + isModify);
            String action = "";
            String objectClass = (String)userBean.get("objectClass");
            if (objectClass != null && objectClass.equalsIgnoreCase("CSVContactListener")) {
                if (isModify) {
                    action = "jsp.UserManagement.UseAdmin.bulk_contact_modification";
                    actionId = ReportsUtil.BULK_CONTACT_MODIFICATION_REPORT_ID;
                    reportFileName = "BulkContactModificationStatus";
                } else {
                    action = "jsp.UserManagement.UserAdmin.create_bulk_contacts";
                    actionId = ReportsUtil.BULK_CONTACT_CREATION_REPORT_ID;
                    reportFileName = "BulkContactCreationStatus";
                }
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVGroupListener")) {
                if (isModify) {
                    action = "jsp.UserManagement.UseAdmin.bulk_group_modification";
                    actionId = ReportsUtil.BULK_GROUP_MODIFICATION_REPORT_ID;
                    reportFileName = "BulkGroupModificationStatus";
                } else {
                    action = "admp.deleg.hdt_deleg.cre_role.action_name.cre_group";
                    actionId = ReportsUtil.BULK_GROUP_CREATION_REPORT_ID;
                    reportFileName = "BulkGroupCreationStatus";
                }
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVComputerListener")) {
                if (isModify) {
                    action = "admp.mgmt.comp_mgmt.mgmtname.bulk_comp_modification";
                    actionId = ReportsUtil.BULK_COMPUTER_MODIFICATION_REPORT_ID;
                    reportFileName = "BulkComputerModificationStatus";
                } else {
                    action = "admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_comp";
                    actionId = ReportsUtil.BULK_COMPUTER_CREATION_REPORT_ID;
                    reportFileName = "BulkComputerCreationStatus";
                }
            } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVOUListener")) {
                if (isModify) {
                    action = "admp.deleg.hdt_deleg.cre_role.action_name.bulk_ou_modify";
                    actionId = ReportsUtil.BULK_OU_MODIFICATION_REPORT_ID;
                    reportFileName = "BulkOUModificationStatus";
                } else {
                    action = "admp.deleg.hdt_deleg.cre_role.action_name.cre_mod_ou";
                    actionId = ReportsUtil.BULK_OU_CREATION_REPORT_ID;
                    reportFileName = "BulkOUCreationStatus";
                }
            } else if (isModify) {
                action = "admp.deleg.hdt_deleg.cre_role.action_name.bulk_user_modify";
                actionId = ReportsUtil.BULK_USER_MODIFICATION_REPORT_ID;
                reportFileName = "BulkUserModificationStatus";
            } else {
                action = "admp.reports.report_actions.create_request.options.create_bulk_user";
                actionId = ReportsUtil.BULK_USER_CREATION_REPORT_ID;
                reportFileName = "BulkUserCreationStatus";
            }
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("actionText", rb.getString("admp.deleg.hdt_deleg.cre_hdt.text_action"));
            inputParams.put("action", rb.getString(action));
            inputParams.put("domainName", domainName);
            inputParams.put("domainText", rb.getString("admp.common.text.domain"));
            inputParams.put("dateText", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("statusText", rb.getString("admp.common.text.status"));
            inputParams.put("loginId", loginId);
            AddUserHandler addUserHandler = AddUserHandler.getInstance();
            Criteria crit = userBean.getUserOperationCriteria();
            ArrayList userMgmtDetails = addUserHandler.getUserDetailsList(userCreationID, attributeList, 1, ((Long)userBean.get("ImportCount")).intValue(), crit);
            HashMap pwdMap = null;
            String tempTable = "ADSMUserBUMDetails_" + String.valueOf(userCreationID);
            TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tempTable);
            if (td != null) {
                pwdMap = AddUserHandler.getFromBulkUserLayoutTempTable((String)tempTable);
            }
            ArrayList list = CSVUserAction.getListForExport(userMgmtDetails, pwdMap);
            int exportCount = list.size();
            CSVUserAction.exportResults(reportFileName, reportType, list, attributeList, inputParams, request, response);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)action, (Integer)actionId, (String)"-", (Boolean)Boolean.FALSE, (String)("UserModificationStatus." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)exportCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ArrayList getListForExport(ArrayList<Hashtable> userMgmtDetails) {
        return CSVUserAction.getListForExport(userMgmtDetails, null);
    }

    private static ArrayList getListForExport(ArrayList<Hashtable> userMgmtDetails, HashMap pwdMap) {
        ArrayList<Properties> exportDetails = new ArrayList<Properties>();
        try {
            for (Hashtable singleUserDetails : userMgmtDetails) {
                Properties props = new Properties();
                ArrayList userValues = (ArrayList)singleUserDetails.get("USER_VALUES");
                Long userIdx = (Long)singleUserDetails.get("USER_INDEX");
                for (Hashtable values : userValues) {
                    String attrLdapName = (String)values.get("ATTRIB_LDAP_NAME");
                    Integer relType = (Integer)values.get("RELATIONAL_TYPE");
                    String attrValue = "";
                    if (values.get("ATTRIB_VALUE") != null) {
                        attrValue = values.get("ATTRIB_VALUE").toString();
                    }
                    String colName = (String)values.get("ATTRIB_COLUMN_NAME");
                    if (attrLdapName.equalsIgnoreCase("password")) {
                        String pwdVal;
                        if (PasswordUtil.getShowPasswordValue()) {
                            attrValue = "********";
                        } else if (pwdMap != null && userIdx != null && (pwdVal = (String)pwdMap.get(userIdx)) != null) {
                            attrValue = pwdVal;
                        }
                    }
                    if (attrLdapName.equalsIgnoreCase("Creation Status")) continue;
                    props.put(colName, attrValue);
                }
                exportDetails.add(props);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exportDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportResults(String reportFileName, String reportType, ArrayList list, ArrayList resultAttributeList, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        JRArrayList tempJRReportList = new JRArrayList();
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        try {
            int noOfObjToFetch;
            int exportPerRowCount;
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "UserModificationStatus.xml";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)reportFileName));
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            ArrayList<Properties> attributelist = new ArrayList<Properties>();
            for (Object attrObj : resultAttributeList) {
                Hashtable attrTable = (Hashtable)attrObj;
                Properties props = new Properties();
                Integer attribId = attrTable.containsKey("ACTION_ID") ? ((Long)attrTable.get("ACTION_ID")).intValue() : 0;
                props.put("ATTRIB_ID", attribId);
                props.put("ATTRIB_LDAP_NAME", (String)attrTable.get("ATTRIB_LDAP_NAME"));
                props.put("ATTRIB_DISP_NAME", (String)attrTable.get("ATTRIB_DISP_NAME"));
                props.put("TABLE_NAME", "EMPTY");
                props.put("ATTRIB_COLUMN_NAME", (String)attrTable.get("ATTRIB_COLUMN_NAME"));
                if (((String)attrTable.get("ATTRIB_LDAP_NAME")).equalsIgnoreCase("Creation Status")) continue;
                attributelist.add(props);
            }
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributelist, list, new Hashtable(), reportType, request, new Hashtable(), -1, true, showSerialNo, rb);
            Integer widthValue = (Integer)columnWidths.remove("maxColumnWidth");
            if (widthValue != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, rb, loginId, showSerialNo, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
            JasperReport jasperReportBasedOnType = null;
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            boolean isSingleSheet = false;
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int n2 = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (noOfObjToFetch = reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            if (isCSVExport) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            } else {
                JRDesignBand titleBand = new JRDesignBand();
                titleBand.setHeight(0);
                jasperDesign.setTitle((JRBand)titleBand);
                if (isSingleSheet) {
                    jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                }
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            }
            int AddToPgNumber = 0;
            ListUserDataProvider dataProvider = new ListUserDataProvider(list);
            AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, new Hashtable(), AddToPgNumber, jasperReportBasedOnType, jasperReport, dataProvider, defaultHeaderBand, reportType, locale, isSingleSheet, showSerialNo, 0, noOfObjToFetch);
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return;
        }
        try {
            ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    protected static class ObjectEqualsComparision
    implements Comparator<String> {
        protected ObjectEqualsComparision() {
        }

        @Override
        public int compare(String string1, String string2) {
            return string1.compareToIgnoreCase(string2);
        }
    }
}

