/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ComputerUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.GroupUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserAttributeHandler;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class CSVUserBean
extends UserBean {
    Logger out = Logger.getLogger("ADMangLogger");
    public static String USER_ATTRIBUTE_TABLE = "ADSMAUNamingAttributes";
    public static String[] keyLdapNames = new String[]{"samAccountName", "userPrincipalName", "distinguishedName", "cn", "name", "givenName", "sn", "displayName", "canonicalName", "profilePath", "scriptPath", "employeeID"};
    public static String[] keyColumnNames = new String[]{"SAM_ACCOUNT_NAME", "LOGON_NAME", "DISTINGUISHED_NAME", "COMMON_NAME", "FULL_NAME", "FIRST_NAME", "LAST_NAME", "DISPLAY_NAME", "CANONICAL_NAME", "PROFILE_PATH", "SCRIPT_PATH", "EMPLOYEE_ID"};
    public static String USER_CUSTOM_ATTRIB_TABLE = "ADSMAUCustomAttributes";

    public void initAttributeLists() {
        String str;
        ArrayList attributeList = (ArrayList)this.get("attributeList");
        String keyLdapName = null;
        for (int i = 0; i < keyLdapNames.length; ++i) {
            for (Hashtable hash : attributeList) {
                String str2 = (String)hash.get("ATTRIB_LDAP_NAME");
                if (!str2.equalsIgnoreCase(keyLdapNames[i])) continue;
                keyLdapName = str2;
                break;
            }
            if (keyLdapName != null) break;
        }
        if (keyLdapName != null) {
            this.set("keyLdapName", keyLdapName);
        }
        ArrayList resultAttributeList = new ArrayList();
        ArrayList<String> resultLdapNameList = new ArrayList<String>();
        for (Hashtable hash : attributeList) {
            str = (String)hash.get("ATTRIB_LDAP_NAME");
            for (int i = 0; i < keyLdapNames.length; ++i) {
                if (!str.equalsIgnoreCase(keyLdapNames[i])) continue;
                resultAttributeList.add(hash);
                resultLdapNameList.add(str);
                if (resultAttributeList.size() == 4) break;
            }
            if (resultAttributeList.size() != 4) continue;
            break;
        }
        if (resultAttributeList.size() < 4) {
            for (Hashtable hash : attributeList) {
                str = (String)hash.get("ATTRIB_LDAP_NAME");
                if (!resultLdapNameList.contains(str)) {
                    resultAttributeList.add(hash);
                }
                if (resultAttributeList.size() != 4) continue;
                break;
            }
        }
        Hashtable<String, Object> hash1 = new Hashtable<String, Object>();
        hash1.put("RELATIONAL_TYPE", new Integer(0));
        hash1.put("ATTRIB_COLUMN_NAME", "CREATION_STATUS");
        hash1.put("ATTRIB_LDAP_NAME", "Creation Status");
        hash1.put("ATTRIB_DISP_NAME", "Creation Status");
        resultAttributeList.add(hash1);
        Hashtable<String, Object> hash2 = new Hashtable<String, Object>();
        hash2.put("RELATIONAL_TYPE", new Integer(0));
        hash2.put("ATTRIB_COLUMN_NAME", "CREATION_MESSAGE");
        hash2.put("ATTRIB_LDAP_NAME", "Status");
        hash2.put("ATTRIB_DISP_NAME", "admp.mgmt.common.text.status");
        resultAttributeList.add(hash2);
        this.set("resultAttributeList", resultAttributeList);
    }

    public void init(HttpServletRequest request) {
        try {
            this.set("operation", "");
            this.set("attributeList", new ArrayList());
            this.set("resultAttributeList", new ArrayList());
            this.set("browse", null);
            this.set("userCreationID", new Long(-1L));
            this.set("selectAllUsers", "false");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.set("RANGE", NavigateRangeUtil.getDefaultRange((String)"CSVModification", (Long)loginId));
            this.set("FROM_INDEX", new Long(1L));
            this.set("PAGE_NUMBER", "1");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            Long[] ids = authObject.getActionArray();
            ArrayList domainList = authObject.getDomainList();
            ArrayList groupList = new ArrayList();
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProps = (Properties)domainList.get(i);
                groupList.addAll(HelpdeskUtil.getDelegatedGroupsWithOU((Long)loginId, (String)domainProps.getProperty("DOMAIN_NAME")));
            }
            this.initListener(loginId, ids, domainVsIds, groupList, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList, HttpServletRequest request) {
        try {
            Integer reportId = (Integer)this.get("reportId");
            String className = "com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener";
            if (reportId != null) {
                DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
                Row r = obj.getFirstRow("ADSMReports");
                className = (String)r.get("CLASS_NAME");
                if (r.get("ACTION_ID") != null) {
                    request.setAttribute("actionId", (Object)((Long)r.get("ACTION_ID")));
                }
            }
            this.setObjectClass(className);
            Class<?> classToInvoke = Class.forName(className.trim());
            Class[] args = new Class[]{loginId.getClass(), ids.getClass(), domainVsIds.getClass(), groupList.getClass()};
            Object[] objs = new Object[]{loginId, ids, domainVsIds, groupList};
            Constructor<?> ct = classToInvoke.getConstructor(args);
            CSVUserListener listener = (CSVUserListener)ct.newInstance(objs);
            this.setListener(listener);
            Locale locale = request.getLocale();
            listener.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setObjectClass(String className) {
        if (className != null && className.endsWith("CSVUserListener")) {
            this.set("objectClass", "CSVUserListener");
        } else if (className != null && className.endsWith("CSVGroupListener")) {
            this.set("objectClass", "CSVGroupListener");
        } else if (className != null && className.endsWith("CSVComputerListener")) {
            this.set("objectClass", "CSVComputerListener");
        } else if (className != null && className.endsWith("CSVOUListener")) {
            this.set("objectClass", "CSVOUListener");
        } else {
            this.set("objectClass", "CSVContactListener");
        }
    }

    public Criteria getUserOperationCriteria() {
        Criteria crit = null;
        try {
            String tableName = USER_ATTRIBUTE_TABLE;
            String selectAllUsers = (String)this.get("selectAllUsers");
            ArrayList deSelectedIndexes = (ArrayList)this.get("deSelectedSIDs");
            if (selectAllUsers.equals("false")) {
                ArrayList userIndexList = (ArrayList)this.get("selectedSIDs");
                Long[] userIndexes = new Long[userIndexList.size()];
                for (int i = 0; i < userIndexList.size(); ++i) {
                    userIndexes[i] = (Long)userIndexList.get(i);
                }
                Column col = new Column(tableName, "USER_INDEX");
                crit = new Criteria(col, (Object)userIndexes, 8);
            } else if (deSelectedIndexes.size() > 0) {
                Long[] userIndexes = new Long[deSelectedIndexes.size()];
                for (int i = 0; i < deSelectedIndexes.size(); ++i) {
                    userIndexes[i] = (Long)deSelectedIndexes.get(i);
                }
                Column col = new Column(tableName, "USER_INDEX");
                crit = new Criteria(col, (Object)userIndexes, 9);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public void reCreateList(HttpServletRequest request) {
        try {
            String tempTable;
            TableDefinition td;
            Long userCreationID = (Long)this.get("userCreationID");
            HttpSession session = request.getSession();
            String sessionID = session.getId();
            String domainName = (String)this.get("domainName");
            Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Users," + defaultNamingContext;
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            Long newUserCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            Criteria c = null;
            if (request.getParameter("listAll") == null) {
                c = new Criteria(new Column(USER_ATTRIBUTE_TABLE, "CREATION_STATUS"), (Object)"SUCCESS", 1);
                c = c.and(new Criteria(new Column(USER_ATTRIBUTE_TABLE, "CREATION_STATUS"), null, 1));
                c = c.and(new Criteria(new Column(USER_ATTRIBUTE_TABLE, "CREATION_STATUS"), (Object)"", 1));
            }
            Table baseTable = new Table(USER_ATTRIBUTE_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addSelectColumn(new Column(USER_ATTRIBUTE_TABLE, "*"));
            Column creationID = new Column(USER_ATTRIBUTE_TABLE, "USER_CREATION_ID");
            Criteria criteria = new Criteria(creationID, (Object)userCreationID, 0);
            if (c != null) {
                criteria = criteria.and(c);
            }
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            DataObject[] dataObjects = new DataObject[UserMgmtUtil.multiValuAttribsTables.length];
            for (int i = 0; i < UserMgmtUtil.multiValuAttribsTables.length; ++i) {
                Table baseTable1 = new Table(UserMgmtUtil.multiValuAttribsTables[i]);
                SelectQueryImpl query1 = new SelectQueryImpl(baseTable1);
                query1.addSelectColumn(new Column(UserMgmtUtil.multiValuAttribsTables[i], "*"));
                query1.setCriteria(criteria);
                query1.addJoin(new Join(baseTable1, baseTable, new String[]{"USER_INDEX"}, new String[]{"USER_INDEX"}, 2));
                dataObjects[i] = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query1);
            }
            DataObject customAttributeDO = null;
            Table customAttributeTable = new Table(USER_CUSTOM_ATTRIB_TABLE);
            SelectQueryImpl customAttribQuery = new SelectQueryImpl(customAttributeTable);
            customAttribQuery.addSelectColumn(new Column(USER_CUSTOM_ATTRIB_TABLE, "*"));
            customAttribQuery.setCriteria(criteria);
            customAttribQuery.addJoin(new Join(customAttributeTable, baseTable, new String[]{"USER_INDEX"}, new String[]{"USER_INDEX"}, 2));
            customAttributeDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)customAttribQuery);
            HashMap pwdMap = null;
            if (userCreationID != null && (td = MetaDataUtil.getTableDefinitionByName((String)(tempTable = "ADSMUserBUMDetails_" + String.valueOf(userCreationID)))) != null) {
                AddUserHandler.getInstance();
                pwdMap = AddUserHandler.getFromBulkUserLayoutTempTable((String)tempTable);
            }
            UserMgmtUtil.updateNewDO((DataObject)dataObject, (DataObject[])dataObjects, (DataObject)customAttributeDO, (Long)newUserCreationID, pwdMap);
            this.set("userCreationID", newUserCreationID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateColumns(HttpServletRequest request) {
        try {
            Long userIndex;
            ArrayList attributeList = (ArrayList)this.get("attributeList");
            ArrayList userDetailsList = new ArrayList();
            Long userCreationID = (Long)this.get("userCreationID");
            Hashtable<String, String> changedHash = new Hashtable<String, String>();
            ArrayList toBeRemovedMultipleValues = new ArrayList();
            ArrayList multipleToSingle = new ArrayList();
            ArrayList<Hashtable> newAttributeList = new ArrayList<Hashtable>();
            String newVsOldColumnStr = request.getParameter("COLUMN_MAP");
            JSONObject newVsOldColumnMap = new JSONObject(newVsOldColumnStr);
            for (Hashtable hash : attributeList) {
                String str = (String)hash.get("ATTRIB_COLUMN_NAME");
                String val = (String)newVsOldColumnMap.get(str);
                Hashtable hash2 = hash;
                if (val != null && !val.equalsIgnoreCase(str)) {
                    Hashtable h;
                    String s1;
                    void var16_22;
                    Object var16_23 = null;
                    String objectClass = (String)this.get("objectClass");
                    if (objectClass != null && objectClass.equalsIgnoreCase("CSVContactListener")) {
                        ContactUserHandler contactUserHandler = ContactUserHandler.getInstance();
                    } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVGroupListener")) {
                        GroupUserHandler groupUserHandler = GroupUserHandler.getInstance();
                    } else if (objectClass != null && objectClass.equalsIgnoreCase("CSVComputerListener")) {
                        ComputerUserHandler computerUserHandler = ComputerUserHandler.getInstance();
                    } else {
                        AddUserHandler addUserHandler = AddUserHandler.getInstance();
                    }
                    hash2 = (Hashtable)var16_22.getAttributeTableMap(new String[]{val}).get(0);
                    Integer srcRT = (Integer)hash.get("RELATIONAL_TYPE");
                    Integer targetRT = (Integer)hash2.get("RELATIONAL_TYPE");
                    if (srcRT.equals(0) && targetRT.equals(0)) {
                        changedHash.put(val, str);
                        s1 = (String)changedHash.get(str);
                        if (s1 == null) {
                            changedHash.put(str, "");
                        }
                    } else if (srcRT.equals(1) && targetRT.equals(0)) {
                        toBeRemovedMultipleValues.add(hash.get("AU_TABLE_NAME"));
                        h = new Hashtable();
                        h.put("SRC_ATTRIB_ID", hash.get("ATTRIB_ID"));
                        h.put("TARGET_ATTRIB_ID", hash2.get("ATTRIB_ID"));
                        multipleToSingle.add(h);
                    } else if (srcRT.equals(0) && targetRT.equals(1)) {
                        s1 = (String)changedHash.get(str);
                        if (s1 == null) {
                            changedHash.put(str, "");
                        }
                        toBeRemovedMultipleValues.add(hash2.get("AU_TABLE_NAME"));
                        Hashtable h2 = new Hashtable();
                        h2.put("SRC_ATTRIB_ID", hash.get("ATTRIB_ID"));
                        h2.put("TARGET_ATTRIB_ID", hash2.get("ATTRIB_ID"));
                        multipleToSingle.add(h2);
                    } else if (srcRT.equals(1) && targetRT.equals(1)) {
                        toBeRemovedMultipleValues.add(hash2.get("AU_TABLE_NAME"));
                        toBeRemovedMultipleValues.add(hash.get("AU_TABLE_NAME"));
                        h = new Hashtable();
                        h.put("SRC_ATTRIB_ID", hash.get("ATTRIB_ID"));
                        h.put("TARGET_ATTRIB_ID", hash2.get("ATTRIB_ID"));
                        multipleToSingle.add(h);
                    }
                }
                newAttributeList.add(hash2);
            }
            Column creationID = new Column(USER_ATTRIBUTE_TABLE, "USER_CREATION_ID");
            Criteria criteria = new Criteria(creationID, (Object)userCreationID, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(USER_ATTRIBUTE_TABLE, criteria);
            DataObject[] dataObjects = new DataObject[UserMgmtUtil.multiValuAttribsTables.length];
            for (int i = 0; i < UserMgmtUtil.multiValuAttribsTables.length; ++i) {
                Column column = new Column(UserMgmtUtil.multiValuAttribsTables[i], "USER_CREATION_ID");
                Criteria criteria2 = new Criteria(column, (Object)userCreationID, 0);
                dataObjects[i] = CommonUtil.getPersistence((boolean[])new boolean[0]).get(UserMgmtUtil.multiValuAttribsTables[i], criteria2);
            }
            Iterator iterator = dataObject.getRows(USER_ATTRIBUTE_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
                userIndex = (Long)row.get("USER_INDEX");
                hashtable.put("USER_INDEX", userIndex);
                ArrayList<Hashtable> detailsList = new ArrayList<Hashtable>();
                for (Hashtable hashtable2 : attributeList) {
                    Hashtable hashtable3 = (Hashtable)hashtable2.clone();
                    Integer relationalType = (Integer)hashtable2.get("RELATIONAL_TYPE");
                    if (relationalType.equals(1)) {
                        ArrayList arrayList = AddUserHandler.getInstance().getMultiValues(dataObjects, userIndex, (String)hashtable2.get("ATTRIB_COLUMN_NAME"));
                        hashtable3.put("ATTRIB_VALUE", arrayList);
                        hashtable3.put("ATTRIB_VALUE_COUNT", new Long(arrayList.size()));
                    } else {
                        Object value = row.get((String)hashtable2.get("ATTRIB_COLUMN_NAME"));
                        if (value != null) {
                            hashtable3.put("ATTRIB_VALUE", value);
                        }
                    }
                    detailsList.add(hashtable3);
                }
                hashtable.put("USER_VALUES", detailsList);
                userDetailsList.add(hashtable);
            }
            for (int j = 0; j < toBeRemovedMultipleValues.size(); ++j) {
                String string = (String)toBeRemovedMultipleValues.get(j);
                DataObject obj = dataObjects[this.getMultiTableIndex(string)];
                Criteria crit = new Criteria(new Column(string, "USER_CREATION_ID"), (Object)userCreationID, 0);
                obj.deleteRows(string, crit);
            }
            for (Hashtable hashtable : userDetailsList) {
                ArrayList attributeValues = (ArrayList)hashtable.get("USER_VALUES");
                userIndex = (Long)hashtable.get("USER_INDEX");
                Criteria crit = new Criteria(new Column(USER_ATTRIBUTE_TABLE, "USER_INDEX"), (Object)userIndex, 0);
                Row r = dataObject.getRow(USER_ATTRIBUTE_TABLE, crit);
                Enumeration e = changedHash.keys();
                while (e.hasMoreElements()) {
                    String string = (String)e.nextElement();
                    String val = (String)changedHash.get(string);
                    if (val.equalsIgnoreCase("")) {
                        r.set(string, (Object)"");
                        continue;
                    }
                    for (Hashtable h : attributeValues) {
                        String s = (String)h.get("ATTRIB_COLUMN_NAME");
                        if (!s.equalsIgnoreCase(val)) continue;
                        r.set(string, h.get("ATTRIB_VALUE"));
                    }
                }
                for (Hashtable hashtable4 : multipleToSingle) {
                    DataObject obj;
                    String targetColumnName;
                    String targetTableName;
                    String columnName;
                    Integer srcId = (Integer)hashtable4.get("SRC_ATTRIB_ID");
                    Integer targetId = (Integer)hashtable4.get("TARGET_ATTRIB_ID");
                    Hashtable hash1 = this.getAttributeDetails(srcId, AddUserHandler.getInstance().getAttributeList());
                    Hashtable hash2 = this.getAttributeDetails(targetId, AddUserHandler.getInstance().getAttributeList());
                    Integer srcRT = (Integer)hash1.get("RELATIONAL_TYPE");
                    Integer targetRT = (Integer)hash2.get("RELATIONAL_TYPE");
                    if (srcRT.equals(1) && targetRT.equals(0)) {
                        columnName = (String)hash1.get("ATTRIB_COLUMN_NAME");
                        String targetColumnName2 = (String)hash2.get("ATTRIB_COLUMN_NAME");
                        for (Hashtable h1 : attributeValues) {
                            String s = (String)h1.get("ATTRIB_COLUMN_NAME");
                            if (!s.equalsIgnoreCase(columnName)) continue;
                            ArrayList list = (ArrayList)h1.get("ATTRIB_VALUE");
                            r.set(targetColumnName2, list.get(0));
                        }
                        continue;
                    }
                    if (srcRT.equals(0) && targetRT.equals(1)) {
                        columnName = (String)hash1.get("ATTRIB_COLUMN_NAME");
                        targetTableName = (String)hash2.get("AU_TABLE_NAME");
                        targetColumnName = (String)hash2.get("ATTRIB_COLUMN_NAME");
                        obj = dataObjects[this.getMultiTableIndex(targetTableName)];
                        Row row = new Row(targetTableName);
                        row.set("USER_INDEX", (Object)userIndex);
                        row.set("USER_CREATION_ID", (Object)userCreationID);
                        for (Hashtable h1 : attributeValues) {
                            String s = (String)h1.get("ATTRIB_COLUMN_NAME");
                            if (!s.equalsIgnoreCase(columnName)) continue;
                            row.set(targetColumnName, h1.get("ATTRIB_VALUE"));
                        }
                        obj.addRow(row);
                        continue;
                    }
                    if (!srcRT.equals(1) || !targetRT.equals(1)) continue;
                    columnName = (String)hash1.get("ATTRIB_COLUMN_NAME");
                    targetTableName = (String)hash2.get("AU_TABLE_NAME");
                    targetColumnName = (String)hash2.get("ATTRIB_COLUMN_NAME");
                    obj = dataObjects[this.getMultiTableIndex(targetTableName)];
                    for (Hashtable h1 : attributeValues) {
                        String s = (String)h1.get("ATTRIB_COLUMN_NAME");
                        if (!s.equalsIgnoreCase(columnName)) continue;
                        ArrayList list = (ArrayList)hashtable4.get("ATTRIB_VALUE");
                        for (int i = 0; i < list.size(); ++i) {
                            Row row = new Row(targetTableName);
                            row.set("USER_INDEX", (Object)userIndex);
                            row.set("USER_CREATION_ID", (Object)userCreationID);
                            row.set(targetColumnName, list.get(i));
                            obj.addRow(row);
                        }
                    }
                }
                dataObject.updateRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            for (int i = 0; i < UserMgmtUtil.multiValuAttribsTables.length; ++i) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObjects[i]);
            }
            this.set("attributeList", newAttributeList);
            this.initAttributeLists();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Hashtable getAttributeDetails(Integer attId, ArrayList<Hashtable> attributeList) {
        for (Hashtable hashtable : attributeList) {
            if (!attId.equals(hashtable.get("ATTRIB_ID"))) continue;
            return hashtable;
        }
        return null;
    }

    private int getMultiTableIndex(String tableName) {
        for (int i = 0; i < UserMgmtUtil.multiValuAttribsTables.length; ++i) {
            String string = UserMgmtUtil.multiValuAttribsTables[i];
            if (!string.equalsIgnoreCase(tableName)) continue;
            return i;
        }
        return -1;
    }

    public void modifyUser(HttpServletRequest request) {
        try {
            CSVUserListener listener = (CSVUserListener)this.getListener();
            Long userCreationID = (Long)this.get("userCreationID");
            Integer reportId = (Integer)this.get("reportId");
            Criteria crit = this.getUserOperationCriteria();
            ArrayList attributeList = (ArrayList)this.get("resultAttributeList");
            ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList((Long)this.get("userCreationID"), attributeList, -1, -1, crit);
            request.setAttribute("userDetailsList", (Object)userDetailsList);
            ArrayList attributeList1 = (ArrayList)this.get("attributeList");
            ArrayList userDetailsList1 = AddUserHandler.getInstance().getUserDetailsList((Long)this.get("userCreationID"), attributeList1, -1, -1, crit);
            listener.init(reportId, userCreationID, (String)this.get("domainName"), userDetailsList1, (String)this.get("keyLdapName"), attributeList);
            listener.modifyUser(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveUserDetails(HttpServletRequest request, String type) throws Exception {
        this.setNamingAttributes(request);
        this.setSecurityAttributes(request);
        this.setPasswordAttributes(request);
        this.setTerminalAttributes(request);
        if (type.equals("csv")) {
            this.setExchangeAttributes(request);
            UserAttributeHandler.addorUpdateUserAttributeDetails(this, request);
        } else {
            String mailEnabled = (String)this.get("mailEnabled");
            if (mailEnabled.equalsIgnoreCase("mailBox")) {
                this.setExchangeAttributes(request);
                this.setEmailProxyAddresses(request, mailEnabled);
            } else if (mailEnabled.equalsIgnoreCase("mail")) {
                this.setMailEnableAttributes(request);
                this.setEmailProxyAddresses(request, mailEnabled);
            }
        }
    }

    @Override
    public void setPasswordAttributes(HttpServletRequest request) throws Exception {
        String PASSWORD = "";
        if (request.getParameter("enterPassword") != null) {
            PASSWORD = request.getParameter("enterPassword");
        }
        this.set("PASSWORD", PASSWORD);
    }

    @Override
    public ArrayList<String> getProtocolSettings(String owaccess, String pop, String imap, Integer version) {
        return super.getProtocolSettings(owaccess, pop, imap, version);
    }

    public boolean checkAuthorization(HttpServletRequest request, String ldapName, Long actionId, String domainName) {
        for (int i = 0; i < keyLdapNames.length; ++i) {
            if (!keyLdapNames[i].equalsIgnoreCase(ldapName)) continue;
            return true;
        }
        return ClientUtil.checkAuthorization(request, domainName, (long)actionId);
    }

    public void setRange(Long loginId) {
        Integer range = (Integer)this.get("RANGE");
        NavigateRangeUtil.setDefaultRange((String)"CSVModification", (int)range, (Long)loginId);
    }
}

