/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVComputerListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVContactListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVGroupListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVOUListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class CSVUserListener
extends AddUserListener {
    protected boolean stop = false;
    protected Hashtable authorizedDomainOUHash = null;
    private String[] validSelected = null;
    protected String[] validSelectedValues = null;
    protected boolean csvHasPwd = false;
    private Long[] ids = null;
    private ArrayList updateList = new ArrayList();
    private Properties messageProp = null;
    public AdventNetResourceBundle rb;
    protected Hashtable domainVsIds = new Hashtable();
    protected Integer reportId;
    protected int updatedCount = 0;
    protected Long requestId;
    protected boolean isWorkflowMode = false;
    ArrayList resultAttributeList = null;

    public void setWorkflowMode(boolean bl) {
        this.isWorkflowMode = bl;
    }

    public AddUserHandler returnHandler() {
        AddUserHandler addUserHandler = AddUserHandler.getInstance();
        return addUserHandler;
    }

    public CSVUserListener(Long l) {
        this.loginId = l;
    }

    public CSVUserListener(Long l, Long[] longArray, Hashtable hashtable, ArrayList arrayList) {
        this.loginId = l;
        this.ids = longArray;
        this.domainVsIds = hashtable;
        this.userCreationGroupList = arrayList;
    }

    public void init(Integer n, Long l, String string, ArrayList<Hashtable> arrayList, String string2) {
        this.init(n, l, string, arrayList, string2, null, null);
    }

    public void init(Integer n, Long l, String string, ArrayList<Hashtable> arrayList, String string2, ArrayList arrayList2) {
        this.init(n, l, string, arrayList, string2, null, arrayList2);
    }

    public void init(Integer n, Long l, String string, ArrayList<Hashtable> arrayList, String string2, Long l2, ArrayList arrayList2) {
        this.userCreationID = l;
        this.reportId = n;
        this.domainName = string;
        this.userDetailsList = arrayList;
        this.keyLdapName = string2;
        this.requestId = l2;
        this.resultAttributeList = arrayList2;
        try {
            Properties properties = HDTDomainHandler.getConfiguredValues((String)string, (Long)this.loginId);
            String string3 = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            this.userCreationGroupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String[][] getMessages() {
        String[] stringArray = new String[]{"heading", "query.string", "message.body", "message.match.criteria", "message.error_occured", "error.no.object", "link.sample"};
        String[] stringArray2 = new String[]{this.rb.getString("client.csv.CSVUserListener.modify_users_using_CSV"), "(&(objectClass=user)(objectCategory=user)", this.rb.getString("client.csv.CSVUserListener.you_can_modify_users_by_importing_data_from_csv_files"), this.rb.getString("client.csv.CSVUserListener.match_criteria_for_users_in_AD"), this.rb.getString("client.csv.CSVUserListener.show_the_error_occured_users_only"), this.rb.getString("client.csv.CSVUserListener.please_select_the_user"), "/help/csv-import-management/active-directory-modify-users-csv.html"};
        String[][] stringArray3 = new String[][]{stringArray, stringArray2};
        return stringArray3;
    }

    public String getObjectMessage(String string) {
        if (this.messageProp == null) {
            this.messageProp = new Properties();
            String[][] stringArray = this.getMessages();
            for (int i = 0; i < stringArray[0].length; ++i) {
                this.messageProp.put(stringArray[0][i], stringArray[1][i]);
            }
        }
        return this.messageProp.getProperty(string);
    }

    public String getObjectName(ArrayList arrayList) {
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            Hashtable hashtable = (Hashtable)arrayList.get(i);
            String string2 = (String)hashtable.get("ATTRIB_LDAP_NAME");
            if (!string2.equalsIgnoreCase("sAMAccountName") && !string2.equalsIgnoreCase("userName") && !string2.equalsIgnoreCase("givenName") && !string2.equalsIgnoreCase("distinguishedName") && !string2.equalsIgnoreCase("name") || string == null) continue;
            string = (String)hashtable.get("ATTRIB_VALUE");
            return string;
        }
        return string;
    }

    public void updatePreventDeletion(String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("S-1-1-0");
        ArrayList arrayList2 = new ArrayList();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ACCESS_MASK", 65600L);
        hashtable.put("PERMISSION_STRING", "Delete,Delete Subtree");
        hashtable.put("INHERIT_TYPE_FLAG", new Long(0L));
        hashtable.put("ACE_TYPE", 1L);
        hashtable.put("ACE_ID", new Long(1L));
        hashtable.put("operation", string2);
        arrayList2.add(hashtable);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, arrayList2, arrayList, (String)string);
    }

    public void updateParent(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("S-1-1-0");
        ArrayList arrayList2 = new ArrayList();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ACCESS_MASK", 2L);
        hashtable.put("PERMISSION_STRING", "Delete all child");
        hashtable.put("INHERIT_TYPE_FLAG", new Long(0L));
        hashtable.put("ACE_TYPE", 1L);
        hashtable.put("ACE_ID", new Long(1L));
        hashtable.put("operation", "add");
        arrayList2.add(hashtable);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, arrayList2, arrayList, (String)string);
    }

    public void modifyUser(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = httpServletRequest.getRemoteHost();
        ADMPAuthObject aDMPAuthObject = (ADMPAuthObject)httpSession.getAttribute("ADMP_AUTH_OBJECT");
        this.validSelected = httpServletRequest.getParameterValues("validSelected");
        this.validSelectedValues = httpServletRequest.getParameterValues("validSelectedValues");
        String string2 = httpServletRequest.getParameter("appendvaluesfromCSV");
        this.isAppendMultiValue = string2 != null && string2.equalsIgnoreCase("on");
        String string3 = httpServletRequest.getParameter("removeADValueCSVEmpty");
        this.isClearEmptyValue = string3 != null && string3.equalsIgnoreCase("on");
        this.authorizedDomainOUHash = aDMPAuthObject.getDomainOUsMap();
        Action action = new Action(this, string);
        this.stop = false;
        this.isCompleted = false;
        this.errorMessage = "";
        action.start();
    }

    public void modifyUser() {
        Action action = new Action(this, this.hostId);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void setAuthorizedDomainOUHash(Hashtable hashtable) {
        this.authorizedDomainOUHash = hashtable;
    }

    public void setValidSelected(String[] stringArray) {
        this.validSelected = stringArray;
    }

    public String[] getValidSelected() {
        return this.validSelected;
    }

    public void setValidSelectedValues(String[] stringArray) {
        this.validSelectedValues = stringArray;
    }

    public String[] getValidSelectedValues() {
        return this.validSelectedValues;
    }

    public String getKeyLdapName() {
        return this.keyLdapName;
    }

    public void setAdvancedOptions(String string, String string2) {
        this.isAppendMultiValue = Boolean.parseBoolean(string);
        this.isClearEmptyValue = Boolean.parseBoolean(string2);
    }

    @Override
    public void stop() {
        this.stop = true;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void performADSync() {
        DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"User"}, (boolean)false);
    }

    public static String convertGuidToHexDecimal(String string) {
        string = string.replaceAll("[{}]+", "");
        int n = string.length() - string.replaceAll("-", "").length();
        String[] stringArray = string.split("-");
        if (n == 4 && stringArray.length == 5) {
            int n2 = 0;
            char[] cArray = stringArray[0].toCharArray();
            char[] cArray2 = stringArray[1].toCharArray();
            char[] cArray3 = stringArray[2].toCharArray();
            String string2 = CSVUserListener.guidConversion(cArray);
            string2 = string2 + CSVUserListener.guidConversion(cArray2);
            string2 = string2 + CSVUserListener.guidConversion(cArray3);
            string2 = string2 + stringArray[3];
            string2 = string2 + stringArray[4];
            char[] cArray4 = string2.toCharArray();
            char[] cArray5 = new char[48];
            int n3 = 0;
            while (n3 + 1 < cArray4.length) {
                cArray5[n2++] = 92;
                cArray5[n2++] = cArray4[n3];
                cArray5[n2++] = cArray4[n3 + 1];
                n3 += 2;
            }
            return String.valueOf(cArray5);
        }
        return "";
    }

    private static String guidConversion(char[] cArray) {
        int n = 0;
        char[] cArray2 = new char[cArray.length];
        for (int i = cArray.length - 1; i >= 0; i -= 2) {
            cArray2[n++] = cArray[i - 1];
            cArray2[n++] = cArray[i];
        }
        return String.valueOf(cArray2);
    }

    protected ArrayList splitMultiValues(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String string : arrayList) {
                    String[] stringArray;
                    if (string == null) continue;
                    for (String string2 : stringArray = string.split("(?<!\\\\);")) {
                        if (string2 == null || string2.isEmpty() || arrayList2.contains(string2 = string2.replace("\\;", ";"))) continue;
                        arrayList2.add(string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    protected void modifyObject(String string, Hashtable hashtable, Hashtable hashtable2, boolean bl, Hashtable hashtable3, DataObject dataObject) throws Exception {
        Object object;
        boolean bl2;
        Properties properties;
        Serializable serializable;
        Object object2;
        Object object3;
        block130: {
            String string2;
            Object object4;
            Long l;
            block127: {
                Object object5;
                Object object6;
                Object object72;
                String string3;
                String string4;
                boolean bl3;
                String string5;
                Properties properties2;
                ArrayList<String> arrayList;
                ArrayList<Hashtable> arrayList2;
                ArrayList<Hashtable> arrayList3;
                ArrayList<Hashtable> arrayList4;
                ArrayList<Object> arrayList5;
                ArrayList<Hashtable> arrayList6;
                block125: {
                    String string6;
                    Object object8;
                    int n;
                    Object object9;
                    Hashtable hashtable4;
                    int n2;
                    l = (Long)hashtable.get("USER_INDEX");
                    ArrayList arrayList7 = (ArrayList)hashtable.get("USER_VALUES");
                    arrayList6 = new ArrayList<Hashtable>();
                    arrayList5 = new ArrayList<Object>();
                    arrayList4 = new ArrayList<Hashtable>();
                    arrayList3 = new ArrayList<Hashtable>();
                    arrayList2 = new ArrayList<Hashtable>();
                    arrayList = new ArrayList<String>();
                    Properties properties3 = new Properties();
                    properties2 = new Properties();
                    String string7 = "(&(objectClass=user)(objectCategory=user)";
                    String string8 = "";
                    if (this.validSelectedValues != null) {
                        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
                            hashtable4 = (Hashtable)arrayList7.get(n2);
                            for (int i = 0; i < this.validSelectedValues.length; ++i) {
                                object9 = (String)hashtable4.get("ATTRIB_LDAP_NAME");
                                if (((String)object9).equalsIgnoreCase("password")) {
                                    this.csvHasPwd = true;
                                }
                                if (!((String)object9).equals(object3 = this.validSelectedValues[i])) continue;
                                object4 = hashtable4.get("ATTRIB_VALUE");
                                if (((String)object9).equalsIgnoreCase("sAMAccountName")) {
                                    string8 = (String)object4;
                                }
                                n = (Integer)hashtable4.get("RELATIONAL_TYPE");
                                object2 = "";
                                if (n == 1) continue;
                                object2 = (String)object4;
                                serializable = (Long)hashtable4.get("DATA_HANDLER_TYPE");
                                if ((Long)serializable == 6L) {
                                    object2 = ((String)object2).toUpperCase();
                                }
                                object2 = ((String)object9).equalsIgnoreCase("objectGUID") ? CSVUserListener.convertGuidToHexDecimal((String)object2) : CommonUtil.escapeSpecialCharacters((String)object2);
                                string7 = string7 + "(" + (String)object9 + "=" + (String)object2 + ")";
                            }
                        }
                    } else {
                        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
                            hashtable4 = (Hashtable)arrayList7.get(n2);
                            String string9 = (String)hashtable4.get("ATTRIB_LDAP_NAME");
                            if (string9.equalsIgnoreCase("password")) {
                                this.csvHasPwd = true;
                            }
                            if (!string9.equals(this.keyLdapName)) continue;
                            this.keyLdapValue = CommonUtil.escapeSpecialCharacters((String)((String)hashtable4.get("ATTRIB_VALUE")));
                        }
                        string7 = string7 + "(" + this.keyLdapName + "=" + this.keyLdapValue + ")";
                    }
                    string7 = string7 + ")";
                    System.out.println("searchString : : : : : : " + string7);
                    string5 = "";
                    string5 = this.getObjectName(arrayList7);
                    this.removeUnAuthorizedProps(arrayList7);
                    this.getProperties("modify", arrayList7, arrayList6, arrayList4, arrayList3, arrayList2, arrayList, properties3, "User");
                    hashtable4 = (Hashtable)hashtable2.get(l);
                    mgmtLog.log(Level.FINE, "Bulk User modification Custom Attributes : " + hashtable4);
                    if (hashtable4 != null) {
                        Enumeration enumeration = hashtable4.keys();
                        while (enumeration.hasMoreElements()) {
                            object9 = (String)enumeration.nextElement();
                            object3 = (ArrayList)hashtable4.get(object9);
                            if (((String)object9).equalsIgnoreCase("removeMemberOf")) {
                                properties2.put("removeMemberOf", this.splitMultiValues((ArrayList)object3));
                                continue;
                            }
                            if (((String)object9).equalsIgnoreCase("removeProxyAddresses")) {
                                properties2.put("removeProxyAddresses", this.splitMultiValues((ArrayList)object3));
                                continue;
                            }
                            if (!this.isClearEmptyValue && object3 != null && ((ArrayList)object3).size() == 0) continue;
                            object4 = new Hashtable();
                            ((Hashtable)object4).put((String)"ATTRIB_LDAP_NAME", (String)object9);
                            ((Hashtable)object4).put("DATA_HANDLER_TYPE", 3L);
                            ((Hashtable)object4).put("ATTRIB_VALUE_COUNT", 1L);
                            n = 0;
                            object2 = this.returnHandler().getAttributeDetailsFromMap("ATTRIB_LDAP_NAME", object9);
                            if (object2 != null && ((Hashtable)object2).get("RELATIONAL_TYPE") != null) {
                                int n3 = n = ((Integer)((Hashtable)object2).get("RELATIONAL_TYPE")).compareTo(1) == 0 ? 1 : 0;
                            }
                            if (this.isAppendMultiValue && n != 0) {
                                ((Hashtable)object4).put("DW_CONTROL_CODE", 3L);
                            } else {
                                ((Hashtable)object4).put("DW_CONTROL_CODE", 2L);
                            }
                            if (object3 != null && ((ArrayList)object3).size() > 1) {
                                serializable = new ArrayList<String>();
                                object8 = ((ArrayList)object3).iterator();
                                while (object8.hasNext()) {
                                    string6 = object8.next();
                                    serializable.add(string6.toString().trim());
                                }
                                ((Hashtable)object4).put("ATTRIB_VALUE", serializable);
                                ((Hashtable)object4).put("ATTRIB_VALUE_COUNT", new Long(serializable.size()));
                            } else if (object3 != null && ((ArrayList)object3).size() == 1) {
                                ((Hashtable)object4).put("ATTRIB_VALUE", ((ArrayList)object3).get(0));
                            } else {
                                ((Hashtable)object4).put("ATTRIB_VALUE", "");
                                ((Hashtable)object4).put("DW_CONTROL_CODE", 1L);
                            }
                            arrayList5.add(object4);
                        }
                    }
                    bl3 = false;
                    object9 = "";
                    if (properties3.containsKey("removeMemberOf")) {
                        bl3 = true;
                    }
                    object3 = "";
                    if (properties3.get("distinguishedName") != null) {
                        object3 = properties3.getProperty("distinguishedName");
                    }
                    object4 = "";
                    if (properties3.get("userName") != null) {
                        object4 = properties3.getProperty("userName");
                    }
                    string2 = "";
                    if (properties3.get("samAccountName") != null) {
                        string2 = properties3.getProperty("samAccountName");
                    }
                    object2 = null;
                    if (properties3.get("password") != null) {
                        object2 = properties3.getProperty("password");
                    }
                    serializable = "";
                    if (properties3.get("manager") != null) {
                        serializable = properties3.getProperty("manager");
                    }
                    object8 = "";
                    if (properties3.get("remoteHomeDir") != null) {
                        object8 = properties3.getProperty("remoteHomeDir");
                    }
                    string6 = "";
                    if (properties3.get("tsRemoteHomeDir") != null) {
                        string6 = properties3.getProperty("tsRemoteHomeDir");
                    }
                    String string10 = "";
                    if (properties3.get("profilePath") != null) {
                        string10 = properties3.getProperty("profilePath");
                    }
                    String string11 = "";
                    if (properties3.get("tsProfilePath") != null) {
                        string11 = properties3.getProperty("tsProfilePath");
                    }
                    String string12 = "";
                    if (properties3.get("tsWorkingDir") != null) {
                        string12 = properties3.getProperty("tsWorkingDir");
                    }
                    string4 = "";
                    if (properties3.get("msExchArchiveDatabaseLink") != null) {
                        string4 = properties3.getProperty("msExchArchiveDatabaseLink");
                    }
                    string3 = "";
                    if (properties3.get("msExchArchiveAddress") != null) {
                        string3 = properties3.getProperty("msExchArchiveAddress");
                    }
                    string2 = CommonUtil.replaceSAMAccountSplChars((String)string2);
                    if (string8.isEmpty()) {
                        string8 = string2;
                    }
                    if (!((String)object8).equals("")) {
                        object8 = FormatClientUtil.getFormatValue(this.domainName, (String)object8, arrayList7, string8, (String)object4, arrayList5);
                        CSVUserListener.setFormatValue(arrayList6, "homeDirectory", (String)object8);
                    }
                    string10 = FormatClientUtil.getFormatValue(this.domainName, string10, arrayList7, string8, (String)object4, arrayList5);
                    CSVUserListener.setFormatValue(arrayList6, "profilePath", string10);
                    if (!string6.equals("")) {
                        string6 = FormatClientUtil.getFormatValue(this.domainName, string6, arrayList7, string8, (String)object4, arrayList5);
                        CSVUserListener.setFormatValue(arrayList3, "tsHomeDir", string6);
                    }
                    string11 = FormatClientUtil.getFormatValue(this.domainName, string11, arrayList7, string8, (String)object4, arrayList5);
                    CSVUserListener.setFormatValue(arrayList3, "tsProfilePath", string11);
                    string12 = FormatClientUtil.getFormatValue(this.domainName, string12, arrayList7, string8, (String)object4, arrayList5);
                    CSVUserListener.setFormatValue(arrayList3, "tsWorkingDir", string12);
                    Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
                    hashtable5.put("domainName", this.domainName);
                    hashtable5.put("userName", object4);
                    hashtable5.put("samAccountName", string2);
                    if (object2 != null) {
                        hashtable5.put("password", object2);
                    }
                    hashtable5.put("propList", arrayList6);
                    hashtable5.put("modifyList", arrayList4);
                    hashtable5.put("tsList", arrayList3);
                    hashtable5.put("winNTAttributeList", arrayList2);
                    hashtable5.put("groupList", arrayList);
                    hashtable5.put("remoteHomeDir", object8);
                    hashtable5.put("tsRemoteHomeDir", string6);
                    hashtable5.put(" msExchArchiveDatabaseLink", string4);
                    hashtable5.put("msExchArchiveAddress", string3);
                    Long l2 = HDTAuditUtil.fillAuditObjDetails((Long)((Long)hashtable3.get("audit_id")), (String)string5, (String)this.domainName, (DataObject)dataObject);
                    hashtable3.put("object_id", l2);
                    hashtable3.put("objectName", string5);
                    if (properties3.get("manager") != null) {
                        hashtable3.put("manager", serializable);
                    }
                    properties = new Properties();
                    boolean bl4 = false;
                    bl2 = false;
                    if (bl3) {
                        properties2.put("isClearIfEmpty", (Object)bl3);
                    }
                    if (bl) break block127;
                    try {
                        String string13;
                        Object object10;
                        Serializable serializable2;
                        String string14;
                        String string15;
                        Object object11;
                        Object object12;
                        block128: {
                            block129: {
                                Object object13;
                                this.removeUnAuthorizedProps(arrayList5);
                                this.checkRemovePropsSelected(properties2);
                                this.fillProxyAddrMacroValues(properties2, arrayList7, string2, (String)object4, arrayList5);
                                if (object2 == null && arrayList6.size() == 0 && arrayList4.size() == 0 && arrayList3.size() == 0 && arrayList2.size() == 0 && arrayList.size() == 0 && !bl3 && properties2 != null && !properties2.isEmpty()) {
                                    properties2.put("HasRemoveProps", (Object)true);
                                }
                                object = "SUCCESS";
                                object72 = null;
                                if (((String)object3).equals("")) {
                                    boolean bl5 = false;
                                    object72 = new ArrayList();
                                    ((ArrayList)object72).add("distinguishedName");
                                    ((ArrayList)object72).add("sAMAccountName");
                                    ((ArrayList)object72).add("name");
                                    ((ArrayList)object72).add("homeMDB");
                                    ((ArrayList)object72).add("msExchHomeServerName");
                                    ((ArrayList)object72).add("msExchArchiveDatabaseLink");
                                    ((ArrayList)object72).add("msExchArchiveAddress");
                                    if (properties2.containsKey("removeProxyAddresses")) {
                                        ((ArrayList)object72).add("proxyAddresses");
                                    }
                                    if (properties2.containsKey("removeMemberOf") && ((String)(object13 = (String)((ArrayList)properties2.get("removeMemberOf")).get(0))).equalsIgnoreCase("true")) {
                                        bl5 = true;
                                        ((ArrayList)object72).add("memberOf");
                                    }
                                    if ((object72 = ADHandler.getObjectsWithOutListener((Properties)(object13 = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId)), (String)string, (ArrayList)object72, (String)string7)) != null && ((ArrayList)object72).size() > 0) {
                                        object12 = (Properties)((ArrayList)object72).get(0);
                                        object3 = StrUtil.getString((Properties)object12, (String)"distinguishedName");
                                        string2 = StrUtil.getString((Properties)object12, (String)"sAMAccountName");
                                        object9 = StrUtil.getString((Properties)object12, (String)"name");
                                        if (properties2.containsKey("removeProxyAddresses")) {
                                            this.checkAndRemovePrimaryProxyAddr(properties2, (Properties)object12);
                                        }
                                        if (properties2.containsKey("removeMemberOf") && bl5) {
                                            this.removeUnAuthorizedGroups(properties2, (Properties)object12, this.loginId, this.domainName);
                                        }
                                    } else {
                                        properties.setProperty("CREATION_STATUS", "SEVERE");
                                        properties.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
                                        properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        object = properties.getProperty("CREATION_STATUS");
                                    }
                                }
                                if (properties2 != null && !properties2.isEmpty()) {
                                    if (properties2.containsKey("removeMemberOf")) {
                                        hashtable5.put("removeMemberOf", properties2.get("removeMemberOf").toString());
                                    }
                                    if (properties2.containsKey("removeProxyAddresses")) {
                                        hashtable5.put("removeProxyAddresses", properties2.get("removeProxyAddresses").toString());
                                    }
                                }
                                object6 = (ArrayList)this.authorizedDomainOUHash.get(this.domainName);
                                if (object2 == null && arrayList6.size() <= 0 && arrayList4.size() <= 0 && arrayList3.size() <= 0 && arrayList2.size() <= 0 && arrayList.size() <= 0 && arrayList5.size() <= 0 && !bl3 && properties2.size() <= 0) break block128;
                                mgmtLog.log(Level.INFO, "propList after authorize check " + arrayList6);
                                hashtable5.put("customList", arrayList5);
                                if (object6 != null && ((ArrayList)object6).size() != 0) break block129;
                                object13 = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)string, (String)string7, (String)StrUtil.getContainerDNFromDN((String)object3), (String)object2, arrayList6, arrayList4, arrayList3, arrayList2, arrayList, (Properties)properties2);
                                properties = this.getBulkUserErrorMessage(this.domainName, string7, arrayList, (NativeError)object13, (String)object4, (String)object3);
                                object = properties.getProperty("CREATION_STATUS");
                                if (((String)object).equalsIgnoreCase("SEVERE") || arrayList5.isEmpty()) break block128;
                                object12 = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)string, (String)string7, (String)StrUtil.getContainerDNFromDN((String)object3), null, arrayList5, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)properties, (NativeError)object12, (String)string7);
                                break block128;
                            }
                            for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                                object12 = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)((ArrayList)object6).get(i)), (String)string7, (String)StrUtil.getContainerDNFromDN((String)object3), (String)object2, arrayList6, arrayList4, arrayList3, arrayList2, arrayList, (Properties)properties2);
                                properties = this.getBulkUserErrorMessage(this.domainName, string7, arrayList, (NativeError)object12, (String)object4, (String)object3);
                                object = properties.getProperty("CREATION_STATUS");
                                if (((String)object).equalsIgnoreCase("SEVERE")) continue;
                                if (arrayList5.isEmpty()) break;
                                object11 = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)((ArrayList)object6).get(i)), (String)string7, (String)StrUtil.getContainerDNFromDN((String)object3), null, arrayList5, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)properties, (NativeError)object11, (String)string7);
                                break;
                            }
                        }
                        if (object2 == null) {
                            object2 = "";
                        }
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + l);
                        properties.setProperty("userName", (String)object4);
                        properties.setProperty("logonName", string2);
                        properties.setProperty("password", (String)object2);
                        object5 = null;
                        if (string5.equals("")) {
                            HDTAuditUtil.updateAuditData((Long)l2, (String)string2, (String)"OBJECT_NAME", (DataObject)dataObject);
                            string5 = string2;
                            hashtable3.put("objectName", string2);
                        }
                        if (((String)object).equalsIgnoreCase("SEVERE")) break block125;
                        if (properties.getProperty("CREATION_MESSAGE") != null && properties.getProperty("CREATION_MESSAGE").contains(this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"))) {
                            bl4 = true;
                            properties.remove("CREATION_MESSAGE");
                        }
                        mgmtLog.log(Level.INFO, "Search String :(sAMAccountName=" + string2 + ")");
                        System.out.println("Creation status is not severe (sAMAccountName=" + string2 + ")");
                        if (this.checkSelected("homeDirectory") && object3 != null && !((String)object3).equals("")) {
                            object5 = UserPermissionsHandler.getInstance().getDefaultACEList(null, (String)object3, this.domainName);
                            if (!((String)object8).equals("") && ((String)object8).startsWith("\\")) {
                                try {
                                    object12 = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)object8, null, (String)object3, (ArrayList)object5, (long)0x20000000L);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)properties, (NativeError)object12, (String)"homeDir");
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        if (this.checkSelected("tsHomeDir") && object3 != null && !((String)object3).equals("")) {
                            object5 = UserPermissionsHandler.getInstance().getDefaultACEList(null, (String)object3, this.domainName);
                            if (!string6.equals("") && string6.startsWith("\\")) {
                                try {
                                    object12 = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)string6, null, (String)object3, (ArrayList)object5, (long)0x20000000L);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)properties, (NativeError)object12, (String)"tsHomeDir");
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        try {
                            if (properties3.get("preventDeletion") != null) {
                                object12 = new Properties();
                                ((Properties)object12).put("ATTRIB_LDAP_NAME", "preventDeletion");
                                ((Properties)object12).put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                                ((Properties)object12).put("ATTRIB_VALUE_COUNT", new Long(1L));
                                if (((Boolean)properties3.get("preventDeletion")).booleanValue()) {
                                    ((Properties)object12).put("ATTRIB_VALUE", "true");
                                    object11 = StrUtil.getContainerDNFromDN((String)object3);
                                    this.updatePreventDeletion((String)object3, "add");
                                    if (!((String)object11).equalsIgnoreCase(string)) {
                                        this.updateParent((String)object11);
                                    }
                                } else {
                                    ((Properties)object12).put("ATTRIB_VALUE", "false");
                                    this.updatePreventDeletion((String)object3, "delete");
                                }
                                arrayList6.add((Hashtable)object12);
                                bl4 = true;
                            }
                        }
                        catch (Exception exception) {
                            object11 = new StringBuilder();
                            if (properties.getProperty("CREATION_MESSAGE") != null) {
                                ((StringBuilder)object11).append(properties.getProperty("CREATION_MESSAGE"));
                                if (((StringBuilder)object11).length() > 0) {
                                    ((StringBuilder)object11).append(" , ");
                                }
                            }
                            ((StringBuilder)object11).append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_modifying_preventDeletion"), exception.getMessage()));
                            properties.setProperty("CREATION_MESSAGE", ((StringBuilder)object11).toString());
                            properties.setProperty("CREATION_STATUS", "SEVERE");
                            properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        if (this.checkSelected("name") && object4 != null && !((String)object4).equals("")) {
                            mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + (String)object4 + " for the User : " + (String)object3);
                            try {
                                ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)object3, (String)object4, null);
                                object9 = object4;
                                object3 = StrUtil.updateFullNameToExistingDN((String)object3, (String)object9);
                                object12 = new Properties();
                                ((Properties)object12).put("ATTRIB_LDAP_NAME", "name");
                                ((Properties)object12).put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                                ((Properties)object12).put("ATTRIB_VALUE_COUNT", (Object)1L);
                                ((Properties)object12).put("ATTRIB_VALUE", object4);
                                arrayList6.add((Hashtable)object12);
                                bl4 = true;
                            }
                            catch (LocalizedException localizedException) {
                                localizedException.printStackTrace();
                                object11 = new StringBuilder();
                                if (properties.getProperty("CREATION_MESSAGE") != null) {
                                    ((StringBuilder)object11).append(properties.getProperty("CREATION_MESSAGE"));
                                    if (((StringBuilder)object11).length() > 0) {
                                        ((StringBuilder)object11).append(" , ");
                                    }
                                }
                                ((StringBuilder)object11).append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_modifying_fullname"), localizedException.getMessage(this.rb)));
                                properties.setProperty("CREATION_MESSAGE", ((StringBuilder)object11).toString());
                                properties.setProperty("CREATION_STATUS", "SEVERE");
                                properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if ((this.checkSelected("msExchArchiveDatabaseLink") || this.checkSelected("msExchArchiveAddress") && object3 != null && !((String)object3).equals("")) && object72 != null && ((ArrayList)object72).size() > 0) {
                            object12 = (Properties)((ArrayList)object72).get(0);
                            object11 = StrUtil.getString((Properties)object12, (String)"msExchHomeServerName");
                            String string16 = StrUtil.getString((Properties)object12, (String)"homeMDB");
                            string15 = StrUtil.getString((Properties)object12, (String)"msExchArchiveDatabaseLink");
                            string14 = StrUtil.getString((Properties)object12, (String)"msExchArchiveAddress");
                            serializable2 = ExchangeUtil.getExchangeServerType((String)object11);
                            if (!string4.equals("") || !string3.equals("")) {
                                if ((Integer)serializable2 >= 2010) {
                                    boolean bl6 = false;
                                    if (!string3.equals("")) {
                                        bl6 = true;
                                    }
                                    if (string15.equals("") && string14.equals("")) {
                                        mgmtLog.log(Level.INFO, "Creating archive mailbox for the User : " + (String)object3);
                                        object10 = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)object11);
                                        string13 = "";
                                        string13 = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)object3, (String)string4, (String)string3, (Properties)object10, (boolean)bl6);
                                        if (string13.length() > 0) {
                                            properties.setProperty("CREATION_MESSAGE", string13);
                                            properties.setProperty("CREATION_STATUS", "WARNING");
                                            properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                            properties.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                        }
                                    } else {
                                        object10 = MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_create_archive"), this.rb.getString((String)object3));
                                        properties.setProperty("CREATION_MESSAGE", (String)object10);
                                        properties.setProperty("CREATION_STATUS", "WARNING");
                                        properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        properties.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                    }
                                } else {
                                    String string17 = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)this.rb.getString(string16)));
                                    properties.setProperty("CREATION_MESSAGE", string17);
                                    properties.setProperty("CREATION_STATUS", "WARNING");
                                    properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                    properties.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                }
                            }
                        }
                        if (this.checkSelected("ouName") && !((String)object3).equals("")) {
                            object12 = properties3.getProperty("OUName");
                            if (object12 != null && !((String)object12).equals("")) {
                                object11 = null;
                                boolean bl7 = false;
                                if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)DelegationUtil.CREATE_OU_ACTION_ID)) {
                                    bl7 = true;
                                }
                                if ((string15 = MgmtUtil.checkAndCreateParent(this.domainName, (String)object12, this.loginId, bl7)) != null) {
                                    object12 = string15;
                                } else {
                                    mgmtLog.log(Level.INFO, "Seems given dn format is not valid DN or logged user doesn't have to create new option, so Move to container option might be fail " + bl7);
                                }
                                if (((String)object9).equals("")) {
                                    object9 = StrUtil.getNameFromDN((String)object3);
                                }
                                if (!((String)object3).equals(string14 = "CN=" + (String)object9 + "," + (String)object12)) {
                                    object11 = string14;
                                    try {
                                        mgmtLog.log(Level.INFO, "Move container option selected - SourceDN " + (String)object3 + " Destination DN : " + (String)object12);
                                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)object3, (String)object12);
                                        bl4 = true;
                                        serializable2 = new ArrayList();
                                        if (object11 != null) {
                                            String string18 = DirectoryObjectUtil.getOUNameFromDN((String)object3);
                                            object10 = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + " : </B><br/>" + string18;
                                            string18 = DirectoryObjectUtil.getOUNameFromDN((String)object11);
                                            string13 = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + " : </B><br/>" + string18;
                                            ((ArrayList)serializable2).add(object10);
                                            ((ArrayList)serializable2).add(string13);
                                        }
                                        if (!((ArrayList)serializable2).isEmpty()) {
                                            Properties properties4 = new Properties();
                                            properties4.put("ATTRIB_LDAP_NAME", "container");
                                            properties4.put("ATTRIB_VALUE_COUNT", (Object)2L);
                                            properties4.put("ATTRIB_VALUE", serializable2);
                                            arrayList6.add(properties4);
                                        }
                                    }
                                    catch (LocalizedException localizedException) {
                                        localizedException.printStackTrace();
                                        StringBuilder stringBuilder = new StringBuilder();
                                        if (properties.getProperty("CREATION_MESSAGE") != null) {
                                            stringBuilder.append(properties.getProperty("CREATION_MESSAGE"));
                                            if (stringBuilder.length() > 0) {
                                                stringBuilder.append(" , ");
                                            }
                                        }
                                        stringBuilder.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_moving_objects"), localizedException.getMessage(this.rb)));
                                        properties.setProperty("CREATION_MESSAGE", stringBuilder.toString());
                                        properties.setProperty("CREATION_STATUS", "SEVERE");
                                        properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            } else {
                                mgmtLog.log(Level.INFO, "OUName is selected as toBeUpdateAttributeList but value might not be provided in csv file or HDT is not authorized to use this OU");
                                object11 = new StringBuilder();
                                if (properties.getProperty("CREATION_MESSAGE") != null) {
                                    ((StringBuilder)object11).append(properties.getProperty("CREATION_MESSAGE"));
                                    if (((StringBuilder)object11).length() > 0) {
                                        ((StringBuilder)object11).append(" , ");
                                    }
                                }
                                ((StringBuilder)object11).append(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_unauth_OU"));
                                properties.setProperty("CREATION_MESSAGE", ((StringBuilder)object11).toString());
                                properties.setProperty("CREATION_STATUS", "SEVERE");
                                properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                        }
                        if (bl4) {
                            bl2 = true;
                            object12 = new StringBuilder();
                            ((StringBuilder)object12).append(this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                            properties.setProperty("CREATION_STATUS", "SUCCESS");
                            properties.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            if (properties.getProperty("CREATION_MESSAGE") != null && properties.getProperty("CREATION_MESSAGE").length() > 0) {
                                properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                ((StringBuilder)object12).append(" , ");
                                ((StringBuilder)object12).append(properties.getProperty("CREATION_MESSAGE"));
                                properties.setProperty("CREATION_STATUS", "SEVERE");
                            }
                            properties.setProperty("CREATION_MESSAGE", ((StringBuilder)object12).toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        object72 = new StringBuilder();
                        if (properties.getProperty("CREATION_MESSAGE") != null) {
                            ((StringBuilder)object72).append(properties.getProperty("CREATION_MESSAGE"));
                            if (((StringBuilder)object72).length() > 0) {
                                ((StringBuilder)object72).append(" , ");
                            }
                        }
                        ((StringBuilder)object72).append(exception.getMessage());
                        properties.setProperty("CREATION_MESSAGE", ((StringBuilder)object72).toString());
                        properties.setProperty("CREATION_STATUS", "SEVERE");
                        properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                }
                properties.put("USER_INDEX", l);
                if (arrayList != null && !arrayList.isEmpty()) {
                    object = new Properties();
                    ((Properties)object).put("ATTRIB_LDAP_NAME", "memberOf");
                    ((Properties)object).put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    ((Properties)object).put("ATTRIB_VALUE_COUNT", (Object)2L);
                    ((Properties)object).put("ATTRIB_VALUE", arrayList);
                    arrayList6.add((Hashtable)object);
                }
                if (object2 != null && !((String)object2).equals("")) {
                    object = new Properties();
                    ((Properties)object).put("ATTRIB_LDAP_NAME", "password");
                    ((Properties)object).put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.password"));
                    ((Properties)object).put("ATTRIB_VALUE", object2);
                    arrayList6.add((Hashtable)object);
                }
                if (string4 != null && !string4.equals("")) {
                    object = new Properties();
                    ((Properties)object).put("ATTRIB_LDAP_NAME", "msExchArchiveDatabaseLink");
                    ((Properties)object).put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_database"));
                    ((Properties)object).put("ATTRIB_VALUE", string4);
                    arrayList6.add((Hashtable)object);
                }
                if (string3 != null && !string3.equals("")) {
                    object = new Properties();
                    ((Properties)object).put("ATTRIB_LDAP_NAME", "msExchArchiveAddress");
                    ((Properties)object).put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_domain"));
                    ((Properties)object).put("ATTRIB_VALUE", string3);
                    arrayList6.add((Hashtable)object);
                }
                if (arrayList != null && arrayList.isEmpty() && bl3) {
                    object = new Properties();
                    ((Properties)object).put("ATTRIB_LDAP_NAME", "memberOf");
                    ((Properties)object).put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    ((Properties)object).put("ATTRIB_VALUE", "");
                    arrayList6.add((Hashtable)object);
                }
                if (properties2 != null && !properties2.isEmpty()) {
                    object = new Properties();
                    if (properties2.containsKey("removeMemberOf")) {
                        ((Properties)object).put("ATTRIB_LDAP_NAME", "removeMemberOf");
                        ((Properties)object).put("ATTRIB_DISP_NAME", "admp.mgmt.user_mgmt.grp_attribs.input.remove_frm_grp");
                        object72 = (ArrayList)properties2.get("removeMemberOf");
                        if (((ArrayList)object72).contains("true")) {
                            ((Properties)object).put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            ((Properties)object).put("ATTRIB_VALUE", properties2.get("removeMemberOf").toString());
                        }
                        arrayList6.add((Hashtable)object);
                    }
                    object = new Properties();
                    if (properties2.containsKey("removeProxyAddresses")) {
                        ((Properties)object).put("ATTRIB_LDAP_NAME", "removeProxyAddresses");
                        ((Properties)object).put("ATTRIB_DISP_NAME", "admp.mgmt.csv_import.common.text.remove_proxy_addresses");
                        object72 = (ArrayList)properties2.get("removeProxyAddresses");
                        if (((ArrayList)object72).contains("true")) {
                            ((Properties)object).put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            ((Properties)object).put("ATTRIB_VALUE", properties2.get("removeProxyAddresses").toString());
                        }
                        arrayList6.add((Hashtable)object);
                    }
                }
                if (this.errorList != null && !this.errorList.isEmpty()) {
                    object = this.errorList.keySet();
                    object72 = "";
                    bl2 = true;
                    object6 = object.iterator();
                    while (object6.hasNext()) {
                        object5 = (String)object6.next();
                        object72 = (String)object72 + (String)this.errorList.get(object5);
                    }
                    object6 = MessageFormat.format(this.rb.getString("admp.mgmt.csv_import.common.statmsg.attributes_not_updated_successfully"), object);
                    object6 = (String)object6 + (String)object72;
                    properties.setProperty("CREATION_STATUS", "SEVERE");
                    properties.setProperty("CREATION_MESSAGE", (String)object6);
                    properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                if (properties.getProperty("CREATION_MESSAGE") == null) {
                    properties.setProperty("CREATION_STATUS", "SEVERE");
                    properties.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_on_attribute"));
                    properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                for (Object object72 : arrayList5) {
                    ((Hashtable)object72).put("ATTRIB_VALUE_COUNT", 1L);
                }
                TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.mgmtname.mod_user_csv"), string5, this.domainName, arrayList6, arrayList4, arrayList2, arrayList3, arrayList5, properties.getProperty("CREATION_MESSAGE"), (Long)hashtable3.get("object_id"), dataObject, this.rb);
                this.addRow(properties);
                break block130;
            }
            if (object2 == null) {
                object2 = "";
            }
            properties.setProperty("CREATION_STATUS", "WARNING");
            properties.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.statmsg.could_not_create_license_level_exceeded"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers")));
            properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            properties.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
            properties.put("USER_INDEX", l);
            properties.setProperty("userName", (String)object4);
            properties.setProperty("logonName", string2);
            properties.setProperty("password", (String)object2);
            this.addRow(properties);
        }
        object = DirectoryObjectUtil.getOUNameFromDN((String)object3);
        hashtable3.put("OUName", object);
        hashtable3.put("password", object2);
        hashtable3.put("manager", serializable);
        hashtable3.put("error_msg", properties.getProperty("CREATION_MESSAGE"));
        hashtable3.put("send_notification", bl2);
        mgmtLog.log(Level.INFO, "After User Creation");
    }

    protected void checkAndRemovePrimaryProxyAddr(Properties properties, Properties properties2) {
        try {
            ArrayList arrayList = (ArrayList)properties.get("removeProxyAddresses");
            ArrayList arrayList2 = (ArrayList)properties2.get("proxyAddresses");
            if (arrayList2 == null || arrayList2.isEmpty()) {
                return;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Object e : arrayList2) {
                String string = (String)e;
                if (string.contains("SMTP")) continue;
                for (Object e2 : arrayList) {
                    String string2 = (String)e2;
                    if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase("true")) continue;
                    arrayList3.add(string);
                }
            }
            properties.put("removeProxyAddresses", arrayList3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void removeUnAuthorizedGroups(Properties properties, Properties properties2, Long l, String string) {
        try {
            ArrayList arrayList = (ArrayList)properties2.get("memberOf");
            if (arrayList == null || arrayList.isEmpty()) {
                return;
            }
            ArrayList arrayList2 = new ArrayList();
            for (Object e : arrayList) {
                Hashtable hashtable = (Hashtable)e;
                arrayList2.add(hashtable.get("distinguishedName"));
            }
            ArrayList arrayList3 = GroupHandler.getUnAuthorisedGroups((String)string, (Long)l, arrayList2);
            if (arrayList3 != null && !arrayList3.isEmpty()) {
                arrayList2.removeAll(arrayList3);
                properties.put("removeMemberOf", arrayList2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void checkRemovePropsSelected(Properties properties) {
        if (this.validSelected != null) {
            boolean bl = false;
            if (properties.containsKey("removeMemberOf")) {
                for (String string : this.validSelected) {
                    if (!string.equalsIgnoreCase("removeMemberOf")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    properties.remove("removeMemberOf");
                }
            }
            bl = false;
            if (properties.containsKey("removeProxyAddresses")) {
                for (String string : this.validSelected) {
                    if (!string.equalsIgnoreCase("removeProxyAddresses")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    properties.remove("removeProxyAddresses");
                }
            }
        }
    }

    protected void fillProxyAddrMacroValues(Properties properties, ArrayList arrayList, String string, String string2, ArrayList arrayList2) {
        try {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList arrayList4 = (ArrayList)properties.get("removeProxyAddresses");
            if (arrayList4 == null || arrayList4.isEmpty()) {
                return;
            }
            for (Object e : arrayList4) {
                String string3 = (String)e;
                if (string3.equalsIgnoreCase("true")) {
                    arrayList3.add("true");
                    continue;
                }
                String string4 = FormatClientUtil.getFormatValue(this.domainName, string3, arrayList, string, string2, arrayList2);
                arrayList3.add(string4);
            }
            properties.put("removeProxyAddresses", arrayList3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeUnAuthorizedProps(ArrayList arrayList) throws Exception {
        if (this.validSelected != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String object : this.validSelected) {
                arrayList2.add(object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Hashtable hashtable = (Hashtable)arrayList.get(i);
                String string = (String)hashtable.get("ATTRIB_LDAP_NAME");
                if (arrayList2.contains(string)) {
                    Long l = (Long)hashtable.get("MODIFY_ID");
                    if (this.isWorkflowMode || l == null || ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)l)) continue;
                    throw new Exception(this.rb.getString("client.csv.CSVUserListener.the_attribute") + " " + string + " " + this.rb.getString("client.csv.CSVUserListener.is_not_authorized_for_this_user"));
                }
                mgmtLog.log(Level.INFO, "Unchecked Attribute in proplist : " + string);
                arrayList.remove(i);
                --i;
            }
        }
    }

    @Override
    public void addRow(Properties properties) {
        AddUserHandler.getInstance().updateCreationStatus(this.rb, properties);
        this.updateUI(properties);
    }

    protected void updateOutList() {
        if (this.updateList.size() > 0) {
            mgmtLog.log(Level.INFO, "Modify CSV Update Count : " + this.updateList.size());
            for (int i = 0; i < this.updateList.size() && i < 25; ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    private void updateUI(Properties properties) {
        Long l = (Long)properties.get("USER_INDEX");
        ++this.updatedCount;
        String string = "<script> updateUI('" + l.toString() + "','" + properties.getProperty("CREATION_MESSAGE") + "','" + properties.getProperty("CREATION_STATUS") + "')</script>";
        if (this.out != null && !this.out.checkError() && !this.isCompleted) {
            this.updateOutList();
            if (this.updatedCount <= 25) {
                this.out.write(string);
            }
            this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            this.out.flush();
        } else {
            this.updateList.add(string);
        }
    }

    protected void reloadUI() {
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='CSVUserModification.do?methodToCall=bulkUser&selectedTab=admin&operation=ShowResult'</script>");
                this.out.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void controlUI(PrintWriter printWriter) {
        if (this.isCompleted) {
            return;
        }
        this.out = printWriter;
        while (!this.isCompleted) {
            try {
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred_message"), exception.getMessage()));
            }
        }
        boolean bl = true;
        try {
            if (this.out == null || this.out.checkError() || !this.isCompleted) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        if (bl) {
            try {
                this.updateOutList();
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.reloadUI();
        this.out = null;
    }

    public Properties getBulkUserErrorMessage(String string, String string2, ArrayList arrayList, NativeError nativeError, String string3, String string4) {
        Object object;
        Properties properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = null;
        String string6 = null;
        Hashtable hashtable = nativeError.getErrors();
        if (hashtable != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string7 = (String)object.nextElement();
                string5 = nativeError.getErrorMessage((Object)string7, this.rb);
                string6 = nativeError.getSeverityLevel((Object)string7);
                if (string6 != null && string6.equals("SEVERE")) {
                    properties.setProperty("CREATION_STATUS", string6);
                    properties.setProperty("CREATION_MESSAGE", string5);
                    properties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    properties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    return properties;
                }
                stringBuilder.append(string5);
            }
        }
        if (this.invalidGroups != null && this.invalidGroups.size() != 0) {
            object = new StringBuilder();
            for (int i = 0; i < this.invalidGroups.size(); ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append((String)this.invalidGroups.get(i));
            }
            stringBuilder.append(" " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_invalid_groups"), ((StringBuilder)object).toString()));
        }
        if (stringBuilder.length() > 0) {
            properties.setProperty("CREATION_STATUS", "WARNING");
            properties.setProperty("CREATION_MESSAGE", stringBuilder.toString());
            properties.setProperty("CREATION_IMAGE", "/images/alert.gif");
            properties.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return properties;
        }
        properties.setProperty("CREATION_STATUS", "SUCCESS");
        properties.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
        properties.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return properties;
    }

    protected boolean checkSelected(String string) {
        boolean bl = false;
        if (this.validSelected != null) {
            for (int i = 0; i < this.validSelected.length; ++i) {
                if (!string.equalsIgnoreCase(this.validSelected[i])) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected boolean canUpdate(String string) {
        if (this.validSelectedValues != null) {
            for (int i = 0; i < this.validSelectedValues.length; ++i) {
                if (!this.validSelectedValues[i].equalsIgnoreCase(string)) continue;
                return false;
            }
        }
        return true;
    }

    protected void sendSysLogs(Hashtable hashtable, Integer n, String string, String string2, AdventNetResourceBundle adventNetResourceBundle) {
        try {
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            ArrayList arrayList4;
            DataObject dataObject = CategoryHandler.getReportDetails((Integer)n);
            Long l = (Long)dataObject.getFirstRow("ADSMReports").get("ACTION_ID");
            Properties properties = HDTAuditUtil.getActionDetails((Long)l);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ACTION", (Object)adventNetResourceBundle.getString((String)properties.get("ACTION_CATEGORY")));
            jSONObject.put(adventNetResourceBundle.getString("admp.mgmt.common.text.task"), (Object)adventNetResourceBundle.getString((String)properties.get("ACTION_NAME")));
            jSONObject.put(string2, hashtable.get("userName"));
            jSONObject.put(adventNetResourceBundle.getString("admp.mgmt.common.text.domain_name"), hashtable.get("domainName"));
            ArrayList arrayList5 = (ArrayList)hashtable.get("groupList");
            if (!arrayList5.isEmpty()) {
                jSONObject.put("memberOf", (Object)arrayList5);
            }
            String string3 = "";
            String string4 = "";
            ArrayList arrayList6 = (ArrayList)hashtable.get("propList");
            if (arrayList6 != null) {
                for (int i = 0; i < arrayList6.size(); ++i) {
                    Hashtable hashtable2 = (Hashtable)arrayList6.get(i);
                    string3 = hashtable2.get("ATTRIB_LDAP_NAME").toString();
                    string4 = hashtable2.get("ATTRIB_VALUE").toString();
                    if (string3.equalsIgnoreCase("password")) {
                        string4 = "********";
                    } else {
                        string4 = CommonUtil.htmlEscapeForAuditReport((String)string4);
                        string4 = CommonUtil.htmlDeEscape((String)string4);
                    }
                    jSONObject.put(string3, (Object)string4);
                }
            }
            if ((arrayList4 = (ArrayList)hashtable.get("modifyList")) != null) {
                for (int i = 0; i < arrayList4.size(); ++i) {
                    Hashtable hashtable3 = (Hashtable)arrayList4.get(i);
                    string3 = hashtable3.get("ATTRIB_LDAP_NAME").toString();
                    string4 = hashtable3.get("ATTRIB_VALUE").toString();
                    string4 = CommonUtil.htmlEscapeForAuditReport((String)string4);
                    string4 = CommonUtil.htmlDeEscape((String)string4);
                    jSONObject.put(string3, (Object)string4);
                }
            }
            if ((arrayList3 = (ArrayList)hashtable.get("winNTAttributeList")) != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    Hashtable hashtable4 = (Hashtable)arrayList3.get(i);
                    string3 = hashtable4.get("ATTRIB_LDAP_NAME").toString();
                    string4 = hashtable4.get("ATTRIB_VALUE").toString();
                    string4 = CommonUtil.htmlEscapeForAuditReport((String)string4);
                    string4 = CommonUtil.htmlDeEscape((String)string4);
                    jSONObject.put(string3, (Object)string4);
                }
            }
            if ((arrayList2 = (ArrayList)hashtable.get("tsList")) != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    Hashtable hashtable5 = (Hashtable)arrayList2.get(i);
                    string3 = hashtable5.get("ATTRIB_LDAP_NAME").toString();
                    string4 = hashtable5.get("ATTRIB_VALUE").toString();
                    string4 = CommonUtil.htmlEscapeForAuditReport((String)string4);
                    string4 = CommonUtil.htmlDeEscape((String)string4);
                    jSONObject.put(string3, (Object)string4);
                }
            }
            if ((arrayList = (ArrayList)hashtable.get("customList")) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Hashtable hashtable6 = (Hashtable)arrayList.get(i);
                    string3 = hashtable6.get("ATTRIB_LDAP_NAME").toString();
                    string4 = hashtable6.get("ATTRIB_VALUE").toString();
                    string4 = CommonUtil.htmlEscapeForAuditReport((String)string4);
                    string4 = CommonUtil.htmlDeEscape((String)string4);
                    jSONObject.put(string3, (Object)string4);
                }
            }
            if (string.contains(adventNetResourceBundle.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"))) {
                string = string.replace(adventNetResourceBundle.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"), "");
            }
            jSONObject.put(adventNetResourceBundle.getString("admp.common.text.status"), (Object)string);
            if (hashtable.get("technicianName") != null) {
                jSONObject.put("TechnicianName", hashtable.get("technicianName"));
            } else {
                jSONObject.put("TechnicianName", (Object)"");
            }
            LogForwarderAPI.getInstance().sendMessage(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void triggerNotification(DataObject dataObject, ArrayList<Long> arrayList, Integer n, Hashtable hashtable, Long l, Integer n2, String string, AdventNetResourceBundle adventNetResourceBundle, ArrayList arrayList2, ArrayList arrayList3) {
        MgmtNotificationListener mgmtNotificationListener = new MgmtNotificationListener();
        mgmtNotificationListener.triggerNotification(dataObject, arrayList, n, hashtable, l, n2, string, adventNetResourceBundle, arrayList2, this.requestId, arrayList3);
    }

    private class Action
    extends Thread {
        private CSVUserListener modifyUserListener;
        private String hostId;
        private Integer objectId;

        public Action(CSVUserListener cSVUserListener2, String string) {
            this.modifyUserListener = cSVUserListener2;
            this.hostId = string;
            this.objectId = cSVUserListener2 instanceof CSVComputerListener ? Integer.valueOf(3) : (cSVUserListener2 instanceof CSVContactListener ? Integer.valueOf(4) : (cSVUserListener2 instanceof CSVGroupListener ? Integer.valueOf(2) : (cSVUserListener2 instanceof CSVOUListener ? Integer.valueOf(5) : Integer.valueOf(1))));
        }

        @Override
        public void run() {
            try {
                Long l;
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                String string = "";
                boolean bl = false;
                if (CSVUserListener.this.isWorkflowMode && CSVUserListener.this.requestId != null) {
                    l = WorkFlowUtil.getWorkFlowType((Long)CSVUserListener.this.requestId);
                    if (l == 2L) {
                        string = CSVUserListener.this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request");
                        bl = true;
                    } else {
                        string = l == 1L ? CSVUserListener.this.rb.getString("admp.auto.automation.heading.automation") : (l == 0L ? CSVUserListener.this.rb.getString("admp.home.feature.heading.workflow") : "");
                    }
                }
                l = -1L;
                l = bl ? HDTAuditUtil.fillAuditDetails((Long)CSVUserListener.this.loginId, (String)this.hostId, (Integer)CSVUserListener.this.reportId, (DataObject)dataObject, (AdventNetResourceBundle)CSVUserListener.this.rb, (String)string, (Long)CSVUserListener.this.requestId) : HDTAuditUtil.fillAuditDetails((Long)CSVUserListener.this.loginId, (String)this.hostId, (Integer)CSVUserListener.this.reportId, (DataObject)dataObject, (AdventNetResourceBundle)CSVUserListener.this.rb, (String)string);
                boolean bl2 = CommonUtil.isLicenseExceeded((String)"userMgmt");
                Properties properties = HDTDomainHandler.getConfiguredValues((String)CSVUserListener.this.domainName, (Long)CSVUserListener.this.loginId);
                String string2 = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Hashtable hashtable = AddUserHandler.getInstance().getCustomAttributesList(CSVUserListener.this.userCreationID);
                Hashtable hashtable2 = new Hashtable();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (Object object : CSVUserListener.this.userDetailsList) {
                    if (CSVUserListener.this.stop) continue;
                    Hashtable<String, Long> hashtable3 = new Hashtable<String, Long>();
                    hashtable3.put("audit_id", l);
                    CSVUserListener.this.modifyObject(string2, (Hashtable)object, hashtable, bl2, hashtable3, dataObject);
                    HDTAuditUtil.fillAuditObjectStatus(hashtable3, (DataObject)dataObject);
                    String string3 = hashtable3.get("error_msg") != null ? hashtable3.get("error_msg").toString().toLowerCase() : "";
                    boolean bl3 = (Boolean)hashtable3.get("send_notification");
                    if (bl3) {
                        arrayList.add((Long)hashtable3.get("object_id"));
                    }
                    Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                    hashtable4.put("password", hashtable3.get("password") != null ? (String)hashtable3.get("password") : "");
                    hashtable4.put("manager", hashtable3.get("manager") != null ? (String)hashtable3.get("manager") : "");
                    hashtable2.put(hashtable3.get("objectName"), hashtable4);
                    String string4 = (String)hashtable3.get("OUName");
                    if (arrayList2.contains(string4)) continue;
                    arrayList2.add(string4);
                }
                CSVUserListener.this.performADSync();
                boolean bl4 = PasswordUtil.getSavePasswordValue();
                if (!bl4) {
                    if (CSVUserListener.this.csvHasPwd) {
                        Object object;
                        AddUserHandler.getInstance();
                        object = AddUserHandler.createBulkUserLayoutTempTable((Long)CSVUserListener.this.userCreationID);
                        AddUserHandler.getInstance();
                        AddUserHandler.copyIntoBulkUserLayoutTempTable((Long)CSVUserListener.this.userCreationID, null, (String)object);
                    }
                    AddUserHandler.getInstance();
                    AddUserHandler.clearPwdForBUM((Long)CSVUserListener.this.userCreationID);
                }
                this.modifyUserListener.isCompleted = true;
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                if (arrayList.size() > 0) {
                    CSVUserListener.this.triggerNotification(dataObject, arrayList, this.objectId, hashtable2, CSVUserListener.this.loginId, CSVUserListener.this.reportId, CSVUserListener.this.domainName, CSVUserListener.this.rb, this.modifyUserListener.resultAttributeList, arrayList2);
                }
            }
            catch (Exception exception) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + exception.getMessage());
                this.modifyUserListener.isCompleted = true;
                this.modifyUserListener.errorMessage = exception.getMessage();
                exception.printStackTrace();
            }
        }
    }
}

