/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserAction;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserBean;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserAttributeHandler;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ModifyUserAction
extends CSVUserAction {
    Logger out = Logger.getLogger("ADMangLogger");

    public ActionForward singleModify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forward = "modifySingleUser";
        String message = "";
        Hashtable<String, Object> logProps = new Hashtable<String, Object>();
        try {
            HttpSession session = request.getSession();
            CSVUserBean bean = (CSVUserBean)form;
            String domainName = request.getParameter("domainName");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            Properties properties = null;
            if (domainName == null) {
                properties = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = properties.getProperty("DOMAIN_NAME");
            } else {
                properties = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            logProps.put("domainName", domainName);
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList primaryGroupList = UserMgmtUtil.getGroupList((Long)loginId, (String)defaultNamingContext);
            session.setAttribute("userCreationGroupList", (Object)primaryGroupList);
            request.setAttribute("type", (Object)"singleModify");
            boolean updateBean = false;
            if (request.getParameter("Update User") != null) {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6008, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                Properties prop = new Properties();
                CSVUserBean bmBean = (CSVUserBean)((Object)session.getAttribute("CLONE_BEAN"));
                String updateDN = (String)session.getAttribute("updateDN");
                bean.initSecurity(request, "singleModify", domainName);
                bean.setCheckPrivilege(true);
                bean.saveUserDetails(request, "modify");
                AddUserClientUtil.setAccountProperties(bean, domainName);
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Hashtable domainVsIds = authObject.getDomainActionMap();
                Long[] ids = authObject.getActionArray();
                ArrayList userDetailsList = AddUserClientUtil.getUpdatedBean(bean, bmBean, updateDN, "singleModify", domainName, domainVsIds);
                CSVUserListener listener = (CSVUserListener)bean.getListener();
                if (listener == null) {
                    bean.initListener((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID"), ids, domainVsIds, primaryGroupList, request);
                    listener = (CSVUserListener)bean.getListener();
                }
                bean.setCustomAttributes(request);
                ArrayList customList = this.getCustomAttributeList(domainName, bean);
                for (Hashtable hashtable : userDetailsList) {
                    String mailServer;
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    listener.getProperties("modify", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "User");
                    String searchDN = updateDN;
                    updateDN = CommonUtil.escapeSpecialCharacters((String)updateDN);
                    String searchString = "(&(objectClass=user)(objectCategory=user)(distinguishedName=" + updateDN + "))";
                    String distinguishedName = "";
                    if (props.get("distinguishedName") != null) {
                        distinguishedName = props.getProperty("distinguishedName");
                    }
                    String userName = "";
                    if (props.get("userName") != null) {
                        userName = props.getProperty("userName");
                    }
                    String samAccountName = this.getObjectString(updateDN, properties, "sAMAccountName");
                    String password = null;
                    if (props.get("password") != null) {
                        password = props.getProperty("password");
                    }
                    String remoteHomeDir = "";
                    if (props.get("remoteHomeDir") != null) {
                        remoteHomeDir = props.getProperty("remoteHomeDir");
                    }
                    String tsRemoteHomeDir = "";
                    if (props.get("tsRemoteHomeDir") != null) {
                        tsRemoteHomeDir = props.getProperty("tsRemoteHomeDir");
                    }
                    boolean updatePolicy = false;
                    if (props.get("msExchPoliciesIncluded") != null && props.get("msExchPoliciesIncluded").equals("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}") && (mailServer = (String)bean.get("MAIL_SERVER")) != null && ExchangeUtil.checkExchange2007((String)mailServer)) {
                        Hashtable<String, Object> msExchPoliciesIncluded = new Hashtable<String, Object>();
                        msExchPoliciesIncluded.put("ATTRIB_LDAP_NAME", "msExchPoliciesIncluded");
                        msExchPoliciesIncluded.put("ATTRIB_VALUE", "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
                        msExchPoliciesIncluded.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        msExchPoliciesIncluded.put("DATA_HANDLER_TYPE", new Long(3L));
                        propList.add(msExchPoliciesIncluded);
                        updatePolicy = true;
                    }
                    String hideAddressBook = (String)props.get("msExchHideFromAddressLists");
                    String recipientType = (String)bean.get("mailEnabled");
                    boolean ex2007 = false;
                    String mailServer2 = (String)bean.get("MAIL_SERVER");
                    String adminGroup = (String)bean.get("MS_EXCH_ADMIN_GROUP");
                    System.out.println("Admin Group :: " + adminGroup);
                    if (mailServer2 != null && ExchangeUtil.checkExchange2007((String)mailServer2) || adminGroup != null && ExchangeUtil.checkExchangeGroup2007((String)adminGroup)) {
                        ex2007 = true;
                    }
                    logProps.put("SAM Account Name", samAccountName);
                    logProps.put("DistinguihedName", updateDN);
                    logProps.put("propList", propList);
                    logProps.put("tsList", tsList);
                    if (groupList != null) {
                        logProps.put("groupList", groupList);
                    }
                    logProps.put("modifyList", modifyList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)samAccountName, (String)domainName, (DataObject)auditDataObj);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    audit_info.put("object_id", object_id);
                    ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
                    NativeError error = null;
                    String CREATION_STATUS = null;
                    Properties exchangeServerDetails = new Properties();
                    if (mailServer2 != null) {
                        exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer2);
                    } else if (adminGroup != null) {
                        exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)domainName, (String)adminGroup, (Long)loginId);
                    }
                    if (ouList == null || ouList.size() == 0) {
                        error = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)updateDN), (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, (boolean)false);
                        prop = AddUserErrorHandler.getSingleUserErrorMessage((AdventNetResourceBundle)rb, (String)domainName, (String)searchString, (String)samAccountName, (String)distinguishedName, groupList, (NativeError)error, (String)rb.getString("admp.reports.common.status_msg.successfully_updated"));
                        if (!customList.isEmpty()) {
                            NativeError customError = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)updateDN), null, (ArrayList)customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                            AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)rb, (Properties)prop, (NativeError)customError, (String)searchString);
                        }
                        CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        if (updatePolicy && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            ADHandler.updateEmailPolicy((String)domainName, (long)loginId, (String)distinguishedName, (Properties)exchangeServerDetails);
                        }
                        if (hideAddressBook != null && ex2007 && hideAddressBook.equalsIgnoreCase("false")) {
                            ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails);
                        }
                    } else {
                        for (int i = 0; i < ouList.size(); ++i) {
                            String dn = ((String)ouList.get(i)).toLowerCase();
                            String s = searchDN.toLowerCase();
                            if (!s.endsWith(dn)) continue;
                            error = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)((String)ouList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)updateDN), (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, (boolean)false);
                            prop = AddUserErrorHandler.getSingleUserErrorMessage((AdventNetResourceBundle)rb, (String)domainName, (String)searchString, (String)samAccountName, (String)distinguishedName, groupList, (NativeError)error, (String)rb.getString("admp.reports.common.status_msg.successfully_updated"));
                            if (!customList.isEmpty()) {
                                NativeError customError = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)((String)ouList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)updateDN), null, (ArrayList)customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)rb, (Properties)prop, (NativeError)customError, (String)searchString);
                            }
                            CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                            if (updatePolicy && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                                ADHandler.updateEmailPolicy((String)domainName, (long)loginId, (String)distinguishedName, (Properties)exchangeServerDetails);
                            }
                            if (hideAddressBook != null && ex2007 && hideAddressBook.equalsIgnoreCase("false")) {
                                ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails);
                            }
                            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !CREATION_STATUS.equalsIgnoreCase("WARNING")) break;
                        }
                    }
                    if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && !CREATION_STATUS.equalsIgnoreCase("WARNING") && distinguishedName != null) {
                        NativeError nativeError;
                        ArrayList bmList = (ArrayList)bmBean.get("MEMBER_OF");
                        ArrayList amList = (ArrayList)bean.get("MEMBER_OF");
                        ArrayList memberList = new ArrayList();
                        ArrayList<String> removeList = new ArrayList<String>();
                        for (int i = 0; i < bmList.size(); ++i) {
                            if (amList.contains(bmList.get(i))) continue;
                            memberList.add(bmList.get(i));
                        }
                        String primaryGroupId = (String)bean.get("PRIMARY_GROUP_ID");
                        if (memberList != null && !memberList.isEmpty()) {
                            for (Object object : memberList) {
                                Properties proper = (Properties)object;
                                String objectRID = proper.getProperty("objectRID");
                                String remGrpDistinguishedName = proper.getProperty("Distinguished_Name");
                                if (objectRID.equals(primaryGroupId)) continue;
                                groupList.add(remGrpDistinguishedName);
                                removeList.add(objectRID);
                            }
                            if (removeList != null && !removeList.isEmpty()) {
                                ArrayList<Properties> list = new ArrayList<Properties>();
                                Properties p = new Properties();
                                p.put("ATTRIB_VALUE", distinguishedName);
                                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                p.put("DATA_HANDLER_TYPE", new Long(3L));
                                p.put("ATTRIB_LDAP_NAME", "member");
                                p.put("DW_CONTROL_CODE", new Long(4L));
                                list.add(p);
                                for (int i = 0; i < removeList.size(); ++i) {
                                    String groupSid = UserMgmtUtil.getGroupSIDfromRID((String)((String)removeList.get(i)), (ArrayList)primaryGroupList);
                                    this.out.log(Level.INFO, "Removing User from the Group : " + groupSid);
                                    if (groupSid == null) continue;
                                    try {
                                        ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)groupSid, (String)distinguishedName, list, null);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        Properties PRIMARY_GROUP = (Properties)bean.get("PRIMARY_GROUP");
                        amList.add(PRIMARY_GROUP);
                        bean.set("MEMBER_OF", amList);
                        bean.set("proxyAddress", bean.get("EMAIL_PROXY_ADDRESSES"));
                        if (userName != null && !userName.equals("")) {
                            this.out.log(Level.INFO, "Modifying Name Attribute :" + userName + " for the User : " + distinguishedName);
                            ADHandlerForMgmt.modifyUserFullName((String)domainName, (Long)loginId, (String)distinguishedName, (String)userName, null);
                        }
                        ArrayList<Properties> aceList = new ArrayList<Properties>();
                        Properties ps = new Properties();
                        ps.put("ACCESS_MASK", new Long(0x1F01FFL));
                        ps.put("ACE_TYPE", new Long(0L));
                        ps.put("INHERIT_TYPE_FLAG", new Long(3L));
                        ps.put("DN", updateDN);
                        aceList.add(ps);
                        if (!remoteHomeDir.equals("") && remoteHomeDir.startsWith("\\")) {
                            try {
                                nativeError = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)remoteHomeDir, null, (String)distinguishedName, aceList, (long)0x20000000L);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)prop, (NativeError)nativeError, (String)"homeDir");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!tsRemoteHomeDir.equals("") && tsRemoteHomeDir.startsWith("\\")) {
                            try {
                                nativeError = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)tsRemoteHomeDir, null, (String)distinguishedName, aceList, (long)0x20000000L);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)prop, (NativeError)nativeError, (String)"tsHomeDir");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    request.setAttribute("password", (Object)password);
                    if (groupList != null && !groupList.isEmpty()) {
                        Properties grpList = new Properties();
                        grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                        grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                        grpList.put("ATTRIB_VALUE", groupList);
                        propList.add(grpList);
                    }
                    if (userName != null && !userName.equals("")) {
                        Properties nameList = new Properties();
                        nameList.put("ATTRIB_LDAP_NAME", "name");
                        nameList.put("ATTRIB_VALUE", userName);
                        propList.add(nameList);
                    }
                    if (password != null) {
                        Properties pwdProps = new Properties();
                        pwdProps.put("ATTRIB_LDAP_NAME", "password");
                        pwdProps.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.password"));
                        pwdProps.put("ATTRIB_VALUE", password);
                        propList.add(pwdProps);
                    }
                    System.out.println("Single user modification error prop: " + prop);
                    TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.mod_sing_user.mgmtname.mod_sing_user"), samAccountName, domainName, propList, modifyList, winNTAttributeList, tsList, null, prop.getProperty("STATUS_MESSAGE"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                    String status = prop.getProperty("STATUS_MESSAGE");
                    ArrayList creationMsg = (ArrayList)prop.get("CREATION_MESSAGE");
                    if (creationMsg != null && !creationMsg.isEmpty()) {
                        for (int i = 0; i < creationMsg.size(); ++i) {
                            Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                            status = rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + creationMessage.get("ERROR_CODE") + " : " + rb.getString((String)creationMessage.get("ERROR_MESSAGE")) + creationMessage.get("NATIVE_ERROR_MESSAGE");
                        }
                    }
                    audit_info.put("error_msg", status);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                }
                String LOGON_NAME = (String)bean.get("LOGON_NAME");
                String upnPrefix = "";
                String upnSuffix = "";
                int dnsNameIndex = LOGON_NAME.lastIndexOf("@");
                if (dnsNameIndex > 0) {
                    upnPrefix = LOGON_NAME.substring(0, dnsNameIndex);
                    upnSuffix = LOGON_NAME.substring(dnsNameIndex + 1);
                } else {
                    upnPrefix = LOGON_NAME;
                    upnSuffix = properties.getProperty("DOMAIN_DNS_NAME");
                }
                bean.set("LOGON_NAME", upnPrefix, false);
                bean.set("UPN_SUFFIX", upnSuffix);
                request.setAttribute("statusProps", (Object)prop);
                String CREATION_STATUS = (String)prop.get("CREATION_STATUS");
                if (CREATION_STATUS != null && CREATION_STATUS.equalsIgnoreCase("SUCCESS")) {
                    updateBean = true;
                }
            } else {
                String guid = request.getParameter("guid");
                if (guid != null) {
                    ArrayList valueList;
                    Object value;
                    int index;
                    ArrayList valueList2;
                    ArrayList objectList;
                    updateBean = true;
                    bean.initialize(mapping);
                    bean.setCheckPrivilege(false);
                    Row r = DirectoryObjectAPI.getInstance().getUserObject(guid);
                    String distinguishedName = null;
                    String objectName = null;
                    if (r != null) {
                        distinguishedName = (String)r.get("DISTINGUISHED_NAME");
                        objectName = (String)r.get("SAM_ACCOUNT_NAME");
                    }
                    guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    String bindString = "";
                    bindString = distinguishedName == null ? "<GUID=" + guid + ">" : distinguishedName;
                    ArrayList<String> attrList = new ArrayList<String>();
                    ArrayList userList = AddUserHandler.getInstance().getAttributeDetailsFromDB();
                    for (Hashtable hash : userList) {
                        attrList.add((String)hash.get("ATTRIB_LDAP_NAME"));
                    }
                    Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userModification");
                    if (customAttribProp.size() > 0) {
                        String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
                        for (int i = 0; i < customLdapNames.length; ++i) {
                            attrList.add(customLdapNames[i]);
                        }
                    }
                    attrList.add("legacyExchangeDN");
                    Properties userDetails = ADHandler.getObjectProperties((String)domainName, (Long)loginId, (String)bindString, attrList);
                    ArrayList<String> tslist = new ArrayList<String>();
                    tslist.add("TerminalService");
                    Properties tsDetails = ADHandler.getUserTerminalObjects((String)domainName, (Long)loginId, (String)guid, tslist);
                    this.out.log(Level.INFO, "Terminal Properties : " + tsDetails);
                    if (tsDetails != null) {
                        userDetails.putAll((Map<?, ?>)((Properties)tsDetails.get("TerminalService")));
                    }
                    if ((objectList = (ArrayList)userDetails.get("objectSid")) == null) {
                        objectList = (ArrayList)userDetails.get("objectSID");
                    }
                    String objectSID = (String)objectList.get(0);
                    session.setAttribute("objectSID", (Object)objectSID);
                    this.out.log(Level.INFO, "Property Values are : " + userDetails);
                    if (objectName == null && (valueList2 = (ArrayList)userDetails.get("sAMAccountName")) != null) {
                        objectName = (String)valueList2.get(0);
                    }
                    if (distinguishedName == null && (valueList2 = (ArrayList)userDetails.get("distinguishedName")) != null) {
                        distinguishedName = (String)valueList2.get(0);
                    }
                    ArrayList legacyDNList = (ArrayList)userDetails.get("legacyExchangeDN");
                    String legacyDN = "";
                    if (legacyDNList != null) {
                        legacyDN = (String)legacyDNList.get(0);
                    }
                    if ((index = legacyDN.toLowerCase().lastIndexOf("/cn=recipients/cn=")) != -1) {
                        legacyDN = legacyDN.substring(0, index);
                    }
                    bean.set("MS_EXCH_ADMIN_GROUP", legacyDN);
                    session.setAttribute("updateDN", (Object)distinguishedName);
                    boolean userCannotChangePassword = ADHandlerForMgmt.checkCantChangePassword((String)domainName, (Long)loginId, (String)objectName, (String)distinguishedName);
                    if (userCannotChangePassword) {
                        bean.set("USER_CANT_CHANGE_PWD", userCannotChangePassword);
                        bean.set("USER_FLAGS", 64);
                    }
                    String mailEnabled = "no";
                    String mailNickName = null;
                    String targetAddress = null;
                    String homeMDB = null;
                    for (Hashtable hash : userList) {
                        ArrayList valueList3;
                        String column = (String)hash.get("ATTRIB_COLUMN_NAME");
                        if (!column.equals("MAIL_ALIAS") && !column.equals("ME_MAIL_ALIAS") && !column.equals("TARGET_ADDRESS") && !column.equals("MAIL_BOX_STORE") || (valueList3 = (ArrayList)userDetails.get((String)hash.get("ATTRIB_LDAP_NAME"))) == null || valueList3.isEmpty()) continue;
                        if (column.equals("MAIL_ALIAS") || column.equals("ME_MAIL_ALIAS")) {
                            mailNickName = (String)valueList3.get(0);
                            continue;
                        }
                        if (column.equals("TARGET_ADDRESS")) {
                            targetAddress = (String)valueList3.get(0);
                            continue;
                        }
                        if (!column.equals("MAIL_BOX_STORE")) continue;
                        homeMDB = (String)valueList3.get(0);
                    }
                    if (mailNickName != null && targetAddress != null) {
                        mailEnabled = "mail";
                    } else if (mailNickName != null && homeMDB != null) {
                        mailEnabled = "mailBox";
                    }
                    bean.set("mailEnabled", mailEnabled);
                    this.out.log(Level.INFO, "Mail Enabled Action : " + mailEnabled);
                    Set extendedLdapList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_COLUMN_NAME");
                    for (Hashtable hash : userList) {
                        String column = (String)hash.get("ATTRIB_COLUMN_NAME");
                        Integer attribId = (Integer)hash.get("ATTRIB_ID");
                        if (column.equalsIgnoreCase("DISTINGUISHED_NAME") || column.equalsIgnoreCase("OBJECT_GUID")) continue;
                        Integer relationalType = (Integer)hash.get("RELATIONAL_TYPE");
                        value = "-";
                        valueList = null;
                        if (relationalType.equals(1)) {
                            valueList = (ArrayList)userDetails.get((String)hash.get("ATTRIB_LDAP_NAME"));
                            UserAttributeHandler.modifyMultipleValuedAttributes(bean, domainName, loginId, column, valueList, primaryGroupList, mailEnabled);
                            continue;
                        }
                        if (column.startsWith("TS_")) {
                            value = userDetails.get((String)hash.get("ATTRIB_LDAP_NAME"));
                            if (value == null || value.equals("")) continue;
                            UserAttributeHandler.modifySingleValuedAttributes(bean, domainName, column, value, mailEnabled);
                            continue;
                        }
                        if (extendedLdapList.contains(column)) {
                            valueList = (ArrayList)userDetails.get((String)hash.get("ATTRIB_LDAP_NAME"));
                            if (valueList == null || valueList.isEmpty()) continue;
                            value = valueList.get(0);
                            UserAttributeHandler.modifySingleValuedAttributes(bean, domainName, column, value, mailEnabled);
                            continue;
                        }
                        if (hash.get("MODIFY_ID") == null || (Long)hash.get("MODIFY_ID") >= 1600L || (valueList = (ArrayList)userDetails.get((String)hash.get("ATTRIB_LDAP_NAME"))) == null || valueList.isEmpty()) continue;
                        value = valueList.get(0);
                        UserAttributeHandler.modifySingleValuedAttributes(bean, domainName, column, value, mailEnabled);
                    }
                    UserAttributeHandler.modifyGeneralValuedAttributes(request, bean, domainName, loginId, properties, primaryGroupList);
                    if (customAttribProp.size() > 0) {
                        String[] customDisplayNames = (String[])customAttribProp.get("customAttribDisplayName");
                        String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
                        String[] customDataTypes = (String[])customAttribProp.get("customAttribDataType");
                        String[] customLdapValues = new String[customDisplayNames.length];
                        for (int i = 0; i < customDisplayNames.length; ++i) {
                            value = "";
                            if (customLdapNames[i].startsWith("ts")) {
                                value = (String)userDetails.get(customLdapNames[i]);
                            } else {
                                valueList = (ArrayList)userDetails.get(customLdapNames[i]);
                                if (valueList != null && !valueList.isEmpty()) {
                                    value = (String)valueList.get(0);
                                    if (customDataTypes[i].equalsIgnoreCase("boolean")) {
                                        value = AddUserClientUtil.getBooleanValue((String)value).toString().toUpperCase();
                                    }
                                }
                            }
                            customLdapValues[i] = value;
                        }
                        bean.set("CUSTOM_ATTRIB_DISPLAY_NAME", customDisplayNames);
                        bean.set("CUSTOM_ATTRIB_LDAP_NAME", customLdapNames);
                        bean.set("CUSTOM_ATTRIB_LDAP_VALUE", customLdapValues);
                    }
                    ArrayList mailServersList = new ArrayList();
                    mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
                    ArrayList mailBoxStoresList = new ArrayList();
                    ArrayList mailServers = new ArrayList();
                    ArrayList<String> mailServerDNs = new ArrayList<String>();
                    ArrayList mailBoxStores = new ArrayList();
                    ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
                    boolean exch2007 = false;
                    if (mailServersList != null && !mailServersList.isEmpty()) {
                        mailServers = (ArrayList)mailServersList.get(0);
                        mailServerDNs = (ArrayList<String>)mailServersList.get(1);
                    }
                    if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                        String MAIL_SERVER = (String)bean.get("MAIL_SERVER");
                        if (MAIL_SERVER == null || MAIL_SERVER.equals("0") || MAIL_SERVER.equals("")) {
                            MAIL_SERVER = (String)mailServerDNs.get(0);
                        }
                        mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
                        exch2007 = ExchangeUtil.checkExchange2007((String)MAIL_SERVER);
                    } else {
                        mailServers = new ArrayList();
                        mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
                        mailServerDNs = new ArrayList<String>();
                        mailServerDNs.add("0");
                    }
                    if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                        mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                        mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
                    }
                    if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                        mailBoxStores = new ArrayList();
                        mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                        mailBoxStoreDNs = new ArrayList<String>();
                        mailBoxStoreDNs.add("0");
                    }
                    String owaccess = (String)bean.get("owaccess");
                    String pop = (String)bean.get("pop");
                    String imap = (String)bean.get("imap");
                    ArrayList<Object> PROTOCOL_SETTINGS = new ArrayList();
                    if (mailServersList != null && !mailServersList.isEmpty()) {
                        String MAIL_SERVER = (String)bean.get("MAIL_SERVER");
                        Integer version = ExchangeUtil.getExchangeServerType((String)MAIL_SERVER);
                        PROTOCOL_SETTINGS = bean.getProtocolSettings(owaccess, pop, imap, version);
                        bean.set("PROTOCOL_SETTINGS", PROTOCOL_SETTINGS);
                    }
                    bean.set("mailServers", mailServers);
                    bean.set("mailServerDNs", mailServerDNs);
                    bean.set("mailBoxStores", mailBoxStores);
                    bean.set("mailBoxStoreDNs", mailBoxStoreDNs);
                }
            }
            if (updateBean) {
                CSVUserBean clonedBean = (CSVUserBean)bean.getClone(bean);
                session.setAttribute("CLONE_BEAN", (Object)clonedBean);
            }
            session.setAttribute("userCreationDomain", (Object)domainName);
            request.setAttribute("domainProps", (Object)properties);
            request.setAttribute("domainList", (Object)HDTDomainHandler.getConfiguredList((Long)loginId));
        }
        catch (LocalizedException le) {
            message = le.getMessage(rb);
            if (message != null) {
                message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.mod_sing_user.statmsg_error_in_modifying_user"), message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward(forward);
    }

    private String getObjectString(String loginName, Properties properties, String ldapName) {
        String string = null;
        try {
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add(ldapName);
            String searchString = "(&(objectClass=user)(objectCategory=person)(distinguishedName=" + loginName + "))";
            ArrayList list = ADHandler.getObjectsWithOutListener((Properties)properties, (String)properties.getProperty("DEFAULT_NAMING_CONTEXT"), attrList, (String)searchString);
            Properties userDetails = (Properties)list.get(0);
            ArrayList disList = (ArrayList)userDetails.get(ldapName);
            string = (String)disList.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return string;
    }

    private ArrayList getCustomAttributeList(String domainName, CSVUserBean bean) {
        ArrayList<String> customValueList;
        int i;
        ArrayList customList = new ArrayList();
        String[] customLdapNames = (String[])bean.get("CUSTOM_ATTRIB_NAME");
        String[] customLdapValues = (String[])bean.get("CUSTOM_ATTRIB_VALUE");
        String[] confCustomLdapNameArray = (String[])bean.get("CUSTOM_ATTRIB_LDAP_NAME");
        String[] confCustomLdapValueArray = (String[])bean.get("CUSTOM_ATTRIB_LDAP_VALUE");
        Hashtable<String, ArrayList<String>> customTable = new Hashtable<String, ArrayList<String>>();
        for (i = 0; i < customLdapNames.length; ++i) {
            customValueList = (ArrayList<String>)customTable.get(customLdapNames[i]);
            if (customValueList == null) {
                customValueList = new ArrayList<String>();
            }
            customValueList.add(customLdapValues[i]);
            customTable.put(customLdapNames[i], customValueList);
        }
        for (i = 0; i < confCustomLdapNameArray.length; ++i) {
            customValueList = (ArrayList<String>)customTable.get(confCustomLdapNameArray[i]);
            if (customValueList == null) {
                customValueList = new ArrayList<String>();
            }
            if (!confCustomLdapValueArray[i].equals("")) {
                customValueList.add(confCustomLdapValueArray[i]);
            }
            customTable.put(confCustomLdapNameArray[i], customValueList);
        }
        Enumeration enumeration = customTable.keys();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            ArrayList values = (ArrayList)customTable.get(attributeName);
            if (values == null || values.size() <= 0) continue;
            ArrayList<String> values2 = new ArrayList<String>();
            for (Object object : values) {
                String format = (String)object;
                format = FormatClientUtil.getFormatValue(domainName, format, bean, new ArrayList());
                values2.add(format);
            }
            int count = values2.size();
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("ATTRIB_LDAP_NAME", attributeName);
            hash.put("DATA_HANDLER_TYPE", 3L);
            hash.put("ATTRIB_VALUE_COUNT", new Long(count));
            if (count == 1) {
                hash.put("ATTRIB_VALUE", values2.get(0));
            } else {
                hash.put("ATTRIB_VALUE", values2);
            }
            customList.add(hash);
        }
        return customList;
    }
}

