/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.dbsync.DBSynchronizer;
import com.manageengine.ads.fw.util.ADSErrorHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class ADAPDashboardAction
extends DispatchAction {
    Logger logger = Logger.getLogger("ADSLogger");
    private static final String PRODUCT_NAME = "ManageEngine ADAudit Plus";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.isUserAuthorized(request)) {
            return new ActionForward("/404Error.do");
        }
        String forwardPage = "mainPage";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
            if (domainName == null) {
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            }
            JSONObject productStatus = JumpToHandler.getProductStatus((String)PRODUCT_NAME);
            request.setAttribute("PRODUCT_SERVER_STATUS", (Object)productStatus);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("list", (Object)HDTDomainHandler.getConfiguredList((Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward loadContainers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = null;
        try {
            Long productId = CommonUtil.getProductId((String)PRODUCT_NAME);
            Long apiId = this.getAPIId(productId, "LOAD_DASHBOARD_CONTAINERS");
            Properties params = new Properties();
            params.put("params", request.getParameter("params"));
            RestAPI api = new RestAPI();
            api.execute(apiId, params);
            CommonUtil.setResponseText((HttpServletResponse)response, (String)api.getResponseText());
        }
        catch (Exception e) {
            e.printStackTrace();
            forwardPage = "lhsPage";
            request.setAttribute("ERROR_STATUS", (Object)this.constructServerStatus(e.getMessage()));
            try {
                JSONObject temp = new JSONObject(request.getParameter("params"));
                request.setAttribute("requestedDomain", (Object)(temp.has("domainName") ? temp.getString("domainName") : ""));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward loadComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject layoutParams = new JSONObject(request.getParameter("params"));
            Long productId = CommonUtil.getProductId((String)PRODUCT_NAME);
            Properties params = new Properties();
            params.put("params", layoutParams.toString());
            RestAPI api = new RestAPI();
            api.execute(productId, "LOAD_DASHBOARD_COMPONENT", params);
            CommonUtil.setResponseText((HttpServletResponse)response, (String)api.getResponseText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject constructServerStatus(String errorMessage) {
        JSONObject serverStatus;
        block2: {
            serverStatus = null;
            try {
                serverStatus = new JSONObject(errorMessage);
            }
            catch (Exception e) {
                serverStatus = ADSErrorHandler.getErrorObject((String)errorMessage);
                if (serverStatus != null) break block2;
                serverStatus = ADSErrorHandler.getErrorObject((String)"00000100");
            }
        }
        return serverStatus;
    }

    private boolean isUserAuthorized(HttpServletRequest request) {
        if (!CommonUtil.isProductIntegrated((String)"ManageEngine AD360")) {
            this.logger.log(Level.FINE, "AD360 is not integrated forwarding to 404ErrorPage");
            return false;
        }
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList roleList = authObject.getRoleList();
        if (!roleList.contains(com.adventnet.sym.adsm.common.server.util.CommonUtil.SUPER_ADMIN_ROLE_ID)) {
            this.logger.log(Level.FINE, "User is not authorized to view ADAP dashboard forwarding to 404ErrorPage");
            return false;
        }
        return true;
    }

    private Long getAPIId(Long productId, String apiName) throws Exception {
        Long apiId = null;
        try {
            apiId = RestAPIUtil.getAPIId((Long)productId, (String)apiName);
        }
        catch (Exception e) {
            if (e.getMessage().equals("00000006") && JumpToHandler.getProductStatus((String)"ManageEngine AD360").getString("ERROR_CODE").equals("00000000")) {
                DBSynchronizer dbsync = new DBSynchronizer();
                dbsync.synchronize(new boolean[]{true});
                this.logger.log(Level.FINE, "Product is synced with AD360 to get API details");
                apiId = RestAPIUtil.getAPIId((Long)productId, (String)apiName);
            }
            throw e;
        }
        return apiId;
    }
}

