/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPQuickLinksDataProvider
implements ComponentDataProvider,
ComponentGenerator {
    private boolean isDataAvailable = false;

    public boolean isDataAvailable() {
        return this.isDataAvailable;
    }

    public JSONObject getDataModel(HttpServletRequest request, JSONObject params) {
        JSONObject dataModel = new JSONObject();
        try {
            Long containerId = params.getLong("containerId");
            JSONArray links = new JSONArray();
            SelectQueryImpl contQuery = new SelectQueryImpl(Table.getTable((String)"ADMPQuickLinks"));
            contQuery.addJoin(new Join("ADMPQuickLinks", "ADMPQuickLinksMapping", new String[]{"QUICK_LINK_ID"}, new String[]{"QUICK_LINK_ID"}, 1));
            contQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"QUICK_LINK_ID"));
            contQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"ACTION_ID"));
            contQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"DISPLAY_NAME"));
            contQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"URL"));
            contQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"STYLES"));
            contQuery.setCriteria(new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"CONTAINER_ID"), (Object)containerId, 0));
            contQuery.addSortColumn(new SortColumn("ADMPQuickLinksMapping", "PRIORITY_ID", true));
            DataObject qlDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)contQuery);
            Iterator it = qlDO.getRows("ADMPQuickLinks");
            while (it.hasNext()) {
                JSONObject linkDetails = new JSONObject();
                Row row = (Row)it.next();
                List columns = row.getColumns();
                linkDetails.put("UNIQUE_ID", row.get("QUICK_LINK_ID"));
                linkDetails.put("DISPLAY_NAME", row.get("DISPLAY_NAME"));
                if (((Long)row.get("ACTION_ID")).compareTo(1L) != 0) {
                    linkDetails.put("URL", row.get("URL"));
                } else {
                    linkDetails.put("PROMOTION_URL", row.get("URL"));
                    linkDetails.put("TARGET", (Object)"_blank");
                }
                linkDetails.put("STYLES", row.get("STYLES"));
                links.put((Object)linkDetails);
            }
            dataModel.put(Long.toString(containerId), (Object)links);
            dataModel.put("IS_EMBER", params.optBoolean("IS_EMBER", false));
            if (links.length() != 0) {
                this.isDataAvailable = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }

    public JSONObject generate(JSONObject dataModel, ADSResourceBundle ... rb) throws Exception {
        if (dataModel.optBoolean("IS_EMBER", false)) {
            JSONObject componentDetails = new JSONObject();
            componentDetails.put("NAME", (Object)"dashboard/layout-quicklinks");
            componentDetails.put("responseType", (Object)"JSON");
            dataModel.remove("IS_EMBER");
            JSONArray data = new JSONArray();
            Iterator keys = dataModel.keys();
            while (keys.hasNext()) {
                JSONArray links = (JSONArray)dataModel.get((String)keys.next());
                for (int i = 0; i < links.length(); ++i) {
                    JSONObject link = (JSONObject)links.get(i);
                    if (rb.length != 0) {
                        link.put("DISPLAY_NAME", (Object)rb[0].getString(link.getString("DISPLAY_NAME")));
                    }
                    data.put((Object)link);
                }
            }
            componentDetails.put("DATA", (Object)data);
            return componentDetails;
        }
        dataModel.remove("IS_EMBER");
        return dataModel;
    }
}

