/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlow;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADMPWorkflowSummaryDataProvider
implements ComponentDataProvider,
ComponentGenerator {
    private boolean isDataAvailable = false;

    public boolean isDataAvailable() {
        return this.isDataAvailable;
    }

    public JSONObject getDataModel(HttpServletRequest request, JSONObject params) {
        JSONObject dataModel = new JSONObject();
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable summaryList = WorkFlow.getSummaryList((Long)loginId);
            ArrayList availableWFelementsList = WorkFlowUtil.getAllWFelements((Integer)WorkFlowUtil.DEFAULT_WORKFLOW_ID);
            Properties assignedRequest = (Properties)summaryList.get("AssignedRequest");
            JSONObject data = new JSONObject();
            int totalCount = 0;
            if (authObject.isReviewer().booleanValue() && availableWFelementsList.contains(2)) {
                data.put("reviewalCount", assignedRequest.get("reviewalCount"));
                totalCount += ((Integer)assignedRequest.get("reviewalCount")).intValue();
            }
            if (authObject.isApprover().booleanValue() && availableWFelementsList.contains(3)) {
                data.put("approvalCount", assignedRequest.get("approvalCount"));
                totalCount += ((Integer)assignedRequest.get("approvalCount")).intValue();
            }
            if (authObject.isCommitter().booleanValue() && availableWFelementsList.contains(4)) {
                data.put("executorCount", assignedRequest.get("executorCount"));
                totalCount += ((Integer)assignedRequest.get("executorCount")).intValue();
            }
            data.put("totalCount", totalCount);
            dataModel.put("DATA", (Object)data);
            dataModel.put("IS_EMBER", params.optBoolean("IS_EMBER", false));
            this.isDataAvailable = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }

    public JSONObject generate(JSONObject dataModel, ADSResourceBundle ... rb) throws Exception {
        if (dataModel.optBoolean("IS_EMBER", false)) {
            JSONObject componentDetails = new JSONObject();
            componentDetails.put("NAME", (Object)"workflow-summary");
            componentDetails.put("responseType", (Object)"JSON");
            componentDetails.put("DATA", dataModel.get("DATA"));
            return componentDetails;
        }
        dataModel.remove("IS_EMBER");
        return dataModel;
    }
}

