/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.sym.adsm.common.server.reports.DashboardReportUtil;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DashboardRefreshHandler {
    private static DashboardRefreshHandler handler = null;
    private Hashtable<Long, ArrayList<String>> loginIdVsContainers = new Hashtable();
    static Logger logger = Logger.getLogger("ADSLayoutLogger");

    private DashboardRefreshHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DashboardRefreshHandler getInstance() {
        if (handler != null) return handler;
        Class<DashboardRefreshHandler> clazz = DashboardRefreshHandler.class;
        synchronized (DashboardRefreshHandler.class) {
            if (handler != null) return handler;
            handler = new DashboardRefreshHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void refreshContainer(Long loginId, Long containerId, String domainName, ArrayList reportMappings) {
        this.refreshContainer(loginId, containerId, domainName, null, reportMappings, false);
    }

    public void refreshContainer(Long loginId, Long containerId, String domainName, Long pointId, ArrayList reportMappings, boolean getResultRows) {
        try {
            String container = containerId.toString();
            if (pointId != null) {
                container = container + "P" + pointId.toString();
            }
            if (domainName != null) {
                container = container + domainName;
            }
            if (this.register(loginId, container)) {
                if (domainName != null) {
                    DomainContainerReportAction dcra = new DomainContainerReportAction(loginId, container, domainName, reportMappings, getResultRows);
                    dcra.start();
                } else {
                    ContainerReportAction cra = new ContainerReportAction(loginId, container, reportMappings, getResultRows);
                    cra.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCount(Long loginId, Long containerId, String domainName, Long pointId, ArrayList reportMappings) {
        try {
            String container = containerId.toString();
            if (pointId != null) {
                container = container + "P" + pointId.toString();
            }
            if (domainName != null) {
                container = container + domainName;
            }
            if (this.register(loginId, container)) {
                ContainerCountAction cca = new ContainerCountAction(loginId, container, reportMappings);
                cca.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCountForContainers(Long loginId, ArrayList<Long> containerIds) {
        this.updateCountForContainers(loginId, containerIds, null);
    }

    public void updateCountForContainers(Long loginId, ArrayList<Long> containerIds, String domainName) {
        ContainersCountAction cca = new ContainersCountAction(loginId, containerIds, domainName);
        cca.start();
    }

    public void updateCount(Long loginId, ArrayList reportMappings) {
        CountAction ca = new CountAction(loginId, reportMappings);
        ca.start();
    }

    public void updateCountForLayout(Long loginId, Long layoutId) {
        LayoutCountAction lca = new LayoutCountAction(loginId, layoutId);
        lca.start();
    }

    public boolean checkStatus(Long loginId, Long containerId, String domainName, Long pointId) {
        ArrayList<String> containers;
        String container = "";
        String container2 = "";
        if (containerId != null) {
            container = container + containerId.toString();
        }
        if (pointId != null) {
            container = container + "P" + pointId.toString();
            container2 = container2 + "P" + pointId.toString();
        }
        if (domainName != null) {
            container = container + domainName;
            container2 = container2 + domainName;
        }
        if ((containers = this.loginIdVsContainers.get(loginId)) != null) {
            return containers.contains(container) || containers.contains(container2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean register(Long loginId, String container) {
        Hashtable<Long, ArrayList<String>> hashtable = this.loginIdVsContainers;
        synchronized (hashtable) {
            ArrayList<String> containers;
            if (this.loginIdVsContainers.get(loginId) == null) {
                this.loginIdVsContainers.put(loginId, new ArrayList());
            }
            if ((containers = this.loginIdVsContainers.get(loginId)).contains(container)) {
                logger.log(Level.INFO, container + " is already present for loginId: " + loginId);
                return false;
            }
            containers.add(container);
            logger.log(Level.FINE, container + " is registered for loginId: " + loginId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister(Long loginId, String container) {
        Hashtable<Long, ArrayList<String>> hashtable = this.loginIdVsContainers;
        synchronized (hashtable) {
            ArrayList<String> containers = this.loginIdVsContainers.get(loginId);
            if (containers == null) {
                logger.log(Level.INFO, loginId + " is not initialized for any refresh");
                return;
            }
            if (containers.contains(container)) {
                containers.remove(container);
                logger.log(Level.FINE, container + " is deregistered for loginId: " + loginId);
            } else {
                logger.log(Level.INFO, container + " is not present for loginId: " + loginId);
            }
        }
    }

    private class ContainerCountAction
    extends Thread {
        Long loginId = null;
        String container = null;
        ArrayList reportMappings = null;

        public ContainerCountAction(Long loginId, String container, ArrayList reportMappings) {
            this.loginId = loginId;
            this.container = container;
            this.reportMappings = reportMappings;
        }

        @Override
        public void run() {
            DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, (ArrayList)this.reportMappings);
            DashboardRefreshHandler.this.deregister(this.loginId, this.container);
        }
    }

    private class ContainerReportAction
    extends Thread {
        Long loginId = null;
        String container = null;
        ArrayList reportMappings = null;
        boolean getResultRows = false;

        public ContainerReportAction(Long loginId, String container, ArrayList reportMappings, boolean getResultRows) {
            this.loginId = loginId;
            this.container = container;
            this.reportMappings = reportMappings;
            this.getResultRows = getResultRows;
        }

        @Override
        public void run() {
            if (this.getResultRows) {
                DashboardReportUtil.runSelectedReport((Long)this.loginId, (ArrayList)this.reportMappings);
            } else {
                DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, (ArrayList)this.reportMappings);
            }
            DashboardRefreshHandler.this.deregister(this.loginId, this.container);
        }
    }

    private class ContainersCountAction
    extends Thread {
        ArrayList<Long> containerIds = null;
        Long loginId = null;
        String domainName = null;

        public ContainersCountAction(Long loginId, ArrayList<Long> containerIds, String domainName) {
            this.loginId = loginId;
            this.containerIds = containerIds;
            this.domainName = domainName;
        }

        @Override
        public void run() {
            try {
                int i;
                ArrayList<String> registeredKeys = new ArrayList<String>();
                ArrayList<ArrayList> reportMappingsArray = new ArrayList<ArrayList>();
                for (i = 0; i < this.containerIds.size(); ++i) {
                    Long containerId = this.containerIds.get(i);
                    String container = containerId.toString();
                    if (this.domainName != null) {
                        container = container + this.domainName;
                    }
                    ArrayList tempReportMappings = DashboardUtil.getReportMappings(containerId, this.domainName);
                    if (!DashboardRefreshHandler.this.register(this.loginId, container)) continue;
                    reportMappingsArray.add(tempReportMappings);
                    registeredKeys.add(container);
                }
                for (i = 0; i < registeredKeys.size(); ++i) {
                    DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, (ArrayList)((ArrayList)reportMappingsArray.get(i)));
                    DashboardRefreshHandler.this.deregister(this.loginId, (String)registeredKeys.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class CountAction
    extends Thread {
        Long loginId = null;
        ArrayList reportMappings = null;

        public CountAction(Long loginId, ArrayList reportMappings) {
            this.loginId = loginId;
            this.reportMappings = reportMappings;
        }

        @Override
        public void run() {
            try {
                int i;
                ArrayList<String> registeredKeys = new ArrayList<String>();
                ArrayList<HashMap> reportMappingsArray = new ArrayList<HashMap>();
                for (i = 0; i < this.reportMappings.size(); ++i) {
                    HashMap reportMapping = (HashMap)this.reportMappings.get(i);
                    String domainName = (String)reportMapping.get("domainName");
                    Long pointId = (Long)reportMapping.get("dashboardReportMapping");
                    String container = "P" + pointId.toString();
                    if (domainName != null) {
                        container = container + domainName;
                    }
                    if (!DashboardRefreshHandler.this.register(this.loginId, container)) continue;
                    reportMappingsArray.add(reportMapping);
                    registeredKeys.add(container);
                }
                for (i = 0; i < registeredKeys.size(); ++i) {
                    ArrayList singleReportMappingInArrayForm = new ArrayList();
                    singleReportMappingInArrayForm.add(reportMappingsArray.get(i));
                    DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, singleReportMappingInArrayForm);
                    DashboardRefreshHandler.this.deregister(this.loginId, (String)registeredKeys.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class DomainContainerReportAction
    extends Thread {
        Long loginId = null;
        String container = null;
        String domainName = null;
        ArrayList reportMappings = null;
        boolean getResultRows = false;

        public DomainContainerReportAction(Long loginId, String container, String domainName, ArrayList reportMappings, boolean getResultRows) {
            this.loginId = loginId;
            this.container = container;
            this.domainName = domainName;
            this.reportMappings = reportMappings;
            this.getResultRows = getResultRows;
        }

        @Override
        public void run() {
            if (this.getResultRows) {
                DashboardReportUtil.runSelectedReport((String)this.domainName, (Long)this.loginId, (ArrayList)this.reportMappings);
            } else {
                DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, (ArrayList)this.reportMappings);
            }
            DashboardRefreshHandler.this.deregister(this.loginId, this.container);
        }
    }

    private class LayoutCountAction
    extends Thread {
        Long loginId = null;
        Long layoutId = null;

        public LayoutCountAction(Long loginId, Long layoutId) {
            this.loginId = loginId;
            this.layoutId = layoutId;
        }

        @Override
        public void run() {
            try {
                int i;
                ArrayList containersHashList = DashboardReportUtil.getContainersForLayoutRefresh((Long)this.loginId);
                ArrayList<String> registeredKeys = new ArrayList<String>();
                ArrayList<ArrayList> reportMappingsArray = new ArrayList<ArrayList>();
                for (i = 0; i < containersHashList.size(); ++i) {
                    HashMap containerHash = (HashMap)containersHashList.get(i);
                    Long containerId = (Long)containerHash.get("containerId");
                    String domainName = (String)containerHash.get("domainName");
                    String container = containerId.toString();
                    if (domainName != null) {
                        container = container + domainName;
                    }
                    ArrayList tempReportMappings = DashboardUtil.getReportMappings(containerId, domainName);
                    if (!DashboardRefreshHandler.this.register(this.loginId, container)) continue;
                    reportMappingsArray.add(tempReportMappings);
                    registeredKeys.add(container);
                }
                for (i = 0; i < registeredKeys.size(); ++i) {
                    DashboardReportUtil.updateSelectedReportCount((Long)this.loginId, (ArrayList)((ArrayList)reportMappingsArray.get(i)));
                    DashboardRefreshHandler.this.deregister(this.loginId, (String)registeredKeys.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

