/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delayedtask;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.webclient.delayedtask.ScheduleDelayedTaskListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ExchOnlineRoomMailboxDelayedTaskListener
extends ScheduleDelayedTaskListener {
    private static String[] calenderProcessingAttributeNames = new String[]{"Identity", "AllowConflicts", "AllowRecurringMeetings", "ScheduleOnlyDuringWorkHours", "EnforceSchedulingHorizon", "BookingWindowInDays", "MaximumDurationInMinutes", "MaximumConflictInstances", "ConflictPercentageAllowed", "DeleteAttachments", "DeleteComments", "DeleteSubject", "DeleteNonCalendarItems", "AddOrganizerToSubject", "RemovePrivateProperty", "OrganizerInfo", "AddAdditionalResponse", "AdditionalResponse", "TentativePendingApproval", "ResourceDelegates", "AutomateProcessing", "ForwardRequestsToDelegates", "AllBookInPolicy", "BookInPolicy", "AllRequestInPolicy", "RequestInPolicy", "AllRequestOutOfPolicy", "RequestOutOfPolicy"};
    private static boolean isCalenderProcessingAttributeNamesSorted = false;
    private static String[] mailboxProcessingAttributesName = new String[]{"Identity", "SimpleDisplayName", "HiddenFromAddressListsEnabled", "IssueWarningQuota", "ProhibitSendQuota", "ProhibitSendReceiveQuota", "RetainDeletedItemsFor", "MaxSendSize", "MaxReceiveSize", "ResourceCapacity", "RoleAssignmentPolicy", "SharingPolicy", "RetentionPolicy", "DeliverToMailboxAndForward", "ForwardingAddress", "RejectMessagesFromSendersOrMembers", "AcceptMessagesOnlyFromSendersOrMembers", "EmailAddresses"};
    private static boolean isMailboxProcessingAttributesNameSorted = false;

    @Override
    protected void execute(Properties taskProp, HashMap taskDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String message = "";
        boolean isSuccess = false;
        String waadTenantId = (String)taskProp.get("DOMAIN_NAME");
        Properties o365Props = DomainInfoCache.getInstance().getWAADDomainProperties(waadTenantId);
        String tenantPass = (String)o365Props.get("WAAD_TENANT_PASSWD");
        String objectName = (String)taskProp.get("OBJECT_NAME");
        logger.log(Level.FINE, "Executing delayed task for tenant: " + waadTenantId + " Object modified: " + objectName);
        String objectId = (String)taskProp.get("OBJECT_ID");
        ArrayList<Properties> modifyCalendarAttribToNative = new ArrayList<Properties>();
        ArrayList<Properties> modifyExchangeAttribToNative = new ArrayList<Properties>();
        this.getModifyCalendarAttributes(taskProp, taskDetails, modifyCalendarAttribToNative);
        this.getModifyMailboxAttributes(taskProp, taskDetails, modifyExchangeAttribToNative);
        Properties nativeStatusProperties = new Properties();
        Boolean isMailboxModified = true;
        if (modifyExchangeAttribToNative.size() > 1) {
            isMailboxModified = O365MgmtUtil.modifyResourceMailbox(nativeStatusProperties, waadTenantId, tenantPass, modifyExchangeAttribToNative, rb);
        }
        Boolean isCalendarModified = true;
        if (modifyCalendarAttribToNative.size() > 1) {
            isCalendarModified = O365MgmtUtil.modifyCalenderProcessing(nativeStatusProperties, waadTenantId, tenantPass, modifyCalendarAttribToNative, rb);
        }
        isSuccess = isCalendarModified != false && isMailboxModified != false;
        this.setExecutionStatus(isSuccess);
        message = !isSuccess ? nativeStatusProperties.getProperty("message") : "admp.mgmt.common.text.successfully_modified";
        this.setStatusMessage(message);
        logger.log(Level.FINE, "Completed execution of exchange online room mailbox delayed task for " + objectName + ". isSuccess: " + isCalendarModified);
        this.setAuditPropList(taskDetails, rb);
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.delayedtask.category.exch_online_room_mbx_mgmt"), objectName, waadTenantId, this.auditPropList, new ArrayList(), new ArrayList(), rb.getString(message), (Long)audit_info.get("object_id"), auditDataObj, rb);
    }

    private void getModifyCalendarAttributes(Properties taskProp, HashMap taskDetails, ArrayList<Properties> modifyCalendarAttribToNative) {
        ExchOnlineRoomMailboxDelayedTaskListener.sortCmdletParams();
        for (Map.Entry pair : taskDetails.entrySet()) {
            String attribName = (String)pair.getKey();
            if (Arrays.binarySearch(calenderProcessingAttributeNames, attribName) < 0) continue;
            Object attribValue = pair.getValue();
            if (attribValue instanceof String) {
                Properties attribProp = new Properties();
                attribProp.put("PARAMETER", attribName);
                attribProp.put("VALUE", attribValue.toString());
                modifyCalendarAttribToNative.add(attribProp);
                continue;
            }
            if (attribValue instanceof ArrayList) {
                ArrayList attribValueList = (ArrayList)attribValue;
                Properties attribProp = new Properties();
                attribProp.put("PARAMETER", attribName);
                StringBuilder aValue = new StringBuilder(attribValueList.size() * 37);
                for (int i = 0; i < attribValueList.size(); ++i) {
                    aValue.append(attribValueList.get(i));
                    aValue.append(" ");
                }
                aValue.deleteCharAt(aValue.length() - 1);
                attribProp.put("VALUE", "P:" + aValue.toString());
                modifyCalendarAttribToNative.add(attribProp);
                continue;
            }
            logger.log(Level.FINE, "attribValue is not expected: " + attribValue.getClass().getName());
        }
    }

    private void getModifyMailboxAttributes(Properties taskProp, HashMap taskDetails, ArrayList<Properties> modifyMailboxAttribToNative) {
        ExchOnlineRoomMailboxDelayedTaskListener.sortCmdletParams();
        for (Map.Entry pair : taskDetails.entrySet()) {
            String attribName = (String)pair.getKey();
            if (Arrays.binarySearch(mailboxProcessingAttributesName, attribName) < 0) continue;
            Object attribValue = pair.getValue();
            if (attribValue instanceof String) {
                Properties attribProp = new Properties();
                attribProp.put("PARAMETER", attribName);
                attribProp.put("VALUE", attribValue.toString());
                modifyMailboxAttribToNative.add(attribProp);
                continue;
            }
            if (attribValue instanceof ArrayList) {
                ArrayList attribValueList = (ArrayList)attribValue;
                Properties attribProp = new Properties();
                attribProp.put("PARAMETER", attribName);
                StringBuilder aValue = new StringBuilder(attribValueList.size() * 37);
                for (int i = 0; i < attribValueList.size(); ++i) {
                    aValue.append(attribValueList.get(i));
                    aValue.append(" ");
                }
                aValue.deleteCharAt(aValue.length() - 1);
                attribProp.put("VALUE", "P:" + aValue.toString());
                modifyMailboxAttribToNative.add(attribProp);
                continue;
            }
            logger.log(Level.FINE, "attribValue is not expected: " + attribValue.getClass().getName());
        }
    }

    private void setAuditPropList(HashMap inputMap, AdventNetResourceBundle rb) {
        for (Object key : inputMap.keySet()) {
            String keyStr = key.toString();
            Properties auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString(keyStr));
            if (!(keyStr.equalsIgnoreCase("RequestInPolicy") || keyStr.equalsIgnoreCase("RequestOutOfPolicy") || keyStr.equalsIgnoreCase("ResourceDelegates") || keyStr.equalsIgnoreCase("BookInPolicy") || keyStr.equalsIgnoreCase("AcceptMessagesOnlyFromSendersOrMembers") || keyStr.equalsIgnoreCase("RejectMessagesFromSendersOrMembers"))) {
                String attribValue = inputMap.get(keyStr).toString();
                if (attribValue.startsWith("S:") || attribValue.startsWith("P:") || attribValue.startsWith("B:")) {
                    attribValue = keyStr.equalsIgnoreCase("ForwardingAddress") ? O365MgmtHandler.getDisplayNameForAudit((String)attribValue.substring(2)) : attribValue.substring(2);
                }
                auditProp.put("ATTRIB_VALUE", attribValue);
            } else {
                ArrayList listForAudit = null;
                listForAudit = keyStr.equalsIgnoreCase("EmailAddresses") ? (ArrayList)inputMap.get(keyStr) : O365MgmtHandler.getDisplayNameForAudit((ArrayList)((ArrayList)inputMap.get(keyStr)));
                auditProp.put("ATTRIB_VALUE", listForAudit);
            }
            this.auditPropList.add(auditProp);
        }
    }

    private static void sortCmdletParams() {
        if (!isCalenderProcessingAttributeNamesSorted) {
            Arrays.sort(calenderProcessingAttributeNames);
            isCalenderProcessingAttributeNamesSorted = true;
        }
        if (!isMailboxProcessingAttributesNameSorted) {
            Arrays.sort(mailboxProcessingAttributesName);
            isMailboxProcessingAttributesNameSorted = true;
        }
    }
}

