/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleHandler;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPRoleAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(ADMPRoleAction.class.getName());

    public ActionForward viewADMPRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            DynaValidatorForm bean = (DynaValidatorForm)form;
            String operation = request.getParameter("operation");
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.ROLE_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            if (operation != null && operation.equals("view")) {
                this.resetBean(bean, request);
            }
            List<HashMap<String, Object>> helpDeskRolesList = this.getRolesList(request, bean, Boolean.TRUE);
            request.setAttribute("AdmpRoleList", helpDeskRolesList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward createOrEditRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject authorizedFieldsObj = new JSONObject();
        JSONObject userFieldsObj = new JSONObject();
        JSONObject contacatFieldsObj = new JSONObject();
        JSONObject computerFieldsObj = new JSONObject();
        JSONObject groupFieldsObj = new JSONObject();
        JSONObject ouFieldsObj = new JSONObject();
        JSONObject shMailboxFieldsObj = new JSONObject();
        JSONObject lkMailboxFieldsObj = new JSONObject();
        JSONObject rcMailboxFieldsObj = new JSONObject();
        JSONObject dlGroupFieldsObj = new JSONObject();
        JSONObject fsmPermissionFieldsObj = new JSONObject();
        JSONObject o365DistGroupFieldsObj = new JSONObject();
        JSONArray userFieldsArray = new JSONArray();
        JSONArray contactFieldsArray = new JSONArray();
        JSONArray computerFieldsArray = new JSONArray();
        JSONArray groupFieldsArray = new JSONArray();
        JSONArray ouFieldsArray = new JSONArray();
        JSONArray shMailboxFieldsArray = new JSONArray();
        JSONArray lkMailboxFieldsArray = new JSONArray();
        JSONArray dlGroupFieldsArray = new JSONArray();
        JSONArray rcMailboxFieldsArray = new JSONArray();
        JSONArray fsmPermissionFieldsArray = new JSONArray();
        JSONArray o365DistGroupFieldsArray = new JSONArray();
        String tileName = "createADMPRole";
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Long roleID = null;
            if (request.getParameter("roleID") != null && !request.getParameter("roleID").equals("")) {
                roleID = new Long(request.getParameter("roleID"));
            }
            String operation = request.getParameter("operation");
            userFieldsObj.put("fieldsFilled", false);
            contacatFieldsObj.put("fieldsFilled", false);
            computerFieldsObj.put("fieldsFilled", false);
            groupFieldsObj.put("fieldsFilled", false);
            ouFieldsObj.put("fieldsFilled", false);
            shMailboxFieldsObj.put("fieldsFilled", false);
            lkMailboxFieldsObj.put("fieldsFilled", false);
            dlGroupFieldsObj.put("fieldsFilled", false);
            rcMailboxFieldsObj.put("fieldsFilled", false);
            fsmPermissionFieldsObj.put("fieldsFilled", false);
            o365DistGroupFieldsObj.put("fieldsFilled", false);
            if (operation.equals("createRole")) {
                this.logger.log(Level.INFO, "Trying to create new role, so setting roleid to 0.");
                bean.set("roleID", (Object)new Long(0L));
            } else {
                String[] o365DistGroupActions;
                String[] fsmPermissionActions;
                String[] rcMailboxActions;
                String[] dlGroupActions;
                String[] lkMailboxActions;
                String[] shMailboxActions;
                String[] ouActions;
                String[] groupActions;
                String[] computerActions;
                String[] contactActions;
                this.logger.log(Level.INFO, "Trying to change the existing role " + roleID);
                Hashtable hashtable = HelpDeskRoleHandler.getRoleDetails((Long)roleID);
                request.setAttribute("ROLE_DETAILS", (Object)hashtable);
                bean.set("roleID", (Object)roleID);
                String[] userActions = HelpDeskRoleHandler.initCreateUserActionIds((Long)roleID);
                if (userActions != null) {
                    userFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has user creation attribute privillages.");
                    for (int i = 0; i < userActions.length; ++i) {
                        userFieldsArray.put((Object)userActions[i]);
                    }
                }
                if ((contactActions = HelpDeskRoleHandler.initCreateContactActionIds((Long)roleID)) != null) {
                    contacatFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has contact creation attribute privillages.");
                    for (int i = 0; i < contactActions.length; ++i) {
                        contactFieldsArray.put((Object)contactActions[i]);
                    }
                }
                if ((computerActions = HelpDeskRoleHandler.initCreateComputerActionIds((Long)roleID)) != null) {
                    computerFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has computer creation attribute privillages.");
                    for (int i = 0; i < computerActions.length; ++i) {
                        computerFieldsArray.put((Object)computerActions[i]);
                    }
                }
                if ((groupActions = HelpDeskRoleHandler.initCreateGroupActionIds((Long)roleID)) != null) {
                    groupFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has Group creation attribute privillages.");
                    for (int i = 0; i < groupActions.length; ++i) {
                        groupFieldsArray.put((Object)groupActions[i]);
                    }
                }
                if ((ouActions = HelpDeskRoleHandler.initCreateOUActionIds((Long)roleID)) != null) {
                    ouFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has OU creation attribute privillages.");
                    for (int i = 0; i < ouActions.length; ++i) {
                        ouFieldsArray.put((Object)ouActions[i]);
                    }
                }
                if ((shMailboxActions = HelpDeskRoleHandler.initCreateShMailboxActionIds((Long)roleID)) != null) {
                    shMailboxFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has Shared Mailbox creation attribute privillages.");
                    for (int i = 0; i < shMailboxActions.length; ++i) {
                        shMailboxFieldsArray.put((Object)shMailboxActions[i]);
                    }
                }
                if ((lkMailboxActions = HelpDeskRoleHandler.initCreateLkMailboxActionIds((Long)roleID)) != null) {
                    lkMailboxFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has Linked Mailbox creation attribute privillages.");
                    for (int i = 0; i < lkMailboxActions.length; ++i) {
                        lkMailboxFieldsArray.put((Object)lkMailboxActions[i]);
                    }
                }
                if ((dlGroupActions = HelpDeskRoleHandler.initCreateDLGroupActionIds((Long)roleID)) != null) {
                    dlGroupFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has Group creation attribute privillages.");
                    for (int i = 0; i < dlGroupActions.length; ++i) {
                        dlGroupFieldsArray.put((Object)dlGroupActions[i]);
                    }
                }
                if ((rcMailboxActions = HelpDeskRoleHandler.initCreateResourceMailboxActionIds((Long)roleID)) != null) {
                    rcMailboxFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has Shared Mailbox creation attribute privillages.");
                    for (int i = 0; i < rcMailboxActions.length; ++i) {
                        rcMailboxFieldsArray.put((Object)rcMailboxActions[i]);
                    }
                }
                if ((fsmPermissionActions = HelpDeskRoleHandler.initFSMPermissionActionIds((Long)roleID)) != null) {
                    fsmPermissionFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has FSM Permission attribute privillages.");
                    for (int i = 0; i < fsmPermissionActions.length; ++i) {
                        fsmPermissionFieldsArray.put((Object)fsmPermissionActions[i]);
                    }
                }
                if ((o365DistGroupActions = HelpDeskRoleHandler.initModifyO365DistGroupActionIds((Long)roleID)) != null) {
                    o365DistGroupFieldsObj.put("fieldsFilled", true);
                    this.logger.log(Level.FINE, "This role " + roleID + "has O365 Dist Group modification attribute privillages.");
                    for (int i = 0; i < o365DistGroupActions.length; ++i) {
                        o365DistGroupFieldsArray.put((Object)o365DistGroupActions[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        userFieldsObj.put("fieldsList", (Object)userFieldsArray);
        contacatFieldsObj.put("fieldsList", (Object)contactFieldsArray);
        computerFieldsObj.put("fieldsList", (Object)computerFieldsArray);
        groupFieldsObj.put("fieldsList", (Object)groupFieldsArray);
        ouFieldsObj.put("fieldsList", (Object)ouFieldsArray);
        shMailboxFieldsObj.put("fieldsList", (Object)shMailboxFieldsArray);
        lkMailboxFieldsObj.put("fieldsList", (Object)lkMailboxFieldsArray);
        dlGroupFieldsObj.put("fieldsList", (Object)dlGroupFieldsArray);
        rcMailboxFieldsObj.put("fieldsList", (Object)rcMailboxFieldsArray);
        fsmPermissionFieldsObj.put("fieldsList", (Object)fsmPermissionFieldsArray);
        o365DistGroupFieldsObj.put("fieldsList", (Object)o365DistGroupFieldsArray);
        authorizedFieldsObj.put("user", (Object)userFieldsObj);
        authorizedFieldsObj.put("contact", (Object)contacatFieldsObj);
        authorizedFieldsObj.put("computer", (Object)computerFieldsObj);
        authorizedFieldsObj.put("group", (Object)groupFieldsObj);
        authorizedFieldsObj.put("OU", (Object)ouFieldsObj);
        authorizedFieldsObj.put("sharedMailbox", (Object)shMailboxFieldsObj);
        authorizedFieldsObj.put("linkedMailbox", (Object)lkMailboxFieldsObj);
        authorizedFieldsObj.put("dlGroup", (Object)dlGroupFieldsObj);
        authorizedFieldsObj.put("resourceMailbox", (Object)rcMailboxFieldsObj);
        authorizedFieldsObj.put("fsmPermission", (Object)fsmPermissionFieldsObj);
        authorizedFieldsObj.put("o365DistGroup", (Object)o365DistGroupFieldsObj);
        request.setAttribute("authorizedFields", (Object)authorizedFieldsObj.toString());
        String roleType = request.getParameter("roleType");
        if (roleType != null && roleType.equals("SDP")) {
            tileName = "createSDPRole";
        }
        return mapping.findForward(tileName);
    }

    public ActionForward copyHDTRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            Long roleID = new Long(request.getParameter("roleID"));
            String sortColumn = request.getParameter("sortColumn");
            bean.set("sortColumn", (Object)sortColumn);
            String[] actions = null;
            String[] userActions = HelpDeskRoleHandler.initCreateUserActionIds((Long)roleID);
            String[] contactActions = HelpDeskRoleHandler.initCreateContactActionIds((Long)roleID);
            String[] computerActions = HelpDeskRoleHandler.initCreateComputerActionIds((Long)roleID);
            String[] groupActions = HelpDeskRoleHandler.initCreateGroupActionIds((Long)roleID);
            String[] ouActions = HelpDeskRoleHandler.initCreateOUActionIds((Long)roleID);
            String[] shMailboxActions = HelpDeskRoleHandler.initCreateShMailboxActionIds((Long)roleID);
            String[] lkMailboxActions = HelpDeskRoleHandler.initCreateLkMailboxActionIds((Long)roleID);
            String[] dlGroupActions = HelpDeskRoleHandler.initCreateDLGroupActionIds((Long)roleID);
            String[] rcMailboxActions = HelpDeskRoleHandler.initCreateResourceMailboxActionIds((Long)roleID);
            String[] fsmPermissionActions = HelpDeskRoleHandler.initFSMPermissionActionIds((Long)roleID);
            String[] o365DistGroupActions = HelpDeskRoleHandler.initModifyO365DistGroupActionIds((Long)roleID);
            String admpRoleName = request.getParameter("newRoleName");
            String admpRoleDescription = "";
            Hashtable hashtable = HelpDeskRoleHandler.getRoleDetails((Long)roleID);
            if (hashtable != null) {
                admpRoleDescription = rb.getString((String)hashtable.get("ADMP_ROLE_DESCRIPTION"));
                DataObject roleObj = (DataObject)hashtable.get("ADMP_ROLE_ACTIONS");
                Iterator it = roleObj.getRows("ADMPRolePermissions");
                actions = new String[roleObj.size("ADMPRolePermissions")];
                int i = 0;
                while (it.hasNext()) {
                    String actionStr;
                    Row r = (Row)it.next();
                    actions[i] = actionStr = String.valueOf((Long)r.get("ACTION_ID"));
                    ++i;
                }
            }
            String message = "";
            if (!HelpDeskRoleHandler.isRoleExists((String)admpRoleName)) {
                HelpDeskRoleHandler.saveADMPRole((String)admpRoleName, (String)admpRoleDescription, null, (String[])actions, (String[])userActions, (String[])contactActions, (String[])computerActions, (String[])groupActions, (String[])ouActions, (String[])shMailboxActions, (String[])dlGroupActions, (String[])rcMailboxActions, (String[])fsmPermissionActions, (String[])o365DistGroupActions, (String[])lkMailboxActions);
                message = rb.getString("admp.deleg.hdt_deleg.cre_role.stat_msg_copy_hdt_role");
                this.logger.log(Level.INFO, "Status message for the saving new role " + admpRoleName + " is " + message);
                request.setAttribute("statusMessage", (Object)message);
                HDTAuditUtil.fillHDRolesAuditDetails((Long)((Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID")), (Long)DelegationUtil.HELP_DESK_ROLES_CATEGORY_ID, (String)admpRoleName, (String)"admp.deleg.hdt_deleg.hdd_reports.created", (AdventNetResourceBundle)rb);
            } else {
                message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg_error_in_creating_helpDesk_role"), rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.role_name_already_exists"));
                request.setAttribute("errorMessage", (Object)message);
            }
        }
        catch (DataAccessException e) {
            request.setAttribute("errorMessage", (Object)rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.helpDesk_role_size_exceeds"));
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_saving_helpDesk_role"));
        }
        List<HashMap<String, Object>> helpDeskRolesList = this.getRolesList(request, bean);
        request.setAttribute("AdmpRoleList", helpDeskRolesList);
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward saveADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean;
        String message;
        block65: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            message = null;
            bean = (DynaValidatorForm)form;
            try {
                Hashtable<String, String> hashtable;
                Long loginId;
                int i;
                Long creationFieldsRoleId;
                if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.ROLE_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                String admpRoleName = request.getParameter("ADMP_ROLE_NAME");
                String admpRoleDescription = request.getParameter("ADMP_ROLE_DESCRIPTION");
                String roleType = request.getParameter("roleType");
                Long roleID = (Long)bean.get("roleID");
                String[] actions = request.getParameterValues("actions");
                String[] userActions = null;
                String[] contactActions = null;
                String[] computerActions = null;
                String[] groupActions = null;
                String[] ouActions = null;
                String[] shMailboxActions = null;
                String[] lkMailboxActions = null;
                String[] dlGroupActions = null;
                String[] rcMailboxActions = null;
                String[] fsmPermissionActions = null;
                String[] o365DistGroupActions = null;
                boolean isUserCreationChecked = false;
                boolean isContactCreationChecked = false;
                boolean isComputerCreationChecked = false;
                boolean isGroupCreationChecked = false;
                boolean isOUCreationChecked = false;
                boolean isSHMailboxCreationChecked = false;
                boolean isLKMailboxCreationChecked = false;
                boolean isDLGroupCreationChecked = false;
                boolean isRCMailboxCreationChecked = false;
                boolean isFSMPermMgmtChecked = false;
                boolean isO365DistGroupModificationChecked = false;
                String authorizedFieldsString = request.getParameter("authorizedFields");
                JSONObject authorizedFieldsJsonObj = new JSONObject(authorizedFieldsString);
                boolean isSDPAddOn = CommonUtil.isSDPAddOnLicense();
                boolean isAdmpTechAvailable = CommonUtil.isAdmpTechAvailable();
                if (!(!isSDPAddOn && isAdmpTechAvailable || actions == null || roleID == null || roleID.equals(0L) || roleID.equals(CommonUtil.SUPER_ADMIN_ROLE_ID))) {
                    ArrayList roleActionList = HelpDeskRoleUtil.getRoleActionsAsString((Long)roleID);
                    ArrayList sdpAddonActionList = new ArrayList();
                    sdpAddonActionList = isAdmpTechAvailable ? HelpDeskRoleUtil.getRoleActionsAsString((Long)DelegationUtil.SDP_ADDON_ROLE_ID) : HelpDeskRoleUtil.getRoleActionsAsString((Long)DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID);
                    ArrayList<String> actionsList = new ArrayList<String>(Arrays.asList(actions));
                    roleActionList.removeAll(sdpAddonActionList);
                    actionsList.addAll(roleActionList);
                    actions = new String[actionsList.size()];
                    actionsList.toArray(actions);
                }
                for (int j = 0; actions != null && j < actions.length; ++j) {
                    if (DelegationUtil.CREATE_USER_ACTION_ID.toString().equals(actions[j])) {
                        isUserCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_CONTACT_ACTION_ID.toString().equals(actions[j])) {
                        isContactCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_GROUP_ACTION_ID.toString().equals(actions[j])) {
                        isGroupCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_OU_ACTION_ID.toString().equals(actions[j])) {
                        isOUCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_SHARED_MAILBOX_ACTION_ID.toString().equals(actions[j])) {
                        isSHMailboxCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_LINKED_MAILBOX_ACTION_ID.toString().equals(actions[j])) {
                        isLKMailboxCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_DL_GROUP_ACTION_ID.toString().equals(actions[j])) {
                        isDLGroupCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_RESOURCE_MAILBOX_ACTION_ID.toString().equals(actions[j])) {
                        isRCMailboxCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.CREATE_COMPUTER_ACTION_ID.toString().equals(actions[j])) {
                        isComputerCreationChecked = true;
                        continue;
                    }
                    if (DelegationUtil.PERMISSION_MGMT_ACTION_ID.toString().equals(actions[j])) {
                        isFSMPermMgmtChecked = true;
                        continue;
                    }
                    if (DelegationUtil.MODIFY_O365_DISTRIBUTION_GROUP_ACTION_ID.toString().equals(actions[j])) {
                        isO365DistGroupModificationChecked = true;
                        continue;
                    }
                    if (isUserCreationChecked && isContactCreationChecked && isGroupCreationChecked && isOUCreationChecked && isSHMailboxCreationChecked && isLKMailboxCreationChecked && isDLGroupCreationChecked && isRCMailboxCreationChecked && isComputerCreationChecked && isO365DistGroupModificationChecked) break;
                }
                Long l = roleType != null && roleType.equals("SDP") ? DelegationUtil.SDP_ADDON_ROLE_ID : (creationFieldsRoleId = isAdmpTechAvailable ? CommonUtil.SUPER_ADMIN_ROLE_ID : DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID);
                if (isUserCreationChecked) {
                    JSONObject userFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("user");
                    boolean isFieldsFilledByUser = userFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilledByUser) {
                        JSONArray userFieldsJsonArray = userFieldsJsonObj.getJSONArray("fieldsList");
                        userActions = new String[userFieldsJsonArray.length()];
                        for (i = 0; i < userFieldsJsonArray.length(); ++i) {
                            userActions[i] = userFieldsJsonArray.getString(i);
                        }
                    } else {
                        userActions = HelpDeskRoleHandler.initCreateUserActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isContactCreationChecked) {
                    JSONObject contactFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("contact");
                    boolean isFieldsFilledByContact = contactFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilledByContact) {
                        JSONArray contactFieldsJsonArray = contactFieldsJsonObj.getJSONArray("fieldsList");
                        contactActions = new String[contactFieldsJsonArray.length()];
                        for (i = 0; i < contactFieldsJsonArray.length(); ++i) {
                            contactActions[i] = contactFieldsJsonArray.getString(i);
                        }
                    } else {
                        contactActions = HelpDeskRoleHandler.initCreateContactActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isComputerCreationChecked) {
                    JSONObject computerFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("computer");
                    boolean isFieldsFilledByComputer = computerFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilledByComputer) {
                        JSONArray computerFieldsJsonArray = computerFieldsJsonObj.getJSONArray("fieldsList");
                        computerActions = new String[computerFieldsJsonArray.length()];
                        for (i = 0; i < computerFieldsJsonArray.length(); ++i) {
                            computerActions[i] = computerFieldsJsonArray.getString(i);
                        }
                    } else {
                        computerActions = HelpDeskRoleHandler.initCreateComputerActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isGroupCreationChecked) {
                    JSONObject groupFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("group");
                    boolean isFieldsFilledByGroup = groupFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilledByGroup) {
                        JSONArray groupFieldsJsonArray = groupFieldsJsonObj.getJSONArray("fieldsList");
                        groupActions = new String[groupFieldsJsonArray.length()];
                        for (i = 0; i < groupFieldsJsonArray.length(); ++i) {
                            groupActions[i] = groupFieldsJsonArray.getString(i);
                        }
                    } else {
                        groupActions = HelpDeskRoleHandler.initCreateGroupActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isOUCreationChecked) {
                    JSONObject ouFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("OU");
                    boolean isFieldsFilledByOU = ouFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilledByOU) {
                        JSONArray ouFieldsJsonArray = ouFieldsJsonObj.getJSONArray("fieldsList");
                        ouActions = new String[ouFieldsJsonArray.length()];
                        for (i = 0; i < ouFieldsJsonArray.length(); ++i) {
                            ouActions[i] = ouFieldsJsonArray.getString(i);
                        }
                    } else {
                        ouActions = HelpDeskRoleHandler.initCreateOUActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isSHMailboxCreationChecked) {
                    JSONObject shMailboxFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("sharedMailbox");
                    boolean isFieldsFilled = shMailboxFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilled) {
                        JSONArray shMailboxFieldsJsonArray = shMailboxFieldsJsonObj.getJSONArray("fieldsList");
                        shMailboxActions = new String[shMailboxFieldsJsonArray.length()];
                        for (i = 0; i < shMailboxFieldsJsonArray.length(); ++i) {
                            shMailboxActions[i] = shMailboxFieldsJsonArray.getString(i);
                        }
                    } else {
                        shMailboxActions = HelpDeskRoleHandler.initCreateShMailboxActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isLKMailboxCreationChecked) {
                    JSONObject lkMailboxFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("linkedMailbox");
                    boolean isFieldsFilled = lkMailboxFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFieldsFilled) {
                        JSONArray lkMailboxFieldsJsonArray = lkMailboxFieldsJsonObj.getJSONArray("fieldsList");
                        lkMailboxActions = new String[lkMailboxFieldsJsonArray.length()];
                        for (i = 0; i < lkMailboxFieldsJsonArray.length(); ++i) {
                            lkMailboxActions[i] = lkMailboxFieldsJsonArray.getString(i);
                        }
                    } else {
                        lkMailboxActions = HelpDeskRoleHandler.initCreateLkMailboxActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isDLGroupCreationChecked) {
                    JSONObject dlGroupFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("dlGroup");
                    boolean isFieldsFilledByDLGroup = dlGroupFieldsJsonObj.getBoolean("fieldsFilled");
                    System.out.println("isFieldsFilledByDLGroup : " + isFieldsFilledByDLGroup);
                    if (isFieldsFilledByDLGroup) {
                        JSONArray dlGroupFieldsJsonArray = dlGroupFieldsJsonObj.getJSONArray("fieldsList");
                        System.out.println("dlGroupFieldsJsonArray : " + dlGroupFieldsJsonArray);
                        dlGroupActions = new String[dlGroupFieldsJsonArray.length()];
                        for (i = 0; i < dlGroupFieldsJsonArray.length(); ++i) {
                            dlGroupActions[i] = dlGroupFieldsJsonArray.getString(i);
                        }
                    } else {
                        dlGroupActions = HelpDeskRoleHandler.initCreateDLGroupActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isRCMailboxCreationChecked) {
                    JSONObject rcMailboxFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("resourceMailbox");
                    boolean isFilled = rcMailboxFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFilled) {
                        JSONArray rcMailboxFieldsJsonArray = rcMailboxFieldsJsonObj.getJSONArray("fieldsList");
                        rcMailboxActions = new String[rcMailboxFieldsJsonArray.length()];
                        for (i = 0; i < rcMailboxFieldsJsonArray.length(); ++i) {
                            rcMailboxActions[i] = rcMailboxFieldsJsonArray.getString(i);
                        }
                    } else {
                        rcMailboxActions = HelpDeskRoleHandler.initCreateResourceMailboxActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isFSMPermMgmtChecked) {
                    JSONObject fsmPermissionFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("fsmPermission");
                    boolean isFilled = fsmPermissionFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFilled) {
                        JSONArray fsmPermissionFieldsJsonArray = fsmPermissionFieldsJsonObj.getJSONArray("fieldsList");
                        fsmPermissionActions = new String[fsmPermissionFieldsJsonArray.length()];
                        for (i = 0; i < fsmPermissionFieldsJsonArray.length(); ++i) {
                            fsmPermissionActions[i] = fsmPermissionFieldsJsonArray.getString(i);
                        }
                        fsmPermissionActions = FileServerMgmtUtil.updateOnselectActionIds((String[])fsmPermissionActions);
                    } else {
                        fsmPermissionActions = HelpDeskRoleHandler.initFSMPermissionActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (isO365DistGroupModificationChecked) {
                    JSONObject o365DistGroupFieldsJsonObj = authorizedFieldsJsonObj.getJSONObject("o365DistGroup");
                    boolean isFilled = o365DistGroupFieldsJsonObj.getBoolean("fieldsFilled");
                    if (isFilled) {
                        JSONArray o365DistGroupFieldsJsonArray = o365DistGroupFieldsJsonObj.getJSONArray("fieldsList");
                        o365DistGroupActions = new String[o365DistGroupFieldsJsonArray.length()];
                        for (i = 0; i < o365DistGroupFieldsJsonArray.length(); ++i) {
                            o365DistGroupActions[i] = o365DistGroupFieldsJsonArray.getString(i);
                        }
                    } else {
                        o365DistGroupActions = HelpDeskRoleHandler.initModifyO365DistGroupActionIds((Long)creationFieldsRoleId);
                    }
                }
                if (roleID.equals(CommonUtil.SUPER_ADMIN_ROLE_ID)) {
                    message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.cant_chng_super_admin");
                    this.logger.log(Level.INFO, "Trying to edit Super Admin Role ");
                    break block65;
                }
                if (roleID != null && roleID != 0L) {
                    if (!HelpDeskRoleHandler.isRoleExists((Long)roleID, (String)admpRoleName)) {
                        HelpDeskRoleHandler.updateADMPRole((Long)roleID, (String)admpRoleName, (String)admpRoleDescription, (String[])actions, (String[])userActions, (String[])contactActions, (String[])computerActions, (String[])groupActions, (String[])ouActions, (String[])shMailboxActions, (String[])dlGroupActions, (String[])rcMailboxActions, (String[])fsmPermissionActions, (String[])o365DistGroupActions, (String[])lkMailboxActions);
                        message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.success_updated_helpDesk_role"), EscapeUtil.escSplCharsAsHTML((Object)rb.getString(admpRoleName)));
                        this.logger.log(Level.INFO, "Status message for the saving existing role (" + roleID + "," + admpRoleName + ") is " + message);
                        loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
                        HDTAuditUtil.fillHDRolesAuditDetails((Long)loginId, (Long)DelegationUtil.HELP_DESK_ROLES_CATEGORY_ID, (String)admpRoleName, (String)"admp.deleg.hdt_deleg.hdd_reports.modified", (AdventNetResourceBundle)rb);
                        break block65;
                    }
                    message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.role_name_already_exists");
                    hashtable = new Hashtable<String, String>();
                    hashtable.put("ADMP_ROLE_NAME", admpRoleName);
                    hashtable.put("ADMP_ROLE_DESCRIPTION", admpRoleDescription);
                    request.setAttribute("message", (Object)message);
                    request.setAttribute("ROLE_DETAILS", hashtable);
                    return mapping.findForward("createADMPRole");
                }
                if (!HelpDeskRoleHandler.isRoleExists((String)admpRoleName)) {
                    HelpDeskRoleHandler.saveADMPRole((String)admpRoleName, (String)admpRoleDescription, (String)roleType, (String[])actions, (String[])userActions, (String[])contactActions, (String[])computerActions, (String[])groupActions, (String[])ouActions, (String[])shMailboxActions, (String[])dlGroupActions, (String[])rcMailboxActions, (String[])fsmPermissionActions, (String[])o365DistGroupActions, (String[])lkMailboxActions);
                    message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.success_created_helpDesk_role"), EscapeUtil.escSplCharsAsHTML((Object)rb.getString(admpRoleName)));
                    this.logger.log(Level.INFO, "Status message for the saving new role " + admpRoleName + " is " + message);
                    loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
                    HDTAuditUtil.fillHDRolesAuditDetails((Long)loginId, (Long)DelegationUtil.HELP_DESK_ROLES_CATEGORY_ID, (String)admpRoleName, (String)"admp.deleg.hdt_deleg.hdd_reports.created", (AdventNetResourceBundle)rb);
                    break block65;
                }
                message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg_error_in_creating_helpDesk_role"), rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.role_name_already_exists"));
                hashtable = new Hashtable();
                hashtable.put("ADMP_ROLE_NAME", admpRoleName);
                hashtable.put("ADMP_ROLE_DESCRIPTION", admpRoleDescription);
                request.setAttribute("message", (Object)message);
                request.setAttribute("ROLE_DETAILS", hashtable);
                return mapping.findForward("createADMPRole");
            }
            catch (DataAccessException e) {
                message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.helpDesk_role_size_exceeds");
            }
            catch (Exception e) {
                message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_saving_helpDesk_role");
                e.printStackTrace();
                this.logger.log(Level.INFO, "Error while saving the role : " + message);
            }
        }
        this.resetBean(bean, request);
        List<HashMap<String, Object>> helpDeskRolesList = this.getRolesList(request, bean);
        request.setAttribute("AdmpRoleList", helpDeskRolesList);
        request.setAttribute("statusMessage", (Object)message);
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward deleteADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        DynaValidatorForm bean = (DynaValidatorForm)form;
        String message = null;
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.ROLE_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            Long roleID = new Long(request.getParameter("roleID"));
            String roleName = HelpDeskRoleUtil.getRoleName((Long)roleID);
            if (roleName != null && roleName.length() > 0) {
                HelpDeskRoleHandler.deleteADMPRole((Long)roleID);
                message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.view_role.statmsg.successfully_deleted_role"), EscapeUtil.escSplCharsAsHTML((Object)rb.getString(roleName)));
                this.logger.log(Level.INFO, "Status message for deleting role is :: " + message);
                Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
                HDTAuditUtil.fillHDRolesAuditDetails((Long)loginId, (Long)DelegationUtil.HELP_DESK_ROLES_CATEGORY_ID, (String)roleName, (String)"admp.deleg.hdt_deleg.hdd_reports.deleted", (AdventNetResourceBundle)rb);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = exception.getMessage();
            if (message != null) {
                message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_deleting_helpDesk_roles"), message);
                request.setAttribute("statusMessage", (Object)message);
            }
            this.logger.log(Level.INFO, "Exception Occurs while deleting Helpdeskroles for the roleid" + request.getParameter("roleID") + " Message is :" + message);
        }
        this.resetBean(bean, request);
        List<HashMap<String, Object>> helpDeskRolesList = this.getRolesList(request, bean);
        request.setAttribute("AdmpRoleList", helpDeskRolesList);
        request.setAttribute("statusMessage", (Object)message);
        return mapping.findForward("viewADMPRoles");
    }

    private void resetBean(DynaValidatorForm bean, HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        int range = NavigateRangeUtil.getDefaultRange((String)"HelpDeskRoles", (Long)loginId);
        bean.set("RANGE", (Object)range);
        bean.set("TO_INDEX", (Object)range);
        bean.set("FROM_INDEX", (Object)new Integer(1));
        bean.set("searchText", (Object)"");
        bean.set("PAGE_NUMBER", (Object)"1");
    }

    private List<HashMap<String, Object>> getRolesList(HttpServletRequest request, DynaValidatorForm bean) {
        return this.getRolesList(request, bean, false);
    }

    private List<HashMap<String, Object>> getRolesList(HttpServletRequest request, DynaValidatorForm bean, Boolean isObjectClassNeeded) {
        Boolean isAscending = (Boolean)bean.get("sortOrder");
        String sortedColumn = (String)bean.get("sortColumn");
        Integer fromIndex = (Integer)bean.get("FROM_INDEX");
        Integer range = (Integer)bean.get("RANGE");
        String searchText = (String)bean.get("searchText");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String isNavigate = request.getParameter("isNavigate");
        if (isNavigate != null && isNavigate.equals("false")) {
            NavigateRangeUtil.setDefaultRange((String)"HelpDeskRoles", (int)range, (Long)loginId);
        }
        ArrayList helpDeskRolesList = HelpDeskRoleHandler.getHelpDeskRolesList((Integer)fromIndex, (Integer)range, (Boolean)isAscending, (String)sortedColumn, (String)searchText, (Boolean)isObjectClassNeeded);
        Integer totalRecordsCount = helpDeskRolesList.size();
        List rolesList = new ArrayList();
        Integer toIndex = (Integer)bean.get("TO_INDEX");
        if (helpDeskRolesList.size() >= toIndex) {
            if (fromIndex + range > totalRecordsCount) {
                rolesList = helpDeskRolesList.subList(fromIndex - 1, totalRecordsCount);
                bean.set("TO_INDEX", (Object)totalRecordsCount);
            } else {
                rolesList = helpDeskRolesList.subList(fromIndex - 1, toIndex);
            }
        } else {
            rolesList = helpDeskRolesList;
        }
        ArrayList viewColumnList = HelpDeskRoleHandler.getViewColumnList();
        bean.set("rolesCount", (Object)totalRecordsCount);
        request.setAttribute("viewColumnList", (Object)viewColumnList);
        return rolesList;
    }
}

