/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.iamapps.handler.sso.idpauth.SAMLAuthnRequestBuilder;
import com.manageengine.ads.fw.iamapps.handler.sso.idpauth.SAMLIDPAuthHandler;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class ADMPSSOAction
extends DispatchAction {
    private static String urlConfigId = ProductUniqueSeqGenerator.generateUniqueIdentifier();

    public ActionForward unspecified(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("SAMLConfigurations", (Object)SAMLIDPAuthHandler.getSAMLConfigurations((String)"LOGIN_AUTH"));
        request.setAttribute("SAMLIDPDetails", (Object)SAMLIDPAuthHandler.getSAMLIdpList());
        request.setAttribute("urlConfigId", (Object)urlConfigId);
        return actionmapping.findForward("NTLMSSOSettings");
    }

    public ActionForward saveSAMLConfig(ActionMapping actionmapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject samlConfigDetails = new JSONObject();
        Boolean isProviderConfigured = Boolean.FALSE;
        String message = "";
        String messageType = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String urlConfigId;
            String logonParams = request.getParameter("LOGONPARAMS");
            logonParams = URLDecoder.decode(logonParams, "UTF-8");
            JSONObject jsonParam = new JSONObject(logonParams);
            isProviderConfigured = jsonParam.has("isProviderConfigured") ? (Boolean)jsonParam.get("isProviderConfigured") : Boolean.TRUE;
            String providerName = jsonParam.has("providerName") ? (String)jsonParam.get("providerName") : "";
            String issuerURL = jsonParam.has("ISSUER_URL") ? (String)jsonParam.get("ISSUER_URL") : "";
            String loginURL = jsonParam.has("LOGIN_URL") ? (String)jsonParam.get("LOGIN_URL") : "";
            String logoutURL = jsonParam.has("LOGOUT_URL") ? (String)jsonParam.get("LOGOUT_URL") : "";
            String publicKey = jsonParam.has("PUBLIC_KEY") ? (String)jsonParam.get("PUBLIC_KEY") : "";
            String customissurl = jsonParam.has("customissuerurl") ? (String)jsonParam.get("customissuerurl") : "";
            String samlConfigId = jsonParam.has("samlConfigId") ? (String)jsonParam.get("samlConfigId") : "";
            String idpAuthenticatorId = jsonParam.has("idpAuthenticatorId") ? (String)jsonParam.get("idpAuthenticatorId") : "";
            String string = urlConfigId = jsonParam.has("urlConfigId") ? (String)jsonParam.get("urlConfigId") : "";
            if (providerName.equals("Custom SAML") && !customissurl.equals("")) {
                providerName = customissurl;
            }
            samlConfigDetails.put("ISSUER_URL", (Object)issuerURL);
            samlConfigDetails.put("LOGIN_URL", (Object)loginURL);
            samlConfigDetails.put("LOGOUT_URL", (Object)logoutURL);
            samlConfigDetails.put("PUBLIC_KEY", (Object)publicKey);
            samlConfigDetails.put("AUTH_MODE_NAME", (Object)"LOGIN_AUTH");
            samlConfigDetails.put("IDP_PROVIDER_NAME", (Object)providerName);
            samlConfigDetails.put("IDP_AUTHENTICATOR_ID", (Object)idpAuthenticatorId);
            if (!samlConfigId.equals("") && !samlConfigId.equals("0")) {
                samlConfigDetails.put("AUTH_CONFIG_ID", (Object)samlConfigId);
            }
            if (urlConfigId.equals("")) {
                samlConfigDetails.put("URL_CONFIG_ID", (Object)ProductUniqueSeqGenerator.generateUniqueIdentifier());
            } else {
                samlConfigDetails.put("URL_CONFIG_ID", (Object)urlConfigId);
            }
            String ssoAuthType = ADSMPersUtil.getSyMParameter((String)"SSOAuthType");
            String isSSOConfigured = ADSMPersUtil.getSyMParameter((String)"SingleSignOn");
            boolean isSAMLConfigured = true;
            if (!isProviderConfigured.booleanValue()) {
                String idpLogoName = null;
                String idpLogoPath = null;
                DynaActionForm imagekeyForm = (DynaActionForm)form;
                Map params = imagekeyForm.getMap();
                FormFile idpLogoFile = (FormFile)params.remove("logoimage");
                if (idpLogoFile != null) {
                    idpLogoName = idpLogoFile.getFileName();
                }
                if (idpLogoName != null && !idpLogoName.equals("")) {
                    try {
                        idpLogoPath = ClientUtil.storeFile(idpLogoFile, idpLogoName, "images/logos/saml_idp/");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    samlConfigDetails.put("IDP_IMAGE_PATH", (Object)"images/logos/saml_idp");
                    samlConfigDetails.put("IDP_IMAGE_NAME", (Object)idpLogoName);
                }
            }
            if ((isSAMLConfigured = SAMLIDPAuthHandler.saveSAMLIDPSettings((JSONObject)samlConfigDetails)) && message.equals("")) {
                message = rb.getString("ads.common.text.saml_saved_success");
                messageType = "success";
            }
            ADSMPersUtil.updateSyMParameter((String)"SSOAuthType", (String)"SAML");
            ADSMPersUtil.updateSyMParameter((String)"SingleSignOn", (String)"true");
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        request.setAttribute("SAMLConfigurations", (Object)SAMLIDPAuthHandler.getSAMLLoginConfigurations());
        request.setAttribute("SAMLIDPDetails", (Object)SAMLIDPAuthHandler.getSAMLIdpList());
        request.setAttribute("samlMessage", (Object)message);
        request.setAttribute("samlMessageType", (Object)messageType);
        return actionmapping.findForward("NTLMSSOSettings");
    }

    public ActionForward disableSSO(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String status = "failed";
        String messageType = "success";
        response.setContentType("text/html");
        JSONObject result = new JSONObject();
        try {
            ADSMPersUtil.updateSyMParameter((String)"SSOAuthType", (String)"");
            ADSMPersUtil.updateSyMParameter((String)"SingleSignOn", (String)"false");
            status = rb.getString("ads.common.text.success_update");
            messageType = "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            status = e.getMessage();
            messageType = "failed";
        }
        result.put("samlMessage", (Object)status);
        result.put("samlMessageType", (Object)messageType);
        CommonUtil.setResponseText((HttpServletResponse)response, (String)result.toString());
        return mapping.findForward(null);
    }

    public ActionForward downloadSPMetadata(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            response = this.downloadSPMetadataHelper(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServletResponse downloadSPMetadataHelper(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream in = null;
        ServletOutputStream outStream = response.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)outStream);
        try {
            String accessURL = "";
            int serverport = request.getServerPort();
            String uniqueId = request.getParameter("uniqueId");
            boolean isADMPProtocolSecured = request.isSecure();
            accessURL = isADMPProtocolSecured ? "https://" + InetAddress.getLocalHost().getHostName() + ":" + serverport : "http://" + InetAddress.getLocalHost().getHostName() + ":" + serverport;
            if (uniqueId == null) {
                uniqueId = "";
            }
            JSONObject spMetadata = new JSONObject();
            spMetadata.put("ENTITY_ID", (Object)accessURL);
            spMetadata.put("LOGOUT_URL", (Object)(accessURL + "/samlLogout/" + uniqueId));
            spMetadata.put("ACS_URL", (Object)(accessURL + "/samlLogin/" + uniqueId));
            String metaDataStr = SAMLAuthnRequestBuilder.generateSPMetaData((JSONObject)spMetadata);
            response.setContentType("application/octet-stream");
            response.setContentLength(metaDataStr.length());
            response.setHeader("Content-Disposition", "attachment;filename=\"sp_metadata.xml\"");
            in = new ByteArrayInputStream(metaDataStr.getBytes());
            byte[] sendData = new byte[metaDataStr.length()];
            in.read(sendData);
            bos.write(sendData, 0, sendData.length);
            bos.flush();
            response.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            outStream.close();
            bos.close();
            in.close();
        }
        return response;
    }
}

