/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.ADMPGroupDelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.BulkEditTechnicianHandler;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianDataHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianGroupHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianListener;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupTableDataModel;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.delegation.HDTReportListener;
import com.adventnet.sym.adsm.common.webclient.delegation.TechnicianConfig;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPTechnicianAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(ADMPTechnicianAction.class.getName());

    public ActionForward viewTechnicians(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        ArrayList<String> authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.TECHNICIAN_ACTION_ID);
        request.setAttribute("domainName", (Object)authorizedDomainList.get(0));
        request.setAttribute("domainOUList", new Hashtable());
        request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)loginId));
        request.setAttribute("rolesList", (Object)HelpDeskRoleHandler.getADMPRoles());
        request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"HelpDeskTechnician", (Long)loginId));
        return mapping.findForward("viewADMPUsers");
    }

    public ActionForward listTechnicianRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long cvId = ColumnConfiguration.getCVId((String)"HelpDeskTechnician", (long)loginId);
            if (cvId == null) {
                ColumnConfiguration.createCVMapping((String)"HelpDeskTechnician", (Long)loginId);
                cvId = ColumnConfiguration.getCVId((String)"HelpDeskTechnician", (long)loginId);
            }
            ArrayList viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            Integer fromIndex = (Integer)json.get("startIndex");
            Boolean isAscending = json.getBoolean("ascending");
            Boolean isNewRange = json.getBoolean("isNewRange");
            Integer range = (Integer)json.get("range");
            String sortColumn = (String)json.get("sortColumn");
            String viewType = (String)json.get("viewType");
            if (viewType == null || viewType.equalsIgnoreCase("defaultView")) {
                viewType = ADMPGroupDelegationUtil.getAllDelegatedGroups().size() > 0 ? "groupView" : "listView";
                json.put("viewType", (Object)viewType);
            }
            if (isNewRange.booleanValue()) {
                NavigateRangeUtil.setDefaultRange((String)"HelpDeskTechnician", (int)range, (Long)loginId);
            }
            Hashtable userGroupMapping = ADMPGroupDelegationUtil.getUserGroupMapping();
            ArrayList techList = new ArrayList();
            if (viewType.equalsIgnoreCase("groupView")) {
                Hashtable groupUserMapping = ADMPGroupDelegationUtil.getGroupUserMapping();
                request.setAttribute("groupUserMapping", (Object)groupUserMapping);
                Hashtable userProp = TechnicianHandler.getTechnicianMap((String)"HelpDeskUser", (JSONObject)json, (ArrayList)viewColumnList, (Hashtable)userGroupMapping);
                request.setAttribute("userProp", (Object)userProp);
                Hashtable resultUsers = userProp;
                if ((String)json.get("searchText") != null && !((String)json.get("searchText")).equals("") && !((String)json.get("typeFilters")).equalsIgnoreCase("User")) {
                    resultUsers = TechnicianHandler.getTechnicianMap((String)"HelpDeskUser", (JSONObject)json, (ArrayList)viewColumnList, (Hashtable)userGroupMapping, (Boolean)true);
                    ArrayList<Long> resultUserLoginIds = new ArrayList<Long>();
                    Set keys = resultUsers.keySet();
                    for (Long key : keys) {
                        resultUserLoginIds.add(key);
                    }
                    ArrayList mappedGroupList = ADMPGroupDelegationUtil.getMappedGroupList(resultUserLoginIds);
                    json.put("mappedGroupList", (Object)mappedGroupList);
                }
                request.setAttribute("resultUsers", (Object)resultUsers);
                techList = TechnicianHandler.getAvailableTechnicianAndDelegatedGroups((JSONObject)json, (ArrayList)viewColumnList);
            } else {
                techList = TechnicianHandler.getAvailableTechnicianAndDelegatedGroups((JSONObject)json, (ArrayList)viewColumnList);
            }
            ArrayList<String> authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.TECHNICIAN_ACTION_ID);
            Integer toIndex = fromIndex + range - 1;
            if (techList.size() < toIndex) {
                toIndex = techList.size();
            }
            List technicianList = techList.subList(fromIndex - 1, toIndex);
            if (viewType.equalsIgnoreCase("groupView")) {
                Hashtable hash;
                int i;
                ArrayList directUsers = TechnicianDataHandler.getDirectUsers();
                ArrayList<Long> selectedDirectUsersList = new ArrayList<Long>();
                ArrayList<Hashtable> forcedOutList = new ArrayList<Hashtable>();
                ArrayList reOrderedTechnicianList = new ArrayList();
                for (i = 0; i < techList.size(); ++i) {
                    hash = (Hashtable)techList.get(i);
                    String classType = "User";
                    if (hash.get("ClassType") != null) {
                        classType = (String)hash.get("ClassType");
                    }
                    String statusOfObject = (String)hash.get("Account Status");
                    ArrayList roleList = (ArrayList)hash.get("ADMP_ROLE_NAME");
                    if (classType.equalsIgnoreCase("User") && (statusOfObject.equalsIgnoreCase("FORCEDOUT") || roleList == null || roleList.size() == 0)) {
                        forcedOutList.add(hash);
                        continue;
                    }
                    reOrderedTechnicianList.add(hash);
                }
                for (i = 0; i < forcedOutList.size(); ++i) {
                    reOrderedTechnicianList.add(forcedOutList.get(i));
                }
                technicianList = reOrderedTechnicianList.subList(fromIndex - 1, toIndex);
                for (i = 0; i < technicianList.size(); ++i) {
                    hash = (Hashtable)technicianList.get(i);
                    Long techId = (Long)hash.get("Login ID");
                    String classType = "User";
                    if (hash.get("ClassType") != null) {
                        classType = (String)hash.get("ClassType");
                    }
                    if (!classType.equalsIgnoreCase("User") || !directUsers.contains(techId)) continue;
                    selectedDirectUsersList.add(techId);
                }
                request.setAttribute("directUsers", selectedDirectUsersList);
            }
            request.setAttribute("userGroupMapping", (Object)userGroupMapping);
            request.setAttribute("domainName", (Object)authorizedDomainList.get(0));
            request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)loginId));
            request.setAttribute("totalCount", (Object)techList.size());
            request.setAttribute("viewColumnList", (Object)viewColumnList);
            request.setAttribute("usersList", technicianList);
            request.setAttribute("searchText", (Object)((String)json.get("searchText")));
            request.setAttribute("sortOrder", (Object)(isAscending == false ? 1 : 0));
            request.setAttribute("sortColumn", (Object)sortColumn);
            request.setAttribute("viewType", (Object)viewType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("ListTechniciansRows");
    }

    public ActionForward addBulkTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String defaultNamingContext = (String)json.get("domainName");
        Properties domainproperties = DomainUtil.getDomainDetails((String)defaultNamingContext, (String)"DEFAULT_NAMING_CONTEXT");
        String domainName = domainproperties.getProperty("DOMAIN_NAME");
        String selectedTechnicianlist = request.getParameter("selectedUserlist");
        JSONObject selectedListJson = new JSONObject(selectedTechnicianlist);
        String selectedUserType = request.getParameter("selectedUserType");
        JSONObject selectedUserTypeJson = new JSONObject(selectedUserType);
        JSONObject selectedGroupList = new JSONObject();
        JSONObject selectedUserList = new JSONObject();
        boolean isGroupAvailable = false;
        boolean isUserAvailable = false;
        Iterator itr = selectedListJson.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Integer objectType = selectedUserTypeJson.getInt(key);
            if (objectType.equals(3)) {
                isGroupAvailable = true;
                selectedGroupList.put(key, (Object)selectedListJson.getString(key));
                continue;
            }
            if (!objectType.equals(10)) continue;
            selectedUserList.put(key, (Object)selectedListJson.getString(key));
            isUserAvailable = true;
        }
        String statusMessage = null;
        ArrayList statusList = new ArrayList();
        String successStatus = "";
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            ArrayList errormsglist = new ArrayList();
            if (isUserAvailable) {
                errormsglist = TechnicianListener.addNewObject((HttpServletRequest)request, (JSONObject)json, (JSONObject)selectedUserList);
                statusList.addAll(errormsglist);
            }
            if (isGroupAvailable) {
                errormsglist = TechnicianListener.addBulkGroupBasedDelegation((HttpServletRequest)request, (JSONObject)json, (JSONObject)selectedGroupList);
                statusList.addAll(errormsglist);
            }
            Properties statProp = HelpdeskUtil.getStatusMsgProp(statusList, (AdventNetResourceBundle)rb, (String)"add");
            statusMessage = (String)statProp.get("statusMessage");
            successStatus = (String)statProp.get("successStatus");
            this.logger.log(Level.INFO, "Status message for add new technician is " + statusMessage + " LoginId for newly created technician : " + statusList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.INFO, "Exception occurs while adding new technician");
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", statusList);
        request.setAttribute("listHDTOpt", (Object)"all");
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward copyTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String domainName = (String)json.get("domainName");
        String statusMessage = null;
        ArrayList statusList = new ArrayList();
        String successStatus = "";
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            statusList = TechnicianListener.copyNewObject((HttpServletRequest)request);
            Properties statProp = HelpdeskUtil.getStatusMsgProp((ArrayList)statusList, (AdventNetResourceBundle)rb, (String)"copy");
            statusMessage = (String)statProp.get("statusMessage");
            successStatus = (String)statProp.get("successStatus");
            this.logger.log(Level.INFO, "Status message for add new technician is " + statusMessage + " LoginId for newly created technician : " + statusList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.INFO, "Exception occurs while adding new technician");
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", (Object)statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward deleteAccount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String successStatus;
        ArrayList<Properties> statusList;
        String statusMessage;
        block22: {
            Locale locale = request.getLocale();
            HttpSession session = request.getSession();
            Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            statusMessage = null;
            statusList = new ArrayList<Properties>();
            successStatus = "";
            try {
                String isADMPGroupAvailable;
                String isADMPUserAvailable = request.getParameter("isADMPUserAvailable");
                if (isADMPUserAvailable.equalsIgnoreCase("true")) {
                    if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                        throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                    }
                    String anonymousParamsString = request.getParameter("anonymousParams");
                    JSONObject anonymousParamsJson = new JSONObject();
                    if (anonymousParamsString != null && !anonymousParamsString.equals("")) {
                        anonymousParamsJson = new JSONObject(anonymousParamsString);
                    }
                    Hashtable<Long, String> anonyHash = new Hashtable<Long, String>();
                    String params = request.getParameter("params");
                    JSONObject json = new JSONObject(params);
                    String isRequesterDeleted = "true";
                    String isChangeScheduleOwner = "false";
                    if (request.getParameter("isRequesterDeleted") != null) {
                        isRequesterDeleted = request.getParameter("isRequesterDeleted");
                    }
                    if (request.getParameter("isChangeScheduleOwner") != null) {
                        isChangeScheduleOwner = request.getParameter("isChangeScheduleOwner");
                    }
                    Long[] loginIds = new Long[json.length()];
                    int index = 0;
                    Iterator itr = json.keys();
                    while (itr.hasNext()) {
                        Long techId;
                        String key = (String)itr.next();
                        String classType = (String)json.get(key);
                        loginIds[index] = techId = new Long(key);
                        ++index;
                        Hashtable accountDetailsHash = ADMPUserHandler.getUser((Long)techId, (AdventNetResourceBundle)rb);
                        String domainName = (String)accountDetailsHash.get("DOMAIN_NAME");
                        String name = ClientUtil.htmlEscape((String)accountDetailsHash.get("NAME"));
                        Boolean isSuccess = false;
                        this.logger.log(Level.INFO, "Going to delete the technician : " + techId + " by " + sessionLoginId + " : " + isRequesterDeleted);
                        if (domainName.equals("ADManager Plus Authentication") && ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue() && !key.equalsIgnoreCase(DelegationUtil.ADMIN_LOGIN_ID.toString())) {
                            isSuccess = TechnicianListener.delete((Long)techId, (Long)sessionLoginId, (String)isRequesterDeleted, (String)isChangeScheduleOwner, (AdventNetResourceBundle)rb);
                        } else if (ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                            isSuccess = TechnicianListener.delete((Long)techId, (Long)sessionLoginId, (String)isRequesterDeleted, (String)isChangeScheduleOwner, (AdventNetResourceBundle)rb);
                        }
                        this.logger.log(Level.INFO, "Delete the technician : " + techId + " - isSuccess " + isSuccess);
                        Properties statusprop = new Properties();
                        statusprop.setProperty("Name", name);
                        statusprop.put("isSuccess", isSuccess);
                        statusprop.setProperty("Type", classType);
                        if (isSuccess.booleanValue()) {
                            statusprop.setProperty("statusMessage", rb.getString("client.admin.CustomTitles.successfully_removed"));
                            if (anonymousParamsJson.has(key)) {
                                String anonyName = URLDecoder.decode(anonymousParamsJson.getString(key).replace("\\\\", "\\"), "UTF-8");
                                if (anonyName.length() > 50) {
                                    anonyName = anonyName.substring(0, 49);
                                }
                                anonyHash.put(techId, anonyName);
                            }
                        } else {
                            statusprop.setProperty("statusMessage", rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        statusList.add(statusprop);
                    }
                    if (isChangeScheduleOwner.equalsIgnoreCase("true")) {
                        SchedulerHandler.changeOwnerForAllSchedulers((Long[])loginIds);
                    }
                    WorkFlowUtil.changeOwnerForAllWFSchedulers((Long[])loginIds);
                    if (CommonUtil.isAnonymizationEnabled() && CommonUtil.isGDPRComplianceEnabled() && anonyHash.size() != 0) {
                        boolean anonyStatus = CommonUtil.anonymizeTechName(anonyHash);
                        this.logger.log(Level.INFO, "anonyStatus : " + anonyStatus);
                    }
                }
                if ((isADMPGroupAvailable = request.getParameter("isADMPGroupAvailable")).equalsIgnoreCase("true")) {
                    String groupJsonString = request.getParameter("selectedGroups");
                    JSONObject groupJson = new JSONObject(groupJsonString);
                    Iterator itr = groupJson.keys();
                    while (itr.hasNext()) {
                        String groupId = (String)itr.next();
                        Long id = Long.parseLong(groupId);
                        String name = ClientUtil.htmlEscape((String)groupJson.get(groupId));
                        String domainName = ADMPGroupDelegationUtil.getADMPGroupDomainName((Long)id);
                        Boolean isSuccess = false;
                        if (ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                            isSuccess = TechnicianListener.deleteADMPGroup((Long)id, (Long)sessionLoginId, (AdventNetResourceBundle)rb);
                        }
                        Properties statusprop = new Properties();
                        statusprop.setProperty("Name", name);
                        statusprop.put("isSuccess", isSuccess);
                        statusprop.setProperty("Type", "Group");
                        if (isSuccess.booleanValue()) {
                            statusprop.setProperty("statusMessage", rb.getString("client.admin.CustomTitles.successfully_removed"));
                        } else {
                            statusprop.setProperty("statusMessage", rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        statusList.add(statusprop);
                    }
                }
                Properties statProp = HelpdeskUtil.getStatusMsgProp(statusList, (AdventNetResourceBundle)rb, (String)"delete");
                statusMessage = (String)statProp.get("statusMessage");
                successStatus = (String)statProp.get("successStatus");
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception occurs while updating the account status");
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) break block22;
                this.logger.log(Level.SEVERE, "!! Error in deleting Technician :" + message);
            }
        }
        request.setAttribute("statusMessage", statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward updateAccountStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String statusMessage = "";
        ArrayList<Properties> statusList = new ArrayList<Properties>();
        String successStatus = "";
        try {
            String isADMPGroupAvailable;
            String operation = request.getParameter("operation");
            String isADMPUserAvailable = request.getParameter("isADMPUserAvailable");
            if (isADMPUserAvailable.equalsIgnoreCase("true")) {
                if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String status = request.getParameter("status");
                String params = request.getParameter("params");
                JSONObject json = new JSONObject(params);
                String isRequesterDisabled = request.getParameter("isRequesterDisabled");
                Iterator itr = json.keys();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    Hashtable accountDetailsHash = ADMPUserHandler.getUser((Long)new Long(key), (AdventNetResourceBundle)rb);
                    String domainName = (String)accountDetailsHash.get("DOMAIN_NAME");
                    String name = ClientUtil.htmlEscape((String)accountDetailsHash.get("NAME"));
                    Boolean isSuccess = false;
                    String UIStatusMessage = "";
                    try {
                        Properties statusProp = null;
                        if (key.equalsIgnoreCase(DelegationUtil.ADMIN_LOGIN_ID.toString())) {
                            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        if (domainName.equals("ADManager Plus Authentication") && ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue() && !key.equalsIgnoreCase(DelegationUtil.ADMIN_LOGIN_ID.toString())) {
                            statusProp = TechnicianListener.updateAccountStatus((String)key, (String)status, (HttpServletRequest)request, (AdventNetResourceBundle)rb, (String)isRequesterDisabled);
                        } else if (ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                            statusProp = TechnicianListener.updateAccountStatus((String)key, (String)status, (HttpServletRequest)request, (AdventNetResourceBundle)rb, (String)isRequesterDisabled);
                        } else {
                            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        if (statusProp.get("ErrorMessage") == null) {
                            isSuccess = true;
                            statusMessage = (String)statusProp.get("statusMessage");
                        } else {
                            isSuccess = false;
                            statusMessage = (String)statusProp.get("ErrorMessage");
                        }
                        UIStatusMessage = (String)statusProp.get("UIStatusMessage");
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        if (message == null) continue;
                        message = rb.getString(message);
                        Properties statusprop = new Properties();
                        statusprop.setProperty("Name", name);
                        statusprop.put("isSuccess", isSuccess);
                        statusprop.setProperty("statusMessage", message);
                        statusprop.setProperty("UIStatusMessage", message);
                        statusList.add(statusprop);
                        continue;
                    }
                    Properties statusprop = new Properties();
                    statusprop.setProperty("Name", name);
                    statusprop.put("isSuccess", isSuccess);
                    statusprop.setProperty("statusMessage", statusMessage);
                    statusprop.setProperty("UIStatusMessage", UIStatusMessage);
                    statusList.add(statusprop);
                }
            }
            if ((isADMPGroupAvailable = request.getParameter("isADMPGroupAvailable")).equalsIgnoreCase("true")) {
                ADMPTechnicianAction.changeGroupStatus(request, statusList);
            }
            Properties statProp = HelpdeskUtil.getStatusMsgProp(statusList, (AdventNetResourceBundle)rb, (String)operation);
            statusMessage = (String)statProp.get("statusMessage");
            successStatus = (String)statProp.get("successStatus");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occurs while updating the account status");
            e.printStackTrace();
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward isTechnicianAsRequester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean isRequester = false;
            boolean isScheduleAvailable = false;
            String idString = request.getParameter("id");
            String isSchedulerCheckNeeded = request.getParameter("isSchedulerCheckNeeded");
            String[] loginIdArray = idString.split(",");
            for (int i = 0; i < loginIdArray.length; ++i) {
                if (loginIdArray[i] == null || loginIdArray[i] == "") continue;
                Long login_id = Long.parseLong(loginIdArray[i]);
                boolean isTechAsRequester = HelpdeskUtil.isRequester((Long)login_id);
                if (!isRequester) {
                    isRequester = isTechAsRequester;
                }
                if (isSchedulerCheckNeeded == null || !isSchedulerCheckNeeded.equalsIgnoreCase("true") || !SchedulerUtil.isSchedulerAvailableAsOwner((Long)login_id).booleanValue()) continue;
                isScheduleAvailable = true;
            }
            JSONObject umlautJSONObj = new JSONObject();
            umlautJSONObj.put("isTechAsRequester", isRequester);
            umlautJSONObj.put("isScheduleAvailable", isScheduleAvailable);
            umlautJSONObj.put("isGDPRComplianceEnabled", CommonUtil.isGDPRComplianceEnabled());
            umlautJSONObj.put("isAnonymizationEnabled", CommonUtil.isAnonymizationEnabled());
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(umlautJSONObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward editTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        Long loginID = new Long(request.getParameter("loginID"));
        this.logger.log(Level.INFO, "Getting the technician details for the loginid : " + loginID);
        String classType = request.getParameter("classType");
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            if (loginID != null) {
                Hashtable hash = null;
                if (classType.equalsIgnoreCase("User")) {
                    boolean isDirectUser = TechnicianDataHandler.isDirectUser((Long)loginID);
                    hash = ADMPUserHandler.getUser((Long)loginID, (AdventNetResourceBundle)rb, (boolean)isDirectUser);
                } else if (classType.equalsIgnoreCase("Group")) {
                    hash = TechnicianGroupHandler.getADMPGroupDetails((Long)loginID, (String)classType, (String)"ADSMGroupGeneralDetails", (AdventNetResourceBundle)rb);
                }
                TechnicianConfig.setUserDetails(request, bean, hash, rb);
                request.setAttribute("TechnicianId", (Object)loginID);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mapping.findForward("createTechnician");
    }

    public ActionForward updateTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean;
        String statusMessage;
        HttpSession session;
        AdventNetResourceBundle rb;
        block12: {
            String message;
            Locale locale = request.getLocale();
            rb = ResourceBundleMgr.getInstance().getBundle(locale);
            session = request.getSession();
            statusMessage = null;
            bean = (DynaValidatorForm)form;
            Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            try {
                if (!sessionLoginId.equals(DelegationUtil.ADMIN_LOGIN_ID) && !ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                String objectType = request.getParameter("objectType");
                if (objectType.equalsIgnoreCase("User")) {
                    statusMessage = TechnicianConfig.updateHelpDeskTechnician(request, bean, rb);
                } else if (objectType.equalsIgnoreCase("Group")) {
                    statusMessage = TechnicianConfig.updateADMPGroup(request, bean, rb);
                }
                this.resetBean(bean, request);
                this.reInit(bean);
            }
            catch (LocalizedException le) {
                message = le.getMessage(rb);
                if (message != null) {
                    this.logger.log(Level.SEVERE, "!! Error in Updating HDT :" + message);
                    if (!message.startsWith("License")) {
                        message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_user"), rb.getString(message));
                    }
                    request.setAttribute("ErrorMessage", (Object)message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                message = e.getMessage();
                if (message == null) break block12;
                this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                if (!message.startsWith("License")) {
                    message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_user"), rb.getString(message));
                }
                request.setAttribute("ErrorMessage", (Object)message);
            }
        }
        if (statusMessage != null) {
            request.setAttribute("statusMessage", statusMessage);
        }
        this.logger.log(Level.INFO, "Status message for update technician is : " + statusMessage);
        this.resetBean(bean, request);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        ArrayList<String> authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.TECHNICIAN_ACTION_ID);
        request.setAttribute("domainName", (Object)authorizedDomainList.get(0));
        request.setAttribute("domainOUList", new Hashtable());
        request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)loginId));
        request.setAttribute("rolesList", (Object)HelpDeskRoleHandler.getADMPRoles());
        request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"HelpDeskTechnician", (Long)loginId));
        return mapping.findForward("viewADMPUsers");
    }

    private void reInit(DynaValidatorForm bean) {
        String[] ar;
        for (String string : ar = new String[]{"userDN", "userNameString"}) {
            bean.set(string, (Object)"");
        }
        bean.set("domainOUList", new Hashtable());
        bean.set("description", (Object)"");
        bean.set("emailAddress", (Object)"");
        bean.set("templateList", (Object)"");
        bean.set("configuredDomains", (Object)new String[0]);
        bean.set("adminCredential", new Hashtable());
        bean.set("includeGroupsMap", new HashMap());
        bean.set("excludeGroupsMap", new HashMap());
        bean.set("sortColumn", (Object)"FULL_NAME");
    }

    public ActionForward addObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("HelpDeskTechnicianBean");
        try {
            String selectedObjects = request.getParameter("selectedObjects");
            String selectedObjectNames = request.getParameter("selectedObjectNames");
            String objectClass = request.getParameter("objectClass");
            String selectVariable = request.getParameter("selectVariable");
            String deSelectVariable = null;
            deSelectVariable = selectVariable.equals("includeGroups") ? "excludeGroups" : "includeGroups";
            String[] objectStr = selectedObjects.split(";;;");
            String[] objectNamesStr = selectedObjectNames.split(";;;");
            String domainName = request.getParameter("domainName");
            HashMap selectedObjectsMap = (HashMap)bean.get(selectVariable + "Map");
            HashMap deSelectedObjectsMap = (HashMap)bean.get(deSelectVariable + "Map");
            ArrayList objectList = (ArrayList)selectedObjectsMap.get(objectClass);
            ArrayList deSelectObjectList = (ArrayList)deSelectedObjectsMap.get(objectClass);
            if (objectList == null) {
                objectList = new ArrayList();
            }
            for (int i = 0; i < objectStr.length; ++i) {
                String object = objectStr[i];
                String objectName = domainName + "\\" + objectNamesStr[i];
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("DISTINGUISHED_NAME", object);
                objectMap.put("NAME", objectName);
                if (objectClass.equals("organizationalUnit")) {
                    Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                    ClientUtil.getOUDetails(domainName, object, loginId);
                }
                if (deSelectObjectList != null && deSelectObjectList.contains(objectMap) || objectList.contains(objectMap)) continue;
                objectList.add(objectMap);
            }
            selectedObjectsMap.put(objectClass, objectList);
            System.out.println("Bean group add" + selectVariable + " : " + selectedObjectsMap);
            bean.set(selectVariable + "Map", (Object)selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("HelpDeskTechnicianBean");
        try {
            String selectedObjects = request.getParameter("selectedObjects");
            String selectedObjectNames = request.getParameter("selectedObjectNames");
            String objectClasses = request.getParameter("objectClasses");
            String selectVariable = request.getParameter("selectVariable");
            String domainName = request.getParameter("domainName");
            String[] objects = selectedObjects.split(";;;");
            String[] objectNames = selectedObjectNames.split(";;;");
            String[] objectClass = objectClasses.split(";;;");
            HashMap selectedObjectsMap = (HashMap)bean.get(selectVariable + "Map");
            for (int i = 0; i < objects.length; ++i) {
                ArrayList objectList = (ArrayList)selectedObjectsMap.get(objectClass[i]);
                if (objectList == null) {
                    objectList = new ArrayList();
                }
                String objectName = objectNames[i];
                for (HashMap objectMap : objectList) {
                    if (!((String)objectMap.get("DISTINGUISHED_NAME")).equals(objects[i])) continue;
                    objectList.remove(objectMap);
                    break;
                }
                if (objectList.isEmpty()) {
                    selectedObjectsMap.remove(objectClass[i]);
                    continue;
                }
                selectedObjectsMap.put(objectClass[i], objectList);
            }
            System.out.println("Bean group remove" + selectVariable + " : " + selectedObjectsMap);
            bean.set(selectVariable + "Map", (Object)selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward selfServiceAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forward = "SelfServiceAccounts";
        String statusMessage = null;
        try {
            String SelfService;
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)form;
            String operation = request.getParameter("operation");
            if (operation != null && operation.equalsIgnoreCase("delete")) {
                Long loginId = Long.parseLong(request.getParameter("loginId"));
                statusMessage = HelpdeskUtil.deleteADMPUser((Long)loginId) ? rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.success_deleted_user") : rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.error_deleting_user");
            }
            if (request.getParameter("Save") != null) {
                SelfService = request.getParameter("enableSelfService");
                if (SelfService == null) {
                    SelfService = "false";
                }
                ADSMPersUtil.updateSyMParameter((String)"SelfService", (String)SelfService);
                return null;
            }
            SelfService = ADSMPersUtil.getSyMParameter((String)"SelfService");
            bean.set("enableSelfServiceportal", (Object)SelfService);
            request.setAttribute("statusMessage", statusMessage);
            TechnicianConfig.setSelfServiceConfDetails(request, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("statusMessage", (Object)rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.error_updating_settings"));
        }
        return mapping.findForward(forward);
    }

    private void resetBean(DynaValidatorForm bean, HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        int range = NavigateRangeUtil.getDefaultRange((String)"HelpDeskTechnician", (Long)loginId);
        bean.set("RANGE", (Object)range);
        bean.set("TO_INDEX", (Object)range);
        bean.set("FROM_INDEX", (Object)new Integer(1));
        bean.set("searchText", (Object)"");
        bean.set("PAGE_NUMBER", (Object)"1");
    }

    public ActionForward showResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        ArrayList<Long> cvIdList = new ArrayList<Long>();
        Long userCvId = ColumnConfiguration.getDefaultCvId((String)"USERMODIFYREQ");
        cvIdList.add(userCvId);
        Long groupCvId = ColumnConfiguration.getDefaultCvId((String)"GROUPMODIFYREQ");
        cvIdList.add(groupCvId);
        for (Long cvId : cvIdList) {
            ArrayList columnList = ColumnConfiguration.getViewColumnList((long)cvId);
            HashMap columnProp = (HashMap)columnList.get(0);
            String tableName = (String)columnProp.get("TABLE_NAME");
            PopupTableDataModel popupTableModel = new PopupTableDataModel();
            ArrayList totalColumn = ColumnConfiguration.getTotalColumnList((long)cvId);
            for (int k = 0; k < totalColumn.size(); ++k) {
                Boolean isUniqueDisplayColumn;
                HashMap map = (HashMap)totalColumn.get(k);
                Boolean isUniqueColumn = (Boolean)map.get("IS_UNIQUE_VALUE_COLUMN");
                if (isUniqueColumn.booleanValue()) {
                    popupTableModel.setUniqueColumnMap(map);
                }
                if (!(isUniqueDisplayColumn = (Boolean)map.get("IS_UNIQUE_DISPLAY_COLUMN")).booleanValue()) continue;
                popupTableModel.setUniqueDisplayColumnMap(map);
            }
            Boolean isWorkflowMode = Boolean.FALSE;
            DataObject dataObj = WorkFlowClientUtil.getResultList(params, loginId, columnList, request, isWorkflowMode);
            popupTableModel.setUniqueIdAndValueInTableDataWithDO(dataObj, tableName);
            popupTableModel.setColumnList(columnList);
            if (cvId.equals(userCvId)) {
                request.setAttribute("DropDownResultDataModel", (Object)popupTableModel);
                continue;
            }
            if (!cvId.equals(groupCvId)) continue;
            request.setAttribute("GroupDropDownResultDataModel", (Object)popupTableModel);
        }
        return mapping.findForward("showListInDropDown");
    }

    public ActionForward addOus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            String distinguishedName = request.getParameter("distinguishedName");
            String selectedOus = request.getParameter("selectedOus");
            String domainName = request.getParameter("domainName");
            JSONObject selectedOUsJson = new JSONObject(selectedOus);
            ArrayList<String> list = new ArrayList<String>();
            Iterator itr = selectedOUsJson.keys();
            while (itr.hasNext()) {
                String selectedOUDN = (String)itr.next();
                if (list.contains(selectedOUDN) || selectedOUDN.equalsIgnoreCase(distinguishedName)) continue;
                list.add(selectedOUDN);
            }
            domainOUList.put(distinguishedName, list);
            bean.set("domainOUList", (Object)domainOUList);
            request.setAttribute("selectedOUList", list);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)distinguishedName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("selectedOUsDiv");
    }

    public ActionForward showBulkEditTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        DynaValidatorForm bean = (DynaValidatorForm)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        bean.set("loginID", (Object)loginId);
        String selectedUserList = request.getParameter("selectedUserList");
        JSONObject selectedUserListJson = new JSONObject(selectedUserList);
        String selectedGroupList = request.getParameter("selectedGroupList");
        JSONObject selectedGroupListJson = new JSONObject(selectedGroupList);
        ArrayList<Long> techList = new ArrayList<Long>();
        Iterator itr = selectedUserListJson.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            techList.add(new Long(key));
        }
        ArrayList<Long> hdtGroupList = new ArrayList<Long>();
        itr = selectedGroupListJson.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            hdtGroupList.add(new Long(key));
        }
        JSONObject techListJSON = BulkEditTechnicianHandler.getSelectedTechDetails(techList, hdtGroupList, (AdventNetResourceBundle)rb);
        ArrayList<String> authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.TECHNICIAN_ACTION_ID);
        request.setAttribute("domainName", (Object)authorizedDomainList.get(0));
        request.setAttribute("defaultNamingContext", (Object)DomainUtil.getDefaultNamingContext((String)authorizedDomainList.get(0)));
        request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)loginId));
        request.setAttribute("domainOUList", new Hashtable());
        request.setAttribute("rolesList", (Object)HelpDeskRoleHandler.getADMPRoles());
        request.setAttribute("templateList", (Object)FcLayoutViewHandler.getAllAuthorizedLayoutsUnchecked((Long)loginId));
        request.setAttribute("technicianList", (Object)techListJSON);
        request.setAttribute("waadAccountsVsDetails", (Object)HelpdeskUtil.getWAADAccountDetails((Long)loginId, (String)"User", (boolean)false));
        return mapping.findForward("bulkEditTechnician");
    }

    public ActionForward bulkEditTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String domainName = (String)json.get("domainName");
        String statusMessage = null;
        ArrayList statusList = new ArrayList();
        String successStatus = "";
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            statusList = BulkEditTechnicianHandler.bulkEditTechnician((HttpServletRequest)request);
            Properties statProp = HelpdeskUtil.getStatusMsgProp((ArrayList)statusList, (AdventNetResourceBundle)rb, (String)"edit");
            JSONObject techList = (JSONObject)json.get("technicianList");
            Iterator itr1 = techList.keys();
            while (itr1.hasNext()) {
                String loginIdStr = (String)itr1.next();
                String[] loginIdStrArray = loginIdStr.split("_");
                String objectClass = new String(loginIdStrArray[0]);
                Long loginId = new Long(loginIdStrArray[1]);
                TechnicianHandler.manageAccountRole((Long)loginId);
            }
            statusMessage = (String)statProp.get("statusMessage");
            successStatus = (String)statProp.get("successStatus");
            this.logger.log(Level.INFO, "Status message for add new technician is " + statusMessage + " LoginId for newly created technician : " + statusList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.INFO, "Exception occurs while adding new technician");
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", (Object)statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward getOutputFilters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONArray filtersList = ADMPGroupDelegationUtil.getOutputFilterJsonArray((AdventNetResourceBundle)rb);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("outputFilters", (Object)filtersList);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward changeGroupStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String statusMessage = "";
        ArrayList statusList = new ArrayList();
        String successStatus = "";
        try {
            ADMPTechnicianAction.changeGroupStatus(request, statusList);
            String operation = request.getParameter("operation");
            Properties statProp = HelpdeskUtil.getStatusMsgProp(statusList, (AdventNetResourceBundle)rb, (String)operation);
            statusMessage = (String)statProp.get("statusMessage");
            successStatus = (String)statProp.get("successStatus");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occurs while updating the account status");
            e.printStackTrace();
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("successStatus", (Object)successStatus);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public static void changeGroupStatus(HttpServletRequest request, ArrayList statusList) throws Exception {
        String statusMessage = "";
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        String operation = request.getParameter("operation");
        Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String changeStatusTo = request.getParameter("changeStatusTo");
        Boolean isSuccess = false;
        String UIStatusMessage = "";
        Hashtable groupUserMapping = ADMPGroupDelegationUtil.getGroupUserMapping();
        String groupJsonString = request.getParameter("selectedGroups");
        JSONObject groupJson = new JSONObject(groupJsonString);
        Iterator itr = groupJson.keys();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            Long groupID = Long.parseLong(id);
            String name = ClientUtil.htmlEscape((String)groupJson.get(id));
            String domainName = ADMPGroupDelegationUtil.getADMPGroupDomainName((Long)groupID);
            ArrayList loginIdList = (ArrayList)groupUserMapping.get(groupID);
            if (loginIdList.contains(sessionLoginId)) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            try {
                Properties statusProp = null;
                if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.TECHNICIAN_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                statusProp = TechnicianListener.updateADMPGroupStatus((Long)groupID, (String)changeStatusTo, (HttpServletRequest)request, (AdventNetResourceBundle)rb);
                if (statusProp.get("ErrorMessage") == null) {
                    isSuccess = true;
                    statusMessage = (String)statusProp.get("statusMessage");
                } else {
                    isSuccess = false;
                    statusMessage = (String)statusProp.get("ErrorMessage");
                }
                UIStatusMessage = (String)statusProp.get("UIStatusMessage");
                Properties statusprop = new Properties();
                statusprop.setProperty("Name", name);
                statusprop.put("isSuccess", isSuccess);
                statusprop.setProperty("statusMessage", statusMessage);
                statusprop.setProperty("UIStatusMessage", UIStatusMessage);
                statusList.add(statusprop);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) continue;
                message = rb.getString(message);
                Properties statusprop = new Properties();
                statusprop.setProperty("Name", name);
                statusprop.put("isSuccess", isSuccess);
                statusprop.setProperty("statusMessage", message);
                statusprop.setProperty("UIStatusMessage", message);
                statusList.add(statusprop);
            }
        }
    }

    public ActionForward exportReportForHDT(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            DynaValidatorForm bean = null;
            String exportType = "HelpDeskTechnician";
            String className = "com.adventnet.sym.adsm.common.webclient.delegation.HDTReportListener";
            String reportFileName = "HDTReports.xml";
            String reportName = "";
            String description = "";
            String reportIdString = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdString);
            String actionText = "";
            if (reportId == 10002) {
                bean = (DynaValidatorForm)session.getAttribute("HelpDeskTechnicianBean");
                exportType = "HelpDeskTechnician";
                reportName = "HelpDeskTechnicians";
                description = "admp.deleg.hdt_deleg.hdt_export.description";
                actionText = "admp.deleg.hdt_deleg.hdt_export.title";
            } else if (reportId == 10003) {
                bean = (DynaValidatorForm)session.getAttribute("ADMPRoleBean");
                exportType = "HelpDeskRoles";
                reportName = "HelpDeskRoles";
                description = "admp.deleg.hdt_deleg.hdt_roles_export.description";
                actionText = "admp.deleg.hdt_deleg.hdt_roles_export.title";
            }
            Class<?> classToInvoke = Class.forName(className.trim());
            reportName = rb.getString(reportName);
            String format = request.getParameter("format");
            String selectedIdList = request.getParameter("selectedIdList");
            String searchText = request.getParameter("searchText");
            String ascending = request.getParameter("ascending");
            String sortColumn = request.getParameter("sortColumn");
            HDTReportListener listener = (HDTReportListener)classToInvoke.newInstance();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("desc", rb.getString(description));
            listener.exportReport(reportFileName, reportName, reportId, format, loginId, selectedIdList, searchText, ascending, sortColumn, rb, response, request, inputs, bean, locale, exportType);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.heading.help_desk_delegation", (String)actionText, (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)(reportName + "." + format), (String)format.toLowerCase(), (String)"-", (Integer)listener.getExportRowCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward checkForOwnGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Hashtable groupUserMapping = ADMPGroupDelegationUtil.getGroupUserMapping();
        String groupIdString = request.getParameter("selectedGroupList");
        String[] groupIdArray = groupIdString.split(",");
        String isOwnGroup = "";
        for (String groupId : groupIdArray) {
            if (groupId == null || groupId == "") continue;
            Long id = Long.parseLong(groupId);
            ArrayList loginIdList = (ArrayList)groupUserMapping.get(id);
            if (!loginIdList.contains(sessionLoginId)) break;
            isOwnGroup = "true";
            break;
        }
        try {
            PrintWriter writer = response.getWriter();
            writer.print(isOwnGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

