/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.delegation.HDTReportListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class HDTReportAction
extends DispatchAction {
    AdventNetResourceBundle rb;

    public ActionForward report(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "reportsPage";
        this.rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.HDT_REPORT_ACTION_ID).booleanValue()) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            HttpSession session = request.getSession();
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long actionId = ClientUtil.getActionId(reportId);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList domainList = (ArrayList)authObject.getDomainList().clone();
            for (Properties domainProps : domainList) {
                domainProps.put("IAM_APP_ID", (Object)1);
                domainProps.put("ACCOUNT_TYPE", this.rb.getString("admp.mgmt.fc_layout.common.active_directory"));
            }
            Hashtable iamAppAccountDetails = authObject.getAuthorizedIamAppAccountDetails();
            Enumeration iamAppAccounts = iamAppAccountDetails.keys();
            while (iamAppAccounts.hasMoreElements()) {
                String iamAppAccount = (String)iamAppAccounts.nextElement();
                Hashtable details = (Hashtable)iamAppAccountDetails.get(iamAppAccount);
                if (!((Boolean)details.get("isWaadAccountSelected")).booleanValue()) continue;
                Properties domainProps = new Properties();
                domainProps.put("DOMAIN_NAME", iamAppAccount);
                domainProps.put("DOMAIN_DNS_NAME", iamAppAccount);
                int iamAppId = (Integer)details.get("iamAppId");
                domainProps.put("IAM_APP_ID", (Object)iamAppId);
                if (iamAppId == 3) {
                    domainProps.put("ACCOUNT_TYPE", this.rb.getString("admp.mgmt.fc_layout.common.text_o365"));
                } else if (iamAppId == 2) {
                    domainProps.put("ACCOUNT_TYPE", this.rb.getString("admp.mgmt.fc_layout.common.gsuite"));
                }
                domainList.add(domainProps);
            }
            JSONArray domainArr = FcJSONUtility.getJSONArrayOfJSONObject((ArrayList)domainList);
            domainArr = this.getDomainNamesJSONArray(domainArr);
            request.setAttribute("domainList", (Object)domainArr.toString());
            JSONArray delegDomainArr = FcJSONUtility.getJSONArrayOfJSONObject((ArrayList)domainList);
            delegDomainArr = this.getDomainNamesJSONArray(delegDomainArr);
            request.setAttribute("delegatedDomainList", (Object)delegDomainArr.toString());
            JSONObject supportedMatchCriteriaArray = TechnicianHandler.getSupportedMatchCriteria();
            request.setAttribute("supportedMatchCriteriaArray", (Object)supportedMatchCriteriaArray.toString());
            JSONObject matchCriteriaIdVsName = TechnicianHandler.getMatchCriteriaName((AdventNetResourceBundle)this.rb);
            request.setAttribute("matchCriteriaIdVsName", (Object)matchCriteriaIdVsName.toString());
            JSONArray fieldsArray = TechnicianHandler.getReportConditionFields((AdventNetResourceBundle)this.rb);
            request.setAttribute("fieldsArray", (Object)fieldsArray.toString());
            request.setAttribute("time", (Object)System.currentTimeMillis());
            String action = request.getParameter("action");
            request.setAttribute("HDTReport", (Object)"true");
            if (action != null && action.equalsIgnoreCase("fullScreenList")) {
                tile = "fullScreenListPage";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    private JSONArray getDomainNamesJSONArray(JSONArray domainListJSONArr) {
        JSONArray newDomainListJSONArr = new JSONArray();
        try {
            for (int i = 0; i < domainListJSONArr.length(); ++i) {
                JSONObject newDomainList = new JSONObject();
                JSONObject domList = (JSONObject)domainListJSONArr.get(i);
                newDomainList.put("DOMAIN_NAME", domList.has("DOMAIN_NAME") ? domList.get("DOMAIN_NAME") : "");
                newDomainList.put("DOMAIN_FLAT_NAME", domList.has("DOMAIN_FLAT_NAME") ? domList.get("DOMAIN_FLAT_NAME") : "");
                newDomainList.put("DOMAIN_DNS_NAME", domList.has("DOMAIN_DNS_NAME") ? domList.get("DOMAIN_DNS_NAME") : "");
                newDomainList.put("IAM_APP_ID", domList.has("IAM_APP_ID") ? domList.get("IAM_APP_ID") : Integer.valueOf(1));
                newDomainList.put("ACCOUNT_TYPE", domList.has("ACCOUNT_TYPE") ? domList.get("ACCOUNT_TYPE") : "");
                newDomainListJSONArr.put((Object)newDomainList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newDomainListJSONArr;
    }

    public ActionForward generateReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "reportResultPage";
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.HDT_REPORT_ACTION_ID).booleanValue()) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            request.setAttribute("time", (Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward generateReportResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "reportResultRowsPage";
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.HDT_REPORT_ACTION_ID).booleanValue()) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            HDTReportListener listener = (HDTReportListener)classToInvoke.newInstance();
            ArrayList attributeList = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            listener.setReportRows(request, attributeList, true, false);
            request.setAttribute("attributeList", (Object)attributeList);
            request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"HDTReport", (Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward saveTable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String substring = request.getParameter("substring");
            StringTokenizer substringTokenizer = new StringTokenizer(substring, ",");
            ArrayList<Properties> subList = new ArrayList<Properties>();
            int i = 0;
            while (substringTokenizer.hasMoreTokens()) {
                Properties properties = new Properties();
                Integer attributeId = new Integer(substringTokenizer.nextToken());
                properties.put("ATTRIB_ID", attributeId);
                properties.put("PRIORITY_ID", new Integer(++i));
                subList.add(properties);
            }
            ReportAttributeHandler.getInstance().saveColumns(reportId, subList, loginId);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.HDT_REPORT_ACTION_ID).booleanValue()) {
                throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            String format = request.getParameter("format");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            DataObject dataObj = ReportHandler.getReportDetails((Integer)reportId);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("ADSMReports");
                String className = (String)r.get("CLASS_NAME");
                String reportFileName = (String)r.get("REPORT_FILE_NAME");
                String reportName = (String)r.get("REPORT_NAME");
                reportName = rb.getString(reportName);
                String description = (String)r.get("DESCRIPTION");
                Class<?> classToInvoke = Class.forName(className.trim());
                HDTReportListener listener = (HDTReportListener)classToInvoke.newInstance();
                HashMap<String, String> inputs = new HashMap<String, String>();
                inputs.put("desc", rb.getString(description));
                listener.exportReportForHDTReport(reportFileName, reportName, reportId, format, loginId, rb, response, request, inputs);
                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.audit_reports", (String)reportName, (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)("HelpDeskTechniciansReports." + format), (String)format.toLowerCase(), (String)"-", (Integer)listener.getExportRowCount());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

