/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.export;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.SelectionTableModel;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.webclient.export.JRCustomTableDataSource;
import com.adventnet.sym.adsm.common.webclient.export.JRDataSourceReport;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class JasperDesignUtil {
    public static JasperPrint createJRPrintForView(SelectionTableModel dataModel, String heading, AdventNetResourceBundle rb, String exportType, String viewName, Long loginId, Locale locale) {
        return JasperDesignUtil.createJRPrintForView(dataModel, heading, rb, exportType, viewName, loginId, locale, false);
    }

    public static JasperPrint createJRPrintForView(SelectionTableModel dataModel, String heading, AdventNetResourceBundle rb, String exportType, String viewName, Long loginId, Locale locale, boolean isPage) {
        JasperPrint print = null;
        try {
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            HashMap<String, Boolean> inputParams = new HashMap<String, Boolean>();
            JasperDesign jasperDesign = JasperDesignUtil.createJasperDesign(viewName);
            JRDesignBand titleBand = new JRDesignBand();
            titleBand.setHeight(0);
            jasperDesign.setTitle((JRBand)titleBand);
            if (exportType.toLowerCase().indexOf("pdf") != -1 || exportType.toLowerCase().indexOf("html") != -1 || exportType.toLowerCase().indexOf("xls") != -1) {
                JasperDesignUtil.addPageHeader(jasperDesign, heading, exportType, locale);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1) {
                JasperDesignUtil.addPageFooter(jasperDesign, rb, isPage);
            }
            if (exportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, exportType);
            }
            JRDesignBand columnheaderband = new JRDesignBand();
            columnheaderband.setHeight(30);
            jasperDesign.setColumnHeader((JRBand)columnheaderband);
            JRDesignBand detailband = new JRDesignBand();
            detailband.setHeight(50);
            jasperDesign.setDetail((JRBand)detailband);
            Hashtable columnWidths = JasperDesignUtil.calculateWidth(dataModel, exportType, rb, showSerialNo);
            Integer widthValue = (Integer)columnWidths.remove("maxColumnWidth");
            if (widthValue != null) {
                int pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1 || exportType.toLowerCase().indexOf("html") != -1) {
                JasperDesignUtil.addPageHeader(jasperDesign, heading, exportType, locale);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1) {
                JasperDesignUtil.addPageFooter(jasperDesign, rb, isPage);
            }
            JasperDesignUtil.fillBand(jasperDesign, columnheaderband, detailband, dataModel, rb, exportType, showSerialNo, columnWidths, loginId, locale);
            JRDesignBand band = new JRDesignBand();
            band.setHeight(30);
            jasperDesign.setColumnFooter((JRBand)band);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JRCustomTableDataSource dataSource = new JRCustomTableDataSource(dataModel, showSerialNo);
            if (exportType.equals("pdf") || exportType.equals("html")) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            } else {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
        }
        catch (JRException jrEx) {
            jrEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return print;
    }

    public static JasperReport getJasperReportObject(SelectionTableModel dataModel, String heading, AdventNetResourceBundle rb, String exportType, String viewName, Long loginId, Locale locale, boolean isPage, int fromIndex, boolean isSingleSheet) {
        JasperReport jasperReport = null;
        try {
            Hashtable columnWidths;
            Integer widthValue;
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            HashMap inputParams = new HashMap();
            JasperDesign jasperDesign = JasperDesignUtil.createJasperDesign(viewName);
            boolean isFirstReport = fromIndex == 1;
            JRDesignBand columnheaderband = new JRDesignBand();
            columnheaderband.setHeight(30);
            jasperDesign.setColumnHeader((JRBand)columnheaderband);
            JRDesignBand detailband = new JRDesignBand();
            detailband.setHeight(50);
            jasperDesign.setDetail((JRBand)detailband);
            JRDesignBand titleBand = new JRDesignBand();
            titleBand.setHeight(0);
            jasperDesign.setTitle((JRBand)titleBand);
            if (!(exportType.toLowerCase().indexOf("pdf") == -1 && exportType.toLowerCase().indexOf("html") == -1 && exportType.toLowerCase().indexOf("xls") == -1 || isSingleSheet && !isFirstReport)) {
                JasperDesignUtil.addPageHeader(jasperDesign, heading, exportType, locale);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1) {
                JasperDesignUtil.addPageFooter(jasperDesign, rb, isPage, true);
            }
            if (fromIndex == 1 && exportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, exportType);
            }
            if ((widthValue = (Integer)(columnWidths = JasperDesignUtil.calculateWidth(dataModel, exportType, rb, showSerialNo)).remove("maxColumnWidth")) != null) {
                int pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1 || exportType.toLowerCase().indexOf("html") != -1) {
                JasperDesignUtil.addPageHeader(jasperDesign, heading, exportType, locale);
            }
            if (exportType.toLowerCase().indexOf("pdf") != -1) {
                JasperDesignUtil.addPageFooter(jasperDesign, rb, isPage, true);
            }
            JasperDesignUtil.fillBand(jasperDesign, columnheaderband, detailband, dataModel, rb, exportType, showSerialNo, columnWidths, loginId, locale, isFirstReport);
            JRDesignBand band = new JRDesignBand();
            band.setHeight(30);
            jasperDesign.setColumnFooter((JRBand)band);
            JRDesignParameter pageParam = new JRDesignParameter();
            pageParam.setName("AddToPgNumber");
            pageParam.setForPrompting(false);
            pageParam.setValueClass(Integer.class);
            jasperDesign.addParameter((JRParameter)pageParam);
            jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
        }
        catch (JRException jrEx) {
            jrEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jasperReport;
    }

    public static JasperPrint getTocPrintObject(String tocDesignFile, ArrayList exportViewsList, ArrayList outputFilterVsViewsResultCount, HashMap jrParameterMap, AdventNetResourceBundle rb, Long loginId, String exportType, Locale locale, boolean isIntersect) {
        JasperPrint print = null;
        try {
            String jrxmlDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adsm" + File.separator + "jasperreports" + File.separator + "jrxml";
            String reportFileName = jrxmlDir + File.separator + "ExportReport.xml";
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setWhenNoDataType((byte)3);
            if (exportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, exportType);
            }
            JRDesignBand titlebBand = (JRDesignBand)jasperDesign.getTitle();
            JRDesignStaticText staticText = null;
            staticText = isIntersect ? JasperDesignUtil.getStaticText(4, 245, 150, 18, rb.getString("admp.reports.common.export.specified_groups")) : JasperDesignUtil.getStaticText(4, 245, 150, 18, rb.getString("admp.reports.common.export.report_summary"));
            JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
            JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_Column", reportPDFFont, 12, false, false);
            staticText.setFont((JRFont)columnFont);
            titlebBand.addElement((JRDesignElement)staticText);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand("pdf", jasperDesign, locale);
            JRDesignBand columnheaderband = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailband = (JRDesignBand)jasperDesign.getDetail();
            if (isIntersect) {
                JasperDesignUtil.fillBandForTOCIntersect(jasperDesign, columnheaderband, detailband, rb, loginId, exportType, locale);
            } else {
                JasperDesignUtil.fillBandForTOC(jasperDesign, columnheaderband, detailband, exportViewsList, rb, loginId, exportType, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JRDataSourceReport dataSource = new JRDataSourceReport(outputFilterVsViewsResultCount, isIntersect);
            HashMap inputParams = new HashMap();
            Long date = new Long(System.currentTimeMillis());
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(date));
            Set keys = jrParameterMap.keySet();
            for (String key : keys) {
                inputParams.put(key, jrParameterMap.get(key));
            }
            print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
        }
        catch (JRException jrEx) {
            jrEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return print;
    }

    public static void fillBand(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, SelectionTableModel datamModel, AdventNetResourceBundle rb, String exportType, boolean showSerialNo, Hashtable<String, Integer> columnWidths, Long loginId, Locale locale) {
        JasperDesignUtil.fillBand(jasperDesign, columnHeaderBand, detailBand, datamModel, rb, exportType, showSerialNo, columnWidths, loginId, locale, true);
    }

    public static void fillBand(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, SelectionTableModel datamModel, AdventNetResourceBundle rb, String exportType, boolean showSerialNo, Hashtable<String, Integer> columnWidths, Long loginId, Locale locale, boolean isFirstReport) {
        int columnWidth = jasperDesign.getColumnWidth();
        int x = 0;
        try {
            columnHeaderBand.setHeight(30);
            detailBand.setHeight(30);
            int width = columnWidth / datamModel.getHeaderColumnCount();
            if (showSerialNo) {
                width = 25;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, 0, width, 30, displayName, rb, loginId, exportType, locale);
                x += width + 0;
            }
            for (int i = 0; i < datamModel.getHeaderColumnCount(); ++i) {
                String displayName = rb.getString(datamModel.getColumnName(i).toString());
                HashMap columnMap = datamModel.getColumnMap(i);
                width = columnWidths.get(displayName);
                JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, 0, width, 30, displayName, rb, loginId, columnMap, exportType, locale);
                x += width + 0;
            }
            if (exportType.toLowerCase().indexOf("xls") != -1 || exportType.toLowerCase().indexOf("csv") != -1) {
                JRDesignExpression express = new JRDesignExpression();
                express.setValueClass(Boolean.class);
                if (isFirstReport) {
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                } else {
                    express.setText("Boolean.FALSE");
                }
                columnHeaderBand.setPrintWhenExpression((JRExpression)express);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addFieldToJasper(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, int x, int y, int width, int height, String displayName, AdventNetResourceBundle rb, Long loginId, String reportType, Locale locale) throws Exception {
        JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, y, width, height, displayName, rb, loginId, null, reportType, locale);
    }

    private static void addFieldToJasper(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, int x, int y, int width, int height, String displayName, AdventNetResourceBundle rb, Long loginId, HashMap columnProps, String reportType, Locale locale) throws Exception {
        int columnFontSize = 10;
        int normalFontSize = 9;
        JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
        JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, columnFontSize, true, false);
        JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalFontSize, false, false);
        JRDesignTextField txt = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, height, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)2, (byte)2);
        txt.setMode((byte)1);
        txt.setKey(displayName);
        txt.setPrintRepeatedValues(true);
        txt.setRemoveLineWhenBlank(false);
        txt.setPrintInFirstWholeBand(false);
        txt.setPrintWhenDetailOverflows(true);
        JRBaseBox box = new JRBaseBox();
        box.setTopBorder((byte)5);
        box.setTopBorderColor(new Color(155, 166, 109));
        box.setBottomBorder((byte)5);
        box.setBottomBorderColor(new Color(155, 166, 109));
        box.setLeftBorder((byte)5);
        box.setLeftBorderColor(new Color(155, 166, 109));
        box.setRightBorder((byte)5);
        box.setRightBorderColor(new Color(155, 166, 109));
        box.setLeftPadding(1);
        txt.setBox((JRBox)box);
        txt.setBackcolor(new Color(239, 239, 231));
        txt.setForecolor(Color.BLACK);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        displayName = displayName.replaceAll("\\\\", "\\\\\\\\");
        displayName = displayName.replaceAll("\\\"", "\\\\\"");
        exp.setText("\"" + displayName + "\"");
        txt.setExpression((JRExpression)exp);
        columnHeaderBand.addElement((JRDesignElement)txt);
        JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
        if (columnProps != null) {
            Integer attribId = (Integer)columnProps.get("ATTRIB_ID");
            if (attribId == null) {
                attribId = (Integer)columnProps.get("COLUMN_ID");
            }
            JRDesignField field = new JRDesignField();
            field.setName(attribId.toString());
            field.setValueClass(String.class);
            jasperDesign.addField((JRField)field);
            txtField.setBox((JRBox)box);
            detailBand.setSplitAllowed(false);
            txtField.setPrintWhenDetailOverflows(true);
            txtField.setPrintRepeatedValues(true);
            txtField.setPrintInFirstWholeBand(true);
            JRFieldDesignUtil.setDesignExpression(detailBand, attribId, rb, box, txtField, width, x, loginId, reportPDFFont);
            detailBand.addElement((JRDesignElement)txtField);
        } else {
            JRDesignField field = new JRDesignField();
            field.setName(displayName.toString());
            field.setValueClass(String.class);
            jasperDesign.addField((JRField)field);
            exp = new JRDesignExpression();
            exp.setValueClass(String.class);
            exp.setText("$F{" + displayName + "}");
            txtField.setBox((JRBox)box);
            txtField.setExpression((JRExpression)exp);
            detailBand.setSplitAllowed(false);
            txtField.setPrintWhenDetailOverflows(true);
            txtField.setPrintRepeatedValues(true);
            txtField.setPrintInFirstWholeBand(true);
            detailBand.addElement((JRDesignElement)txtField);
        }
    }

    public static void fillBandForTOC(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList exportViewsList, AdventNetResourceBundle rb, Long loginId, String reportType, Locale locale) {
        JasperDesignUtil.fillBandForTOC(jasperDesign, columnHeaderBand, detailBand, exportViewsList, rb, loginId, null, reportType, locale);
    }

    public static void fillBandForTOC(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList exportViewsList, AdventNetResourceBundle rb, Long loginId, String summaryTitle, String reportType, Locale locale) {
        int columnWidth = jasperDesign.getColumnWidth();
        int x = 0;
        ArrayList tempViewsList = (ArrayList)exportViewsList.clone();
        if (summaryTitle != null) {
            Hashtable<String, String> dummyViewConfig = new Hashtable<String, String>();
            dummyViewConfig.put("filterName", summaryTitle);
            tempViewsList.add(0, dummyViewConfig);
        }
        try {
            columnHeaderBand.setHeight(20);
            detailBand.setHeight(30);
            int width = columnWidth / tempViewsList.size();
            for (int viewIndex = 0; viewIndex < tempViewsList.size(); ++viewIndex) {
                Hashtable viewConfig = (Hashtable)tempViewsList.get(viewIndex);
                String viewName = (String)viewConfig.get("filterName");
                JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, 0, width, 20, viewName, rb, loginId, reportType, locale);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBandForTOCIntersect(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, AdventNetResourceBundle rb, Long loginId, String reportType, Locale locale) {
        int columnWidth = jasperDesign.getColumnWidth();
        int x = 0;
        try {
            columnHeaderBand.setHeight(20);
            detailBand.setHeight(30);
            int width = 30;
            String displayName = rb.getString("admp.reports.common.export.Serial_no");
            JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, 0, width, 20, displayName, rb, loginId, reportType, locale);
            x += width + 0;
            width = 150;
            displayName = rb.getString("admp.common.attrib_disp_name.group_name");
            JasperDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, x, 0, width, 20, displayName, rb, loginId, reportType, locale);
            x += width + 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JRDesignReportFont getJRDesignReportFont(String name, String fontName, int size, boolean bold, boolean isDefault) {
        JRDesignReportFont font = new JRDesignReportFont();
        font.setName(name);
        font.setDefault(isDefault);
        font.setFontName(fontName);
        font.setFontSize(size);
        font.setBold(bold);
        font.setPdfFontName("Helvetica");
        font.setPdfEncoding("Cp1252");
        font.setPdfEmbedded(false);
        return font;
    }

    private static JasperDesign createJasperDesign(String name) {
        JasperDesign jasperDesign = new JasperDesign();
        jasperDesign.setName(name);
        jasperDesign.setPageWidth(615);
        jasperDesign.setPageHeight(842);
        jasperDesign.setColumnWidth(535);
        jasperDesign.setColumnSpacing(0);
        jasperDesign.setLeftMargin(30);
        jasperDesign.setRightMargin(30);
        jasperDesign.setTopMargin(20);
        jasperDesign.setBottomMargin(20);
        jasperDesign.addImport("com.adventnet.sym.adsm.security.server.util.DateTimeUtil");
        return jasperDesign;
    }

    public static JRDesignStaticText getStaticText(int x, int y, int width, int height, String text) throws Exception {
        JRDesignStaticText staticText = new JRDesignStaticText();
        staticText.setX(x);
        staticText.setY(y);
        staticText.setWidth(width);
        staticText.setHeight(height);
        staticText.setHorizontalAlignment((byte)1);
        staticText.setText(text);
        return staticText;
    }

    private static JRDesignTextField getTextField(int x, int y, int width, int height) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setStretchWithOverflow(false);
        textField.setBlankWhenNull(true);
        textField.setX(x);
        textField.setY(y);
        textField.setWidth(width);
        textField.setHeight(height);
        textField.setHorizontalAlignment((byte)1);
        textField.setHyperlinkType((byte)1);
        textField.setHyperlinkTarget((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        return textField;
    }

    private static void addPageHeader(JasperDesign jasperDesign, String objectName, String exportType, Locale locale) throws Exception {
        JRDesignBand titleBand = new JRDesignBand();
        titleBand.setHeight(40);
        JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(exportType, locale);
        JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 12, false, false);
        JRDesignStaticText staticText = JasperDesignUtil.getStaticText(5, 6, 500, 16, objectName);
        staticText.setFont((JRFont)columnFont);
        staticText.setPrintWhenDetailOverflows(true);
        titleBand.addElement((JRDesignElement)staticText);
        JRDesignLine line = new JRDesignLine();
        line.setX(1);
        line.setY(30);
        line.setWidth(jasperDesign.getPageWidth() - 62);
        line.setHeight(1);
        line.setStretchType((byte)0);
        titleBand.addElement((JRDesignElement)line);
        jasperDesign.setPageHeader((JRBand)titleBand);
    }

    private static void addPageFooter(JasperDesign jasperDesign, AdventNetResourceBundle rb, boolean isPage) throws Exception {
        JasperDesignUtil.addPageFooter(jasperDesign, rb, isPage, false);
    }

    private static void addPageFooter(JasperDesign jasperDesign, AdventNetResourceBundle rb, boolean isPage, boolean addToPageNo) throws Exception {
        JRDesignBand titleBand = new JRDesignBand();
        titleBand.setHeight(30);
        JRDesignLine line = new JRDesignLine();
        line.setX(1);
        line.setY(5);
        line.setWidth(jasperDesign.getPageWidth() - 62);
        line.setHeight(1);
        line.setStretchType((byte)0);
        titleBand.addElement((JRDesignElement)line);
        if (isPage) {
            JRDesignStaticText staticText = JasperDesignUtil.getStaticText(260, 10, 50, 15, rb.getString("admp.reports_export.pagefooter.page"));
            titleBand.addElement((JRDesignElement)staticText);
            JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(290, 10, 30, 15, null, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClass(Integer.class);
            String text = "$V{PAGE_NUMBER}";
            if (addToPageNo) {
                text = "$V{PAGE_NUMBER} + ($P{AddToPgNumber}==null?0:$P{AddToPgNumber})";
            }
            exp.setText(text);
            txtField.setExpression((JRExpression)exp);
            txtField.setPrintWhenDetailOverflows(true);
            txtField.setPrintRepeatedValues(true);
            txtField.setPrintInFirstWholeBand(true);
            titleBand.addElement((JRDesignElement)txtField);
        }
        jasperDesign.setPageFooter((JRBand)titleBand);
    }

    public static Hashtable calculateWidth(SelectionTableModel dataModel, String reportType, AdventNetResourceBundle rb, boolean showSerialNo) {
        int columnWidth = 535;
        Hashtable exportParams = JRFieldDesignUtil.exportSettings();
        boolean hasFlexibleWidth = true;
        String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
        if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
            hasFlexibleWidth = false;
        }
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        if (showSerialNo) {
            columnWidth = 510;
        }
        int width = columnWidth / dataModel.getHeaderColumnCount();
        for (int j = 0; j < dataModel.getRowCount(); ++j) {
            for (int k = 0; k < dataModel.getColumnCount(); ++k) {
                Integer len;
                HashMap columnMap = dataModel.getColumnMap(k);
                Integer attributeId = (Integer)RVUtil.getColumnValue((HashMap)columnMap, (Object)"ATTRIB_ID");
                String displayName = (String)columnMap.get("ATTRIB_DISP_NAME");
                if (attributeId == null) {
                    attributeId = (Integer)RVUtil.getColumnValue((HashMap)columnMap, (Object)"COLUMN_ID");
                    displayName = (String)columnMap.get("DISPLAY_NAME");
                }
                displayName = rb.getString(displayName);
                Object obj = dataModel.getValueAt(j, attributeId.intValue());
                if (obj == null) {
                    obj = "";
                }
                String str = obj.toString();
                if (reportType.toLowerCase().equals("csvde") && str.equals("-")) {
                    str = "";
                }
                int strLength = str.length();
                if (displayName.length() > strLength) {
                    strLength = displayName.length();
                }
                int length = strLength * 5;
                if (reportType.toLowerCase().equals("xlsx") && (attributeId == 1040 || attributeId == 1039 || attributeId == 1029 || attributeId == 1035 || attributeId == 1030 || attributeId == 1044 || attributeId == 2008 || attributeId == 2009 || attributeId == 3011 || attributeId == 3012 || attributeId == 3019 || attributeId == 5039 || attributeId == 5040 || attributeId == 6023 || attributeId == 6024 || attributeId == 8005 || attributeId == 8006 || attributeId == 1022 || attributeId == 9054 || attributeId == 9056 || attributeId == 9057 || attributeId == 10013 || attributeId == 10014 || attributeId == 11013 || attributeId == 11014 || attributeId == 1192 || attributeId == 3033 || attributeId == 7036 || attributeId == 7037 || attributeId == 1033 || attributeId == 3025 || attributeId == 1031 || attributeId == 17039 || attributeId == 17040)) {
                    length = 120;
                }
                if ((len = (Integer)columnWidths.get(displayName)) != null) {
                    if (length <= len) continue;
                    columnWidths.put(displayName, new Integer(length));
                    continue;
                }
                columnWidths.put(displayName, new Integer(length));
            }
        }
        int calculatedMaxWidth = 0;
        if (hasFlexibleWidth) {
            Enumeration keys = columnWidths.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int columnSize = (Integer)columnWidths.get(key);
                columnSize += columnSize / 20 + 1;
                columnWidths.put(key, new Integer(columnSize));
                calculatedMaxWidth += columnSize;
            }
        }
        ArrayList<String> lengthyList = new ArrayList<String>();
        int remTotalWidth = 0;
        int maxPDFColWidth = 14200 - dataModel.getHeaderColumnCount() * 2;
        if (!reportType.toLowerCase().equals("csvde") && hasFlexibleWidth) {
            if (!columnWidths.isEmpty() && calculatedMaxWidth < columnWidth) {
                int remainingWidth = columnWidth - calculatedMaxWidth;
                int widthToAddForEachColumn = remainingWidth / columnWidths.size();
                Enumeration keys = columnWidths.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    int columnSize = (Integer)columnWidths.get(key);
                    columnWidths.put(key, new Integer(columnSize += widthToAddForEachColumn));
                }
                calculatedMaxWidth = columnWidth;
            } else if (calculatedMaxWidth > maxPDFColWidth) {
                calculatedMaxWidth = maxPDFColWidth;
            }
        } else {
            calculatedMaxWidth = columnWidth;
        }
        width = calculatedMaxWidth / dataModel.getHeaderColumnCount();
        if (!reportType.toLowerCase().equals("csvde")) {
            for (int i = 0; i < dataModel.getHeaderColumnCount(); ++i) {
                String displayName = rb.getString(dataModel.getColumnName(i).toString());
                if (columnWidths.isEmpty() || columnWidths.get(displayName) == null) continue;
                int w = (Integer)columnWidths.get(displayName);
                if (w > width) {
                    lengthyList.add(displayName);
                    continue;
                }
                remTotalWidth += width - w;
            }
            int extraWidth = 0;
            if (lengthyList.size() > 0) {
                extraWidth = remTotalWidth / lengthyList.size();
            }
            for (int i = 0; i < lengthyList.size(); ++i) {
                String columnName = (String)lengthyList.get(i);
                int w = (Integer)columnWidths.get(columnName);
                columnWidths.put(columnName, new Integer(width + extraWidth));
            }
            if (!columnWidths.isEmpty() && hasFlexibleWidth) {
                columnWidths.put("maxColumnWidth", new Integer(calculatedMaxWidth));
            }
        }
        return columnWidths;
    }
}

