/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.fileserver;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtTask;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerTaskManager;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerTaskMgmtUtil;
import com.adventnet.sym.adsm.common.server.fileserver.ManageFileServerList;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.MgmtTask;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileServerMgmtAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(FileServerMgmtAction.class.getName());

    public ActionForward loadCVC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "permissionMgmt";
        try {
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            Long actionId = ClientUtil.getActionId(reportId);
            if (!ClientAuthorizationUtil.isAuthorized(request, actionId).booleanValue()) {
                tile = "accessDenied";
            }
            Long cvcId = CVCUtil.getCVCId((Integer)reportId);
            Long cvcDataId = CVCUtil.getDefaultDataModelId((String)"FileServerMgmt");
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("cvcId", (Object)cvcId);
            request.setAttribute("cvcDataId", (Object)cvcDataId);
        }
        catch (Exception e) {
            e.printStackTrace();
            tile = "accessDenied";
        }
        return mapping.findForward(tile);
    }

    public ActionForward manageServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.MANAGE_FILE_SERVER_ACTION_ID).booleanValue()) {
            return null;
        }
        String tile = "fileServerList";
        return mapping.findForward(tile);
    }

    public ActionForward viewBackgroundTasks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "fileServerBackground";
        return mapping.findForward(tile);
    }

    public ActionForward loadRVC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "permissionMgmt";
        try {
            String genIDstr = request.getParameter("generationId");
            Long generationId = new Long(genIDstr);
            HashMap mgmtDetails = FileServerMgmtUtil.getMgmtDetails((Long)generationId);
            Integer reportId = (Integer)mgmtDetails.get("REPORT_ID");
            if (reportId != null) {
                Long cvcId = CVCUtil.getCVCId((Integer)reportId);
                Long cvcDataId = (Long)mgmtDetails.get("CVC_DATA_ID");
                request.setAttribute("reportId", (Object)reportId);
                request.setAttribute("cvcId", (Object)cvcId);
                request.setAttribute("cvcDataId", (Object)cvcDataId);
                if (!ClientAuthorizationUtil.isSuperAdmin(request)) {
                    tile = "accessDenied";
                }
            } else {
                tile = "accessDenied";
            }
        }
        catch (Exception e) {
            tile = "errorPage";
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward updateMETrackCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward getRVCConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block4: {
            PrintWriter writer = null;
            try {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String genIDstr = request.getParameter("generationId");
                Long generationId = new Long(genIDstr);
                HashMap mgmtDetails = FileServerMgmtUtil.getMgmtDetails((Long)generationId);
                Integer reportId = (Integer)mgmtDetails.get("REPORT_ID");
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                Long cvcDataId = (Long)mgmtDetails.get("CVC_DATA_ID");
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId);
                Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)cvcDataId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
                rvcJsonObject.put("generationId", (Object)generationId);
                if (FileServerTaskManager.getInstance().getTaskStatus(generationId) != null) {
                    rvcJsonObject.put("isReportRunning", true);
                } else {
                    HashMap genDetails = FileServerTaskMgmtUtil.getGenerationStatus((AdventNetResourceBundle)rb, (Long)generationId);
                    rvcJsonObject.put("statusMessage", genDetails.get("statusMessage"));
                    rvcJsonObject.put("status", genDetails.get("status"));
                    rvcJsonObject.put("isReportRunning", false);
                }
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block4;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward saveCVCConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block2: {
            PrintWriter writer = null;
            try {
                String reportIdStr = request.getParameter("reportId");
                Integer reportId = Integer.parseInt(reportIdStr);
                String action = request.getParameter("action");
                HttpSession session = request.getSession();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String hostId = request.getRemoteHost();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                JSONObject jsonObject = new JSONObject(request.getParameter("CVCData"));
                DataObject cvcDataDO = this.saveCVCData(jsonObject);
                Row cvcDataRow = cvcDataDO.getFirstRow("CVConfigurationData");
                Long cvcDataId = (Long)cvcDataRow.get("CVC_DATA_ID");
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId);
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                Long generationId = this.initiateMgmtTask(loginId, reportId, action, dynamicHandlerClassName, rvcDataObject, cvcDataDO, cvcDataId, hostId, rb, authObject);
                CVCUtil.saveDataModelId((String)session.getId(), (Long)loginId, (Integer)reportId, (Long)cvcDataId, (Long)generationId);
                Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)cvcDataId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
                rvcJsonObject.put("generationId", (Object)generationId);
                rvcJsonObject.put("isReportRunning", true);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block2;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward addFileServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            PrintWriter writer = null;
            try {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                ArrayList<String> objectGUIDList = new ArrayList<String>();
                JSONObject jsonObject = new JSONObject(request.getParameter("computers"));
                Iterator it = jsonObject.keys();
                while (it.hasNext()) {
                    String objectGuid = (String)it.next();
                    objectGUIDList.add(objectGuid);
                }
                jsonObject = ManageFileServerList.addFileServer(objectGUIDList);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(jsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block3;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward removeFileServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            PrintWriter writer = null;
            try {
                ArrayList<String> objectGUIDList = new ArrayList<String>();
                JSONObject jsonObject = new JSONObject(request.getParameter("computers"));
                Iterator it = jsonObject.keys();
                while (it.hasNext()) {
                    String objectGuid = (String)it.next();
                    objectGUIDList.add(objectGuid);
                }
                ManageFileServerList.removeFileServers(objectGUIDList);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(jsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block3;
                writer.close();
            }
        }
        return null;
    }

    private DataObject saveCVCData(JSONObject cvcData) throws Exception {
        Long cvcDataId = null;
        DataObject cvcDataDO = CVCDataUtil.saveCVCData((JSONObject)cvcData);
        Row cvcDataRow = cvcDataDO.getFirstRow("CVConfigurationData");
        cvcDataId = (Long)cvcDataRow.get("CVC_DATA_ID");
        return cvcDataDO;
    }

    private Long initiateMgmtTask(Long loginId, Integer reportId, String action, String dynamicHandlerClassName, DataObject rvcDataObject, DataObject cvcDataDO, Long cvcDataId, String hostId, AdventNetResourceBundle rb, ADMPAuthObject authObject) throws Exception {
        Long generationId = 0L;
        StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
        statusUpdater.init(rvcDataObject, cvcDataId);
        generationId = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)"", (Long)loginId);
        Long cvId = ColumnConfiguration.getCVId((String)"PermissionMgmt", (long)DelegationUtil.ADMIN_LOGIN_ID);
        ArrayList columnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
        FileServerMgmtTask task = new FileServerMgmtTask(statusUpdater, generationId, loginId, cvcDataDO, action, columnList, reportId, hostId, rb, authObject);
        Boolean ret = FileServerTaskManager.getInstance().addTask((MgmtTask)task, generationId);
        if (!ret.booleanValue()) {
            throw new Exception("ERROR");
        }
        return generationId;
    }

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            Long generationId = reqJSONObject.getInt("generationId");
            StatusUpdater dynamicUpdator = FileServerTaskManager.getInstance().getTaskStatus(generationId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (dynamicUpdator == null) {
                jsonObject = new JSONObject();
                jsonObject.put("isCompleted", true);
                HashMap genDetails = FileServerTaskMgmtUtil.getGenerationStatus((AdventNetResourceBundle)rb, (Long)generationId);
                jsonObject.put("statusMessage", genDetails.get("statusMessage"));
                jsonObject.put("status", genDetails.get("status"));
            } else {
                jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getFileServerMgmtTaskDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Integer currentTaskCount = FileServerTaskManager.getInstance().getCurrentTaskCount();
            String statusMessage = "";
            if (currentTaskCount > 0) {
                statusMessage = MessageFormat.format(rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.have_tasks_running_in_background"), currentTaskCount);
            }
            jsonObject = new JSONObject();
            jsonObject.put("statusMessage", (Object)statusMessage);
            jsonObject.put("currentTaskCount", (Object)currentTaskCount);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getFileServerMgmtBackgroundTaskDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            jsonObject = FileServerMgmtAction.getLatestBackgroundTaskListJSON(rb, loginId, reqJSONObject);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static JSONObject getLatestBackgroundTaskListJSON(AdventNetResourceBundle rb, Long loginId, JSONObject jsonObject) {
        JSONObject statusJson = new JSONObject();
        ArrayList headerColumnList = new ArrayList();
        try {
            Long cvId = ColumnConfiguration.getCVId((String)"BackgroundTasks", (long)DelegationUtil.ADMIN_LOGIN_ID);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            ArrayList backgroundTaskList = FileServerTaskMgmtUtil.getBackgroundTaskList((AdventNetResourceBundle)rb, (Long)loginId, (ArrayList)headerColumnList, (int)0, (int)25);
            statusJson.put("rows", (Object)FileServerMgmtAction.getTaskRowDetailsJSON(backgroundTaskList, headerColumnList));
            statusJson.put("count", (Object)FileServerTaskMgmtUtil.getTotalBackgroundtaskCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusJson;
    }

    private static JSONArray getTaskRowDetailsJSON(ArrayList backgroundTaskList, ArrayList columnList) {
        JSONArray rowDetails = new JSONArray();
        JSONArray row = null;
        try {
            for (int index = 0; backgroundTaskList != null && index < backgroundTaskList.size(); ++index) {
                row = new JSONArray();
                HashMap hash = (HashMap)backgroundTaskList.get(index);
                row.put(hash.get("REPORT_GENERATION_ID"));
                for (int j = 0; j < columnList.size(); ++j) {
                    HashMap colMap = (HashMap)columnList.get(j);
                    Integer columnId = (Integer)colMap.get("COLUMN_ID");
                    if (hash.containsKey(columnId)) {
                        String value = (String)hash.get(columnId);
                        row.put((Object)ClientUtil.htmlEscape(value));
                        continue;
                    }
                    row.put((Object)"-");
                }
                rowDetails.put((Object)row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    public ActionForward stopTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request.getParameter("generationId") != null) {
                Long generationId = Long.valueOf(request.getParameter("generationId"));
                FileServerTaskManager.getInstance().stopTask(generationId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getFolderPermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "viewFolderPermission";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String isCopyFolderPermissionStr = request.getParameter("isCopyFolderPermission");
            Boolean isCopyFolderPermission = isCopyFolderPermissionStr != null ? Boolean.valueOf(isCopyFolderPermissionStr) : false;
            String cvcIdStr = request.getParameter("cvcId");
            Long cvcId = Long.parseLong(cvcIdStr);
            DataObject dataObj = CVCUtil.getCVConfiguration((Long)cvcId);
            Row permissionConfig = dataObj.getFirstRow("CVCPermissionConfig");
            String permObjectType = (String)permissionConfig.get("PERM_OBJECT_TYPE");
            String folderPathJSONStr = request.getParameter("folderPath");
            JSONObject folderPathJSON = new JSONObject(folderPathJSONStr);
            ArrayList permissionProps = new ArrayList();
            String includeInherited = request.getParameter("includeInherited");
            boolean isIncludeInherited = includeInherited != null && includeInherited.equalsIgnoreCase("true");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Iterator it = folderPathJSON.keys();
            if (it.hasNext()) {
                String folderPath = (String)it.next();
                request.setAttribute("serverName", (Object)FileServerMgmtUtil.getServerForFolder((String)folderPath));
                permissionProps = FileServerMgmtUtil.getFolderPermissions((HttpServletRequest)request, (String)folderPath, (Long)loginId, (AdventNetResourceBundle)rb, (boolean)isIncludeInherited, (String)permObjectType, (Boolean)false, (Boolean)isCopyFolderPermission);
            }
            request.setAttribute("permissionProps", permissionProps);
            if (isCopyFolderPermission != null && isCopyFolderPermission.booleanValue()) {
                request.setAttribute("dataObj", (Object)dataObj);
                request.setAttribute("inputIndex", (Object)request.getParameter("inputIndex"));
                tile = "newPermissionField";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward getSelectedFolderView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedList = request.getParameter("selectedList");
        JSONArray jsonArray = new JSONArray(selectedList);
        request.setAttribute("SelectedFolders", (Object)FileServerMgmtUtil.getSelectedFoldersList((JSONArray)jsonArray));
        return mapping.findForward("selectedFoldersView");
    }

    public ActionForward getCVCDataIdForPreview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block2: {
            PrintWriter writer = null;
            try {
                JSONObject jsonObject = new JSONObject(request.getParameter("CVCData"));
                DataObject cvcDataDO = this.saveCVCData(jsonObject);
                Row cvcDataRow = cvcDataDO.getFirstRow("CVConfigurationData");
                Long cvcDataId = (Long)cvcDataRow.get("CVC_DATA_ID");
                JSONObject rvcJsonObject = new JSONObject();
                rvcJsonObject.put("cvcDataId", (Object)cvcDataId);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block2;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward getDetailedMgmtResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String folderInputIdStr = request.getParameter("inputId");
        Long folderInputId = Long.valueOf(folderInputIdStr);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList resultProps = new ArrayList();
        HashMap resultHash = FileServerMgmtUtil.getModificationResults((Long)folderInputId, (AdventNetResourceBundle)rb, (Boolean)false);
        Hashtable result = (Hashtable)resultHash.get(rb.getString("admp.mgmt.fileserver.perm_mgmt.permission"));
        for (Long errorCode : result.keySet()) {
            resultProps.addAll((Collection)result.get(errorCode));
        }
        request.setAttribute("result", resultProps);
        request.setAttribute("folderName", resultHash.get("folderName"));
        return mapping.findForward("result");
    }

    public ActionForward getGroupsWithSamePermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String uniqueIdStr = request.getParameter("uniqueId");
            Long uniqueId = Long.valueOf(uniqueIdStr);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Hashtable groupList = FileServerMgmtUtil.getGroupsWithSamePermission((Long)uniqueId, (ADMPAuthObject)authObject, (Long)loginId, (AdventNetResourceBundle)rb);
            request.setAttribute("groupList", (Object)groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("groupList");
    }

    public ActionForward isAllFileServersSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        JSONObject jsonObj = new JSONObject();
        String fileServerListJSONStr = request.getParameter("fileServerList");
        try {
            JSONObject fileServerList = new JSONObject(fileServerListJSONStr);
            ArrayList<String> fileServers = new ArrayList<String>();
            Iterator itC = fileServerList.keys();
            while (itC.hasNext()) {
                String objGUID = (String)itC.next();
                fileServers.add(objGUID);
            }
            if (fileServers.size() > 0) {
                Criteria c = new Criteria(Column.getColumn((String)"ADSMFileServers", (String)"OBJECT_GUID"), (Object)StrUtil.getStringArray(fileServers), 9);
                DataObject dO = ManageFileServerList.getFileServersDataObject();
                Iterator itS = dO.getRows("ADSMFileServers", c);
                if (itS.hasNext()) {
                    jsonObj.put("isAllSelected", false);
                } else {
                    jsonObj.put("isAllSelected", true);
                }
            } else {
                jsonObj.put("isAllSelected", false);
            }
            response.setContentType("application/json");
            writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateOpertaion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }
}

