/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.fileserver;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.statusupdater.AbstractStatusUpdater;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileServerMgmtStatusUpdator
extends AbstractStatusUpdater
implements StatusUpdater {
    private Long totalCount = 0L;
    private Integer dynamicSize = 25;
    private Boolean isCompleted = false;
    private Hashtable taskStatus = null;
    private int currentTaskCode;
    private String currentFolder = null;
    private ArrayList currentResultRows = new ArrayList();

    public FileServerMgmtStatusUpdator() {
        this.taskStatus = new Hashtable();
    }

    public void init(DataObject rvcDataObject, Long cvcDataId) {
    }

    public void init(DataObject rvcDataObject) {
    }

    public void updateStatus(Properties prop, String objClass, String folderPath) {
        if (prop != null) {
            this.currentResultRows.add(0, prop);
            while (this.currentResultRows.size() > this.dynamicSize) {
                this.currentResultRows.remove(this.currentResultRows.size() - 1);
            }
            Long l = this.totalCount;
            Long l2 = this.totalCount = Long.valueOf(this.totalCount + 1L);
        }
    }

    public void setIsCompleted(boolean flag) {
        this.isCompleted = flag;
    }

    public void setProgressTask(int taskCode) {
        this.currentTaskCode = taskCode;
    }

    public void setTaskObject(Object obj) {
        this.currentFolder = (String)obj;
    }

    public void setTaskError(Object error) {
        Hashtable<String, Object> objects = (Hashtable<String, Object>)this.taskStatus.get(this.currentTaskCode);
        if (objects == null) {
            objects = new Hashtable<String, Object>();
            this.taskStatus.put(this.currentTaskCode, objects);
        }
        objects.put(this.currentFolder, error);
    }

    public Hashtable getTaskErrors(AdventNetResourceBundle rb) {
        Enumeration keys = this.taskStatus.keys();
        Hashtable objectsVsError = new Hashtable();
        while (keys.hasMoreElements()) {
            Integer taskCode = (Integer)keys.nextElement();
            Hashtable objectNameVsErros = (Hashtable)this.taskStatus.get(taskCode);
            objectsVsError.putAll(objectNameVsErros);
        }
        return objectsVsError;
    }

    public JSONObject getJSONObject(JSONObject jsonObject, AdventNetResourceBundle rb) {
        JSONObject statusJson = new JSONObject();
        JSONArray filterDetails = new JSONArray();
        try {
            statusJson.put("errorCount", this.getTaskErrors(rb).size());
            statusJson.put("isCompleted", (Object)this.isCompleted);
            statusJson.put("count", (Object)this.totalCount);
            statusJson.put("statusMessage", (Object)this.getCurrentStatusMessage(rb));
            JSONObject json = null;
            JSONArray rvFilterIdArray = (JSONArray)jsonObject.get("rvFilterIdList");
            JSONArray filterIdAttributeList = (JSONArray)jsonObject.get("filterIdAttributeList");
            try {
                for (int index = 0; index < rvFilterIdArray.length(); ++index) {
                    json = new JSONObject();
                    int filterId = (Integer)rvFilterIdArray.get(index);
                    json.put("filterId", filterId);
                    json.put("count", (Object)this.totalCount);
                    JSONArray attributeList = (JSONArray)filterIdAttributeList.get(index);
                    json.put("rowData", (Object)this.getRowDetails(attributeList, rb));
                    json.put("uniqueIndex", 1);
                    filterDetails.put((Object)json);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            statusJson.put("filterDetails", (Object)filterDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusJson;
    }

    private JSONArray getRowDetails(JSONArray attribList, AdventNetResourceBundle rb) {
        JSONArray rowDetails = new JSONArray();
        JSONArray row = null;
        try {
            for (int index = 0; this.currentResultRows != null && index < this.currentResultRows.size(); ++index) {
                row = new JSONArray();
                Properties prop = (Properties)this.currentResultRows.get(index);
                for (int innerIndex = 0; innerIndex < attribList.length(); ++innerIndex) {
                    String val = "-";
                    Integer attribId = (Integer)attribList.get(innerIndex);
                    if (prop.containsKey(attribId)) {
                        String value = (String)prop.get(attribId);
                        val = ClientUtil.htmlEscape(rb.getString(value));
                    }
                    row.put((Object)val);
                }
                rowDetails.put((Object)row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    public int getCurrentTaskCode() {
        return this.currentTaskCode;
    }

    private String getCurrentStatusMessage(AdventNetResourceBundle rb) {
        String message = rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.modification_in_progress");
        if (this.currentTaskCode == StatusUpdater.TASKCODE.MODIFY_PERM.getValue() && this.currentFolder != null) {
            message = MessageFormat.format(rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.modifying_folder_permission"), this.currentFolder);
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue()) {
            message = rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.modify_folders_interupted");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.TASK_SCHEDULED.getValue()) {
            message = rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.modify_folders_scheduled");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.TASK_COMPLETED.getValue()) {
            message = rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.modify_folders_completing");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.TASK_REJECTED.getValue()) {
            message = rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.unable_to_add_task");
        }
        return message;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public ArrayList getCriterias() {
        return new ArrayList();
    }

    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return rb.getString("admp.mgmt.fileserver.perm_mgmt.stat_msg.empty_result");
    }

    public void updateStatus(JSONArray jsonArray, String domainName) {
    }

    public void updateErrorStatus(Hashtable errors) {
    }

    public ArrayList<Hashtable> getErrorList() {
        return null;
    }

    public JSONObject getMultiDCDetails() {
        return null;
    }

    public void init(Hashtable reportDomains) {
    }

    public void setProperties(String baseTableName, boolean isSyncEnabled, boolean isRowsUpdatedBySync) {
    }

    public void setIsRowUpdatedBySync(boolean isRowsUpdatedBySync) {
    }
}

