/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.formats;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CustomizeFormat
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.NAMING_FORMATS_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            String[] columnValue = new String[]{"REMOVE_SPACE", "REMOVE_UMLAUTS", "TRIM_SPACES_DOTS"};
            String[] paramName = new String[]{"removeSpace", "removeUmlauts", "trimSpacesDots"};
            if (request.getParameter("Save") != null) {
                if (!CustomizeFormat.duplicateNamingFormat(request).booleanValue()) {
                    Long formatId = FormatClientUtil.getFormatId("NORMAL");
                    Row r = new Row("ADSMFormats");
                    r.set("FORMAT_ID", (Object)formatId);
                    r.set("FORMAT_DISPLAY_NAME", (Object)request.getParameter("displayName"));
                    r.set("FORMAT_VALUE", (Object)request.getParameter("formatValue"));
                    r.set("REMOVE_CHARACTERS", (Object)request.getParameter("removalcharacters"));
                    for (int i = 0; i < columnValue.length; ++i) {
                        Boolean paramValue = CustomizeFormat.getBooleanValueFrmRequest(request, paramName[i]);
                        r.set(columnValue[i], (Object)paramValue);
                    }
                    Boolean restrictLength = CustomizeFormat.getBooleanValueFrmRequest(request, "restrictLength");
                    if (restrictLength.booleanValue() && request.getParameter("noOfChars") != null && !request.getParameter("noOfChars").equals("")) {
                        r.set("RESTRICTED_LENGTH", (Object)Integer.parseInt(request.getParameter("noOfChars")));
                    }
                    DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    obj.addRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.naming_formt.statusmsg_successfully_saved_format"));
                } else {
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.statmsg.display_name_exists"));
                }
            } else if (request.getParameter("Delete") != null) {
                String idStr = request.getParameter("formatId");
                Long id = new Long(idStr);
                Hashtable<String, ArrayList<String>> formatUsedIn = FormatClientUtil.getFormatUsedInInfo(id);
                boolean formatNotInUse = true;
                StringBuffer warningMsg = new StringBuffer(rb.getString("admp.admin.custom_settgs.naming_formt.using_in"));
                Set<String> keys = formatUsedIn.keySet();
                for (String key : keys) {
                    Iterator<String> it = formatUsedIn.get(key).iterator();
                    if (!it.hasNext()) continue;
                    formatNotInUse = false;
                    warningMsg.append(" [");
                    warningMsg.append(rb.getString(key));
                    warningMsg.append(" :");
                    while (it.hasNext()) {
                        warningMsg.append(it.next());
                        if (!it.hasNext()) continue;
                        warningMsg.append(", ");
                    }
                    warningMsg.append("]");
                }
                if (formatNotInUse) {
                    warningMsg.append(" [" + rb.getString("admp.mgmt.fc_layout_common.text_template") + "]");
                    formatNotInUse = FormatClientUtil.isFormatNotInUseInTemplate(id);
                }
                if (formatNotInUse) {
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(new Column("ADSMCustomFormats", "FORMAT_ID"), (Object)id, 0));
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.naming_formt.statusmsg_successfully_deleted_format"));
                } else {
                    request.setAttribute("message", (Object)warningMsg.toString());
                }
            } else if (request.getParameter("Edit") != null) {
                String idStr;
                String prevformatName;
                String formatName = request.getParameter("displayName");
                if (formatName.equalsIgnoreCase(prevformatName = CustomizeFormat.getFormatName(Long.valueOf(idStr = request.getParameter("formatId")))) || !CustomizeFormat.duplicateNamingFormat(request).booleanValue()) {
                    Long id = new Long(idStr);
                    UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMFormats");
                    Criteria crit = new Criteria(new Column("ADSMFormats", "FORMAT_ID"), (Object)id, 0);
                    updateQuery.setCriteria(crit);
                    updateQuery.setUpdateColumn("FORMAT_DISPLAY_NAME", (Object)request.getParameter("displayName"));
                    updateQuery.setUpdateColumn("FORMAT_VALUE", (Object)request.getParameter("formatValue"));
                    updateQuery.setUpdateColumn("REMOVE_CHARACTERS", (Object)request.getParameter("removalcharacters"));
                    for (int i = 0; i < columnValue.length; ++i) {
                        Boolean paramValue = CustomizeFormat.getBooleanValueFrmRequest(request, paramName[i]);
                        updateQuery.setUpdateColumn(columnValue[i], (Object)paramValue);
                    }
                    Boolean restrictLength = CustomizeFormat.getBooleanValueFrmRequest(request, "restrictLength");
                    if (restrictLength.booleanValue() && request.getParameter("noOfChars") != null && !request.getParameter("noOfChars").equals("")) {
                        updateQuery.setUpdateColumn("RESTRICTED_LENGTH", (Object)Integer.parseInt(request.getParameter("noOfChars")));
                    } else {
                        updateQuery.setUpdateColumn("RESTRICTED_LENGTH", (Object)-1);
                    }
                    updateQuery.setUpdateColumn("FORMAT_CASE", (Object)0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.naming_formt.statusmsg_successfully_edited_format"));
                } else {
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.statmsg.display_name_exists"));
                }
            }
            request.setAttribute("formats", (Object)AdminUtil.getFormats());
            request.setAttribute("rules", (Object)CustomizeFormat.getRules());
            request.setAttribute("defaultSettings", (Object)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("format");
    }

    public static DataObject getRules() {
        DataObject obj = null;
        try {
            Criteria crit = new Criteria(new Column("ADSMFormatRules", "RULE_NAME"), (Object)"", 1);
            obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRules", crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    private static Boolean getBooleanValueFrmRequest(HttpServletRequest request, String paramName) {
        Boolean paramValue = false;
        if ("on".equalsIgnoreCase(request.getParameter(paramName))) {
            paramValue = true;
        }
        return paramValue;
    }

    private static Boolean duplicateNamingFormat(HttpServletRequest request) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_DISPLAY_NAME"), (Object)request.getParameter("displayName"), 0);
        DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", criteria);
        if (!dataobj.isEmpty()) {
            return true;
        }
        return false;
    }

    public static String getFormatName(long formatId) {
        String formatName = "";
        try {
            Criteria crit = new Criteria(new Column("ADSMFormats", "FORMAT_ID"), (Object)formatId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("ADSMFormats");
                formatName = (String)r.get("FORMAT_DISPLAY_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatName;
    }
}

