/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.formats;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.formats.CustomizeFormat;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomizeFormatRule
extends DispatchAction {
    private static final String UMLAUT_CONFIGURATION_TABLE = "ADSMUmlautConfigurations";

    public ActionForward initialize(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            System.out.println("initializing bean.");
            DynaValidatorForm bean = (DynaValidatorForm)form;
            bean.set("dataObject", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward addCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Row customFormat;
            DynaValidatorForm bean = (DynaValidatorForm)form;
            DataObject dataObject = (DataObject)bean.get("dataObject");
            if (dataObject == null) {
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                bean.set("dataObject", (Object)dataObject);
            }
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String[] attributeArray = new String[]{"givenName", "sn", "initials", "userPrincipalName", "sAMAccountName", "resultantFormatValLength"};
            String[] attributeArrayValue = new String[]{rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_first_name"), rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_last_name"), rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_middle_name"), rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_logon_name"), rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_sam_account_name"), rb.getString("admp.admin.custom_settgs.naming_formt.attribvalue_format_val_len")};
            String[] constraintNameArray = new String[]{"start", "end", "<", ">"};
            String[] constraintNameArrayValue = new String[]{rb.getString("admp.admin.custom_settgs.naming_formt.criteria.starts_with"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.ends_with"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.less_than"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.greater_than")};
            String[] constraintArray = new String[]{"NULL", "notNULL", ".", " "};
            String[] constraintArrayValue = new String[]{rb.getString("admp.admin.custom_settgs.naming_formt.criteria.empty"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.not_empty"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.contain_dot"), rb.getString("admp.admin.custom_settgs.naming_formt.criteria.contain_space")};
            String[] constraintNameExceptionArray = new String[]{"is", "contain"};
            String matchingCriteria = request.getParameter("match_crit");
            String selConditionFormat = request.getParameter("sel_condn_format");
            int rowCount = Integer.parseInt(request.getParameter("rowCount"));
            Long ruleId = 0L;
            if (dataObject.isEmpty()) {
                customFormat = new Row("ADSMCustomFormats");
                DBUtil.fillGeneratedValues((Row)customFormat);
                customFormat.set("FORMAT_TYPE", (Object)"ADVANCED");
                ruleId = (Long)customFormat.get("FORMAT_ID");
                Row formatRule = new Row("ADSMFormatRules");
                formatRule.set("FORMAT_ID", customFormat.get("FORMAT_ID"));
                dataObject.addRow(customFormat);
                dataObject.addRow(formatRule);
            } else {
                customFormat = dataObject.getFirstRow("ADSMCustomFormats");
                ruleId = (Long)customFormat.get("FORMAT_ID");
            }
            Long priority = 0L;
            Iterator it = dataObject.getRows("ADSMFormatRuleConditions");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long l = (Long)r.get("PRIORITY");
                if (l <= priority) continue;
                priority = l;
            }
            Row condRow = new Row("ADSMFormatRuleConditions");
            DBUtil.fillGeneratedValues((Row)condRow);
            condRow.set("FORMAT_ID", (Object)ruleId);
            condRow.set("MATCHING_CRITERIA", (Object)matchingCriteria);
            condRow.set("PRIORITY", (Object)new Long(priority + 1L));
            condRow.set("RESULTANT_FORMAT", (Object)Long.parseLong(selConditionFormat));
            dataObject.addRow(condRow);
            Long condnId = (Long)condRow.get("CONDITION_ID");
            for (int i = 0; i < rowCount; ++i) {
                int j;
                String attributeName = request.getParameter("attributeName" + i);
                String constraintName = request.getParameter("constraint" + i);
                String constraintValue = request.getParameter("constraintValue" + i);
                Row critRow = new Row("ADSMFormatRuleCondnCrits");
                critRow.set("CONDITION_ID", (Object)condnId);
                critRow.set("ATTRIBUTE_NAME", (Object)attributeName);
                critRow.set("CRITERIA", (Object)constraintName);
                critRow.set("CRITERIA_VALUE", (Object)constraintValue);
                for (j = 0; j < attributeArray.length; ++j) {
                    if (!attributeArray[j].equals(attributeName)) continue;
                    attributeName = attributeArrayValue[j];
                }
                for (j = 0; j < constraintNameArray.length; ++j) {
                    if (!constraintNameArray[j].equals(constraintName)) continue;
                    constraintName = constraintNameArrayValue[j];
                }
                for (j = 0; j < constraintArray.length; ++j) {
                    if (!constraintArray[j].equals(constraintValue)) continue;
                    constraintValue = constraintArrayValue[j];
                }
                for (j = 0; j < constraintNameExceptionArray.length; ++j) {
                    if (!constraintNameExceptionArray[j].equals(constraintName)) continue;
                    constraintName = "";
                }
                String description = attributeName + " " + constraintName + " " + constraintValue;
                critRow.set("CRITERIA_DESCRIPTION", (Object)description);
                dataObject.addRow(critRow);
            }
            TreeMap conditions = FormatClientUtil.getConditionProps(dataObject, rb);
            ByteArrayOutputStream outNode = this.getConditionsXMLElement(ruleId, conditions.values(), rb);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward addRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ByteArrayOutputStream outNode = null;
            DynaValidatorForm bean = (DynaValidatorForm)form;
            DataObject dataObject = (DataObject)bean.get("dataObject");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String ruleIdstr = request.getParameter("ruleId");
            Long ruleId = Long.parseLong(ruleIdstr);
            String ruleName = request.getParameter("ruleName");
            String ruleFormatsValStr = request.getParameter("ruleFormatsVal");
            Long ruleFormatsVal = Long.parseLong(ruleFormatsValStr);
            if (!CustomizeFormatRule.duplicateNamingFormat(request).booleanValue()) {
                String condns = request.getParameter("condns");
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMFormatRules");
                Criteria crit = new Criteria(new Column("ADSMFormatRules", "FORMAT_ID"), (Object)ruleId, 0);
                Row formatRule = dataObject.getFirstRow("ADSMFormatRules");
                formatRule.set("RULE_NAME", (Object)ruleName);
                formatRule.set("DEFAULT_FORMAT", (Object)ruleFormatsVal);
                String[] condnIds = condns.split(",");
                for (int i = 0; i < condnIds.length; ++i) {
                    Criteria criteria = new Criteria(new Column("ADSMFormatRuleConditions", "CONDITION_ID"), (Object)condnIds[i], 0);
                    Row condRow = dataObject.getRow("ADSMFormatRuleConditions", criteria);
                    condRow.set("PRIORITY", (Object)new Long(i + 1));
                    dataObject.updateRow(condRow);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
                TreeMap conditions = FormatClientUtil.getConditionProps(dataObject, rb);
                outNode = this.listRulesXMLElement(ruleId, ruleName, ruleFormatsVal, conditions.values(), rb);
            } else {
                outNode = CustomizeFormatRule.listRuleError(true);
            }
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ByteArrayOutputStream listRuleError(Boolean isDuplicateRuleName) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element errorElt = document.createElement("error");
            errorElt.setAttribute("duplicate_rule_name", isDuplicateRuleName.toString());
            data.appendChild(errorElt);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    private static Boolean duplicateNamingFormat(HttpServletRequest request) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMFormatRules", (String)"RULE_NAME"), (Object)request.getParameter("ruleName"), 0);
        DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRules", criteria);
        if (!dataobj.isEmpty()) {
            return true;
        }
        return false;
    }

    public ActionForward getRuleDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String ruleIdstr = request.getParameter("ruleId");
            Long ruleIdLong = Long.parseLong(ruleIdstr);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMFormatRules", (String)"FORMAT_ID"), (Object)ruleIdLong, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ADSMCustomFormats", crit);
            bean.set("dataObject", (Object)obj);
            TreeMap conditions = FormatClientUtil.getConditionProps(obj, rb);
            ByteArrayOutputStream outNode = this.getRuleDetailsXMLElement(obj, conditions.values(), rb);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            DataObject dataObject = (DataObject)bean.get("dataObject");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String ruleId = request.getParameter("ruleId");
            Long ruleIdLong = Long.parseLong(ruleId);
            String ruleName = request.getParameter("ruleName");
            String ruleFormatsValStr = request.getParameter("ruleFormatsVal");
            Long ruleFormatsVal = Long.parseLong(ruleFormatsValStr);
            String condns = request.getParameter("condns");
            String deleteCondnIdList = request.getParameter("deleteCondnIdList");
            Row formatRuleRow = dataObject.getFirstRow("ADSMFormatRules");
            String oldRuleName = (String)formatRuleRow.get("RULE_NAME");
            ByteArrayOutputStream outNode = null;
            if (ruleName.equalsIgnoreCase(oldRuleName) || !CustomizeFormatRule.duplicateNamingFormat(request).booleanValue()) {
                int i;
                formatRuleRow.set("RULE_NAME", (Object)ruleName);
                formatRuleRow.set("DEFAULT_FORMAT", (Object)ruleFormatsVal);
                dataObject.updateRow(formatRuleRow);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMFormatRules");
                String[] deleteCondnIds = deleteCondnIdList.split(",");
                String[] condnIds = condns.split(",");
                ArrayList<String> condnIdsList = new ArrayList<String>(condnIds.length);
                for (String s : condnIds) {
                    condnIdsList.add(s);
                }
                for (i = 0; i < deleteCondnIds.length; ++i) {
                    if (!condnIdsList.contains(deleteCondnIds[i])) continue;
                    condnIdsList.remove(deleteCondnIds[i]);
                    dataObject.deleteRows("ADSMFormatRuleConditions", new Criteria(Column.getColumn((String)"ADSMFormatRuleConditions", (String)"CONDITION_ID"), (Object)deleteCondnIds[i], 0));
                }
                for (i = 0; i < condnIdsList.size(); ++i) {
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMFormatRuleConditions", (String)"CONDITION_ID"), condnIdsList.get(i), 0);
                    Row conditionRow = dataObject.getRow("ADSMFormatRuleConditions", criteria);
                    conditionRow.set("PRIORITY", (Object)new Long(i + 1));
                    dataObject.updateRow(conditionRow);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                TreeMap conditions = FormatClientUtil.getConditionProps(dataObject, rb);
                outNode = this.listRulesXMLElement(ruleIdLong, ruleName, ruleFormatsVal, conditions.values(), rb);
            } else {
                outNode = CustomizeFormatRule.listRuleError(true);
            }
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteConditionRow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            DataObject dataObject = (DataObject)bean.get("dataObject");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String condnIdstr = request.getParameter("conditionId");
            Long conditionId = Long.parseLong(condnIdstr);
            dataObject.deleteRows("ADSMFormatRuleConditions", new Criteria(Column.getColumn((String)"ADSMFormatRuleConditions", (String)"CONDITION_ID"), (Object)conditionId, 0));
            TreeMap conditions = FormatClientUtil.getConditionProps(dataObject, rb);
            String ruleIdstr = request.getParameter("ruleId");
            Long ruleId = Long.parseLong(ruleIdstr);
            ByteArrayOutputStream outNode = this.getConditionsXMLElement(ruleId, conditions.values(), rb);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            bean.set("dataObject", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String ruleIdstr = request.getParameter("ruleId");
            Long ruleId = Long.parseLong(ruleIdstr);
            Hashtable<String, ArrayList<String>> ruleUsedIn = FormatClientUtil.getAdvFormatUsedInInfo(ruleId);
            boolean ruleNotInUse = true;
            StringBuffer message = new StringBuffer(rb.getString("admp.admin.custom_settgs.naming_formt.using_in"));
            Set<String> keys = ruleUsedIn.keySet();
            for (String key : keys) {
                Iterator<String> it = ruleUsedIn.get(key).iterator();
                if (!it.hasNext()) continue;
                ruleNotInUse = false;
                message.append(" [");
                message.append(rb.getString(key));
                message.append(" :");
                while (it.hasNext()) {
                    message.append(it.next());
                    if (!it.hasNext()) continue;
                    message.append(",");
                }
                message.append("]");
            }
            if (ruleNotInUse) {
                message.append(" [" + rb.getString("admp.mgmt.fc_layout_common.text_template") + "]");
                ruleNotInUse = FormatClientUtil.isFormatNotInUseInTemplate(ruleId);
            }
            if (ruleNotInUse) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(new Column("ADSMCustomFormats", "FORMAT_ID"), (Object)ruleId, 0));
                message = new StringBuffer("SUCCESS");
            }
            ByteArrayOutputStream outNode = this.deleteStatusXMLElement(message.toString());
            response.setContentType("text/xml; charset =UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward setDefaultFormatSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Criteria criteria = null;
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatDefaultSettings", criteria);
            ArrayList<Properties> defaultValuesList = new ArrayList<Properties>();
            if (!dob.isEmpty()) {
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMFormatDefaultSettings");
                criteria = null;
                dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatDefaultSettings", criteria);
                updateQuery.setCriteria(criteria);
                for (int i = 0; i < UserMgmtUtil.formatColumnNames.length; ++i) {
                    Long formatVal = Long.parseLong(request.getParameter(UserMgmtUtil.formatColumnNames[i]));
                    updateQuery.setUpdateColumn(UserMgmtUtil.formatColumnNames[i], (Object)formatVal);
                    Properties defaultValueProp = new Properties();
                    defaultValueProp.setProperty("ATTRIB_COLUMN_NAME", UserMgmtUtil.formatColumnNames[i].substring(0, UserMgmtUtil.formatColumnNames[i].length() - 7));
                    defaultValueProp.setProperty("FORMAT_ID", formatVal.toString());
                    defaultValuesList.add(defaultValueProp);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
            } else {
                Row r = new Row("ADSMFormatDefaultSettings");
                for (int i = 0; i < UserMgmtUtil.formatColumnNames.length; ++i) {
                    r.set(UserMgmtUtil.formatColumnNames[i], (Object)request.getParameter(UserMgmtUtil.formatColumnNames[i]));
                    Properties defaultValueProp = new Properties();
                    defaultValueProp.setProperty("ATTRIB_COLUMN_NAME", UserMgmtUtil.formatColumnNames[i].substring(0, UserMgmtUtil.formatColumnNames[i].length() - 7));
                    defaultValueProp.setProperty("FORMAT_ID", request.getParameter(UserMgmtUtil.formatColumnNames[i]));
                    defaultValuesList.add(defaultValueProp);
                }
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                obj.addRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
            }
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcLayoutUpdateHandler.setDefaultNamingFormatSettings(defaultValuesList, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getDefaultFormatSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList<Long> formatValueList = new ArrayList<Long>();
            Criteria criteria = null;
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatDefaultSettings", criteria);
            Iterator it = obj.getRows("ADSMFormatDefaultSettings");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                for (int i = 0; i < UserMgmtUtil.formatColumnNames.length; ++i) {
                    formatValueList.add((Long)r.get(UserMgmtUtil.formatColumnNames[i]));
                }
            }
            for (int i = 0; i < UserMgmtUtil.formatColumnNames.length; ++i) {
                Long formatValue = 0L;
                if (formatValueList.size() > 0) {
                    formatValue = (Long)formatValueList.get(i);
                }
                request.setAttribute(UserMgmtUtil.formatColumnNames[i], (Object)formatValue.toString());
            }
            request.setAttribute("formats", (Object)AdminUtil.getFormats());
            request.setAttribute("rules", (Object)CustomizeFormat.getRules());
            request.setAttribute("defaultSettings", (Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("format");
    }

    private ByteArrayOutputStream getConditionsXMLElement(Long ruleId, Collection condnPropList, AdventNetResourceBundle rb) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element ruleIdElt = document.createElement("ruleId");
            ruleIdElt.setAttribute("ruleIdValue", ruleId.toString());
            data.appendChild(ruleIdElt);
            for (Properties prop : condnPropList) {
                Element condn = document.createElement("condn");
                condn.setAttribute("condn_desc", (String)prop.get("condnDesc"));
                data.appendChild(condn);
                Element condnIds = document.createElement("condn_id");
                condnIds.setAttribute("condn_id_val", prop.get("condnId").toString());
                data.appendChild(condnIds);
                Element format = document.createElement("format");
                format.setAttribute("format_val", prop.get("format").toString());
                data.appendChild(format);
            }
            Element conditionText = document.createElement("conditionText");
            conditionText.setAttribute("conditionTextVal", rb.getString("admp.admin.custom_settgs.naming_formt.statmsg.condition"));
            data.appendChild(conditionText);
            Element formatText = document.createElement("formatText");
            formatText.setAttribute("formatTextVal", rb.getString("admp.admin.custom_settgs.naming_formt.statmsg.format"));
            data.appendChild(formatText);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    private ByteArrayOutputStream getRuleDetailsXMLElement(DataObject obj, Collection condnPropList, AdventNetResourceBundle rb) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Row r = obj.getFirstRow("ADSMFormatRules");
            Long ruleId = (Long)r.get("FORMAT_ID");
            String ruleName = (String)r.get("RULE_NAME");
            Long defFormat = (Long)r.get("DEFAULT_FORMAT");
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element ruleIdElt = document.createElement("ruleId");
            ruleIdElt.setAttribute("ruleIdValue", ruleId.toString());
            data.appendChild(ruleIdElt);
            Element ruleNameElt = document.createElement("rule_name");
            ruleNameElt.setAttribute("ruleName", ruleName);
            data.appendChild(ruleNameElt);
            Element defFormatValue = document.createElement("def_format_val");
            defFormatValue.setAttribute("def_format", defFormat.toString());
            data.appendChild(defFormatValue);
            for (Properties prop : condnPropList) {
                Element condn = document.createElement("condn");
                condn.setAttribute("condn_desc", (String)prop.get("condnDesc"));
                data.appendChild(condn);
                Element condnIds = document.createElement("condn_id");
                condnIds.setAttribute("condn_id_val", prop.get("condnId").toString());
                data.appendChild(condnIds);
                Element format = document.createElement("format");
                format.setAttribute("format_val", prop.get("format").toString());
                data.appendChild(format);
            }
            Element conditionText = document.createElement("conditionText");
            conditionText.setAttribute("conditionTextVal", rb.getString("admp.admin.custom_settgs.naming_formt.statmsg.condition"));
            data.appendChild(conditionText);
            Element formatText = document.createElement("formatText");
            formatText.setAttribute("formatTextVal", rb.getString("admp.admin.custom_settgs.naming_formt.statmsg.format"));
            data.appendChild(formatText);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    private ByteArrayOutputStream listRulesXMLElement(Long ruleId, String ruleName, Long ruleFormatsVal, Collection condnPropList, AdventNetResourceBundle rb) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element ruleIdElt = document.createElement("rule_id");
            ruleIdElt.setAttribute("ruleId", ruleId.toString());
            data.appendChild(ruleIdElt);
            Element ruleNameElt = document.createElement("rule_name");
            ruleNameElt.setAttribute("ruleName", ruleName);
            data.appendChild(ruleNameElt);
            Element ruleDefFormat = document.createElement("rule_def_format");
            ruleDefFormat.setAttribute("def_format", FormatClientUtil.getNamingFormatDisplayName(ruleFormatsVal, rb));
            data.appendChild(ruleDefFormat);
            for (Properties prop : condnPropList) {
                Element condn = document.createElement("condn");
                condn.setAttribute("condn_desc", (String)prop.get("condnDesc"));
                data.appendChild(condn);
                Element format = document.createElement("formats");
                format.setAttribute("format_name", prop.get("format").toString());
                data.appendChild(format);
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    private ByteArrayOutputStream deleteStatusXMLElement(String message) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element statusMessage = document.createElement("message");
            statusMessage.setAttribute("message", message);
            data.appendChild(statusMessage);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public static ActionForward umlautConfigurations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DataObject dataObject = FormatUtil.getUmlautConfigurationsDO();
            request.setAttribute("umlautConfigurationsDO", (Object)dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("umlautDialog");
    }

    public ActionForward saveUmlautDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Criteria crit;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String umlautInp = request.getParameter("umlaut");
            String umlaut = "";
            for (int i = 0; i < umlautInp.length(); ++i) {
                umlaut = umlaut + "\\u" + Integer.toHexString(umlautInp.charAt(i) | 0x10000).substring(1);
            }
            String replChar = request.getParameter("replChar");
            String message = "";
            String messageStyle = "";
            DataObject dataObject = FormatUtil.getUmlautConfigurationsDO();
            String val = (String)dataObject.getValue(UMLAUT_CONFIGURATION_TABLE, "UMLAUT", crit = new Criteria(Column.getColumn((String)UMLAUT_CONFIGURATION_TABLE, (String)"UMLAUT"), (Object)umlaut, 0));
            if (val != null) {
                message = rb.getString("admp.admin.custom_settgs.naming_formt.statmsg_umlaut_already_exists");
                messageStyle = "redtxtbold";
                this.setUmlautJSONObject(response, message, messageStyle, dataObject);
            } else {
                Row r = new Row(UMLAUT_CONFIGURATION_TABLE);
                r.set("UMLAUT", (Object)umlaut);
                r.set("REPLACE_CHAR", (Object)EscapeUtil.escapeNamingFormat((String)replChar));
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                obj.addRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
                message = rb.getString("admp.admin.custom_settgs.naming_formt.statmsg_successfully_added");
                messageStyle = "greentextbold";
                dataObject.addRow(r);
                this.setUmlautJSONObject(response, message, messageStyle, dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteUmlautDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String umlautId = request.getParameter("umlautId");
            Long id = new Long(umlautId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)UMLAUT_CONFIGURATION_TABLE, (String)"UMLAUT_ID"), (Object)id, 0));
            String message = rb.getString("admp.admin.custom_settgs.naming_formt.statmsg_successfully_deleted");
            String messageStyle = "greentextbold";
            DataObject dataObject = FormatUtil.getUmlautConfigurationsDO();
            this.setUmlautJSONObject(response, message, messageStyle, dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ActionForward updateUmlautDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String umlautId = request.getParameter("umlautId");
            Long id = new Long(umlautId);
            UpdateQueryImpl updateQuery = new UpdateQueryImpl(UMLAUT_CONFIGURATION_TABLE);
            Criteria crit = new Criteria(Column.getColumn((String)UMLAUT_CONFIGURATION_TABLE, (String)"UMLAUT_ID"), (Object)id, 0);
            updateQuery.setCriteria(crit);
            updateQuery.setUpdateColumn("REPLACE_CHAR", (Object)EscapeUtil.escapeNamingFormat((String)request.getParameter("replChar")));
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward searchUmlautDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String umlautInp = request.getParameter("searchChar");
            DataObject dataObject = FormatUtil.getUmlautConfigurationsDO();
            DataObject resultDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String umlautCrit = "";
            String message = "";
            String messageStyle = "";
            if (!umlautInp.equals("")) {
                for (int i = 0; i < umlautInp.length(); ++i) {
                    umlautCrit = umlautCrit + "\\u" + Integer.toHexString(umlautInp.charAt(i) | 0x10000).substring(1);
                }
                Criteria crit = new Criteria(Column.getColumn((String)UMLAUT_CONFIGURATION_TABLE, (String)"UMLAUT"), (Object)umlautCrit, 0);
                if (dataObject.getRow(UMLAUT_CONFIGURATION_TABLE, crit) != null) {
                    resultDataObj.addRow(dataObject.getRow(UMLAUT_CONFIGURATION_TABLE, crit));
                }
                if (resultDataObj.isEmpty()) {
                    message = rb.getString("admp.admin.custom_settgs.naming_formt.statmsg_no_matching_umlaut");
                    messageStyle = "redtxtbold";
                }
            } else {
                resultDataObj = dataObject;
            }
            this.setUmlautJSONObject(response, message, messageStyle, resultDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setUmlautJSONObject(HttpServletResponse response, String message, String messageStyle, DataObject dataObject) throws Exception {
        try {
            JSONObject umlautJSONObj = new JSONObject();
            JSONArray umlautJSONArray = new JSONArray();
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(UMLAUT_CONFIGURATION_TABLE);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    JSONObject obj = new JSONObject();
                    obj.put("umlautId", (Object)((Long)row.get("UMLAUT_ID")));
                    String umlaut = (String)row.get("UMLAUT");
                    String[] umlautStrArray = umlaut.split("\\\\u");
                    String resUmlautStr = "";
                    for (String tempUmlautStr : umlautStrArray) {
                        if (tempUmlautStr.equals("")) continue;
                        resUmlautStr = resUmlautStr + (char)Integer.parseInt(tempUmlautStr, 16);
                    }
                    obj.put("umlaut", (Object)resUmlautStr);
                    obj.put("replChar", (Object)EscapeUtil.unEscapeNamingFormat((String)((String)row.get("REPLACE_CHAR"))));
                    umlautJSONArray.put((Object)obj);
                }
            }
            umlautJSONObj.put("message", (Object)message);
            umlautJSONObj.put("messageStyle", (Object)messageStyle);
            umlautJSONObj.put("umlautList", (Object)umlautJSONArray);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(umlautJSONObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

