/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.formats;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.formats.AdvancedFormatUtil;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.formats.UserCreationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.formats.UserModificationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.struts.validator.DynaValidatorForm;

public class FormatClientUtil {
    private static final String NAMING_FORMATS_TABLE = "ADSMFormats";
    private static final String FC_AVOID_DUPLICATION_MENU = "FcAvoidDuplicationMenuItem";

    public static String getFormattedName(Long formatId, Hashtable resultHash, String domainName, String logonName, ArrayList customAttribList) {
        String formattedName = "";
        try {
            formattedName = FormatUtil.getFormattedName((Long)formatId, (Hashtable)resultHash, (String)domainName, (String)logonName, (ArrayList)customAttribList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    public static String getFormattedName(Long formatId, DynaValidatorForm dynaValidatorForm, String domainName, String logonName, ArrayList customAttribList) {
        String formattedName = "";
        try {
            String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
            if (formatType.equals("ADVANCED")) {
                Long resultantFormatId;
                formatId = resultantFormatId = FormatClientUtil.getAdvancedFormatIdValue(formatId, dynaValidatorForm, new Hashtable(), domainName, logonName, "", customAttribList);
            }
            String format = FormatClientUtil.getStringColumnValue(NAMING_FORMATS_TABLE, "FORMAT_ID", formatId, "FORMAT_VALUE");
            formattedName = UserCreationFormatUtil.getFormattedName(format, dynaValidatorForm, domainName, logonName, customAttribList);
            formattedName = FormatUtil.applyFormatRestrictions((Long)formatId, (String)formattedName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    private static Long getAdvancedFormatIdValue(Long formatId, DynaValidatorForm dynaValidatorForm, Hashtable resultHash, String domainName, String logonName, String objectClass, ArrayList customAttribList) {
        Long resultantFormatId = 0L;
        try {
            Long defFormatId = AdvancedFormatUtil.getDefaultNamingFormatRule((Long)formatId);
            String defFormat = FormatClientUtil.getStringColumnValue(NAMING_FORMATS_TABLE, "FORMAT_ID", defFormatId, "FORMAT_VALUE");
            String defFormattedName = "";
            defFormattedName = UserCreationFormatUtil.getFormattedName(defFormat, dynaValidatorForm, domainName, logonName, customAttribList);
            defFormattedName = FormatUtil.applyFormatRestrictions((Long)defFormatId, (String)defFormattedName);
            int formattedNameLen = defFormattedName.length();
            resultantFormatId = FormatUtil.getAdvancedFormatIdValue((Long)formatId, (DynaValidatorForm)dynaValidatorForm, (Hashtable)resultHash, (String)domainName, (String)logonName, (String)"", (ArrayList)customAttribList, (Long)defFormatId, (int)formattedNameLen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultantFormatId;
    }

    public static String getFormatValue(Long formatId, Hashtable resultHash, String domainName, String objectClass) {
        String formattedName = "";
        try {
            String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
            if (formatType.equals("ADVANCED")) {
                Long resultantFormatId;
                formatId = resultantFormatId = FormatUtil.getAdvancedFormatIdValue((Long)formatId, null, (Hashtable)resultHash, (String)domainName, (String)"", (String)objectClass, new ArrayList());
            }
            String format = FormatClientUtil.getStringColumnValue(NAMING_FORMATS_TABLE, "FORMAT_ID", formatId, "FORMAT_VALUE");
            formattedName = UserModificationFormatUtil.getFormatValue(format, resultHash, domainName, objectClass);
            formattedName = FormatUtil.applyFormatRestrictions((Long)formatId, (String)formattedName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    public static String getFormatValue(String format, Hashtable resultHash, String domainName, String objectClass) {
        String formattedName = "";
        try {
            formattedName = UserModificationFormatUtil.getFormatValue(format, resultHash, domainName, objectClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    public static String getFormatValueForCustomScript(String format, Hashtable resultHash, String domainName, String objectClass) {
        String formattedName = "";
        try {
            formattedName = UserModificationFormatUtil.getFormatValue(format, resultHash, domainName, objectClass, Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    public static Hashtable<String, ArrayList> getNamingFormats(AdventNetResourceBundle resBund) {
        DataObject dataObject = UserMgmtUtil.getFormats();
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        try {
            ArrayList<String> displayList = new ArrayList<String>();
            ArrayList<Long> valueList = new ArrayList<Long>();
            Iterator iterator = dataObject.getRows(NAMING_FORMATS_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                displayList.add(resBund.getString((String)row.get("FORMAT_DISPLAY_NAME")));
                Long formatId = (Long)row.get("FORMAT_ID");
                valueList.add(formatId);
            }
            hashtable.put("displayList", displayList);
            hashtable.put("valueList", valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashtable;
    }

    public static String getNamingFormatDisplayName(Long formatId, AdventNetResourceBundle resBund) {
        String formatValue = "";
        try {
            Criteria criteria = new Criteria(new Column(NAMING_FORMATS_TABLE, "FORMAT_ID"), (Object)formatId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(NAMING_FORMATS_TABLE, criteria);
            Row row = dataObject.getRow(NAMING_FORMATS_TABLE);
            if (row.get("FORMAT_DISPLAY_NAME") != null) {
                formatValue = resBund.getString(row.get("FORMAT_DISPLAY_NAME").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatValue;
    }

    public static Hashtable getDefaultNamingFormatSettings() {
        Hashtable hash = FormatUtil.getDefaultNamingFormatSettings();
        return hash;
    }

    public static String getFormatValue(String domainName, String format, UserBean userBean, ArrayList customAttribList) {
        String formatValue = UserModificationFormatUtil.getFormatValue(domainName, format, userBean, customAttribList);
        return formatValue;
    }

    public static String getFormatValue(String domainName, String format, UserBean userBean, ArrayList customAttribList, boolean homedir) {
        String formatValue = UserModificationFormatUtil.getFormatValue(domainName, format, userBean, customAttribList, homedir);
        return formatValue;
    }

    public static String getFormatValue(String domainName, String format, ArrayList<Hashtable> valuesList, String sAMAccountName, String userName, ArrayList customAttribList) {
        String formatValue = UserModificationFormatUtil.getFormatValue(domainName, format, valuesList, sAMAccountName, userName, customAttribList);
        return formatValue;
    }

    public static String getFormatValue(String domainName, String format, ArrayList<Hashtable> valuesList, String sAMAccountName, String userName, ArrayList customAttribList, boolean homedir) {
        String formatValue = UserModificationFormatUtil.getFormatValue(domainName, format, valuesList, sAMAccountName, userName, customAttribList, homedir);
        return formatValue;
    }

    public static Hashtable<String, ArrayList> getNamingFormatRules(AdventNetResourceBundle resBund) {
        Hashtable ruleHash = new Hashtable();
        try {
            ruleHash = AdvancedFormatUtil.getNamingFormatRules((AdventNetResourceBundle)resBund);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ruleHash;
    }

    public static String getStringColumnValue(String tableName, String critColumnName, Long critValue, String columnName) {
        String strValue = FormatUtil.getStringColumnValue((String)tableName, (String)critColumnName, (Long)critValue, (String)columnName);
        return strValue;
    }

    public static Integer getNamingFormatRestrictedLength(Long formatId) {
        Integer restrictedLen = FormatUtil.getNamingFormatRestrictedLength((Long)formatId);
        return restrictedLen;
    }

    public static Long getFormatId(String formatType) {
        Long formatId = 0L;
        try {
            Row r = new Row("ADSMCustomFormats");
            r.set("FORMAT_TYPE", (Object)formatType);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            obj.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
            obj = null;
            Criteria crit = null;
            obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFormats", crit);
            Iterator it = obj.getRows("ADSMCustomFormats");
            while (it.hasNext()) {
                r = (Row)it.next();
                formatId = (Long)r.get("FORMAT_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatId;
    }

    public static Hashtable<String, ArrayList<String>> getFormatUsedInInfo(Long formatId) {
        Hashtable<String, ArrayList<String>> formatUsedIn = new Hashtable<String, ArrayList<String>>();
        try {
            formatUsedIn.put("admp.admin.custom_settgs.naming_formt.text_def_settgs", AdvancedFormatUtil.getFormatUsedDefSettgsList((Long)formatId));
            formatUsedIn.put("admp.admin.custom_settgs.naming_formt.text_advanced_format", FormatUtil.getFormatUsedAdvFmtList((Long)formatId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatUsedIn;
    }

    public static Hashtable<String, ArrayList<String>> getAdvFormatUsedInInfo(Long formatId) {
        Hashtable<String, ArrayList<String>> advFormatUsedIn = new Hashtable<String, ArrayList<String>>();
        try {
            advFormatUsedIn.put("admp.admin.custom_settgs.naming_formt.text_def_settgs", AdvancedFormatUtil.getFormatUsedDefSettgsList((Long)formatId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return advFormatUsedIn;
    }

    public static Long getPriority(Long formatId) {
        Long priority = 0L;
        priority = AdvancedFormatUtil.getPriority((Long)formatId);
        return priority;
    }

    public static Collection getConditionProps(Long ruleId, AdventNetResourceBundle rb) {
        Collection collection = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMFormatRules", (String)"FORMAT_ID"), (Object)ruleId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ADSMCustomFormats", crit);
            TreeMap map = FormatClientUtil.getConditionProps(obj, rb);
            collection = map.values();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collection;
    }

    public static TreeMap getConditionProps(DataObject dataObject, AdventNetResourceBundle rb) {
        TreeMap<Long, Properties> sortedConditions = new TreeMap<Long, Properties>();
        try {
            Iterator it = dataObject.getRows("ADSMFormatRuleConditions");
            while (it.hasNext()) {
                Properties prop = new Properties();
                Row r = (Row)it.next();
                Long condnId = (Long)r.get("CONDITION_ID");
                String matching = (String)r.get("MATCHING_CRITERIA");
                Long priority = (Long)r.get("PRIORITY");
                String condnDesc = "";
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMFormatRuleCondnCrits", (String)"CONDITION_ID"), (Object)condnId, 0);
                Iterator it1 = dataObject.getRows("ADSMFormatRuleCondnCrits", crit);
                while (it1.hasNext()) {
                    Row r1 = (Row)it1.next();
                    String desc = (String)r1.get("CRITERIA_DESCRIPTION");
                    condnDesc = !condnDesc.equals("") ? condnDesc + " " + desc : desc;
                    if (!it1.hasNext()) continue;
                    condnDesc = condnDesc + " " + matching;
                }
                prop.put("condnDesc", condnDesc);
                prop.put("condnId", condnId);
                Long resultFormat = (Long)r.get("RESULTANT_FORMAT");
                String format = FormatClientUtil.getNamingFormatDisplayName(resultFormat, rb);
                prop.put("format", format);
                sortedConditions.put(priority, prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortedConditions;
    }

    public static boolean isFormatNotSelectedToAvoidDuplication(Long formatId, String criColumn) {
        boolean formatNotInUse = true;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)FC_AVOID_DUPLICATION_MENU));
            Criteria criteria = null;
            if (criColumn.equals("FORMAT_ID")) {
                criteria = new Criteria(Column.getColumn((String)FC_AVOID_DUPLICATION_MENU, (String)criColumn), (Object)formatId, 0);
            } else {
                String searchStringFormatId = "\"" + String.valueOf(formatId) + "\"";
                criteria = new Criteria(Column.getColumn((String)FC_AVOID_DUPLICATION_MENU, (String)criColumn), (Object)("*" + searchStringFormatId + "*"), 2);
            }
            criteria = criteria.and(new Criteria(Column.getColumn((String)FC_AVOID_DUPLICATION_MENU, (String)"IS_APPLY_NAMING_FORMAT"), (Object)true, 0));
            query.addSelectColumn(Column.getColumn((String)FC_AVOID_DUPLICATION_MENU, (String)"UNIQUE_ID"));
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                formatNotInUse = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatNotInUse;
    }

    public static boolean isFormatNotInUseInTemplate(Long formatId) {
        boolean formatNotInUse = true;
        formatNotInUse = FormatClientUtil.isFormatNotSelectedToAvoidDuplication(formatId, "FORMAT_ID");
        if (formatNotInUse) {
            formatNotInUse = FormatClientUtil.isFormatNotSelectedToAvoidDuplication(formatId, "FORMAT_ID_LIST");
        }
        return formatNotInUse;
    }
}

