/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.formats;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ComputerUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserModificationFormatUtil {
    protected static Logger logger = Logger.getLogger("ADMangLogger");
    private static final String NAMING_FORMATS_TABLE = "ADSMFormats";

    public static String getFormatValue(String format, Hashtable result, String domainName, String objectClass) {
        return UserModificationFormatUtil.getFormatValue(format, result, domainName, objectClass, (Boolean)false);
    }

    public static String getFormatValue(String format, Hashtable result, String domainName, String objectClass, Boolean isCustomScript) {
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        AdventNetResourceBundle rb = (AdventNetResourceBundle)result.get("rb");
        StringBuffer value = new StringBuffer();
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            if (!isCustomScript.booleanValue()) {
                prevStr = prevStr.replaceAll("\"", "");
            }
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                Long loginId = (Long)result.get("loginId");
                noOfLetters = FormatUtil.getNoOfLetters((String)format, (int)nextIndex, (int)length);
                String ldapName = format.substring(index + 1, nextIndex);
                String attribValue = UserModificationFormatUtil.getAttributeValue(ldapName, domainName, result, objectClass);
                if (ldapName.equalsIgnoreCase("rand")) {
                    attribValue = FormatUtil.getRandomNumber((String)noOfLetters);
                }
                if (ldapName.equalsIgnoreCase("createdTime") && loginId != null) {
                    attribValue = DateTimeUtil.getTimeZoneDate((Long)loginId);
                }
                if (ldapName.equalsIgnoreCase("Technician") && loginId != null) {
                    attribValue = rb.getString(HelpdeskUtil.getLoginUserName((Long)loginId));
                }
                if (attribValue != null) {
                    nextIndex = FormatUtil.applyFormatsToAttribute((String)format, (String)attribValue, (String)noOfLetters, (int)nextIndex, (StringBuffer)value);
                } else {
                    value.append(format.substring(index, nextIndex + 1));
                    String actions = FormatUtil.getFormatActionString((String)format, (int)(nextIndex + 1));
                    nextIndex += actions.length();
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex);
        if (!isCustomScript.booleanValue()) {
            lastStr = lastStr.replaceAll("\"", "");
        }
        value.append(lastStr);
        String ret = value.toString().trim();
        ret = FormatUtil.removeMultipleSpecialChars((String)ret);
        logger.log(Level.INFO, "Format : " + format + ", Result " + ret);
        return ret;
    }

    public static String getFormattedValue(String format, Hashtable result, String domainName, String objectClass) {
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        StringBuffer value = new StringBuffer();
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                noOfLetters = FormatUtil.getNoOfLetters((String)format, (int)nextIndex, (int)length);
                String ldapName = format.substring(index + 1, nextIndex);
                String attribValue = UserModificationFormatUtil.getAttributeValue(ldapName, domainName, result, objectClass);
                if (ldapName.equalsIgnoreCase("rand")) {
                    attribValue = FormatUtil.getRandomNumber((String)noOfLetters);
                }
                if (attribValue != null) {
                    String str;
                    if (!noOfLetters.equals("")) {
                        nextIndex += noOfLetters.length();
                    }
                    if (nextIndex + 3 < length && ("[L]".equalsIgnoreCase(str = format.substring(nextIndex + 1, nextIndex + 4)) || "[U]".equalsIgnoreCase(str))) {
                        attribValue = FormatUtil.getCaseChangedAttribValue((int)nextIndex, (String)format, (String)attribValue);
                        nextIndex += 3;
                    }
                    FormatUtil.updateBufferValue((String)noOfLetters, (StringBuffer)value, (String)attribValue);
                    prevIndex = nextIndex + 1;
                    index = format.indexOf("%", nextIndex + 1);
                    continue;
                }
                value.append(format.substring(index, nextIndex));
                prevIndex = nextIndex;
                index = format.indexOf("%", nextIndex);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex).replaceAll("\"", "");
        value.append(lastStr);
        String ret = value.toString().trim();
        ret = FormatUtil.removeMultipleSpecialChars((String)ret);
        logger.log(Level.INFO, "Format : " + format + ", Result " + ret);
        System.out.println("rettt " + ret);
        return ret;
    }

    private static String getAttributeValue(String ldapName, String domainName, Hashtable resultHash, String objectClass) {
        String attribValue = null;
        try {
            ArrayList attributeDetailsMap;
            Integer id = null;
            if ("o365user".equalsIgnoreCase(objectClass)) {
                attributeDetailsMap = ReportAttributeHandler.getInstance().getAttributes("O365UserGeneralDetails");
                Properties upn = new Properties();
                upn.put("ATTRIB_LDAP_NAME", "UPN");
                upn.put("ATTRIB_COLUMN_NAME", "UPN");
                attributeDetailsMap.add(upn);
                for (Hashtable hash : attributeDetailsMap) {
                    if (!ldapName.equalsIgnoreCase((String)hash.get("ATTRIB_LDAP_NAME"))) continue;
                    attribValue = (String)resultHash.get((String)hash.get("ATTRIB_COLUMN_NAME"));
                }
            } else if ("contact".equalsIgnoreCase(objectClass)) {
                attributeDetailsMap = ContactUserHandler.getInstance().getAttributeList();
                for (Hashtable hash : attributeDetailsMap) {
                    if (!ldapName.equalsIgnoreCase((String)hash.get("ATTRIB_LDAP_NAME"))) continue;
                    id = (Integer)hash.get("ATTRIB_ID");
                }
            } else if ("computer".equalsIgnoreCase(objectClass)) {
                attributeDetailsMap = ComputerUserHandler.getInstance().getAttributeDetailsFromDB();
                for (Hashtable hash : attributeDetailsMap) {
                    if (!ldapName.equalsIgnoreCase((String)hash.get("ATTRIB_LDAP_NAME"))) continue;
                    id = (Integer)hash.get("ATTRIB_ID");
                }
            } else {
                if ("o365UserForAD".equalsIgnoreCase(objectClass)) {
                    return (String)resultHash.get(ldapName.toLowerCase());
                }
                id = UserMgmtUtil.getAttributeId((String)ldapName);
            }
            if (id != null) {
                attribValue = FormatUtil.getValue((Hashtable)resultHash, (Integer)id);
            }
            if ((attribValue == null || attribValue.equals("")) && !objectClass.equalsIgnoreCase("o365user")) {
                if (ldapName.equalsIgnoreCase("userName") || ldapName.equalsIgnoreCase("logonName")) {
                    attribValue = FormatUtil.getValue((Hashtable)resultHash, (int)1006);
                } else if (ldapName.equalsIgnoreCase("domainName") || ldapName.equalsIgnoreCase("domainDNSName")) {
                    attribValue = DomainHandler.getDomainDNSName((String)domainName);
                } else {
                    String attribval;
                    ArrayList<String> attribList = new ArrayList<String>();
                    attribList.add(ldapName);
                    String guid = (String)resultHash.get("OBJECT_GUID");
                    guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
                    Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)1L, (String)guid, attribList);
                    ArrayList attribvallist = (ArrayList)prop.get(ldapName);
                    if (attribvallist != null && attribvallist.size() >= 1 && (attribval = (String)attribvallist.get(0)) != null && !attribval.equals("")) {
                        attribValue = attribval;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribValue;
    }

    public static void addUPNPrefixValue(Properties currentUserDetails) {
        if (currentUserDetails != null && currentUserDetails.containsKey("USER_PRINCIPAL_NAME")) {
            String upn = (String)currentUserDetails.get("USER_PRINCIPAL_NAME");
            if (upn.indexOf("@") > 0) {
                upn = upn.substring(0, upn.indexOf("@"));
            }
            currentUserDetails.put("UPN", upn);
        }
    }

    public static String getFormatValue(String domainName, String format, UserBean userBean, ArrayList customAttribList) {
        String ret = UserModificationFormatUtil.getFormatValue(domainName, format, userBean, customAttribList, false);
        return ret;
    }

    public static String getFormatValue(String domainName, String format, UserBean userBean, ArrayList customAttribList, boolean homedir) {
        int lastIndex1;
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        StringBuffer value = new StringBuffer();
        boolean validLdapName = true;
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                noOfLetters = FormatUtil.getNoOfLetters((String)format, (int)nextIndex, (int)length);
                String ldapName = format.substring(index + 1, nextIndex);
                String attribValue = UserModificationFormatUtil.getAttributeValue(ldapName, "", domainName, "", userBean, new ArrayList<Hashtable>(), customAttribList);
                if (ldapName.equalsIgnoreCase("rand")) {
                    attribValue = FormatUtil.getRandomNumber((String)noOfLetters);
                }
                if (attribValue != null) {
                    nextIndex = FormatUtil.applyFormatsToAttribute((String)format, (String)attribValue, (String)noOfLetters, (int)nextIndex, (StringBuffer)value);
                } else {
                    validLdapName = false;
                    value.append(format.substring(index, nextIndex + 1));
                    String actions = FormatUtil.getFormatActionString((String)format, (int)(nextIndex + 1));
                    nextIndex += actions.length();
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex).replaceAll("\"", "");
        value.append(lastStr);
        String s = value.toString();
        int index1 = s.indexOf("%");
        if (index1 > 0 && validLdapName && (lastIndex1 = s.indexOf("%", index1 + 1)) > 0) {
            s = UserModificationFormatUtil.getFormatValue(domainName, s, userBean, customAttribList);
        }
        String ret = s.trim();
        if (!homedir) {
            ret = FormatUtil.removeMultipleSpecialChars((String)ret);
        }
        return ret;
    }

    public static String getFormatValue(String domainName, String format, ArrayList<Hashtable> valuesList, String sAMAccountName, String userName, ArrayList customAttribList, boolean homedir) {
        int lastIndex1;
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        StringBuffer value = new StringBuffer();
        boolean validLdapName = true;
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                noOfLetters = FormatUtil.getNoOfLetters((String)format, (int)nextIndex, (int)length);
                String ldapName = format.substring(index + 1, nextIndex);
                String attribValue = UserModificationFormatUtil.getAttributeValue(ldapName, sAMAccountName, domainName, userName, null, valuesList, customAttribList);
                if (ldapName.equalsIgnoreCase("rand")) {
                    attribValue = FormatUtil.getRandomNumber((String)noOfLetters);
                }
                if (attribValue != null) {
                    nextIndex = FormatUtil.applyFormatsToAttribute((String)format, (String)attribValue, (String)noOfLetters, (int)nextIndex, (StringBuffer)value);
                } else {
                    validLdapName = false;
                    value.append(format.substring(index, nextIndex + 1));
                    String actions = FormatUtil.getFormatActionString((String)format, (int)(nextIndex + 1));
                    nextIndex += actions.length();
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex).replaceAll("\"", "");
        value.append(lastStr);
        String s = value.toString();
        int index1 = s.indexOf("%");
        if (index1 > 0 && validLdapName && (lastIndex1 = s.indexOf("%", index1 + 1)) > 0) {
            s = UserModificationFormatUtil.getFormatValue(domainName, s, valuesList, sAMAccountName, userName, customAttribList);
        }
        String ret = s.trim();
        if (!homedir) {
            ret = FormatUtil.removeMultipleSpecialChars((String)ret);
        }
        return ret;
    }

    public static String getFormatValue(String domainName, String format, ArrayList<Hashtable> valuesList, String sAMAccountName, String userName, ArrayList customAttribList) {
        String ret = UserModificationFormatUtil.getFormatValue(domainName, format, valuesList, sAMAccountName, userName, customAttribList, false);
        return ret;
    }

    private static String getAttributeValue(String ldapName, String sAMAccountName, String domainName, String userName, UserBean userBean, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> customAttribList) {
        String attribValue = null;
        try {
            if (customAttribList.size() > 0) {
                for (Hashtable hash : customAttribList) {
                    if (!hash.get("ATTRIB_LDAP_NAME").equals(ldapName)) continue;
                    attribValue = (String)hash.get("ATTRIB_VALUE");
                }
            }
            if (attribValue == null || attribValue.equals("")) {
                if (ldapName.equalsIgnoreCase("userName") || ldapName.equalsIgnoreCase("LogonName") || ldapName.equalsIgnoreCase("sAMAccountName") || ldapName.equalsIgnoreCase("userPrincipalName")) {
                    attribValue = userBean != null ? (String)userBean.get("SAM_ACCOUNT_NAME") : sAMAccountName;
                } else if (ldapName.equalsIgnoreCase("domainName") || ldapName.equalsIgnoreCase("domainDNSName")) {
                    attribValue = DomainHandler.getDomainDNSName((String)domainName);
                } else if (ldapName.equalsIgnoreCase("name") || ldapName.equalsIgnoreCase("cn")) {
                    attribValue = userName;
                } else {
                    Hashtable properties = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)ldapName);
                    if (!properties.isEmpty()) {
                        if (userBean != null) {
                            String columnString = (String)properties.get("ATTRIB_COLUMN_NAME");
                            Map map = userBean.getMap();
                            if (map.containsKey(columnString)) {
                                attribValue = userBean.get(columnString).toString();
                            }
                        } else {
                            for (Hashtable hashtable : valuesList) {
                                String ldapString = (String)hashtable.get("ATTRIB_LDAP_NAME");
                                if (!ldapString.equalsIgnoreCase(ldapName)) continue;
                                attribValue = hashtable.get("ATTRIB_VALUE").toString();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribValue;
    }
}

