/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.gpomgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtBean;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.gpomgmt.GPODbData;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class EditGPOAction
extends DispatchAction {
    static Properties domainStatus = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        if ((session = request.getSession()).getAttribute("GPOMgmtBean") == null) {
            session.setAttribute("GPOMgmtBean", (Object)new GPOMgmtBean());
        }
        GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
        Properties gpoDetails = GPOMgmtUtil.getGPODetails((String)request.getParameter("gpoGuid"));
        String domainName = gpoDetails.getProperty("domainName");
        domainStatus.remove(domainName + "_errorMsg");
        domainStatus.remove(domainName + "_error");
        domainStatus.remove(domainName + "_msg");
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"GPOADMXFileDetails"));
        sq.addSelectColumn(Column.getColumn((String)"GPOADMXFileDetails", (String)"*"));
        sq.setCriteria(new Criteria(Column.getColumn((String)"GPOADMXFileDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
        if (dataObj.isEmpty()) {
            Class<EditGPOAction> clazz = EditGPOAction.class;
            synchronized (EditGPOAction.class) {
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (dataObj.isEmpty()) {
                    domainStatus.put(domainName + "_isPopulating", (Object)true);
                    Row r = new Row("GPOADMXFileDetails");
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("STATUS", (Object)0);
                    DataObject statusDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    statusDataObj.addRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(statusDataObj);
                    GPODbDataPopulation populate = new GPODbDataPopulation(domainName, gpoMgmtBean, rb, locale);
                    Thread dataPopulation = new Thread(populate);
                    dataPopulation.start();
                    request.setAttribute("runScript", (Object)true);
                    request.setAttribute("gpoGuid", (Object)request.getParameter("gpoGuid"));
                    // ** MonitorExit[var14_14] (shouldn't be in output)
                    return mapping.findForward("editgpo");
                }
                Row r = dataObj.getFirstRow("GPOADMXFileDetails");
                if (!r.get("STATUS").equals(1)) {
                    request.setAttribute("status", (Object)"populating");
                    request.setAttribute("domainName", (Object)gpoDetails.getProperty("domainName"));
                    // ** MonitorExit[var14_14] (shouldn't be in output)
                    return mapping.findForward("editgpo");
                }
                // ** MonitorExit[var14_14] (shouldn't be in output)
            }
        } else {
            Row r = dataObj.getFirstRow("GPOADMXFileDetails");
            if (!r.get("STATUS").equals(1)) {
                request.setAttribute("status", (Object)"populating");
                request.setAttribute("domainName", (Object)gpoDetails.getProperty("domainName"));
                return mapping.findForward("editgpo");
            }
        }
        {
            Criteria crit = new Criteria(Column.getColumn((String)"GPOSettingsState", (String)"SESSION_ID"), (Object)request.getSession().getId(), 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"GPOSettingsState", (String)"OBJECT_GUID"), (Object)request.getParameter("gpoGuid"), 0));
            CommonUtil.getPersistenceNT().delete(crit);
            request.setAttribute("gpoName", (Object)gpoDetails.getProperty("displayName"));
            request.setAttribute("domainName", (Object)gpoDetails.getProperty("domainName"));
            request.setAttribute("folderId", (Object)GPOMgmtUtil.getComputerConfigFolId((String)gpoDetails.getProperty("domainName")));
            request.setAttribute("status", (Object)"success");
            this.setGpoSessionDetails(gpoMgmtBean, locale, domainName);
            return mapping.findForward("editgpo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGpoSessionDetails(GPOMgmtBean gpoMgmtBean, Locale locale, String domainName) throws Exception {
        HashMap<String, String> tableDetails = gpoMgmtBean.getGpoTableDetails(domainName);
        if (tableDetails == null) {
            GPOMgmtBean gPOMgmtBean = gpoMgmtBean;
            synchronized (gPOMgmtBean) {
                tableDetails = gpoMgmtBean.getGpoTableDetails(domainName);
                if (tableDetails == null) {
                    SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"GPOADMXFileDetails"));
                    sq.addSelectColumn(Column.getColumn((String)"GPOADMXFileDetails", (String)"*"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"GPOADMXFileDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    Row r = dataObj.getFirstRow("GPOADMXFileDetails");
                    String languages = (String)r.get("LANGUAGES");
                    String[] langs = languages.split(" ");
                    String gpoFolderNamesTable = "GPOSettingFolderDetails_" + langs[0];
                    String gpoSettingNamesTable = "GPORegSetting_" + langs[0];
                    String gpoSettingsStateConfigTable = "GPOSettingsStateConfig_" + langs[0];
                    String language = locale.getLanguage();
                    String country = locale.getCountry();
                    String strLocale = language + "_" + country;
                    String curLang = langs[0];
                    for (int l = 0; l < langs.length; ++l) {
                        String curLang2 = langs[l];
                        if (!strLocale.equalsIgnoreCase(curLang2)) continue;
                        gpoFolderNamesTable = "GPOSettingFolderDetails_" + curLang2;
                        gpoSettingNamesTable = "GPORegSetting_" + curLang2;
                        gpoSettingsStateConfigTable = "GPOSettingsStateConfig_" + curLang2;
                        curLang = curLang2;
                        break;
                    }
                    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(new Locale(curLang.substring(0, 2), curLang.substring(3, 5)));
                    GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)rb, (String)"GPOSettingsStateConfig", (String)gpoSettingsStateConfigTable);
                    tableDetails = new HashMap<String, String>();
                    tableDetails.put("GPOSettingFolderDetails", gpoFolderNamesTable);
                    tableDetails.put("GPORegSetting", gpoSettingNamesTable);
                    tableDetails.put("GPOSettingsStateConfig", gpoSettingsStateConfigTable);
                    gpoMgmtBean.setGpoTableDetails(domainName, tableDetails);
                    gpoMgmtBean.setAdmxRb(domainName, rb);
                }
            }
        }
    }

    public ActionForward getRegSettingPopulationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String domainName = request.getParameter("domainName");
            JSONObject details = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            response.setContentType("application/json");
            if (domainStatus.get(domainName + "_error") != null) {
                String errorMsg = (String)domainStatus.get(domainName + "_errorMsg");
                domainStatus.remove(domainName + "_isPopulating");
                domainStatus.remove(domainName + "_errorMsg");
                domainStatus.remove(domainName + "_error");
                domainStatus.remove(domainName + "_msg");
                details.put("isPopulatating", false);
                details.put("isError", true);
                details.put("msg", (Object)errorMsg);
                PrintWriter writer = response.getWriter();
                writer.print(details);
                return null;
            }
            String msg = domainStatus.get(domainName + "_msg") != null ? (String)domainStatus.get(domainName + "_msg") : rb.getString("admp.common.text.initializing");
            details.put("isPopulatating", domainStatus.get(domainName + "_isPopulating"));
            details.put("msg", (Object)msg);
            if (domainStatus.get(domainName + "_isPopulating") != null && !((Boolean)domainStatus.get(domainName + "_isPopulating")).booleanValue()) {
                domainStatus.remove(domainName + "_isPopulating");
                domainStatus.remove(domainName + "_msg");
            }
            details.put("isError", false);
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getRegSettingDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long regSettingId = Long.valueOf(request.getParameter("regSettingId"));
            String gpoGuid = request.getParameter("gpoGuid");
            Properties gpoDetails = GPOMgmtUtil.getGPODetails((String)gpoGuid);
            String domainName = gpoDetails.getProperty("domainName");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            AdventNetResourceBundle rb = gpoMgmtBean.getAdmxRb(domainName);
            JSONObject details = GPOMgmtUtil.getRegSettingDetails((long)regSettingId, (String)gpoGuid, (String)session.getId(), (AdventNetResourceBundle)rb, (GPOMgmtBean)gpoMgmtBean, (Long)loginId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSubFoldersAndSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long folderId = Long.valueOf(request.getParameter("folderId"));
            Properties gpoDetails = GPOMgmtUtil.getGPODetails((String)request.getParameter("gpoGuid"));
            String domainName = gpoDetails.getProperty("domainName");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            AdventNetResourceBundle rb = gpoMgmtBean.getAdmxRb(domainName);
            JSONObject details = GPOMgmtUtil.getSubFoldersAndSettings((long)folderId, (String)request.getParameter("gpoGuid"), (String)request.getParameter("viewParams"), (String)session.getId(), (AdventNetResourceBundle)rb, (GPOMgmtBean)gpoMgmtBean, (Long)loginId, (String)domainName);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateGpoRegSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            String hostId = request.getRemoteHost();
            Properties gpoDetails = GPOMgmtUtil.getGPODetails((String)request.getParameter("gpoGuid"));
            String domainName = gpoDetails.getProperty("domainName");
            AdventNetResourceBundle rb = gpoMgmtBean.getAdmxRb(domainName);
            JSONObject details = GPOMgmtUtil.updateGpoRegSetting((String)request.getParameter("gpoGuid"), (String)request.getParameter("settingDetails"), (String)session.getId(), (AdventNetResourceBundle)rb, (Long)loginId, (String)hostId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward createGPO(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String gpoName = request.getParameter("gpoName");
            String domainName = request.getParameter("domainName");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            JSONObject details = GPOMgmtUtil.createGPO((String)domainName, (Long)loginId, (String)hostId, (String)gpoName, (AdventNetResourceBundle)rb);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private class GPODbDataPopulation
    implements Runnable {
        String domainName = null;
        GPOMgmtBean gpoMgmtBean = null;
        AdventNetResourceBundle rb = null;
        Locale locale = null;

        GPODbDataPopulation(String domainName, GPOMgmtBean gpoMgmtBean, AdventNetResourceBundle rb, Locale locale) {
            this.domainName = domainName;
            this.gpoMgmtBean = gpoMgmtBean;
            this.rb = rb;
            this.locale = locale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<GPODbDataPopulation> clazz = GPODbDataPopulation.class;
            synchronized (GPODbDataPopulation.class) {
                try {
                    String sourceLocation;
                    File file;
                    String productHome = System.getProperty("product.home");
                    if (productHome == null) {
                        productHome = System.getProperty("server.home");
                    }
                    if ((file = new File(sourceLocation = productHome + File.separator + "tempGpo")).exists()) {
                        file = new File(sourceLocation = sourceLocation + File.separator + this.domainName);
                        if (file.exists()) {
                            FileUtils.cleanDirectory((File)file);
                        } else {
                            file.mkdir();
                        }
                    } else {
                        file.mkdir();
                        sourceLocation = sourceLocation + File.separator + this.domainName;
                        file = new File(sourceLocation);
                        file.mkdir();
                    }
                    SelectQueryImpl selSq = new SelectQueryImpl(Table.getTable((String)"ADSMDCConfiguration"));
                    selSq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID"));
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"OPERATING_SYSTEM"), null, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)this.domainName, 0));
                    selSq.setCriteria(crit);
                    DataObject dataOb = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selSq);
                    if (!dataOb.isEmpty()) {
                        DomainHandler.updateDCOsInfo((String)this.domainName, null);
                    }
                    domainStatus.put(this.domainName + "_msg", this.rb.getString("admp.mgmt.gpo_mgmt.checking_central_store"));
                    SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMDCConfiguration"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"OPERATING_SYSTEM"));
                    Criteria c2 = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)this.domainName, 0);
                    sq.setCriteria(c2);
                    sq.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"OPERATING_SYSTEM"), false));
                    DataObject domainControllersDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    Row r = domainControllersDataObj.getFirstRow("ADSMDCConfiguration");
                    String dcName = (String)r.get("DOMAIN_CONTROLLER_NAME");
                    String operatingSystem = (String)r.get("OPERATING_SYSTEM");
                    String location = "\\\\" + dcName + "\\SYSVOL\\" + this.domainName + "\\Policies\\PolicyDefinitions";
                    String minOs = "Windows Server 2008";
                    boolean foundAdmx = false;
                    if (ADHandler.isFolderExists((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String)location)) {
                        domainStatus.put(this.domainName + "_msg", this.rb.getString("admp.mgmt.gpo_mgmt.found_store_getting_files"));
                        ADHandlerForMgmt.moveFolder((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String)location, (String)sourceLocation);
                        foundAdmx = true;
                    } else {
                        domainStatus.put(this.domainName + "_msg", this.rb.getString("admp.mgmt.gpo_mgmt.store_not_found_checking_dcs"));
                        Iterator iter = domainControllersDataObj.getRows("ADSMDCConfiguration");
                        while (iter.hasNext()) {
                            Row curRow = (Row)iter.next();
                            String curOS = (String)curRow.get("OPERATING_SYSTEM");
                            if (curOS.compareToIgnoreCase(minOs) < 0) continue;
                            dcName = (String)curRow.get("DOMAIN_CONTROLLER_NAME");
                            operatingSystem = (String)curRow.get("OPERATING_SYSTEM");
                            location = "\\\\" + dcName + "\\C$\\Windows\\PolicyDefinitions";
                            if (!ADHandler.isFolderExists((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String)location)) continue;
                            domainStatus.put(this.domainName + "_msg", MessageFormat.format(this.rb.getString("admp.mgmt.gpo_mgmt.getting_files_from"), dcName));
                            ADHandlerForMgmt.moveFolder((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String)location, (String)sourceLocation);
                            foundAdmx = true;
                            break;
                        }
                    }
                    if (!foundAdmx) {
                        GPOMgmtUtil.clearGPOInfo((String)this.domainName);
                        String errorMsg = "No ADMX Files found!";
                        domainStatus.put(this.domainName + "_errorMsg", errorMsg);
                        domainStatus.put(this.domainName + "_error", (Object)true);
                        domainStatus.put(this.domainName + "_isPopulating", (Object)false);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    Properties details = GPODbData.populate(this.domainName, productHome, domainStatus, this.rb);
                    if (details.getProperty("status") != null && details.getProperty("status").equalsIgnoreCase("error")) {
                        GPOMgmtUtil.clearGPOInfo((String)this.domainName);
                        String errorMsg = details.getProperty("msg");
                        if (errorMsg == null) {
                            errorMsg = this.rb.getString("admp.mgmt.gpo_mgmt_some_err_occ");
                        }
                        domainStatus.put(this.domainName + "_errorMsg", errorMsg);
                        domainStatus.put(this.domainName + "_error", (Object)true);
                        domainStatus.put(this.domainName + "_isPopulating", (Object)false);
                        System.out.println("Error details: " + errorMsg);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    r = new Row("GPOADMXFileDetails");
                    r.set("DOMAIN_NAME", (Object)this.domainName);
                    r.set("STATUS", (Object)1);
                    r.set("DC_NAME", (Object)dcName);
                    r.set("PATH", (Object)location);
                    r.set("OPERATING_SYSTEM", (Object)operatingSystem);
                    ArrayList languagesAvailable = (ArrayList)details.get("langs");
                    String langStr = languagesAvailable.toString();
                    langStr = langStr.substring(1, langStr.length() - 1);
                    String[] langs = langStr.split(",");
                    StringBuilder finalLangs = new StringBuilder();
                    int i = 0;
                    for (i = 0; i < langs.length - 1; ++i) {
                        finalLangs.append(langs[i].trim() + " ");
                    }
                    if (langs.length >= 1) {
                        finalLangs.append(langs[i].trim());
                    }
                    r.set("LANGUAGES", (Object)finalLangs.toString().replace("-", "_"));
                    sq = new SelectQueryImpl(Table.getTable((String)"GPOADMXFileDetails"));
                    sq.addSelectColumn(Column.getColumn((String)"GPOADMXFileDetails", (String)"*"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"GPOADMXFileDetails", (String)"DOMAIN_NAME"), (Object)this.domainName, 0));
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    dataObj.updateRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    domainStatus.put(this.domainName + "_errorMsg", this.rb.getString("admp.mgmt.gpo_mgmt_some_err_occ") + " : " + le.getMessage(this.rb));
                    domainStatus.put(this.domainName + "_error", (Object)true);
                    try {
                        GPOMgmtUtil.clearGPOInfo((String)this.domainName);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    domainStatus.put(this.domainName + "_errorMsg", this.rb.getString("admp.mgmt.gpo_mgmt_some_err_occ") + " : " + e.getMessage());
                    domainStatus.put(this.domainName + "_error", (Object)true);
                    try {
                        GPOMgmtUtil.clearGPOInfo((String)this.domainName);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                domainStatus.put(this.domainName + "_isPopulating", (Object)false);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

