/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.gpomgmt;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.queue.QueueUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class GPODbData {
    static Properties uvhIds = new Properties();
    static XPath xpath = XPathFactory.newInstance().newXPath();
    static Properties nameSpaceVsFileNames = new Properties();
    static Properties fileNameVsNameSpaces = new Properties();
    static Properties nameSpaceVsDocElements = new Properties();
    static Properties filenameVsAdmlDocProps = new Properties();
    static String[] supportedLangs = new String[]{"en-US", "de-DE", "es-ES", "fr-FR", "it-IT", "ja-JP", "nl-nl", "zh-cn", "tr-TR"};
    static String[] langs = null;
    static Properties userFolderProps = new Properties();
    static Properties computerFolderProps = new Properties();
    static Long nextFolderId = 501L;
    static final int REG_SZ = 1;
    static final int REG_EXPAND_SZ = 2;
    static final int REG_MULTI_SZ = 7;
    static final int REG_DWORD = 4;
    static final int CONST_VAL_TYPE = 1;
    static final int COMBO_VAL_TYPE = 2;
    static final int USER_VAL_TYPE = 3;
    static final int NO_COMP = 1;
    static final int TEXT_BOX = 2;
    static final int COMBO_BOX = 3;
    static final int NO_SORT_COMBO = 4;
    static final int CHECK_BOX = 5;
    static final int NUMERICAL_TEXT_BOX = 6;
    static final int BUTTON = 7;
    static final int MULTI_TEXT_BOX = 8;
    static Properties folderNameProps = new Properties();
    static Properties regSettingHelpProps = new Properties();
    static Properties regSettingNameProps = new Properties();
    static Properties regSettingPathProps = new Properties();
    static Properties regSettingSupportedFromProps = new Properties();
    static Properties regSettingAllCompTextDetails = new Properties();
    static Properties regSettingAllCompTextDetailsEng = new Properties();
    static DataObject dataObj = null;
    static DataObject dataObjConfig = null;
    static DataObject dataObjDynaVal = null;
    static long curMaxLinesInPropFiles = -1L;
    static ArrayList<String> parentRows = null;
    static ArrayList<String> regSettingRows = null;
    static ArrayList<String> gpoRegSettingKeyRows = null;
    static ArrayList<String> regSettingKeyValNameRows = null;
    static ArrayList<String> regSettingConstValMappingRows = null;
    static ArrayList<String> regSettingUIDetailsRows = null;
    static ArrayList<String> regSettingUITextDetailsRows = null;
    static ArrayList<String> regSettingRangeCompMappingRows = null;
    static ArrayList<String> regSettingTextBoxCompDetailsRows = null;
    static ArrayList<String> regSettingCheckBoxCompDetailsRows = null;
    static ArrayList<String> regSettingListValMappingRows = null;
    static ArrayList<String> regSettingListValSubValConfigRows = null;
    static ArrayList<String> regSettingListValSubValDetailsRows = null;
    static ArrayList<String> regSettingMultiTextCompDetailsRows = null;
    static ArrayList<String> regSettingUIDynaValDetailsRows = null;
    static ArrayList<String> regSettingBoolValMappingRows = null;
    static String[] tableArrayFilesToDb = new String[]{"RegSettingKeyValName", "RegSettingUIDetails", "RegSettingUIDynaValDetails", "RegSettingUITextDetails", "RegSettingCheckBoxCompDetails", "RegSettingTextBoxCompDetails", "RegSettingMultiTextCompDetails", "RegSettingListValSubValConfig", "RegSettingListValSubValDetails", "RegSettingListValMapping", "RegSettingConstValMapping", "RegSettingRangeCompMapping", "RegSettingBoolValMapping"};
    static Properties tableVsRows = null;
    static ArrayList<String> langTables = null;
    static Properties langTablesRows = null;
    static Properties columnOrderProp = null;
    static long testCount = 0L;
    static long testCount2 = 0L;

    public static void reinit() {
        uvhIds = new Properties();
        nameSpaceVsFileNames = new Properties();
        fileNameVsNameSpaces = new Properties();
        nameSpaceVsDocElements = new Properties();
        filenameVsAdmlDocProps = new Properties();
        langs = null;
        userFolderProps = new Properties();
        computerFolderProps = new Properties();
        nextFolderId = 501L;
        folderNameProps = new Properties();
        regSettingHelpProps = new Properties();
        regSettingNameProps = new Properties();
        regSettingPathProps = new Properties();
        regSettingSupportedFromProps = new Properties();
        regSettingAllCompTextDetails = new Properties();
        regSettingAllCompTextDetailsEng = new Properties();
        dataObj = null;
        dataObjConfig = null;
        dataObjDynaVal = null;
        curMaxLinesInPropFiles = -1L;
        parentRows = new ArrayList();
        regSettingRows = new ArrayList();
        gpoRegSettingKeyRows = new ArrayList();
        regSettingKeyValNameRows = new ArrayList();
        regSettingConstValMappingRows = new ArrayList();
        regSettingUIDetailsRows = new ArrayList();
        regSettingUITextDetailsRows = new ArrayList();
        regSettingRangeCompMappingRows = new ArrayList();
        regSettingTextBoxCompDetailsRows = new ArrayList();
        regSettingCheckBoxCompDetailsRows = new ArrayList();
        regSettingListValMappingRows = new ArrayList();
        regSettingListValSubValConfigRows = new ArrayList();
        regSettingListValSubValDetailsRows = new ArrayList();
        regSettingMultiTextCompDetailsRows = new ArrayList();
        regSettingUIDynaValDetailsRows = new ArrayList();
        regSettingBoolValMappingRows = new ArrayList();
        ArrayList<ArrayList<String>> tableArrayFilesToDbList = new ArrayList<ArrayList<String>>();
        tableArrayFilesToDbList.add(regSettingKeyValNameRows);
        tableArrayFilesToDbList.add(regSettingUIDetailsRows);
        tableArrayFilesToDbList.add(regSettingUIDynaValDetailsRows);
        tableArrayFilesToDbList.add(regSettingUITextDetailsRows);
        tableArrayFilesToDbList.add(regSettingCheckBoxCompDetailsRows);
        tableArrayFilesToDbList.add(regSettingTextBoxCompDetailsRows);
        tableArrayFilesToDbList.add(regSettingMultiTextCompDetailsRows);
        tableArrayFilesToDbList.add(regSettingListValSubValConfigRows);
        tableArrayFilesToDbList.add(regSettingListValSubValDetailsRows);
        tableArrayFilesToDbList.add(regSettingListValMappingRows);
        tableArrayFilesToDbList.add(regSettingConstValMappingRows);
        tableArrayFilesToDbList.add(regSettingRangeCompMappingRows);
        tableArrayFilesToDbList.add(regSettingBoolValMappingRows);
        tableVsRows = new Properties();
        for (int c = 0; c < tableArrayFilesToDb.length; ++c) {
            String curTableName = tableArrayFilesToDb[c];
            tableVsRows.put(curTableName, tableArrayFilesToDbList.get(c));
        }
        langTables = new ArrayList();
        langTablesRows = new Properties();
        columnOrderProp = new Properties();
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("FOLDER_ID");
        cols.add("FOLDER_NAME_I18N_KEY");
        cols.add("PARENT_ID");
        cols.add("IS_MACHINE_FOLDER");
        cols.add("FOLDER_TYPE");
        cols.add("DOMAIN_NAME");
        columnOrderProp.put("GPOSettingFolderDetails", cols);
        cols = new ArrayList();
        cols.add("REG_SETTING_ID");
        cols.add("REG_SETTING_I18N_KEY");
        cols.add("PARENT_ID");
        cols.add("SUPPORTED_FROM");
        cols.add("HELP_TEXT");
        cols.add("SETTING_PATH_I18N_KEY");
        cols.add("POLICY_NAME");
        cols.add("FILE_NAME");
        columnOrderProp.put("GPORegSetting", cols);
        cols = new ArrayList();
        cols.add("REG_SETTING_KEY_ID");
        cols.add("REG_SETTING_ID");
        cols.add("KEY_PATH");
        columnOrderProp.put("GPORegSettingKey", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("REG_SETTING_KEY_ID");
        cols.add("ENABLED_VAL_NAME");
        cols.add("DISABLED_VAL_NAME");
        cols.add("ENABLED_DATA_TYPE");
        cols.add("DISABLED_DATA_TYPE");
        cols.add("VALUE_TYPE");
        cols.add("IS_DISABLED_VAL_ONLY");
        cols.add("IS_REQUIRED");
        columnOrderProp.put("RegSettingKeyValName", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("VALUE_TYPE");
        cols.add("VALUE_ID");
        columnOrderProp.put("RegSettingConstValMapping", cols);
        cols = new ArrayList();
        cols.add("REG_SETTING_ID");
        cols.add("VAL_NAME_ID");
        cols.add("PRIORITY");
        cols.add("DESCRIPTION");
        cols.add("COMPONENT_ID");
        columnOrderProp.put("RegSettingUIDetails", cols);
        cols = new ArrayList();
        cols.add("REG_SETTING_ID");
        cols.add("PRIORITY");
        cols.add("TEXT_KEY");
        columnOrderProp.put("RegSettingUITextDetails", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("CONFIG_ID");
        columnOrderProp.put("RegSettingRangeCompMapping", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("MAX_LENGTH");
        cols.add("DEFAULT_TEXT");
        columnOrderProp.put("RegSettingTextBoxCompDetails", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("IS_DEFAULT_CHECKED");
        columnOrderProp.put("RegSettingCheckBoxCompDetails", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("VALUE_ID");
        cols.add("IS_DEFAULT");
        columnOrderProp.put("RegSettingListValMapping", cols);
        cols = new ArrayList();
        cols.add("CONFIG_ID");
        cols.add("VAL_NAME_ID");
        cols.add("VALUE_ID");
        columnOrderProp.put("RegSettingListValSubValConfig", cols);
        cols = new ArrayList();
        cols.add("DETAIL_ID");
        cols.add("CONFIG_ID");
        cols.add("KEY_PATH");
        cols.add("VAL_NAME");
        cols.add("DATA_TYPE");
        cols.add("VALUE");
        columnOrderProp.put("RegSettingListValSubValDetails", cols);
        cols = new ArrayList();
        cols.add("VAL_NAME_ID");
        cols.add("MAX_LENGTH");
        cols.add("MAX_STRINGS");
        columnOrderProp.put("RegSettingMultiTextCompDetails", cols);
        cols = new ArrayList();
        cols.add("REG_SETTING_ID");
        cols.add("DYNA_VAL_ID");
        cols.add("PRIORITY");
        cols.add("DESCRIPTION");
        cols.add("COMPONENT_ID");
        columnOrderProp.put("RegSettingUIDynaValDetails", cols);
        cols = new ArrayList();
        cols.add("MAPPING_ID");
        cols.add("VAL_NAME_ID");
        cols.add("TYPE");
        cols.add("CONFIG_ID");
        columnOrderProp.put("RegSettingBoolValMapping", cols);
        testCount = 0L;
        testCount2 = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties populate(String domainName, String productHome, Properties domainStatus, AdventNetResourceBundle curRb) throws Exception {
        int l;
        int j;
        int i;
        domainStatus.put(domainName + "_msg", curRb.getString("admp.mgmt.gpo_mgmt.checking_adml_lang_files"));
        GPODbData.reinit();
        Properties returnProp = new Properties();
        dataObjDynaVal = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        String tempGpoPath = productHome + File.separator + "tempGpo" + File.separator + domainName;
        ArrayList<String> languagesAvailable = new ArrayList<String>();
        for (i = 0; i < supportedLangs.length; ++i) {
            File chkDir = new File(tempGpoPath + File.separator + supportedLangs[i]);
            if (!chkDir.exists()) continue;
            languagesAvailable.add(supportedLangs[i]);
            chkDir = new File(System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adsm" + File.separator + "gpomgmt" + File.separator + "GpoMgmtMessage_" + supportedLangs[i].substring(0, 2) + "_" + supportedLangs[i].substring(3, 5) + ".properties");
            LineNumberReader lnr = new LineNumberReader(new FileReader(chkDir));
            lnr.skip(Long.MAX_VALUE);
            if ((long)(lnr.getLineNumber() + 10) <= curMaxLinesInPropFiles) continue;
            curMaxLinesInPropFiles = lnr.getLineNumber() + 100;
        }
        if (languagesAvailable.size() == 0) {
            returnProp.put("status", "error");
            returnProp.put("msg", "no supported languages available.");
            return returnProp;
        }
        for (i = 0; i < languagesAvailable.size(); ++i) {
            String curLang = (String)languagesAvailable.get(i);
            if (!curLang.equalsIgnoreCase("en-US")) continue;
            if (i == 0) break;
            languagesAvailable.remove(i);
            languagesAvailable.add(0, "en-US");
            break;
        }
        langs = languagesAvailable.toArray(new String[0]);
        ArrayList<Properties> allProps = new ArrayList<Properties>();
        allProps.add(folderNameProps);
        allProps.add(regSettingHelpProps);
        allProps.add(regSettingNameProps);
        allProps.add(regSettingPathProps);
        allProps.add(regSettingSupportedFromProps);
        allProps.add(regSettingAllCompTextDetails);
        for (int i2 = 0; i2 < allProps.size(); ++i2) {
            Properties curProps = (Properties)allProps.get(i2);
            for (int j2 = 0; j2 < langs.length; ++j2) {
                String curLang = langs[j2];
                curProps.put(curLang, new Properties());
            }
        }
        String resourceFileName = System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adsm" + File.separator + "gpomgmt" + File.separator + "GpoMgmtMessage_" + langs[0].substring(0, 2) + "_" + langs[0].substring(3, 5) + ".properties";
        Properties pr = new Properties();
        try (FileInputStream stream = null;){
            stream = new FileInputStream(resourceFileName);
            pr.load(stream);
        }
        Set<Object> keys = pr.keySet();
        for (Object k : keys) {
            String key = (String)k;
            String val = pr.getProperty(key);
            regSettingAllCompTextDetailsEng.put(val, key);
        }
        SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"RegSettingConstValConfig"));
        selQuery.addSelectColumn(Column.getColumn((String)"RegSettingConstValConfig", (String)"*"));
        dataObjConfig = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selQuery);
        selQuery = new SelectQueryImpl(Table.getTable((String)"RegSettingListValConfig"));
        selQuery.addSelectColumn(Column.getColumn((String)"RegSettingListValConfig", (String)"*"));
        dataObjConfig.merge(CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selQuery));
        selQuery = new SelectQueryImpl(Table.getTable((String)"RegSettingRangeComponentConfig"));
        selQuery.addSelectColumn(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"*"));
        dataObjConfig.merge(CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selQuery));
        selQuery = new SelectQueryImpl(Table.getTable((String)"RegSettingBoolValConfig"));
        selQuery.addSelectColumn(Column.getColumn((String)"RegSettingBoolValConfig", (String)"*"));
        dataObjConfig.merge(CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selQuery));
        domainStatus.put(domainName + "_msg", curRb.getString("admp.mgmt.gpo_mgmt.parsing_admx_and_adml_files"));
        String[] admxFiles = GPODbData.finder(tempGpoPath, "admx");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"GPOSettingFolderDetails"));
        sq.addSelectColumn(Column.getColumn((String)"GPOSettingFolderDetails", (String)"FOLDER_ID").maximum());
        RelationalAPI relAPI = RelationalAPI.getInstance();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            if (dataSet.next() && dataSet.getValue(1) != null) {
                nextFolderId = (Long)dataSet.getValue(1) + 10L;
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
            throw throwable;
        }
        DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        Long currentCompFolId = nextFolderId;
        StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentCompFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_comp_config"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"-1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentUserFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentUserFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_user_config"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"-1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentCompPolFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentCompPolFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_policies"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentCompFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentCompAdminTempFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentCompAdminTempFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_administrative_templates"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentCompPolFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentUserPolFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentUserPolFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_policies"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentUserFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentUserAdminTempFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentUserAdminTempFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_administrative_templates"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentUserPolFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentCompAllSettingsFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentCompAllSettingsFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_all_settings"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentCompAdminTempFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        Long currentUserAllSettingsFolId = nextFolderId = Long.valueOf(nextFolderId + 1L);
        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)currentUserAllSettingsFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"admp.mgmt.gpo_mgmt.folder_name_all_settings"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)currentUserAdminTempFolId.toString()));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
        parentRows.add(tableString.toString());
        nextFolderId = nextFolderId + 1L;
        for (int i3 = 0; i3 < admxFiles.length; ++i3) {
            File curFile = new File(tempGpoPath + File.separator + admxFiles[i3]);
            Document dom = null;
            try {
                dom = db.parse(curFile);
            }
            catch (SAXParseException se) {
                String eFile = curFile.getName();
                File tempFile = new File(tempGpoPath + File.separator + "temp_" + admxFiles[i3] + "s");
                curFile.renameTo(tempFile);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "unicode"));
                String str = in.readLine();
                String totStr = "";
                while ((str = in.readLine()) != null) {
                    totStr = totStr + str;
                    totStr = totStr + "\n";
                }
                File newFile = new File(tempGpoPath + File.separator + admxFiles[i3]);
                newFile.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(newFile));
                String[] buf = totStr.split("\n");
                for (int it = 0; it < buf.length; ++it) {
                    bw.write(buf[it]);
                    if (i3 == buf.length - 1) continue;
                    bw.newLine();
                }
                bw.flush();
                bw.close();
                dom = db.parse(newFile);
                in.close();
                tempFile.delete();
            }
            Element doc = dom.getDocumentElement();
            NodeList polNameSpacesNL = doc.getElementsByTagName("policyNamespaces");
            Element polNameSpaceElem = (Element)polNameSpacesNL.item(0);
            NodeList targetNL = polNameSpaceElem.getElementsByTagName("target");
            Element targetElem = (Element)targetNL.item(0);
            String filename = curFile.getName();
            String namespaceAttr = targetElem.getAttribute("namespace");
            if (nameSpaceVsFileNames.containsKey(namespaceAttr)) {
                System.out.println("Error: namespaceAttr: " + namespaceAttr + " is already defined. Old val is: " + nameSpaceVsFileNames.get(namespaceAttr));
                returnProp.put("status", "error");
                returnProp.put("msg", namespaceAttr + " is already defined.");
                return returnProp;
            }
            nameSpaceVsFileNames.put(namespaceAttr, filename);
            fileNameVsNameSpaces.put(filename, namespaceAttr);
            nameSpaceVsDocElements.put(namespaceAttr, doc);
            Properties admlDocProps = new Properties();
            filenameVsAdmlDocProps.put(filename, admlDocProps);
            for (j = 0; j < langs.length; ++j) {
                String finalLang = langs[j];
                File admlFile = new File(tempGpoPath + File.separator + finalLang + File.separator + filename.split("[.]")[0] + ".adml");
                if (!admlFile.exists()) {
                    System.out.println("Error admlfile not present for " + filename + ": for lang: " + langs[j] + ", hence trying to use another lang file...");
                    boolean foundAdml = false;
                    for (int z = 0; z < langs.length; ++z) {
                        String curLang = langs[z];
                        admlFile = new File(tempGpoPath + File.separator + curLang + File.separator + filename.split("[.]")[0] + ".adml");
                        if (!admlFile.exists()) continue;
                        foundAdml = true;
                        finalLang = curLang;
                        break;
                    }
                    if (!foundAdml) {
                        System.out.println("Error: admlfile not present for " + filename + " for any languages..");
                        returnProp.put("status", "error");
                        returnProp.put("msg", "Error: admlfile not present for " + filename + " for any languages..");
                        return returnProp;
                    }
                }
                admlFile = new File(tempGpoPath + File.separator + finalLang + File.separator + filename.split("[.]")[0] + ".adml");
                dom = db.parse(tempGpoPath + File.separator + finalLang + File.separator + admlFile.getName());
                doc = dom.getDocumentElement();
                admlDocProps.put(langs[j], doc);
            }
        }
        String[] types = new String[]{"Machine", "User"};
        boolean supportKeyNum = false;
        domainStatus.put(domainName + "_msg", curRb.getString("admp.mgmt.gpo_mgmt.getting_reg_settings_from_admx_adml_files"));
        for (int curType = 0; curType < 2; ++curType) {
            for (int i4 = 0; i4 < admxFiles.length; ++i4) {
                File curFile = new File(tempGpoPath + File.separator + admxFiles[i4]);
                String curFileName = curFile.getName();
                String curNameSpaceAttr = (String)fileNameVsNameSpaces.get(curFileName);
                Element curDocElement = (Element)nameSpaceVsDocElements.get(curNameSpaceAttr);
                NodeList policyElements = curDocElement.getElementsByTagName("policy");
                String onlyFileName = curFileName.substring(0, curFileName.indexOf("."));
                Properties curAdmlDocProps = (Properties)filenameVsAdmlDocProps.get(curFileName);
                for (j = 0; j < policyElements.getLength(); ++j) {
                    Element defElement;
                    Element curPolElem = (Element)policyElements.item(j);
                    String classAttr = curPolElem.getAttribute("class");
                    ++testCount2;
                    if (!classAttr.equalsIgnoreCase(types[curType]) && !classAttr.equalsIgnoreCase("Both")) continue;
                    ++testCount;
                    Long curUvhId = GPODbData.getUvhid("GPORegSetting", "REG_SETTING_ID");
                    String polName = curPolElem.getAttribute("name");
                    String displayName = curPolElem.getAttribute("displayName");
                    String explainText = curPolElem.getAttribute("explainText");
                    String presentation = curPolElem.getAttribute("presentation");
                    String rootKey = curPolElem.getAttribute("key");
                    displayName = displayName.substring(displayName.indexOf(".") + 1, displayName.length() - 1);
                    if (!explainText.equals("")) {
                        explainText = explainText.substring(explainText.indexOf(".") + 1, explainText.length() - 1);
                    }
                    if (!presentation.equals("")) {
                        presentation = presentation.substring(presentation.indexOf(".") + 1, presentation.length() - 1);
                    }
                    String i18nDisplayName = "admp.gpo_mgmt.reg_setting.display_name." + polName + "_" + onlyFileName + "_" + ++curMaxLinesInPropFiles;
                    for (int z = 0; z < langs.length; ++z) {
                        String curLang = langs[z];
                        Element curLangDocElement = (Element)curAdmlDocProps.get(curLang);
                        String displayNameStr = (String)xpath.evaluate("/policyDefinitionResources/resources/stringTable/string[@id='" + displayName + "']", curLangDocElement, XPathConstants.STRING);
                        if (z == 0) {
                            if (regSettingAllCompTextDetailsEng.get(displayNameStr) != null) {
                                i18nDisplayName = regSettingAllCompTextDetailsEng.getProperty(displayNameStr);
                                --curMaxLinesInPropFiles;
                                break;
                            }
                            regSettingAllCompTextDetailsEng.put(displayNameStr, i18nDisplayName);
                        }
                        Properties curLangPropKeys = (Properties)regSettingNameProps.get(curLang);
                        curLangPropKeys.put(i18nDisplayName, displayNameStr);
                    }
                    Element supportedOnElem = (Element)curPolElem.getElementsByTagName("supportedOn").item(0);
                    String refAttr = supportedOnElem.getAttribute("ref");
                    Element supportAdmxDocElem = curDocElement;
                    String supportAdmxFileName = curFileName;
                    String supportInfo = refAttr;
                    if (refAttr.contains(":")) {
                        String supportPrefix = refAttr.substring(0, refAttr.indexOf(":"));
                        supportInfo = refAttr.substring(refAttr.indexOf(":") + 1).trim();
                        Element usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/using[@prefix='" + supportPrefix + "']", curDocElement, XPathConstants.NODE);
                        if (usingElement == null) {
                            usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/target[@prefix='" + supportPrefix + "']", curDocElement, XPathConstants.NODE);
                        }
                        String supportNameSpace = usingElement.getAttribute("namespace");
                        supportAdmxFileName = (String)nameSpaceVsFileNames.get(supportNameSpace);
                        supportAdmxDocElem = (Element)nameSpaceVsDocElements.get(supportNameSpace);
                    }
                    if ((defElement = (Element)xpath.compile("//definition[@name='" + supportInfo + "']").evaluate(supportAdmxDocElem, XPathConstants.NODE)) == null && (defElement = (Element)xpath.compile("//minorVersion[@name='" + supportInfo + "']").evaluate(supportAdmxDocElem, XPathConstants.NODE)) == null && (defElement = (Element)xpath.compile("//majorVersion[@name='" + supportInfo + "']").evaluate(supportAdmxDocElem, XPathConstants.NODE)) == null) {
                        defElement = (Element)xpath.compile("//product[@name='" + supportInfo + "']").evaluate(supportAdmxDocElem, XPathConstants.NODE);
                    }
                    String i18nSupportedOn = "";
                    if (defElement == null) {
                        if ("SUPPORTED_FALSE".equalsIgnoreCase(supportInfo)) {
                            i18nSupportedOn = "-";
                        } else {
                            System.out.println("defElement missing... supportInfo: " + supportInfo + "  filename: " + curFileName + " polName: " + polName);
                            i18nSupportedOn = supportInfo;
                        }
                    } else {
                        String supportDispName = defElement.getAttribute("displayName");
                        supportDispName = supportDispName.substring(supportDispName.indexOf(".") + 1, supportDispName.length() - 1);
                        i18nSupportedOn = "admp.gpo_mgmt.reg_setting.supportinfo." + supportDispName + "_" + ++curMaxLinesInPropFiles;
                        Properties supportAdmlDocProps = (Properties)filenameVsAdmlDocProps.get(supportAdmxFileName);
                        for (int z = 0; z < langs.length; ++z) {
                            String curLang = langs[z];
                            Element curLangDocElement = (Element)supportAdmlDocProps.get(curLang);
                            String supportedOnStr = (String)xpath.evaluate("/policyDefinitionResources/resources/stringTable/string[@id='" + supportDispName + "']", curLangDocElement, XPathConstants.STRING);
                            if (z == 0) {
                                if (regSettingAllCompTextDetailsEng.get(supportedOnStr) != null) {
                                    i18nSupportedOn = regSettingAllCompTextDetailsEng.getProperty(supportedOnStr);
                                    --curMaxLinesInPropFiles;
                                    break;
                                }
                                regSettingAllCompTextDetailsEng.put(supportedOnStr, i18nSupportedOn);
                            }
                            Properties curLangPropKeys = (Properties)regSettingSupportedFromProps.get(curLang);
                            curLangPropKeys.put(i18nSupportedOn, supportedOnStr);
                        }
                    }
                    String i18nExplainText = null;
                    if (!explainText.equals("")) {
                        i18nExplainText = "admp.gpo_mgmt.reg_setting.help_text." + polName + "_" + onlyFileName + "_" + ++curMaxLinesInPropFiles;
                        for (int z = 0; z < langs.length; ++z) {
                            String curLang = langs[z];
                            Element curLangDocElement = (Element)curAdmlDocProps.get(curLang);
                            String explainTextStr = (String)xpath.evaluate("/policyDefinitionResources/resources/stringTable/string[@id='" + explainText + "']", curLangDocElement, XPathConstants.STRING);
                            explainTextStr = explainTextStr.replace("\n", "<br/>");
                            if (z == 0) {
                                if (regSettingAllCompTextDetailsEng.get(explainTextStr) != null) {
                                    i18nExplainText = regSettingAllCompTextDetailsEng.getProperty(explainTextStr);
                                    --curMaxLinesInPropFiles;
                                    break;
                                }
                                regSettingAllCompTextDetailsEng.put(explainTextStr, i18nExplainText);
                            }
                            Properties curLangPropKeys = (Properties)regSettingHelpProps.get(curLang);
                            curLangPropKeys.put(i18nExplainText, explainTextStr);
                        }
                    }
                    Element parentCategoryElem = (Element)curPolElem.getElementsByTagName("parentCategory").item(0);
                    String parRefAttr = parentCategoryElem.getAttribute("ref");
                    Element catDocElem = curDocElement;
                    String catFileName = curFileName;
                    String parInfo = parRefAttr;
                    Element catElem = null;
                    if (parRefAttr.contains(":")) {
                        String parPrefix = parRefAttr.substring(0, parRefAttr.indexOf(":"));
                        parInfo = parRefAttr.substring(parRefAttr.indexOf(":") + 1).trim();
                        Element usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/using[@prefix='" + parPrefix + "']", curDocElement, XPathConstants.NODE);
                        if (usingElement == null) {
                            usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/target[@prefix='" + parPrefix + "']", curDocElement, XPathConstants.NODE);
                        }
                        String parNameSpace = usingElement.getAttribute("namespace");
                        catFileName = (String)nameSpaceVsFileNames.get(parNameSpace);
                        catDocElem = (Element)nameSpaceVsDocElements.get(parNameSpace);
                    }
                    catElem = (Element)xpath.evaluate("//category[@name='" + parInfo + "']", catDocElem, XPathConstants.NODE);
                    Properties parentDetails = GPODbData.getParentDetails(catElem, catFileName, catDocElem, types[curType], currentCompAdminTempFolId, currentUserAdminTempFolId, domainName);
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curUvhId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)i18nDisplayName));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)((Long)parentDetails.get("id")).toString()));
                    if (i18nSupportedOn != null && i18nSupportedOn.length() > 0) {
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)i18nSupportedOn));
                    } else {
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"-"));
                    }
                    if (i18nExplainText != null && i18nExplainText.length() > 0) {
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)i18nExplainText));
                    } else {
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"-"));
                    }
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)((String)parentDetails.get("i18nKeyPath"))));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)polName));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curFileName));
                    regSettingRows.add(tableString.toString());
                }
            }
        }
        System.out.println("finished processing admx and adml files..");
        GPODbData.writeFromFileToDB(parentRows, tempGpoPath + File.separator + "GPOSettingFolderDetails.txt", "GPOSettingFolderDetails", (List)columnOrderProp.get("GPOSettingFolderDetails"));
        GPODbData.writeFromFileToDB(regSettingRows, tempGpoPath + File.separator + "GPORegSetting.txt", "GPORegSetting", (List)columnOrderProp.get("GPORegSetting"));
        regSettingRows = null;
        parentRows = null;
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)"GPOSettingFolderDetails"));
        subQuery.addSelectColumn(Column.getColumn((String)"GPOSettingFolderDetails", (String)"FOLDER_ID"));
        subQuery.setCriteria(new Criteria(Column.getColumn((String)"GPOSettingFolderDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DerivedColumn subQueryResCol = new DerivedColumn("GPOSettingFolderDetails", (SelectQuery)subQuery);
        sq = new SelectQueryImpl(Table.getTable((String)"GPORegSetting"));
        sq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"REG_SETTING_ID"));
        sq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"FILE_NAME"));
        sq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"POLICY_NAME"));
        Criteria regSettingCrit = new Criteria(Column.getColumn((String)"GPORegSetting", (String)"PARENT_ID"), (Object)subQueryResCol, 8);
        sq.setCriteria(regSettingCrit);
        sq.addSortColumn(new SortColumn("GPORegSetting", "REG_SETTING_ID", true));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
        Iterator gpoRegSettingsIter = dataObj.getRows("GPORegSetting");
        while (gpoRegSettingsIter.hasNext()) {
            Row curGpoRegSettingRow = (Row)gpoRegSettingsIter.next();
            Long curRegSettingUvhId = (Long)curGpoRegSettingRow.get("REG_SETTING_ID");
            String curRegSettingFileName = (String)curGpoRegSettingRow.get("FILE_NAME");
            String curRegSettingPolName = (String)curGpoRegSettingRow.get("POLICY_NAME");
            domainStatus.put(domainName + "_msg", MessageFormat.format(curRb.getString("admp.mgmt.gpo_mgmt.checking_policy_name"), curRegSettingPolName));
            String nameSpace = (String)fileNameVsNameSpaces.get(curRegSettingFileName);
            Element curRegSettingDocElem = (Element)nameSpaceVsDocElements.get(nameSpace);
            Element curPolElem = (Element)xpath.evaluate("//policy[@name='" + curRegSettingPolName + "']", curRegSettingDocElem, XPathConstants.NODE);
            String mainRegKey = curPolElem.getAttribute("key");
            String mainValueName = curPolElem.getAttribute("valueName");
            String onlyFileName = curRegSettingFileName.substring(0, curRegSettingFileName.indexOf("."));
            ArrayList<String> processedValNames = new ArrayList<String>();
            Properties curSettingRegKeysVsIds = new Properties();
            int uiPriority = 0;
            NodeList enabledValueNL = curPolElem.getElementsByTagName("enabledValue");
            NodeList disabledValueNL = curPolElem.getElementsByTagName("disabledValue");
            if (enabledValueNL.getLength() == 1) {
                Long curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(mainRegKey);
                if (curRegKeyUvhId == null) {
                    curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)mainRegKey));
                    gpoRegSettingKeyRows.add(tableString.toString());
                    curSettingRegKeysVsIds.put(mainRegKey, curRegKeyUvhId);
                }
                Element enabledValElement = (Element)enabledValueNL.item(0);
                Element disabledValElement = null;
                String disabledValName = "**del." + mainValueName;
                int disabledDataType = 1;
                String disabledValue = " ";
                String enabledValName = mainValueName;
                int valueType = 1;
                int enabledDataType = 4;
                String enabledValue = null;
                NodeList childEnabledValElemNL = enabledValElement.getElementsByTagName("string");
                if (childEnabledValElemNL.getLength() == 1) {
                    enabledDataType = 1;
                    enabledValue = ((Element)childEnabledValElemNL.item(0)).getTextContent();
                } else {
                    childEnabledValElemNL = enabledValElement.getElementsByTagName("decimal");
                    if (childEnabledValElemNL.getLength() == 1) {
                        enabledDataType = 4;
                        enabledValue = ((Element)childEnabledValElemNL.item(0)).getAttribute("value");
                    } else {
                        childEnabledValElemNL = enabledValElement.getElementsByTagName("delete");
                        if (childEnabledValElemNL.getLength() == 1) {
                            enabledDataType = 1;
                            enabledValue = " ";
                            enabledValName = "**del." + mainValueName;
                        } else {
                            System.out.println("ERROR: Unhandled data type found for enabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                            returnProp.put("status", "error");
                            returnProp.put("msg", "ERROR: Unhandled data type found for enabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                            return returnProp;
                        }
                    }
                }
                if (disabledValueNL.getLength() == 1) {
                    disabledValElement = (Element)disabledValueNL.item(0);
                    disabledValName = mainValueName;
                    NodeList childDisabledValElemNL = disabledValElement.getElementsByTagName("decimal");
                    Element childDisabledValElem = null;
                    if (childDisabledValElemNL.getLength() == 1) {
                        disabledDataType = 4;
                        childDisabledValElem = (Element)childDisabledValElemNL.item(0);
                        disabledValue = childDisabledValElem.getAttribute("value");
                    } else {
                        childDisabledValElemNL = disabledValElement.getElementsByTagName("string");
                        if (childDisabledValElemNL.getLength() == 1) {
                            disabledDataType = 1;
                            childDisabledValElem = (Element)childDisabledValElemNL.item(0);
                            disabledValue = childDisabledValElem.getTextContent();
                        } else {
                            childDisabledValElemNL = disabledValElement.getElementsByTagName("delete");
                            if (childDisabledValElemNL.getLength() == 1) {
                                disabledDataType = 1;
                                disabledValue = " ";
                            } else {
                                System.out.println("ERROR: Unhandled data type found for disabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "ERROR: Unhandled data type found for disabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                        }
                    }
                }
                Long enabledValId = GPODbData.getConstValId(enabledValue);
                Long disabledValId = GPODbData.getConstValId(disabledValue);
                Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                if (enabledValName.length() == 0) {
                    enabledValName = " ";
                }
                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                regSettingKeyValNameRows.add(tableString.toString());
                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValId));
                regSettingConstValMappingRows.add(tableString.toString());
                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValId));
                regSettingConstValMappingRows.add(tableString.toString());
                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)""));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                regSettingUIDetailsRows.add(tableString.toString());
                processedValNames.add(enabledValName);
            } else if (disabledValueNL.getLength() == 1) {
                System.out.println("ERROR: Unhandled scenario. Only disabledValue is present without enabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                returnProp.put("status", "error");
                returnProp.put("msg", "ERROR: Unhandled scenario. Only disabledValue is present without enabledValue. Policy Name: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                return returnProp;
            }
            NodeList enabledListNL = curPolElem.getElementsByTagName("enabledList");
            NodeList disabledListNL = curPolElem.getElementsByTagName("disabledList");
            if (disabledListNL.getLength() == 1 && enabledListNL.getLength() == 0) {
                boolean dummy = false;
            } else if (enabledListNL.getLength() == 1) {
                Long enabledValId;
                int j3;
                ArrayList<String> processedDisabItemValNames = new ArrayList<String>();
                Element enabledListElem = (Element)enabledListNL.item(0);
                NodeList enabItemListNL = enabledListElem.getElementsByTagName("item");
                Element disabledListElem = null;
                NodeList disabItemListNL = null;
                String enabledListDefaultKey = enabledListElem.getAttribute("defaultKey");
                String disabledListDefaultKey = "";
                if (disabledListNL.getLength() == 1) {
                    disabledListElem = (Element)disabledListNL.item(0);
                    disabItemListNL = disabledListElem.getElementsByTagName("item");
                    disabledListDefaultKey = disabledListElem.getAttribute("defaultKey");
                }
                for (j3 = 0; j3 < enabItemListNL.getLength(); ++j3) {
                    Long curRegKeyUvhId;
                    int enabledDataType;
                    Element curEnabItem = (Element)enabItemListNL.item(j3);
                    String enabledValName = curEnabItem.getAttribute("valueName");
                    processedValNames.add(enabledValName);
                    String enabledRegKey = curEnabItem.getAttribute("key");
                    boolean enabledListDefaultKeyUsed = false;
                    if (enabledRegKey.length() == 0) {
                        enabledRegKey = enabledListDefaultKey;
                        enabledListDefaultKeyUsed = true;
                    }
                    NodeList enabValList = curEnabItem.getElementsByTagName("value");
                    Element enabValElem = (Element)enabValList.item(0);
                    NodeList decimalValNL = enabValElem.getElementsByTagName("decimal");
                    NodeList stringValNL = enabValElem.getElementsByTagName("string");
                    String enabledValue = null;
                    if (decimalValNL.getLength() > 0) {
                        enabledDataType = 4;
                        enabledValue = ((Element)decimalValNL.item(0)).getAttribute("value");
                    } else if (stringValNL.getLength() > 0) {
                        enabledDataType = 1;
                        Element strElem = (Element)stringValNL.item(0);
                        enabledValue = strElem.getTextContent();
                    } else {
                        System.out.println("Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                        returnProp.put("status", "error");
                        returnProp.put("msg", "Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                        return returnProp;
                    }
                    String disabledValName = "**del." + enabledValName;
                    int disabledDataType = 1;
                    String disabledValue = " ";
                    if (disabledListElem != null) {
                        Element disabledItem = (Element)xpath.evaluate("item[@key='" + enabledRegKey + "' and @valueName='" + enabledValName + "']", disabledListElem, XPathConstants.NODE);
                        if (enabledListDefaultKeyUsed && disabledItem == null) {
                            disabledItem = (Element)xpath.evaluate("item[not(@key) and @valueName='" + enabledValName + "']", disabledListElem, XPathConstants.NODE);
                        }
                        if (disabledItem != null) {
                            processedDisabItemValNames.add(enabledRegKey + enabledValName);
                            disabledValName = enabledValName;
                            NodeList decimalNL = disabledItem.getElementsByTagName("decimal");
                            NodeList stringNL = disabledItem.getElementsByTagName("string");
                            NodeList deleteNL = disabledItem.getElementsByTagName("delete");
                            if (decimalNL.getLength() > 0) {
                                disabledDataType = 4;
                                disabledValue = ((Element)decimalNL.item(0)).getAttribute("value");
                            } else if (stringNL.getLength() > 0) {
                                disabledDataType = 1;
                                Element strElem = (Element)stringNL.item(0);
                                disabledValue = strElem.getTextContent();
                            } else if (deleteNL.getLength() > 0) {
                                disabledValName = "**del." + enabledValName;
                                disabledDataType = 1;
                                disabledValue = " ";
                            } else {
                                System.out.println("Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                        }
                    }
                    if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(enabledRegKey)) == null) {
                        curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledRegKey));
                        gpoRegSettingKeyRows.add(tableString.toString());
                        curSettingRegKeysVsIds.put(enabledRegKey, curRegKeyUvhId);
                    }
                    enabledValId = GPODbData.getConstValId(enabledValue);
                    Long disabledValId = GPODbData.getConstValId(disabledValue);
                    int valueType = 1;
                    Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                    regSettingKeyValNameRows.add(tableString.toString());
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValId));
                    regSettingConstValMappingRows.add(tableString.toString());
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValId));
                    regSettingConstValMappingRows.add(tableString.toString());
                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)""));
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                    regSettingUIDetailsRows.add(tableString.toString());
                }
                if (disabledListNL.getLength() == 1) {
                    for (j3 = 0; j3 < disabItemListNL.getLength(); ++j3) {
                        Long disabledValId;
                        int disabledDataType;
                        Element curItem = (Element)disabItemListNL.item(j3);
                        String disabledValName = curItem.getAttribute("valueName");
                        String regKey = curItem.getAttribute("key");
                        if (regKey.length() == 0) {
                            regKey = disabledListDefaultKey;
                        }
                        if (processedDisabItemValNames.contains(regKey + disabledValName)) continue;
                        String enabledValName = "NoValName";
                        int enabledDataType = -1;
                        String enabledValue = " ";
                        String disabledValue = null;
                        NodeList disabValueNL = curItem.getElementsByTagName("value");
                        Element disabValElem = (Element)disabValueNL.item(0);
                        NodeList decimalValNL = disabValElem.getElementsByTagName("decimal");
                        NodeList stringValNL = disabValElem.getElementsByTagName("string");
                        if (decimalValNL.getLength() > 0) {
                            disabledDataType = 4;
                            disabledValue = ((Element)decimalValNL.item(0)).getAttribute("value");
                        } else if (stringValNL.getLength() > 0) {
                            disabledDataType = 1;
                            Element strElem = (Element)stringValNL.item(0);
                            disabledValue = strElem.getTextContent();
                        } else {
                            System.out.println("Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                            returnProp.put("status", "error");
                            returnProp.put("msg", "Unknown type child. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                            return returnProp;
                        }
                        Long curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(regKey);
                        if (curRegKeyUvhId == null) {
                            curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)regKey));
                            gpoRegSettingKeyRows.add(tableString.toString());
                            curSettingRegKeysVsIds.put(regKey, curRegKeyUvhId);
                        }
                        enabledValId = disabledValId = GPODbData.getConstValId(disabledValue);
                        int valueType = 1;
                        Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                        regSettingKeyValNameRows.add(tableString.toString());
                        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValId));
                        regSettingConstValMappingRows.add(tableString.toString());
                        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValId));
                        regSettingConstValMappingRows.add(tableString.toString());
                        tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)""));
                        tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                        regSettingUIDetailsRows.add(tableString.toString());
                    }
                }
            }
            NodeList elementsNL = curPolElem.getElementsByTagName("elements");
            if (elementsNL.getLength() == 1) {
                Element elementsElem = (Element)elementsNL.item(0);
                String presentation = curPolElem.getAttribute("presentation");
                presentation = presentation.substring(presentation.indexOf(".") + 1, presentation.length() - 1);
                Properties admlDocProps = (Properties)filenameVsAdmlDocProps.get(curRegSettingFileName);
                Element engLangDocElement = (Element)admlDocProps.get(langs[0]);
                Element engPresentationElem = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", engLangDocElement, XPathConstants.NODE);
                if (engPresentationElem == null) {
                    System.out.println("unexpected scenario... presentation element is missing for polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                    returnProp.put("status", "error");
                    returnProp.put("msg", "unexpected scenario... presentation element is missing for polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                    return returnProp;
                }
                int presentationCounter = 0;
                int textPresentationElementCounter = 0;
                Node childPreElem = engPresentationElem.getFirstChild();
                while (true) {
                    if (childPreElem.getNodeType() == 1) {
                        String curLangDesc;
                        Element curLangPresentationElem;
                        Properties curLangProps;
                        String description;
                        String textKeyDescription;
                        Element curPresentationElem = (Element)childPreElem;
                        String tagName = curPresentationElem.getTagName();
                        if (tagName.equalsIgnoreCase("text")) {
                            ++textPresentationElementCounter;
                            String textKey = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + ++presentationCounter + "_" + ++curMaxLinesInPropFiles;
                            String text = curPresentationElem.getTextContent();
                            if (text == null || text.trim().length() == 0) {
                                textKey = "";
                            }
                            if (textKey.length() > 0) {
                                boolean isExistingValue;
                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(text) != null;
                                if (isExistingValue) {
                                    textKey = regSettingAllCompTextDetailsEng.getProperty(text);
                                    --curMaxLinesInPropFiles;
                                } else {
                                    regSettingAllCompTextDetailsEng.put(text, textKey);
                                    for (int z = 0; z < langs.length; ++z) {
                                        String curLang = langs[z];
                                        Properties curLangProps2 = (Properties)regSettingAllCompTextDetails.get(curLang);
                                        Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                        Element curLangPresentationElem2 = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                        Node curLangTextElem = null;
                                        if (curLangPresentationElem2 == null) {
                                            System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            curLangPresentationElem2 = engPresentationElem;
                                        }
                                        Node curNode = curLangPresentationElem2.getFirstChild();
                                        int curLangTextPresentationElementCounter = 0;
                                        while (true) {
                                            Element curElem;
                                            String curTagName;
                                            if (curNode.getNodeType() == 1 && (curTagName = (curElem = (Element)curNode).getTagName()).equalsIgnoreCase("text") && ++curLangTextPresentationElementCounter == textPresentationElementCounter) {
                                                curLangTextElem = curElem;
                                                break;
                                            }
                                            if (curNode.getNextSibling() == null) break;
                                            curNode = curNode.getNextSibling();
                                        }
                                        if (curLangTextElem == null) {
                                            System.out.println("unexpected scenario... no corresponding text element present in adml for polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName + " and current lang: " + curLang);
                                            returnProp.put("status", "error");
                                            returnProp.put("msg", "unexpected scenario... no corresponding text element present in adml for polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName + " and current lang: " + curLang);
                                            return returnProp;
                                        }
                                        String curLangText = curLangTextElem.getTextContent();
                                        curLangProps2.put(textKey, curLangText);
                                    }
                                }
                            } else {
                                --curMaxLinesInPropFiles;
                            }
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKey));
                            regSettingUITextDetailsRows.add(tableString.toString());
                        } else if (tagName.equalsIgnoreCase("decimalTextBox")) {
                            Long curRegKeyUvhId;
                            ++presentationCounter;
                            String id = curPresentationElem.getAttribute("refId");
                            Element decimalElem = (Element)xpath.evaluate(".//decimal[@id='" + id + "']", curPolElem, XPathConstants.NODE);
                            String curRegKey = decimalElem.getAttribute("key");
                            if (curRegKey.length() == 0) {
                                curRegKey = mainRegKey;
                            }
                            String enabledValName = decimalElem.getAttribute("valueName");
                            processedValNames.add(enabledValName);
                            if (enabledValName.length() == 0) {
                                System.out.println("valueName of decimal is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "valueName of decimal is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                            int enabledDataType = 4;
                            String storeAsText = decimalElem.getAttribute("storeAsText");
                            if (storeAsText.equalsIgnoreCase("true")) {
                                enabledDataType = 1;
                            }
                            String disabledValName = "**del." + enabledValName;
                            int disabledDataType = 1;
                            int valueType = 3;
                            String isRequired = "0";
                            if (decimalElem.getAttribute("required").equalsIgnoreCase("true")) {
                                isRequired = "1";
                            }
                            String minValue = "0";
                            String maxValue = "9999";
                            if (decimalElem.getAttribute("minValue").length() > 0) {
                                minValue = decimalElem.getAttribute("minValue");
                            }
                            if (decimalElem.getAttribute("maxValue").length() > 0) {
                                maxValue = decimalElem.getAttribute("maxValue");
                            }
                            if (decimalElem.getAttribute("soft").length() > 0) {
                                System.out.println("!!!!!!!!!!!soft attribute of decimal element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "!!!!!!!!!!!soft attribute of decimal element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                            String defaultValue = "1";
                            String isSpinVisible = "true";
                            String spinStep = "1";
                            textKeyDescription = "";
                            description = curPresentationElem.getTextContent();
                            if (description == null || description.length() == 0) {
                                boolean dummy = false;
                            }
                            if (curPresentationElem.getAttribute("defaultValue").length() > 0) {
                                defaultValue = curPresentationElem.getAttribute("defaultValue");
                            }
                            if (curPresentationElem.getAttribute("spin").length() > 0) {
                                isSpinVisible = curPresentationElem.getAttribute("spin");
                            }
                            if (curPresentationElem.getAttribute("spinStep").length() > 0) {
                                spinStep = curPresentationElem.getAttribute("spinStep");
                            }
                            if (description.length() > 0) {
                                boolean isExistingValue;
                                textKeyDescription = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description) != null;
                                if (isExistingValue) {
                                    textKeyDescription = regSettingAllCompTextDetailsEng.getProperty(description);
                                    --curMaxLinesInPropFiles;
                                } else {
                                    regSettingAllCompTextDetailsEng.put(description, textKeyDescription);
                                    for (int z = 0; z < langs.length; ++z) {
                                        Element curLangDecimalTextBoxElem;
                                        String curLang = langs[z];
                                        curLangProps = (Properties)regSettingAllCompTextDetails.get(curLang);
                                        Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                        curLangPresentationElem = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                        if (curLangPresentationElem == null) {
                                            System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            curLangPresentationElem = engPresentationElem;
                                        }
                                        if ((curLangDesc = (curLangDecimalTextBoxElem = (Element)xpath.evaluate("decimalTextBox[@refId='" + id + "']", curLangPresentationElem, XPathConstants.NODE)).getTextContent()) == null || curLangDesc.length() == 0) {
                                            boolean dummy = false;
                                        }
                                        curLangProps.put(textKeyDescription, curLangDesc);
                                    }
                                }
                            }
                            if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey)) == null) {
                                curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                gpoRegSettingKeyRows.add(tableString.toString());
                                curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                            }
                            Long rangeConfigId = GPODbData.getRangeConfigId(defaultValue, minValue, maxValue, isSpinVisible, spinStep);
                            Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)isRequired));
                            regSettingKeyValNameRows.add(tableString.toString());
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)rangeConfigId.toString()));
                            regSettingRangeCompMappingRows.add(tableString.toString());
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"6"));
                            regSettingUIDetailsRows.add(tableString.toString());
                        } else if (tagName.equalsIgnoreCase("textBox")) {
                            Long curRegKeyUvhId;
                            String defVal;
                            ++presentationCounter;
                            String id = curPresentationElem.getAttribute("refId");
                            Element textElem = (Element)xpath.evaluate(".//text[@id='" + id + "']", curPolElem, XPathConstants.NODE);
                            String curRegKey = textElem.getAttribute("key");
                            if (curRegKey.length() == 0) {
                                curRegKey = mainRegKey;
                            }
                            String enabledValName = textElem.getAttribute("valueName");
                            processedValNames.add(enabledValName);
                            if (enabledValName.length() == 0) {
                                System.out.println("valueName of text element is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "valueName of text element is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                            int enabledDataType = 1;
                            String expandable = textElem.getAttribute("expandable");
                            if (expandable.equalsIgnoreCase("true")) {
                                enabledDataType = 2;
                            }
                            String disabledValName = "**del." + enabledValName;
                            int disabledDataType = 1;
                            int valueType = 3;
                            String isRequired = "0";
                            if (textElem.getAttribute("required").equalsIgnoreCase("true")) {
                                isRequired = "1";
                            }
                            String maxLength = "1023";
                            if (textElem.getAttribute("maxLength").length() > 0) {
                                maxLength = textElem.getAttribute("maxLength");
                            }
                            if (textElem.getAttribute("soft").length() > 0) {
                                System.out.println("!!!!!!!!!!!soft attribute of text element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "!!!!!!!!!!!soft attribute of text element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                            Element labelElement = (Element)xpath.evaluate("label", curPresentationElem, XPathConstants.NODE);
                            if (labelElement == null) {
                                System.out.println("labelElement is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "labelElement is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                return returnProp;
                            }
                            String textKeyDescription2 = "";
                            String description2 = labelElement.getTextContent();
                            if (description2 == null || description2.length() == 0) {
                                boolean dummy = false;
                            }
                            if (description2.length() > 0) {
                                boolean isExistingValue;
                                textKeyDescription2 = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description2) != null;
                                if (isExistingValue) {
                                    textKeyDescription2 = regSettingAllCompTextDetailsEng.getProperty(description2);
                                    --curMaxLinesInPropFiles;
                                } else {
                                    regSettingAllCompTextDetailsEng.put(description2, textKeyDescription2);
                                    for (int z = 0; z < langs.length; ++z) {
                                        Element curLangTextBoxElem;
                                        Element curLanglabelElement;
                                        String curLang = langs[z];
                                        Properties curLangProps3 = (Properties)regSettingAllCompTextDetails.get(curLang);
                                        Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                        Element curLangPresentationElem3 = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                        if (curLangPresentationElem3 == null) {
                                            System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            curLangPresentationElem3 = engPresentationElem;
                                        }
                                        if ((curLanglabelElement = (Element)xpath.evaluate("label", curLangTextBoxElem = (Element)xpath.evaluate("textBox[@refId='" + id + "']", curLangPresentationElem3, XPathConstants.NODE), XPathConstants.NODE)) == null) {
                                            System.out.println("curLang: " + curLang + ", labelElement is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            returnProp.put("status", "error");
                                            returnProp.put("msg", "curLang: " + curLang + ", labelElement is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            return returnProp;
                                        }
                                        String curLangDesc2 = curLanglabelElement.getTextContent();
                                        if (curLangDesc2 == null || curLangDesc2.length() == 0) {
                                            boolean dummy = false;
                                        }
                                        curLangProps3.put(textKeyDescription2, curLangDesc2);
                                    }
                                }
                            }
                            String defaultValueKey = "";
                            Element defValElement = (Element)xpath.evaluate("defaultValue", curPresentationElem, XPathConstants.NODE);
                            if (defValElement != null && (defVal = defValElement.getTextContent()).length() > 0) {
                                boolean isExistingValue;
                                defaultValueKey = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + ++presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(defVal) != null;
                                if (isExistingValue) {
                                    defaultValueKey = regSettingAllCompTextDetailsEng.getProperty(defVal);
                                    --curMaxLinesInPropFiles;
                                } else {
                                    regSettingAllCompTextDetailsEng.put(defVal, defaultValueKey);
                                    for (int z = 0; z < langs.length; ++z) {
                                        Element curLangTextBoxElem;
                                        Element curLangdefValElem;
                                        String curLang = langs[z];
                                        curLangProps = (Properties)regSettingAllCompTextDetails.get(curLang);
                                        Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                        curLangPresentationElem = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                        if (curLangPresentationElem == null) {
                                            System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            curLangPresentationElem = engPresentationElem;
                                        }
                                        if ((curLangdefValElem = (Element)xpath.evaluate("defaultValue", curLangTextBoxElem = (Element)xpath.evaluate("textBox[@refId='" + id + "']", curLangPresentationElem, XPathConstants.NODE), XPathConstants.NODE)) == null) {
                                            System.out.println("curLang: " + curLang + ", defaultValue is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            returnProp.put("status", "error");
                                            returnProp.put("msg", "curLang: " + curLang + ", defaultValue is absent for a textBox element in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            return returnProp;
                                        }
                                        String curLangDefValText = curLangdefValElem.getTextContent();
                                        if (curLangDefValText == null || curLangDefValText.length() == 0) {
                                            boolean dummy = false;
                                        }
                                        curLangProps.put(defaultValueKey, curLangDefValText);
                                    }
                                }
                            }
                            if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey)) == null) {
                                curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                gpoRegSettingKeyRows.add(tableString.toString());
                                curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                            }
                            Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)isRequired));
                            regSettingKeyValNameRows.add(tableString.toString());
                            if (!maxLength.equalsIgnoreCase("1023") || defaultValueKey.length() > 0) {
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)maxLength));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)defaultValueKey));
                                regSettingTextBoxCompDetailsRows.add(tableString.toString());
                            }
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription2));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
                            regSettingUIDetailsRows.add(tableString.toString());
                        } else if (tagName.equalsIgnoreCase("checkBox")) {
                            Long curRegKeyUvhId;
                            Element stringE;
                            ++presentationCounter;
                            String id = curPresentationElem.getAttribute("refId");
                            Element boolElem = (Element)xpath.evaluate(".//boolean[@id='" + id + "']", curPolElem, XPathConstants.NODE);
                            String curRegKey = boolElem.getAttribute("key");
                            if (curRegKey.length() == 0) {
                                curRegKey = mainRegKey;
                            }
                            int valueType = 1;
                            String enabledValName = boolElem.getAttribute("valueName");
                            processedValNames.add(enabledValName);
                            String enabledValue = "1";
                            int enabledDataType = 4;
                            String disabledValName = "**del." + enabledValName;
                            String disabledValue = " ";
                            int disabledDataType = 1;
                            Element trueValueElem = (Element)xpath.evaluate("trueValue", boolElem, XPathConstants.NODE);
                            Element falseValueElem = (Element)xpath.evaluate("falseValue", boolElem, XPathConstants.NODE);
                            if (trueValueElem != null) {
                                stringE = (Element)xpath.evaluate("string", trueValueElem, XPathConstants.NODE);
                                Element decimalE = (Element)xpath.evaluate("decimal", trueValueElem, XPathConstants.NODE);
                                if (stringE != null) {
                                    enabledValue = stringE.getTextContent();
                                    enabledDataType = 1;
                                } else if (decimalE != null) {
                                    enabledValue = decimalE.getAttribute("value");
                                    enabledDataType = 4;
                                } else {
                                    System.out.println("for trueValue of boolean both str and decimal are not present.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "for trueValue of boolean both str and decimal are not present.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                if (enabledValue == null || enabledValue.length() == 0) {
                                    System.out.println("enabledValue is null or empty: " + enabledValue + " for trueValue of boolean.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "enabledValue is null or empty: " + enabledValue + " for trueValue of boolean.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                            }
                            if (falseValueElem != null) {
                                stringE = (Element)xpath.evaluate("string", falseValueElem, XPathConstants.NODE);
                                Element decimalE = (Element)xpath.evaluate("decimal", falseValueElem, XPathConstants.NODE);
                                Element deleteE = (Element)xpath.evaluate("delete", falseValueElem, XPathConstants.NODE);
                                if (stringE != null) {
                                    disabledValName = enabledValName;
                                    disabledValue = stringE.getTextContent();
                                    disabledDataType = 1;
                                } else if (decimalE != null) {
                                    disabledValName = enabledValName;
                                    disabledValue = decimalE.getAttribute("value");
                                    disabledDataType = 4;
                                } else if (deleteE != null) {
                                    disabledValName = "**del." + enabledValName;
                                    disabledValue = " ";
                                    disabledDataType = 1;
                                } else {
                                    System.out.println("for falseValue of boolean str, decimal, delete elems are not present.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "for falseValue of boolean str, decimal, delete elems are not present.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                if (disabledValue == null || disabledValue.length() == 0) {
                                    System.out.println("disabledValue is null or empty: " + disabledValue + " for falseValue of boolean.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "disabledValue is null or empty: " + disabledValue + " for falseValue of boolean.. in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                            }
                            Element trueListElem = (Element)xpath.evaluate("trueList", boolElem, XPathConstants.NODE);
                            Element falseListElem = (Element)xpath.evaluate("falseList", boolElem, XPathConstants.NODE);
                            boolean defaultChecked = false;
                            if (curPresentationElem.getAttribute("defaultChecked").length() > 0) {
                                defaultChecked = Boolean.valueOf(curPresentationElem.getAttribute("defaultChecked"));
                            }
                            textKeyDescription = "";
                            description = curPresentationElem.getTextContent();
                            if (description == null || description.length() == 0) {
                                boolean dummy = false;
                            }
                            if (description.length() > 0) {
                                boolean isExistingValue;
                                textKeyDescription = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description) != null;
                                if (isExistingValue) {
                                    textKeyDescription = regSettingAllCompTextDetailsEng.getProperty(description);
                                    --curMaxLinesInPropFiles;
                                } else {
                                    regSettingAllCompTextDetailsEng.put(description, textKeyDescription);
                                    for (int z = 0; z < langs.length; ++z) {
                                        Element curLangCheckBoxElem;
                                        String curLang = langs[z];
                                        curLangProps = (Properties)regSettingAllCompTextDetails.get(curLang);
                                        Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                        curLangPresentationElem = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                        if (curLangPresentationElem == null) {
                                            System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            curLangPresentationElem = engPresentationElem;
                                        }
                                        if ((curLangCheckBoxElem = (Element)xpath.evaluate("checkBox[@refId='" + id + "']", curLangPresentationElem, XPathConstants.NODE)) == null) {
                                            System.out.println("curLang: " + curLang + ", check box elem is missing id: " + id + " polName: " + curRegSettingPolName + " and fileName: " + curRegSettingFileName);
                                        }
                                        if ((curLangDesc = curLangCheckBoxElem.getTextContent()) == null || curLangDesc.length() == 0) {
                                            boolean dummy = false;
                                        }
                                        curLangProps.put(textKeyDescription, curLangDesc);
                                    }
                                }
                            }
                            if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey)) == null) {
                                curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                gpoRegSettingKeyRows.add(tableString.toString());
                                curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                            }
                            Long enabledValId = GPODbData.getConstValId(enabledValue);
                            Long disabledValId = GPODbData.getConstValId(disabledValue);
                            Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                            regSettingKeyValNameRows.add(tableString.toString());
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValId));
                            regSettingConstValMappingRows.add(tableString.toString());
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValId));
                            regSettingConstValMappingRows.add(tableString.toString());
                            if (defaultChecked) {
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
                                regSettingCheckBoxCompDetailsRows.add(tableString.toString());
                            }
                            if (trueListElem != null) {
                                GPODbData.populateTrueListConfigDetails(1, trueListElem, curRegSettingPolName, curRegSettingFileName, valNameId);
                            }
                            if (falseListElem != null) {
                                GPODbData.populateTrueListConfigDetails(2, falseListElem, curRegSettingPolName, curRegSettingFileName, valNameId);
                            }
                            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription));
                            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"5"));
                            regSettingUIDetailsRows.add(tableString.toString());
                        } else {
                            String curLangDesc3;
                            Properties curLangProps4;
                            String curLang;
                            String description3;
                            String textKeyDescription3;
                            if (tagName.equalsIgnoreCase("comboBox")) {
                                System.out.println("comboBox component came for first time.. till now it was not handled.. need to handle this new component... polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                break;
                            }
                            if (tagName.equalsIgnoreCase("dropdownList")) {
                                Long curRegKeyUvhId;
                                int valueType = 2;
                                ++presentationCounter;
                                String id = curPresentationElem.getAttribute("refId");
                                Element enumElem = (Element)xpath.evaluate(".//enum[@id='" + id + "']", curPolElem, XPathConstants.NODE);
                                String curRegKey = enumElem.getAttribute("key");
                                if (curRegKey.length() == 0) {
                                    curRegKey = mainRegKey;
                                }
                                String enabledValName = enumElem.getAttribute("valueName");
                                processedValNames.add(enabledValName);
                                if (enabledValName.length() == 0) {
                                    System.out.println("valueName of enumElem is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "valueName of enumElem is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                String disabledValName = "**del." + enabledValName;
                                int disabledDataType = 1;
                                String isRequired = "0";
                                if (enumElem.getAttribute("required").equalsIgnoreCase("true")) {
                                    isRequired = "1";
                                }
                                String noSort = "false";
                                String defaultItem = null;
                                if (curPresentationElem.getAttribute("noSort").length() > 0) {
                                    noSort = curPresentationElem.getAttribute("noSort");
                                }
                                if (curPresentationElem.getAttribute("defaultItem").length() > 0) {
                                    defaultItem = curPresentationElem.getAttribute("defaultItem");
                                }
                                int compType = 3;
                                if (noSort.equalsIgnoreCase("true")) {
                                    compType = 4;
                                }
                                textKeyDescription3 = "";
                                description3 = curPresentationElem.getTextContent();
                                if (description3 == null || description3.length() == 0) {
                                    boolean dummy = false;
                                }
                                if (description3.length() > 0) {
                                    boolean isExistingValue;
                                    textKeyDescription3 = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                    boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description3) != null;
                                    if (isExistingValue) {
                                        textKeyDescription3 = regSettingAllCompTextDetailsEng.getProperty(description3);
                                        --curMaxLinesInPropFiles;
                                    } else {
                                        regSettingAllCompTextDetailsEng.put(description3, textKeyDescription3);
                                        for (int z = 0; z < langs.length; ++z) {
                                            Element curLangDecimalTextBoxElem;
                                            curLang = langs[z];
                                            curLangProps4 = (Properties)regSettingAllCompTextDetails.get(curLang);
                                            Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                            Element curLangPresentationElem4 = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                            if (curLangPresentationElem4 == null) {
                                                System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                                curLangPresentationElem4 = engPresentationElem;
                                            }
                                            if ((curLangDesc3 = (curLangDecimalTextBoxElem = (Element)xpath.evaluate("dropdownList[@refId='" + id + "']", curLangPresentationElem4, XPathConstants.NODE)).getTextContent()) == null || curLangDesc3.length() == 0) {
                                                boolean dummy = false;
                                            }
                                            curLangProps4.put(textKeyDescription3, curLangDesc3);
                                        }
                                    }
                                }
                                if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey)) == null) {
                                    curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                    gpoRegSettingKeyRows.add(tableString.toString());
                                    curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                                }
                                int enabledDataType = -1;
                                NodeList allItems = enumElem.getElementsByTagName("item");
                                block34: for (int h = 0; h < allItems.getLength(); ++h) {
                                    Element curItem = (Element)allItems.item(h);
                                    if (!curItem.getParentNode().getNodeName().equalsIgnoreCase("enum")) continue;
                                    Node itemChild = curItem.getFirstChild();
                                    while (true) {
                                        if (itemChild.getNodeType() == 1 && itemChild.getNodeName().equalsIgnoreCase("value")) {
                                            if (((Element)itemChild).getElementsByTagName("decimal").getLength() == 1) {
                                                enabledDataType = 4;
                                                break block34;
                                            }
                                            if (((Element)itemChild).getElementsByTagName("string").getLength() == 1) {
                                                enabledDataType = 1;
                                                break block34;
                                            }
                                            System.out.println("unexpected datatype (other than decimal, string..) for enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            returnProp.put("status", "error");
                                            returnProp.put("msg", "unexpected datatype (other than decimal, string..) for enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                            return returnProp;
                                        }
                                        if (itemChild.getNextSibling() == null) break block34;
                                        itemChild = itemChild.getNextSibling();
                                    }
                                }
                                if (enabledDataType == -1) {
                                    System.out.println("invalid datatype found for a enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "invalid datatype found for a enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)isRequired));
                                regSettingKeyValNameRows.add(tableString.toString());
                                int itemPriority = 0;
                                int itemNo = -1;
                                allItems = enumElem.getElementsByTagName("item");
                                block36: for (int h = 0; h < allItems.getLength(); ++h) {
                                    Element curItem = (Element)allItems.item(h);
                                    if (!curItem.getParentNode().getNodeName().equalsIgnoreCase("enum")) continue;
                                    Node itemChild = curItem.getFirstChild();
                                    Long curListValConfigId = null;
                                    while (true) {
                                        if (itemChild.getNodeType() == 1) {
                                            if (itemChild.getNodeName().equalsIgnoreCase("value")) {
                                                String strItemNo;
                                                boolean isExistingValue;
                                                String itemDisplayName = curItem.getAttribute("displayName");
                                                itemDisplayName = itemDisplayName.substring(itemDisplayName.indexOf(".") + 1, itemDisplayName.length() - 1);
                                                String itemDispName = (String)xpath.evaluate("//policyDefinitionResources/resources/stringTable/string[@id='" + itemDisplayName + "']", engLangDocElement, XPathConstants.STRING);
                                                if (itemDispName == null || itemDispName.length() == 0) {
                                                    System.out.println("a item displayName is null or empty: " + itemDisplayName + " for a enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName + " hence going to use key of displayName from admx..");
                                                    itemDispName = itemDisplayName;
                                                }
                                                String itemDispNameKey = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + ++presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                                boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(itemDispName) != null;
                                                if (isExistingValue) {
                                                    itemDispNameKey = regSettingAllCompTextDetailsEng.getProperty(itemDispName);
                                                    --curMaxLinesInPropFiles;
                                                } else {
                                                    regSettingAllCompTextDetailsEng.put(itemDispName, itemDispNameKey);
                                                    for (int z = 0; z < langs.length; ++z) {
                                                        String curLang2 = langs[z];
                                                        Properties curLangProps5 = (Properties)regSettingAllCompTextDetails.get(curLang2);
                                                        Element curLangDocElement = (Element)admlDocProps.get(curLang2);
                                                        String curLangItemDispName = (String)xpath.evaluate("//policyDefinitionResources/resources/stringTable/string[@id='" + itemDisplayName + "']", curLangDocElement, XPathConstants.STRING);
                                                        if (curLangItemDispName == null || curLangItemDispName.length() == 0) {
                                                            System.out.println("a item displayName is null or empty: " + itemDisplayName + " in lang: " + curLang2 + " for a enum in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName + " hence going to use key of displayName from admx..");
                                                            curLangItemDispName = itemDisplayName;
                                                        }
                                                        curLangProps5.put(itemDispNameKey, curLangItemDispName);
                                                    }
                                                }
                                                String itemVal = null;
                                                if (enabledDataType == 4) {
                                                    itemVal = ((Element)((Element)itemChild).getElementsByTagName("decimal").item(0)).getAttribute("value");
                                                } else if (enabledDataType == 1) {
                                                    itemVal = ((Element)((Element)itemChild).getElementsByTagName("string").item(0)).getTextContent();
                                                }
                                                Long listValConfigValueId = GPODbData.getListValConfigValueId(itemDispNameKey, itemVal, ++itemPriority);
                                                String strDefItem = "0";
                                                if (defaultItem != null && defaultItem.equalsIgnoreCase(strItemNo = "" + ++itemNo)) {
                                                    strDefItem = "1";
                                                }
                                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)listValConfigValueId.toString()));
                                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)strDefItem));
                                                regSettingListValMappingRows.add(tableString.toString());
                                                curListValConfigId = listValConfigValueId;
                                            } else if (itemChild.getNodeName().equalsIgnoreCase("valueList")) {
                                                Long configId = GPODbData.getUvhid("RegSettingListValSubValConfig", "CONFIG_ID");
                                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)configId.toString()));
                                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString(curListValConfigId));
                                                regSettingListValSubValConfigRows.add(tableString.toString());
                                                NodeList subItems = ((Element)itemChild).getElementsByTagName("item");
                                                for (int k = 0; k < subItems.getLength(); ++k) {
                                                    Element subItem = (Element)subItems.item(k);
                                                    String curSubRegKey = subItem.getAttribute("key");
                                                    String curSubValName = subItem.getAttribute("valueName");
                                                    if (curSubRegKey.length() == 0 || curSubValName.length() == 0) {
                                                        System.out.println("key or valName is not present in a item in valueList of a enum in polName: " + curRegSettingPolName + " in file name: " + curRegSettingFileName);
                                                        returnProp.put("status", "error");
                                                        returnProp.put("msg", "key or valName is not present in a item in valueList of a enum in polName: " + curRegSettingPolName + " in file name: " + curRegSettingFileName);
                                                        return returnProp;
                                                    }
                                                    String subItemVal = null;
                                                    int subItemValType = -1;
                                                    NodeList decimalNL = subItem.getElementsByTagName("decimal");
                                                    if (decimalNL.getLength() == 1) {
                                                        Element curDec = (Element)decimalNL.item(0);
                                                        subItemValType = 4;
                                                        subItemVal = curDec.getAttribute("value");
                                                    } else {
                                                        NodeList deleteNL = subItem.getElementsByTagName("delete");
                                                        if (deleteNL.getLength() == 1) {
                                                            subItemValType = 1;
                                                            subItemVal = " ";
                                                            curSubValName = "**del." + curSubValName;
                                                        } else {
                                                            NodeList stringNL = subItem.getElementsByTagName("string");
                                                            if (stringNL.getLength() == 1) {
                                                                Element curStr = (Element)stringNL.item(0);
                                                                subItemValType = 1;
                                                                subItemVal = curStr.getTextContent();
                                                            } else {
                                                                System.out.println("*****new items (other than decimal/delete/string) in valueList of a item of a enum in polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName);
                                                                returnProp.put("status", "error");
                                                                returnProp.put("msg", "*****new items (other than decimal/delete/string) in valueList of a item of a enum in polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName);
                                                                return returnProp;
                                                            }
                                                        }
                                                    }
                                                    Long detailId = GPODbData.getUvhid("RegSettingListValSubValDetails", "DETAIL_ID");
                                                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)detailId.toString()));
                                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)configId.toString()));
                                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curSubRegKey));
                                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curSubValName));
                                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + subItemValType)));
                                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)subItemVal));
                                                    regSettingListValSubValDetailsRows.add(tableString.toString());
                                                }
                                            }
                                        }
                                        if (itemChild.getNextSibling() == null) continue block36;
                                        itemChild = itemChild.getNextSibling();
                                    }
                                }
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription3));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + compType)));
                                regSettingUIDetailsRows.add(tableString.toString());
                            } else if (tagName.equalsIgnoreCase("multiTextBox")) {
                                Element multiTextElem;
                                String curRegKey;
                                ++presentationCounter;
                                String id = curPresentationElem.getAttribute("refId");
                                String defaultHeight = "3";
                                if (curPresentationElem.getAttribute("defaultHeight").length() > 0) {
                                    defaultHeight = curPresentationElem.getAttribute("defaultHeight");
                                }
                                if (curPresentationElem.getAttribute("showAsDialog").length() > 0) {
                                    System.out.println("!!!!!!!!!!!showAsDialog attribute multiTextBox presentation element is found which is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "!!!!!!!!!!!showAsDialog attribute multiTextBox presentation element is found which is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                String textKeyDescription4 = "";
                                String description4 = curPresentationElem.getTextContent();
                                if (description4 == null || description4.length() == 0) {
                                    boolean dummy = false;
                                }
                                if (description4.length() > 0) {
                                    boolean isExistingValue;
                                    textKeyDescription4 = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                    boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description4) != null;
                                    if (isExistingValue) {
                                        textKeyDescription4 = regSettingAllCompTextDetailsEng.getProperty(description4);
                                        --curMaxLinesInPropFiles;
                                    } else {
                                        regSettingAllCompTextDetailsEng.put(description4, textKeyDescription4);
                                        for (int z = 0; z < langs.length; ++z) {
                                            Element curLangMultiTextBoxElem;
                                            String curLangDesc4;
                                            String curLang3 = langs[z];
                                            Properties curLangProps6 = (Properties)regSettingAllCompTextDetails.get(curLang3);
                                            Element curLangDocElement = (Element)admlDocProps.get(curLang3);
                                            Element curLangPresentationElem5 = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                            if (curLangPresentationElem5 == null) {
                                                System.out.println("presentation elem is null for lang: " + curLang3 + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                                curLangPresentationElem5 = engPresentationElem;
                                            }
                                            if ((curLangDesc4 = (curLangMultiTextBoxElem = (Element)xpath.evaluate("multiTextBox[@refId='" + id + "']", curLangPresentationElem5, XPathConstants.NODE)).getTextContent()) == null || curLangDesc4.length() == 0) {
                                                boolean dummy = false;
                                            }
                                            curLangProps6.put(textKeyDescription4, curLangDesc4);
                                        }
                                    }
                                }
                                if ((curRegKey = (multiTextElem = (Element)xpath.evaluate(".//multiText[@id='" + id + "']", curPolElem, XPathConstants.NODE)).getAttribute("key")).length() == 0) {
                                    curRegKey = mainRegKey;
                                }
                                int valueType = 3;
                                int enabledDataType = 7;
                                String enabledValName = multiTextElem.getAttribute("valueName");
                                processedValNames.add(enabledValName);
                                if (enabledValName.length() == 0) {
                                    System.out.println("valueName of multiText is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "valueName of multiText is empty. polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                int disabledDataType = 1;
                                String disabledValName = "**del." + enabledValName;
                                String isRequired = "0";
                                if (multiTextElem.getAttribute("required").equalsIgnoreCase("true")) {
                                    isRequired = "1";
                                }
                                String maxLength = "1023";
                                if (multiTextElem.getAttribute("maxLength").length() > 0) {
                                    maxLength = multiTextElem.getAttribute("maxLength");
                                }
                                String maxStrings = "0";
                                if (multiTextElem.getAttribute("maxStrings").length() > 0) {
                                    maxStrings = multiTextElem.getAttribute("maxStrings");
                                }
                                if (multiTextElem.getAttribute("soft").length() > 0) {
                                    System.out.println("!!!!!!!!!!!soft attribute of multiText element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "!!!!!!!!!!!soft attribute of multiText element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                Long curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey);
                                if (curRegKeyUvhId == null) {
                                    curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                    gpoRegSettingKeyRows.add(tableString.toString());
                                    curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                                }
                                Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)isRequired));
                                regSettingKeyValNameRows.add(tableString.toString());
                                if (!maxLength.equalsIgnoreCase("1023") || !maxStrings.equalsIgnoreCase("0")) {
                                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)maxLength));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)maxStrings));
                                    regSettingMultiTextCompDetailsRows.add(tableString.toString());
                                }
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription4));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"8"));
                                regSettingUIDetailsRows.add(tableString.toString());
                            } else if (tagName.equalsIgnoreCase("listBox")) {
                                Long curRegKeyUvhId;
                                ++presentationCounter;
                                String id = curPresentationElem.getAttribute("refId");
                                Element listElem = (Element)xpath.evaluate(".//list[@id='" + id + "']", curPolElem, XPathConstants.NODE);
                                String curRegKey = listElem.getAttribute("key");
                                if (curRegKey.length() == 0) {
                                    curRegKey = mainRegKey;
                                }
                                if ((curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey)) == null) {
                                    curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                                    tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                                    gpoRegSettingKeyRows.add(tableString.toString());
                                    curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
                                }
                                String valuePrefix = null;
                                if (listElem.hasAttribute("valuePrefix")) {
                                    valuePrefix = "";
                                    if (listElem.getAttribute("valuePrefix").length() > 0) {
                                        valuePrefix = listElem.getAttribute("valuePrefix");
                                    }
                                }
                                boolean additive = false;
                                if (listElem.getAttribute("additive").length() > 0) {
                                    additive = Boolean.parseBoolean(listElem.getAttribute("additive"));
                                }
                                boolean enabledDataType = true;
                                String explicitValue = "false";
                                if (listElem.getAttribute("explicitValue").length() > 0) {
                                    explicitValue = listElem.getAttribute("explicitValue");
                                }
                                if (listElem.getAttribute("expandable").length() > 0) {
                                    System.out.println("!!!!!!!!!!!expandable attribute of list element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    returnProp.put("status", "error");
                                    returnProp.put("msg", "!!!!!!!!!!!expandable attribute of list element is not handled. Found it in polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                    return returnProp;
                                }
                                int type = 1;
                                if (explicitValue.equalsIgnoreCase("true")) {
                                    type = 2;
                                }
                                if (valuePrefix != null) {
                                    type = 3;
                                }
                                Long dynaValId = GPODbData.getUvhid("RegSettingKeyDynaVal", "DYNA_VAL_ID");
                                Row regSettingKeyDynaValRow = new Row("RegSettingKeyDynaVal");
                                regSettingKeyDynaValRow.set("DYNA_VAL_ID", (Object)dynaValId);
                                regSettingKeyDynaValRow.set("REG_SETTING_KEY_ID", (Object)curRegKeyUvhId);
                                regSettingKeyDynaValRow.set("TYPE", (Object)type);
                                if (valuePrefix != null) {
                                    regSettingKeyDynaValRow.set("VALUE_PREFIX", (Object)valuePrefix);
                                }
                                regSettingKeyDynaValRow.set("IS_ADDITIVE", (Object)additive);
                                dataObjDynaVal.addRow(regSettingKeyDynaValRow);
                                textKeyDescription3 = "";
                                description3 = curPresentationElem.getTextContent();
                                if (description3 == null || description3.length() == 0) {
                                    boolean dummy = false;
                                }
                                if (description3.length() > 0) {
                                    boolean isExistingValue;
                                    textKeyDescription3 = "admp.gpo_mgmt.reg_setting_presentation." + curRegSettingPolName + "_" + onlyFileName + "." + presentationCounter + "_" + ++curMaxLinesInPropFiles;
                                    boolean bl = isExistingValue = regSettingAllCompTextDetailsEng.get(description3) != null;
                                    if (isExistingValue) {
                                        textKeyDescription3 = regSettingAllCompTextDetailsEng.getProperty(description3);
                                        --curMaxLinesInPropFiles;
                                    } else {
                                        regSettingAllCompTextDetailsEng.put(description3, textKeyDescription3);
                                        for (int z = 0; z < langs.length; ++z) {
                                            Element curLangListBoxElem;
                                            curLang = langs[z];
                                            curLangProps4 = (Properties)regSettingAllCompTextDetails.get(curLang);
                                            Element curLangDocElement = (Element)admlDocProps.get(curLang);
                                            Element curLangPresentationElem6 = (Element)xpath.evaluate("//presentation[@id='" + presentation + "']", curLangDocElement, XPathConstants.NODE);
                                            if (curLangPresentationElem6 == null) {
                                                System.out.println("presentation elem is null for lang: " + curLang + " polName: " + curRegSettingPolName + " and file name: " + curRegSettingFileName);
                                                curLangPresentationElem6 = engPresentationElem;
                                            }
                                            if ((curLangDesc3 = (curLangListBoxElem = (Element)xpath.evaluate("listBox[@refId='" + id + "']", curLangPresentationElem6, XPathConstants.NODE)).getTextContent()) == null || curLangDesc3.length() == 0) {
                                                boolean dummy = false;
                                            }
                                            curLangProps4.put(textKeyDescription3, curLangDesc3);
                                        }
                                    }
                                }
                                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)dynaValId.toString()));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)textKeyDescription3));
                                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"7"));
                                regSettingUIDynaValDetailsRows.add(tableString.toString());
                            } else {
                                System.out.println("unexpected tagName: " + tagName + " in presentation of polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName);
                                returnProp.put("status", "error");
                                returnProp.put("msg", "unexpected tagName: " + tagName + " in presentation of polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName);
                                return returnProp;
                            }
                        }
                    }
                    if (childPreElem.getNextSibling() == null) break;
                    childPreElem = childPreElem.getNextSibling();
                }
            }
            if (mainValueName.length() <= 0 || processedValNames.contains(mainValueName)) continue;
            String curRegKey = mainRegKey;
            Long curRegKeyUvhId = (Long)curSettingRegKeysVsIds.get(curRegKey);
            if (curRegKeyUvhId == null) {
                curRegKeyUvhId = GPODbData.getUvhid("GPORegSettingKey", "REG_SETTING_KEY_ID");
                tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKey));
                gpoRegSettingKeyRows.add(tableString.toString());
                curSettingRegKeysVsIds.put(curRegKey, curRegKeyUvhId);
            }
            String enabledValName = mainValueName;
            String disabledValName = "**del." + mainValueName;
            int enabledDataType = 4;
            int disabledDataType = 1;
            int valueType = 1;
            String enabledValue = "1";
            String disabledValue = " ";
            Long enabledValId = GPODbData.getConstValId(enabledValue);
            Long disabledValId = GPODbData.getConstValId(disabledValue);
            Long valNameId = GPODbData.getUvhid("RegSettingKeyValName", "VAL_NAME_ID");
            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curRegKeyUvhId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValName));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValName));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + enabledDataType)));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + disabledDataType)));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + valueType)));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
            regSettingKeyValNameRows.add(tableString.toString());
            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)enabledValId));
            regSettingConstValMappingRows.add(tableString.toString());
            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"2"));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)disabledValId));
            regSettingConstValMappingRows.add(tableString.toString());
            tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curRegSettingUvhId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + ++uiPriority)));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)""));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
            regSettingUIDetailsRows.add(tableString.toString());
        }
        domainStatus.put(domainName + "_msg", curRb.getString("admp.mgmt.gpo_mgmt.updating_adml_lang_details"));
        allProps = new ArrayList();
        allProps.add(folderNameProps);
        allProps.add(regSettingHelpProps);
        allProps.add(regSettingNameProps);
        allProps.add(regSettingPathProps);
        allProps.add(regSettingSupportedFromProps);
        allProps.add(regSettingAllCompTextDetails);
        boolean newKeysAdded = false;
        String[] fileNames = new String[]{"folderName", "regsettingHelp", "regsettingName", "regSettingPath", "regSettingSupportedFrom", "regSettingDialogBoxKeys"};
        for (int i5 = 0; i5 < allProps.size(); ++i5) {
            Properties curProps = (Properties)allProps.get(i5);
            for (int j4 = 0; j4 < langs.length; ++j4) {
                String curLang = langs[j4];
                Properties curPropForALang = (Properties)curProps.get(curLang);
                if (curPropForALang.size() <= 0) continue;
                String fileName = System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adsm" + File.separator + "gpomgmt" + File.separator + "GpoMgmtMessage_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5) + ".properties";
                FileOutputStream output = new FileOutputStream(fileName, true);
                curPropForALang.store(output, null);
                newKeysAdded = true;
            }
        }
        System.out.println("after writing to props file..");
        if (newKeysAdded) {
            ResourceBundleMgr.getInstance().resetResourceBundles();
        }
        System.out.println("just before master data update...");
        domainStatus.put(domainName + "_msg", curRb.getString("admp.mgmt.gpo_mgmt.updating_necessary_tables"));
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObjConfig);
        dataObjConfig = null;
        GPODbData.writeFromFileToDB(gpoRegSettingKeyRows, tempGpoPath + File.separator + "GPORegSettingKey.txt", "GPORegSettingKey", (List)columnOrderProp.get("GPORegSettingKey"));
        gpoRegSettingKeyRows = null;
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObjDynaVal);
        dataObjDynaVal = null;
        for (int tables = 0; tables < tableArrayFilesToDb.length; ++tables) {
            String curTableName = tableArrayFilesToDb[tables];
            ArrayList curTableRows = (ArrayList)tableVsRows.get(curTableName);
            GPODbData.writeFromFileToDB(curTableRows, tempGpoPath + File.separator + curTableName + ".txt", curTableName, (List)columnOrderProp.get(curTableName));
            curTableRows.clear();
        }
        System.out.println("just after master data update...");
        System.out.println("just before lang data update...");
        SelectQueryImpl gpoSettingFolDetailsSq = new SelectQueryImpl(Table.getTable((String)"GPOSettingFolderDetails"));
        gpoSettingFolDetailsSq.addSelectColumn(Column.getColumn((String)"GPOSettingFolderDetails", (String)"FOLDER_ID"));
        gpoSettingFolDetailsSq.addSelectColumn(Column.getColumn((String)"GPOSettingFolderDetails", (String)"FOLDER_NAME_I18N_KEY"));
        gpoSettingFolDetailsSq.setCriteria(new Criteria(Column.getColumn((String)"GPOSettingFolderDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)gpoSettingFolDetailsSq);
        subQuery = new SelectQueryImpl(Table.getTable((String)"GPOSettingFolderDetails"));
        subQuery.addSelectColumn(Column.getColumn((String)"GPOSettingFolderDetails", (String)"FOLDER_ID"));
        subQuery.setCriteria(new Criteria(Column.getColumn((String)"GPOSettingFolderDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        subQueryResCol = new DerivedColumn("GPOSettingFolderDetails", (SelectQuery)subQuery);
        gpoSettingFolDetailsSq = new SelectQueryImpl(Table.getTable((String)"GPORegSetting"));
        gpoSettingFolDetailsSq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"REG_SETTING_ID"));
        gpoSettingFolDetailsSq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"REG_SETTING_I18N_KEY"));
        gpoSettingFolDetailsSq.addSelectColumn(Column.getColumn((String)"GPORegSetting", (String)"SETTING_PATH_I18N_KEY"));
        regSettingCrit = new Criteria(Column.getColumn((String)"GPORegSetting", (String)"PARENT_ID"), (Object)subQueryResCol, 8);
        gpoSettingFolDetailsSq.setCriteria(regSettingCrit);
        dataObj.merge(CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)gpoSettingFolDetailsSq));
        for (l = 0; l < langs.length; ++l) {
            String curLang = langs[l];
            String tableName = "GPOSettingFolderDetails_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5);
            GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)null, (String)"GPOSettingFolderDetails", (String)tableName);
            GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)null, (String)"GPORegSetting", (String)("GPORegSetting_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5)));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(new Locale(curLang.substring(0, 2), curLang.substring(3, 5)));
            ArrayList gpoSettingFolderDetailsChildRows = new ArrayList();
            GPODbData.populateTable("GPOSettingFolderDetails", tableName, new String[]{"FOLDER_ID", "FOLDER_NAME_I18N_KEY"}, new String[]{"FOLDER_ID", "FOLDER_NAME"}, rb, gpoSettingFolderDetailsChildRows);
            ArrayList<String> cols = new ArrayList<String>();
            cols.add("FOLDER_ID");
            cols.add("FOLDER_NAME");
            columnOrderProp.put(tableName, cols);
            langTables.add(tableName);
            langTablesRows.put(tableName, gpoSettingFolderDetailsChildRows);
            ArrayList gpoRegSettingChildRows = new ArrayList();
            GPODbData.populateTable("GPORegSetting", "GPORegSetting_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5), new String[]{"REG_SETTING_ID", "REG_SETTING_I18N_KEY", "SETTING_PATH_I18N_KEY"}, new String[]{"REG_SETTING_ID", "REG_SETTING", "SETTING_PATH"}, rb, gpoRegSettingChildRows);
            cols = new ArrayList();
            cols.add("REG_SETTING_ID");
            cols.add("REG_SETTING");
            cols.add("SETTING_PATH");
            columnOrderProp.put("GPORegSetting_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5), cols);
            langTables.add("GPORegSetting_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5));
            langTablesRows.put("GPORegSetting_" + curLang.substring(0, 2) + "_" + curLang.substring(3, 5), gpoRegSettingChildRows);
        }
        for (l = 0; l < langTables.size(); ++l) {
            String tableName = langTables.get(l);
            ArrayList curTableRows = (ArrayList)langTablesRows.remove(tableName);
            if (curTableRows.size() <= 0) continue;
            GPODbData.writeFromFileToDB(curTableRows, tempGpoPath + File.separator + tableName + ".txt", tableName, (List)columnOrderProp.get(tableName));
            curTableRows = null;
        }
        returnProp.put("langs", languagesAvailable);
        System.out.println("just after lang data update...");
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("RegSettingKeyValName");
        Criteria criteria = new Criteria(Column.getColumn((String)"RegSettingKeyValName", (String)"ENABLED_VAL_NAME"), (Object)" ", 0);
        updateQuery.setCriteria(criteria);
        updateQuery.setUpdateColumn("ENABLED_VAL_NAME", (Object)"");
        CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
        System.out.println("Success!!");
        return returnProp;
    }

    public static void populateTable(String parentTableName, String childTableName, String[] parentCols, String[] childCols, AdventNetResourceBundle rb, ArrayList childRows) throws Exception {
        Iterator iter = dataObj.getRows(parentTableName);
        while (iter.hasNext()) {
            Row parRow = (Row)iter.next();
            StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)parRow.get(parentCols[0]).toString()));
            for (int i = 1; i < childCols.length; ++i) {
                String str = (String)parRow.get(parentCols[i]);
                if (str == null) continue;
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)rb.getString(str)));
            }
            childRows.add(tableString.toString());
        }
    }

    public static Long getConstValId(String val) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"RegSettingConstValConfig", (String)"VALUE"), (Object)val, 0);
        Iterator iter = dataObjConfig.getRows("RegSettingConstValConfig", crit);
        if (iter.hasNext()) {
            Row r = (Row)iter.next();
            return (Long)r.get("VALUE_ID");
        }
        Long uvhId = GPODbData.getUvhid("RegSettingConstValConfig", "VALUE_ID");
        Row curConstValConfigRow = new Row("RegSettingConstValConfig");
        curConstValConfigRow.set("VALUE_ID", (Object)uvhId);
        curConstValConfigRow.set("VALUE", (Object)val);
        dataObjConfig.addRow(curConstValConfigRow);
        return uvhId;
    }

    public static Long getRangeConfigId(String defaultValue, String minValue, String maxValue, String isSpinVisible, String spinStep) throws Exception {
        boolean isSpinVisibleBool = Boolean.parseBoolean(isSpinVisible);
        Criteria crit = new Criteria(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"DEFAULT_VALUE"), (Object)defaultValue, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"MIN_VALUE"), (Object)minValue, 0));
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"MAX_VALUE"), (Object)maxValue, 0));
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"IS_SPIN_VISIBLE"), (Object)isSpinVisibleBool, 0));
        Iterator iter = dataObjConfig.getRows("RegSettingRangeComponentConfig", crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingRangeComponentConfig", (String)"SPIN_STEP"), (Object)spinStep, 0)));
        if (iter.hasNext()) {
            Row r = (Row)iter.next();
            return (Long)r.get("CONFIG_ID");
        }
        Long uvhId = GPODbData.getUvhid("RegSettingRangeComponentConfig", "CONFIG_ID");
        Row curConfigRow = new Row("RegSettingRangeComponentConfig");
        curConfigRow.set("CONFIG_ID", (Object)uvhId);
        curConfigRow.set("DEFAULT_VALUE", (Object)Long.parseLong(defaultValue));
        curConfigRow.set("MIN_VALUE", (Object)Long.parseLong(minValue));
        curConfigRow.set("MAX_VALUE", (Object)Long.parseLong(maxValue));
        curConfigRow.set("IS_SPIN_VISIBLE", (Object)isSpinVisibleBool);
        curConfigRow.set("SPIN_STEP", (Object)Long.parseLong(spinStep));
        dataObjConfig.addRow(curConfigRow);
        return uvhId;
    }

    public static Long getListValConfigValueId(String itemDispNameKey, String itemVal, int itemPriority) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"RegSettingListValConfig", (String)"VAL_TEXT"), (Object)itemDispNameKey, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingListValConfig", (String)"VALUE"), (Object)itemVal, 0));
        Iterator iter = dataObjConfig.getRows("RegSettingListValConfig", crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingListValConfig", (String)"PRIORITY"), (Object)itemPriority, 0)));
        if (iter.hasNext()) {
            Row r = (Row)iter.next();
            return (Long)r.get("VALUE_ID");
        }
        Long uvhId = GPODbData.getUvhid("RegSettingListValConfig", "VALUE_ID");
        Row curConfigRow = new Row("RegSettingListValConfig");
        curConfigRow.set("VALUE_ID", (Object)uvhId);
        curConfigRow.set("VAL_TEXT", (Object)itemDispNameKey);
        curConfigRow.set("VALUE", (Object)itemVal);
        curConfigRow.set("PRIORITY", (Object)itemPriority);
        dataObjConfig.addRow(curConfigRow);
        return uvhId;
    }

    public static void populateTrueListConfigDetails(int trueOrFalse, Element listElem, String curRegSettingPolName, String curRegSettingFileName, Long valNameId) throws Exception {
        NodeList subItems = listElem.getElementsByTagName("item");
        for (int k = 0; k < subItems.getLength(); ++k) {
            Element subItem = (Element)subItems.item(k);
            String curSubRegKey = subItem.getAttribute("key");
            String curSubValName = subItem.getAttribute("valueName");
            if (curSubRegKey.length() == 0 || curSubValName.length() == 0) {
                System.out.println("key or valName is not present in a item in trueList/falseList of a boolean in polName: " + curRegSettingPolName + " in file name: " + curRegSettingFileName + " trueOrFalse: " + trueOrFalse);
                throw new Exception("key or valName is not present in a item in trueList/falseList of a boolean in polName: " + curRegSettingPolName + " in file name: " + curRegSettingFileName + " trueOrFalse: " + trueOrFalse);
            }
            String subItemVal = null;
            int subItemValType = -1;
            NodeList decimalNL = subItem.getElementsByTagName("decimal");
            if (decimalNL.getLength() == 1) {
                Element curDec = (Element)decimalNL.item(0);
                subItemValType = 4;
                subItemVal = curDec.getAttribute("value");
            } else {
                NodeList deleteNL = subItem.getElementsByTagName("delete");
                if (deleteNL.getLength() == 1) {
                    subItemValType = 1;
                    subItemVal = " ";
                    curSubValName = "**del." + curSubValName;
                } else {
                    NodeList stringNL = subItem.getElementsByTagName("string");
                    if (stringNL.getLength() == 1) {
                        Element curStr = (Element)stringNL.item(0);
                        subItemValType = 1;
                        subItemVal = curStr.getTextContent();
                    } else {
                        System.out.println("*****new items (other than decimal/delete/string) in item of a boolElem in trueList/falseList in polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName + " trueOrFalse: " + trueOrFalse);
                        throw new Exception("new items (other than decimal/delete/string) in item of a boolElem in trueList/falseList in polName: " + curRegSettingPolName + " in fileName: " + curRegSettingFileName + " trueOrFalse: " + trueOrFalse);
                    }
                }
            }
            Long configId = GPODbData.getTrueFalseListItemConfigId(curSubRegKey, curSubValName, subItemValType, subItemVal);
            Long mappingId = GPODbData.getUvhid("RegSettingBoolValMapping", "MAPPING_ID");
            StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)mappingId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)valNameId.toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)("" + trueOrFalse)));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)configId.toString()));
            regSettingBoolValMappingRows.add(tableString.toString());
        }
    }

    public static Long getTrueFalseListItemConfigId(String curSubRegKey, String curSubValName, int subItemValType, String subItemVal) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"RegSettingBoolValConfig", (String)"KEY_PATH"), (Object)curSubRegKey, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingBoolValConfig", (String)"VAL_NAME"), (Object)curSubValName, 0));
        crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingBoolValConfig", (String)"DATA_TYPE"), (Object)subItemValType, 0));
        Iterator iter = dataObjConfig.getRows("RegSettingBoolValConfig", crit = crit.and(new Criteria(Column.getColumn((String)"RegSettingBoolValConfig", (String)"VALUE"), (Object)subItemVal, 0)));
        if (iter.hasNext()) {
            Row r = (Row)iter.next();
            return (Long)r.get("CONFIG_ID");
        }
        Long configId = GPODbData.getUvhid("RegSettingBoolValConfig", "CONFIG_ID");
        Row curRegSettingBoolValConfigRow = new Row("RegSettingBoolValConfig");
        curRegSettingBoolValConfigRow.set("CONFIG_ID", (Object)configId);
        curRegSettingBoolValConfigRow.set("KEY_PATH", (Object)curSubRegKey);
        curRegSettingBoolValConfigRow.set("VAL_NAME", (Object)curSubValName);
        curRegSettingBoolValConfigRow.set("DATA_TYPE", (Object)subItemValType);
        curRegSettingBoolValConfigRow.set("VALUE", (Object)subItemVal);
        dataObjConfig.addRow(curRegSettingBoolValConfigRow);
        return configId;
    }

    public static Properties getParentDetails(Element catElem, String catFileName, Element catDocElem, String obj, Long currentCompAdminTempFolId, Long currentUserAdminTempFolId, String domainName) throws Exception {
        Properties folderProps = userFolderProps;
        Long parentId = currentUserAdminTempFolId;
        if (obj.equalsIgnoreCase("Machine")) {
            folderProps = computerFolderProps;
            parentId = currentCompAdminTempFolId;
        }
        ArrayList<Properties> catElementProps = new ArrayList<Properties>();
        Properties catElemProp = new Properties();
        catElemProp.put("catElem", catElem);
        catElemProp.put("catFileName", catFileName);
        catElemProp.put("catDocElem", catDocElem);
        catElementProps.add(catElemProp);
        NodeList parCatOfCatElemList = catElem.getElementsByTagName("parentCategory");
        while (parCatOfCatElemList != null && parCatOfCatElemList.getLength() > 0) {
            String refAttr;
            Element parCatOfCatElem = (Element)parCatOfCatElemList.item(0);
            String parInfo = refAttr = parCatOfCatElem.getAttribute("ref");
            if (refAttr.contains(":")) {
                String parNameSpace;
                String parPrefix = refAttr.substring(0, refAttr.indexOf(":"));
                parInfo = refAttr.substring(refAttr.indexOf(":") + 1).trim();
                Element usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/using[@prefix='" + parPrefix + "']", catDocElem, XPathConstants.NODE);
                if (usingElement == null) {
                    usingElement = (Element)xpath.evaluate("/policyDefinitions/policyNamespaces/target[@prefix='" + parPrefix + "']", catDocElem, XPathConstants.NODE);
                }
                if (nameSpaceVsFileNames.get(parNameSpace = usingElement.getAttribute("namespace")) == null) break;
                catFileName = (String)nameSpaceVsFileNames.get(parNameSpace);
                catDocElem = (Element)nameSpaceVsDocElements.get(parNameSpace);
            }
            catElem = (Element)xpath.evaluate("//category[@name='" + parInfo + "']", catDocElem, XPathConstants.NODE);
            catElemProp = new Properties();
            catElemProp.put("catElem", catElem);
            catElemProp.put("catFileName", catFileName);
            catElemProp.put("catDocElem", catDocElem);
            catElementProps.add(catElemProp);
            parCatOfCatElemList = catElem.getElementsByTagName("parentCategory");
        }
        int size = catElementProps.size();
        String path = "";
        String i18nKeyPath = "";
        String folderNameI18nKey = "";
        for (int z = size - 1; z >= 0; --z) {
            Properties curCatElemProp = (Properties)catElementProps.get(z);
            Element curCatElem = (Element)curCatElemProp.get("catElem");
            String curCatFileName = (String)curCatElemProp.get("catFileName");
            String curCatName = curCatElem.getAttribute("name");
            path = path + "\\" + curCatName;
            String curCatDispName = curCatElem.getAttribute("displayName");
            curCatDispName = curCatDispName.substring(curCatDispName.indexOf(".") + 1, curCatDispName.length() - 1);
            if (folderProps.get(path) != null) continue;
            Properties curFolderProps = new Properties();
            folderProps.put(path, curFolderProps);
            curFolderProps.put("id", nextFolderId);
            curFolderProps.put("path", path);
            i18nKeyPath = path.substring(1);
            i18nKeyPath = i18nKeyPath.replace("\\", "_");
            i18nKeyPath = "admp.gpo_mgmt.path." + i18nKeyPath + "_" + ++curMaxLinesInPropFiles;
            curFolderProps.put("i18nKeyPath", i18nKeyPath);
            folderNameI18nKey = path.substring(1);
            folderNameI18nKey = folderNameI18nKey.replace("\\", "_");
            folderNameI18nKey = "admp.gpo_mgmt.fol_name." + folderNameI18nKey + "_" + ++curMaxLinesInPropFiles;
            curFolderProps.put("i18nFolderName", folderNameI18nKey);
            nextFolderId = nextFolderId + 1L;
            Properties folderNameInAllLangs = new Properties();
            Properties folderPathInAllLangs = new Properties();
            curFolderProps.put("folderNameInAllLangs", folderNameInAllLangs);
            curFolderProps.put("folderPathInAllLangs", folderPathInAllLangs);
            Properties admlDocProps = (Properties)filenameVsAdmlDocProps.get(curCatFileName);
            for (int y = 0; y < langs.length; ++y) {
                String curLang = langs[y];
                Element curLangDocElement = (Element)admlDocProps.get(curLang);
                String curLangFolName = (String)xpath.evaluate("//string[@id='" + curCatDispName + "']", curLangDocElement, XPathConstants.STRING);
                if (curLangFolName.equals("")) {
                    System.out.println("issue:: curLang: " + curLang + " and curCatDispName: " + curCatDispName + " and curCatFileName: " + curCatFileName);
                    return null;
                }
                folderNameInAllLangs.put(curLang, curLangFolName);
                Properties curLangFolNamePropKeys = (Properties)folderNameProps.get(curLang);
                Properties curLangRegSettingPathPropKeys = (Properties)regSettingPathProps.get(curLang);
                curLangFolNamePropKeys.put(folderNameI18nKey, curLangFolName);
                if (z == size - 1) {
                    folderPathInAllLangs.put(curLang, "\\" + curLangFolName);
                    curLangRegSettingPathPropKeys.put(i18nKeyPath, "\\" + curLangFolName);
                    curFolderProps.put("parentId", parentId);
                    continue;
                }
                String parentFolderPath = path.substring(0, path.lastIndexOf("\\"));
                Properties parentFolderProps = (Properties)folderProps.get(parentFolderPath);
                Properties parFolderPathInAllLangs = (Properties)parentFolderProps.get("folderPathInAllLangs");
                String parFolderPathInCurLang = (String)parFolderPathInAllLangs.get(curLang);
                folderPathInAllLangs.put(curLang, parFolderPathInCurLang + "\\" + curLangFolName);
                curLangRegSettingPathPropKeys.put(i18nKeyPath, parFolderPathInCurLang + "\\" + curLangFolName);
                curFolderProps.put("parentId", parentFolderProps.get("id"));
            }
            StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)curFolderProps.get("id").toString()));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)folderNameI18nKey));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)curFolderProps.get("parentId").toString()));
            if (obj.equalsIgnoreCase("user")) {
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
            } else {
                tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"1"));
            }
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)"0"));
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)domainName));
            parentRows.add(tableString.toString());
        }
        return (Properties)folderProps.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getUvhid(String tableName, String colName) {
        DataSet dataSet = null;
        Connection connection = null;
        Long curUvh = null;
        try {
            if (uvhIds.get(tableName + "_" + colName) == null) {
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)colName).maximum());
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                dataSet = relAPI.executeQuery((Query)sq, connection);
                if (dataSet.next()) {
                    if (dataSet.getValue(1) != null) {
                        curUvh = (Long)dataSet.getValue(1) + 10L;
                        uvhIds.put(tableName + "_" + colName, curUvh);
                    } else {
                        uvhIds.put(tableName + "_" + colName, (Object)10L);
                    }
                } else {
                    uvhIds.put(tableName + "_" + colName, (Object)10L);
                }
            }
            curUvh = (Long)uvhIds.get(tableName + "_" + colName);
            curUvh = curUvh + 1L;
            uvhIds.put(tableName + "_" + colName, curUvh);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return curUvh;
    }

    public static String getKeyFromValue(Map hm, Object value) {
        for (Object o : hm.keySet()) {
            if (!hm.get(o).equals(value)) continue;
            return o.toString();
        }
        return null;
    }

    public static String[] finder(String dirName, final String type) {
        File dir = new File(dirName);
        return dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith("." + type);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFromFileToDB(ArrayList<String> rows, String fileName, String tableName, List<String> columns) throws Exception {
        if (rows.size() > 0) {
            boolean del;
            File file = new File(fileName);
            String filePath = file.getCanonicalPath();
            filePath = filePath.replace('\\', '/');
            FileOutputStream fStream = null;
            OutputStreamWriter oStreamWriter = null;
            PrintWriter writer = null;
            try {
                fStream = new FileOutputStream(file, false);
                oStreamWriter = new OutputStreamWriter((OutputStream)fStream, QueueUtil.getFileEncoding());
                writer = new PrintWriter((Writer)oStreamWriter, false);
                for (int i = 0; i < rows.size(); ++i) {
                    String curRow = rows.get(i);
                    writer.println(curRow);
                }
            }
            finally {
                writer.flush();
                writer.close();
                oStreamWriter.close();
                fStream.close();
            }
            String columnOrder = GPODbData.getColumnOrder(columns);
            QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
            String sql = queryGen.loadDataQuery(tableName, columnOrder, filePath, queryGen.getFieldDelimiter(), "\r\n", "\"", null);
            if (file.exists() && !(del = file.delete())) {
                System.out.println("unable to delete file:: " + fileName);
            }
        }
    }

    private static String getColumnOrder(List<String> columns) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(columns.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

