/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs;

import com.adventnet.sym.adsm.common.webclient.graphs.DataSetProducer;
import com.adventnet.sym.adsm.common.webclient.graphs.GraphCustomization;
import com.adventnet.sym.adsm.common.webclient.graphs.ToolTipGenerator;
import com.adventnet.sym.adsm.common.webclient.graphs.URLGenerator;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import java.io.File;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.json.JSONObject;

public class GraphGenerator
implements ComponentGenerator {
    private String imageUrl = null;
    private String imageFormat = "png";
    private String tmpFolder = "charts";

    public void setTempFolder(String tmpFolder) {
        this.tmpFolder = tmpFolder;
    }

    public void setImageFormat(String format) {
        this.imageFormat = format;
    }

    private String getImageLocation() throws Exception {
        this.imageUrl = new String(".." + File.separator + "webapps" + File.separator + "adsm" + File.separator + this.tmpFolder);
        File dir = new File(this.imageUrl);
        try {
            boolean check;
            if (!dir.exists() && !(check = dir.mkdir())) {
                throw new Exception("Folder Cannot Created:\n Possible Errors:1. User not having permission to create folder.\n 2. No space to create new folder. ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.imageUrl;
    }

    public JSONObject generate(JSONObject dataModel, ADSResourceBundle ... rb) throws Exception {
        JSONObject imageDetails = new JSONObject();
        JFreeChart chart = null;
        DataSetProducer dataSetProducer = new DataSetProducer();
        try {
            CategoryPlot plot;
            PieDataset ds;
            JSONObject graphModel = dataModel.getJSONObject("GRAPH_MODEL");
            String graphType = graphModel.getString("GRAPH_TYPE");
            String imageLocation = this.getImageLocation();
            boolean enableToolTip = Boolean.parseBoolean(graphModel.getString("ENABLE_TOOLTIP"));
            boolean enableUrl = Boolean.parseBoolean(graphModel.getString("ENABLE_URL"));
            boolean enableLabel = Boolean.parseBoolean(graphModel.getString("ENABLE_LABEL"));
            if (graphType.equals("Pie")) {
                ds = dataSetProducer.producePieDataset(dataModel);
                chart = ChartFactory.createPieChart3D((String)graphModel.getString("GRAPH_TITLE"), (PieDataset)ds, (boolean)false, (boolean)enableToolTip, (boolean)enableUrl);
                GraphCustomization.customizePieCharts(chart);
                PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
                piePlot3D.setLabelGenerator((PieSectionLabelGenerator)(enableLabel ? new StandardPieSectionLabelGenerator() : null));
                piePlot3D.setToolTipGenerator((PieToolTipGenerator)new ToolTipGenerator());
                piePlot3D.setURLGenerator((PieURLGenerator)new URLGenerator(dataModel));
            } else if (graphType.equals("Bar")) {
                ds = dataSetProducer.produceBarDataset(dataModel);
                chart = ChartFactory.createBarChart3D((String)graphModel.getString("GRAPH_TITLE"), (String)graphModel.getString("X_AXIS_LABEL"), (String)graphModel.getString("Y_AXIS_LABEL"), (CategoryDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)enableToolTip, (boolean)enableUrl);
                GraphCustomization.customizeBarCharts(chart);
                plot = chart.getCategoryPlot();
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
                renderer.setToolTipGenerator((CategoryToolTipGenerator)new ToolTipGenerator());
                renderer.setItemURLGenerator((CategoryURLGenerator)new URLGenerator(dataModel));
            } else if (graphType.equals("HorizontalBar")) {
                ds = dataSetProducer.produceBarDataset(dataModel);
                chart = ChartFactory.createBarChart3D((String)graphModel.getString("GRAPH_TITLE"), (String)graphModel.getString("X_AXIS_LABEL"), (String)graphModel.getString("Y_AXIS_LABEL"), (CategoryDataset)ds, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)enableToolTip, (boolean)enableUrl);
                GraphCustomization.customizeBarCharts(chart);
                plot = chart.getCategoryPlot();
                BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
                renderer.setToolTipGenerator((CategoryToolTipGenerator)new ToolTipGenerator());
                renderer.setItemURLGenerator((CategoryURLGenerator)new URLGenerator(dataModel));
            }
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            String chartName = graphModel.getString("GRAPH_NAME") + "_" + graphType + "_" + graphModel.getString("DOMAIN_NAME") + "_" + graphModel.getString("DURATION") + "." + this.imageFormat;
            File imageFile = new File(imageLocation + File.separator + chartName);
            if (imageFile.exists() && !imageFile.getCanonicalPath().endsWith(imageFile.getName())) {
                System.out.println("Deleting file if it already exist with same name(with some letters in upper or lower case)");
                imageFile.delete();
            }
            int width = graphModel.getInt("WIDTH");
            int height = graphModel.getInt("HEIGHT");
            if (this.imageFormat.equalsIgnoreCase("jpg") || this.imageFormat.equalsIgnoreCase("jpeg")) {
                ChartUtilities.saveChartAsJPEG((File)imageFile, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
            } else if (this.imageFormat.equalsIgnoreCase("png")) {
                ChartUtilities.saveChartAsPNG((File)imageFile, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
            }
            if (enableToolTip) {
                String imageMap = ImageMapUtilities.getImageMap((String)chartName, (ChartRenderingInfo)info);
                imageDetails.put("IMAGE_TOOLTIP", (Object)imageMap);
            }
            imageDetails.put("IMAGE_NAME", (Object)chartName);
            imageDetails.put("IMAGE_SRC", (Object)(this.tmpFolder + "/" + chartName));
            imageDetails.put("LEGEND_ITEM", (Object)dataModel.getJSONObject("GRAPH_DATA"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return imageDetails;
    }
}

