/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.groups.GroupMgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CSVGroupsListener
extends CSVUserListener {
    AdventNetResourceBundle rb = null;
    private String containerName = null;
    private ArrayList attributeList = null;
    private ArrayList resultAttributeList = null;
    protected Hashtable groupTypeProps = null;

    public CSVGroupsListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        super(loginId, ids, domainVsIds, groupList);
    }

    public void addGroups(HttpServletRequest request) {
        Action action = new Action(this, request);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void init(Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName, String container, Hashtable groupTypeProps, ArrayList attributeList, ArrayList resultAttributeList) {
        this.userCreationID = userCreationID;
        this.domainName = domainName;
        this.userDetailsList = userDetailsList;
        this.keyLdapName = keyLdapName;
        this.containerName = container;
        this.groupTypeProps = groupTypeProps;
        this.attributeList = attributeList;
        this.resultAttributeList = resultAttributeList;
        this.reportId = 5004;
    }

    @Override
    protected void reloadUI() {
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='CSVGroups.do?methodToCall=bulkGroup&selectedTab=admin&operation=ShowResult'</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private CSVGroupsListener modifyUserListener;
        private String hostId;
        private Long loginId;

        public Action(CSVGroupsListener modifyUserListener, HttpServletRequest request) {
            HttpSession session = request.getSession();
            this.modifyUserListener = modifyUserListener;
            this.hostId = request.getRemoteHost();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)CSVGroupsListener.this.reportId, (DataObject)auditDataObj, (ArrayList)CSVGroupsListener.this.attributeList, (AdventNetResourceBundle)CSVGroupsListener.this.rb);
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                audit_info.put("audit_id", audit_id);
                boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"groupMgmt");
                Hashtable customAttributesList = AddUserHandler.getInstance().getCustomAttributesList(CSVGroupsListener.this.userCreationID);
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)CSVGroupsListener.this.domainName);
                for (Hashtable hashtable : CSVGroupsListener.this.userDetailsList) {
                    String container;
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    if (CSVGroupsListener.this.groupTypeProps != null && !CSVGroupsListener.this.groupTypeProps.isEmpty()) {
                        valuesList.add(CSVGroupsListener.this.groupTypeProps);
                    }
                    ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
                    ArrayList customList = new ArrayList();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    ArrayList<String> crossForestMembersList = new ArrayList<String>();
                    Properties props = new Properties();
                    CSVGroupsListener.this.getProperties("create", (ArrayList<Hashtable>)valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, crossForestMembersList, props, "Group");
                    String groupName = "";
                    if (props.getProperty("groupName") != null) {
                        groupName = props.getProperty("userName");
                    }
                    if (groupName.equalsIgnoreCase("") && props.get("displayName") != null) {
                        groupName = props.getProperty("displayName");
                    }
                    if (groupName.equalsIgnoreCase("") && props.get("samAccountName") != null) {
                        groupName = props.getProperty("samAccountName");
                    }
                    if (props.getProperty("userName") != null) {
                        groupName = props.getProperty("userName");
                    }
                    if (groupName.equalsIgnoreCase("") && props.get("samAccountName") != null) {
                        groupName = props.getProperty("samAccountName");
                    }
                    if ((container = (String)props.get("OUName")) != null) {
                        CSVGroupsListener.this.containerName = container;
                    }
                    if (!objectOUList.contains(CSVGroupsListener.this.containerName)) {
                        objectOUList.add(CSVGroupsListener.this.containerName);
                    }
                    groupName = CommonUtil.escapeString((String)groupName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
                    String adminGroup = null;
                    String mailAlias = null;
                    boolean ex2007 = false;
                    if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                        adminGroup = props.getProperty("adminGroup");
                    }
                    if (props.get("mailAlias") != null) {
                        mailAlias = props.getProperty("mailAlias");
                    }
                    if (adminGroup != null) {
                        ex2007 = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                    }
                    Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
                    mgmtLog.log(Level.FINE, "Bulk User modification Custom Attributes : " + nameVsValues);
                    if (nameVsValues != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            String attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            for (int i = 0; i < CSVGroupsListener.this.attributeList.size(); ++i) {
                                Hashtable attribHash = (Hashtable)CSVGroupsListener.this.attributeList.get(i);
                                String attribName = (String)attribHash.get("ATTRIB_COLUMN_NAME");
                                if (!attribName.equalsIgnoreCase(attributeName)) continue;
                                attributeName = (String)attribHash.get("ATTRIB_LDAP_NAME");
                            }
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", 1L);
                            if (values != null && values.size() > 1) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (Object string : values) {
                                    list.add(string.toString().trim());
                                }
                                customTable.put("ATTRIB_VALUE", list);
                                customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            } else if (values != null && values.size() == 1) {
                                customTable.put("ATTRIB_VALUE", values.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", "");
                            }
                            customList.add(customTable);
                        }
                    }
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    logProps.put("domainName", CSVGroupsListener.this.domainName);
                    logProps.put("userName", groupName);
                    logProps.put("propList", propList);
                    logProps.put("customList", customList);
                    logProps.put("modifyList", modifyList);
                    logProps.put("tsList", tsList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    logProps.put("groupList", groupList);
                    logProps.put("crossForestMembersList", crossForestMembersList);
                    ArrayList<Hashtable> nonExchPropList = new ArrayList<Hashtable>();
                    GroupMgmtUtil.getNonExchPropList(propList, nonExchPropList);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (Long)userIndex, (String)groupName, (String)CSVGroupsListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("user_index", userIndex);
                    if (props.get("manager") != null) {
                        Hashtable<String, String> userVsmanager = new Hashtable<String, String>();
                        userVsmanager.put("manager", props.get("manager").toString());
                        resultList.put(groupName, userVsmanager);
                    }
                    if (CSVGroupsListener.this.stop) break;
                    if (!isLicenseExceeded) {
                        NativeError error = new NativeError();
                        error = !ex2007 ? ADHandler.addGroup((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String)CSVGroupsListener.this.containerName, (String)groupName, propList, groupList) : ADHandler.addGroup((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String)CSVGroupsListener.this.containerName, (String)groupName, nonExchPropList, groupList);
                        Properties statusProps = GroupErrorHandler.getBulkGroupErrorMessage(CSVGroupsListener.this.domainName, groupList, error, groupName, CSVGroupsListener.this.containerName, CSVGroupsListener.this.rb);
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        statusProps.put("USER_INDEX", userIndex);
                        String creationStatus = statusProps.getProperty("CREATION_STATUS");
                        String creationMessage = statusProps.getProperty("CREATION_MESSAGE");
                        statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(CSVGroupsListener.this.rb.getString(creationMessage), new String("")));
                        statusProps.setProperty("CREATION_STATUS", CSVGroupsListener.this.rb.getString(creationStatus));
                        String distinguishedName = "cn=" + groupName + "," + CSVGroupsListener.this.containerName;
                        String searchString = "(&(objectCategory=Group)(objectClass=group)(cn=" + CommonUtil.escapeSpecialCharacters((String)groupName) + "))";
                        if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                            String managerDN;
                            NativeError errHandler;
                            String errorMsg;
                            if (!crossForestMembersList.isEmpty() && (errorMsg = CSVGroupsListener.this.getCrossForestErrorMsg(errHandler = ADHandler.addCrossForestMembers((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String)distinguishedName, crossForestMembersList), distinguishedName, CSVGroupsListener.this.rb)) != null) {
                                statusProps.setProperty("CREATION_STATUS", "WARNING");
                                StringBuilder messageBuilder = new StringBuilder();
                                if (statusProps.getProperty("CREATION_MESSAGE") != null) {
                                    messageBuilder.append(statusProps.getProperty("CREATION_MESSAGE"));
                                }
                                messageBuilder.append(errorMsg);
                                statusProps.setProperty("CREATION_MESSAGE", messageBuilder.toString());
                                statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                            }
                            if (ex2007) {
                                String exchErrMessage = "";
                                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)CSVGroupsListener.this.domainName, (String)adminGroup, (Long)this.loginId);
                                if (mailAlias != null) {
                                    exchErrMessage = ADHandler.createDistributionGroup2007((String)CSVGroupsListener.this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailAlias, (Properties)exchangeServerDetails);
                                }
                                NativeError modifyExchPropError = ADHandler.searchAndModifyGroup((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String)CSVGroupsListener.this.containerName, (String)searchString, null, propList, null, (boolean)false);
                                Properties exchStatusProps = GroupErrorHandler.getBulkGroupErrorMessage(CSVGroupsListener.this.domainName, groupList, modifyExchPropError, searchString, CSVGroupsListener.this.containerName, CSVGroupsListener.this.rb);
                                String exchCreationStatus = CSVGroupsListener.this.rb.getString(exchStatusProps.getProperty("CREATION_STATUS"));
                                if (exchCreationStatus.equalsIgnoreCase("SEVERE") || exchCreationStatus.equalsIgnoreCase("WARNING")) {
                                    statusProps.setProperty("CREATION_STATUS", "WARNING");
                                    statusProps.setProperty("CREATION_MESSAGE", statusProps.getProperty("CREATION_MESSAGE") + CSVGroupsListener.this.rb.getString("admp.mgmt.grp_mgmt_cre_sing_grp.statmsg.following_error_occurred") + " " + CSVGroupsListener.this.rb.getString(exchStatusProps.getProperty("CREATION_MESSAGE")));
                                }
                                if (exchErrMessage.length() != 0) {
                                    statusProps.setProperty("CREATION_MESSAGE", statusProps.getProperty("CREATION_MESSAGE") + ", " + MessageFormat.format(CSVGroupsListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.mail_enabled"), CSVGroupsListener.this.rb.getString(exchErrMessage)));
                                }
                            }
                            GroupMgmtUtil.updateGroup(CSVGroupsListener.this.domainName, CSVGroupsListener.this.containerName, searchString, this.loginId, CSVGroupsListener.this.rb);
                            String managerCanUpdateMembers = (String)props.get("managerCanUpdateMembers");
                            if (("true".equalsIgnoreCase(managerCanUpdateMembers) || "yes".equalsIgnoreCase(managerCanUpdateMembers) || "1".equalsIgnoreCase(managerCanUpdateMembers)) && (managerDN = (String)props.get("managedBy")) != null) {
                                ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
                                String sid = UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)managerDN), (String)managerDN);
                                if (sid != null) {
                                    everyOneTrusteeList.add(sid);
                                    ArrayList aceList = new ArrayList();
                                    Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
                                    aceHash.put("ACCESS_MASK", 32L);
                                    aceHash.put("PERMISSION_GUID", "{BF9679C0-0DE6-11D0-A285-00AA003049E2}");
                                    aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
                                    aceHash.put("ACE_ID", new Long(1L));
                                    aceHash.put("ACE_TYPE", 5L);
                                    aceHash.put("operation", "add");
                                    aceList.add(aceHash);
                                    try {
                                        ADHandler.delegateTemplate((String)CSVGroupsListener.this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)distinguishedName);
                                        Properties managerProp = new Properties();
                                        managerProp.put("ATTRIB_LDAP_NAME", "managerCanUpdateMembers");
                                        managerProp.put("ATTRIB_DISP_NAME", CSVGroupsListener.this.rb.getString("admp.common.attrib_disp_name.managerCanUpdateMembers"));
                                        managerProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                                        managerProp.put("ATTRIB_VALUE", "add");
                                        propList.add(managerProp);
                                    }
                                    catch (Exception e) {
                                        mgmtLog.log(Level.SEVERE, "Problem in updating managerCanUpdateMembers. Native Exception : " + e.getMessage());
                                    }
                                } else {
                                    mgmtLog.log(Level.FINE, "No sid is found for managerDN : " + managerDN);
                                }
                            }
                        }
                        if (!creationStatus.equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                            String searchName = CommonUtil.escapeSpecialCharacters((String)groupName);
                            searchString = "(&(objectClass=Group)(objectCategory=Group)(name=" + searchName + "))";
                            NativeError customError = ADHandler.searchAndModifyGroup((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String)CSVGroupsListener.this.containerName, (String)searchString, null, customList, new ArrayList(), (boolean)false);
                            AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)CSVGroupsListener.this.rb, (Properties)statusProps, (NativeError)customError, (String)searchString);
                        }
                        try {
                            if (!statusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE") && props.get("preventDeletion") != null) {
                                String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                                String value = "";
                                if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                                    value = "true";
                                    CSVGroupsListener.this.updatePreventDeletion(distinguishedName, "add");
                                    if (!rootName.equalsIgnoreCase(defaultNamingcontext)) {
                                        CSVGroupsListener.this.updateParent(rootName);
                                    }
                                } else {
                                    value = "false";
                                    CSVGroupsListener.this.updatePreventDeletion(distinguishedName, "delete");
                                }
                                Properties grpList = new Properties();
                                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                                grpList.put("ATTRIB_DISP_NAME", CSVGroupsListener.this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                grpList.put("ATTRIB_VALUE", value);
                                propList.add(grpList);
                                logProps.put("propList", propList);
                                statusProps.setProperty("CREATION_MESSAGE", CSVGroupsListener.this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                                statusProps.setProperty("CREATION_STATUS", "SUCCESS");
                                statusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            }
                        }
                        catch (Exception e) {
                            statusProps.setProperty("CREATION_MESSAGE", e.getMessage());
                            statusProps.setProperty("CREATION_STATUS", "SEVERE");
                            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        TechAuditAPI.getInstance().auditLogs(this.loginId, logProps, statusProps.getProperty("CREATION_MESSAGE"), CSVGroupsListener.this.rb.getString("admp.mgmt.grp_mgmt.cre_single_grp.mgmtname.group_creation"), CSVGroupsListener.this.rb);
                        CSVGroupsListener.this.addRow(statusProps);
                        audit_info.put("error_msg", statusProps.getProperty("CREATION_MESSAGE"));
                        if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                            auditObjectIdList.add(object_id);
                        }
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("CREATION_STATUS", "WARNING");
                        prop.setProperty("CREATION_MESSAGE", MessageFormat.format(CSVGroupsListener.this.rb.getString("admp.mgmt.grp_mgmt.cre_bulk_grps.alert.could_not_create_license_level_exceeded"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers")));
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                        prop.put("USER_INDEX", userIndex);
                        CSVGroupsListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                    }
                    mgmtLog.log(Level.INFO, "After Group Creation");
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties hdtProp = HelpdeskUtil.getHDTProp((Long)this.loginId, (AdventNetResourceBundle)CSVGroupsListener.this.rb);
                    String hdtName = hdtProp.getProperty("FULL_NAME");
                    logProps.put("technicianName", hdtName);
                    this.modifyUserListener.sendSysLogs(logProps, 5004, (String)audit_info.get("error_msg"), CSVGroupsListener.this.rb.getString("admp.ad_explorer.view_props.computer.attrib_disp_name.group_name"), CSVGroupsListener.this.rb);
                }
                this.modifyUserListener.isCompleted = true;
                CSVGroupsListener.this.updatedCount = 0;
                DomainHandler.updateDomainDatas((String)CSVGroupsListener.this.domainName, (Long)this.loginId, (String[])new String[]{"Group"}, (boolean)false);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 2;
                    CSVGroupsListener.this.triggerNotification(auditDataObj, auditObjectIdList, objectId, resultList, this.loginId, CSVGroupsListener.this.reportId, CSVGroupsListener.this.domainName, CSVGroupsListener.this.rb, this.modifyUserListener.resultAttributeList, objectOUList);
                }
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

