/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.groups.GroupMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupModificationUtil;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.EOFException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;

public class GroupMgmtAction
extends DispatchAction {
    Logger logger = Logger.getLogger("ADMangLogger");
    protected Vector headerLdapNames = new Vector();

    public ActionForward groupCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = null;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String operation = request.getParameter("operation");
            DynaValidatorForm groupBean = (DynaValidatorForm)form;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            String action = (String)groupBean.get("action");
            String domainName = (String)groupBean.get("domainName");
            Properties statusProps = new Properties();
            Long actionId = 1045L;
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, actionId);
            Hashtable initialValues = (Hashtable)groupBean.get("initialValues");
            if (!domainList.isEmpty() && !domainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
            if (request.getParameter("action") != null || operation != null && operation.equalsIgnoreCase("modify")) {
                this.initBean(groupBean);
                this.initExchangeValues(groupBean, rb);
            }
            if (operation != null) {
                groupBean.set("meMRrecipientsDNString", (Object)GroupMgmtUtil.replaceChar((String)groupBean.get("meMRrecipientsDNString")));
                this.setMailEnableAttributes(request, groupBean);
            }
            this.checkCheckBoxes(request, groupBean);
            if (operation != null) {
                if (action.length() == 0 && operation.equals("Update Group")) {
                    groupBean.set("action", (Object)"modify");
                }
                ArrayList list = GroupMgmtUtil.getNativeProps(request, groupBean);
                ArrayList exchPropList = new ArrayList();
                String createEmailAddress = (String)groupBean.get("createEmailAddress");
                Boolean ex2007 = false;
                if (createEmailAddress.equals("true") && !groupBean.get("MS_EXCH_ADMIN_GROUP").equals("0")) {
                    exchPropList = GroupMgmtUtil.getExchPropList(groupBean, operation);
                    this.logger.log(Level.INFO, "RESULTANT ExchProp List : " + exchPropList);
                    String adminGroup = (String)groupBean.get("MS_EXCH_ADMIN_GROUP");
                    if (adminGroup != null) {
                        ex2007 = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                    }
                    if (!ex2007.booleanValue() || !operation.equals("Create Group")) {
                        list.addAll(exchPropList);
                    }
                }
                ArrayList<String> groupList = new ArrayList<String>();
                ArrayList memberOf = (ArrayList)groupBean.get("MEMBER_OF");
                for (int i = 0; i < memberOf.size(); ++i) {
                    Properties properties = (Properties)memberOf.get(i);
                    String groupDN = properties.getProperty("Distinguished_Name");
                    if (groupList.contains(groupDN)) continue;
                    groupList.add(groupDN);
                }
                if (operation.equals("Create Group")) {
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    String heading = rb.getString("admp.mgmt.grp_mgmt.cre_single_grp.mgmtname.group_creation");
                    try {
                        if (action.equals("add")) {
                            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)4001, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                            String groupName = request.getParameter("name");
                            String escapedString = CommonUtil.escapeString((String)groupName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
                            logProps.put("GroupName", groupName);
                            logProps.put("domainName", domainName);
                            logProps.put("container", request.getParameter("container"));
                            logProps.put("Properties", list);
                            logProps.put("exchProperties", exchPropList);
                            logProps.put("groupList", groupList);
                            this.logger.log(Level.INFO, "RESULTANT : " + domainName + " : " + request.getParameter("container") + " : " + escapedString);
                            this.logger.log(Level.INFO, "RESULTANT LISTS : " + list + " \n : GROUP - LIST : " + groupList);
                            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)groupName, (String)domainName, (DataObject)auditDataObj);
                            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                            audit_info.put("object_id", object_id);
                            NativeError errHdlr = ADHandler.addGroup((String)domainName, (Long)loginId, (String)request.getParameter("container"), (String)escapedString, (ArrayList)list, groupList);
                            statusProps = GroupErrorHandler.getBulkGroupErrorMessage(domainName, groupList, errHdlr, escapedString, request.getParameter("container"), rb);
                            request.setAttribute("Message", (Object)statusProps.getProperty("CREATION_MESSAGE"));
                            String creationMessage = statusProps.getProperty("CREATION_MESSAGE");
                            if (statusProps.getProperty("CREATION_STATUS") != null && statusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SUCCESS") || statusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("WARNING")) {
                                statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(rb.getString(creationMessage), new String(escapedString)));
                                String distinguishedName = "cn=" + escapedString + "," + request.getParameter("container");
                                String searchString = "(&(objectCategory=Group)(objectClass=group)(cn=" + CommonUtil.escapeSpecialCharacters((String)groupName) + "))";
                                if (ex2007.booleanValue()) {
                                    NativeError modifyExchPropError;
                                    Properties exchStatusProps;
                                    String exchCreationStatus;
                                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)domainName, (String)((String)groupBean.get("MS_EXCH_ADMIN_GROUP")), (Long)loginId);
                                    if (groupBean.get("ME_MAIL_ALIAS") != null) {
                                        ADHandler.createDistributionGroup2007((String)domainName, (long)loginId, (String)distinguishedName, (String)((String)groupBean.get("ME_MAIL_ALIAS")), (Properties)exchangeServerDetails);
                                    }
                                    if ((exchCreationStatus = rb.getString((exchStatusProps = GroupErrorHandler.getBulkGroupErrorMessage(domainName, groupList, modifyExchPropError = ADHandler.searchAndModifyGroup((String)domainName, (Long)loginId, (String)request.getParameter("container"), null, (String)searchString, (ArrayList)exchPropList, null, (boolean)false), searchString, request.getParameter("container"), rb)).getProperty("CREATION_STATUS"))).equalsIgnoreCase("SEVERE") || exchCreationStatus.equalsIgnoreCase("WARNING")) {
                                        statusProps.setProperty("CREATION_STATUS", "WARNING");
                                        statusProps.setProperty("CREATION_MESSAGE", rb.getString(statusProps.getProperty("CREATION_MESSAGE")) + rb.getString("admp.mgmt.grp_mgmt_cre_sing_grp.statmsg.following_error_occurred") + " " + rb.getString(exchStatusProps.getProperty("CREATION_MESSAGE")));
                                    }
                                }
                                GroupMgmtUtil.updateGroup(domainName, request.getParameter("container"), searchString, loginId, rb);
                            }
                            audit_info.put("error_msg", creationMessage);
                            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                        }
                    }
                    catch (Exception e) {
                        request.setAttribute("Message", (Object)e.getMessage());
                        statusProps.setProperty("CREATION_MESSAGE", e.getMessage());
                        e.printStackTrace();
                    }
                    request.setAttribute("statusProps", (Object)statusProps);
                    TechAuditAPI.getInstance().auditLogs(loginId, logProps, (String)request.getAttribute("CREATION_STATUS"), heading, rb);
                } else if (operation.equals("Update Group")) {
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    Hashtable initialMembers = new Hashtable();
                    String heading = rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.mgmtname.group_modification");
                    try {
                        this.logger.log(Level.INFO, "createEmailAddress value is" + createEmailAddress);
                        if (createEmailAddress.equals("true")) {
                            this.logger.log(Level.INFO, "Filling the auth and unauth values");
                            GroupModificationUtil.fillAuthUnAuthValues(list, (String)groupBean.get("meMRrecipientsDNString"), (String)groupBean.get("meMsgRestriction"), (String)groupBean.get("name"), domainName, ";", (ArrayList)groupBean.get("meMRrecipientsDNPrevList"));
                        }
                        DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)4002, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)groupBean.get("name")), (String)domainName, (DataObject)auditDataObj);
                        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                        audit_info.put("object_id", object_id);
                        ArrayList<String> toBeRemovedList = new ArrayList<String>();
                        try {
                            String valueString;
                            logProps.put("Domain Name", domainName);
                            logProps.put("Resultant List", list);
                            logProps.put("groupname", (String)groupBean.get("name"));
                            this.logger.log(Level.INFO, "RESULTANT LISTS : " + list + " \n : DOMAINNAME : " + domainName + " \n : sid : " + (String)groupBean.get("sid") + " \n : GROUP - LIST : " + groupList);
                            ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)((String)groupBean.get("sid")), (String)((String)groupBean.get("distinguishedName")), (ArrayList)list, groupList);
                            ArrayList prevGroupList = (ArrayList)groupBean.get("prevMemberOf");
                            Boolean removal = false;
                            if (prevGroupList != null) {
                                for (Properties prevGroup : prevGroupList) {
                                    removal = false;
                                    for (String existingGroup : groupList) {
                                        if (!existingGroup.equalsIgnoreCase((String)prevGroup.get("Distinguished_Name"))) continue;
                                        removal = true;
                                        break;
                                    }
                                    if (removal.booleanValue()) continue;
                                    toBeRemovedList.add((String)prevGroup.get("Distinguished_Name"));
                                }
                            }
                            ArrayList<Properties> removeList = new ArrayList<Properties>();
                            Properties removalProp = new Properties();
                            if (toBeRemovedList != null && toBeRemovedList.size() > 0) {
                                removalProp.put("ATTRIB_VALUE", (String)groupBean.get("distinguishedName"));
                                removalProp.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                removalProp.put("DATA_HANDLER_TYPE", new Long(3L));
                                removalProp.put("ATTRIB_LDAP_NAME", "member");
                                removalProp.put("DW_CONTROL_CODE", new Long(4L));
                                removeList.add(removalProp);
                                for (int i = 0; i < toBeRemovedList.size(); ++i) {
                                    String groupSid = UserMgmtUtil.getSIDFromDN((String)domainName, (String)((String)toBeRemovedList.get(i)));
                                    if (groupSid == null) continue;
                                    ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)groupSid, (String)((String)groupBean.get("distinguishedName")), removeList, null);
                                }
                            }
                            this.setManagerCanUpdateList(groupBean, loginId, initialValues);
                            initialValues.put("MANAGER", (String)groupBean.get("MANAGER"));
                            if (createEmailAddress.equals("true") && ex2007.booleanValue() && (valueString = (String)groupBean.get("ME_HIDDEN_TO_ADDRESSLISTS")) != null && !valueString.equalsIgnoreCase("")) {
                                if (valueString.equalsIgnoreCase("TRUE")) {
                                    valueString = "true";
                                }
                                String identity = (String)groupBean.get("distinguishedName");
                                String adminGroup = (String)groupBean.get("MS_EXCH_ADMIN_GROUP");
                                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)domainName, (String)adminGroup, (Long)loginId);
                                ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)identity, (String)"group", (String)valueString, (Properties)exchangeServerDetails);
                            }
                            request.setAttribute("Message", (Object)rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.statmsg.successfully_updated_group"));
                            request.setAttribute("ErrorSeverity", (Object)"success");
                            Hashtable membersList = (Hashtable)groupBean.get("membersList");
                            initialMembers = (Hashtable)groupBean.get("initialValuesTable");
                            groupBean.set("initialValuesTable", membersList.clone());
                        }
                        catch (LocalizedException le) {
                            request.setAttribute("Message", (Object)le.getMessage(rb));
                            request.setAttribute("ErrorSeverity", (Object)"Severe");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            request.setAttribute("Message", (Object)e.getMessage());
                            request.setAttribute("ErrorSeverity", (Object)"Severe");
                        }
                        if (!groupList.isEmpty()) {
                            Properties grpList = new Properties();
                            grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                            grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                            grpList.put("ATTRIB_VALUE", groupList);
                            list.add(grpList);
                        }
                        if (toBeRemovedList != null && !toBeRemovedList.isEmpty()) {
                            Properties remList = new Properties();
                            remList.put("ATTRIB_LDAP_NAME", "memberOf");
                            remList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                            remList.put("DW_CONTROL_CODE", (Object)4L);
                            remList.put("ATTRIB_VALUE", toBeRemovedList);
                            list.add(remList);
                        }
                        ArrayList<String> modifiedMembersValue = new ArrayList<String>();
                        String attrName = new String();
                        for (int index = 0; index < list.size(); ++index) {
                            Properties tempProp = (Properties)list.get(index);
                            attrName = tempProp.getProperty("ATTRIB_LDAP_NAME");
                            if (!attrName.equalsIgnoreCase("member") && !attrName.equalsIgnoreCase("memberOf")) continue;
                            String auditHeading = new String();
                            int dwControlCode = Integer.parseInt(tempProp.get("DW_CONTROL_CODE").toString());
                            if (dwControlCode == 3 || dwControlCode == 2) {
                                auditHeading = (modifiedMembersValue.isEmpty() ? "" : "<BR/>") + "<B>" + rb.getString("admp.audit.display_text.added") + "</B><br/>";
                            }
                            if (dwControlCode == 4) {
                                auditHeading = (modifiedMembersValue.isEmpty() ? "" : "<BR/>") + "<B>" + rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                            }
                            if (dwControlCode == 1) {
                                if (initialMembers.isEmpty()) {
                                    modifiedMembersValue.add(rb.getString("admp.audit.display_text.removed_all"));
                                } else {
                                    modifiedMembersValue.add("<B>" + rb.getString("admp.audit.display_text.removed") + "</B><BR/>");
                                    Enumeration tempIter = initialMembers.keys();
                                    while (tempIter.hasMoreElements()) {
                                        String str = (String)tempIter.nextElement();
                                        modifiedMembersValue.add(str);
                                    }
                                }
                                list.remove(index);
                                break;
                            }
                            modifiedMembersValue.add(auditHeading);
                            ArrayList valuesArray = new ArrayList();
                            int count = Integer.parseInt(tempProp.get("ATTRIB_VALUE_COUNT").toString());
                            if (count > 1) {
                                valuesArray = (ArrayList)tempProp.get("ATTRIB_VALUE");
                            } else if (tempProp.getProperty("ATTRIB_VALUE").length() != 0) {
                                String singleMember = tempProp.getProperty("ATTRIB_VALUE");
                                valuesArray.add(singleMember);
                            }
                            for (String values : valuesArray) {
                                modifiedMembersValue.add(values);
                            }
                            if (dwControlCode == 2) {
                                modifiedMembersValue.add("<BR/><B>" + rb.getString("admp.audit.display_text.removed_all") + "</B>");
                            }
                            list.remove(index);
                            --index;
                        }
                        if (!modifiedMembersValue.isEmpty()) {
                            Properties membersList = new Properties();
                            membersList.put("ATTRIB_LDAP_NAME", attrName);
                            membersList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                            membersList.put("ATTRIB_VALUE", modifiedMembersValue);
                            list.add(membersList);
                        }
                        TechAuditAPI.getInstance().auditGroupModification(loginId, rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.mgmtname.mod_sing_group"), (String)groupBean.get("name"), domainName, list, (String)request.getAttribute("Message"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                        audit_info.put("error_msg", (String)request.getAttribute("Message"));
                        HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (operation.equals("Remove")) {
                    String[] members = request.getParameterValues("members");
                    for (int i = 0; i < members.length; ++i) {
                        Hashtable membersList = (Hashtable)groupBean.get("membersList");
                        membersList.remove(members[i]);
                    }
                } else if (operation.equals("modify")) {
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID);
                    String groupName = request.getParameter("name");
                    groupBean.set("sid", (Object)request.getParameter("sid"));
                    groupBean.set("name", (Object)request.getParameter("name"));
                    groupBean.set("distinguishedName", (Object)request.getParameter("distinguishedName"));
                    String escapedString = CommonUtil.escapeSpecialCharacters((String)groupName);
                    String searchString = "(&(objectCategory=Group)(objectClass=group)(cn=" + escapedString + "))";
                    ArrayList attributeList = this.getAttributeList();
                    for (int k = 0; k < attributeList.size(); ++k) {
                        if (!((String)attributeList.get(k)).equalsIgnoreCase("member")) continue;
                        attributeList.remove(k);
                        --k;
                    }
                    this.logger.log(Level.INFO, " domainDetails.getProperty : " + domainDetails.getProperty("DEFAULT_NAMING_CONTEXT") + " : attributeList : " + attributeList + " : searchString : " + searchString);
                    attributeList.add("primaryGroupToken");
                    ArrayList grouplist = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), (ArrayList)attributeList, (String)searchString);
                    this.logger.log(Level.INFO, "RESULTANT LISTS : " + grouplist);
                    Properties props = (Properties)grouplist.get(0);
                    if (props.get("dLMemSubmitPerms") != null) {
                        groupBean.set("meMRrecipientsDNPrevList", props.get("dLMemSubmitPerms"));
                    } else if (props.get("dLMemRejectPerms") != null) {
                        groupBean.set("meMRrecipientsDNPrevList", props.get("dLMemRejectPerms"));
                    } else {
                        groupBean.set("meMRrecipientsDNPrevList", new ArrayList());
                    }
                    GroupModificationUtil.setGroupProps(grouplist, groupBean);
                    initialValues.put("MANAGER", (String)groupBean.get("MANAGER"));
                    groupBean.set("managerCanUpdateList", (Object)this.getManagerCanUpdateList(domainName, loginId, (String)groupBean.get("distinguishedName"), (String)groupBean.get("MANAGER")));
                }
            }
            Properties properties = null;
            if (domainName.equals("") || domainName.equalsIgnoreCase("All Domains")) {
                properties = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = properties.getProperty("DOMAIN_NAME");
            } else {
                properties = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            groupBean.set("domainName", (Object)domainName);
            String previousDomainName = (String)groupBean.get("previousDomainName");
            if (!previousDomainName.equals(domainName) || domainName.equals("") || domainName.equalsIgnoreCase("All Domains")) {
                this.initBean(groupBean);
                ArrayList MEMBER_OF = (ArrayList)groupBean.get("MEMBER_OF");
                ArrayList groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)properties.getProperty("DEFAULT_NAMING_CONTEXT"));
                groupBean.set("userCreationGroupList", (Object)groupList);
                groupBean.set("MEMBER_OF", (Object)MEMBER_OF);
                this.initExchangeValues(groupBean, rb);
                groupBean.set("previousDomainName", (Object)domainName);
            }
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = null;
            containerName = ((String)groupBean.get("container")).equalsIgnoreCase("") ? "CN=Users," + properties.getProperty("DEFAULT_NAMING_CONTEXT") : (String)groupBean.get("container");
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            groupBean.set("container", (Object)containerName);
            groupBean.set("containerStr", groupBean.get("container"));
            session.setAttribute("userCreationDomain", (Object)domainName);
            forwardPage = action.equals("add") ? "groupCreation" : "groupModification";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public void setManagerCanUpdateList(DynaValidatorForm groupBean, Long loginId, Hashtable initialValues) {
        String managerDN = (String)groupBean.get("MANAGER");
        String distinguishedName = (String)groupBean.get("distinguishedName");
        String managerCanUpdateList = (String)groupBean.get("managerCanUpdateList");
        String domainName = (String)groupBean.get("domainName");
        String prevManager = (String)initialValues.get("MANAGER");
        boolean checkManagerUpdate = false;
        try {
            if (managerDN != null) {
                ArrayList<String> managerList = new ArrayList<String>();
                managerList.add(UserMgmtUtil.getSIDFromDNGeneral((String)managerDN));
                ArrayList aceList = new ArrayList();
                Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
                aceHash.put("ACCESS_MASK", 32L);
                aceHash.put("PERMISSION_GUID", "{BF9679C0-0DE6-11D0-A285-00AA003049E2}");
                aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
                aceHash.put("ACE_ID", new Long(1L));
                aceHash.put("ACE_TYPE", 5L);
                aceList.add(aceHash);
                if (prevManager != null && !prevManager.equals("") && !prevManager.equals(managerDN)) {
                    aceHash.put("operation", "delete");
                    ArrayList<String> removeManagerList = new ArrayList<String>();
                    removeManagerList.add(UserMgmtUtil.getSIDFromDNGeneral((String)prevManager));
                    if (removeManagerList.get(0) != null) {
                        ADHandler.delegateTemplate((String)domainName, (Long)loginId, aceList, removeManagerList, (String)distinguishedName);
                    }
                }
                if ("on".equalsIgnoreCase(managerCanUpdateList)) {
                    aceHash.put("operation", "add");
                } else {
                    aceHash.put("operation", "delete");
                    checkManagerUpdate = true;
                }
                if (!(managerDN == null || managerDN.equals("") || managerList.get(0) == null || !prevManager.equals(managerDN) && checkManagerUpdate)) {
                    ADHandler.delegateTemplate((String)domainName, (Long)loginId, aceList, managerList, (String)distinguishedName);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getManagerCanUpdateList(String domainName, Long loginId, String distinguishedName, String managerDN) {
        String returnValue = "false";
        try {
            Properties aclProp = ADHandler.getACLsFromDNWithoutLookup((String)domainName, (Long)loginId, (String)distinguishedName);
            if (aclProp != null) {
                ArrayList aceList = (ArrayList)aclProp.get("acls");
                String[] trusteeToFilter = new String[]{UserMgmtUtil.getSIDFromDNGeneral((String)managerDN)};
                if (aceList != null && !aceList.isEmpty()) {
                    for (int index = 0; index < aceList.size(); ++index) {
                        Properties aceProps = (Properties)aceList.get(index);
                        String trusteeSid = (String)aceProps.get("sid");
                        if (trusteeSid == null || !Arrays.asList(trusteeToFilter).contains(trusteeSid)) continue;
                        String objectTypeGUID = (String)aceProps.get("objectTypeGUID");
                        String aceType = (String)aceProps.get("aceType");
                        String accessMask = (String)aceProps.get("accessMask");
                        if (objectTypeGUID == null || aceType.equalsIgnoreCase("admp.common.native.permissions.accesstype_deny") || !objectTypeGUID.equalsIgnoreCase("{BF9679C0-0DE6-11D0-A285-00AA003049E2}") || !accessMask.equalsIgnoreCase("48") && !accessMask.equalsIgnoreCase("32") && !accessMask.equalsIgnoreCase("16")) continue;
                        returnValue = "true";
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return returnValue;
    }

    public ArrayList getAttributeList() {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        Integer reportId = new Integer(108);
        ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), reportId);
            for (int j = 0; j < l.size(); ++j) {
                Properties p = (Properties)l.get(j);
                attributeList.add(p.get("ATTRIB_LDAP_NAME"));
            }
        }
        String[] exchProps = new String[]{"mailNickName", "targetAddress", "legacyExchangeDN", "displayNamePrintable", "msExchHideFromAddressLists", "delivContLength", "msExchRequireAuthToSendTo", "unauthOrig", "authOrig"};
        for (int i = 0; i < exchProps.length; ++i) {
            if (attributeList.contains(exchProps[i])) continue;
            attributeList.add(exchProps[i]);
        }
        attributeList.add("mail");
        return attributeList;
    }

    private void checkCheckBoxes(HttpServletRequest request, DynaValidatorForm bean) {
        String[] ckbxs = new String[]{"ME_HIDDEN_TO_ADDRESSLISTS", "createEmailAddress", "deleteExistingMembers", "ME_REQUIRE_AUTH", "managerCanUpdateList"};
        for (int i = 0; i < ckbxs.length; ++i) {
            if (request.getParameter(ckbxs[i]) != null) continue;
            bean.set(ckbxs[i], (Object)"FALSE");
        }
    }

    private void initExchangeValues(DynaValidatorForm groupBean, AdventNetResourceBundle rb) {
        String domainName = (String)groupBean.get("domainName");
        ArrayList mailGroupsList = new ArrayList();
        ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
        ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
        mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
        if (!mailGroupsList.isEmpty()) {
            msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
            msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
            if (msExchAdminGroupDNList.isEmpty()) {
                msExchAdminGroupDisplayList = new ArrayList<String>();
                msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.grp_mgmt.cre_single_grp.attribvalue_no_exch_admin_grps_available"));
                msExchAdminGroupDNList = new ArrayList<String>();
                msExchAdminGroupDNList.add("0");
            }
        }
        groupBean.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
        groupBean.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
    }

    private void initBean(DynaValidatorForm groupBean) {
        String[] keys = new String[]{"name", "sid", "samAccountName", "description", "mail", "info", "MANAGER", "managerText", "container", "containerStr", "ME_MAIL_ALIAS", "TARGET_ADDRESS", "MS_EXCH_ADMIN_GROUP", "ME_SIMPLE_DISPLAY_NAME", "ME_HIDDEN_TO_ADDRESSLISTS", "ME_IN_MESSAGE_SIZE", "ME_REQUIRE_AUTH", "primaryGroupToken", "LEGACY_EXCHANGE_DN"};
        for (int i = 0; i < keys.length; ++i) {
            groupBean.set(keys[i], (Object)"");
        }
        groupBean.set("membersList", new Hashtable());
        groupBean.set("csvList", new ArrayList());
        groupBean.set("validList", new ArrayList());
        groupBean.set("notExistsList", new ArrayList());
        groupBean.set("moreNosList", new ArrayList());
        groupBean.set("MEMBER_OF", new ArrayList());
        groupBean.set("REJECT_MESSAGES_FROM", new ArrayList());
        groupBean.set("ACCEPT_MESSAGES_FROM", new ArrayList());
        groupBean.set("meMRrecipientsDNList", new ArrayList());
        groupBean.set("meMRrecipientsDisplayList", new ArrayList());
        groupBean.set("hideDeleteMembers", (Object)"false");
        groupBean.set("primaryGroupIDList", new Hashtable());
        groupBean.set("initialValuesTable", new Hashtable());
    }

    public void setMailEnableAttributes(HttpServletRequest request, DynaValidatorForm groupBean) throws Exception {
        String meDelivSize;
        String createEmailAddress = (String)groupBean.get("createEmailAddress");
        if (createEmailAddress.equalsIgnoreCase("false")) {
            return;
        }
        String domainName = (String)groupBean.get("domainName");
        String meMsgRestriction = (String)groupBean.get("meMsgRestriction");
        ArrayList<Properties> ACCEPT_MESSAGES_FROM = new ArrayList<Properties>();
        ArrayList<Properties> REJECT_MESSAGES_FROM = new ArrayList<Properties>();
        if (!groupBean.get("meMRrecipientsDNString").equals("")) {
            JSONObject meMRrecipientsDNString = new JSONObject((String)groupBean.get("meMRrecipientsDNString"));
            Iterator stringTokenizer = meMRrecipientsDNString.keys();
            ArrayList<String> meMRrecipientsDNList = new ArrayList<String>();
            ArrayList<String> meMRrecipientsDisplayList = new ArrayList<String>();
            while (stringTokenizer.hasNext()) {
                Properties properties = new Properties();
                String dnString = (String)meMRrecipientsDNString.get((String)stringTokenizer.next());
                properties.setProperty("Distinguished_Name", dnString);
                if (meMsgRestriction.equalsIgnoreCase("onlyFrom")) {
                    ACCEPT_MESSAGES_FROM.add(properties);
                } else if (meMsgRestriction.equalsIgnoreCase("fromExcept")) {
                    REJECT_MESSAGES_FROM.add(properties);
                }
                if (meMRrecipientsDNList.contains(dnString)) continue;
                meMRrecipientsDNList.add(dnString);
                String dispName = UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString);
                if (dispName == null || dispName == "") {
                    meMRrecipientsDisplayList.add(dnString);
                    continue;
                }
                meMRrecipientsDisplayList.add(dispName);
            }
            groupBean.set("meMRrecipientsDNList", meMRrecipientsDNList);
            groupBean.set("meMRrecipientsDisplayList", meMRrecipientsDisplayList);
            groupBean.set("REJECT_MESSAGES_FROM", REJECT_MESSAGES_FROM);
            groupBean.set("ACCEPT_MESSAGES_FROM", ACCEPT_MESSAGES_FROM);
        }
        if ((meDelivSize = (String)groupBean.get("meDelivSize")).equals("default")) {
            groupBean.set("ME_IN_MESSAGE_SIZE", (Object)"");
        }
    }

    public ActionForward members(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm groupBean = (DynaValidatorForm)form;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String operation = request.getParameter("operation");
            if (operation != null) {
                if (operation.equals("csvImport")) {
                    this.csvImport(request, groupBean);
                    groupBean.set("validated", (Object)"false");
                } else if (operation.equalsIgnoreCase(rb.getString("groupmanagement.members.add"))) {
                    this.addMembers(request, groupBean);
                }
                request.setAttribute("operation", (Object)operation);
            } else if (request.getParameter("keyLdapName") != null) {
                groupBean.set("keyPos", (Object)this.headerLdapNames.indexOf(request.getParameter("keyLdapName")));
            }
        }
        catch (Exception e) {
            groupBean.set("csvList", new ArrayList());
            request.setAttribute("errorMessage", (Object)e.getMessage());
            e.printStackTrace();
        }
        return mapping.findForward("members");
    }

    public void addMembers(HttpServletRequest request, DynaValidatorForm groupBean) {
        Hashtable membersList = (Hashtable)groupBean.get("membersList");
        if (membersList == null) {
            membersList = new Hashtable();
            groupBean.set("membersList", membersList);
        }
        String validated = (String)groupBean.get("validated");
        String[] validSelected = request.getParameterValues("validSelected");
        ArrayList csvList = (ArrayList)groupBean.get("csvList");
        ArrayList validList = (ArrayList)groupBean.get("validList");
        ArrayList notExistsList = (ArrayList)groupBean.get("notExistsList");
        ArrayList moreNosList = (ArrayList)groupBean.get("moreNosList");
        if (validated.equalsIgnoreCase("false")) {
            validList = new ArrayList();
            notExistsList = new ArrayList();
            moreNosList = new ArrayList();
            groupBean.set("validList", validList);
            groupBean.set("notExistsList", notExistsList);
            groupBean.set("moreNosList", moreNosList);
            for (int i = 0; validSelected != null && i < validSelected.length; ++i) {
                int index = Integer.parseInt(validSelected[i]);
                Vector values = (Vector)csvList.get(index);
                this.validateAndFillList(request, groupBean, values);
            }
            if (notExistsList.size() > 0 || moreNosList.size() > 0) {
                return;
            }
        }
        String[] notExistsSelected = request.getParameterValues("notExistsSelected");
        String[] moreNosSelected = request.getParameterValues("moreNosSelected");
        this.checkInvalidList(request, groupBean, moreNosSelected, moreNosList);
        this.checkInvalidList(request, groupBean, notExistsSelected, notExistsList);
        request.setAttribute("successMessage", (Object)"added");
    }

    private void validateAndFillList(HttpServletRequest request, DynaValidatorForm groupBean, Vector values) {
        try {
            Hashtable membersList = (Hashtable)groupBean.get("membersList");
            ArrayList csvList = (ArrayList)groupBean.get("csvList");
            ArrayList validList = (ArrayList)groupBean.get("validList");
            ArrayList notExistsList = (ArrayList)groupBean.get("notExistsList");
            ArrayList moreNosList = (ArrayList)groupBean.get("moreNosList");
            String searchString = this.getSearchString(groupBean, values);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)((String)groupBean.get("membersDomainName")), (Long)loginId);
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("distinguishedName");
            attributeList.add("cn");
            ArrayList containerList = GroupMgmtAction.getContainerList(loginId, (String)groupBean.get("membersDomainName"));
            ArrayList list = null;
            for (int i = 0; i < containerList.size() && (list = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)((String)containerList.get(i)), attributeList, (String)searchString)).size() <= 0; ++i) {
            }
            if (list == null || list.size() == 0) {
                notExistsList.add(values);
            } else if (list.size() > 1) {
                moreNosList.add(values);
            } else {
                Properties p = (Properties)list.get(0);
                validList.add(values);
                membersList.put(this.getValue(p, "distinguishedName").toLowerCase(), this.getValue(p, "cn"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getContainerList(Long loginId, String domainName) {
        Properties domainDetails = new Properties();
        try {
            domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> containerList = new ArrayList<String>();
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        if (ouList.size() > 0) {
            containerList.addAll(ouList);
        } else {
            containerList.add(domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"));
        }
        return containerList;
    }

    private void checkInvalidList(HttpServletRequest request, DynaValidatorForm groupBean, String[] selectedList, ArrayList invalidList) {
        Hashtable membersList = (Hashtable)groupBean.get("membersList");
        ArrayList csvList = (ArrayList)groupBean.get("csvList");
        for (int i = 0; selectedList != null && i < selectedList.length; ++i) {
            int index = Integer.parseInt(selectedList[i]);
            this.setMembersList(request, groupBean, csvList, index);
        }
    }

    private void setMembersList(HttpServletRequest request, DynaValidatorForm groupBean, ArrayList list, int index) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable membersList = (Hashtable)groupBean.get("membersList");
            Vector values = (Vector)list.get(index);
            Integer dnPos = (Integer)groupBean.get("dnPos");
            Integer cnPos = (Integer)groupBean.get("cnPos");
            String dn = request.getParameter("dnValue" + index);
            String cn = null;
            cn = cnPos == null ? (String)values.get(0) : (String)values.get(cnPos);
            ArrayList containerList = GroupMgmtAction.getContainerList(loginId, (String)groupBean.get("membersDomainName"));
            for (int i = 0; i < containerList.size(); ++i) {
                String dns = (String)containerList.get(i);
                if (!dn.toLowerCase().endsWith(dns.toLowerCase())) continue;
                membersList.put(dn, cn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getValue(Properties p, String key) {
        ArrayList list = (ArrayList)p.get(key);
        return (String)list.get(0);
    }

    private String getSearchString(DynaValidatorForm groupBean, Vector values) {
        String s = "";
        Integer index = null;
        if (groupBean.get("keyPos") != null) {
            index = (Integer)groupBean.get("keyPos");
            s = s + "(" + groupBean.get("keyLdapName") + "=" + values.get(index) + ")";
        }
        s = "( & " + GroupMgmtUtil.getGroupTypeSearchString(groupBean) + s + " )";
        return s;
    }

    public void csvImport(HttpServletRequest request, DynaValidatorForm groupBean) throws Exception {
        try {
            FormFile formFile = (FormFile)groupBean.get("browse");
            String fileName = formFile.getFileName();
            InputStream stream = null;
            Vector headerVector = null;
            boolean headerSize = false;
            Vector valuesVector = new Vector();
            StringBuilder message = new StringBuilder();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (fileName != null) {
                try {
                    stream = formFile.getInputStream();
                }
                catch (Exception e) {
                    message.append(e.getMessage());
                    request.setAttribute("importErrorMessage", (Object)message.toString());
                    return;
                }
            }
            CSVReader csvReader = new CSVReader(stream, rb);
            ArrayList<Vector> list = new ArrayList<Vector>();
            try {
                headerVector = csvReader.getAllFieldsInLine();
            }
            catch (Exception headerVectorException) {
                csvReader.close();
            }
            this.validateCSVHeader(headerVector, groupBean, rb);
            String header = (String)groupBean.get("header");
            if (header.equalsIgnoreCase("false")) {
                list.add(headerVector);
            }
            try {
                while (true) {
                    valuesVector = csvReader.getAllFieldsInLine();
                    list.add(valuesVector);
                }
            }
            catch (EOFException eofexception) {
                csvReader.close();
                groupBean.set("csvList", list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public ActionForward editGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList<Properties> availableGroups = null;
        ArrayList<Properties> newAvailibleGroups = null;
        ArrayList selectedGroups = null;
        ArrayList<Properties> tobeDeletedProps = new ArrayList<Properties>();
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        try {
            String beanName = request.getParameter("beanName");
            DynaValidatorForm userBean = (DynaValidatorForm)session.getAttribute(beanName);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties domainProps = null;
            if (domainName == null) {
                domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            } else {
                domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            ArrayList groupList = (ArrayList)userBean.get("userCreationGroupList");
            String fromModifyGroups = request.getParameter("fromModifyGroups");
            if (request.getParameter("fromModifyGroups") != null) {
                String domainDistinguidhedName = DomainUtil.getDefaultNamingContext((String)domainName);
                groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)domainDistinguidhedName);
                userBean.set("userCreationGroupList", (Object)groupList);
                if (!domainName.equalsIgnoreCase((String)userBean.get("previousDomainName"))) {
                    userBean.set("MEMBER_OF", new ArrayList());
                }
            }
            userBean.set("previousDomainName", (Object)domainName);
            String jsonMemberOf = request.getParameter("memberOfJSON");
            if (request.getParameter("groupString") != null && request.getParameter("memberOfJSON") != null) {
                JSONObject memberOfList = new JSONObject(jsonMemberOf);
                JSONObject memberOfDNList = (JSONObject)memberOfList.get("memberOf");
                ArrayList<Properties> MEMBER_OF = new ArrayList<Properties>();
                StringBuilder builder = new StringBuilder("");
                for (int i = 0; i < memberOfDNList.length(); ++i) {
                    String distinguishedName = (String)memberOfDNList.get("MEMBEROFGROUP" + i);
                    Properties properties = UserMgmtUtil.getPropertiesfromDN((String)distinguishedName, (ArrayList)groupList);
                    if (properties == null) continue;
                    MEMBER_OF.add(properties);
                    String displayName = properties.getProperty("Display_Name");
                    builder.append(displayName);
                    if (i == memberOfDNList.length() - 1) continue;
                    builder.append(", ");
                }
                userBean.set("MEMBER_OF", MEMBER_OF);
                request.setAttribute("edited", (Object)"true");
                request.setAttribute("groupString", (Object)builder.toString());
            } else {
                availableGroups = new ArrayList<Properties>();
                for (Properties properties : groupList) {
                    String distinguishedName = properties.getProperty("distinguishedName");
                    String name = properties.getProperty("name");
                    String groupType = properties.getProperty("groupType");
                    String groupScope = properties.getProperty("groupScope");
                    String groupType1 = properties.getProperty("groupType1");
                    String objectRID = properties.getProperty("objectSID");
                    objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
                    Properties properties2 = new Properties();
                    properties2.setProperty("Display_Name", name);
                    properties2.setProperty("Distinguished_Name", distinguishedName);
                    properties2.setProperty("objectRID", objectRID);
                    properties2.setProperty("groupType1", groupType1);
                    properties2.setProperty("groupScope", groupScope);
                    properties2.setProperty("groupType", groupType);
                    availableGroups.add(properties2);
                }
                selectedGroups = (ArrayList)userBean.get("MEMBER_OF");
                for (Properties properties : selectedGroups) {
                    for (Properties properties2 : availableGroups) {
                        if (!properties.equals(properties2)) continue;
                        tobeDeletedProps.add(properties2);
                    }
                }
                for (Properties properties : tobeDeletedProps) {
                    availableGroups.remove(properties);
                }
            }
            request.setAttribute("beanName", (Object)beanName);
            newAvailibleGroups = new ArrayList<Properties>();
            if (fromModifyGroups != null && fromModifyGroups.equalsIgnoreCase("true")) {
                newAvailibleGroups = availableGroups;
            }
            String GroupType = request.getParameter("groupType");
            String GroupScope = request.getParameter("groupScope");
            if (GroupScope != null && GroupScope.trim().length() != 0) {
                Properties properties3;
                String objectRID;
                String groupType1;
                String groupScope;
                String groupType;
                String name;
                if (GroupScope.equalsIgnoreCase("domainLocal")) {
                    for (Properties properties : groupList) {
                        String distinguishedName = properties.getProperty("distinguishedName");
                        name = properties.getProperty("name");
                        groupType = properties.getProperty("groupType");
                        groupScope = properties.getProperty("groupScope");
                        groupType1 = properties.getProperty("groupType1");
                        objectRID = properties.getProperty("objectSID");
                        objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
                        if (!groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.domain_local"))) continue;
                        properties3 = new Properties();
                        properties3.setProperty("Display_Name", name);
                        properties3.setProperty("Distinguished_Name", distinguishedName);
                        properties3.setProperty("objectRID", objectRID);
                        properties3.setProperty("groupType1", groupType1);
                        properties3.setProperty("groupScope", groupScope);
                        properties3.setProperty("groupType", groupType);
                        newAvailibleGroups.add(properties3);
                    }
                } else if (GroupScope.equalsIgnoreCase("global")) {
                    for (Properties properties : groupList) {
                        String distinguishedName = properties.getProperty("distinguishedName");
                        name = properties.getProperty("name");
                        groupType = properties.getProperty("groupType");
                        groupScope = properties.getProperty("groupScope");
                        groupType1 = properties.getProperty("groupType1");
                        objectRID = properties.getProperty("objectSID");
                        objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
                        if (!groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.global")) && !groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.domain_local")) && !groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.universal"))) continue;
                        properties3 = new Properties();
                        properties3.setProperty("Display_Name", name);
                        properties3.setProperty("Distinguished_Name", distinguishedName);
                        properties3.setProperty("objectRID", objectRID);
                        properties3.setProperty("groupType1", groupType1);
                        properties3.setProperty("groupScope", groupScope);
                        properties3.setProperty("groupType", groupType);
                        newAvailibleGroups.add(properties3);
                    }
                } else {
                    for (Properties properties : groupList) {
                        String distinguishedName = properties.getProperty("distinguishedName");
                        name = properties.getProperty("name");
                        groupType = properties.getProperty("groupType");
                        groupScope = properties.getProperty("groupScope");
                        groupType1 = properties.getProperty("groupType1");
                        objectRID = properties.getProperty("objectSID");
                        objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
                        if (!groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.domain_local")) && !groupScope.equals(rb.getString("admp.reports.group_reports.group_scopes.universal"))) continue;
                        properties3 = new Properties();
                        properties3.setProperty("Display_Name", name);
                        properties3.setProperty("Distinguished_Name", distinguishedName);
                        properties3.setProperty("objectRID", objectRID);
                        properties3.setProperty("groupType1", groupType1);
                        properties3.setProperty("groupScope", groupScope);
                        properties3.setProperty("groupType", groupType);
                        newAvailibleGroups.add(properties3);
                    }
                }
            }
            if (selectedGroups != null) {
                for (Properties properties : selectedGroups) {
                    String disp = (String)properties.get("Display_Name");
                    for (Properties properties2 : newAvailibleGroups) {
                        String disp1 = (String)properties2.get("Display_Name");
                        if (!disp.equals(disp1)) continue;
                        tobeDeletedProps.add(properties2);
                    }
                }
            }
            for (Properties properties : tobeDeletedProps) {
                newAvailibleGroups.remove(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("availableGroups", newAvailibleGroups);
        request.setAttribute("selectedGroups", selectedGroups);
        return mapping.findForward("groups");
    }

    private void validateCSVHeader(Vector headerVector, DynaValidatorForm groupBean, AdventNetResourceBundle rb) throws Exception {
        boolean header = false;
        boolean keyHeader = false;
        String[] keyLdapNames = new String[]{"samAccountName", "userPrincipalName", "distinguishedName", "DN", "cn", "name", "givenName", "sn", "displayName", "canonicalName", "profilePath", "scriptPath"};
        String keyLdapName = null;
        Vector<String> attributeList = new Vector<String>();
        this.headerLdapNames = headerVector;
        for (int j = 0; j < headerVector.size(); ++j) {
            String s = (String)headerVector.get(j);
            for (int i = 0; i < keyLdapNames.length; ++i) {
                String s1 = keyLdapNames[i];
                if (!s1.equalsIgnoreCase(s)) continue;
                header = true;
                if (i > 5) continue;
                if (keyLdapName == null) {
                    groupBean.set("keyPos", (Object)new Integer(j));
                    keyLdapName = s;
                }
                keyHeader = true;
                attributeList.add(s);
            }
            if (s.equalsIgnoreCase("DN") || s.equalsIgnoreCase("distinguishedName")) {
                groupBean.set("dnPos", (Object)new Integer(j));
                continue;
            }
            if (!s.equalsIgnoreCase("cn") && !s.equalsIgnoreCase("name")) continue;
            groupBean.set("cnPos", (Object)new Integer(j));
        }
        if (header) {
            if (!keyHeader) {
                throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            }
            groupBean.set("attributeList", attributeList);
        } else {
            int dnPos = -1;
            for (int i = 0; i < headerVector.size(); ++i) {
                String s = (String)headerVector.get(i);
                if (s.indexOf("CN=") == 0 && s.indexOf("cn=") == 0 || s.indexOf("DC=") == 0 && s.indexOf("dc=") == 0) continue;
                groupBean.set("keyPos", (Object)new Integer(i));
                dnPos = i;
                keyLdapName = "distinguishedName";
                groupBean.set("dnPos", (Object)new Integer(i));
                break;
            }
            if (dnPos == -1) {
                throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            }
        }
        groupBean.set("keyLdapName", keyLdapName);
        groupBean.set("header", (Object)String.valueOf(header));
    }

    public ActionForward removeDNList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            ArrayList meMRrecipientsDNList = (ArrayList)bean.get("meMRrecipientsDNList");
            ArrayList meMRrecipientsDisplayList = (ArrayList)bean.get("meMRrecipientsDisplayList");
            ArrayList REJECT_MESSAGES_FROM = (ArrayList)bean.get("REJECT_MESSAGES_FROM");
            ArrayList ACCEPT_MESSAGES_FROM = (ArrayList)bean.get("ACCEPT_MESSAGES_FROM");
            String removedDN = request.getParameter("removeDNList");
            for (int i = 0; i < meMRrecipientsDNList.size(); ++i) {
                if (!((String)meMRrecipientsDNList.get(i)).equalsIgnoreCase(removedDN)) continue;
                meMRrecipientsDNList.remove(i);
                meMRrecipientsDisplayList.remove(i);
                if (REJECT_MESSAGES_FROM.size() > 0) {
                    REJECT_MESSAGES_FROM.remove(i);
                }
                if (ACCEPT_MESSAGES_FROM.size() <= 0) continue;
                ACCEPT_MESSAGES_FROM.remove(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getMembersList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            String domainName = (String)bean.get("domainName");
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID);
            String groupName = (String)bean.get("name");
            String escapedString = CommonUtil.escapeString((String)groupName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String searchString = "(&(objectCategory=Group)(objectClass=group)(cn=" + escapedString + "))";
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("member");
            attributeList.add("objectSID");
            String sid = (String)bean.get("sid");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList members = ADHandler.getMoreList((String)domainName, (Long)loginId, (String)sid);
            this.logger.log(Level.INFO, "members : " + members);
            TreeMap sortedMembers = new TreeMap();
            Hashtable membersList = (Hashtable)bean.get("membersList");
            membersList.clear();
            Hashtable primaryGroupIDList = new Hashtable();
            for (int i = 0; i < members.size(); ++i) {
                try {
                    Hashtable hash = (Hashtable)members.get(i);
                    Hashtable mem = new Hashtable();
                    membersList.put(hash.get("distinguishedName"), hash.get("cn"));
                    mem.put("distinguishedName", hash.get("distinguishedName"));
                    if (hash.containsKey("primaryGroupID")) {
                        mem.put("primaryGroupID", hash.get("primaryGroupID"));
                        primaryGroupIDList.put(hash.get("distinguishedName"), hash.get("primaryGroupID"));
                    } else {
                        mem.put("primaryGroupID", "0");
                        primaryGroupIDList.put(hash.get("distinguishedName"), "0");
                    }
                    sortedMembers.put(hash.get("cn"), mem);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            bean.set("initialValuesTable", membersList.clone());
            bean.set("membersList", (Object)membersList);
            bean.set("primaryGroupIDList", primaryGroupIDList);
            this.logger.log(Level.INFO, "groupMemberslist LISTS : " + members + "\n membersList : " + membersList);
            GroupModificationUtil.getXMLMembers(request, response, sortedMembers);
            bean.set("hideDeleteMembers", (Object)"true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

