/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.model.DynamicController;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModifyGroupListener
extends ModifyUserListener
implements DynamicController {
    public ModifyGroupListener() {
        this.tableName = new String("ADSMModifyGroupResult");
        this.mgmtIds[0] = 2003;
        this.mgmtIds[1] = 2023;
        this.mgmtIds[2] = 2021;
        this.mgmtIds[3] = 2043;
        this.mgmtIds[4] = 2022;
        this.dnAttribId = 2003;
        if (!LicenseMgr.getInstance().isModuleLicensed("Group Management")) {
            this.isLicenseExceeded = true;
        }
        this.searchAttributes = SearchProfileHandler.getSearchAttributes((int)3, (int)2);
    }

    @Override
    public String getObjectName(Hashtable h) {
        return this.getValue(h, new Integer(2047));
    }

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1016L);
        return categoryId;
    }

    @Override
    public ArrayList getMgmtActions(ArrayList actions) {
        ArrayList resultMgmtActions = new ArrayList();
        Hashtable<String, Object> mgmtActionItems = new Hashtable<String, Object>();
        for (int i = 0; i < actions.size(); ++i) {
            Hashtable hash = (Hashtable)actions.get(i);
            ArrayList actionItems = (ArrayList)hash.get("ACTION_ITEMS");
            String categoryName = (String)hash.get("CATEGORY_NAME");
            Long subCategoryId = (Long)hash.get("SUB_CATEGORY_ID");
            if (actionItems == null || subCategoryId == 1017L || subCategoryId == 1019L || subCategoryId == 1036L || subCategoryId == 1038L) continue;
            mgmtActionItems = new Hashtable();
            mgmtActionItems.put("CATEGORY_NAME", categoryName);
            mgmtActionItems.put("ACTION_ITEMS", actionItems);
            resultMgmtActions.add(mgmtActionItems);
        }
        return resultMgmtActions;
    }

    @Override
    public void search(HttpServletRequest request, ReportBean bean) {
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)loginId);
            logger.log(Level.INFO, "Generation ID : " + this.generationId);
            ArrayList attributeList = this.getReportAttributeList();
            String searchString = request.getParameter("searchString");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            logger.log(Level.INFO, "The container list is : " + containerList);
            StringBuffer str = new StringBuffer();
            str.append("(&(objectCategory=group)(objectClass=group)");
            if (searchString != null && !searchString.equals("")) {
                this.getSearchString(searchString, str);
            }
            str.append(")");
            logger.log(Level.INFO, "Searching the SIDs for the String " + searchString);
            logger.log(Level.INFO, "Form to Action : ");
            ModifyUserListener.Action action = new ModifyUserListener.Action(this, loginId, containerList, attributeList, str.toString(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void modifyUser(HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            this.domainVsIds = authObject.getDomainActionMap();
            this.authorizedDomainOUHash = authObject.getDomainOUsMap();
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            ArrayList list = null;
            JSONObject jsonObject = new JSONObject(request.getParameter("selectedSid").toString().trim());
            JSONArray selectedSidArray = jsonObject.getJSONArray("selectedSid");
            String[] sidArray = new String[selectedSidArray.length()];
            for (int j = 0; j < selectedSidArray.length(); ++j) {
                sidArray[j] = selectedSidArray.getString(j);
            }
            Criteria resultTableCriteria = ModifyGroupListener.getSIDCriteria(bean, sidArray);
            Criteria columnSearchCriteria = null;
            Properties p = new Properties();
            p.put("TABLE_NAME", this.resultTableName);
            p.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
            ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns(this.reportId);
            Properties sidProps = new Properties();
            sidProps.put("ATTRIB_ID", new Integer(2023));
            sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
            sidProps.put("ATTRIB_LDAP_NAME", "objectSID");
            sidProps.put("TABLE_NAME", this.baseTableName);
            sidProps.put("RELATIONAL_TYPE", new Integer(0));
            attributeList.add(sidProps);
            Hashtable multipleValuesSids = new Hashtable();
            list = this.getRows(attributeList, p, true, -1, -1, multipleValuesSids, resultTableCriteria, columnSearchCriteria, new ArrayList());
            Integer count = ReportHandler.getSIDReportCount((Long)this.getGenerationId(), (String)this.resultTableName, (Criteria)resultTableCriteria);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            ModifyUserListener.ModifyAction action = new ModifyUserListener.ModifyAction(this, loginId, hostId, bean, list, this.getReportAttributeList(), 2);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void modifyCSVUser(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String hostId = request.getRemoteHost();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        this.domainVsIds = authObject.getDomainActionMap();
        this.authorizedDomainOUHash = authObject.getDomainOUsMap();
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            ArrayList list = null;
            JSONObject jsonObject = new JSONObject(request.getParameter("selectedSid").toString().trim());
            JSONArray selectedSidArray = jsonObject.getJSONArray("selectedSid");
            String[] sidArray = new String[selectedSidArray.length()];
            for (int j = 0; j < selectedSidArray.length(); ++j) {
                sidArray[j] = selectedSidArray.getString(j);
            }
            Criteria crit = this.getSelectedUserIndexCriteria(sidArray);
            ArrayList attributeList = (ArrayList)bean.get("attributeList");
            list = AddUserHandler.getInstance().getUserDetailsList(this.generationId, attributeList, -1, 0, null, crit);
            Integer count = AddUserHandler.getInstance().getCount(this.generationId, crit);
            ModifyCSVAction action = new ModifyCSVAction(loginId, hostId, bean, list, 2);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String modifyCSVUser(String searchString, ReportBean bean, String defaultNamingContext, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        String message = null;
        try {
            ArrayList attib = this.getReportAttributeList();
            Properties prop = this.getAttributeValues(this.domainName, defaultNamingContext, loginId, attib, searchString);
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.no_user_present");
            }
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Hashtable uiValues = new Hashtable();
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues);
            ArrayList<String> guidList = new ArrayList<String>();
            guidList.add(guid);
            DBObjectUtil.addOrUpdate((String)this.baseTableName, (String)this.tableKey, guidList, tableRowMap, relationalTableRowMap);
            ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns(this.reportId);
            Properties sidProps = new Properties();
            sidProps.put("ATTRIB_ID", new Integer(2023));
            sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
            sidProps.put("TABLE_NAME", this.baseTableName);
            sidProps.put("RELATIONAL_TYPE", new Integer(0));
            attributeList.add(sidProps);
            Hashtable multipleValuesSids = new Hashtable();
            Criteria crit = new Criteria(new Column(this.baseTableName, this.tableKey), (Object)guid, 0);
            ArrayList list = DBObjectUtil.getObjects((String)this.baseTableName, (String)this.tableKey, (ArrayList)attributeList, (Criteria)crit);
            Hashtable result = (Hashtable)list.get(0);
            ArrayList attrib = (ArrayList)bean.get("attributeList");
            ArrayList<String> atrributes = new ArrayList<String>();
            for (int i = 0; i < attrib.size(); ++i) {
                Hashtable ha = (Hashtable)attrib.get(i);
                String ldapName = (String)ha.get("ATTRIB_LDAP_NAME");
                atrributes.add(ldapName);
            }
            System.out.println("Modify CSV User atrributes:" + atrributes);
            audit_info.put("distinguishedName", this.getValue(result, 1004));
            message = this.modifyUser(result, atrributes, bean, this.domainName, loginId, audit_info, auditDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getMessage();
            this.auditFailure(audit_info, auditDataObj, errMsg);
            return errMsg;
        }
        return message;
    }

    @Override
    public void auditFailure(Hashtable audit_info, DataObject auditDataObj, String errMsg) {
        try {
            Long obj_id = (Long)audit_info.get("object_id");
            Row auditRow = auditDataObj.getRow("ADSMAuditDetails");
            Row objRow = auditDataObj.getRow("ADSMAuditObjs", new Criteria(Column.getColumn((String)"ADSMAuditObjs", (String)"OBJECT_ID"), (Object)obj_id, 0));
            TechAuditAPI.getInstance().auditGroupModification(this.loginId, (String)auditRow.get("ACTION_NAME"), (String)objRow.get("OBJECT_NAME"), (String)objRow.get("OBJECT_DOMAIN"), new ArrayList(), new ArrayList(), new ArrayList(), errMsg, obj_id, auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void populateIncludedAndExcludedGroup(String domainName, Long loginId) {
        Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)domainName);
        this.groupIncludeList = (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU");
        this.groupExcludeList = (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU");
    }

    protected class ModifyCSVAction
    extends Thread {
        private ArrayList list = null;
        ReportBean bean = null;
        private ArrayList messageList = null;
        private int modifyCount = 0;
        private Long loginId = null;
        private String hostId = "";
        private Integer objectId = 0;

        public ModifyCSVAction(Long loginId, String hostId, ReportBean b, ArrayList list, Integer objectId) {
            this.bean = b;
            this.list = list;
            this.messageList = new ArrayList();
            this.modifyCount = 0;
            this.loginId = loginId;
            this.hostId = hostId;
            this.objectId = objectId;
        }

        private void updatePreviousList() {
            if (this.messageList.size() > 0) {
                for (int i = 0; i < this.messageList.size(); ++i) {
                    ModifyGroupListener.this.out.write((String)this.messageList.get(i));
                    ModifyGroupListener.this.out.flush();
                }
                this.messageList.clear();
            }
        }

        private void updateMessage(Long userIndex, String message) {
            ++this.modifyCount;
            String s = "<script>if(this.load) updateMessage('" + userIndex.toString() + "','" + message + "')</script>";
            String s1 = "<script>if(this.load) updateCount('" + this.modifyCount + "')</script>";
            if (ModifyGroupListener.this.out != null) {
                this.updatePreviousList();
                ModifyGroupListener.this.out.write(s);
                ModifyGroupListener.this.out.flush();
                ModifyGroupListener.this.out.write(s1);
                ModifyGroupListener.this.out.flush();
            } else {
                this.messageList.add(s);
                this.messageList.add(s1);
            }
            Properties prop = new Properties();
            prop.setProperty("CREATION_STATUS", "WARNING");
            prop.setProperty("CREATION_MESSAGE", message);
            prop.put("USER_INDEX", userIndex);
            AddUserHandler.getInstance().updateCreationStatus(ModifyGroupListener.this.rb, prop);
        }

        @Override
        public void run() {
            String[] domains = (String[])this.bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)this.bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            ModifyGroupListener.this.domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            ModifyGroupListener.this.populateIncludedAndExcludedGroup(ModifyGroupListener.this.domainName, this.loginId);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ModifyGroupListener.this.domainName);
            this.bean.set("inputParams", inputParams);
            Hashtable resultList = new Hashtable();
            ArrayList<String> objectOUList = new ArrayList<String>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            boolean isLicenseExceeded = LicenseMgr.getInstance().isLicenseExceeded("Group Management");
            String keyLdapName = (String)this.bean.get("keyLdapName");
            ModifyGroupListener.this.setTableProps(ModifyGroupListener.this.domainName, new Long(-1L));
            ModifyGroupListener.this.registerQueue();
            ModifyGroupListener.this.updateResult = false;
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)ModifyGroupListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)ModifyGroupListener.this.rb);
                for (int i = 0; ModifyGroupListener.this.continueAction && i < this.list.size(); ++i) {
                    Hashtable hashtable = (Hashtable)this.list.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    String keyLdapValue = null;
                    String message = "";
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    for (Hashtable hashtable1 : valuesList) {
                        String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                        if (!ldapName.equals(keyLdapName)) continue;
                        keyLdapValue = hashtable1.get("ATTRIB_VALUE").toString();
                        break;
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, keyLdapValue, (String)ModifyGroupListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    if (!isLicenseExceeded) {
                        String searchString = "(&(objectClass=group)(objectCategory=group)(" + keyLdapName + "=" + keyLdapValue + "))";
                        message = ModifyGroupListener.this.modifyCSVUser(searchString, this.bean, defaultNamingContext, this.loginId, audit_info, auditDataObj);
                        this.updateMessage(userIndex, message);
                    } else {
                        message = MessageFormat.format(ModifyGroupListener.this.rb.getString("admp.mgmt.grp_mgmt.mod_grps_csv.alert.could_not_update_license_level_exceeded"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers"));
                        this.updateMessage(userIndex, message);
                    }
                    String managerVal = "";
                    Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
                    if (hashtable.get("manager") != null) {
                        managerVal = (String)hashtable.get("manager");
                    }
                    if (managerVal != null && !managerVal.equals("")) {
                        managerAndPwd.put("manager", managerVal);
                    }
                    resultList.put(keyLdapValue, managerAndPwd);
                    auditObjectIdList.add((Long)audit_info.get("object_id"));
                    String dnValue = (String)audit_info.get("distinguishedName");
                    String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue);
                    if (!objectOUList.contains(ouName)) {
                        objectOUList.add(ouName);
                    }
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                ModifyGroupListener.this.updateQueue();
                ModifyGroupListener.this.isCompleted = true;
                ModifyGroupListener.this.totalCount = 0;
                ModifyGroupListener.this.endQueue();
                ModifyGroupListener.this.updateResult = true;
                this.messageList.clear();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, this.objectId, resultList, this.loginId, ModifyGroupListener.this.reportId, ModifyGroupListener.this.domainName, ModifyGroupListener.this.rb, null, objectOUList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

