/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.groups.ModifyGroupListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ModifyOrganizationGroupListener
extends ModifyGroupListener {
    private ArrayList addToGroupList = new ArrayList();
    private ArrayList removeFromGroupList = new ArrayList();
    private Boolean isRemoveAllGrp = false;

    public ModifyOrganizationGroupListener() {
        this.reportId = new Integer(4004);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String retMessage = new String();
        try {
            logger.log(Level.INFO, "Calling Modify User in the ModifyOrganizationGroupListener");
            ArrayList list = new ArrayList();
            ArrayList groupList = new ArrayList();
            Properties remAddGrps = new Properties();
            boolean hasError = false;
            try {
                String sid = this.getValue(result, 2023);
                String dn = this.getValue(result, 2003);
                if (HelpdeskUtil.isExcludedGroup((String)dn, (ArrayList)this.groupExcludeList) || !HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)this.groupIncludeList)) {
                    message.append(this.rb.getString("groupmanagement.messages.not_authorized_group"));
                } else {
                    dn = CommonUtil.escapeDN((String)dn);
                    list = GroupMgmtUtil.getOrganizationNativeProps(bean, result);
                    ModifyGroupListener listener = (ModifyGroupListener)bean.getListener();
                    logger.log(Level.INFO, "Starts Modifying the Group,Sid: " + sid + "dn: " + dn);
                    logger.log(Level.FINE, "bean list: " + (Object)((Object)bean));
                    remAddGrps = this.groupList(bean, domainName, loginId, dn, message);
                    NativeError err = ADHandlerForMgmt.modifyOrganizationGroup((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)list, groupList, (Properties)remAddGrps, (boolean)false);
                    Hashtable errors = err.getErrors();
                    if (errors != null && !errors.isEmpty()) {
                        Set keys = errors.keySet();
                        for (Object key : keys) {
                            String errorMessage = err.getErrorMessage(key, this.rb);
                            if (errorMessage == null || errorMessage.isEmpty()) continue;
                            message.append(errorMessage);
                            hasError = true;
                            break;
                        }
                    }
                    if (!this.addToGroupList.isEmpty()) {
                        Properties addGrpsProp = new Properties();
                        addGrpsProp.put("addToGroup", this.addToGroupList);
                        err = ADHandlerForMgmt.modifyOrganizationGroup((String)domainName, (Long)loginId, (String)sid, (String)dn, new ArrayList(), new ArrayList(), (Properties)addGrpsProp, (boolean)false);
                        errors = err.getErrors();
                        if (errors != null && !errors.isEmpty()) {
                            Set keys = errors.keySet();
                            for (Object key : keys) {
                                String errorMessage = err.getErrorMessage(key, this.rb);
                                if (errorMessage == null || errorMessage.isEmpty()) continue;
                                message.append(errorMessage);
                                hasError = true;
                                break;
                            }
                        }
                    }
                    ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                    if (remAddGrps.containsKey("isAllGrpsAuth") && !((Boolean)remAddGrps.get("isAllGrpsAuth")).booleanValue() && !hasError) {
                        if (list.isEmpty()) {
                            if (((ArrayList)remAddGrps.get("removeFromGroup")).isEmpty()) {
                                message.append(this.rb.getString("groupmanagement.messages.unable_to_modify"));
                            } else {
                                message.append(this.rb.getString("admp.mgmt.common.statmsg.partially_modified"));
                            }
                        } else {
                            message.append(this.rb.getString("admp.mgmt.common.statmsg.partially_modified"));
                        }
                    } else if (!hasError) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    }
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.unable_to_modify") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.unable_to_modify") + e.getMessage());
            }
            if (!groupList.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", groupList);
                list.add(grpList);
            }
            if (!this.addToGroupList.isEmpty()) {
                Properties addProps = new Properties();
                addProps.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.add_to_group"));
                addProps.put("ATTRIB_VALUE_COUNT", (Object)2L);
                addProps.put("ATTRIB_VALUE", this.addToGroupList);
                list.add(addProps);
            }
            if (!remAddGrps.isEmpty()) {
                Properties remProps = new Properties();
                if (remAddGrps.containsKey("removeFromGroup")) {
                    remProps.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.remove_from_group"));
                    remProps.put("ATTRIB_VALUE_COUNT", (Object)2L);
                    remProps.put("ATTRIB_VALUE", (ArrayList)remAddGrps.get("removeFromGroup"));
                    list.add(remProps);
                }
            }
            if (!(retMessage = message.toString()).equalsIgnoreCase(this.rb.getString("admp.mgmt.common.text.successfully_modified"))) {
                String toFind1 = this.rb.getString("admp.mgmt.user_mgmt.group_mem.error.already_exist");
                String toFind2 = this.rb.getString("admp.mgmt.user_mgmt.group_mem.error.unwilling_to_process");
                int messageLen = retMessage.length();
                int toFindStrLen1 = toFind1.length();
                int toFindStrLen2 = toFind2.length();
                int occurence1 = 0;
                int occurence2 = 0;
                if (retMessage.contains(toFind1)) {
                    for (int ind = 0; ind < messageLen - toFindStrLen1; ++ind) {
                        if (toFind1.compareTo(retMessage.substring(ind, ind + toFindStrLen1)) != 0 || ++occurence1 <= 1) continue;
                        retMessage = retMessage.replaceFirst(toFind1, "");
                        messageLen = retMessage.length();
                    }
                }
                if (retMessage.contains(toFind2)) {
                    for (int ind = 0; ind < messageLen - toFindStrLen2; ++ind) {
                        if (toFind2.compareTo(retMessage.substring(ind, ind + toFindStrLen2)) != 0 || ++occurence2 <= 1) continue;
                        retMessage = retMessage.replaceFirst(toFind2, "");
                        messageLen = retMessage.length();
                    }
                }
            }
            TechAuditAPI.getInstance().auditGroupModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_add_org_attribs"), this.getValue(result, 2001), domainName, list, retMessage, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + retMessage);
        return retMessage;
    }

    public Properties groupList(ReportBean bean, String domainName, Long loginId, String dn, StringBuffer message) {
        Properties groupList = new Properties();
        try {
            String domainDistinguidhedName = DomainUtil.getDefaultNamingContext((String)domainName);
            BeanMap props = (BeanMap)bean.get("props");
            Hashtable addToGroupsMap = (Hashtable)props.get("addToGroupDNVsNameMap");
            Hashtable remFromGroupsMap = (Hashtable)props.get("removeFromGroupDNVsNameMap");
            String isRemoveAllGrps = (String)props.get("isRemoveAllGroup");
            this.addToGroupList = new ArrayList();
            this.removeFromGroupList = new ArrayList();
            this.isRemoveAllGrp = false;
            if (addToGroupsMap != null && !addToGroupsMap.isEmpty()) {
                for (String dN : addToGroupsMap.keySet()) {
                    if (this.addToGroupList.contains(dN)) continue;
                    this.addToGroupList.add(dN);
                }
            }
            if (remFromGroupsMap != null && !remFromGroupsMap.isEmpty()) {
                for (String dN : remFromGroupsMap.keySet()) {
                    if (this.removeFromGroupList.contains(dN)) continue;
                    this.removeFromGroupList.add(dN);
                }
                groupList.put("removeFromGroup", this.removeFromGroupList);
            }
            if (isRemoveAllGrps.equalsIgnoreCase("on")) {
                this.isRemoveAllGrp = true;
                String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + CommonUtil.escapeSpecialCharacters((String)dn) + "))";
                Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                ArrayList<String> groupAttributeList = new ArrayList<String>();
                groupAttributeList.add("cn");
                groupAttributeList.add("distinguishedName");
                groupAttributeList.add("objectSid");
                ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
                ArrayList<String> authorizedGrouplistProps = new ArrayList<String>();
                ArrayList<String> unAuthorizedGrouplistProps = new ArrayList<String>();
                if (!grouplistProps.isEmpty()) {
                    for (int index = 0; index < grouplistProps.size(); ++index) {
                        Properties props1 = (Properties)grouplistProps.get(index);
                        if (props1 == null) continue;
                        ArrayList ouDNList = (ArrayList)props1.get("distinguishedName");
                        String ouDN = (String)ouDNList.get(0);
                        if (!HelpdeskUtil.isExcludedGroup((String)ouDN, (ArrayList)this.groupExcludeList) && HelpdeskUtil.isAuthorizedGroup((String)ouDN, (ArrayList)this.groupIncludeList)) {
                            authorizedGrouplistProps.add(ouDN);
                            continue;
                        }
                        unAuthorizedGrouplistProps.add(ouDN);
                        logger.log(Level.FINE, "Not Authorized Group- " + ouDN);
                    }
                }
                if (authorizedGrouplistProps.isEmpty()) {
                    if (message.length() != 0) {
                        message.append(". ");
                    }
                    if (!grouplistProps.isEmpty()) {
                        groupList.put("isAllGrpsAuth", (Object)false);
                        message.append(this.rb.getString("groupmanagement.messages.not_authorized_remove_group"));
                    }
                } else if (!unAuthorizedGrouplistProps.isEmpty()) {
                    groupList.put("isAllGrpsAuth", (Object)false);
                    message.append(this.rb.getString("groupmanagement.messages.not_authorized_few_remove_group"));
                    logger.log(Level.INFO, this.rb.getString("groupmanagement.messages.not_authorized_remove_group") + " : " + unAuthorizedGrouplistProps.toString());
                }
                groupList.put("removeFromGroup", authorizedGrouplistProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupList;
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        String[] actionValues = new String[]{"description", "mail", "info", "managerText"};
        String[] actionLabelsStr = new String[]{"admp.mgmt.grp_mgmt.org_attribs.input.desc", "admp.mgmt.grp_mgmt.org_attribs.input.email", "admp.mgmt.grp_mgmt.org_attribs.input.notes", "admp.mgmt.grp_mgmt.org_attribs.input.managed_by"};
        MgmtUtil.setEmptyFieldsMessage(request, bean, actionValues, actionLabelsStr);
    }
}

