/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.sym.adsm.common.webclient.integration.ADActionExecuter;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;

public abstract class ActionExecuter {
    private int inputSource;
    public static final String AD_EXECUTOR = "ad";
    protected static int generationId;
    private static LinkedHashMap<Integer, ActionExecuter> hashSetOfExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionExecuter() {
        LinkedHashMap<Integer, ActionExecuter> linkedHashMap = hashSetOfExecutors;
        synchronized (linkedHashMap) {
            generationId = ActionExecuter.getNextGenerationID();
            hashSetOfExecutors.put(generationId, this);
        }
    }

    public static ActionExecuter getExecutorInstance(String actionExecutor, int configId) {
        try {
            ADActionExecuter executor = null;
            if (actionExecutor.equals(AD_EXECUTOR)) {
                executor = new ADActionExecuter(configId);
            }
            return executor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract int initiateAction(GenericData var1);

    public abstract boolean isCompletedExecution();

    public abstract JSONArray getStatus();

    public static boolean isCompleted(Integer generationId) {
        ActionExecuter instance = hashSetOfExecutors.get(generationId);
        return instance.isCompletedExecution();
    }

    public static JSONArray getStatus(Integer generationId) {
        ActionExecuter instance = hashSetOfExecutors.get(generationId);
        return instance.getStatus();
    }

    private static int getNextGenerationID() {
        if (hashSetOfExecutors.size() > 0) {
            int prev = -1;
            for (Map.Entry<Integer, ActionExecuter> entry : hashSetOfExecutors.entrySet()) {
                Integer val = entry.getKey();
                if (prev == -1) {
                    if (val > 1) {
                        return 1;
                    }
                    prev = val;
                    continue;
                }
                if (val - prev > 1) {
                    return prev + 1;
                }
                prev = val;
            }
            return prev + 1;
        }
        return 1;
    }

    static {
        hashSetOfExecutors = new LinkedHashMap();
    }
}

