/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.integration.InputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.MSSQLInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.OracleInputDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DBInputDataSource
extends InputDataSource {
    private static Logger out = Logger.getLogger("WFLogger");
    Hashtable<String, String> configData = null;
    GenericData genData = new GenericData();
    GenericData allGenericData = new GenericData();
    String dbName = null;
    int configId;
    boolean isSchedule = false;
    Long scheduleId;
    Connection connection = null;
    DataObject recordCheckDO = null;
    Long integAdvncCriteriaId = null;
    Hashtable mappingData = null;

    public void setIntegAdvncCriteriaId(Long integAdvncCriteriaId) {
        this.integAdvncCriteriaId = integAdvncCriteriaId;
    }

    public String getAdvancedSelectQuery() {
        String query = this.getSelectQuery();
        if (this.integAdvncCriteriaId != null) {
            try {
                Criteria c = new Criteria(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"CRITERIA_ID"), (Object)this.integAdvncCriteriaId, 0);
                SelectQueryImpl critQuery = new SelectQueryImpl(Table.getTable((String)"AutoIntegAdvancCriteriaDetails"));
                critQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
                critQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"PROCESSING_ORDER"), true));
                critQuery.setCriteria(c);
                DataObject obj = DataAccess.get((SelectQuery)critQuery);
                String criteria = "";
                if (obj != null) {
                    Iterator it = obj.getRows("AutoIntegAdvancCriteriaDetails");
                    while (it.hasNext()) {
                        Row row = (Row)it.next();
                        if (!criteria.isEmpty()) {
                            criteria = criteria + " " + (String)row.get("PROCESS_MATCH_CRITERIA");
                        }
                        criteria = criteria + " " + DBDataSourceUtil.getProcessedWhereCriteria(Integer.parseInt((String)row.get("MATCH_CRITERIA")), (String)row.get("COLUMN_NAME"), (String)row.get("COLUMN_VALUE"));
                        criteria = "(" + criteria.trim() + ")";
                    }
                    if (!criteria.isEmpty()) {
                        query = query + " where " + criteria;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return query;
        }
        return query;
    }

    protected abstract String getUrlString();

    protected abstract String getDriverClass();

    protected abstract String getSelectQuery();

    protected abstract Hashtable getConfigData(int var1);

    protected abstract boolean isTableExists(String var1);

    public DBInputDataSource(int configId, String secondarySource) throws Exception {
        this.configId = configId;
        this.configData = this.getConfigData(configId);
        this.init();
    }

    public DBInputDataSource(int configId) throws Exception {
        this.configId = configId;
        this.configData = this.getConfigData(configId);
        this.init();
    }

    public DBInputDataSource(int configId, Long scheduleId) throws Exception {
        this.configId = configId;
        if (scheduleId != null) {
            this.isSchedule = true;
            this.scheduleId = scheduleId;
        }
        this.configData = this.getConfigData(configId);
        this.init();
    }

    public static DBInputDataSource getInstance(int configId) throws Exception {
        return DBInputDataSource.getInstance(configId, null);
    }

    public static DBInputDataSource getInstance(int configId, Long scheduleId) throws Exception {
        String dbType = DBDataSourceUtil.getDBType(configId);
        if (dbType.equals("mssql")) {
            return new MSSQLInputDataSource(configId, scheduleId);
        }
        if (dbType.equals("oracle")) {
            return new OracleInputDataSource(configId, scheduleId);
        }
        return null;
    }

    private void init() throws Exception {
        this.dbName = DBDataSourceUtil.getDBType(this.configId);
        this.connection = this.getConnection();
        if (this.connection == null) {
            throw new Exception("admp.auto.integ.thirdparty.connection_issue");
        }
        this.createTable();
    }

    private Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            String userName = this.configData.get("USER_NAME");
            String password = this.configData.get("PASSWORD");
            String url = this.getUrlString();
            String driverClass = this.getDriverClass();
            Class.forName(driverClass);
            Connection conn = DriverManager.getConnection(url, userName, password);
            return conn;
        }
        catch (Exception e) {
            System.out.println("Connection exception occurred...");
            e.printStackTrace();
            return null;
        }
    }

    public Hashtable getAttrMapping() {
        if (this.mappingData != null) {
            return this.mappingData;
        }
        this.mappingData = new Hashtable();
        Hashtable<String, String> customAttribToLDAPMapping = new Hashtable<String, String>();
        customAttribToLDAPMapping.put("accountStatus", "userAccountControl");
        try {
            String tableName = "TPIntegrationAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)this.configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                throw new Exception("No rows found for config id " + this.configId + "' in table 'TPIntegrationAttrMapping'");
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ldapValue = (String)r.get("GENERIC_COLUMN");
                String dbColumn = (String)r.get("DB_COLUMN");
                if (customAttribToLDAPMapping.containsKey(ldapValue)) {
                    this.mappingData.put(customAttribToLDAPMapping.get(ldapValue), dbColumn);
                    continue;
                }
                this.mappingData.put(ldapValue, dbColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mappingData;
    }

    private void addResultSetToTempTable(ResultSet rs, String generatedTableName) {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            String tempTableName = generatedTableName + "_temp";
            if (tableDef != null) {
                tableDef.setTableName(tempTableName);
                PrimaryKeyDefinition primaryKeyDef = tableDef.getPrimaryKey();
                ArrayList pkList = new ArrayList(primaryKeyDef.getColumnList());
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(tempTableName + "_PK");
                for (String col : pkList) {
                    pkDef.addColumnName(col);
                }
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
            ResultSetMetaData columns = rs.getMetaData();
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            while (rs.next()) {
                Row row = new Row(tempTableName);
                for (int i = 1; i <= columns.getColumnCount(); ++i) {
                    String dbColumnName = columns.getColumnName(i);
                    Integer dbColumnType = columns.getColumnType(i);
                    String col = rs.getString(dbColumnName);
                    if (col != null) {
                        row.set(dbColumnName, (Object)this.getUpdatedValue(dbColumnName, col.trim()));
                        continue;
                    }
                    if (dbColumnType == 4) {
                        row.set(dbColumnName, null);
                        continue;
                    }
                    row.set(dbColumnName, (Object)"");
                }
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Criteria getDeletedUsersCriteria(String generatedTableName) {
        Criteria missingInTPTableCrit = null;
        String tempTableName = generatedTableName + "_temp";
        try {
            ArrayList pkList = this.getLocalDBPrimaryKeys(generatedTableName);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(generatedTableName);
                while (it.hasNext()) {
                    String key2;
                    Row row = (Row)it.next();
                    Criteria singleUserCrit = null;
                    for (String key2 : pkList) {
                        Criteria singleKeyCrit = new Criteria(Column.getColumn((String)tempTableName, (String)key2), (Object)((String)row.get(key2)), 0);
                        if (singleUserCrit == null) {
                            singleUserCrit = singleKeyCrit;
                            continue;
                        }
                        singleUserCrit = singleUserCrit.and(singleKeyCrit);
                    }
                    DataObject missingRecords = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tempTableName, singleUserCrit);
                    if (!missingRecords.isEmpty()) continue;
                    key2 = (String)pkList.get(0);
                    if (missingInTPTableCrit == null) {
                        missingInTPTableCrit = new Criteria(Column.getColumn((String)generatedTableName, (String)key2), (Object)((String)row.get(key2)), 0);
                        continue;
                    }
                    missingInTPTableCrit = missingInTPTableCrit.or(new Criteria(Column.getColumn((String)generatedTableName, (String)key2), (Object)((String)row.get(key2)), 0));
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).dropTable(tempTableName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                CommonUtil.getPersistence((boolean[])new boolean[0]).dropTable(tempTableName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return missingInTPTableCrit;
    }

    private Criteria getDeletedUsersAdvncCriteria(String generatedTableName, Iterator it) {
        Criteria missingInTPTableCrit = this.getDeletedUsersCriteria(generatedTableName);
        Criteria advncCriteria = null;
        try {
            if (missingInTPTableCrit != null && this.integAdvncCriteriaId != null) {
                Criteria c = new Criteria(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"CRITERIA_ID"), (Object)this.integAdvncCriteriaId, 0);
                SelectQueryImpl critQuery = new SelectQueryImpl(Table.getTable((String)"AutoIntegAdvancCriteriaDetails"));
                critQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
                critQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"PROCESSING_ORDER"), true));
                critQuery.setCriteria(c);
                DataObject obj = DataAccess.get((SelectQuery)critQuery);
                if (obj != null) {
                    it = obj.getRows("AutoIntegAdvancCriteriaDetails");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Column column = Column.getColumn((String)generatedTableName, (String)((String)r.get("COLUMN_NAME")));
                        String columnValue = (String)r.get("COLUMN_VALUE");
                        int matchCriteria = Integer.parseInt((String)r.get("MATCH_CRITERIA"));
                        Criteria crit = new Criteria(column, (Object)columnValue, matchCriteria);
                        if (advncCriteria == null) {
                            advncCriteria = crit;
                            continue;
                        }
                        if (((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("or")) {
                            advncCriteria = advncCriteria.or(crit);
                            continue;
                        }
                        if (!((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("and")) continue;
                        advncCriteria = advncCriteria.and(crit);
                    }
                    if (advncCriteria != null) {
                        missingInTPTableCrit = missingInTPTableCrit.and(advncCriteria);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return missingInTPTableCrit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericData readData(String syncType) {
        ResultSet rs = null;
        Iterator it = null;
        try {
            Statement stmt = this.connection.createStatement();
            String selectQuery = "";
            selectQuery = !syncType.equalsIgnoreCase(AutomationConstants.GET_DELETED) ? this.getAdvancedSelectQuery() : this.getSelectQuery();
            rs = stmt.executeQuery(selectQuery);
            Hashtable attrMapping = this.getAttrMapping();
            ResultSetMetaData columns = rs.getMetaData();
            ArrayList<String> columnNamesfromSource = new ArrayList<String>();
            String generatedTableName = this.getLocalTableName();
            Row generatedTableRow = new Row(generatedTableName);
            ArrayList localColumnList = new ArrayList(generatedTableRow.getColumns());
            AlterTableQueryImpl alterQuery = new AlterTableQueryImpl(generatedTableName);
            for (int i = 1; i <= columns.getColumnCount(); ++i) {
                String colName = columns.getColumnName(i);
                columnNamesfromSource.add(colName);
                if (localColumnList.contains(colName)) continue;
                int dataType = columns.getColumnType(i);
                int columnSize = columns.getColumnDisplaySize(i);
                String mickeyColumnType = this.getMickeyColumnType(dataType);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName(colName);
                coldef.setDescription(colName);
                coldef.setDataType(mickeyColumnType);
                if (mickeyColumnType.equals("CHAR") && columnSize < 50) {
                    coldef.setMaxLength(255);
                } else {
                    coldef.setMaxLength(columnSize);
                }
                try {
                    alterQuery.addColumn(coldef);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alterQuery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                out.log(Level.INFO, "'" + colName + "' column added to " + generatedTableName);
            }
            if (syncType.equalsIgnoreCase(AutomationConstants.GET_DELETED)) {
                this.addResultSetToTempTable(rs, generatedTableName);
                Criteria missingInTPTableCrit = this.getDeletedUsersAdvncCriteria(generatedTableName, it);
                if (missingInTPTableCrit != null) {
                    DataObject generatedTableObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, missingInTPTableCrit);
                    it = generatedTableObj.getRows(generatedTableName);
                    while (it.hasNext()) {
                        Hashtable<String, String> record = new Hashtable<String, String>();
                        Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                        Row r = (Row)it.next();
                        for (String columnName : columnNamesfromSource) {
                            if (r.get(columnName) == null) continue;
                            String columnValue = r.get(columnName).toString();
                            Set keys = attrMapping.keySet();
                            for (String lDAPName : keys) {
                                if (!((String)attrMapping.get(lDAPName)).equalsIgnoreCase(columnName)) continue;
                                columnValue = this.getUpdatedValue(lDAPName, columnValue);
                                record.put(lDAPName, columnValue);
                                break;
                            }
                            chkRecord.put(columnName, columnValue);
                        }
                        this.genData.addRecord(record, chkRecord);
                    }
                }
            } else {
                while (rs.next()) {
                    Hashtable<String, String> record = new Hashtable<String, String>();
                    Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                    for (String columnName : columnNamesfromSource) {
                        Set keys = attrMapping.keySet();
                        if (rs.getString(columnName) == null) continue;
                        String columnValue = rs.getString(columnName).trim();
                        for (String lDAPName : keys) {
                            if (!((String)attrMapping.get(lDAPName)).equalsIgnoreCase(columnName)) continue;
                            columnValue = this.getUpdatedValue(lDAPName, columnValue);
                            record.put(lDAPName, columnValue);
                            break;
                        }
                        chkRecord.put(columnName, columnValue);
                    }
                    this.allGenericData.addRecord(record, chkRecord);
                    if (syncType.equalsIgnoreCase(AutomationConstants.GET_ADDED) && !this.recordPresentInDB(chkRecord)) {
                        this.genData.addRecord(record, chkRecord);
                        continue;
                    }
                    if (!syncType.equals(AutomationConstants.GET_MODIFIED) || !this.isRecordModified(chkRecord)) continue;
                    this.genData.addRecord(record, chkRecord);
                }
            }
            GenericData genericData = this.genData;
            return genericData;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private String getLocalTableName() {
        if (this.isSchedule) {
            return "IntegrationDBRecords_" + this.configId + "_" + this.scheduleId;
        }
        return "IntegrationDBRecords_" + this.configId;
    }

    @Override
    public void postExecutionUpdate(String syncType) {
        if (syncType.equals(AutomationConstants.GET_DELETED)) {
            this.deleteLocalRecords(this.genData);
        } else {
            this.removeAllOldRecordsAndAppend(this.allGenericData);
        }
    }

    private void removeAllOldRecordsAndAppend(GenericData allGenericData) {
        String generatedTableName = this.getLocalTableName();
        ArrayList<GenericData.GenericDataRecord> records = allGenericData.getRecords();
        ArrayList pkList = this.getDBPrimaryKeys(this.configData.get("TABLE_NAME"));
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            dataObject.deleteRows(generatedTableName, (Criteria)null);
            for (GenericData.GenericDataRecord record : records) {
                Hashtable userInput = record.getInputRecord();
                Row r = new Row(generatedTableName);
                Set keys = userInput.keySet();
                for (String pk : keys) {
                    r.set(pk, userInput.get(pk));
                }
                dataObject.addRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteLocalRecords(GenericData genData) {
        ArrayList<GenericData.GenericDataRecord> records = genData.getRecords();
        ArrayList pkList = this.getDBPrimaryKeys(this.configData.get("TABLE_NAME"));
        String generatedTableName = this.getLocalTableName();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            for (GenericData.GenericDataRecord record : records) {
                Hashtable userInput = record.getInputRecord();
                Row r = new Row(generatedTableName);
                for (String pk : pkList) {
                    r.set(pk, userInput.get(pk));
                }
                dataObject.deleteRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getPrimaryKeysFromConfig(int configId) {
        HashSet<String> primaryColList = new HashSet<String>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"TPIntegrationAttrMapping", (String)"CONFIG_ID"), (Object)configId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"TPIntegrationAttrMapping", (String)"IS_PRIMARY"), (Object)true, 0));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("TPIntegrationAttrMapping", criteria);
            if (dataObject != null) {
                Iterator it = dataObject.getRows("TPIntegrationAttrMapping");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    primaryColList.add((String)row.get("DB_COLUMN"));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(primaryColList);
    }

    private boolean recordPresentInDB(Hashtable record) {
        try {
            Row r;
            String generatedTableName = this.getLocalTableName();
            if (this.recordCheckDO == null) {
                this.recordCheckDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            }
            ArrayList pkList = this.getDBPrimaryKeys(this.configData.get("TABLE_NAME"));
            Criteria crit = null;
            if (pkList.size() != 0) {
                String colName = (String)pkList.get(0);
                crit = new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0);
                for (int i = 1; i < pkList.size(); ++i) {
                    colName = (String)pkList.get(i);
                    crit = crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0));
                }
            }
            return (r = this.recordCheckDO.getRow(generatedTableName, crit)) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isRecordModified(Hashtable record) {
        try {
            Row result;
            String generatedTableName = this.getLocalTableName();
            if (this.recordCheckDO == null) {
                this.recordCheckDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            }
            ArrayList pkList = this.getDBPrimaryKeys(this.configData.get("TABLE_NAME"));
            Criteria crit = null;
            if (pkList.size() != 0) {
                String colName = (String)pkList.get(0);
                crit = new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0);
                for (int i = 1; i < pkList.size(); ++i) {
                    colName = (String)pkList.get(i);
                    crit = crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0));
                }
            }
            if ((result = this.recordCheckDO.getRow(generatedTableName, crit)) != null) {
                ArrayList<String> columnList = this.getConfigColumns();
                columnList.removeAll(pkList);
                String colName = "";
                for (int i = 0; i < columnList.size(); ++i) {
                    colName = columnList.get(i);
                    crit = record.get(colName) != null ? crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0)) : crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)"", 0));
                }
            }
            return (result = this.recordCheckDO.getRow(generatedTableName, crit)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ArrayList<String> getConfigColumns() {
        HashSet<String> colList = new HashSet<String>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"TPIntegrationAttrMapping", (String)"CONFIG_ID"), (Object)this.configId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("TPIntegrationAttrMapping", criteria);
            if (dataObject != null) {
                Iterator it = dataObject.getRows("TPIntegrationAttrMapping");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    colList.add((String)row.get("DB_COLUMN"));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(colList);
    }

    private void createTable() {
        String generatedTableName = this.getLocalTableName();
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(generatedTableName);
                DatabaseMetaData meta = this.connection.getMetaData();
                String sqlTableName = this.configData.get("TABLE_NAME");
                ArrayList<String> pkList = this.getDBPrimaryKeys(sqlTableName);
                if (pkList.isEmpty()) {
                    pkList = this.getPrimaryKeysFromConfig(this.configId);
                }
                ResultSet resultSet = meta.getColumns(null, null, sqlTableName, "%");
                while (resultSet.next()) {
                    String colName = resultSet.getString("COLUMN_NAME");
                    if (tableDef.hasColumn(colName)) continue;
                    int dataType = resultSet.getInt("DATA_TYPE");
                    int columnSize = resultSet.getInt("COLUMN_SIZE");
                    String isNullable = resultSet.getString("IS_NULLABLE");
                    String mickeyColumnType = this.getMickeyColumnType(dataType);
                    ColumnDefinition coldef = new ColumnDefinition();
                    coldef.setColumnName(colName);
                    coldef.setDescription(" ");
                    coldef.setDataType(mickeyColumnType);
                    if (mickeyColumnType.equals("CHAR") && columnSize < 50) {
                        coldef.setMaxLength(255);
                    } else {
                        coldef.setMaxLength(columnSize);
                    }
                    if (isNullable.equalsIgnoreCase("yes")) {
                        coldef.setNullable(true);
                    } else {
                        coldef.setNullable(false);
                    }
                    tableDef.addColumnDefinition(coldef);
                }
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(generatedTableName + "_PK");
                for (String col : pkList) {
                    pkDef.addColumnName(col);
                }
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
                out.log(Level.INFO, "Created table :  " + generatedTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            out.log(Level.INFO, "Exception message :  " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentRecordsToDB() {
        ResultSet rs = null;
        try {
            String generatedTableName = this.getLocalTableName();
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            dataObject.deleteRows(generatedTableName, (Criteria)null);
            Statement stmt = this.connection.createStatement();
            String selectQuery = this.getAdvancedSelectQuery();
            rs = stmt.executeQuery(selectQuery);
            ResultSetMetaData columns = rs.getMetaData();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 1; i <= columns.getColumnCount(); ++i) {
                columnNames.add(columns.getColumnName(i));
            }
            while (rs.next()) {
                Row row = new Row(generatedTableName);
                for (int i = 1; i <= columns.getColumnCount(); ++i) {
                    String dbColumnName = columns.getColumnName(i);
                    Integer dbColumnType = columns.getColumnType(i);
                    String col = rs.getString(dbColumnName);
                    if (col != null) {
                        row.set(dbColumnName, (Object)this.getUpdatedValue(dbColumnName, col.trim()));
                        continue;
                    }
                    if (dbColumnType == 4) {
                        row.set(dbColumnName, null);
                        continue;
                    }
                    row.set(dbColumnName, (Object)"");
                }
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            out.log(Level.INFO, generatedTableName + " table updated");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getMickeyColumnType(int sqlType) {
        if (sqlType == -5) {
            return "BIGINT";
        }
        if (sqlType == 1) {
            return "CHAR";
        }
        if (sqlType == 4) {
            return "INTEGER";
        }
        if (sqlType == 16) {
            return "BOOLEAN";
        }
        if (sqlType == 91) {
            return "CHAR";
        }
        if (sqlType == 92) {
            return "TIME";
        }
        if (sqlType == 93) {
            return "TIMESTAMP";
        }
        if (sqlType == 2004) {
            return "BLOB";
        }
        if (sqlType == 6) {
            return "FLOAT";
        }
        if (sqlType == 8) {
            return "DOUBLE";
        }
        if (sqlType == -6) {
            return "TINYINT";
        }
        if (sqlType == 3) {
            return "CHAR";
        }
        if (sqlType == -15) {
            return "NCHAR";
        }
        if (sqlType == -9) {
            return "NCHAR";
        }
        if (sqlType == 12) {
            return "CHAR";
        }
        return "CHAR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getDBPrimaryKeys(String tableName) {
        ArrayList pkList = new ArrayList();
        ResultSet primaryKeyRS = null;
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            primaryKeyRS = meta.getPrimaryKeys(null, null, tableName);
            HashSet<String> dBPKeysSet = new HashSet<String>();
            while (primaryKeyRS.next()) {
                dBPKeysSet.add(primaryKeyRS.getString("COLUMN_NAME"));
            }
            pkList = new ArrayList(dBPKeysSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (primaryKeyRS != null) {
                try {
                    primaryKeyRS.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (pkList.size() == 0) {
            pkList = this.getPKListInAttrMapping();
        }
        return pkList;
    }

    protected ArrayList getLocalDBPrimaryKeys(String tableName) {
        try {
            TableDefinition tabledef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            PrimaryKeyDefinition primaryKeyDef = tabledef.getPrimaryKey();
            ArrayList pkList = new ArrayList(primaryKeyDef.getColumnList());
            return pkList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList getPKListInAttrMapping() {
        HashSet<String> hash_Set = new HashSet<String>();
        try {
            String tableName = "TPIntegrationAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)this.configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                if (!((Boolean)r.get("IS_PRIMARY")).booleanValue()) continue;
                hash_Set.add((String)r.get("DB_COLUMN"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList(hash_Set);
    }

    private String getUpdatedValue(String dbColumnName, String val) {
        Hashtable attrMapping = this.getAttrMapping();
        if (attrMapping.containsKey("userAccountControl") && ((String)attrMapping.get("userAccountControl")).equalsIgnoreCase(dbColumnName)) {
            ArrayList<String> activeState = new ArrayList<String>(Arrays.asList("true", "yes", "1", "active", "activated", "enable", "enabled", "512", "0;2"));
            if (activeState.contains(val.toLowerCase())) {
                return "0;2";
            }
            return "2;0";
        }
        return val;
    }

    private void updateLocalDBColumns() {
    }
}

