/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.ZPeopleInputDataSource;

public abstract class InputDataSource {
    private int inputSource;
    public static final String CSV_SOURCE = "csv";
    public static final String DB_SOURCE = "db";
    public static final String API_SOURCE = "api";
    public static final String WORKDAY = "workday";
    public static final String MSSQL = "mssql";
    public static final String ORACLE = "oracle";
    public static final String ZPEOPLE = "zPeople";

    public static InputDataSource getDataSourceInstance(String inputSource, int configId) {
        return InputDataSource.getDataSourceInstance(inputSource, configId, null);
    }

    private static InputDataSource getDataSourceInstance(String inputSource, int configId, String secondarySource) {
        try {
            InputDataSource dataSource = null;
            if (!inputSource.equals(CSV_SOURCE)) {
                if (inputSource.equals(DB_SOURCE)) {
                    dataSource = DBInputDataSource.getInstance(configId);
                } else if (!inputSource.equals(API_SOURCE) && !inputSource.equals("Mernis")) {
                    if (inputSource.equals(WORKDAY)) {
                        dataSource = new WorkdayInputDataSource(configId);
                    } else if (inputSource.equals(ZPEOPLE)) {
                        dataSource = new ZPeopleInputDataSource(configId);
                    }
                }
            }
            return dataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract GenericData readData(String var1);

    public abstract void postExecutionUpdate(String var1);
}

