/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class MSSQLInputDataSource
extends DBInputDataSource {
    public static final String WINDOWS_AUTH = "windows";
    public static final String SQL_AUTH = "sql";

    public MSSQLInputDataSource(int configId, Long scheduleId) throws Exception {
        super(configId, scheduleId);
    }

    @Override
    protected String getUrlString() {
        String serverName = (String)this.configData.get("SERVER_NAME");
        String port = (String)this.configData.get("PORT_NUMBER");
        String instanceName = (String)this.configData.get("INSTANCE_NAME");
        String databaseName = (String)this.configData.get("DATABASE_NAME");
        String domainName = (String)this.configData.get("DOMAIN_NAME");
        String authenticationType = (String)this.configData.get("AUTHENTICATION_TYPE");
        String url = "jdbc:jtds:sqlserver://" + serverName + ":" + port + "/" + instanceName + ";databaseName=" + databaseName + ";";
        if (WINDOWS_AUTH.equals(authenticationType)) {
            url = url + "useNTLMv2=true;domain=" + domainName + "";
        }
        return url;
    }

    @Override
    protected String getDriverClass() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    @Override
    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        query.append("select * from [" + (String)this.configData.get("TABLE_NAME") + "]");
        return query.toString();
    }

    @Override
    protected Hashtable getConfigData(int configId) {
        Hashtable configData = new Hashtable();
        try {
            configData = DBDataSourceUtil.getConfigDetails(configId);
            return configData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return configData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isTableExists(String tableName) {
        ResultSet tables = null;
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            tables = meta.getTables(null, null, tableName, null);
            if (tables.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

