/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class OracleDataSourceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDBConnection(String serverName, String portNumber, String username, String password, String databaseName) {
        Connection conn = null;
        try {
            String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + databaseName + "";
            String driverClass = "oracle.jdbc.driver.OracleDriver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Hashtable getDBSpecificDetails(int configId) {
        Hashtable<String, Object> configData = new Hashtable<String, Object>();
        try {
            String tableName = "OracleInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                configData.put("SID", r.get("SID"));
                configData.put("TABLE_NAME", ((String)r.get("TABLE_NAME")).toUpperCase());
                configData.put("IS_VALID", Boolean.toString((Boolean)r.get("IS_VALID")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public static boolean addDBConfigData(Hashtable<String, String> props, Integer configId) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row3 = new Row("OracleInputConfig");
            row3.set("SID", (Object)props.get("sid"));
            row3.set("TABLE_NAME", (Object)props.get("tableName"));
            row3.set("CONFIG_ID", (Object)configId);
            row3.set("IS_VALID", (Object)true);
            dataObject.addRow(row3);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean updateDBConfigData(Integer configId, Hashtable<String, String> props) {
        try {
            String tableName = "OracleInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                r.set("SID", (Object)props.get("sid"));
                r.set("TABLE_NAME", (Object)props.get("tableName"));
                r.set("IS_VALID", (Object)true);
                dataObject.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ArrayList getColumnList(String databaseName, String tableName) {
        Iterator it = OracleDataSourceUtil.getColumnNameVsTypeMapping(databaseName, tableName).keys();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateConnection(Hashtable<String, String> props) {
        Connection conn = null;
        ResultSet resultSet = null;
        ArrayList list = new ArrayList();
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("oracle");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String dbSid = props.get("sid");
            String tableName = props.get("tableName");
            String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + dbSid + "";
            String driverClass = "oracle.jdbc.driver.OracleDriver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            Statement stmt = conn.createStatement();
            resultSet = stmt.executeQuery("select * from all_tab_columns where table_name='" + tableName.toUpperCase() + "'");
            if (resultSet != null && !resultSet.next()) {
                String string = "table_does_not_exists";
                return string;
            }
            resultSet.close();
            DatabaseMetaData meta = conn.getMetaData();
            resultSet = meta.getPrimaryKeys(null, null, tableName.toUpperCase());
            if (!resultSet.next()) {
                JSONArray jsonArr = new JSONArray(props.get("attrMapping"));
                for (int ii = 0; ii < jsonArr.length(); ++ii) {
                    JSONObject jsonObj = (JSONObject)jsonArr.get(ii);
                    String isPrimary = (String)jsonObj.get("isPrimary");
                    if (!isPrimary.equalsIgnoreCase("true")) continue;
                    String string = "success";
                    return string;
                }
                String ii = "empty_primary_keys_list";
                return ii;
            }
            String string = "success";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ArrayList getAvailableDBNames() {
        ArrayList<String> dbList = new ArrayList<String>();
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("oracle");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String databaseName = (String)dbDetails.get("instanceName");
            String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + databaseName + "";
            String driverClass = "oracle.jdbc.driver.OracleDriver";
            Class.forName(driverClass);
            Connection conn = DriverManager.getConnection(url, username, password);
            Statement stmt = conn.createStatement();
            ResultSet resultSet = stmt.executeQuery("select name from v$database");
            if (resultSet != null) {
                while (resultSet.next()) {
                    String val = resultSet.getString(1);
                    dbList.add(val);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Connection exception occurred...");
            e.printStackTrace();
        }
        return dbList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getColumnNameVsTypeMapping(String databaseName, String tableName) {
        Connection conn = null;
        ResultSet resultSet = null;
        JSONObject columnDataTypeMap = new JSONObject();
        if (databaseName == null || databaseName.equals("") || tableName == null || tableName.equals("")) {
            return columnDataTypeMap;
        }
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("oracle");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + databaseName + "";
            String driverClass = "oracle.jdbc.driver.OracleDriver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            resultSet = conn.getMetaData().getColumns(null, null, tableName.toUpperCase(), null);
            if (resultSet != null) {
                while (resultSet.next()) {
                    columnDataTypeMap.put(resultSet.getString("COLUMN_NAME"), (Object)resultSet.getString("TYPE_NAME"));
                }
            }
            JSONObject jSONObject = columnDataTypeMap;
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONObject jSONObject = columnDataTypeMap;
            return jSONObject;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

