/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.integration.CrossObjectProvisionController;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayInputDataSource;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkdayUtil {
    public static final String TP_INTEGRATION_CONFIG = "TPIntegrationConfig";
    public static final String AD_ACTION_EXECUTER_CONFIG = "ADActionExecuterConfig";
    public static final String WORKDAY_ACCOUNT_DETAILS = "WorkdayAccountDetails";
    public static final String INPUT_SOURCE = "INPUT_SOURCE";
    public static final String CONFIG_ID = "CONFIG_ID";
    public static final String prefixBsvc = "bsvc";
    public static final String prefixWsse = "wsse";
    public static final String bsvcNamespace = "urn:com.workday/bsvc";
    public static final String wsseNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    Logger logger = Logger.getLogger(WorkdayUtil.class.getName());

    public static String saveWorkdayAccount(HttpServletRequest request, String workdayJsonStr) {
        String message = "admp.admin.workday.workday_account_unsuccessful";
        try {
            JSONObject workdayJson = new JSONObject(workdayJsonStr);
            String username = workdayJson.getString("tenantId");
            String password = workdayJson.getString("tenantPass");
            String endpoint = workdayJson.getString("endPointUrl");
            WorkdayUtil.deleteOldWorkdayDetails();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row2 = new Row(WORKDAY_ACCOUNT_DETAILS);
            row2.set("WORKDAY_TENANT_ID", (Object)username);
            row2.set("PASSWORD", (Object)password);
            row2.set("ENDPOINT_URL", (Object)endpoint);
            dataObject.addRow(row2);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            message = "admp.admin.workday.workday_account_successful";
        }
        catch (Exception e) {
            message = "admp.admin.workday.workday_account_unsuccessful";
            e.printStackTrace();
        }
        return message;
    }

    public static void deleteOldWorkdayDetails() {
        try {
            DataAccess.delete((String)WORKDAY_ACCOUNT_DETAILS, (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String startWorkdaySync() {
        String message = "admp.admin.workday.workday_account_unsuccessful";
        Hashtable workdayProperties = WorkdayUtil.getWorkdayAccountDetails();
        String configId = (String)workdayProperties.get(CONFIG_ID);
        try {
            CrossObjectProvisionController.getInstance().performAction(Integer.parseInt(configId));
            message = "admp.admin.workday.workday_sync_successful";
        }
        catch (Exception e) {
            message = "admp.admin.workday.workday_account_unsuccessful";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testConnection(HttpServletRequest request, String workdayJsonStr) {
        SOAPConnection soapConnection = null;
        String message = "admp.admin.workday.workday_account_unsuccessful";
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            soapConnection = soapConnectionFactory.createConnection();
            JSONObject workdayJson = new JSONObject(workdayJsonStr);
            String username = workdayJson.getString("tenantId");
            String password = workdayJson.getString("tenantPass");
            String workdayEndPoint = workdayJson.getString("endPointUrl");
            String tenantId = "";
            if (username.split("@").length > 1) {
                tenantId = username.split("@")[1];
            }
            WorkdayInputDataSource workdayInputDataSource = new WorkdayInputDataSource(0);
            SOAPMessage getWorkersMsg = workdayInputDataSource.createGetWorkersRequest(username, password);
            String string = message = WorkdayUtil.getResponse(getWorkersMsg, workdayEndPoint, workdayInputDataSource, 0);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                soapConnection.close();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
        return message;
    }

    public static String getResponse(SOAPMessage getWorkersMsg, String endpoint, WorkdayInputDataSource workdayInputDataSource, int counter) throws Exception {
        SOAPConnection soapConnection = null;
        String message = "admp.admin.workday.workday_account_unsuccessful";
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        try {
            soapConnection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = soapConnection.call(getWorkersMsg, (Object)endpoint);
            message = soapResponse.getSOAPPart().getEnvelope().getBody().getFault() == null ? "admp.admin.workday.workday_account_successful" : soapResponse.getSOAPPart().getEnvelope().getBody().getFault().getFaultString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static SOAPMessage createAuthenticationMessage(String username, String password) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration(prefixBsvc, bsvcNamespace);
        envelope.addNamespaceDeclaration(prefixWsse, wsseNamespace);
        SOAPHeader workersReqHeader = envelope.getHeader();
        WorkdayUtil.addCommonHeader(workersReqHeader);
        WorkdayUtil.addAuthenticationElement(workersReqHeader, username, password);
        return soapMessage;
    }

    public static void addCommonHeader(SOAPHeader workersReqHeader) throws Exception {
        SOAPElement commonHeader = workersReqHeader.addChildElement("Workday_Common_Header", prefixBsvc);
        SOAPElement commonHeader2 = commonHeader.addChildElement("Include_Reference_Descriptors_In_Response", prefixBsvc);
        commonHeader2.addTextNode("false");
    }

    public static void addAuthenticationElement(SOAPHeader workersReqHeader, String username, String password) throws Exception {
        SOAPHeaderElement securityHeader = (SOAPHeaderElement)workersReqHeader.addChildElement("Security", prefixWsse);
        securityHeader.setMustUnderstand(true);
        SOAPElement usernameTokenElement = securityHeader.addChildElement("UsernameToken", prefixWsse);
        SOAPElement usernameElement = usernameTokenElement.addChildElement("Username", prefixWsse);
        usernameElement.addTextNode(username);
        SOAPElement passwordElement = usernameTokenElement.addChildElement("Password", prefixWsse);
        passwordElement.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        passwordElement.addTextNode(password);
    }

    public static Hashtable getWorkdayAccountDetails() {
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(WORKDAY_ACCOUNT_DETAILS, (Criteria)null);
            if (dataObject.isEmpty()) {
                return null;
            }
            Row r = dataObject.getFirstRow(WORKDAY_ACCOUNT_DETAILS);
            values.put("username", r.get("WORKDAY_TENANT_ID") == null ? "" : r.get("WORKDAY_TENANT_ID"));
            values.put("password", r.get("PASSWORD") == null ? "" : r.get("PASSWORD"));
            values.put("endPoint", r.get("ENDPOINT_URL"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static void addCredentials(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject obj = new JSONObject();
            String credDetailsJsonTxt = request.getParameter("credDetails");
            String message = WorkdayUtil.testConnection(request, credDetailsJsonTxt);
            String status = "failure";
            if (message.equals("admp.admin.workday.workday_account_successful")) {
                message = WorkdayUtil.saveWorkdayAccount(request, credDetailsJsonTxt);
            }
            if (message.equals("admp.admin.workday.workday_account_successful")) {
                status = "success";
            }
            obj.put("status", (Object)status);
            obj.put("message", (Object)rb.getString(message));
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString(obj.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static JSONArray getDBAttrMapping(int configId) {
        JSONArray mappingData = new JSONArray();
        try {
            JSONObject columnProps = WorkdayUtil.getColumnsPropertiesList();
            String tableName = "WorkdayIntegAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)CONFIG_ID), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("dbColumnName", r.get("WD_COLUMN"));
                jsonObj.put("ldapName", r.get("GENERIC_COLUMN"));
                jsonObj.put("isPrimary", r.get("IS_PRIMARY"));
                jsonObj.put("dataType", columnProps.getJSONObject((String)r.get("WD_COLUMN")).get("DATA_TYPE"));
                mappingData.put((Object)jsonObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappingData;
    }

    public static JSONObject getColumnsPropertiesList() {
        JSONObject wdColumns = new JSONObject();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayCustomColumnDetails", (Criteria)null);
            Iterator it = dataObject.getRows("WorkdayCustomColumnDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject props = new JSONObject();
                try {
                    props.put("DB_COLUMN", (Object)((String)r.get("DB_COLUMN")));
                    props.put("DATA_TYPE", ((Integer)r.get("DATA_TYPE")).intValue());
                    props.put("LENGTH", (Object)((Integer)r.get("LENGTH")));
                    props.put("ISNULLABLE", ((Boolean)r.get("ISNULLABLE")).booleanValue());
                    wdColumns.put((String)r.get("DISPLAY_FORMAT"), (Object)props);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return wdColumns;
    }

    public static HashMap getDisplayVsTableColumnsMapping() {
        HashMap<String, String> wdColumnsMap = new HashMap<String, String>();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayCustomColumnDetails", (Criteria)null);
            Iterator it = dataObject.getRows("WorkdayCustomColumnDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                wdColumnsMap.put((String)r.get("DISPLAY_FORMAT"), (String)r.get("DB_COLUMN"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return wdColumnsMap;
    }

    public static JSONObject getColumnNameVsTypeMapping() {
        JSONObject wdColumnsMap = new JSONObject();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayCustomColumnDetails", (Criteria)null);
            Iterator it = dataObject.getRows("WorkdayCustomColumnDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                try {
                    wdColumnsMap.put((String)r.get("DISPLAY_FORMAT"), (Object)Integer.toString((Integer)r.get("DATA_TYPE")));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return wdColumnsMap;
    }

    public static ArrayList getDisplayColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        try {
            String tableName = "WorkdayCustomColumnDetails";
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.setCriteria((Criteria)null);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"DISPLAY_FORMAT"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows("WorkdayCustomColumnDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                colList.add((String)r.get("DISPLAY_FORMAT"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return colList;
    }
}

