/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.manageengine.ads.fw.ssl.ADSURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ZPeopleUtil {
    public static final String ZOHO_ACCOUNT_DETAILS = "ZohoAccountDetails";
    public static final String ZOHO_COLUMN_DETAILS = "ZohoCustomColumnDetails";
    public static final String CONFIG_ID = "CONFIG_ID";
    public static final String ZOHO_AUTH_API = "https://accounts.zoho.com/apiauthtoken/nb/create?SCOPE=zohopeople/peopleapi";
    public static final String ZOHO_FETCH_EMPLOYEES_API = "https://people.zoho.com/people/api/forms/employee/getRecords";
    Logger logger = Logger.getLogger(ZPeopleUtil.class.getName());
    static String lineSeparator = System.getProperty("line.separator");

    public static String saveZohoAccount(JSONObject authJSON) {
        String message = "admp.admin.integrations.zpeople.account_unsuccessful";
        try {
            String mailId = authJSON.getString("ZOHO_MAIL_ID");
            String authtoken = authJSON.getString("AUTHTOKEN");
            String auth_gen_time = authJSON.getString("AUTH_GEN_TIME");
            ZPeopleUtil.deleteOldZohoDetails(mailId);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row2 = new Row(ZOHO_ACCOUNT_DETAILS);
            row2.set("ZOHO_MAIL_ID", (Object)mailId);
            row2.set("AUTHTOKEN", (Object)authtoken);
            row2.set("AUTH_GEN_TIME", (Object)auth_gen_time);
            dataObject.addRow(row2);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            message = "admp.admin.integrations.zpeople.account_successful";
        }
        catch (Exception e) {
            message = "admp.admin.integrations.zpeople.account_unsuccessful";
            e.printStackTrace();
        }
        return message;
    }

    public static void deleteOldZohoDetails(String mailId) {
        try {
            DataAccess.delete((String)ZOHO_ACCOUNT_DETAILS, (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String testConnection(JSONObject authJSON) {
        String message = "admp.admin.integrations.zpeople.account_unsuccessful";
        try {
            String mailId = authJSON.getString("ZOHO_MAIL_ID");
            String password = authJSON.getString("PASSWORD");
            StringBuilder endPoint = new StringBuilder();
            endPoint.append(ZOHO_AUTH_API);
            endPoint.append("&");
            endPoint.append("EMAIL_ID=");
            endPoint.append(mailId);
            endPoint.append("&");
            endPoint.append("PASSWORD=");
            endPoint.append(password);
            String response = ZPeopleUtil.getResponse(endPoint.toString());
            if (!response.equalsIgnoreCase("failed")) {
                String[] responseLines = response.split(lineSeparator);
                for (int i = 0; i < responseLines.length; ++i) {
                    String line = responseLines[i];
                    if (line.contains("#")) {
                        authJSON.put("AUTH_GEN_TIME", (Object)line.substring(line.lastIndexOf("#") + 1));
                        continue;
                    }
                    if (line.contains("AUTHTOKEN=")) {
                        authJSON.put("AUTHTOKEN", (Object)line.substring(line.lastIndexOf("AUTHTOKEN") + 10));
                        continue;
                    }
                    if (line.contains("CAUSE=")) {
                        authJSON.put("CAUSE", (Object)line.substring(line.lastIndexOf("CAUSE") + 6));
                        continue;
                    }
                    if (!line.contains("RESULT=")) continue;
                    String result = line.substring(line.lastIndexOf("RESULT") + 7);
                    if (result.equalsIgnoreCase("true")) {
                        message = "admp.admin.integrations.zpeople.account_successful";
                    } else {
                        String cause = authJSON.getString("CAUSE");
                        if (cause != null && !cause.equalsIgnoreCase("")) {
                            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                            message = rb.getString(message) + rb.getString("admp.workflow.commitrequest.statmsg.error") + cause;
                        }
                    }
                    authJSON.put("RESULT", (Object)result);
                }
            }
        }
        catch (Exception e) {
            message = "admp.admin.integrations.zpeople.account_unsuccessful";
            e.printStackTrace();
        }
        return message;
    }

    public static HashMap getAuthDetails() throws Exception {
        HashMap<String, Object> authDetails = new HashMap<String, Object>();
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ZOHO_ACCOUNT_DETAILS, (Criteria)null);
        if (dataObject.isEmpty()) {
            throw new Exception("No Zoho Account Configured");
        }
        Row r = dataObject.getFirstRow(ZOHO_ACCOUNT_DETAILS);
        authDetails.put("AUTHTOKEN", r.get("AUTHTOKEN"));
        authDetails.put("ZOHO_MAIL_ID", r.get("ZOHO_MAIL_ID"));
        return authDetails;
    }

    public static String getResponse(String url) {
        String message = "failed";
        try {
            HttpURLConnection connection = ADSURLConnection.openADSURLConnection((String)url);
            StringBuilder response = new StringBuilder();
            String line = "";
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append(lineSeparator);
            }
            message = response.toString();
        }
        catch (SSLHandshakeException e) {
            message = "failed";
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "failed";
        }
        return message;
    }

    public static Hashtable getZohoAccountDetails() {
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ZOHO_ACCOUNT_DETAILS, (Criteria)null);
            if (dataObject.isEmpty()) {
                return null;
            }
            Row r = dataObject.getFirstRow(ZOHO_ACCOUNT_DETAILS);
            values.put("ZOHO_MAIL_ID", r.get("ZOHO_MAIL_ID") == null ? "" : r.get("ZOHO_MAIL_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static void addCredentials(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject obj = new JSONObject();
            String credDetailsJsonTxt = request.getParameter("credDetails");
            JSONObject authJSON = new JSONObject(credDetailsJsonTxt);
            String status = "";
            String message = ZPeopleUtil.testConnection(authJSON);
            if (message == "admp.admin.integrations.zpeople.account_successful") {
                message = ZPeopleUtil.saveZohoAccount(authJSON);
            }
            status = message.contains("admp.admin.integrations.zpeople.account_successful") ? "success" : "failure";
            obj.put("status", (Object)status);
            obj.put("message", (Object)rb.getString(message));
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString(obj.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static JSONArray getDBAttrMapping(int configId) {
        JSONArray mappingData = new JSONArray();
        try {
            JSONObject columnProps = ZPeopleUtil.getColumnsPropertiesList();
            String tableName = "ZohoIntegAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)CONFIG_ID), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("dbColumnName", r.get("ZP_COLUMN"));
                jsonObj.put("ldapName", r.get("GENERIC_COLUMN"));
                jsonObj.put("isPrimary", r.get("IS_PRIMARY"));
                jsonObj.put("dataType", columnProps.getJSONObject((String)r.get("ZP_COLUMN")).get("DATA_TYPE"));
                mappingData.put((Object)jsonObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappingData;
    }

    public static JSONObject getColumnsPropertiesList() {
        JSONObject zpColumns = new JSONObject();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ZOHO_COLUMN_DETAILS, (Criteria)null);
            Iterator it = dataObject.getRows(ZOHO_COLUMN_DETAILS);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject props = new JSONObject();
                try {
                    props.put("DB_COLUMN", (Object)((String)r.get("DB_COLUMN")));
                    props.put("DATA_TYPE", ((Integer)r.get("DATA_TYPE")).intValue());
                    props.put("LENGTH", (Object)((Integer)r.get("LENGTH")));
                    props.put("ISNULLABLE", ((Boolean)r.get("ISNULLABLE")).booleanValue());
                    zpColumns.put((String)r.get("DISPLAY_FORMAT"), (Object)props);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return zpColumns;
    }

    public static HashMap getDisplayVsTableColumnsMapping() {
        HashMap<String, String> zpColumnsMap = new HashMap<String, String>();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ZOHO_COLUMN_DETAILS, (Criteria)null);
            Iterator it = dataObject.getRows(ZOHO_COLUMN_DETAILS);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                zpColumnsMap.put((String)r.get("DISPLAY_FORMAT"), (String)r.get("DB_COLUMN"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return zpColumnsMap;
    }

    public static JSONObject getColumnNameVsTypeMapping() {
        JSONObject zpColumnsMap = new JSONObject();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ZOHO_COLUMN_DETAILS, (Criteria)null);
            Iterator it = dataObject.getRows(ZOHO_COLUMN_DETAILS);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                try {
                    zpColumnsMap.put((String)r.get("DISPLAY_FORMAT"), (Object)Integer.toString((Integer)r.get("DATA_TYPE")));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return zpColumnsMap;
    }

    public static ArrayList getDisplayColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        try {
            String tableName = ZOHO_COLUMN_DETAILS;
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.setCriteria((Criteria)null);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"DISPLAY_FORMAT"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows(ZOHO_COLUMN_DETAILS);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                colList.add((String)r.get("DISPLAY_FORMAT"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return colList;
    }

    public static void updateLastSyncTime(Long scheduleId, Long lastSyncTime) {
        try {
            String tableName = "TPIntegrationScheduleMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                r.set("LAST_SYNCED_TIME", (Object)lastSyncTime);
                dataObject.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getLastSyncTime(Long scheduleId) {
        try {
            String tableName = "TPIntegrationScheduleMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                return (Long)r.get("LAST_SYNCED_TIME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Hashtable getAttrMapping(int configId) {
        HashMap localColumnMapping = ZPeopleUtil.getDisplayVsTableColumnsMapping();
        Hashtable<String, String> customAttribToLDAPMapping = new Hashtable<String, String>();
        customAttribToLDAPMapping.put("accountStatus", "userAccountControl");
        Hashtable mappingData = new Hashtable();
        try {
            String tableName = "ZohoIntegAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)CONFIG_ID), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ldapValue = (String)r.get("GENERIC_COLUMN");
                String dbColumn = (String)localColumnMapping.get((String)r.get("ZP_COLUMN"));
                if (customAttribToLDAPMapping.containsKey(ldapValue)) {
                    mappingData.put(customAttribToLDAPMapping.get(ldapValue), dbColumn);
                    continue;
                }
                mappingData.put(ldapValue, dbColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappingData;
    }

    public static ArrayList<String> getAdvncConfigColumns(int configId) {
        HashSet colList = new HashSet();
        HashMap localColumnMapping = ZPeopleUtil.getDisplayVsTableColumnsMapping();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ZohoIntegAttrMapping", (String)CONFIG_ID), (Object)configId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ZohoIntegAttrMapping", criteria);
            if (dataObject != null) {
                Iterator it = dataObject.getRows("ZohoIntegAttrMapping");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    colList.add(localColumnMapping.get((String)row.get("ZP_COLUMN")));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(colList);
    }

    static {
        if (lineSeparator == null) {
            lineSeparator = "\r012";
        }
    }
}

