/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.CopyObjectUtil;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

class CopyObjectExecuteFlow {
    private static Logger logger = Logger.getLogger("FcLogger");
    private static Long templateCategoryId = 1L;

    CopyObjectExecuteFlow() {
    }

    public static FcFormDataContainer getCopyObjectValues(FcFormDataContainer fcFormDataContainer, Boolean isExecutionPage, Long loginId, FcExecuteFormBean fcExecuteFormBean, String objectGUIDToCopy) {
        FcFormDataContainer copiedADData = new FcFormDataContainer();
        FcFormDataContainer fcToCopyDataContainer = CopyObjectExecuteFlow.getLastSaveFormDataContainer(fcFormDataContainer, isExecutionPage, fcExecuteFormBean.getTemplateCategoryId(), loginId);
        ArrayList attribList = FcExecuteFormFlow.getLDAPNames(fcExecuteFormBean.getTemplateCategoryId(), fcToCopyDataContainer);
        CopyObjectExecuteFlow.removeUnAuthorizedAttributes(attribList);
        templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
        CopyObjectExecuteFlow.getCopyObjectValues(attribList, fcToCopyDataContainer, copiedADData, fcExecuteFormBean.getDomainName(), loginId, objectGUIDToCopy, fcExecuteFormBean.getIsWorkFlowMode());
        return copiedADData;
    }

    private static void getCopyObjectValues(ArrayList attribList, FcFormDataContainer fcFormDataContainer, FcFormDataContainer copyDataContainer, String domainName, Long loginId, String objectGUIDToCopy, boolean isWorkflowMode) {
        try {
            ArrayList valueList;
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(objectGUIDToCopy, domainName, loginId, attribList);
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("loginId", loginId);
            prop.put("templateCategoryId", templateCategoryId);
            prop.put("isWorkflowMode", (Object)isWorkflowMode);
            if (attribList.contains("pwdLastSet") && (valueList = (ArrayList)valuesList.get("distinguishedName")) != null) {
                prop.put("cantChangePwdValue", (Object)ADHandler.getUserCantChangePwd((String)domainName, (Long)loginId, (String)((String)valueList.get(0))));
            }
            CopyObjectExecuteFlow.fillCopiedValue(fcFormDataContainer, copyDataContainer, valuesList, prop, domainName, loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fillCopiedValue(FcFormDataContainer fcFormDataContainer, FcFormDataContainer copyDataContainer, Properties valuesList, Properties prop, String domainName, Long loginId) {
        try {
            prop.put("isCopyExecuteFlow", (Object)true);
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, copyDataContainer, valuesList, prop, false);
                fcLayoutField.getIComponent().setCopyObjectValues(fcLayoutField, copyDataContainer, valuesList, prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getCopyObjectPreivewPageView(FcFormDataContainer fcFormDataContainer, AdventNetResourceBundle rb) {
        JSONArray fieldsPreviewJsonArray = new JSONArray();
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fromClientField = (FcLayoutField)e.nextElement();
                Long fieldId = fromClientField.getFieldId();
                JSONObject fieldJsonObj = new JSONObject();
                fieldJsonObj.put("fieldDisplayText", (Object)fromClientField.getAttribDisplayText());
                fieldJsonObj.put("previewVal", (Object)fromClientField.getIComponent().getRuleFieldListDisplayValue(rb, false));
                fieldJsonObj.put("fieldId", (Object)fieldId);
                fieldsPreviewJsonArray.put((Object)fieldJsonObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldsPreviewJsonArray;
    }

    private static FcFormDataContainer getLastSaveFormDataContainer(FcFormDataContainer fcFormDataContainer, Boolean isExecutionPage, Long templateCategoryId, Long loginId) {
        ArrayList lastSaveFields = CopyObjectUtil.getLastSavedFields((Long)templateCategoryId, (Long)loginId);
        FcFormDataContainer fcToCopyDataContainer = new FcFormDataContainer();
        for (int i = 0; i < lastSaveFields.size(); ++i) {
            FcLayoutField fcLayoutField = (FcLayoutField)fcFormDataContainer.get(lastSaveFields.get(i));
            if (fcLayoutField == null || isExecutionPage.booleanValue() && (fcLayoutField.getIsReadOnly().booleanValue() || fcLayoutField.getIsHidden().booleanValue() || !fcLayoutField.getIsAuthorized().booleanValue())) continue;
            fcToCopyDataContainer.put((Object)fcLayoutField.getFieldId(), (Object)fcLayoutField.clone());
        }
        return fcToCopyDataContainer;
    }

    private static void removeUnAuthorizedAttributes(ArrayList attributeList) {
        if (attributeList.remove("OUName") || attributeList.contains("pwdLastSet")) {
            attributeList.add("distinguishedName");
        }
        attributeList.add("sAMAccountName");
    }
}

