/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public class FcBUCResultsDataSource
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long loginId = reqParams.getLoginId();
            ArrayList headerColumnList = new ArrayList();
            ArrayList<HashMap> headerList = new ArrayList<HashMap>();
            Long cvId = RVUtil.getCustomViewId((int)reqParams.getRvId());
            logger.log(Level.FINE, "CV ID for the rvid " + reqParams.getRvId() + " is " + cvId);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            for (int index = 0; index < headerColumnList.size(); ++index) {
                HashMap details = (HashMap)headerColumnList.get(index);
                String tableName = (String)details.get("TABLE_NAME");
                if (tableName.equalsIgnoreCase("ADSMUserCustomDetails")) continue;
                headerList.add(details);
            }
            this.setTotalColumnList(headerList);
            this.setUniqueId(reqParams.getFilterId());
            ArrayList columnList = ColumnConfiguration.getTotalColumnList((long)cvId);
            ArrayList<Column> selectColumns = new ArrayList<Column>();
            for (int index = 0; index < columnList.size(); ++index) {
                HashMap details = (HashMap)columnList.get(index);
                String columnName = (String)details.get("COLUMN_NAME");
                String tableName = (String)details.get("TABLE_NAME");
                if (tableName.equalsIgnoreCase("ADSMUserCustomDetails") || tableName.equalsIgnoreCase("FcBulkUserManagerVals") || tableName.equalsIgnoreCase("FcBulkUserSelectContainerVals")) continue;
                selectColumns.add(Column.getColumn((String)tableName, (String)columnName));
            }
            selectColumns.add(Column.getColumn((String)"FcBulkUserSingleVals", (String)"PASSWORD_TYPE"));
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"FcBulkObjectIndexDetails"));
            query.addSelectColumns(selectColumns);
            boolean isFcBulkExchOnlineSingleValsPresent = false;
            for (Column c : query.getSelectColumns()) {
                if (!c.getTableAlias().equalsIgnoreCase("FcBulkExchOnlineSingleVals")) continue;
                isFcBulkExchOnlineSingleValsPresent = true;
                break;
            }
            query.addJoin(new Join("FcBulkObjectIndexDetails", "FcBulkUserSingleVals", new String[]{"OBJECT_INDEX_ID"}, new String[]{"OBJECT_INDEX_ID"}, 1));
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)reqParams.getGenerationId(), 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"FcBulkUserSingleVals", (String)"OBJECT_INDEX_TYPE"), (Object)2, 0));
            if (isFcBulkExchOnlineSingleValsPresent) {
                SelectQueryImpl q1 = new SelectQueryImpl(Table.getTable((String)"FcBulkExchOnlineSingleVals"));
                q1.addSelectColumn(Column.getColumn((String)"FcBulkExchOnlineSingleVals", (String)"OBJECT_INDEX_ID"));
                for (Column c : query.getSelectColumns()) {
                    if (!c.getTableAlias().equalsIgnoreCase("FcBulkExchOnlineSingleVals")) continue;
                    q1.addSelectColumn(c);
                }
                q1.setCriteria(new Criteria(Column.getColumn((String)"FcBulkExchOnlineSingleVals", (String)"OBJECT_INDEX_TYPE"), (Object)2, 0));
                query.addJoin(new Join(Table.getTable((String)"FcBulkObjectIndexDetails"), (Table)new DerivedTable("FcBulkExchOnlineSingleVals", (Query)q1), new String[]{"OBJECT_INDEX_ID"}, new String[]{"OBJECT_INDEX_ID"}, 1));
            }
            query.setCriteria(crit);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getRange());
            query.setRange(range);
            query.addSortColumn(new SortColumn(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"), true));
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, String> rowData = null;
            HashMap pwdMap = null;
            String tempTable = "ADSMUserBUCDetails_" + String.valueOf(reqParams.getGenerationId());
            TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tempTable);
            if (td != null) {
                pwdMap = FcLayoutBulkViewHandler.getFromBulkUserLayoutTempTable((String)tempTable);
            }
            while (dataSet.next()) {
                rowData = new HashMap<Object, String>();
                HashMap inputValues = null;
                String objectIndexID = null;
                for (int index = 0; index < columnList.size(); ++index) {
                    Row r;
                    DataObject dataObj;
                    Criteria c;
                    inputValues = new HashMap();
                    HashMap details = (HashMap)columnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String tableName = (String)details.get("TABLE_NAME");
                    String value = "";
                    if (tableName.equalsIgnoreCase("ADSMUserCustomDetails")) continue;
                    if (columnName.equalsIgnoreCase("OBJECT_INDEX_ID")) {
                        objectIndexID = value = ((Long)dataSet.getValue(columnName)).toString();
                        rowData.put("OBJECT_INDEX_ID", value);
                    } else if (columnName.equalsIgnoreCase("OU_NAME")) {
                        c = new Criteria(Column.getColumn((String)"FcBulkUserSelectContainerVals", (String)"OBJECT_INDEX_ID"), (Object)objectIndexID, 0);
                        c = c.and(new Criteria(Column.getColumn((String)"FcBulkUserSelectContainerVals", (String)"OBJECT_INDEX_TYPE"), (Object)2, 0));
                        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkUserSelectContainerVals", c);
                        if (!dataObj.isEmpty() && (r = dataObj.getFirstRow("FcBulkUserSelectContainerVals")) != null) {
                            value = (String)r.get("OU_NAME");
                        }
                    } else if (columnName.equalsIgnoreCase("MANAGER") || columnName.equalsIgnoreCase("MANAGED_BY")) {
                        c = new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_ID"), (Object)objectIndexID, 0);
                        c = c.and(new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_TYPE"), (Object)2, 0));
                        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkUserManagerVals", c);
                        if (!dataObj.isEmpty() && (r = dataObj.getFirstRow("FcBulkUserManagerVals")) != null) {
                            value = (String)r.get("MANAGER");
                        }
                    } else if (columnName.equalsIgnoreCase("PASSWORD")) {
                        value = objectIndexID != null && pwdMap != null && pwdMap.get(Long.valueOf(objectIndexID)) != null ? (String)pwdMap.get(Long.valueOf(objectIndexID)) : (String)dataSet.getValue(columnName);
                        rowData.put("PASSWORD_TYPE", (String)dataSet.getValue("PASSWORD_TYPE"));
                    } else if (columnName.equalsIgnoreCase("O365MANAGER")) {
                        if (dataSet.getValue(columnName) == null) {
                            value = "";
                        } else {
                            value = (String)dataSet.getValue(columnName);
                            String newValue = O365MgmtHandler.getExchangeIdentityForObjectId((String)value);
                            if (newValue != null) {
                                value = newValue;
                            }
                        }
                    } else {
                        value = dataSet.getValue(columnName) == null ? "" : rb.getString((String)dataSet.getValue(columnName));
                    }
                    rowData.put(columnId, value);
                }
                this.tableData.add(rowData);
            }
            this.setTotalResultCount((long)FcLayoutBulkViewHandler.getCSVRowCount((Long)reqParams.getGenerationId()));
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }

    public String getCreationStatus(Long newObjectCreationId) {
        String creationStatus = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)newObjectCreationId, 0);
            DataObject objectCreationDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkObjectIndexDetails", crit);
            Row objectIndexRow = objectCreationDetailsDO.getRow("FcBulkObjectIndexDetails");
            if (objectIndexRow != null) {
                creationStatus = (String)objectIndexRow.get("CREATION_STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return creationStatus;
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 0);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_INDEX_ID");
    }
}

