/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcBulkLayoutController;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.layout.component.FcPassword;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFTask;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkUserCreationListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.MgmtRuleFlow;
import com.adventnet.sym.adsm.common.webclient.reports.JRArrayList;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ListUserDataProvider;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcBulkExecuteFormAction
extends DispatchAction {
    private Logger log = Logger.getLogger("FcLogger");

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
        fcBulkExecuteFormBean.initBean(request);
        ArrayList list = null;
        list = fcBulkExecuteFormBean.getIsWorkFlowMode() ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"");
        session.setAttribute("FcBulkExecuteFormBean", (Object)fcBulkExecuteFormBean);
        request.setAttribute("selectedDomainName", (Object)fcBulkExecuteFormBean.getDomainName());
        request.setAttribute("selectedTemplateId", (Object)fcBulkExecuteFormBean.getDefaultLayoutId().toString());
        request.setAttribute("selectedTemplateName", (Object)FcLayoutViewHandler.getLayoutName((Long)fcBulkExecuteFormBean.getDefaultLayoutId(), (AdventNetResourceBundle)rb));
        request.setAttribute("templateListSize", (Object)list.size());
        request.setAttribute("templateCategoryId", (Object)fcBulkExecuteFormBean.getTemplateCategoryId().toString());
        return mapping.findForward("bulkLayoutPage");
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean checkAuthroziation;
            JSONObject errorDetailsObj;
            JSONObject managedByAuthorizationDetails;
            boolean isAuthorized;
            JSONObject groupAuthorizationDetails;
            boolean isAllGroupsAuthorized;
            JSONObject groupAuthorizationDetails2;
            boolean isAllGroupsAuthorized2;
            int memberOfHeaderIndex;
            Object[] params;
            StringBuilder msg;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            JSONObject currentCSVStatusObj = fcBulkExecuteFormBean.getCurrentCSVStatusObj();
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            String domainName = fcBulkExecuteFormBean.getDomainName();
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            Long selectedLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
            FileInputStream stream = null;
            UploadedFileItem uploadedFileItem = null;
            File file = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                file = uploadedFileItem.getUploadedFile();
                stream = new FileInputStream(file);
            }
            String fileEncoding = request.getParameter("fileEncoding");
            CSVReader csvReader = new CSVReader(stream, fileEncoding, rb);
            Vector headerVector = new Vector();
            Vector valuesVector = new Vector();
            int headerSize = 0;
            ArrayList<Vector> list = new ArrayList<Vector>();
            try {
                headerVector = csvReader.getAllFieldsInLine();
                headerSize = headerVector.size();
            }
            catch (Exception headerVectorException) {
                if (headerVectorException instanceof EOFException) {
                    csvReader.close();
                }
                headerVectorException.printStackTrace();
                csvReader.close();
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)rb.getString("admp.mgmt.csv_import.common.statmsg.open_csv_in_notepad_and_save_in_correct_format")), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            JSONObject CSVStatusObj = FcValidation.validateCSVHeader((Vector)headerVector, (AdventNetResourceBundle)rb);
            if (!CSVStatusObj.getBoolean("status")) {
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, CSVStatusObj.getJSONArray("errorMsg"), CSVStatusObj.getString("extraInfo"));
                return null;
            }
            try {
                while (true) {
                    if ((valuesVector = csvReader.getAllFieldsInLine()).size() != headerSize) {
                        csvReader.close();
                        FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal")), rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal_reasons"));
                        return null;
                    }
                    list.add(valuesVector);
                }
            }
            catch (EOFException eofexception) {
                csvReader.close();
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                int fieldIndex = csvReader.getFieldIndex();
                if (fieldIndex >= headerSize) {
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal")), rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal_reasons"));
                } else {
                    String errorAttr = (String)headerVector.get(fieldIndex);
                    String message = MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.incorrect_format_specified_for_attribute"), errorAttr, csvReader.getLineCount());
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)message), errorMsg);
                }
                return null;
            }
            catch (Exception valuesVectorException) {
                if (valuesVectorException instanceof EOFException) {
                    csvReader.close();
                }
                valuesVectorException.printStackTrace();
                csvReader.close();
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)valuesVectorException.getMessage()), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            if (list.isEmpty()) {
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)rb.getString("admp.mgmt.csv_import.common.statmsg.one_row_available_provide_both_ldap_attrib_header_values_in_consecutive_rows")), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            String[] dnFormatAttributes = new String[]{"ouName"};
            for (int i = 0; i < dnFormatAttributes.length; ++i) {
                int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, dnFormatAttributes[i]);
                if (index == -1) continue;
                try {
                    for (Vector vector : list) {
                        String value = vector.get(index).toString();
                        LdapName ldap = new LdapName(value);
                    }
                    continue;
                }
                catch (InvalidNameException e) {
                    StringBuilder msg2 = new StringBuilder();
                    msg2.append(MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_dn_format"), dnFormatAttributes[i]));
                    msg2.append(" <a class=\"greenlinktxt\" href=\"/help/csv-import-management/active-directory-user-creation-csv.html\" target=\"_help\">");
                    msg2.append(rb.getString("admp.common.text.learn_more"));
                    msg2.append("</a>");
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)msg2.toString()), rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                    return null;
                }
                catch (Exception e) {
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)e.getMessage()), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                    return null;
                }
            }
            JSONObject statusObject = FcLayoutAuth.convertNameToDN(list, (Vector)headerVector, (String)domainName, (Long)loginId);
            if (statusObject == null || statusObject.length() == 0) {
                StringBuilder msg3 = new StringBuilder();
                msg3.append(MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_dn_format_or_samaccountname"), new Object[0]));
                msg3.append(" <a class=\"greenlinktxt\" href=\"/help/csv-import-management/active-directory-user-creation-csv.html\" target=\"_help\">");
                msg3.append(rb.getString("admp.common.text.learn_more"));
                msg3.append("</a>");
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)msg3.toString()), rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                return null;
            }
            if (statusObject.has("ERROR_KEY")) {
                StringBuilder msg4 = new StringBuilder();
                Object[] params2 = (Object[])statusObject.get("ERROR_KEY_PARAMS");
                msg4.append(MessageFormat.format(rb.getString(statusObject.getString("ERROR_KEY")), params2));
                msg4.append(" <a class=\"greenlinktxt\" href=\"/help/csv-import-management/active-directory-user-creation-csv.html\" target=\"_help\">");
                msg4.append(rb.getString("admp.common.text.learn_more"));
                msg4.append("</a>");
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)msg4.toString()), rb.getString("admp.mgmt.csv_import.common.text.dn_example"));
                return null;
            }
            JSONObject duplicateStatus = new JSONObject();
            if (FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf") != -1 && FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeMemberOf") != -1) {
                duplicateStatus = FcLayoutAuth.checkForDuplicates(list, (Vector)headerVector, (String)"memberOf", (String)"removeMemberOf", (boolean)true);
            }
            if (duplicateStatus.has("ERROR_LINE")) {
                msg = new StringBuilder();
                int errorLine = (Integer)duplicateStatus.get("ERROR_LINE");
                params = new Object[]{errorLine, "memberOf"};
                msg.append(MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.add_remove_same_value"), params));
                msg.append(" <a class=\"greenlinktxt\" href=\"/help/csv-import-management/active-directory-user-creation-csv.html\" target=\"_help\">");
                msg.append(rb.getString("admp.common.text.learn_more"));
                msg.append("</a>");
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)msg.toString()), "");
                return null;
            }
            if (FcExecuteFormFlow.getLdapNameIndex(headerVector, "proxyAddresses") != -1 && FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeProxyAddresses") != -1) {
                duplicateStatus = FcLayoutAuth.checkForDuplicates(list, (Vector)headerVector, (String)"proxyAddresses", (String)"removeProxyAddresses", (boolean)true);
            }
            if (duplicateStatus.has("ERROR_LINE")) {
                msg = new StringBuilder();
                int errorLine = (Integer)duplicateStatus.get("ERROR_LINE");
                params = new Object[]{errorLine, "proxyAddresses"};
                msg.append(MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.add_remove_same_value"), params));
                msg.append(" <a class=\"greenlinktxt\" href=\"/help/csv-import-management/active-directory-user-creation-csv.html\" target=\"_help\">");
                msg.append(rb.getString("admp.common.text.learn_more"));
                msg.append("</a>");
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)msg.toString()), "");
                return null;
            }
            String[] checkBoxAttributes = new String[]{"preventDeletion"};
            for (int i = 0; i < checkBoxAttributes.length; ++i) {
                int index = FcExecuteFormFlow.getLdapNameIndex(headerVector, checkBoxAttributes[i]);
                if (index == -1) continue;
                for (Vector vector : list) {
                    String value = vector.get(index).toString();
                    boolean flag = false;
                    try {
                        if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false")) continue;
                        FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)rb.getString("admp.mgmt.automation.robo.error_code.incorrect_prevent_deletion")), "");
                        return null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)e.getMessage()), "");
                        return null;
                    }
                }
            }
            int templateNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "templateName");
            boolean isTemplateNameHeaderAvailable = false;
            if (templateNameHeaderIndex != -1) {
                String templateName;
                isTemplateNameHeaderAvailable = true;
                JSONObject layoutAuthorizationDetails = FcLayoutAuth.validateTemplateNames((int)templateNameHeaderIndex, list, (Long)templateCategoryId, (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode());
                if (layoutAuthorizationDetails.has("inValid")) {
                    templateName = layoutAuthorizationDetails.getString("templateName");
                    int rowIndex = layoutAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.tamplate_name_is_not_valid"), templateName, rowIndex);
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                    return null;
                }
                if (layoutAuthorizationDetails.has("unAuthorized")) {
                    templateName = layoutAuthorizationDetails.getString("templateName");
                    int rowIndex = layoutAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.tamplate_name_is_not_authorized"), templateName, rowIndex);
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                    return null;
                }
            }
            int OUNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "OUName");
            boolean isExcludeChildOu = false;
            if (OUNameHeaderIndex != -1) {
                String defaultDomainNamingContext;
                JSONObject OUNameAuthorizationDetails;
                boolean isAllOusAuthorized;
                ArrayList ouList = new ArrayList();
                if (fcBulkExecuteFormBean.getIsWorkFlowMode()) {
                    ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
                    isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                } else {
                    ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
                }
                if (ouList != null && ouList.size() != 0 && !(isAllOusAuthorized = (OUNameAuthorizationDetails = FcLayoutAuth.isAuthorizedOUNames((int)OUNameHeaderIndex, list, (ArrayList)ouList, (String)(defaultDomainNamingContext = DomainUtil.getDefaultNamingContext((String)domainName)), (boolean)isExcludeChildOu)).getBoolean("isAllOusAuthorized"))) {
                    String ouName = OUNameAuthorizationDetails.getString("ouName");
                    int rowIndex = OUNameAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.ou_name_is_not_authorized"), ouName, rowIndex);
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                    return null;
                }
                String containerName = null;
                try {
                    for (Vector vector : list) {
                        String ouNameString = vector.get(OUNameHeaderIndex).toString();
                        if (containerName == null) {
                            containerName = ouNameString;
                            continue;
                        }
                        if (containerName.equalsIgnoreCase(ouNameString)) {
                            containerName = ouNameString;
                            continue;
                        }
                        containerName = "";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (containerName == null) {
                    containerName = "CN=Users," + DomainUtil.getDefaultNamingContext((String)domainName);
                }
                fcBulkExecuteFormBean.setContainerName(containerName);
            }
            if ((memberOfHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf")) != -1 && !(isAllGroupsAuthorized2 = (groupAuthorizationDetails2 = FcLayoutAuth.isAuthorizedGroups((int)memberOfHeaderIndex, list, (Long)loginId, (String)domainName, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode())).getBoolean("isAllGroupsAuthorized"))) {
                String groupName = groupAuthorizationDetails2.getString("groupName");
                int rowIndex = groupAuthorizationDetails2.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName, rowIndex);
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            int remMemberOfHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "removeMemberOf");
            if (remMemberOfHeaderIndex != -1 && !(isAllGroupsAuthorized = (groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)remMemberOfHeaderIndex, list, (Long)loginId, (String)domainName, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode(), (boolean)true)).getBoolean("isAllGroupsAuthorized"))) {
                String groupName = groupAuthorizationDetails.getString("groupName");
                int rowIndex = groupAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName, rowIndex);
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            int managedByIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "managedBy");
            if (managedByIndex != -1 && !(isAuthorized = (managedByAuthorizationDetails = FcLayoutAuth.isAuthorizedMember((int)managedByIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode(), (Long)loginId)).getBoolean("isAllMembersAuthorized"))) {
                String memberName = managedByAuthorizationDetails.getString("memberName");
                int rowIndex = managedByAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.managedBy_name_is_not_authorized"), memberName, rowIndex);
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            String[] csvHeaders = new String[]{"manager", "authOrig", "unauthOrig", "altRecipient", "publicDelegates"};
            Hashtable domainOUList = new Hashtable();
            for (int headers = 0; headers < csvHeaders.length; ++headers) {
                int headerIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, csvHeaders[headers]);
                if (headerIndex == -1) continue;
                if (csvHeaders[headers].equalsIgnoreCase("authOrig") || csvHeaders[headers].equalsIgnoreCase("unauthOrig")) {
                    JSONObject objectAuthorizationDetails = FcLayoutAuth.isAuthorizedMember((int)headerIndex, list, (ADMPAuthObject)FcExecuteFormFlow.getAuthObject(request), (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode(), (Long)loginId);
                    boolean isAllObjectsAuthorized = objectAuthorizationDetails.getBoolean("isAllMembersAuthorized");
                    if (isAllObjectsAuthorized) continue;
                    JSONObject errorString = new JSONObject();
                    String objectName = objectAuthorizationDetails.getString("memberName");
                    int rowIndex = objectAuthorizationDetails.getInt("rowIndex");
                    String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.object_name_is_not_authorized"), objectName, csvHeaders[headers], rowIndex);
                    errorString.put("errorMsg", (Object)error);
                    FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                    return null;
                }
                JSONObject userAuthorizationDetails = FcLayoutAuth.isAuthorizedUser((int)headerIndex, list, null, domainOUList, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode(), (Long)loginId);
                boolean isAllUsersAuthorized = userAuthorizationDetails.getBoolean("isAllUsersAuthorized");
                if (isAllUsersAuthorized) continue;
                String userName = userAuthorizationDetails.getString("userName");
                int rowIndex = userAuthorizationDetails.getInt("rowIndex");
                String error = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.user_name_is_not_authorized"), userName, csvHeaders[headers], rowIndex);
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, new JSONArray().put((Object)error), rb.getString("admp.mgmt.fc_layout_error.fix_and_reimport_csv_again"));
                return null;
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, request, dataObj, errorDetailsObj = new JSONObject(), headerVector, list, templateCategoryId, loginId, rb, domainName, isTemplateNameHeaderAvailable, templateNameHeaderIndex, selectedLayoutId, checkAuthroziation = !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            if (!status) {
                FcBulkExecuteFormFlow.setCsvImportErrroMsg(currentCSVStatusObj, errorDetailsObj.getJSONArray("errorMsg"), "");
                return null;
            }
            currentCSVStatusObj.put("status", true);
            currentCSVStatusObj.put("errorMsg", (Object)new JSONArray().put((Object)"Success"));
            fcBulkExecuteFormBean.setStartIndex(1);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                String actionText = "";
                if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
                    actionText = "admp.reports.report_actions.create_request.options.create_bulk_user";
                } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) == 0) {
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_ou";
                } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_contacts";
                } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_groups";
                } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0) {
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_comp";
                }
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)actionText, (Integer)ReportsUtil.BULK_USER_CREATION_REPORT_ID, (String)"-", (Boolean)Boolean.TRUE, (String)uploadedFileItem.getFileName(), (String)"csv", (String)"-", (Integer)list.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCSVStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(fcBulkExecuteFormBean.getCurrentCSVStatusObj().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCSVImportErrorDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            JSONArray errorMsg = fcBulkExecuteFormBean.getCurrentCSVStatusObj().getJSONArray("errorMsg");
            if (fcBulkExecuteFormBean.getCurrentCSVStatusObj().has("extraInfo")) {
                request.setAttribute("extraInfo", (Object)fcBulkExecuteFormBean.getCurrentCSVStatusObj().getString("extraInfo"));
            }
            request.setAttribute("errorMsg", (Object)errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("csvImportError");
    }

    public ActionForward getSelectedContainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            String containerName = "";
            String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)fcBulkExecuteFormBean.getDomainName());
            ArrayList ouList = new ArrayList();
            if (fcBulkExecuteFormBean.getCommonContainerName() != null && !fcBulkExecuteFormBean.getCommonContainerName().equals("")) {
                boolean isAuthorized;
                containerName = fcBulkExecuteFormBean.getCommonContainerName();
                ouList = fcBulkExecuteFormBean.getIsWorkFlowMode() ? WFRequesterUtil.getOUListDN((String)fcBulkExecuteFormBean.getDomainName(), (Long)loginId) : HelpdeskUtil.getOUList((String)fcBulkExecuteFormBean.getDomainName(), (Long)loginId);
                if (ouList != null && ouList.size() != 0 && !(isAuthorized = FcLayoutAuth.isAuthorizedOU((String)containerName, (ArrayList)ouList, (String)defaultNamingContext))) {
                    containerName = ouList.get(0).toString();
                }
            } else {
                containerName = FcLayoutUtil.getContainerFieldValue((Long)fcBulkExecuteFormBean.getDefaultLayoutId(), (AdventNetResourceBundle)rb);
                if (containerName == null || containerName.equals("")) {
                    ouList = fcBulkExecuteFormBean.getIsWorkFlowMode() ? WFRequesterUtil.getOUListDN((String)fcBulkExecuteFormBean.getDomainName(), (Long)loginId) : HelpdeskUtil.getOUList((String)fcBulkExecuteFormBean.getDomainName(), (Long)loginId);
                    containerName = UserMgmtUtil.getDefaultContainerName((String)defaultNamingContext, (ArrayList)ouList);
                }
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("containerName", (Object)containerName);
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward checkAuthorization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String ldapName = request.getParameter("ldapName");
            String value = request.getParameter("value");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            if (fcBulkExecuteFormBean.getDPValues() == null) {
                fcBulkExecuteFormBean.setDpValues(FcLayoutUtil.getDPValues((Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)fcBulkExecuteFormBean.getDomainName(), (AdventNetResourceBundle)rb, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode()));
            }
            boolean isAuthorized = FcBulkExecuteFormFlow.checkAuthorization(ldapName, value, fcBulkExecuteFormBean, loginId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("status", isAuthorized);
            if (isAuthorized) {
                jsonObj.put("statusMsg", (Object)rb.getString("admp.common.text.success"));
            } else {
                jsonObj.put("statusMsg", (Object)MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.container_is_not_authorized"), value));
            }
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward editField(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            String ldapName = request.getParameter("ldapName");
            String value = request.getParameter("value");
            Long layoutId = FcLayoutBulkViewHandler.getLayoutIdForObjectIndexId((Long)objectIndexId);
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            if (fcBulkExecuteFormBean.getDPValues() == null) {
                fcBulkExecuteFormBean.setDpValues(FcLayoutUtil.getDPValues((Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)fcBulkExecuteFormBean.getDomainName(), (AdventNetResourceBundle)rb, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode()));
            }
            JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
            FcAttributes fcAttr = (FcAttributes)columnsList.get(ldapName);
            FcBulkExecuteFormFlow.updateField(fcBulkExecuteFormBean.getTemplateCategoryId(), objectIndexId, FcExecuteActionConstants.userDataId, fcAttr.getAttribColumnName(), value);
            boolean checkAuthorization = !fcBulkExecuteFormBean.getIsWorkFlowMode();
            ArrayList selectedIamAppidList = FcLayoutBulkViewHandler.getSelectedIamAppIdForObjectIndexId((Long)objectIndexId);
            JSONArray selectedIamAppsJsonArray = new JSONArray();
            for (Integer iamAppId : selectedIamAppidList) {
                selectedIamAppsJsonArray.put((Object)iamAppId);
            }
            FcBulkExecuteFormFlow.generateResultDataForBulk(request, fcBulkExecuteFormBean.getObjectCreationId(), new Long[]{objectIndexId}, FcExecuteActionConstants.resultDataId, fcBulkExecuteFormBean.getDomainName(), fcBulkExecuteFormBean.getTemplateCategoryId(), loginId, rb, layoutId, fcBulkExecuteFormBean.getDPValues(), checkAuthorization, selectedIamAppsJsonArray);
            FcLayoutBulkViewHandler.updateSelectedIamAppsRow((Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (ArrayList)selectedIamAppidList, (Long)fcBulkExecuteFormBean.getTemplateCategoryId());
            FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getSingleObjResultDataContainer(objectIndexId, fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, null, null, null, null, request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONObject singleObjRowDetails = FcExecuteFormFlow.getSingleObjValuesList(resultDataContainer);
            String validationStatusMsg = FcLayoutViewHandler.getValidationStatusMsg((Long)objectIndexId);
            boolean isWorkflowMode = false;
            if (request.getParameter("isWorkFlowMode") != null) {
                isWorkflowMode = new Boolean(request.getParameter("isWorkFlowMode"));
            }
            if (isWorkflowMode && request.getParameter("commonDetails") != null) {
                try {
                    String commonDetailsString = request.getParameter("commonDetails");
                    JSONObject commonDetailsJson = new JSONObject(commonDetailsString);
                    String detailsString = request.getParameter("inputDetails");
                    JSONObject detailsJson = new JSONObject(detailsString);
                    String oldValue = detailsJson.getString("oldValue");
                    if (!oldValue.equals(value)) {
                        Long taskDetailsId = commonDetailsJson.getLong("taskDetailsId");
                        Long requestId = commonDetailsJson.getLong("requestId");
                        String comments = commonDetailsJson.getString("comments");
                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
                        auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                        auditActivities.setAuditActivitySubType(WFRequestUtil.TASK_OBJECT_MODIFIED);
                        auditActivities.updateBoardId();
                        auditActivities.updateIsCSVImportActionType();
                        auditActivities.setComments(comments);
                        JSONObject fieldChangesHistory = new JSONObject();
                        fieldChangesHistory.put("filedName", (Object)ldapName);
                        fieldChangesHistory.put("oldValue", (Object)oldValue);
                        fieldChangesHistory.put("newValue", (Object)value);
                        auditActivities.updateAuditActivities(fieldChangesHistory, objectIndexId, new JSONArray(), new JSONArray());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            request.setAttribute("CONTAINER_NAME", (Object)request.getParameter("CONTAINER_NAME"));
            request.setAttribute("objectIndexId", (Object)objectIndexId);
            request.setAttribute("validationStatusMsg", (Object)validationStatusMsg);
            request.setAttribute("singleObjRowDetails", (Object)singleObjRowDetails);
            request.setAttribute("sortedColumnsList", (Object)fcBulkExecuteFormBean.getSortedColumnsList());
            request.setAttribute("isWorkFlowMode", (Object)request.getParameter("isWorkFlowMode"));
            request.setAttribute("isWorkFlowPage", (Object)request.getParameter("isWorkFlowPage"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("singleObjectDetailsRow");
    }

    public ActionForward addSingleObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            String domainName = fcBulkExecuteFormBean.getDomainName();
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            fcExecuteFormBean.initForBulkMgmt(request, fcBulkExecuteFormBean.getDomainName(), fcBulkExecuteFormBean.getDefaultLayoutId());
            fcExecuteFormBean.setIsWorkFlowMode(fcBulkExecuteFormBean.getIsWorkFlowMode());
            fcExecuteFormBean.initForExecution(request, fcBulkExecuteFormBean.getDefaultLayoutId(), fcBulkExecuteFormBean.getDomainName(), false);
            FcLayout toClientExecuteLayout = new FcLayout(fcBulkExecuteFormBean.getDefaultLayoutId(), rb, domainName);
            toClientExecuteLayout.removeUnConfiguredIamAppsFieldsList(authObject.getDelegatedLinkedDomains());
            toClientExecuteLayout.removeEmptyTab();
            toClientExecuteLayout.setSelectedIamApps(fcExecuteFormBean.getIamApps(), null);
            FcFormDataContainer formContainer = new FcFormDataContainer();
            formContainer.init(toClientExecuteLayout);
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)fcBulkExecuteFormBean.getDefaultLayoutId())) {
                toClientExecuteLayout.setDomainName(domainName);
                FcExecuteFormFlow.setDomainSpecificFieldValues(fcBulkExecuteFormBean.getDPValues(), formContainer, domainName, rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
            }
            if (!fcExecuteFormBean.getIsWorkFlowMode()) {
                FcExecuteFormFlow.fillAuthorizedFields(request, formContainer, fcExecuteFormBean.getTemplateCategoryId(), domainName, fcExecuteFormBean.getActionId());
            }
            fcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
            fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(formContainer));
            fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, formContainer, fcExecuteFormBean.getNamingFormatFields()));
            fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)toClientExecuteLayout.getLayoutId(), (boolean)false));
            fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)toClientExecuteLayout.getLayoutId(), (boolean)true));
            fcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(formContainer));
            FcExecuteFormFlow.initDataContainerData(request, toClientExecuteLayout);
            fcExecuteFormBean.setDomainName(domainName);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldsAttributes(fcFormDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, fcExecuteFormBean.getUserData());
            MgmtRuleFlow.applyMgmtRulesInLayout(fcExecuteFormBean.getExecuteFormLayout().getLayoutId(), fcFormDataContainer, rb, fcExecuteFormBean.getTemplateData(), fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
            fcExecuteFormBean.setToClientData(fcFormDataContainer);
            fcBulkExecuteFormBean.getIMgmtListener().hideFieldsFromEditing(fcFormDataContainer);
            request.setAttribute("objectIndexId", (Object)objectIndexId);
            request.setAttribute("layoutId", (Object)fcExecuteFormBean.getExecuteFormLayout().getLayoutId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("editSingleObject");
    }

    public ActionForward editSingleObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long l1 = System.currentTimeMillis();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            String domainName = fcBulkExecuteFormBean.getDomainName();
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            String processSelSubTabs = request.getParameter("processSelectedSubTabs");
            boolean processSelectedSubTabs = true;
            if (processSelSubTabs != null) {
                processSelectedSubTabs = Boolean.parseBoolean(processSelSubTabs);
            }
            FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            Long layoutId = FcLayoutBulkViewHandler.getLayoutIdForObjectIndexId((Long)objectIndexId);
            fcExecuteFormBean.initForBulkMgmt(request, domainName, layoutId);
            fcExecuteFormBean.initForExecution(request, false);
            fcExecuteFormBean.setApplyIamAppsDelegation(true);
            FcFormDataContainer defaultFormDataContainer = FcExecuteFormFlow.getDefaultLayoutFormContainer(templateCategoryId, rb, domainName, loginId, fcBulkExecuteFormBean.getDPValues(), FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            DataObject userDataDetailsDO = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.userDataId, templateCategoryId);
            FcFormDataContainer userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, defaultFormDataContainer, userDataDetailsDO, domainName, loginId, rb, fcBulkExecuteFormBean.getDPValues());
            FcLayout toClientExecuteLayout = new FcLayout(layoutId, rb, domainName);
            toClientExecuteLayout.removeUnConfiguredIamAppsFieldsList(authObject.getDelegatedLinkedDomains());
            toClientExecuteLayout.removeEmptyTab();
            FcFormDataContainer toClientData = new FcFormDataContainer();
            toClientData.init(toClientExecuteLayout);
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)layoutId)) {
                FcExecuteFormFlow.setDomainSpecificFieldValues(fcBulkExecuteFormBean.getDPValues(), toClientData, domainName, rb, loginId, templateCategoryId);
            }
            ArrayList selectedIamAppidList = FcLayoutBulkViewHandler.getSelectedIamAppIdForObjectIndexId((Long)objectIndexId);
            toClientExecuteLayout.setSelectedIamApps(fcExecuteFormBean.getIamApps(), selectedIamAppidList);
            l1 = System.currentTimeMillis();
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            FcFormDataContainer cloneToClientData = toClientData.clone();
            FcExecuteFormFlow.setDomainSpecificFieldValues(fcBulkExecuteFormBean.getDPValues(), cloneToClientData, domainName, rb, loginId, templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(cloneToClientData);
            FcLayout cloneToClientLayout = toClientExecuteLayout.clone();
            l1 = System.currentTimeMillis();
            fcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
            FcExecuteFormFlow.setTemplateData(fcExecuteFormBean);
            if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(toClientData));
                fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, toClientData, fcExecuteFormBean.getNamingFormatFields()));
                fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)layoutId, (boolean)false));
                fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)layoutId, (boolean)true));
                fcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(toClientData));
                FcFormDataContainer adData = new FcFormDataContainer();
                fcExecuteFormBean.setADData(adData);
                IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
                iMgmtListener.setGuid(FcExecuteFormFlow.getModifiedObjectGuid(objectIndexId));
                iMgmtListener.setDomainName(domainName);
                iMgmtListener.setLoginId(loginId);
                ArrayList fieldLdapNamesArray = iMgmtListener.getMandatoryFields();
                FcExecuteFormFlow.addRuleFieldsLdapNames(fcExecuteFormBean, fieldLdapNamesArray);
                FcExecuteFormFlow.addNamingFormatFieldsLdapNames(toClientData, fieldLdapNamesArray);
                fieldLdapNamesArray.addAll(FcExecuteFormFlow.getLDAPNames(templateCategoryId, toClientData));
                Properties basicFieldsvaluesList = new Properties();
                iMgmtListener.removeLyncAttributes(fieldLdapNamesArray);
                if (!fieldLdapNamesArray.isEmpty()) {
                    basicFieldsvaluesList = FcExecuteFormFlow.getObjectProperties(iMgmtListener.getGuid(), toClientExecuteLayout.getDomainName(), loginId, fieldLdapNamesArray);
                }
                if (fieldLdapNamesArray.contains("sendAs")) {
                    ArrayList dnlist = (ArrayList)basicFieldsvaluesList.get("distinguishedName");
                    ArrayList sendAsSIDList = iMgmtListener.getSendAsList((String)dnlist.get(0));
                    basicFieldsvaluesList.put("sendAs", sendAsSIDList);
                }
                iMgmtListener.fillMandatoryFields(basicFieldsvaluesList);
                Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
                if (lyncAttribValuesList != null) {
                    basicFieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
                }
                iMgmtListener.fillADValues(toClientData, fcExecuteFormBean.getADData(), basicFieldsvaluesList, loginId, true);
                iMgmtListener.restrictFieldsFromEditing(toClientData);
                fcExecuteFormBean.setUserData(userDataContainer);
                FcExecuteFormFlow.applyTemplate(toClientData, userDataContainer);
                iMgmtHandler.updateFieldValuesToAttributes(toClientData);
                Properties prop = new Properties();
                prop.put("domainName", fcExecuteFormBean.getDomainName());
                prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
                Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(toClientData, prop);
                FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), toClientData, userDataContainer);
                MgmtRuleFlow.applyMgmtRulesInLayout(toClientExecuteLayout.getLayoutId(), toClientData, rb, fcExecuteFormBean.getTemplateData(), userDataContainer, fcExecuteFormBean.getADData());
                ArrayList addedCustomFields = FcLayoutUtil.addAdditionalCustomFields((FcLayout)toClientExecuteLayout, (FcFormDataContainer)userDataContainer);
                toClientData.put(addedCustomFields);
                iMgmtHandler.updateFieldsAttributes(toClientData);
                iMgmtHandler.updateFieldValuesToAttributes(toClientData);
                JSONObject resultSelectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(toClientData, prop);
                FcBulkExecuteFormFlow.selectSubTabInEditingSingleObject(resultSelectedSubTabDetails, userDataDetailsDO, toClientExecuteLayout, false);
                iMgmtHandler.removeUnSelectedSubTabFields(toClientData, resultSelectedSubTabDetails);
                fcExecuteFormBean.setToClientData(toClientData);
                fcBulkExecuteFormBean.getIMgmtListener().hideFieldsFromEditing(toClientData);
                request.setAttribute("objectIndexId", (Object)objectIndexId);
                request.setAttribute("layoutId", (Object)layoutId);
                DataObject resultDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                FcBulkExecuteFormFlow.deleteObjectIndexDetails(new Long[]{objectIndexId}, new Integer[]{FcExecuteActionConstants.resultDataId}, templateCategoryId);
                FcBulkExecuteFormFlow.fillDataObject(resultDataObj, objectIndexId, FcExecuteActionConstants.resultDataId, toClientData, templateCategoryId);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(resultDataObj);
                return mapping.findForward("editSingleObject");
            }
            FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getSingleObjResultDataContainer(objectIndexId, templateCategoryId, domainName, loginId, rb, cloneToClientData, userDataContainer, cloneToClientLayout, null, request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            resultDataContainer.updatePwdString(toClientData);
            l1 = System.currentTimeMillis();
            FcExecuteFormFlow.applyTemplate(toClientData, userDataContainer);
            ArrayList addedCustomFields = FcLayoutUtil.addAdditionalCustomFields((FcLayout)toClientExecuteLayout, (FcFormDataContainer)resultDataContainer);
            toClientData.put(addedCustomFields);
            FcExecuteFormFlow.initDataContainerData(request, toClientExecuteLayout);
            fcExecuteFormBean.setDomainName(domainName);
            fcExecuteFormBean.setUserData(userDataContainer);
            fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(toClientData));
            fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, toClientData, fcExecuteFormBean.getNamingFormatFields()));
            fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)toClientExecuteLayout.getLayoutId(), (boolean)false));
            fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)toClientExecuteLayout.getLayoutId(), (boolean)true));
            fcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(toClientData));
            if (!fcBulkExecuteFormBean.getIsWorkFlowMode()) {
                FcExecuteFormFlow.fillAuthorizedFields(request, toClientData, templateCategoryId, domainName, fcBulkExecuteFormBean.getActionId());
            }
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            iMgmtHandler.updateFieldsAttributes(toClientData);
            iMgmtHandler.updateFieldValuesToAttributes(toClientData);
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(toClientData, prop);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), toClientData, fcExecuteFormBean.getUserData());
            MgmtRuleFlow.applyMgmtRulesInLayout(layoutId, toClientData, rb, fcExecuteFormBean.getTemplateData(), fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
            JSONObject resultSelectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(resultDataContainer, prop);
            JSONObject userSelectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(userDataContainer, prop);
            JSONObject finalizedSelectedSubTabDetails = iMgmtHandler.getFinalizedSelectedSubTabDetails(resultSelectedSubTabDetails, userSelectedSubTabDetails);
            FcBulkExecuteFormFlow.selectSubTabInEditingSingleObject(finalizedSelectedSubTabDetails, userDataDetailsDO, toClientExecuteLayout, processSelectedSubTabs);
            fcExecuteFormBean.setToClientData(toClientData);
            fcBulkExecuteFormBean.getIMgmtListener().hideFieldsFromEditing(toClientData);
            request.setAttribute("objectIndexId", (Object)objectIndexId);
            request.setAttribute("layoutId", (Object)layoutId);
            l1 = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("editSingleObject");
    }

    public ActionForward saveSingleObjectDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            FcLayoutField fcLayoutField;
            FcPassword fcPassword;
            this.log.log(Level.INFO, " Saving single object details starts");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties auditProp = null;
            String jsonString = request.getParameter("FcExecuteLayout");
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            Long layoutId = new Long(request.getParameter("layoutId"));
            Boolean isWorkFlowPage = false;
            if (request.getParameter("isWorkFlowPage") != null) {
                isWorkFlowPage = new Boolean(request.getParameter("isWorkFlowPage"));
            }
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            if (isWorkFlowPage.booleanValue() && objectIndexId != -1L) {
                Long requestId = new Long(request.getParameter("requestId"));
                Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
                auditProp = new Properties();
                auditProp.put("requestId", requestId);
                auditProp.put("taskDetailsId", taskDetailsId);
                auditProp.put("loginId", loginId);
                auditProp.put("layoutId", layoutId);
                auditProp.put("authObj", ClientUtil.getAuthObject(request));
                auditProp.put("parentactionId", fcBulkExecuteFormBean.getActionId());
                auditProp.put("dpValue", fcBulkExecuteFormBean.getDPValues());
            }
            long l = System.currentTimeMillis();
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeFormLayout = new FcLayout();
            executeFormLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeFormLayout, true);
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            FcFormDataContainer userData = fcExecuteFormBean.getUserData();
            ArrayList<FcLayoutField> removedFields = FcExecuteFormFlow.updateUserData(templateCategoryId, fromClientData, fcExecuteFormBean.getToClientData(), userData);
            if (userData.containsKey((Object)FcExecuteActionConstants.PASSWORD_COMPONENT_ID) && (fcPassword = (FcPassword)(fcLayoutField = (FcLayoutField)fromClientData.get((Object)FcExecuteActionConstants.PASSWORD_COMPONENT_ID)).getIComponent()).getGeneratePassword() == 2 && fcPassword.getPasswordString().equals("")) {
                PasswordPolicy pwdPolicy = new PasswordPolicy();
                pwdPolicy.setPolicyDetails();
                String passwordStr = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
                fcPassword.setPasswordString(passwordStr);
                fromClientData.updatePwdString(userData);
            }
            ArrayList<String> selectedSubTabs = FcBulkExecuteFormFlow.getSelectedSubTabs(executeFormLayout);
            l = System.currentTimeMillis();
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(fromClientData);
            iMgmtHandler.updateFieldValuesToAttributes(fromClientData);
            Properties prop = new Properties();
            prop.put("domainName", fcBulkExecuteFormBean.getDomainName());
            JSONObject selectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(fromClientData, prop);
            removedFields.addAll(iMgmtHandler.removeUnSelectedSubTabFields(userData, iMgmtHandler.getSelectedSubTabDetails(executeFormLayout, false)));
            JSONArray selectedIamAppsJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            if (isWorkFlowPage.booleanValue() && templateCategoryId.compareTo(6L) == 0) {
                FcExecuteFormFlow.updateToBeRemovedGroupListForUserData(userData, fcExecuteFormBean.getADData());
            }
            boolean status = FcBulkExecuteFormFlow.saveSingleObjectDetails(objectCreationId, objectIndexId, layoutId, userData, fromClientData, templateCategoryId, rb, fcBulkExecuteFormBean.getDomainName(), removedFields, selectedSubTabDetails, selectedSubTabs, selectedIamAppsJsonArray, fcExecuteFormBean.getIamApps(), auditProp);
            l = System.currentTimeMillis();
            int objectCount = FcLayoutViewHandler.getBulkObjectDetailsTotalCount((Long)objectCreationId);
            fcBulkExecuteFormBean.setStartIndex(1);
            if (objectCount < fcBulkExecuteFormBean.getRange()) {
                fcBulkExecuteFormBean.setEndIndex(objectCount + fcBulkExecuteFormBean.getStartIndex() - 1);
            } else {
                fcBulkExecuteFormBean.setEndIndex(fcBulkExecuteFormBean.getRange());
            }
            fcBulkExecuteFormBean.setTotalCount(FcLayoutViewHandler.getBulkObjectDetailsTotalCount((Long)objectCreationId));
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, objectCreationId, templateCategoryId, fcBulkExecuteFormBean.getDomainName(), loginId, rb, fcBulkExecuteFormBean.getStartIndex(), fcBulkExecuteFormBean.getRange(), "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
            FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            l = System.currentTimeMillis();
            request.setAttribute("objectsList", (Object)objectsList);
            request.setAttribute("isWorkFlowPage", (Object)String.valueOf(isWorkFlowPage));
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward getObjectDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            int count = FcLayoutViewHandler.getBulkObjectDetailsTotalCount((Long)objectCreationId);
            fcBulkExecuteFormBean.setTotalCount(count);
            if (count < fcBulkExecuteFormBean.getStartIndex()) {
                fcBulkExecuteFormBean.setStartIndex(1);
            }
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, objectCreationId, templateCategoryId, fcBulkExecuteFormBean.getDomainName(), loginId, rb, fcBulkExecuteFormBean.getStartIndex(), fcBulkExecuteFormBean.getRange(), "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
            FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward sortValidationStatusColumn(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            fcBulkExecuteFormBean.setStartIndex(1);
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, fcBulkExecuteFormBean.getStartIndex(), fcBulkExecuteFormBean.getRange(), "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward navigateByPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            int startIndex = new Integer(request.getParameter("startIndex"));
            fcBulkExecuteFormBean.setStartIndex(startIndex);
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, startIndex, fcBulkExecuteFormBean.getRange(), "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            fcBulkExecuteFormBean.setStartIndex(startIndex);
            fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward navigateByRange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            int range = new Integer(request.getParameter("range"));
            fcBulkExecuteFormBean.setStartIndex(1);
            fcBulkExecuteFormBean.setRange(range);
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, fcBulkExecuteFormBean.getStartIndex(), range, "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward getNavigationBarDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("startIndex", fcBulkExecuteFormBean.getStartIndex());
            jsonObj.put("endIndex", fcBulkExecuteFormBean.getEndIndex());
            jsonObj.put("range", fcBulkExecuteFormBean.getRange());
            jsonObj.put("totalCount", fcBulkExecuteFormBean.getTotalCount());
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward copySingleObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            boolean status = FcExecuteFormFlow.copySingleObject(objectIndexId, fcBulkExecuteFormBean.getTemplateCategoryId(), null);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("status", status);
            if (status) {
                jsonObj.put("statusMsg", (Object)rb.getString("admp.mgmt.fc_layout_text.copied_row_appended_successfully"));
            } else {
                jsonObj.put("statusMsg", (Object)rb.getString("admp.mgmt.fc_layout_text.copy_failed"));
            }
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteSingleObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long objectIndexId = new Long(request.getParameter("objectIndexId"));
            boolean isWorkflowMode = false;
            if (request.getParameter("isWorkFlowMode") != null) {
                isWorkflowMode = new Boolean(request.getParameter("isWorkFlowMode"));
            }
            if (isWorkflowMode && request.getParameter("commonDetails") != null) {
                try {
                    String commonDetailsString = request.getParameter("commonDetails");
                    JSONObject commonDetailsJson = new JSONObject(commonDetailsString);
                    Long taskDetailsId = commonDetailsJson.getLong("taskDetailsId");
                    Long requestId = commonDetailsJson.getLong("requestId");
                    String comments = commonDetailsJson.getString("comments");
                    WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
                    auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                    auditActivities.setAuditActivitySubType(WFRequestUtil.TASK_OBJECT_REMOVED);
                    auditActivities.updateBoardId();
                    auditActivities.updateIsCSVImportActionType();
                    auditActivities.setComments(comments);
                    JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(null, (Long)null, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), objectIndexId, fcBulkExecuteFormBean.getDomainName(), loginId, rb, -1, -1, null, ClientUtil.getAuthObject(request), fcBulkExecuteFormBean.getActionId(), false, fcBulkExecuteFormBean.getDPValues());
                    JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
                    FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
                    JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
                    auditActivities.updateAuditActivities(new JSONObject(), objectIndexId, objectsList, new JSONArray());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            boolean status = FcExecuteFormFlow.deleteSingleObject(fcBulkExecuteFormBean.getObjectCreationId(), objectIndexId, fcBulkExecuteFormBean.getTemplateCategoryId());
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("status", status);
            if (status) {
                jsonObj.put("statusMsg", (Object)rb.getString("admp.mgmt.fc_layout_text.row_successfully_deleted"));
            } else {
                jsonObj.put("statusMsg", (Object)rb.getString("admp.mgmt.fc_layout_text.cant_delete_row"));
            }
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getTemplateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long selectedTemplateId = new Long(request.getParameter("templateId"));
        FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
        boolean isWorkflowMode = false;
        if (request.getParameter("workflowMode") != null) {
            isWorkflowMode = new Boolean(request.getParameter("workflowMode"));
        }
        if (isWorkflowMode && request.getParameter("commonDetails") != null) {
            try {
                String commonDetailsString = request.getParameter("commonDetails");
                JSONObject commonDetailsJson = new JSONObject(commonDetailsString);
                Long taskDetailsId = commonDetailsJson.getLong("taskDetailsId");
                Long requestId = commonDetailsJson.getLong("requestId");
                String comments = commonDetailsJson.getString("comments");
                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
                auditActivities.setAuditActivityType(WFRequestUtil.TASK_ACTIVITY_TYPE);
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setComments(comments);
                Integer currentWFStatus = auditActivities.getCurrentWFStatus();
                String detailsString = request.getParameter("inputDetails");
                JSONObject detailsJson = new JSONObject(detailsString);
                Long oldTemplateId = detailsJson.getLong("oldTemplateId");
                String selectedTemplateName = FcLayoutViewHandler.getLayoutName((Long)selectedTemplateId, null);
                String oldTemplateName = FcLayoutViewHandler.getLayoutName((Long)oldTemplateId, null);
                JSONObject fieldChangesHistory = new JSONObject();
                fieldChangesHistory.put("filedName", (Object)"admp.popup.common.label_template_name");
                fieldChangesHistory.put("oldValue", (Object)oldTemplateName);
                fieldChangesHistory.put("newValue", (Object)selectedTemplateName);
                auditActivities.updateAuditActivities(fieldChangesHistory, Long.valueOf(-1L), new JSONArray(), new JSONArray());
                if (WorkFlowUserHandler.isRequester((Long)loginId).booleanValue()) {
                    AdmpInput admpInput = new AdmpInput("templateName", selectedTemplateId.toString(), false);
                    auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                }
                this.log.log(Level.INFO, "The technician " + loginId + " is trying to change the templateName from " + oldTemplateName + " to new template " + selectedTemplateName + " workflow stage is " + auditActivities.getBoardId() + " requestId : " + requestId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList list = null;
        list = fcBulkExecuteFormBean.getIsWorkFlowMode() ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"");
        request.setAttribute("selectedDomainName", (Object)fcBulkExecuteFormBean.getDomainName());
        request.setAttribute("selectedTemplateId", (Object)selectedTemplateId.toString());
        request.setAttribute("selectedTemplateName", (Object)FcLayoutViewHandler.getLayoutName((Long)selectedTemplateId, (AdventNetResourceBundle)rb));
        request.setAttribute("templateListSize", (Object)list.size());
        request.setAttribute("applyTemplateFunction", (Object)("FcBulkLayoutDetails.applyTemplateForBulkObjects('" + selectedTemplateId + "', '" + fcBulkExecuteFormBean.getDomainName() + "', '" + fcBulkExecuteFormBean.getTemplateCategoryId() + "')"));
        request.setAttribute("templateCategoryId", (Object)fcBulkExecuteFormBean.getTemplateCategoryId().toString());
        request.setAttribute("isWorkFlowMode", (Object)fcBulkExecuteFormBean.getIsWorkFlowMode());
        return mapping.findForward("layoutDetails");
    }

    public ActionForward applyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long templateId = new Long(request.getParameter("templateId"));
            Long oldLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
            fcBulkExecuteFormBean.setDefaultLayoutId(templateId);
            FcBulkExecuteFormFlow.applyTemplateForBulkObjects(request, oldLayoutId, fcBulkExecuteFormBean);
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, -1, -1, "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            fcBulkExecuteFormBean.setColumnsList(new JSONObject());
            JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
            FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            int range = fcBulkExecuteFormBean.getRange();
            fcBulkExecuteFormBean.setStartIndex(1);
            if (objectsList.length() < range) {
                fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            } else {
                fcBulkExecuteFormBean.setEndIndex(range);
            }
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward getOUNameAvailableStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("isOUNameAvailable", !fcBulkExecuteFormBean.isOUSelectionVisible());
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getMgmtOperationsDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            String mgmtOperText = FcLayoutUtil.getBulkMgmtOperationText((Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode(), (AdventNetResourceBundle)rb);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("mgmtOperText", (Object)mgmtOperText);
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward submitExecuteLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (request.getParameter("containerName") != null) {
                String containerName = request.getParameter("containerName");
                fcBulkExecuteFormBean.setCommonContainerName(containerName);
            }
            IMgmtListener listener = fcBulkExecuteFormBean.getIMgmtListener();
            int rvcID = 201;
            if (fcBulkExecuteFormBean.getTemplateCategoryId().equals(FcExecuteActionConstants.ouCreationTemplateCategoryId)) {
                rvcID = 202;
            }
            if (fcBulkExecuteFormBean.getTemplateCategoryId().equals(FcExecuteActionConstants.contactCreationTemplateCategoryId)) {
                rvcID = 204;
            }
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)rvcID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            FcBulkLayoutController.getInstance().addStatusUpdator(fcBulkExecuteFormBean.getObjectCreationId(), statusUpdater);
            FcIamApps fcIamApps = fcBulkExecuteFormBean.getIamApps();
            if (fcIamApps == null) {
                fcIamApps = fcExecuteFormBean.getIamApps();
            }
            if (listener instanceof FcBulkUserCreationListener) {
                listener.doBulkAction(request, (Object)fcBulkExecuteFormBean, (Object)fcIamApps, loginId, Boolean.valueOf(false), Boolean.valueOf(true));
            } else {
                listener.doBulkAction(request, (Object)fcBulkExecuteFormBean, (Object)fcIamApps, loginId);
            }
            JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)rvcID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", (Object)fcBulkExecuteFormBean.getObjectCreationId());
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(rvcJsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward createWorkFlowRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String containerName = "";
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (request.getParameter("containerName") != null) {
                containerName = request.getParameter("containerName");
                fcBulkExecuteFormBean.setCommonContainerName(containerName);
            }
            if (fcBulkExecuteFormBean.isTemplateNameAvailable()) {
                fcBulkExecuteFormBean.setDefaultLayoutId(-1L);
            }
            JSONObject jsonObj = new JSONObject();
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            String wfCreateRequestProp = request.getParameter("createRequest");
            JSONObject wfCreateRequestJson = new JSONObject(wfCreateRequestProp);
            if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
                jsonObj.put("status", (Object)LicenseMgr.getInstance().getlicenseMessage("Workflow", rb));
            } else if (!CommonUtil.isAdmpTechAvailable()) {
                jsonObj.put("status", (Object)MessageFormat.format(rb.getString("admp.ad_deleg.license_restriction_module_message"), rb.getString(LicenseUtil.HIGHER_VERSION), rb.getString("admp.workflow.createrequest.title_create_request")));
            } else {
                boolean ouAuthorizedCheck = true;
                String domainName = fcBulkExecuteFormBean.getDomainName();
                ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
                if (ouList.size() > 0 && containerName.length() > 0 && !ouList.contains(containerName)) {
                    boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                    Criteria c = null;
                    c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                    ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                    if (!ouList.contains(containerName)) {
                        ouAuthorizedCheck = false;
                    }
                }
                if (ouAuthorizedCheck) {
                    FcLayoutUpdateHandler.updateObjectCreationIdDetails((Long)fcBulkExecuteFormBean.getObjectCreationId(), (String)fcBulkExecuteFormBean.getDomainName(), (String)fcBulkExecuteFormBean.getCommonContainerName(), (Long)fcBulkExecuteFormBean.getDefaultLayoutId());
                    Long requestId = FcExecuteFormFlow.createWorkFlowRequest(fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), loginId, fcBulkExecuteFormBean.getDomainName(), wfCreateRequestJson, rb);
                    if (requestId.compareTo(-1L) != 0) {
                        jsonObj.put("status", (Object)MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.statmsg.request_created_success"), requestId.toString()));
                    } else {
                        jsonObj.put("status", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occured_in_creating_request"));
                    }
                } else {
                    jsonObj.put("status", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"));
                }
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward stopExecuteLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            IMgmtListener listener = fcBulkExecuteFormBean.getIMgmtListener();
            listener.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            StatusUpdater dynamicUpdator = FcBulkLayoutController.getInstance().getStatusUpdator(objectCreationId);
            jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getContainerNameForResultPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("commonContainerName", (Object)fcBulkExecuteFormBean.getCommonContainerName());
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward checkAllObjectsSucceeded(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            boolean isAllSucceeded = FcLayoutViewHandler.isAllObjectsSucceeded((Long)fcBulkExecuteFormBean.getObjectCreationId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isAllSucceeded", isAllSucceeded);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCommonErrorMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = null;
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            ArrayList messageList = FcLayoutViewHandler.getBulkStatusMessages((Long)fcBulkExecuteFormBean.getObjectCreationId());
            String errorId = AddUserClientUtil.getBulkUserCreationTSTID(messageList);
            if (errorId != null) {
                forwardPage = "errorMessageDetails";
                request.setAttribute("errorId", (Object)errorId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getValidationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            boolean isAllRowsErrorFree = FcLayoutViewHandler.isAnyObjectHasValidationError((Long)fcBulkExecuteFormBean.getObjectCreationId(), (int)-1, (int)-1);
            boolean isCurrentPageErrorFree = FcLayoutViewHandler.isAnyObjectHasValidationError((Long)fcBulkExecuteFormBean.getObjectCreationId(), (int)fcBulkExecuteFormBean.getStartIndex(), (int)fcBulkExecuteFormBean.getRange());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isAllRowsErrorFree", !isAllRowsErrorFree);
            jsonObject.put("isCurrentPageErrorFree", !isCurrentPageErrorFree);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getUnSucceededObjectsList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            fcBulkExecuteFormBean.initIMgmtListener();
            Long oldObjectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            fcBulkExecuteFormBean.setObjectCreationId(FcExecuteFormFlow.getNewObjectCreationId());
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            FcExecuteFormFlow.reInsertUnSucceededObjects(oldObjectCreationId, objectCreationId, fcBulkExecuteFormBean.getTemplateCategoryId());
            fcBulkExecuteFormBean.setTotalCount(FcLayoutViewHandler.getBulkObjectDetailsTotalCount((Long)objectCreationId));
            fcBulkExecuteFormBean.setStartIndex(1);
            JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, objectCreationId, fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, fcBulkExecuteFormBean.getStartIndex(), fcBulkExecuteFormBean.getRange(), "VALIDATION_STATUS_MESSAGE", request, fcBulkExecuteFormBean.getActionId(), !fcBulkExecuteFormBean.getIsWorkFlowMode(), fcBulkExecuteFormBean.getDPValues());
            JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
            FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
            JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
            fcBulkExecuteFormBean.setEndIndex(objectsList.length() + fcBulkExecuteFormBean.getStartIndex() - 1);
            request.setAttribute("objectsList", (Object)objectsList);
            ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(fcBulkExecuteFormBean.getColumnsList());
            FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
            fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
            request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("objectsList");
    }

    public ActionForward exportBulkLayoutMgmtStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printStatusPage";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            String domainName = fcBulkExecuteFormBean.getDomainName();
            String containerName = "";
            containerName = fcBulkExecuteFormBean.isOUSelectionVisible() ? fcBulkExecuteFormBean.getCommonContainerName() : "-";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasper" + File.separator + "UserCreationStatus.jasper";
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("domainName", domainName);
            inputParams.put("containerName", containerName);
            inputParams.put("domainText", rb.getString("admp.common.text.domain"));
            inputParams.put("containerText", rb.getString("admp.common.text.container"));
            if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) == 0) {
                inputParams.put("userNameText", rb.getString("admp.common.attrib_disp_name.name"));
                inputParams.put("logonNameText", rb.getString("admp.common.attrib_disp_name.desc"));
                inputParams.put("passwordText", rb.getString("admp.common.attrib_disp_name.managed_by"));
            } else {
                inputParams.put("userNameText", rb.getString("admp.common.attrib_disp_name.user_name"));
                inputParams.put("logonNameText", rb.getString("admp.common.attrib_disp_name.logon_name"));
                inputParams.put("passwordText", rb.getString("admp.common.attrib_disp_name.password"));
            }
            inputParams.put("statusText", rb.getString("admp.common.text.status"));
            inputParams.put("loginId", loginId);
            ArrayList list = new ArrayList();
            list = fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0 ? FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (Long)fcBulkExecuteFormBean.getObjectCreationId(), null, (AdventNetResourceBundle)rb) : FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)fcBulkExecuteFormBean.getObjectCreationId(), (AdventNetResourceBundle)rb);
            FcBulkExecuteFormAction.exportResults(reportFileName, reportType, list, inputParams, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("printStatus")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportResults(String reportFileName, String reportType, ArrayList list, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
        JRArrayList tempJRReportList = new JRArrayList();
        reportFileName = "UserCreationStatus";
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        boolean isWorkFlow = false;
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        if (inputParams.get("isWorkFlow") != null) {
            isWorkFlow = (Boolean)inputParams.get("isWorkFlow");
        }
        int exportCount = list.size();
        try {
            int noOfObjToFetch;
            int exportPerRowCount;
            Hashtable columnWidths;
            Integer widthValue;
            Properties attributeProp3;
            Properties attributeProp1;
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName + ".xml";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)reportFileName));
            if (isWorkFlow) {
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                JRElement[] elements = titleBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    String key = elements[i].getKey();
                    if (!key.equalsIgnoreCase("textField-7") && !key.equalsIgnoreCase("staticText-6") && !key.equalsIgnoreCase("staticText-8")) continue;
                    titleBand.removeElement((JRDesignElement)elements[i]);
                }
            }
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            ArrayList<Properties> attributelist = new ArrayList<Properties>();
            if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) == 0) {
                attributeProp1 = new Properties();
                attributeProp1.put("ATTRIB_ID", (Object)9001);
                attributeProp1.put("ATTRIB_LDAP_NAME", "name");
                attributeProp1.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.name"));
                attributeProp1.put("TABLE_NAME", "EMPTY");
                attributeProp1.put("ATTRIB_COLUMN_NAME", "NAME");
                attributelist.add(attributeProp1);
                Properties attributeProp2 = new Properties();
                attributeProp2.put("ATTRIB_ID", (Object)9002);
                attributeProp2.put("ATTRIB_LDAP_NAME", "description");
                attributeProp2.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.desc"));
                attributeProp2.put("TABLE_NAME", "EMPTY");
                attributeProp2.put("ATTRIB_COLUMN_NAME", "DESCRIPTION");
                attributelist.add(attributeProp2);
                attributeProp3 = new Properties();
                attributeProp3.put("ATTRIB_ID", (Object)9003);
                attributeProp3.put("ATTRIB_LDAP_NAME", "managedBy");
                attributeProp3.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.managed_by"));
                attributeProp3.put("TABLE_NAME", "EMPTY");
                attributeProp3.put("ATTRIB_COLUMN_NAME", "MANAGED_BY");
                attributelist.add(attributeProp3);
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
                attributeProp1 = new Properties();
                attributeProp1.put("ATTRIB_ID", (Object)9001);
                attributeProp1.put("ATTRIB_LDAP_NAME", "name");
                attributeProp1.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.display_name"));
                attributeProp1.put("TABLE_NAME", "EMPTY");
                attributeProp1.put("ATTRIB_COLUMN_NAME", "FULL_NAME");
                attributelist.add(attributeProp1);
                Properties attributeProp2 = new Properties();
                attributeProp2.put("ATTRIB_ID", (Object)9002);
                attributeProp2.put("ATTRIB_LDAP_NAME", "description");
                attributeProp2.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.desc"));
                attributeProp2.put("TABLE_NAME", "EMPTY");
                attributeProp2.put("ATTRIB_COLUMN_NAME", "DESCRIPTION");
                attributelist.add(attributeProp2);
                attributeProp3 = new Properties();
                attributeProp3.put("ATTRIB_ID", (Object)9003);
                attributeProp3.put("ATTRIB_LDAP_NAME", "manager");
                attributeProp3.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.manager"));
                attributeProp3.put("TABLE_NAME", "EMPTY");
                attributeProp3.put("ATTRIB_COLUMN_NAME", "MANAGER");
                attributelist.add(attributeProp3);
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
                attributeProp1 = new Properties();
                attributeProp1.put("ATTRIB_ID", (Object)9001);
                attributeProp1.put("ATTRIB_LDAP_NAME", "name");
                attributeProp1.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.full_name"));
                attributeProp1.put("TABLE_NAME", "EMPTY");
                attributeProp1.put("ATTRIB_COLUMN_NAME", "FULL_NAME");
                attributelist.add(attributeProp1);
                Properties attributeProp_1 = new Properties();
                attributeProp_1.put("ATTRIB_ID", (Object)9004);
                attributeProp_1.put("ATTRIB_LDAP_NAME", "mail");
                attributeProp_1.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.e_mail_address"));
                attributeProp_1.put("TABLE_NAME", "EMPTY");
                attributeProp_1.put("ATTRIB_COLUMN_NAME", "EMAIL_ADDRESS");
                attributelist.add(attributeProp_1);
                Properties attributeProp2 = new Properties();
                attributeProp2.put("ATTRIB_ID", (Object)9002);
                attributeProp2.put("ATTRIB_LDAP_NAME", "description");
                attributeProp2.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.desc"));
                attributeProp2.put("TABLE_NAME", "EMPTY");
                attributeProp2.put("ATTRIB_COLUMN_NAME", "DESCRIPTION");
                attributelist.add(attributeProp2);
                Properties attributeProp32 = new Properties();
                attributeProp32.put("ATTRIB_ID", (Object)9003);
                attributeProp32.put("ATTRIB_LDAP_NAME", "manager");
                attributeProp32.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.manager_ad"));
                attributeProp32.put("TABLE_NAME", "EMPTY");
                attributeProp32.put("ATTRIB_COLUMN_NAME", "MANAGER");
                attributelist.add(attributeProp32);
                Properties attributeProp4 = new Properties();
                attributeProp4.put("ATTRIB_ID", (Object)9006);
                attributeProp4.put("ATTRIB_LDAP_NAME", "o365manager");
                attributeProp4.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.o365_manager"));
                attributeProp4.put("TABLE_NAME", "EMPTY");
                attributeProp4.put("ATTRIB_COLUMN_NAME", "O365MANAGER");
                attributelist.add(attributeProp4);
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0 || fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                ArrayList columnList = ColumnConfiguration.getColumnList((long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (int)2);
                for (int k = 0; k < columnList.size(); ++k) {
                    HashMap map = (HashMap)columnList.get(k);
                    Properties attributeProp = new Properties();
                    if (!((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserSingleVals") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkObjectIndexDetails") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserSelectContainerVals") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserManagerVals")) continue;
                    attributeProp.put("ATTRIB_ID", (Integer)map.get("COLUMN_ID"));
                    attributeProp.put("ATTRIB_LDAP_NAME", "EMPTY");
                    attributeProp.put("ATTRIB_DISP_NAME", (String)map.get("COLUMN_NAME"));
                    attributeProp.put("TABLE_NAME", "EMPTY");
                    attributeProp.put("ATTRIB_COLUMN_NAME", (String)map.get("COL_NAME"));
                    attributelist.add(attributeProp);
                }
            }
            if (isWorkFlow && fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) != 0 && fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) != 0 && fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) != 0) {
                Properties attributeProp5 = new Properties();
                attributeProp5.put("ATTRIB_ID", (Object)9005);
                attributeProp5.put("ATTRIB_LDAP_NAME", "ouName");
                attributeProp5.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.ou_name"));
                attributeProp5.put("TABLE_NAME", "EMPTY");
                attributeProp5.put("ATTRIB_COLUMN_NAME", "OU_NAME");
                attributelist.add(attributeProp5);
            }
            if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) != 0 && fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) != 0) {
                Properties attributeProp4 = new Properties();
                attributeProp4.put("ATTRIB_ID", (Object)9004);
                attributeProp4.put("ATTRIB_LDAP_NAME", "message");
                attributeProp4.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.message"));
                attributeProp4.put("TABLE_NAME", "EMPTY");
                attributeProp4.put("ATTRIB_COLUMN_NAME", "CREATION_MESSAGE");
                attributelist.add(attributeProp4);
            }
            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, new Hashtable(), reportType, request, new Hashtable(), -1, true, showSerialNo, rb)).remove("maxColumnWidth")) != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, rb, loginId, showSerialNo, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
            JasperReport jasperReportBasedOnType = null;
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            boolean isSingleSheet = false;
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int n2 = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (noOfObjToFetch = reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            if (isCSVExport) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            } else {
                JRDesignBand titleBand = new JRDesignBand();
                titleBand.setHeight(0);
                jasperDesign.setTitle((JRBand)titleBand);
                if (isSingleSheet) {
                    jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                }
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            }
            int AddToPgNumber = 0;
            ListUserDataProvider dataProvider = new ListUserDataProvider(list);
            AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, new Hashtable(), AddToPgNumber, jasperReportBasedOnType, jasperReport, dataProvider, defaultHeaderBand, reportType, locale, isSingleSheet, showSerialNo, 0, noOfObjToFetch);
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return;
        }
        try {
            String actionText = "";
            Integer actionId = 0;
            if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
                reportFileName = "UserCreationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_mod_obj";
                actionId = 1003;
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) == 0) {
                reportFileName = "OUCreationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_mod_ou";
                actionId = 50103;
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
                reportFileName = "ContactCreationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_contacts";
                actionId = 1061;
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
                reportFileName = "GroupCreationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_group";
                actionId = 1056;
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0) {
                reportFileName = "ComputerCreationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.cre_comp";
                actionId = 1081;
            } else if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                reportFileName = "UserModificationStatus";
                actionText = "admp.deleg.hdt_deleg.cre_role.action_name.mod_users";
                actionId = 1010;
            }
            ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                actionId = fcBulkExecuteFormBean.getActionId() == null ? actionId.intValue() : fcBulkExecuteFormBean.getActionId().intValue();
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.text.ad_management", (String)actionText, (Integer)actionId, (String)"-", (Boolean)Boolean.FALSE, (String)(reportFileName + "." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)exportCount);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public ActionForward resendFailedWFObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String requestIdStr = request.getParameter("requestId");
        Long requestId = Long.valueOf(requestIdStr);
        WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
        wfViewRequest.updateWFTaskDetails();
        String taskDetailsIdStr = request.getParameter("taskDetailsId");
        Long taskDetailsId = Long.valueOf(taskDetailsIdStr);
        WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
        HashMap resultMap = wfTask.getRequestUserCreationDetails();
        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
        String domainName = (String)resultMap.get("DOMAIN_NAME");
        String containerName = (String)resultMap.get("CONTAINER_NAME");
        String templateName = (String)resultMap.get("TEMPLATE_NAME");
        Long userCreationID = wfTask.getUserCreationId();
        Long templateCategoryId = null;
        for (AdmpInput admpInput : wfTask.getInputList()) {
            if (!admpInput.getName().equalsIgnoreCase("templateCategoryId")) continue;
            templateCategoryId = new Long(admpInput.getValue());
        }
        FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
        fcBulkExecuteFormBean.initBean(request, templateCategoryId.toString(), userCreationID, layoutId, domainName, true);
        ArrayList list = FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"");
        Long automationId = AutomationUtil.getAutomationIdForRequest((Long)requestId);
        if (automationId != null) {
            request.setAttribute("automationId", (Object)automationId);
        }
        request.setAttribute("isRetryOperation", (Object)true);
        request.setAttribute("subject", (Object)wfViewRequest.getSubject());
        request.setAttribute("priority", (Object)wfViewRequest.getPriority());
        session.setAttribute("FcBulkExecuteFormBean", (Object)fcBulkExecuteFormBean);
        request.setAttribute("selectedDomainName", (Object)fcBulkExecuteFormBean.getDomainName());
        request.setAttribute("selectedTemplateId", (Object)fcBulkExecuteFormBean.getDefaultLayoutId().toString());
        request.setAttribute("selectedTemplateName", (Object)FcLayoutViewHandler.getLayoutName((Long)fcBulkExecuteFormBean.getDefaultLayoutId(), (AdventNetResourceBundle)rb));
        request.setAttribute("templateListSize", (Object)list.size());
        request.setAttribute("templateCategoryId", (Object)fcBulkExecuteFormBean.getTemplateCategoryId().toString());
        return mapping.findForward("bulkLayoutPage");
    }
}

