/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFields;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutRhsConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutSubTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutSubTabGroup;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.layout.component.FcAdditionalCustomAttribute;
import com.adventnet.sym.adsm.common.server.layout.component.FcLogonName;
import com.adventnet.sym.adsm.common.server.layout.component.FcSelectContainer;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcUserModificationListener;
import com.adventnet.sym.adsm.common.webclient.layout.MgmtRuleFlow;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcBulkExecuteFormFlow
implements FcLayoutRhsConstants {
    private static Logger logg = Logger.getLogger("FcLogger");
    private static Logger mgmtLog = Logger.getLogger("ADMangLogger");
    public static int chunk = 1000;
    static boolean debug = false;
    static long gl1 = 0L;
    static long gl2 = 0L;
    static long gl3 = 0L;
    static long gl4 = 0L;
    static long gl5 = 0L;
    static long gl6 = 0L;
    static Hashtable dhash = new Hashtable();
    static Hashtable df = new Hashtable();

    public static void updateField(Long templateCategoryId, Long objectIndexId, Integer objectIndexType, String columnName, String value) {
        try {
            Row row;
            String oldValue = "";
            value = value.trim();
            String singleValueTableName = FcLayoutUtil.getSingleValueTableName((Long)templateCategoryId);
            if (columnName.equalsIgnoreCase("ALIAS") || columnName.equalsIgnoreCase("USER_PRINCIPAL_NAME") || columnName.equalsIgnoreCase("O365_SIMPLE_DISPLAY_NAME")) {
                singleValueTableName = "FcBulkExchOnlineSingleVals";
            } else if (columnName.equalsIgnoreCase("OU_NAME")) {
                singleValueTableName = "FcBulkUserSelectContainerVals";
            }
            Criteria crit = new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)new Integer[]{FcExecuteActionConstants.resultDataId, objectIndexType}, 8));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(singleValueTableName, crit);
            if (!dataObject.isEmpty()) {
                row = dataObject.getRow(singleValueTableName, new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)FcExecuteActionConstants.resultDataId, 0));
                oldValue = (String)row.get(columnName);
            }
            if (oldValue.equals(value)) {
                return;
            }
            row = dataObject.getRow(singleValueTableName, new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 0));
            if (row != null) {
                row.set(columnName, (Object)value);
                dataObject.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            } else {
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                row = new Row(singleValueTableName);
                row.set("OBJECT_INDEX_ID", (Object)objectIndexId);
                row.set("OBJECT_INDEX_TYPE", (Object)objectIndexType);
                row.set(columnName, (Object)value);
                dataObj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillFieldAuditDataObject(DataObject dataObj, Long objectIndexId, Long objectIndexType, FcFormDataContainer fcFormDataContainer, Long templateCategoryId) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField field = (FcLayoutField)e.nextElement();
                long l = System.currentTimeMillis();
                long l1 = System.currentTimeMillis() - l;
                if (!debug || l1 <= 0L) continue;
                Long t = (Long)dhash.get(field.getFieldId());
                if (t == null) {
                    t = new Long(0L);
                }
                t = t + l1;
                dhash.put(field.getFieldId(), t);
                df.put(field.getFieldId(), field.getAttribDisplayText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkAuthorization(String ldapName, String attribValue, FcBulkExecuteFormBean fcBulkExecuteFormBean, Long loginId) {
        boolean isAuthroized = false;
        if (ldapName.equalsIgnoreCase("OUName")) {
            ArrayList ouList = HDTDomainHandler.getAuthorizedOUList((String)fcBulkExecuteFormBean.getDomainName(), (Long)loginId, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode());
            String defaultDomainNamingContext = DomainUtil.getDefaultNamingContext((String)fcBulkExecuteFormBean.getDomainName());
            if (ouList == null || ouList.size() == 0) {
                isAuthroized = true;
            } else if (defaultDomainNamingContext.equalsIgnoreCase(attribValue)) {
                if (fcBulkExecuteFormBean.getIsWorkFlowMode()) {
                    isAuthroized = true;
                }
            } else {
                isAuthroized = FcLayoutAuth.isAuthorizedOU((String)attribValue, (ArrayList)ouList, (String)defaultDomainNamingContext);
            }
        }
        return isAuthroized;
    }

    public static ArrayList<String> getSelectedSubTabs(FcLayout fromClientLayout) {
        ArrayList<String> selectedSubTabs = new ArrayList<String>();
        ArrayList fcLayoutTabList = fromClientLayout.getFcLayoutTabList();
        for (int i = 0; i < fcLayoutTabList.size(); ++i) {
            FcLayoutTab fcLayoutTab = (FcLayoutTab)fcLayoutTabList.get(i);
            ArrayList fcLayoutSubTabGroupList = fcLayoutTab.getFcLayoutSubTabGroupList();
            for (int j = 0; j < fcLayoutSubTabGroupList.size(); ++j) {
                FcLayoutSubTabGroup fcLayoutSubTabGroup = (FcLayoutSubTabGroup)fcLayoutSubTabGroupList.get(j);
                Boolean isOptionTab = fcLayoutSubTabGroup.getIsOptionTab();
                if (!isOptionTab.booleanValue()) continue;
                ArrayList fcLayoutSubTabList = fcLayoutSubTabGroup.getFcLayoutSubTabList();
                for (int k = 0; k < fcLayoutSubTabList.size(); ++k) {
                    FcLayoutSubTab fromClientSubTab = (FcLayoutSubTab)fcLayoutSubTabList.get(k);
                    boolean fromClientIsSelected = fromClientSubTab.getIsDefaultSelectedSubTab();
                    if (!fromClientIsSelected) continue;
                    selectedSubTabs.add(fromClientSubTab.getSubTabType());
                }
            }
        }
        return selectedSubTabs;
    }

    public static boolean saveSingleObjectDetails(Long objectCreationId, Long objectIndexId, Long layoutId, FcFormDataContainer userDataContainer, FcFormDataContainer resultDataContainer, Long templateCategoryId, AdventNetResourceBundle rb, String domainName, ArrayList<FcLayoutField> removedFields, JSONObject userSelectedSubTabDetails, ArrayList<String> selectedSubTabs, JSONArray selectedIamAppsJsonArray, FcIamApps fcIamApps, Properties auditProp) {
        try {
            Properties oldDataForAudit = null;
            DataObject dataObj = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.userDataId, templateCategoryId);
            if (auditProp != null) {
                Object user1 = null;
                oldDataForAudit = FcBulkExecuteFormFlow.getWFAuditDataContainers(objectIndexId, templateCategoryId, dataObj, auditProp, domainName, rb);
            }
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            if (objectIndexId == -1L) {
                Row objectIndexIdRow = new Row("FcBulkObjectIndexDetails");
                objectIndexIdRow.set("OBJECT_CREATION_ID", (Object)objectCreationId);
                objectIndexIdRow.set("LAYOUT_ID", (Object)layoutId);
                dataObj.addRow(objectIndexIdRow);
                DataAccess.fillGeneratedValues((DataObject)dataObj);
                objectIndexId = (Long)objectIndexIdRow.get("OBJECT_INDEX_ID");
            } else {
                FcBulkExecuteFormFlow.deleteObjectIndexDetails(new Long[]{objectIndexId}, new Integer[]{FcExecuteActionConstants.resultDataId}, templateCategoryId);
            }
            iMgmtHandler.updateFieldsAttributes(userDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(userDataContainer);
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.userDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userDataContainer, templateCategoryId);
            FcBulkExecuteFormFlow.updateDataObjectForRemovedFields(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, removedFields, templateCategoryId);
            FcBulkExecuteFormFlow.updateDataObjectForSubTabs(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, selectedSubTabs, templateCategoryId);
            FcBulkExecuteFormFlow.removeUnselectedIamAppFields(resultDataContainer, selectedIamAppsJsonArray);
            FcBulkExecuteFormFlow.removeUnselectedIamAppFields(userDataContainer, selectedIamAppsJsonArray);
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("domainDNSName", DomainHandler.getDomainDNSName((String)domainName));
            FcBulkExecuteFormFlow.fillResultDataObject(dataObj, objectIndexId, templateCategoryId, resultDataContainer, userDataContainer, prop, userSelectedSubTabDetails, null, selectedIamAppsJsonArray, rb, layoutId, fcIamApps);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
            if (oldDataForAudit != null) {
                FcBulkExecuteFormFlow.fillWFAuditChanges(objectIndexId, auditProp, oldDataForAudit, userDataContainer, resultDataContainer, rb, templateCategoryId);
            }
            ArrayList mandatoryList = FcValidation.getConsolidatedMandatoryList((JSONArray)selectedIamAppsJsonArray, (FcIamApps)fcIamApps);
            String errorMsg = FcValidation.getValidationStatusMsg((Long)templateCategoryId, (FcFormDataContainer)resultDataContainer, (AdventNetResourceBundle)rb, (ArrayList)mandatoryList, (FcIamApps)fcIamApps);
            FcLayoutUpdateHandler.updateValidationStatusMsg((Long)objectIndexId, (String)errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void removeUnselectedIamAppFields(FcFormDataContainer resultDataContainer, JSONArray selectedIamAppsJsonArray) {
        ArrayList<Integer> selectedIamApps = new ArrayList<Integer>();
        try {
            for (int i = 0; i < selectedIamAppsJsonArray.length(); ++i) {
                selectedIamApps.add(selectedIamAppsJsonArray.getInt(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Enumeration e = resultDataContainer.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            Integer iamAppId = fcLayoutField.getIamAppId();
            if (fcLayoutField.getChildFieldArr() != null && fcLayoutField.getChildFieldArr().size() != 0 || selectedIamApps.contains(iamAppId)) continue;
            resultDataContainer.remove((Object)fcLayoutField.getFieldId());
        }
    }

    public static boolean addObjectDetails(Long objectCreationId, HttpServletRequest request, DataObject dataObj, JSONObject errorDetailsObj, Vector headerVector, ArrayList<Vector> list, Long templateCategoryId, Long loginId, AdventNetResourceBundle rb, String domainName, boolean isTemplateNameHeaderAvailable, int templateNameHeaderIndex, Long selectedLayoutId, boolean checkAuthorization, Hashtable dpValues) {
        try {
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            FcFormDataContainer defaultContainer = new FcFormDataContainer();
            Long defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (Integer)FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            FcLayout defaultLayout = new FcLayout(defaultLayoutId, rb, domainName);
            defaultContainer.init(defaultLayout);
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, defaultContainer, domainName, rb, loginId, templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(defaultContainer);
            JSONObject serializedJSONObject = defaultLayout.serializeToJsonObject();
            FcLayout defaultFcLayout = new FcLayout(selectedLayoutId, rb, domainName);
            Properties templateActionDetails = FcLayoutViewHandler.getTemplateActionDetails((Long)templateCategoryId);
            Long actionId = (Long)templateActionDetails.get("BULK_MGMT_ACTION_ID");
            HttpSession session = null;
            if (checkAuthorization) {
                session = request.getSession();
            }
            int objectCount = 0;
            int objectGuidHeaderIndex = -1;
            Vector newHeaderVector = (Vector)headerVector.clone();
            boolean isGUIDGivenInCSV = true;
            if (templateCategoryId.compareTo(6L) == 0 && (objectGuidHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "objectGUID")) == -1) {
                boolean isAdded = FcBulkExecuteFormFlow.addObjectGuidToList(newHeaderVector, list, domainName, errorDetailsObj);
                if (!isAdded) {
                    return false;
                }
                isGUIDGivenInCSV = false;
            }
            if (list.isEmpty()) {
                logg.log(Level.INFO, "Objects given in CSV not found in DB.Unable to process");
                errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)"No objects to process"));
                return false;
            }
            logg.log(Level.INFO, "CSV Import data processing Initiated. Object count: " + list.size());
            Hashtable layoutCache = new Hashtable();
            objectGuidHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(newHeaderVector, "objectGUID");
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("domainDNSName", DomainHandler.getDomainDNSName((String)domainName));
            prop.put("loginId", loginId);
            prop.put("isWorkFlowMode", (Object)(!checkAuthorization ? 1 : 0));
            for (Vector vector : list) {
                String errorMsg;
                String ldapName;
                Long tempLayoutId;
                Object layoutIdObj;
                String guid = "";
                if (objectGuidHeaderIndex != -1) {
                    Object objectGUID = vector.get(objectGuidHeaderIndex);
                    guid = objectGUID.toString();
                    if (!isGUIDGivenInCSV) {
                        vector.remove(objectGuidHeaderIndex);
                    }
                }
                if (checkAuthorization) {
                    try {
                        session.getAttribute("ADMP_AUTH_OBJECT");
                    }
                    catch (IllegalStateException stateException) {
                        logg.log(Level.INFO, "CSV Import has been aborted. Session has expired");
                        errorDetailsObj.put("errorMsg", (Object)new JSONArray());
                        return false;
                    }
                }
                defaultLayout = new FcLayout();
                defaultLayout.init(serializedJSONObject);
                Long layoutId = selectedLayoutId;
                if (isTemplateNameHeaderAvailable && (layoutIdObj = vector.get(templateNameHeaderIndex)) != null && !layoutIdObj.toString().equals("") && (tempLayoutId = FcLayoutViewHandler.getLayoutId((String)layoutIdObj.toString(), (Long)templateCategoryId)) != null) {
                    layoutId = tempLayoutId;
                }
                FcLayout fcLayout = null;
                fcLayout = selectedLayoutId.compareTo(layoutId) == 0 ? defaultFcLayout.clone() : new FcLayout(layoutId, rb);
                FcFormDataContainer resultDataContainer = new FcFormDataContainer();
                FcFormDataContainer resultContainerForAuth = new FcFormDataContainer();
                resultContainerForAuth.init(fcLayout, true);
                resultDataContainer.init(fcLayout);
                resultContainerForAuth.init(fcLayout, true);
                if (FcLayoutViewHandler.isDomainNameEmpty((Long)layoutId)) {
                    FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, resultDataContainer, domainName, rb, loginId, templateCategoryId);
                }
                iMgmtHandler.updateFieldsAttributes(resultDataContainer);
                if (checkAuthorization) {
                    FcExecuteFormFlow.fillAuthorizedFields(request, resultDataContainer, templateCategoryId, domainName, actionId, layoutCache);
                }
                ArrayList<String> nonAvailableLdapList = new ArrayList<String>();
                ArrayList<String> unAuthorizedLdapNameList = new ArrayList<String>();
                ArrayList<String> hiddenLdapNameList = new ArrayList<String>();
                ArrayList<String> readOnlyLdapNameList = new ArrayList<String>();
                FcBulkExecuteFormFlow.isAuthorizedHeaders(resultContainerForAuth, headerVector, templateCategoryId, nonAvailableLdapList, unAuthorizedLdapNameList, hiddenLdapNameList, readOnlyLdapNameList, checkAuthorization);
                if (nonAvailableLdapList.size() > 0 && checkAuthorization) {
                    FcBulkExecuteFormFlow.isAuthorizedCustomFields(request, rb, domainName, templateCategoryId, nonAvailableLdapList, unAuthorizedLdapNameList);
                }
                JSONArray errorMsgArray = new JSONArray();
                JSONObject errorMsgObject = new JSONObject();
                boolean isExternalAPICall = false;
                if (checkAuthorization) {
                    boolean bl = isExternalAPICall = request.getParameter("PRODUCT_NAME") != null;
                }
                if (!unAuthorizedLdapNameList.isEmpty()) {
                    StringBuilder unAuthorizedLdapNameStr = new StringBuilder();
                    for (int i = 0; i < unAuthorizedLdapNameList.size(); ++i) {
                        ldapName = unAuthorizedLdapNameList.get(i);
                        if (i != 0) {
                            unAuthorizedLdapNameStr.append(", ");
                        }
                        unAuthorizedLdapNameStr.append(ldapName);
                    }
                    errorMsg = "";
                    errorMsg = isExternalAPICall ? MessageFormat.format(rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_not_authorized"), unAuthorizedLdapNameStr.toString()) : MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attributes_not_authorized"), unAuthorizedLdapNameStr.toString());
                    errorMsgObject.put("error", (Object)"Attributes_Not_Authorized");
                    errorMsgObject.put("values", (Object)unAuthorizedLdapNameStr.toString());
                    errorMsgObject.put("errorMsg", (Object)errorMsg);
                    errorMsgArray.put((Object)errorMsgObject);
                }
                if (!hiddenLdapNameList.isEmpty()) {
                    StringBuilder hiddenLdapNameStr = new StringBuilder();
                    for (int i = 0; i < hiddenLdapNameList.size(); ++i) {
                        ldapName = hiddenLdapNameList.get(i);
                        if (i != 0) {
                            hiddenLdapNameStr.append(", ");
                        }
                        hiddenLdapNameStr.append(ldapName);
                    }
                    errorMsg = "";
                    errorMsg = isExternalAPICall ? MessageFormat.format(rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_are_hidden"), hiddenLdapNameStr.toString()) : MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attributes_are_hidden"), hiddenLdapNameStr.toString());
                    errorMsgObject.put("error", (Object)"Attributes_hidden");
                    errorMsgObject.put("values", (Object)hiddenLdapNameStr.toString());
                    errorMsgObject.put("errorMsg", (Object)errorMsg);
                    errorMsgArray.put((Object)errorMsgObject);
                }
                if (!readOnlyLdapNameList.isEmpty()) {
                    StringBuilder readOnlyLdapNameStr = new StringBuilder();
                    for (int i = 0; i < readOnlyLdapNameList.size(); ++i) {
                        ldapName = readOnlyLdapNameList.get(i);
                        if (i != 0) {
                            readOnlyLdapNameStr.append(", ");
                        }
                        readOnlyLdapNameStr.append(ldapName);
                    }
                    errorMsg = "";
                    errorMsg = isExternalAPICall ? MessageFormat.format(rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_are_read_only"), readOnlyLdapNameStr.toString()) : MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attributes_are_read_only"), readOnlyLdapNameStr.toString());
                    errorMsgObject.put("error", (Object)"Read-Only");
                    errorMsgObject.put("values", (Object)readOnlyLdapNameStr.toString());
                    errorMsgObject.put("errorMsg", (Object)errorMsg);
                    errorMsgArray.put((Object)errorMsgObject);
                }
                if (errorMsgArray.length() > 0) {
                    errorDetailsObj.put("errorMsg", (Object)errorMsgArray);
                    return false;
                }
                FcFormDataContainer userDataContainer = new FcFormDataContainer();
                FcFormDataContainer defaultLayoutFormContainer = defaultContainer.clone();
                iMgmtHandler.updateFieldsAttributes(defaultLayoutFormContainer);
                FcBulkExecuteFormFlow.fillUserDataFromCSV(headerVector, vector, defaultLayoutFormContainer, userDataContainer, templateCategoryId, rb, prop);
                if (templateCategoryId.compareTo(6L) == 0 && guid.isEmpty()) {
                    logg.log(Level.INFO, "object Guid empty for the verctor-" + vector.toString());
                    continue;
                }
                Row objectIndexIdRow = new Row("FcBulkObjectIndexDetails");
                objectIndexIdRow.set("OBJECT_CREATION_ID", (Object)objectCreationId);
                objectIndexIdRow.set("LAYOUT_ID", (Object)layoutId);
                if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 && guid != null) {
                    objectIndexIdRow.set("OBJECT_GUID", (Object)guid);
                }
                dataObj.addRow(objectIndexIdRow);
                DataAccess.fillGeneratedValues((DataObject)dataObj);
                Long objectIndexId = (Long)objectIndexIdRow.get("OBJECT_INDEX_ID");
                iMgmtHandler.updateFieldsAttributes(userDataContainer);
                iMgmtHandler.updateFieldValuesToAttributes(userDataContainer);
                JSONObject selectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(userDataContainer, prop);
                if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                    iMgmtHandler.updateFieldsAttributes(userDataContainer);
                    iMgmtHandler.updateFieldValuesToAttributes(userDataContainer);
                    FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userDataContainer, templateCategoryId);
                } else {
                    FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userDataContainer, templateCategoryId);
                }
                FcBulkExecuteFormFlow.fillResultDataObject(dataObj, objectIndexId, templateCategoryId, resultDataContainer, userDataContainer, prop, selectedSubTabDetails, fcLayout, fcLayout.getSelectedIamAppsJsonArray(), rb, layoutId);
                FcBulkExecuteFormFlow.fillEmptyResultDataObjectIfEmpty(dataObj);
                String o365LicenseErrorMsg = "";
                FcIamApps fcIamApps = new FcIamApps(templateCategoryId, fcLayout.getLayoutId(), rb);
                ArrayList mandatoryList = FcValidation.getConsolidatedMandatoryList((JSONArray)fcLayout.getSelectedIamAppsJsonArray(), (FcIamApps)fcIamApps);
                int licenseHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "waadLicenseInfo");
                int groupMemHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "GroupMemberObjectId");
                if (licenseHeaderIndex != -1 || groupMemHeaderIndex != -1) {
                    boolean isAuthorizedGroups;
                    boolean isO365AppSelected = false;
                    JSONArray selectedIamAppsJsonArray = fcLayout.getSelectedIamAppsJsonArray();
                    if (selectedIamAppsJsonArray != null) {
                        for (int i = 0; i < selectedIamAppsJsonArray.length(); ++i) {
                            if (selectedIamAppsJsonArray.getInt(i) != FcLayoutConstants.OFFICE_365_APPID.intValue()) continue;
                            isO365AppSelected = true;
                            break;
                        }
                    }
                    if (licenseHeaderIndex != -1 && isO365AppSelected) {
                        String licenseVal;
                        boolean isAuthorizedLicense;
                        JSONObject licenseDetails = FcLayoutAuth.isValidLicenseDetails((int)licenseHeaderIndex, (Vector)vector, (String)domainName, (HttpSession)session, (Long)loginId, (AdventNetResourceBundle)rb);
                        boolean isValidLicense = licenseDetails.has("isValidLicense") ? licenseDetails.getBoolean("isValidLicense") : false;
                        boolean bl = isAuthorizedLicense = licenseDetails.has("isAuthorizedLicense") ? licenseDetails.getBoolean("isAuthorizedLicense") : true;
                        if (!isValidLicense) {
                            if (licenseDetails.has("isEmptySkuList")) {
                                o365LicenseErrorMsg = rb.getString("admp.mgmt.fc_layout_error.no_o365_accounts_mapped");
                            } else if (licenseDetails.has("licenseVal")) {
                                licenseVal = licenseDetails.getString("licenseVal");
                                o365LicenseErrorMsg = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.license_name_not_valid"), licenseVal);
                            } else {
                                o365LicenseErrorMsg = rb.getString("admp.mgmt.fc_layout_error.license_name_not_valid");
                            }
                        } else if (!isAuthorizedLicense) {
                            if (licenseDetails.has("licenseVal")) {
                                licenseVal = licenseDetails.getString("licenseVal");
                                o365LicenseErrorMsg = MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.license_name_not_authroized"), licenseVal);
                            } else {
                                o365LicenseErrorMsg = rb.getString("admp.mgmt.fc_layout_error.license_name_not_authroized");
                            }
                        }
                    }
                    if (groupMemHeaderIndex != -1 && isO365AppSelected && !(isAuthorizedGroups = FcLayoutAuth.isAuthorizedGroups((int)groupMemHeaderIndex, (Vector)vector, (String)domainName, (HttpSession)session, (Long)loginId, (AdventNetResourceBundle)rb))) {
                        o365LicenseErrorMsg = o365LicenseErrorMsg + rb.getString("admp.mgmt.fc_layout_error.group_membership_not_authroized");
                    }
                }
                if (o365LicenseErrorMsg.length() > 0 && request == null) {
                    errorMsgObject.put("error", (Object)"o365LicError");
                    errorMsgObject.put("values", (Object)"");
                    errorMsgObject.put("errorMsg", (Object)o365LicenseErrorMsg);
                    errorMsgArray.put((Object)errorMsgObject);
                }
                if (errorMsgArray.length() > 0) {
                    errorDetailsObj.put("errorMsg", (Object)errorMsgArray);
                    return false;
                }
                String errorMsg2 = "";
                if (templateCategoryId.compareTo(6L) != 0) {
                    errorMsg2 = FcValidation.getValidationStatusMsg((Long)templateCategoryId, (FcFormDataContainer)resultDataContainer, (AdventNetResourceBundle)rb, (ArrayList)mandatoryList, (FcIamApps)fcIamApps);
                }
                if (o365LicenseErrorMsg.length() > 0) {
                    objectIndexIdRow.set("VALIDATION_STATUS_MESSAGE", (Object)o365LicenseErrorMsg);
                } else {
                    objectIndexIdRow.set("VALIDATION_STATUS_MESSAGE", (Object)errorMsg2);
                }
                if (++objectCount % 500 != 0) continue;
                logg.log(Level.INFO, "CSV Import reaches 500 objects. Inserting the values into DB of total size " + objectCount);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            }
            if (!dataObj.isEmpty()) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            }
            debug = false;
        }
        catch (DataAccessException dAE) {
            dAE.printStackTrace();
            try {
                errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)rb.getString("client.groups.CSVGroupAction.db_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
                if (list.size() >= 500) {
                    logg.log(Level.INFO, "Deleting the values into DB");
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                JSONObject errorMsgObject = new JSONObject();
                errorMsgObject.put("error", (Object)"common");
                errorMsgObject.put("values", (Object)"");
                errorMsgObject.put("errorMsg", (Object)"Error occurred while importing CSV ");
                errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)errorMsgObject));
                if (list.size() >= 500) {
                    logg.log(Level.INFO, "Deleting the values into DB");
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void deleteObjectIndexDetails(Long[] objectIndexId, Integer[] objectIndexType, Long templateCategoryId) throws Exception {
        String singleValueTableName = FcLayoutUtil.getSingleValueTableName((Long)templateCategoryId);
        Criteria criteria = new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 8);
        criteria = criteria.and(new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 8));
        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
        String[] multiValueTables = FcLayoutUtil.getFcBulkMultiValuesTables((Long)templateCategoryId);
        for (int i = 0; i < multiValueTables.length; ++i) {
            Criteria criteria2 = new Criteria(Column.getColumn((String)multiValueTables[i], (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 8);
            criteria2 = criteria2.and(new Criteria(Column.getColumn((String)multiValueTables[i], (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 8));
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria2);
        }
        String customAttrValsTableName = FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId);
        criteria = new Criteria(Column.getColumn((String)customAttrValsTableName, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 8);
        criteria = criteria.and(new Criteria(Column.getColumn((String)customAttrValsTableName, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 8));
        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
    }

    public static boolean applyTemplateForBulkObjects(HttpServletRequest request, Long oldLayoutId, FcBulkExecuteFormBean fcBulkExecuteFormBean) {
        boolean returnValue = false;
        try {
            HttpSession session = request.getSession();
            Locale locale = request.getLocale();
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            String domainName = fcBulkExecuteFormBean.getDomainName();
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            Hashtable dpValues = fcBulkExecuteFormBean.getDPValues();
            Long selectedLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"FcBulkObjectCreationDetails"));
            query.addJoin(new Join("FcBulkObjectCreationDetails", "FcBulkObjectIndexDetails", new String[]{"OBJECT_CREATION_ID"}, new String[]{"OBJECT_CREATION_ID"}, 2));
            query.setCriteria(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject objectIndexDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = objectIndexDetailsDO.getRows("FcBulkObjectIndexDetails");
            if (!objectIndexDetailsDO.isEmpty()) {
                Row row;
                ArrayList<Long> objectIndexIdList = new ArrayList<Long>();
                while (it.hasNext()) {
                    row = (Row)it.next();
                    Long layoutId = (Long)row.get("LAYOUT_ID");
                    if (!layoutId.equals(oldLayoutId)) continue;
                    objectIndexIdList.add((Long)row.get("OBJECT_INDEX_ID"));
                    row.set("LAYOUT_ID", (Object)selectedLayoutId);
                    objectIndexDetailsDO.updateRow(row);
                }
                row = objectIndexDetailsDO.getRow("FcBulkObjectCreationDetails");
                row.set("LAYOUT_ID", (Object)selectedLayoutId);
                objectIndexDetailsDO.updateRow(row);
                Long[] objectIndexIdArr = new Long[objectIndexIdList.size()];
                objectIndexIdList.toArray(objectIndexIdArr);
                boolean checkAuthorization = !fcBulkExecuteFormBean.getIsWorkFlowMode();
                FcBulkExecuteFormFlow.generateResultDataForBulk(request, objectCreationId, objectIndexIdArr, FcExecuteActionConstants.resultDataId, domainName, templateCategoryId, loginId, rb, selectedLayoutId, dpValues, checkAuthorization, null);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(objectIndexDetailsDO);
            }
            returnValue = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static void generateResultDataForBulk(HttpServletRequest request, Long objectCreationId, Long[] objectIndexId, Integer objectIndexType, String domainName, Long templateCategoryId, Long loginId, AdventNetResourceBundle rb, Long layoutId, Hashtable dpValues, boolean checkAuthorization, JSONArray selectedIamAppsJsonArray) {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            FcLayout fcLayout = new FcLayout(layoutId, rb, domainName);
            FcFormDataContainer resultDataContainer = new FcFormDataContainer();
            resultDataContainer.init(fcLayout);
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)layoutId)) {
                FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, resultDataContainer, domainName, rb, loginId, templateCategoryId);
            }
            Properties templateActionDetails = FcLayoutViewHandler.getTemplateActionDetails((Long)templateCategoryId);
            Long actionId = (Long)templateActionDetails.get("BULK_MGMT_ACTION_ID");
            Properties domainDetProp = new Properties();
            domainDetProp.put("domainName", domainName);
            domainDetProp.put("domainDNSName", DomainHandler.getDomainDNSName((String)domainName));
            domainDetProp.put("loginId", loginId);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            FcFormDataContainer defaultFormDataContainer = new FcFormDataContainer();
            Long defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (Integer)FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            FcLayout defaultLayout = new FcLayout(defaultLayoutId, rb, domainName);
            defaultFormDataContainer.init(defaultLayout);
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, defaultFormDataContainer, domainName, rb, loginId, templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(defaultFormDataContainer);
            JSONObject defaultLayoutJsonObject = defaultLayout.serializeToJsonObject();
            for (int index = 0; index < objectIndexId.length; ++index) {
                if (index > 0) {
                    defaultLayout.init(defaultLayoutJsonObject);
                }
                FcFormDataContainer defaultFormDataContainerClone = defaultFormDataContainer.clone();
                iMgmtHandler.updateFieldsAttributes(defaultFormDataContainerClone);
                if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                    FcBulkExecuteFormFlow.generateResultDataForBulkModify(request, objectCreationId, objectIndexId[index], objectIndexType, domainName, templateCategoryId, loginId, rb, layoutId, dpValues, resultDataContainer.clone(), actionId, dataObj, domainDetProp, iMgmtHandler, defaultFormDataContainerClone, fcLayout, checkAuthorization);
                    continue;
                }
                FcBulkExecuteFormFlow.generateResultDataForBulk(request, objectCreationId, objectIndexId[index], objectIndexType, domainName, templateCategoryId, loginId, rb, layoutId, dpValues, resultDataContainer.clone(), actionId, dataObj, domainDetProp, iMgmtHandler, defaultFormDataContainerClone, fcLayout, checkAuthorization, selectedIamAppsJsonArray);
            }
            FcBulkExecuteFormFlow.deleteObjectIndexDetails(objectIndexId, new Integer[]{objectIndexType}, templateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void generateResultDataForBulkModify(HttpServletRequest request, Long objectCreationId, Long objectIndexId, Integer objectIndexType, String domainName, Long templateCategoryId, Long loginId, AdventNetResourceBundle rb, Long layoutId, Hashtable dpValues, FcFormDataContainer resultDataContainer, Long actionId, DataObject dataObj, Properties domainDetProp, IMgmtHandler iMgmtHandler, FcFormDataContainer defaultFormDataContainer, FcLayout resultLayoutObj, boolean checkAuthorization) {
        try {
            FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
            fcExecuteFormBean.setTemplateCategoryId(templateCategoryId);
            fcExecuteFormBean.initForBulkMgmt(request, domainName, layoutId);
            fcExecuteFormBean.setExecuteFormLayout(resultLayoutObj);
            FcExecuteFormFlow.setTemplateData(fcExecuteFormBean);
            fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(resultDataContainer));
            fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, resultDataContainer, fcExecuteFormBean.getNamingFormatFields()));
            fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)layoutId, (boolean)false));
            fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)layoutId, (boolean)true));
            FcFormDataContainer adData = new FcFormDataContainer();
            fcExecuteFormBean.setADData(adData);
            IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
            iMgmtListener.setGuid(FcExecuteFormFlow.getModifiedObjectGuid(objectIndexId));
            iMgmtListener.setDomainName(domainName);
            iMgmtListener.setLoginId(loginId);
            ArrayList fieldLdapNamesArray = iMgmtListener.getMandatoryFields();
            FcExecuteFormFlow.addRuleFieldsLdapNames(fcExecuteFormBean, fieldLdapNamesArray);
            FcExecuteFormFlow.addNamingFormatFieldsLdapNames(resultDataContainer, fieldLdapNamesArray);
            fieldLdapNamesArray.addAll(FcExecuteFormFlow.getLDAPNames(templateCategoryId, resultDataContainer));
            Properties basicFieldsvaluesList = new Properties();
            iMgmtListener.removeLyncAttributes(fieldLdapNamesArray);
            if (!fieldLdapNamesArray.isEmpty()) {
                basicFieldsvaluesList = FcExecuteFormFlow.getObjectProperties(iMgmtListener.getGuid(), resultLayoutObj.getDomainName(), loginId, fieldLdapNamesArray);
            }
            iMgmtListener.fillMandatoryFields(basicFieldsvaluesList);
            Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
            if (lyncAttribValuesList != null) {
                basicFieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
            }
            iMgmtListener.fillADValues(resultDataContainer, fcExecuteFormBean.getADData(), basicFieldsvaluesList, loginId, true);
            FcFormDataContainer userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, defaultFormDataContainer, null, domainName, loginId, rb, dpValues);
            fcExecuteFormBean.setUserData(userDataContainer);
            FcExecuteFormFlow.applyTemplate(resultDataContainer, userDataContainer);
            iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(resultDataContainer);
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(resultDataContainer, domainDetProp);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), resultDataContainer, userDataContainer);
            MgmtRuleFlow.applyMgmtRulesInLayout(layoutId, resultDataContainer, rb, fcExecuteFormBean.getTemplateData(), userDataContainer, fcExecuteFormBean.getADData());
            ArrayList addedCustomFields = FcLayoutUtil.addAdditionalCustomFields((FcLayout)resultLayoutObj, (FcFormDataContainer)userDataContainer);
            resultDataContainer.put(addedCustomFields);
            iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(resultDataContainer);
            JSONObject resultSelectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(resultDataContainer, domainDetProp);
            iMgmtHandler.removeUnSelectedSubTabFields(resultDataContainer, resultSelectedSubTabDetails);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, resultDataContainer, templateCategoryId);
            HttpSession httpSession = request.getSession();
            FcIamApps iamApps = null;
            if (httpSession.getAttribute("FcBulkExecuteFormBean") != null) {
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)httpSession.getAttribute("FcBulkExecuteFormBean");
                iamApps = fcBulkExecuteFormBean.getIamApps();
            } else if (httpSession.getAttribute("FcExecuteFormBean") != null) {
                fcExecuteFormBean = (FcExecuteFormBean)httpSession.getAttribute("FcExecuteFormBean");
                iamApps = fcExecuteFormBean.getIamApps();
            }
            ArrayList mandatoryList = FcValidation.getConsolidatedMandatoryList((JSONArray)resultLayoutObj.getSelectedIamAppsJsonArray(), (FcIamApps)iamApps);
            String errorMsg = FcValidation.getValidationStatusMsg((Long)templateCategoryId, (FcFormDataContainer)resultDataContainer, (AdventNetResourceBundle)rb, (ArrayList)mandatoryList, (FcIamApps)iamApps);
            FcLayoutUpdateHandler.updateValidationStatusMsg((Long)objectIndexId, (String)errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateResultDataForBulk(HttpServletRequest request, Long objectCreationId, Long objectIndexId, Integer objectIndexType, String domainName, Long templateCategoryId, Long loginId, AdventNetResourceBundle rb, Long layoutId, Hashtable dpValues, FcFormDataContainer resultDataContainer, Long actionId, DataObject dataObj, Properties domainDetProp, IMgmtHandler iMgmtHandler, FcFormDataContainer defaultFormDataContainer, FcLayout resultLayoutObj, boolean checkAuthorization, JSONArray selectedIamAppsJsonArray) {
        try {
            FcFormDataContainer userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, defaultFormDataContainer, null, domainName, loginId, rb, dpValues);
            if (checkAuthorization) {
                FcExecuteFormFlow.fillAuthorizedFields(request, resultDataContainer, templateCategoryId, domainName, actionId);
            } else {
                iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            }
            iMgmtHandler.updateFieldsAttributes(userDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(userDataContainer);
            JSONObject userSelectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(userDataContainer, domainDetProp);
            FcBulkExecuteFormFlow.fillResultDataObject(dataObj, objectIndexId, templateCategoryId, resultDataContainer, userDataContainer, domainDetProp, userSelectedSubTabDetails, resultLayoutObj, selectedIamAppsJsonArray != null ? selectedIamAppsJsonArray : resultLayoutObj.getSelectedIamAppsJsonArray(), rb, layoutId);
            HttpSession httpSession = request.getSession();
            FcIamApps iamApps = null;
            if (httpSession.getAttribute("FcBulkExecuteFormBean") != null) {
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)httpSession.getAttribute("FcBulkExecuteFormBean");
                iamApps = fcBulkExecuteFormBean.getIamApps();
            } else if (httpSession.getAttribute("FcExecuteFormBean") != null) {
                FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)httpSession.getAttribute("FcExecuteFormBean");
                iamApps = fcExecuteFormBean.getIamApps();
            }
            ArrayList mandatoryList = FcValidation.getConsolidatedMandatoryList((JSONArray)resultLayoutObj.getSelectedIamAppsJsonArray(), (FcIamApps)iamApps);
            String errorMsg = FcValidation.getValidationStatusMsg((Long)templateCategoryId, (FcFormDataContainer)resultDataContainer, (AdventNetResourceBundle)rb, (ArrayList)mandatoryList, (FcIamApps)iamApps);
            FcLayoutUpdateHandler.updateValidationStatusMsg((Long)objectIndexId, (String)errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillResultDataObject(DataObject dataObj, Long objectIndexId, Long templateCategoryId, FcFormDataContainer resultDataContainer, FcFormDataContainer userDataContainer, Properties prop, JSONObject userSelectedSubTabDetails, FcLayout resultLayoutObj, JSONArray selectedIamAppsJsonArray, AdventNetResourceBundle rb, Long layoutId) {
        FcBulkExecuteFormFlow.fillResultDataObject(dataObj, objectIndexId, templateCategoryId, resultDataContainer, userDataContainer, prop, userSelectedSubTabDetails, resultLayoutObj, selectedIamAppsJsonArray, rb, layoutId, null);
    }

    public static void fillResultDataObject(DataObject dataObj, Long objectIndexId, Long templateCategoryId, FcFormDataContainer resultDataContainer, FcFormDataContainer userDataContainer, Properties prop, JSONObject userSelectedSubTabDetails, FcLayout resultLayoutObj, JSONArray selectedIamAppsJsonArray, AdventNetResourceBundle rb, Long layoutId, FcIamApps fcIamApps) {
        try {
            long l = System.currentTimeMillis();
            if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                FcBulkExecuteFormFlow.combineADAndUserData(resultDataContainer, userDataContainer);
            } else {
                FcBulkExecuteFormFlow.combineTemplateAndUserData(resultDataContainer, userDataContainer);
            }
            gl1 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(resultDataContainer);
            gl2 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(resultDataContainer, prop);
            gl3 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, FcExecuteFormFlow.getNamingFormatFields(resultDataContainer), resultDataContainer, userDataContainer);
            MgmtRuleFlow.applyMgmtRulesInLayout(layoutId, resultDataContainer, rb, resultDataContainer, userDataContainer, new FcFormDataContainer());
            gl6 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            iMgmtHandler.updateFieldValuesToAttributes(resultDataContainer);
            gl4 += System.currentTimeMillis() - l;
            JSONObject selectedSubTabDetails = new JSONObject();
            selectedSubTabDetails = resultLayoutObj != null ? iMgmtHandler.getSelectedSubTabDetails(resultLayoutObj, true) : iMgmtHandler.getSelectedSubTabDetails(resultDataContainer, prop);
            JSONObject finalizedSelectedSubTabDetails = null;
            finalizedSelectedSubTabDetails = templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 ? new JSONObject(selectedSubTabDetails.toString()) : iMgmtHandler.getFinalizedSelectedSubTabDetails(selectedSubTabDetails, userSelectedSubTabDetails);
            iMgmtHandler.removeUnSelectedSubTabFields(resultDataContainer, finalizedSelectedSubTabDetails);
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            l = System.currentTimeMillis();
            ArrayList<Integer> selectedIamApps = new ArrayList<Integer>();
            for (int i = 0; i < selectedIamAppsJsonArray.length(); ++i) {
                selectedIamApps.add(selectedIamAppsJsonArray.getInt(i));
            }
            if (fcIamApps == null) {
                fcIamApps = new FcIamApps(templateCategoryId, layoutId, rb);
            }
            resultDataContainer.fillPassword(ldapVsValueProps, rb);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, resultDataContainer, templateCategoryId, fcIamApps, selectedIamApps);
            gl5 += System.currentTimeMillis() - l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillEmptyResultDataObjectIfEmpty(DataObject dataObj) {
        try {
            String[] bulkValueTables = new String[]{"FcBulkUserSingleVals"};
            DataObject dataObjTemp = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (String bulkValueTable : bulkValueTables) {
                Criteria cri = new Criteria(Column.getColumn((String)bulkValueTable, (String)"OBJECT_INDEX_TYPE"), (Object)FcExecuteActionConstants.userDataId, 0);
                Iterator itr = dataObj.getRows(bulkValueTable, cri);
                while (itr.hasNext()) {
                    Row r = (Row)itr.next();
                    Long objectIndexId = (Long)r.get("OBJECT_INDEX_ID");
                    Integer objectIndexType = (Integer)r.get("OBJECT_INDEX_TYPE");
                    Criteria cri2 = new Criteria(Column.getColumn((String)bulkValueTable, (String)"OBJECT_INDEX_TYPE"), (Object)FcExecuteActionConstants.resultDataId, 0);
                    Iterator itr2 = dataObj.getRows(bulkValueTable, cri2 = cri2.and(new Criteria(Column.getColumn((String)bulkValueTable, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0)));
                    if (itr2.hasNext()) continue;
                    Row resultRow = new Row(bulkValueTable);
                    resultRow.set("OBJECT_INDEX_ID", (Object)objectIndexId);
                    resultRow.set("OBJECT_INDEX_TYPE", (Object)FcExecuteActionConstants.resultDataId);
                    dataObjTemp.addRow(resultRow);
                }
            }
            if (!dataObjTemp.isEmpty()) {
                dataObj.append(dataObjTemp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getObjectDetails(FcBulkExecuteFormBean fcBulkExecuteFormBean, Long objectCreationId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, HttpServletRequest request, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, fcBulkExecuteFormBean.getDefaultLayoutId(), objectCreationId, templateCategoryId, domainName, loginId, rb, startIndex, range, sortColumn, ClientUtil.getAuthObject(request), parentactionId, checkAuthorization, dpValues);
    }

    public static JSONArray getObjectDetails(Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, HttpServletRequest request, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getObjectDetails(null, defaultLayoutId, objectCreationId, templateCategoryId, domainName, loginId, rb, startIndex, range, sortColumn, ClientUtil.getAuthObject(request), parentactionId, checkAuthorization, dpValues);
    }

    public static JSONArray getObjectDetails(Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, ArrayList objectIndexList, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, HttpServletRequest request, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getObjectDetails(null, defaultLayoutId, objectCreationId, templateCategoryId, objectIndexList, domainName, loginId, rb, startIndex, range, sortColumn, ClientUtil.getAuthObject(request), parentactionId, checkAuthorization, dpValues);
    }

    public static JSONArray getObjectDetails(FcBulkExecuteFormBean fcBulkExecuteFormBean, Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, defaultLayoutId, objectCreationId, templateCategoryId, (Long)null, domainName, loginId, rb, startIndex, range, sortColumn, authObject, parentactionId, checkAuthorization, dpValues);
    }

    public static JSONArray getObjectDetails(Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, String domainName, Long loginId, Long parentActionId, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getObjectDetails(null, defaultLayoutId, objectCreationId, templateCategoryId, domainName, loginId, ResourceBundleMgr.getInstance().getBundle(), -1, 0, "OBJECT_INDEX_ID", null, parentActionId, false, dpValues);
    }

    public static JSONArray getObjectDetails(FcBulkExecuteFormBean fcBulkExecuteFormBean, Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, Long objectIndexIdd, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        ArrayList<Long> objectIndexIdList = null;
        if (objectIndexIdd != null) {
            objectIndexIdList = new ArrayList<Long>();
            objectIndexIdList.add(objectIndexIdd);
        }
        return FcBulkExecuteFormFlow.getObjectDetails(fcBulkExecuteFormBean, defaultLayoutId, objectCreationId, templateCategoryId, objectIndexIdList, domainName, loginId, rb, startIndex, range, sortColumn, authObject, parentactionId, checkAuthorization, dpValues);
    }

    public static JSONArray getObjectDetails(FcBulkExecuteFormBean fcBulkExecuteFormBean, Long defaultLayoutId, Long objectCreationId, Long templateCategoryId, ArrayList objectIndexIdList, String domainName, Long loginId, AdventNetResourceBundle rb, int startIndex, int range, String sortColumn, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        JSONArray objectDetailsArray = new JSONArray();
        boolean isADOptionSelected = false;
        try {
            DataObject objectIndexDetailsDO;
            FcFormDataContainer defaultLayoutFormContainer = FcExecuteFormFlow.getDefaultLayoutFormContainer(templateCategoryId, rb, domainName, loginId, dpValues, FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            long l = System.currentTimeMillis();
            SelectQueryImpl query = new SelectQueryImpl(new Table("FcBulkObjectIndexDetails"));
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0);
            if (objectIndexIdList != null && objectIndexIdList.size() > 0) {
                crit = crit.and(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"), (Object)objectIndexIdList.toArray(), 8));
            }
            query.setCriteria(crit);
            if (sortColumn != null) {
                if (sortColumn.equalsIgnoreCase("OBJECT_INDEX_ID")) {
                    query.addSortColumn(new SortColumn("FcBulkObjectIndexDetails", sortColumn, true));
                } else {
                    query.addSortColumn(new SortColumn("FcBulkObjectIndexDetails", sortColumn, false));
                }
            }
            query.addSelectColumn(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"*"));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, range));
            }
            if ((objectIndexDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query)).isEmpty()) {
                return objectDetailsArray;
            }
            Iterator it = objectIndexDetailsDO.getRows("FcBulkObjectIndexDetails");
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            if (defaultLayoutId == null) {
                defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false);
            }
            FcLayout defaultFcLayout = new FcLayout(defaultLayoutId, rb, domainName);
            FcFormDataContainer defaultDataContainer = null;
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)defaultLayoutId)) {
                defaultDataContainer = new FcFormDataContainer();
                defaultDataContainer.init(defaultFcLayout);
                FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, defaultDataContainer, domainName, rb, loginId, templateCategoryId);
            }
            Long[] objectIndexIds = new Long[objectIndexDetailsDO.size("FcBulkObjectIndexDetails")];
            int count = 0;
            while (it.hasNext()) {
                Row objectIndexRow = (Row)it.next();
                objectIndexIds[count++] = (Long)objectIndexRow.get("OBJECT_INDEX_ID");
            }
            Hashtable dataObjects = FcExecuteFormFlow.getObjectDetailsFromDB(objectIndexIds, new Integer[]{FcExecuteActionConstants.userDataId, FcExecuteActionConstants.resultDataId}, templateCategoryId);
            it = objectIndexDetailsDO.getRows("FcBulkObjectIndexDetails");
            boolean isTemplateNameAvailable = false;
            HashSet<String> ouNameList = new HashSet<String>();
            while (it.hasNext()) {
                FcLayoutField ouField;
                FcSelectContainer container;
                String ouName;
                JSONObject objectDetailsObj = new JSONObject();
                Row objectIndexRow = (Row)it.next();
                Long objectIndexId = (Long)objectIndexRow.get("OBJECT_INDEX_ID");
                Long layoutId = (Long)objectIndexRow.get("LAYOUT_ID");
                String validationStatusMsg = objectIndexRow.get("VALIDATION_STATUS_MESSAGE") == null ? "" : (String)objectIndexRow.get("VALIDATION_STATUS_MESSAGE");
                FcLayout objectLayout = null;
                FcFormDataContainer objectDataContainer = null;
                FcFormDataContainer objectDataContainerForUserData = null;
                if (layoutId.equals(defaultLayoutId)) {
                    objectLayout = defaultFcLayout.clone();
                    objectDataContainer = defaultLayoutFormContainer;
                    objectDataContainerForUserData = defaultLayoutFormContainer.clone();
                    FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, objectDataContainerForUserData, domainName, rb, loginId, templateCategoryId);
                    iMgmtHandler.updateFieldsAttributes(objectDataContainerForUserData);
                } else {
                    objectLayout = new FcLayout(layoutId, rb, domainName);
                    objectDataContainer = new FcFormDataContainer();
                    objectDataContainer.init(objectLayout);
                    objectDataContainerForUserData = objectDataContainer.clone();
                    if (FcLayoutViewHandler.isDomainNameEmpty((Long)layoutId)) {
                        FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, objectDataContainer, domainName, rb, loginId, templateCategoryId);
                        FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, objectDataContainerForUserData, domainName, rb, loginId, templateCategoryId);
                    }
                    iMgmtHandler.updateFieldsAttributes(objectDataContainer);
                    iMgmtHandler.updateFieldsAttributes(objectDataContainerForUserData);
                    isTemplateNameAvailable = true;
                }
                FcFormDataContainer userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, objectDataContainerForUserData, (DataObject)dataObjects.get(objectIndexId + "_" + FcExecuteActionConstants.userDataId), domainName, loginId, rb, dpValues);
                FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getSingleObjResultDataContainer(objectIndexId, templateCategoryId, domainName, loginId, rb, objectDataContainer, userDataContainer, objectLayout, (DataObject)dataObjects.get(objectIndexId + "_" + FcExecuteActionConstants.resultDataId), authObject, parentactionId, checkAuthorization, dpValues);
                if (!isADOptionSelected) {
                    isADOptionSelected = FcBulkExecuteFormFlow.isADOptionSelected((DataObject)dataObjects.get(objectIndexId + "_" + FcExecuteActionConstants.resultDataId));
                }
                if (userDataContainer.get((Object)FcExecuteActionConstants.USER_CREATION_CONTAINER_FIELD_ID) == null && resultDataContainer.get((Object)FcExecuteActionConstants.USER_CREATION_CONTAINER_FIELD_ID) != null && (ouName = (container = (FcSelectContainer)(ouField = (FcLayoutField)resultDataContainer.get((Object)FcExecuteActionConstants.USER_CREATION_CONTAINER_FIELD_ID)).getIComponent()).getDn()) != null && !ouName.equals("")) {
                    ouNameList.add(ouName);
                }
                objectDetailsObj.put("objectIndexId", (Object)objectIndexId);
                objectDetailsObj.put("userDataContainer", (Object)userDataContainer);
                objectDetailsObj.put("objectDetails", (Object)resultDataContainer);
                objectDetailsObj.put("validationStatusMsg", (Object)validationStatusMsg);
                objectDetailsArray.put((Object)objectDetailsObj);
            }
            if (fcBulkExecuteFormBean != null) {
                fcBulkExecuteFormBean.setTemplateNameAvailable(isTemplateNameAvailable);
                FcBulkExecuteFormFlow.setOUFlags(templateCategoryId, fcBulkExecuteFormBean, defaultFcLayout, rb, domainName, loginId, dpValues);
                if (ouNameList.size() == 1 && !ouNameList.contains(fcBulkExecuteFormBean.getCommonContainerName()) || ouNameList.size() > 1 || !isADOptionSelected) {
                    fcBulkExecuteFormBean.setIsOUNameAvailable(true);
                    fcBulkExecuteFormBean.setCommonContainerName(null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectDetailsArray;
    }

    public static boolean isADOptionSelected(DataObject dataObj) {
        block5: {
            if (dataObj == null) {
                return true;
            }
            try {
                Iterator it = dataObj.getRows("FcBulkUserSelectedIamAppVals");
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        Row row = (Row)it.next();
                        Integer iamAppId = (Integer)row.get("IAMAPP_ID");
                        if (!iamAppId.equals(FcLayoutConstants.ACTIVE_DIRECTORY_APPID)) continue;
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void removeNonValueColumnNames(FcBulkExecuteFormBean fcBulkExecuteFormBean, ArrayList columnsList, JSONArray objectsList) {
        try {
            for (int i = 0; i < columnsList.size(); ++i) {
                FcAttributes fcAttr = (FcAttributes)columnsList.get(i);
                String ldapName = fcAttr.getAttribLdapName();
                if (ldapName.equalsIgnoreCase("OUName") && fcBulkExecuteFormBean.isOUSelectionVisible()) {
                    columnsList.remove(i);
                    --i;
                    continue;
                }
                boolean isColumnHasValue = false;
                for (int j = 0; j < objectsList.length(); ++j) {
                    JSONObject singleObjectDetails = objectsList.getJSONObject(j);
                    JSONObject singleObjRowDetails = singleObjectDetails.getJSONObject("objectRowDetails");
                    if (fcBulkExecuteFormBean.getTemplateCategoryId().compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 && ldapName.equalsIgnoreCase("memberOf")) {
                        JSONObject jsonObj;
                        ArrayList value;
                        if (!singleObjRowDetails.has("memberOf") || (value = (ArrayList)(jsonObj = (JSONObject)singleObjRowDetails.get("memberOf")).get("value")).isEmpty()) continue;
                        isColumnHasValue = true;
                        break;
                    }
                    if (!singleObjRowDetails.has(ldapName)) continue;
                    isColumnHasValue = true;
                    break;
                }
                if (isColumnHasValue) continue;
                columnsList.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList sortColumnsList(JSONObject columnsList) {
        ArrayList<FcAttributes> sortedColumnsList = new ArrayList<FcAttributes>();
        try {
            ArrayList<Integer> fcAttrIdList = new ArrayList<Integer>();
            JSONObject attribIdVsLdapObj = new JSONObject();
            ArrayList<String> filledLdapNamesList = new ArrayList<String>();
            Iterator it = columnsList.keys();
            while (it.hasNext()) {
                String ldapName = (String)it.next();
                FcAttributes fcAttr = (FcAttributes)columnsList.get(ldapName);
                fcAttrIdList.add(fcAttr.getAttribId());
                attribIdVsLdapObj.put(ldapName, (Object)fcAttr.getAttribId());
            }
            Collections.sort(fcAttrIdList);
            block3: for (Integer attribId : fcAttrIdList) {
                it = columnsList.keys();
                while (it.hasNext()) {
                    String ldapName = (String)it.next();
                    FcAttributes fcAttr = (FcAttributes)columnsList.get(ldapName);
                    if (attribId.compareTo(fcAttr.getAttribId()) != 0 || attribIdVsLdapObj.getInt(ldapName) != attribId.intValue() || filledLdapNamesList.contains(ldapName)) continue;
                    sortedColumnsList.add(fcAttr);
                    filledLdapNamesList.add(ldapName);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortedColumnsList;
    }

    public static void removeNullValueFields(FcFormDataContainer fcFormDataContainer) {
        Enumeration e = fcFormDataContainer.elements();
        while (e.hasMoreElements()) {
            String str;
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            String string = str = fcAttributesList == null ? "null" : "" + fcAttributesList.size();
            if (fcAttributesList != null && fcAttributesList.size() > 0) {
                for (int i = 0; i < fcAttributesList.size(); ++i) {
                    FcAttributes fcAttr = (FcAttributes)fcAttributesList.get(i);
                    if (fcAttr.getAttribValue() != null) continue;
                    fcAttributesList.remove(i);
                    --i;
                }
            }
            str = (fcAttributesList = fcLayoutField.getFcAttributeList()) == null ? "null" : "" + fcAttributesList.size();
        }
    }

    public static void updateFieldsToAttributesForBulk(FcFormDataContainer resultDataContainer, FcFormDataContainer userDataContainer, Properties prop) {
        FcLayoutField fcLayoutField;
        Enumeration e = userDataContainer.elements();
        while (e.hasMoreElements()) {
            fcLayoutField = (FcLayoutField)e.nextElement();
            fcLayoutField.setValueForBulkDisplay(null, prop, resultDataContainer);
        }
        e = resultDataContainer.elements();
        while (e.hasMoreElements()) {
            fcLayoutField = (FcLayoutField)e.nextElement();
            long l = System.currentTimeMillis();
            if (!fcLayoutField.getIsHidden().booleanValue() && !fcLayoutField.getIsReadOnly().booleanValue()) {
                fcLayoutField.setValueForBulkDisplay(userDataContainer, prop, resultDataContainer);
            } else {
                fcLayoutField.setValueForBulkDisplay(null, prop, resultDataContainer);
            }
            long l1 = System.currentTimeMillis() - l;
            if (l1 <= 0L) continue;
        }
    }

    public static void fillFieldsFromBulkLayoutTables(FcFormDataContainer fcFormDataContainer, DataObject dataObj, Long templateCategoryId, Properties prop, AdventNetResourceBundle rb) throws DataAccessException {
        Enumeration e = fcFormDataContainer.elements();
        ArrayList<Integer> selectedIamAppsList = new ArrayList<Integer>();
        Iterator it = dataObj.getRows("FcBulkUserSelectedIamAppVals");
        while (it.hasNext()) {
            Row r = (Row)it.next();
            selectedIamAppsList.add((Integer)r.get("IAMAPP_ID"));
        }
        if (selectedIamAppsList.size() == 0) {
            selectedIamAppsList.add(1);
        }
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            Integer iamAppId = fcLayoutField.getIamAppId();
            if (!(selectedIamAppsList.contains(iamAppId) || fcLayoutField.getChildFieldArr() != null && fcLayoutField.getChildFieldArr().size() != 0)) {
                fcFormDataContainer.remove((Object)fcLayoutField.getFieldId());
                continue;
            }
            if (!fcLayoutField.getIsCustomField().booleanValue()) {
                fcLayoutField.fillFromBulkLayoutTable(dataObj, templateCategoryId, prop);
            }
            if (!fcLayoutField.getIsCustomField().booleanValue() || fcLayoutField.getComponentId() != 79L) continue;
            fcLayoutField.fillFromBulkLayoutTable(dataObj, templateCategoryId, prop);
        }
        String custAttrTableName = FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId);
        Iterator ite = dataObj.getRows(custAttrTableName);
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            if (row == null) continue;
            String customLdapName = row.get("CUSTOM_ATTRIB_NAME") == null ? "" : (String)row.get("CUSTOM_ATTRIB_NAME");
            boolean isFilled = false;
            e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcAttributes fcAttr;
                String ldapName;
                ArrayList fcAttributesList;
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                if (!fcLayoutField.getIsCustomField().booleanValue() || (fcAttributesList = fcLayoutField.getFcAttributeList()) == null || fcAttributesList.size() <= 0 || !customLdapName.equalsIgnoreCase(ldapName = (fcAttr = (FcAttributes)fcAttributesList.get(0)).getAttribLdapName())) continue;
                if (fcLayoutField.getComponentId() == 79L) {
                    isFilled = true;
                    continue;
                }
                String customLdapValue = row.get("CUSTOM_ATTRIB_VALUE") == null ? "" : (String)row.get("CUSTOM_ATTRIB_VALUE");
                fcLayoutField.fillCustomValue(ldapName, customLdapValue);
                isFilled = true;
            }
            if (isFilled) continue;
            FcLayoutField additionalCustomField = FcLayoutUtil.getAdditionalCustomField((FcFormDataContainer)fcFormDataContainer, (String)customLdapName);
            if (additionalCustomField == null) {
                additionalCustomField = FcLayoutUtil.createAdditionalCustomField((Long)templateCategoryId, (FcFormDataContainer)fcFormDataContainer, (String)customLdapName, (AdventNetResourceBundle)rb);
            }
            String customLdapValue = row.get("CUSTOM_ATTRIB_VALUE") == null ? "" : (String)row.get("CUSTOM_ATTRIB_VALUE");
            additionalCustomField.fillCustomValue(customLdapName, customLdapValue);
            FcFormDataContainer tempContainer = new FcFormDataContainer();
            tempContainer.put((Object)additionalCustomField.getFieldId(), (Object)additionalCustomField);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(tempContainer);
            fcFormDataContainer.put((Object)additionalCustomField.getFieldId(), (Object)additionalCustomField);
        }
    }

    public static void removeAddlCustomFields(FcFormDataContainer fcFormDataContainer) {
        try {
            Enumeration keys = fcFormDataContainer.keys();
            while (keys.hasMoreElements()) {
                Long key = (Long)keys.nextElement();
                FcLayoutField fcLayoutF = (FcLayoutField)fcFormDataContainer.get((Object)key);
                if (fcLayoutF.getComponentId().intValue() != 16) continue;
                fcFormDataContainer.remove((Object)fcLayoutF.getFieldId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void combineADAndUserData(FcFormDataContainer templateData, FcFormDataContainer userData) {
        FcLayoutField userDataField;
        Enumeration e = userData.elements();
        while (e.hasMoreElements()) {
            userDataField = (FcLayoutField)e.nextElement();
            if (userDataField.getComponentId().intValue() == 16) continue;
            Long fieldId = userDataField.getFieldId();
            if (templateData.containsKey((Object)fieldId) && !userDataField.getIComponent().hasEmptyValue(true)) {
                FcLayoutField templateDataField = (FcLayoutField)templateData.get((Object)fieldId);
                if (templateDataField.getIsHidden().booleanValue() || templateDataField.getIsReadOnly().booleanValue()) continue;
                templateDataField.applyTemplate(userDataField);
                continue;
            }
            if (userDataField.getIComponent().hasEmptyValue(true)) continue;
            templateData.put((Object)fieldId, (Object)userDataField.clone());
        }
        e = userData.elements();
        while (e.hasMoreElements()) {
            userDataField = (FcLayoutField)e.nextElement();
            if (userDataField.getComponentId().intValue() != 16) continue;
            boolean isUpdated = false;
            String userFieldLdapName = ((FcAdditionalCustomAttribute)userDataField.getIComponent()).getLdapName();
            Enumeration ee = templateData.elements();
            while (ee.hasMoreElements()) {
                String templateFieldLdapName;
                FcLayoutField templateDataField = (FcLayoutField)ee.nextElement();
                if (templateDataField.getComponentId().intValue() != 16 || !userFieldLdapName.equalsIgnoreCase(templateFieldLdapName = ((FcAdditionalCustomAttribute)templateDataField.getIComponent()).getLdapName())) continue;
                if (!templateDataField.getIsHidden().booleanValue() && !templateDataField.getIsReadOnly().booleanValue()) {
                    String userFieldLdapValue = ((FcAdditionalCustomAttribute)userDataField.getIComponent()).getLdapValue();
                    ((FcAdditionalCustomAttribute)templateDataField.getIComponent()).setLdapValue(userFieldLdapValue);
                }
                isUpdated = true;
            }
            if (isUpdated) continue;
            FcLayoutField fcField = userDataField.clone();
            templateData.put((Object)fcField.getFieldId(), (Object)fcField);
        }
    }

    public static void combineTemplateAndUserData(FcFormDataContainer templateData, FcFormDataContainer userData) {
        FcLayoutField userDataField;
        Enumeration e = userData.elements();
        while (e.hasMoreElements()) {
            userDataField = (FcLayoutField)e.nextElement();
            if (userDataField.getComponentId().intValue() == 16) continue;
            Long fieldId = userDataField.getFieldId();
            if (templateData.containsKey((Object)fieldId)) {
                FcLayoutField templateDataField = (FcLayoutField)templateData.get((Object)fieldId);
                if (templateDataField.getIsHidden().booleanValue() || templateDataField.getIsReadOnly().booleanValue()) continue;
                templateDataField.applyTemplate(userDataField);
                continue;
            }
            templateData.put((Object)fieldId, (Object)userDataField.clone());
        }
        e = userData.elements();
        while (e.hasMoreElements()) {
            userDataField = (FcLayoutField)e.nextElement();
            if (userDataField.getComponentId().intValue() != 16) continue;
            boolean isUpdated = false;
            String userFieldLdapName = ((FcAdditionalCustomAttribute)userDataField.getIComponent()).getLdapName();
            Enumeration ee = templateData.elements();
            while (ee.hasMoreElements()) {
                String templateFieldLdapName;
                FcLayoutField templateDataField = (FcLayoutField)ee.nextElement();
                if (templateDataField.getComponentId().intValue() != 16 || !userFieldLdapName.equalsIgnoreCase(templateFieldLdapName = ((FcAdditionalCustomAttribute)templateDataField.getIComponent()).getLdapName())) continue;
                if (!templateDataField.getIsHidden().booleanValue() && !templateDataField.getIsReadOnly().booleanValue()) {
                    String userFieldLdapValue = ((FcAdditionalCustomAttribute)userDataField.getIComponent()).getLdapValue();
                    ((FcAdditionalCustomAttribute)templateDataField.getIComponent()).setLdapValue(userFieldLdapValue);
                }
                isUpdated = true;
            }
            if (isUpdated) continue;
            FcLayoutField fcField = userDataField.clone();
            templateData.put((Object)fcField.getFieldId(), (Object)fcField);
        }
    }

    public static void fillADDataForWorkFlowModify(String guid, String domainName, FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Long templateCategoryId, AdventNetResourceBundle rb, Properties prop) throws Exception {
        try {
            FcUserModificationListener iMgmtListener = new FcUserModificationListener();
            iMgmtListener.setGuid(guid);
            iMgmtListener.setDomainName(domainName);
            iMgmtListener.setLoginId(1L);
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcFormDataContainer);
            attribList.addAll(iMgmtListener.getMandatoryFields());
            Properties valuesList = new Properties();
            iMgmtListener.removeLyncAttributes(attribList);
            if (!attribList.isEmpty()) {
                valuesList = FcExecuteFormFlow.getObjectProperties(guid, domainName, 1L, attribList);
            }
            iMgmtListener.fillMandatoryFields(valuesList);
            Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
            if (lyncAttribValuesList != null) {
                valuesList.putAll((Map<?, ?>)lyncAttribValuesList);
            }
            iMgmtListener.fillADValues(fcFormDataContainer, adDataContainer, valuesList, 1L, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillUserDataFromCSV(Vector headerVector, Vector valueVector, FcFormDataContainer fcFormDataContainer, FcFormDataContainer userDataContainer, Long templateCategoryId, AdventNetResourceBundle rb, Properties prop) throws Exception {
        ArrayList filledHeaders = new ArrayList();
        Enumeration e = fcFormDataContainer.elements();
        while (e.hasMoreElements()) {
            FcLayoutField field = (FcLayoutField)e.nextElement();
            boolean isFilled = field.fillValuesFromCSV(headerVector, valueVector, filledHeaders, prop);
            if (!isFilled) continue;
            FcLayoutField userField = field.clone();
            userField.mergeUserData((FcLayoutField)userDataContainer.get((Object)userField.getFieldId()));
            userDataContainer.put((Object)field.getFieldId(), (Object)userField);
        }
        for (int i = 0; i < headerVector.size(); ++i) {
            FcLayoutField addCustomField;
            boolean isFilled;
            String headerLdapName = (String)headerVector.get(i);
            boolean isHeaderPresent = false;
            for (int ind = 0; ind < filledHeaders.size(); ++ind) {
                if (!filledHeaders.get(ind).toString().equalsIgnoreCase(headerLdapName)) continue;
                isHeaderPresent = true;
                break;
            }
            if (isHeaderPresent || headerLdapName.equalsIgnoreCase("templateName") || !(isFilled = (addCustomField = FcLayoutUtil.createAdditionalCustomField((Long)templateCategoryId, (FcFormDataContainer)userDataContainer, (String)headerLdapName, (AdventNetResourceBundle)rb)).fillValuesFromCSV(headerVector, valueVector, filledHeaders, prop))) continue;
            userDataContainer.put((Object)addCustomField.getFieldId(), (Object)addCustomField.clone());
        }
    }

    public static void updateDataObjectForRemovedFields(DataObject dataObj, Long objectIndexId, Integer objectIndexType, ArrayList<FcLayoutField> removedFields, Long templateCategoryId) {
        try {
            for (FcLayoutField field : removedFields) {
                field.updateRowForDeletion(dataObj, objectIndexId, objectIndexType, templateCategoryId);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateDataObjectForSubTabs(DataObject dataObj, Long objectIndexId, Integer objectIndexType, ArrayList<String> selectedSubTabs, Long templateCategoryId) {
        try {
            Row row = FcLayoutUtil.getObjectIndexRow((DataObject)dataObj, (String)FcLayoutUtil.getSingleValueTableName((Long)templateCategoryId), (Long)objectIndexId, (Integer)objectIndexType);
            if (row == null) {
                return;
            }
            for (String selectedSubTab : selectedSubTabs) {
                if (selectedSubTab.equalsIgnoreCase("noMail") || selectedSubTab.equalsIgnoreCase("mailbox") || selectedSubTab.equalsIgnoreCase("mailEnabled")) {
                    row.set("MAIL_TYPE", (Object)selectedSubTab);
                    continue;
                }
                if (!selectedSubTab.equalsIgnoreCase("lcs") && !selectedSubTab.equalsIgnoreCase("lync") && !selectedSubTab.equalsIgnoreCase("noLcs")) continue;
                row.set("COMMUNICATION_TYPE", (Object)selectedSubTab);
            }
            dataObj.updateRow(row);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillDataObject(DataObject dataObj, Long objectIndexId, Integer objectIndexType, FcFormDataContainer fcFormDataContainer, Long templateCategoryId) {
        FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, objectIndexType, fcFormDataContainer, templateCategoryId, null, null);
    }

    public static void fillDataObject(DataObject dataObj, Long objectIndexId, Integer objectIndexType, FcFormDataContainer fcFormDataContainer, Long templateCategoryId, FcIamApps fcIamApps, ArrayList<Integer> selectedIamAppsList) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField field = (FcLayoutField)e.nextElement();
                long l = System.currentTimeMillis();
                boolean toFillDataObj = true;
                if (selectedIamAppsList != null) {
                    Integer fieldIamAppId = field.getIamAppId();
                    if (fieldIamAppId == null || selectedIamAppsList.contains(fieldIamAppId)) {
                        field.addRowForBulkMgmt(dataObj, objectIndexId, objectIndexType, templateCategoryId);
                    } else if (field.getChildFieldArr() != null && field.getChildFieldArr().size() > 0) {
                        FcIamApp fcIamApp = fcIamApps.getIamApp(fieldIamAppId);
                        ArrayList childFieldArr = field.getChildFieldArr();
                        int length = field.getChildFieldArr().size();
                        for (int i = 0; i < length; ++i) {
                            FcFields childField = fcIamApp.getChildFieldObject((Long)childFieldArr.get(i));
                            if (!selectedIamAppsList.contains((int)childField.getIamAppId())) continue;
                            field.addRowForBulkMgmt(dataObj, objectIndexId, objectIndexType, templateCategoryId);
                        }
                    }
                } else {
                    field.addRowForBulkMgmt(dataObj, objectIndexId, objectIndexType, templateCategoryId);
                }
                long l1 = System.currentTimeMillis() - l;
                if (!debug || l1 <= 0L) continue;
                Long t = (Long)dhash.get(field.getFieldId());
                if (t == null) {
                    t = new Long(0L);
                }
                t = t + l1;
                dhash.put(field.getFieldId(), t);
                df.put(field.getFieldId(), field.getAttribDisplayText());
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void isAuthorizedHeaders(FcFormDataContainer fcFormDataContainer, Vector headerVector, Long templateCategoryId, ArrayList<String> nonAvailableLdapList, ArrayList<String> unAuthorizedLdapNameList, ArrayList<String> hiddenLdapNameList, ArrayList<String> readOnlyLdapNameList, boolean checkAuthorization) {
        try {
            for (Object headerLdapObj : headerVector) {
                if (headerLdapObj == null || headerLdapObj.toString().equals("")) continue;
                Enumeration e = fcFormDataContainer.elements();
                boolean isAvailableInContainer = false;
                while (e.hasMoreElements()) {
                    FcLayoutField fcField = (FcLayoutField)e.nextElement();
                    if (fcField.getIsCustomField().booleanValue()) {
                        if (!fcField.getCustomFieldLdapName().equalsIgnoreCase(headerLdapObj.toString())) continue;
                        isAvailableInContainer = true;
                        boolean isAuthorizedforCSV = fcField.isAuthorizedforCSV(headerLdapObj.toString(), unAuthorizedLdapNameList, hiddenLdapNameList, readOnlyLdapNameList, checkAuthorization);
                        continue;
                    }
                    ArrayList fcAttributesList = fcField.getFcAttributeList();
                    if (fcAttributesList == null || fcAttributesList.size() <= 0) continue;
                    for (FcAttributes fcAttributes : fcAttributesList) {
                        if (!fcAttributes.getAttribLdapName().equalsIgnoreCase(headerLdapObj.toString())) continue;
                        isAvailableInContainer = true;
                        boolean isAuthorizedforCSV = fcField.isAuthorizedforCSV(headerLdapObj.toString(), unAuthorizedLdapNameList, hiddenLdapNameList, readOnlyLdapNameList, checkAuthorization);
                    }
                }
                if (isAvailableInContainer) continue;
                nonAvailableLdapList.add(headerLdapObj.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCsvImportErrroMsg(JSONObject CSVStatusObj, JSONArray errorMsgArray, String extraInfo) {
        try {
            CSVStatusObj.put("status", false);
            CSVStatusObj.put("errorMsg", (Object)errorMsgArray);
            CSVStatusObj.put("extraInfo", (Object)extraInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void selectSubTabInEditingSingleObject(JSONObject selectedSubTabDetails, DataObject userDataDetailsDO, FcLayout fcLayout) {
        FcBulkExecuteFormFlow.selectSubTabInEditingSingleObject(selectedSubTabDetails, userDataDetailsDO, fcLayout, true);
    }

    public static void selectSubTabInEditingSingleObject(JSONObject selectedSubTabDetails, DataObject userDataDetailsDO, FcLayout fcLayout, boolean isProcessingSubTab) {
        try {
            Row row;
            String mailType = null;
            String communicationType = null;
            if (!userDataDetailsDO.isEmpty() && (row = userDataDetailsDO.getRow("FcBulkUserSingleVals")) != null) {
                mailType = (String)row.get("MAIL_TYPE");
                communicationType = (String)row.get("COMMUNICATION_TYPE");
            }
            boolean processMailType = false;
            boolean processCommunicationType = false;
            if ((mailType == null || mailType.equals("")) && selectedSubTabDetails.getBoolean("noMail")) {
                processMailType = true;
            }
            if ((communicationType == null || communicationType.equals("")) && selectedSubTabDetails.getBoolean("noLcs")) {
                processCommunicationType = true;
            }
            ArrayList fcLayoutTabList = fcLayout.getFcLayoutTabList();
            for (int i = 0; i < fcLayoutTabList.size(); ++i) {
                FcLayoutTab fcLayoutTab = (FcLayoutTab)fcLayoutTabList.get(i);
                ArrayList fcLayoutSubTabGroupList = fcLayoutTab.getFcLayoutSubTabGroupList();
                for (int j = 0; j < fcLayoutSubTabGroupList.size(); ++j) {
                    FcLayoutSubTabGroup fcLayoutSubTabGroup = (FcLayoutSubTabGroup)fcLayoutSubTabGroupList.get(j);
                    Boolean isOptionTab = fcLayoutSubTabGroup.getIsOptionTab();
                    if (!isOptionTab.booleanValue()) continue;
                    ArrayList fcLayoutSubTabList = fcLayoutSubTabGroup.getFcLayoutSubTabList();
                    for (int k = 0; k < fcLayoutSubTabList.size(); ++k) {
                        FcLayoutSubTab fcLayoutSubTab = (FcLayoutSubTab)fcLayoutSubTabList.get(k);
                        String subTabType = fcLayoutSubTab.getSubTabType();
                        boolean isSelected = fcLayoutSubTab.getIsDefaultSelectedSubTab();
                        boolean toBeSelected = selectedSubTabDetails.getBoolean(subTabType);
                        if (isProcessingSubTab && processMailType && isSelected && (subTabType.equals("mailbox") || subTabType.equals("mailEnabled"))) {
                            fcLayoutSubTab.setIsDefaultSelectedSubTab(true);
                            continue;
                        }
                        if (isProcessingSubTab && processCommunicationType && isSelected && (subTabType.equals("lcs") || subTabType.equals("lync"))) {
                            fcLayoutSubTab.setIsDefaultSelectedSubTab(true);
                            continue;
                        }
                        fcLayoutSubTab.setIsDefaultSelectedSubTab(toBeSelected);
                    }
                    FcLayoutSubTab fcLayoutSubTab = (FcLayoutSubTab)fcLayoutSubTabList.get(0);
                    ArrayList fcLayoutFieldGroupList = fcLayoutSubTab.getFcLayoutFieldGroupsList();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void isAuthorizedCustomFields(HttpServletRequest request, AdventNetResourceBundle rb, String domainName, Long templateCategoryId, ArrayList<String> nonAvailableLdapList, ArrayList<String> unAuthorizedLdapNameList) {
        ADMPAuthObject authObject = ClientUtil.getAuthObject(request);
        FcBulkExecuteFormFlow.isAuthorizedCustomFields(authObject, rb, domainName, templateCategoryId, nonAvailableLdapList, unAuthorizedLdapNameList);
    }

    public static void isAuthorizedCustomFields(ADMPAuthObject authObject, AdventNetResourceBundle rb, String domainName, Long templateCategoryId, ArrayList<String> nonAvailableLdapList, ArrayList<String> unAuthorizedLdapNameList) {
        try {
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            Long additionalCustomFieldActionId = FcLayoutUtil.getAdditionalCustomAttrActionId((Long)templateCategoryId);
            boolean isModifyObjectCategory = FcLayoutUtil.isModifyObjectCategory((Long)templateCategoryId);
            for (String ldapName : nonAvailableLdapList) {
                boolean isAvailable = false;
                FcAttributes fcAttr = iMgmtHandler.getAttributeDetails("ATTRIB_LDAP_NAME", ldapName);
                if (fcAttr != null) {
                    Long actionId = null;
                    actionId = isModifyObjectCategory ? fcAttr.getModifyId() : fcAttr.getActionId();
                    boolean isAuthorized = ClientUtil.checkAuthorization(authObject, domainName, (long)actionId);
                    if (isAuthorized) continue;
                    unAuthorizedLdapNameList.add(ldapName);
                    continue;
                }
                if (ldapName.equalsIgnoreCase("templateName")) {
                    Long actionIdForChangingTemplate;
                    boolean isAuthorizaedChooseTemplate;
                    if (isModifyObjectCategory || (isAuthorizaedChooseTemplate = ClientUtil.checkAuthorization(authObject, domainName, (long)(actionIdForChangingTemplate = FcLayoutViewHandler.getActionIdForChangingTemplate((Long)templateCategoryId))))) continue;
                    unAuthorizedLdapNameList.add(ldapName);
                    continue;
                }
                boolean isAuthorized = false;
                if (ldapName.equalsIgnoreCase("removeMemberOf")) {
                    Long[] memberOfActionIds = new Long[]{5051L, 5138L, 6007L, 0L, 1433L, 1234L, 5610L, 1099L};
                    isAuthorized = ClientUtil.checkAuthorization(authObject, domainName, (long)memberOfActionIds[templateCategoryId.intValue() - 1]);
                } else if (additionalCustomFieldActionId != null) {
                    isAuthorized = ClientUtil.checkAuthorization(authObject, domainName, (long)additionalCustomFieldActionId);
                }
                if (isAuthorized) continue;
                unAuthorizedLdapNameList.add(ldapName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FcFormDataContainer getSingleObjUserDataContainer(Long objectIndexId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, null, null, domainName, loginId, rb, dpValues);
    }

    public static FcFormDataContainer getSingleObjUserDataContainer(Long objectIndexId, Long templateCategoryId, FcFormDataContainer fcFormDataContainer, DataObject userDataDetailsDO, String domainName, Long loginId, AdventNetResourceBundle rb, Hashtable dpValues) {
        FcFormDataContainer userDataContainer = new FcFormDataContainer();
        try {
            if (userDataDetailsDO == null) {
                userDataDetailsDO = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.userDataId, templateCategoryId);
            }
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("loginId", loginId);
            prop.put("dpValues", dpValues);
            if (fcFormDataContainer == null) {
                fcFormDataContainer = FcExecuteFormFlow.getDefaultLayoutFormContainer(templateCategoryId, rb, domainName, loginId, dpValues, FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            }
            FcBulkExecuteFormFlow.fillUserDataFromDB(fcFormDataContainer, userDataContainer, userDataDetailsDO, templateCategoryId, rb, prop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userDataContainer;
    }

    public static FcFormDataContainer getSingleObjResultDataContainer(Long objectIndexId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, FcFormDataContainer defaultLayoutFormContainer, FcFormDataContainer userDataContainer, FcLayout toClientLayout, DataObject dataObj, HttpServletRequest request, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getSingleObjResultDataContainer(objectIndexId, templateCategoryId, domainName, loginId, rb, defaultLayoutFormContainer, userDataContainer, toClientLayout, dataObj, ClientUtil.getAuthObject(request), parentactionId, checkAuthorization, dpValues);
    }

    public static FcFormDataContainer getSingleObjResultDataContainer(Long objectIndexId, Long templateCategoryId, String domainName, Long loginId, AdventNetResourceBundle rb, FcFormDataContainer defaultLayoutFormContainer, FcFormDataContainer userDataContainer, FcLayout toClientLayout, DataObject dataObj, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getResultDataContainer(objectIndexId, templateCategoryId, rb, domainName, loginId, defaultLayoutFormContainer, toClientLayout, authObject, parentactionId, checkAuthorization, dpValues);
        try {
            if (dataObj == null) {
                dataObj = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.resultDataId, templateCategoryId);
            }
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("loginId", loginId);
            prop.put("dpValues", dpValues);
            FcBulkExecuteFormFlow.fillFieldsFromBulkLayoutTables(resultDataContainer, dataObj, templateCategoryId, prop, rb);
            if (userDataContainer == null) {
                userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, domainName, loginId, rb, dpValues);
            }
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(userDataContainer);
            prop.put("isModification", (Object)(templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 ? 1 : 0));
            FcBulkExecuteFormFlow.updateFieldsToAttributesForBulk(resultDataContainer, userDataContainer, prop);
            JSONObject selectedSubTabDetails = iMgmtHandler.getSelectedSubTabDetails(resultDataContainer, prop);
            iMgmtHandler.removeUnSelectedSubTabFields(resultDataContainer, selectedSubTabDetails);
            FcBulkExecuteFormFlow.removeNullValueFields(resultDataContainer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultDataContainer;
    }

    public static FcFormDataContainer getResultDataContainer(Long objectIndexId, Long templateCategoryId, AdventNetResourceBundle rb, String domainName, Long loginId, FcFormDataContainer defaultLayoutFormContainer, FcLayout toClientLayout, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues) {
        return FcBulkExecuteFormFlow.getResultDataContainer(objectIndexId, templateCategoryId, rb, domainName, loginId, defaultLayoutFormContainer, toClientLayout, authObject, parentactionId, checkAuthorization, dpValues, false, null);
    }

    public static FcFormDataContainer getResultDataContainer(Long objectIndexId, Long templateCategoryId, AdventNetResourceBundle rb, String domainName, Long loginId, FcFormDataContainer defaultLayoutFormContainer, FcLayout toClientLayout, ADMPAuthObject authObject, Long parentactionId, boolean checkAuthorization, Hashtable dpValues, boolean fetchArchiveData, Long archiveTime) {
        FcFormDataContainer resultDataContainer = new FcFormDataContainer();
        try {
            if (defaultLayoutFormContainer == null) {
                defaultLayoutFormContainer = FcExecuteFormFlow.getDefaultLayoutFormContainer(templateCategoryId, rb, domainName, loginId, dpValues, FcExecuteActionConstants.ALL_FIELDS_SYSTEM_DEFAULT_TEMPLATE_EXEC_TYPE);
            }
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            if (toClientLayout == null) {
                Long layoutId = FcLayoutBulkViewHandler.getLayoutIdForObjectIndexId((Long)objectIndexId, (boolean)fetchArchiveData, (Long)archiveTime);
                toClientLayout = new FcLayout(layoutId, rb, domainName);
                resultDataContainer.init(toClientLayout);
                FcBulkExecuteFormFlow.setAdventNetResourceBundle(resultDataContainer, rb);
                if (FcLayoutViewHandler.isDomainNameEmpty((Long)layoutId)) {
                    FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, resultDataContainer, domainName, rb, loginId, templateCategoryId);
                }
            } else {
                resultDataContainer.init(toClientLayout);
                FcBulkExecuteFormFlow.setAdventNetResourceBundle(resultDataContainer, rb);
            }
            iMgmtHandler.updateFieldsAttributes(resultDataContainer, fetchArchiveData, archiveTime);
            Enumeration e = defaultLayoutFormContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcField = (FcLayoutField)e.nextElement();
                if (resultDataContainer.containsKey((Object)fcField.getFieldId())) continue;
                fcField.setIsAvailableInTemplate(Boolean.valueOf(false));
                resultDataContainer.put((Object)fcField.getFieldId(), (Object)fcField.clone());
            }
            iMgmtHandler.updateFieldsAttributes(resultDataContainer, fetchArchiveData, archiveTime);
            if (checkAuthorization) {
                FcExecuteFormFlow.fillAuthorizedFields(authObject, resultDataContainer, templateCategoryId, domainName, parentactionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultDataContainer;
    }

    public static void fillUserDataFromDB(FcFormDataContainer fcFormDataContainer, FcFormDataContainer userDataContainer, DataObject dataObj, Long templateCategoryId, AdventNetResourceBundle rb, Properties prop) throws DataAccessException {
        Enumeration e = fcFormDataContainer.elements();
        while (e.hasMoreElements()) {
            boolean hasValue;
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            if (!fcLayoutField.getIsCustomField().booleanValue() && (hasValue = fcLayoutField.fillFromBulkLayoutTable(dataObj, templateCategoryId, prop))) {
                FcLayoutField userField = fcLayoutField.clone();
                userField.mergeUserData((FcLayoutField)userDataContainer.get((Object)userField.getFieldId()));
                userDataContainer.put((Object)fcLayoutField.getFieldId(), (Object)userField);
            }
            if (!fcLayoutField.getIsCustomField().booleanValue() || fcLayoutField.getComponentId() != 79L || !(hasValue = fcLayoutField.fillFromBulkLayoutTable(dataObj, templateCategoryId, prop))) continue;
            userDataContainer.put((Object)fcLayoutField.getFieldId(), (Object)fcLayoutField.clone());
        }
        String custAttrTableName = FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId);
        Iterator ite = dataObj.getRows(custAttrTableName);
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            if (row == null) continue;
            String customLdapName = row.get("CUSTOM_ATTRIB_NAME") == null ? "" : (String)row.get("CUSTOM_ATTRIB_NAME");
            boolean isFilled = false;
            e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcAttributes fcAttr;
                String ldapName;
                ArrayList fcAttributesList;
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                if (!fcLayoutField.getIsCustomField().booleanValue() || (fcAttributesList = fcLayoutField.getFcAttributeList()) == null || fcAttributesList.size() <= 0 || !customLdapName.equalsIgnoreCase(ldapName = (fcAttr = (FcAttributes)fcAttributesList.get(0)).getAttribLdapName())) continue;
                if (fcLayoutField.getComponentId() == 79L) {
                    isFilled = true;
                } else {
                    String customLdapValue = row.get("CUSTOM_ATTRIB_VALUE") == null ? "" : (String)row.get("CUSTOM_ATTRIB_VALUE");
                    fcLayoutField.fillCustomValue(ldapName, customLdapValue);
                    isFilled = true;
                }
                userDataContainer.put((Object)fcLayoutField.getFieldId(), (Object)fcLayoutField.clone());
            }
            if (isFilled) continue;
            FcLayoutField additionalCustomField = FcLayoutUtil.createAdditionalCustomField((Long)templateCategoryId, (FcFormDataContainer)userDataContainer, (String)customLdapName, (AdventNetResourceBundle)rb);
            String customLdapValue = row.get("CUSTOM_ATTRIB_VALUE") == null ? "" : (String)row.get("CUSTOM_ATTRIB_VALUE");
            additionalCustomField.fillCustomValue(customLdapName, customLdapValue);
            FcFormDataContainer tempContainer = new FcFormDataContainer();
            tempContainer.put((Object)additionalCustomField.getFieldId(), (Object)additionalCustomField);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(tempContainer);
            userDataContainer.put((Object)additionalCustomField.getFieldId(), (Object)additionalCustomField.clone());
        }
    }

    private static void setAdventNetResourceBundle(FcFormDataContainer fcFormDataContainer, AdventNetResourceBundle rb) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcField = (FcLayoutField)e.nextElement();
                fcField.setAdventNetResourceBundle(rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setOUFlags(Long templateCategoryId, FcBulkExecuteFormBean fcBulkExecuteFormBean, FcLayout defaultFcLayout, AdventNetResourceBundle rb, String domainName, Long loginId, Hashtable dpValues) {
        try {
            FcLayoutField selectContainerField;
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            Long defaultLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
            if (defaultFcLayout == null) {
                defaultFcLayout = new FcLayout(defaultLayoutId, rb, domainName);
            }
            String singleValueTableName = "FcBulkUserSelectContainerVals";
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)singleValueTableName, (String)"OU_NAME"), (Object)"", 1));
            crit = crit.and(new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)FcExecuteActionConstants.userDataId, 0));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"FcBulkObjectIndexDetails"));
            sq.addSelectColumn(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"));
            sq.setCriteria(crit);
            sq.addJoin(new Join("FcBulkObjectIndexDetails", singleValueTableName, new String[]{"OBJECT_INDEX_ID"}, new String[]{"OBJECT_INDEX_ID"}, 2));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                fcBulkExecuteFormBean.setIsOUNameAvailable(true);
            } else {
                fcBulkExecuteFormBean.setIsOUNameAvailable(false);
            }
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)defaultLayoutId)) {
                FcFormDataContainer defaultLayoutFormContainer = new FcFormDataContainer();
                defaultLayoutFormContainer.init(defaultFcLayout);
                FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, defaultLayoutFormContainer, domainName, rb, loginId, templateCategoryId);
            }
            if ((selectContainerField = FcLayoutUtil.getContainerField((FcLayout)defaultFcLayout, (AdventNetResourceBundle)rb)) != null) {
                fcBulkExecuteFormBean.setCanEditOU(selectContainerField);
                String containerName = ((FcSelectContainer)selectContainerField.getIComponent()).getDn();
                if (containerName != null && !containerName.equals("")) {
                    fcBulkExecuteFormBean.setCommonContainerName(containerName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isCreateNewOUActionAuthorized(HttpServletRequest request, String domainName) {
        try {
            return ClientUtil.checkAuthorization(request, domainName, (long)FcLayoutRhsConstants.CHOOSE_OU_ACTION_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isOUNameAuthorizedForSelect(HttpServletRequest request, String domainName, boolean isPrivilegedToSelectContainer) {
        try {
            HttpSession session = request.getSession();
            boolean isWorkflowMode = false;
            if (session.getAttribute("FcBulkExecuteFormBean") != null) {
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
                domainName = fcBulkExecuteFormBean.getDomainName();
                isWorkflowMode = fcBulkExecuteFormBean.getIsWorkFlowMode();
            } else if (session.getAttribute("FcExecuteFormBean") != null) {
                FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
                domainName = fcExecuteFormBean.getDomainName();
                isWorkflowMode = fcExecuteFormBean.getIsWorkFlowMode();
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            boolean isPrivilegedToSelectDomain = true;
            ArrayList ouList = HDTDomainHandler.getAuthorizedOUList((String)domainName, (Long)loginId, (boolean)isWorkflowMode);
            if (ouList != null && ouList.size() != 0 || !isPrivilegedToSelectContainer) {
                isPrivilegedToSelectDomain = false;
            }
            return isPrivilegedToSelectDomain;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isOUNameAuthorizedForSelect(HttpServletRequest request, String domainName) {
        try {
            HttpSession session = request.getSession();
            if (session.getAttribute("FcBulkExecuteFormBean") != null) {
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
                domainName = fcBulkExecuteFormBean.getDomainName();
                if (fcBulkExecuteFormBean.getIsWorkFlowMode()) {
                    return true;
                }
            } else if (session.getAttribute("FcExecuteFormBean") != null) {
                FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
                domainName = fcExecuteFormBean.getDomainName();
                if (fcExecuteFormBean.getIsWorkFlowMode()) {
                    return true;
                }
            }
            boolean isAuthorized = ClientUtil.checkAuthorization(request, domainName, 1475L) || ClientUtil.checkAuthorization(request, domainName, 53019L);
            return isAuthorized;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void getWFAuditDetails(FcFormDataContainer oldClientData, FcFormDataContainer newClientData, FcFormDataContainer oldTemplate, FcFormDataContainer newTemplateData, Properties props, AdventNetResourceBundle rb, int objectIndex, Long templateCategoryId) {
        try {
            Hashtable<String, Object> hash;
            boolean isModification = templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0;
            Enumeration e = newClientData.elements();
            FcFormDataContainer oldClientData1 = oldClientData.clone();
            while (e.hasMoreElements()) {
                FcLayoutField fcField = (FcLayoutField)e.nextElement();
                Long fieldId = fcField.getFieldId();
                FcLayoutField oldClient = (FcLayoutField)oldClientData1.remove((Object)fieldId);
                String oldValue = " - ";
                String newValue = " - ";
                boolean isOUName = false;
                ArrayList fcAttributesList = fcField.getFcAttributeList();
                String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
                if (ldapName.equalsIgnoreCase("OUName")) {
                    isOUName = true;
                }
                if ((oldClient == null || !oldClient.isUserChangedField(fcField)) && (oldClient != null || fcField.getIComponent().hasEmptyValue(isModification)) || isOUName) continue;
                if (oldClient != null) {
                    oldValue = oldClient.getIComponent().getRuleFieldListDisplayValue(rb, false);
                } else if (oldTemplate != null && oldTemplate.get((Object)fieldId) != null) {
                    FcLayoutField oldTemp = (FcLayoutField)oldTemplate.get((Object)fieldId);
                    oldValue = oldTemp.getIComponent().getRuleFieldListDisplayValue(rb, false);
                }
                if (fcField.getComponentId().intValue() == 36) {
                    if (oldClient != null) {
                        newValue = fcField.getIComponent().getRuleFieldListDisplayValue(rb, false);
                    } else if (!fcField.getIComponent().hasEmptyValueForWorkFlow()) {
                        newValue = fcField.getIComponent().getRuleFieldListDisplayValue(rb, false);
                    }
                } else if (!fcField.getIComponent().hasEmptyValueForWorkFlow()) {
                    newValue = fcField.getIComponent().getRuleFieldListDisplayValue(rb, false);
                }
                if ("-".equals(oldValue.trim()) && "-".equals(newValue.trim())) continue;
                hash = new Hashtable<String, Object>();
                hash.put("filedName", fcField.getAttribDisplayText());
                if (fcField.getComponentId().intValue() == 24 && objectIndex == FcExecuteActionConstants.userDataId) {
                    String suffixValue;
                    if (oldValue.trim().endsWith("@") && oldTemplate != null && oldTemplate.get((Object)fieldId) != null) {
                        FcLayoutField oldTemplateField = (FcLayoutField)oldTemplate.get((Object)fieldId);
                        suffixValue = ((FcLogonName)oldTemplateField.getIComponent()).getFcUpnSuffix().getUserTypedValue();
                        oldValue = oldValue + suffixValue;
                    }
                    if (newValue.trim().endsWith("@") && newTemplateData != null && newTemplateData.get((Object)fieldId) != null) {
                        FcLayoutField newTemplateField = (FcLayoutField)newTemplateData.get((Object)fieldId);
                        suffixValue = ((FcLogonName)newTemplateField.getIComponent()).getFcUpnSuffix().getUserTypedValue();
                        newValue = newValue + suffixValue;
                    }
                }
                hash.put("newValue", newValue);
                hash.put("oldValue", oldValue);
                hash.put("objectIndex", objectIndex);
                props.put(fieldId, hash);
            }
            Enumeration e1 = oldClientData.elements();
            while (e1.hasMoreElements()) {
                String old;
                FcLayoutField fcField = (FcLayoutField)e1.nextElement();
                Long fieldId = fcField.getFieldId();
                FcLayoutField oldClient = (FcLayoutField)oldClientData1.get((Object)fieldId);
                boolean isOUName = false;
                ArrayList fcAttributesList = fcField.getFcAttributeList();
                String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
                if (ldapName.equalsIgnoreCase("OUName")) {
                    isOUName = true;
                }
                if (oldClient == null || isOUName || "".equals((old = oldClient.getIComponent().getRuleFieldListDisplayValue(rb, false)).trim()) || "-".equals(old.trim()) || oldClient.getIComponent().hasEmptyValue()) continue;
                hash = new Hashtable();
                hash.put("filedName", oldClient.getAttribDisplayText());
                hash.put("newValue", "-");
                hash.put("oldValue", old);
                hash.put("objectIndex", objectIndex);
                props.put(fieldId, hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Properties getWFAuditDataContainers(Long objectIndexId, Long templateCategoryId, DataObject userDataObj, Properties props, String domainName, AdventNetResourceBundle rb) {
        Properties prop = new Properties();
        try {
            Hashtable dpValues = (Hashtable)props.get("dpValue");
            Long loginId = (Long)props.get("loginId");
            Long parentactionId = (Long)props.get("parentactionId");
            ADMPAuthObject authObject = (ADMPAuthObject)props.get("authObj");
            Long layoutId = (Long)props.get("layoutId");
            FcFormDataContainer selectLayoutContainer = new FcFormDataContainer();
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            FcLayout defaultLayout = new FcLayout(layoutId, rb, domainName);
            selectLayoutContainer.init(defaultLayout);
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, selectLayoutContainer, domainName, rb, loginId, templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(selectLayoutContainer);
            FcFormDataContainer userDataContainer = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(objectIndexId, templateCategoryId, selectLayoutContainer, userDataObj, domainName, loginId, rb, dpValues);
            FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getSingleObjResultDataContainer(objectIndexId, templateCategoryId, domainName, loginId, rb, null, userDataContainer, null, null, authObject, parentactionId, false, dpValues);
            iMgmtHandler.updateFieldsAttributes(userDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(userDataContainer);
            iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            iMgmtHandler.updateFieldValuesToAttributes(resultDataContainer);
            prop.put("userdata", userDataContainer);
            prop.put("resultdata", resultDataContainer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    private static void fillWFAuditChanges(Long objectIndexId, Properties auditProp, Properties oldDataForAudit, FcFormDataContainer userDataContainer, FcFormDataContainer resultDataContainer, AdventNetResourceBundle rb, Long templateCategoryId) {
        try {
            FcFormDataContainer oldUserData = (FcFormDataContainer)oldDataForAudit.get("userdata");
            FcFormDataContainer oldResultData = (FcFormDataContainer)oldDataForAudit.get("resultdata");
            Properties prop = new Properties();
            FcBulkExecuteFormFlow.getWFAuditDetails(oldResultData, resultDataContainer, null, null, prop, rb, 2, templateCategoryId);
            FcBulkExecuteFormFlow.getWFAuditDetails(oldUserData, userDataContainer, oldResultData, resultDataContainer, prop, rb, 1, templateCategoryId);
            if (!prop.isEmpty()) {
                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities((Long)auditProp.get("requestId"), (Long)auditProp.get("taskDetailsId"), (Long)auditProp.get("loginId"));
                auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                auditActivities.setAuditActivitySubType(WFRequestUtil.LAYOUT_TASK_OBJECT_MODIFIED);
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("layoutArray", (Object)prop);
                auditActivities.updateAuditActivities(jsonObj, objectIndexId, new JSONArray(), new JSONArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean addObjectGuidToList(Vector headerVector, ArrayList<Vector> list, String domainName, JSONObject errorDetailsObj) {
        try {
            int keyLdapheaderIndex = -1;
            String keyLdapColumnName = null;
            String keyLdapName = null;
            int vectorSize = headerVector.size();
            for (int k = 0; k < vectorSize; ++k) {
                for (int i = 0; i < AutomationConstants.keyLdapNames.length; ++i) {
                    if (!headerVector.get(k).toString().equalsIgnoreCase(AutomationConstants.keyLdapNames[i])) continue;
                    keyLdapheaderIndex = k;
                    keyLdapColumnName = AutomationConstants.keyColumnNames[i];
                    keyLdapName = AutomationConstants.keyLdapNames[i];
                    break;
                }
                if (keyLdapName != null) break;
            }
            if (keyLdapheaderIndex == -1) {
                errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)"Key LDAP name not found"));
                return false;
            }
            Criteria searchCrit = null;
            String tableName = "ADSMUserGeneralDetails";
            ArrayList<String> keyLdapValueList = new ArrayList<String>();
            for (Vector vector : list) {
                String keyLdapValue = vector.get(keyLdapheaderIndex).toString();
                keyLdapValueList.add(keyLdapValue);
            }
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)keyLdapColumnName));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            if (keyLdapValueList != null && !keyLdapValueList.isEmpty()) {
                String[] keyLdapValueListArray = keyLdapValueList.toArray(new String[keyLdapValueList.size()]);
                String[] chunkArray = null;
                for (int i = 0; i < keyLdapValueListArray.length; i += chunk) {
                    chunkArray = Arrays.copyOfRange(keyLdapValueListArray, i, Math.min(keyLdapValueListArray.length, i + chunk));
                    searchCrit = new Criteria(Column.getColumn((String)tableName, (String)keyLdapColumnName), (Object)chunkArray, 8, false);
                    if (searchCrit == null) {
                        errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)"Search criteria cannot be constructed"));
                        return false;
                    }
                    Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)new Integer(1), 0));
                    criteria = criteria.and(searchCrit);
                    query.setCriteria(criteria);
                    DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                    dataObj.append(dObj);
                }
            }
            if (dataObj.isEmpty()) {
                logg.log(Level.INFO, "Values given in CSV not exists in DB-- " + searchCrit);
                errorDetailsObj.put("errorMsg", (Object)new JSONArray().put((Object)"Object not exist"));
                return false;
            }
            for (int k = 0; k < list.size(); ++k) {
                Vector vector = list.get(k);
                String keyLdapValue = vector.get(keyLdapheaderIndex).toString();
                if (keyLdapValue == null || keyLdapValue.isEmpty()) continue;
                Criteria crit1 = new Criteria(new Column(tableName, keyLdapColumnName), (Object)keyLdapValue, 0);
                Row row = dataObj.getRow(tableName, crit1);
                if (row == null) {
                    logg.log(Level.INFO, "Object-" + keyLdapValue + " does not exist in DB.");
                    list.remove(k);
                    --k;
                    continue;
                }
                vector.add(vectorSize, (String)row.get("OBJECT_GUID"));
            }
            if (!list.isEmpty()) {
                headerVector.add(vectorSize, "objectGUID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

