/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcContactMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcContactCreationListener
extends FcADMgmtListener {
    String userName = null;
    String ouName = null;
    ArrayList groupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    String targetAddress = null;
    boolean usePowerShell = false;
    ArrayList<Hashtable> customList;
    String customScriptResult = "";
    DataObject auditDataObject = null;

    public FcContactCreationListener() {
        this.defaultGroupRID = "";
        this.objectType = "contact";
    }

    @Override
    public void reInit() {
        super.reInit();
        this.userName = "";
        this.ouName = null;
        this.rusMessage = "";
        this.groupList = null;
        this.nativeStatusProps = new Properties();
        this.auditLogProps = new Hashtable();
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.targetAddress = null;
        this.usePowerShell = false;
        this.createContact();
    }

    @Override
    public void setStatusMsgForWorkFlowResponse(HttpServletRequest request, Long requestId) {
        request.setAttribute("userName", (Object)this.fcNativeProperties.getProps().getProperty("userName"));
        request.setAttribute("ouName", (Object)this.ouName);
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
        if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
            this.nativeStatusProps.setProperty("STATUS_MESSAGE", LicenseMgr.getInstance().getlicenseMessage("Workflow", this.rb));
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
        } else if (!this.isBulkMgmt) {
            if (requestId.compareTo(-2L) == 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            } else if (requestId.compareTo(-1L) != 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_contact.message_success"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
            } else {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_contact.message_failure"));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            }
        }
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
    }

    private ArrayList<Hashtable> updateCustomAttributeProperties(FcFormDataContainer fromClientData) {
        ArrayList<Hashtable> customListTemp = new ArrayList<Hashtable>();
        try {
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcContactMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
            customFieldsContainer.splitCustomFields(fromClientData);
            FcContactMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            customListTemp = this.getCustomAttribsProperties(customFieldsContainer, false, ldapVsValueProps, "contact");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return customListTemp;
    }

    public void createContact() {
        try {
            Properties customScriptProps;
            String preventDeletion;
            boolean isLicenseExceeded;
            mgmtLog.log(Level.INFO, " FcContactCreation Started ");
            this.stopExecution = false;
            FcContactMgmtHandler.getInstance().updateFieldsTableName(this.fromClientData);
            FcContactMgmtHandler.getInstance().initDataObjForFieldsToAttributes();
            FcContactMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcContactMgmtHandler.getInstance().updateFieldsActionId(this.fromClientData);
            FcContactMgmtHandler.getInstance().updateDefaultComponentId(this.fromClientData);
            FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.customList = this.updateCustomAttributeProperties(this.fromClientData);
            this.addAttributeToNativeProps(this.fromClientData, fcNativeProperties);
            Properties props = fcNativeProperties.getProps();
            this.userName = props.getProperty("userName");
            this.ouName = props.getProperty("OUName");
            if (this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("")) {
                this.ouName = this.commonContainerName;
            }
            if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)this.ouName)) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                return;
            }
            this.groupList = fcNativeProperties.getGroupList();
            String escapedUserName = "";
            if (this.userName != null) {
                escapedUserName = CommonUtil.escapeString((String)this.userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            }
            String adminGroup = null;
            String mailAlias = null;
            Integer exchType = 0;
            ArrayList nonExchPropList = new ArrayList();
            if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                adminGroup = props.getProperty("adminGroup");
            }
            if (props.get("mailAlias") != null) {
                mailAlias = props.getProperty("mailAlias");
            }
            if (props.get("targetAddress") != null) {
                this.targetAddress = props.getProperty("targetAddress");
            }
            if (adminGroup != null) {
                this.usePowerShell = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                exchType = ExchangeUtil.getAdminGroupType((String)adminGroup, (String)this.domainName);
            }
            if (isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"contactMgmt")) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            if (this.stopExecution) {
                if (!this.isBulkMgmt) {
                    ArrayList messageList = new ArrayList();
                    messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                    if (messageList == null) {
                        messageList = new ArrayList();
                    }
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout_error.duplication_occurred_contact"), this.duplicatedAttribute));
                    errorHash.put("ERROR_CODE", "0");
                    messageList.add(errorHash);
                    this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout_error.duplication_occurred_contact"), this.duplicatedAttribute));
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return;
            }
            if (this.usePowerShell && !this.msExchPoliciesExcluded) {
                ArrayList<String> nonExchAttrList = new ArrayList<String>();
                nonExchAttrList.add("givenName");
                nonExchAttrList.add("displayName");
                nonExchAttrList.add("sAMAccountName");
                nonExchAttrList.add("sn");
                nonExchAttrList.add("name");
                ArrayList propList = this.fcNativeProperties.getPropList();
                int propCount = propList.size();
                for (int ind1 = 0; ind1 < propCount; ++ind1) {
                    String ldapName = (String)((Hashtable)propList.get(ind1)).get("ATTRIB_LDAP_NAME");
                    if (nonExchAttrList.contains(ldapName)) {
                        nonExchPropList.add(propList.get(ind1));
                        continue;
                    }
                    if (!ldapName.equalsIgnoreCase("proxyAddresses")) continue;
                    nonExchPropList.add(propList.get(ind1));
                    propList.remove(ind1);
                    --propCount;
                    --ind1;
                }
            }
            ArrayList<Hashtable> exchCustomList = new ArrayList<Hashtable>();
            if (this.usePowerShell) {
                int count = this.customList.size();
                for (int i = 0; i < count; ++i) {
                    Hashtable propAttributeHash = this.customList.get(i);
                    String attribLdapName = (String)propAttributeHash.get("ATTRIB_LDAP_NAME");
                    for (String attrib : UserMgmtUtil.exchCustAttribList) {
                        if (!attrib.equalsIgnoreCase(attribLdapName)) continue;
                        exchCustomList.add(propAttributeHash);
                        this.customList.remove(i);
                        --i;
                        --count;
                    }
                }
            }
            if (this.targetAddress != null && (props.get("displayName") == null || props.get("displayName").equals(""))) {
                Hashtable<String, Object> displayNameHash = new Hashtable<String, Object>();
                displayNameHash.put("ATTRIB_LDAP_NAME", "displayName");
                displayNameHash.put("ATTRIB_VALUE", this.userName);
                displayNameHash.put("ATTRIB_VALUE_COUNT", new Long(1L));
                displayNameHash.put("DATA_HANDLER_TYPE", new Long(3L));
                fcNativeProperties.getPropList().add(displayNameHash);
            }
            if (!this.isADSelected) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "NO_AD");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                if (!this.isBulkMgmt) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                } else {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new String());
                }
                mgmtLog.log(Level.INFO, " FcContactCreation Listener finished ");
                return;
            }
            mgmtLog.log(Level.INFO, " Contact Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.ouName);
            mgmtLog.log(Level.INFO, " User Name :" + this.userName);
            mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " nonExchPropList " + nonExchPropList);
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.userName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("nonExchPropList", nonExchPropList);
            this.auditLogProps.put("groupList", this.groupList);
            if (props.get("customScriptDetails") != null) {
                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
            }
            if (props.get("preventDeletion") != null) {
                this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
            }
            if (this.isADSelected) {
                this.statusObject = !this.usePowerShell ? ADHandler.addContact((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)escapedUserName, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)this.groupList) : ADHandler.addContact((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)escapedUserName, nonExchPropList, (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)this.groupList);
            }
            this.nativeStatusProps = this.isBulkMgmt ? this.getBulkContactErrorMessage(this.statusObject, escapedUserName) : this.getSingleContactErrorMessage(this.statusObject, escapedUserName);
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            String ldapSearchDN = CommonUtil.escapeSpecialCharacters((String)("CN=" + escapedUserName + "," + this.ouName));
            String searchString = "(&(objectClass=contact)(objectCategory=contact)(distinguishedName=" + ldapSearchDN + "))";
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                NativeError customError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, this.customList, new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                }
            }
            if (this.usePowerShell && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                String hideFromAddrListErr;
                String message = "";
                this.rusMessage = "";
                String distinguishedName = "CN=" + escapedUserName + "," + this.ouName;
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.domainName, (String)adminGroup, (Long)this.loginId);
                if (this.targetAddress != null && mailAlias != null) {
                    message = ADHandler.createMailEnabledContact2007((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailAlias, (String)this.targetAddress, (Properties)exchangeServerDetails);
                }
                if (message.length() != 0) {
                    this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_contacts.statmsg.mail_enabled"), this.rb.getString(message)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                } else if (props.get("msExchHideFromAddressLists") != null && props.getProperty("msExchHideFromAddressLists").equalsIgnoreCase("true") && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)"mailContact", (String)"true", (Properties)exchangeServerDetails)).trim().length() > 0) {
                    ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                    if (messageList == null) {
                        messageList = new ArrayList();
                    }
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", hideFromAddrListErr);
                    messageList.add(errorHash);
                    this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                }
                mgmtLog.log(Level.INFO, "MailEnabled Contact status Message " + message + " objectName " + distinguishedName);
                NativeError exchPropError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)this.groupList, (boolean)false);
                if (!this.isBulkMgmt) {
                    this.setSingleContactErrorMessage(exchPropError, searchString);
                } else {
                    this.setBulkContactErrorMessage(exchPropError, searchString);
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.removedProxyAddresses.size() > 0) {
                StringBuilder proxyError = new StringBuilder();
                for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                    Hashtable hash = (Hashtable)this.removedProxyAddresses.get(index);
                    if (index > 0) {
                        proxyError.append(", ");
                    }
                    String proxyAddress = (String)hash.get("PROXY_ADDRESS");
                    String assignedUserName = (String)hash.get("USER_NAME");
                    proxyError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_proxy_already_exist_for_the_user"), proxyAddress, assignedUserName));
                }
                String proxyErrorString = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_removed_proxy_addresses"), proxyError.toString());
                if (this.isBulkMgmt) {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + proxyErrorString);
                } else {
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", proxyErrorString);
                    errorHash.put("NATIVE_ERROR_MESSAGE", ".");
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        ArrayList<Hashtable<String, String>> errorList = new ArrayList<Hashtable<String, String>>();
                        errorList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", errorList);
                    } else {
                        for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(errorHash);
                        }
                    }
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !exchCustomList.isEmpty()) {
                NativeError customError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, exchCustomList, new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                }
                this.customList.addAll(exchCustomList);
            }
            if (!CREATION_STATUS.equals("SEVERE") && props.get("preventDeletion") != null && (preventDeletion = (String)props.get("preventDeletion")).equalsIgnoreCase("true")) {
                this.updatePreventDeletion("CN=" + escapedUserName + "," + this.ouName, "add");
                String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                if (!this.ouName.equalsIgnoreCase(defaultNamingcontext)) {
                    this.updateParent(this.ouName);
                }
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                    if (this.isBulkMgmt && this.customScriptResult != null && !this.customScriptResult.equals("")) {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.customScriptResult);
                    }
                }
            }
            mgmtLog.log(Level.INFO, " FcContactCreation Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            if (this.isBulkMgmt) {
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.internal_error"));
            }
            Hashtable<String, String> exceptionHash = new Hashtable<String, String>();
            exceptionHash.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.internal_error"));
            exceptionHash.put("NATIVE_ERROR_MESSAGE", ".");
            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(exceptionHash);
        }
    }

    public Properties getBulkContactErrorMessage(NativeError statusObject, String escapedUserName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder errCodeBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.domainName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.ouName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.ouName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.ouName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.setProperty("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.userName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.userName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.userName);
            errCodeBuilder.append(this.getErrorCodes(this.userName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        if (!this.userName.equals(escapedUserName) && statusObject.getErrorMessage((Object)escapedUserName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)escapedUserName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)escapedUserName);
            errCodeBuilder.append(this.getErrorCodes(escapedUserName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) != null) {
                messageBuilder.append(statusObject.getErrorMessage(object, this.rb));
            }
            errCodeBuilder.append(this.getErrorCodes(object, statusObject));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.ad_mgmt.create_user.successfully_created_contact_but_following_errors_occured"), messageBuilder.toString()));
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_sucessfully_created_contact"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
        return statusProps;
    }

    @Override
    public String getErrorCodes(Object key, NativeError errHdlr) {
        StringBuilder errCodeBuilder = new StringBuilder();
        try {
            ArrayList errorList = errHdlr.getErrorList(key);
            if (errorList != null && !errorList.isEmpty()) {
                String errorCode = null;
                for (Hashtable hashtable : errorList) {
                    errorCode = (String)hashtable.get("ERROR_CODE");
                    if (errorCode == null) continue;
                    errCodeBuilder.append(errCodeBuilder.length() > 0 ? "," + errorCode : errorCode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCodeBuilder.toString();
    }

    @Override
    public Long createRequest(String domainName, JSONObject wfCreateRequestJson, FcFormDataContainer fromClientData, FcFormDataContainer userData, Long loginId, Long layoutId, FcLayout executeFormLayout, Long templateCategoryId) {
        boolean isRequestCreated = false;
        Long requestId = -1L;
        try {
            this.domainName = domainName;
            this.fromClientData = fromClientData;
            this.userData = userData;
            this.loginId = loginId;
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
                return -1L;
            }
            this.preMgmtActions();
            Long objectCreationId = FcExecuteFormFlow.getNewObjectCreationId();
            Long objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, layoutId);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            this.creationId = objectCreationId;
            this.objectIndexId = objectIndexId;
            FcContactMgmtHandler.getInstance().updateFieldsAttributes(fromClientData);
            FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(fromClientData);
            FcContactMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
            FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
            FcContactMgmtHandler.getInstance().updateFieldsAttributes(userData);
            FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(userData);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userData, FcExecuteActionConstants.contactCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, fromClientData, FcExecuteActionConstants.contactCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.contactCreationTemplateCategoryId);
            JSONArray selectedIamAppsJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            String containerName = FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            if (ouList.size() > 0 && !ouList.contains(containerName)) {
                boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                Criteria c = null;
                c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                if (!ouList.contains(containerName)) {
                    return -2L;
                }
            }
            FcLayoutUpdateHandler.updateObjectCreationIdDetails((Long)objectCreationId, (String)domainName, (String)containerName, (Long)layoutId);
            requestId = FcExecuteFormFlow.createWorkFlowRequest(objectCreationId, FcExecuteActionConstants.contactCreationTemplateCategoryId, loginId, domainName, wfCreateRequestJson, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public void preMgmtActions() throws Exception {
        FcContactMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcContactMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        this.customFieldsContainer = new FcFormDataContainer();
        this.customFieldsContainer.splitCustomFields(this.fromClientData);
        FcContactMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
        FcContactMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
        FcNativeProperties fcNativeProperties = this.fcNativeProperties;
        this.getProperties(false, this.fromClientData, fcNativeProperties, ldapVsValueProps, "contact");
        Properties props = fcNativeProperties.getProps();
        this.userName = props.getProperty("displayName");
        this.ouName = props.getProperty("OUName");
    }

    @Override
    public boolean importCSVDetailsForAutomation(Long objectCreationId, DataObject dataObj, JSONObject errorDetailsObj, Vector headerVector, ArrayList<Vector> list, Long loginId, AdventNetResourceBundle rb, String domainName, Long selectedLayoutId, boolean isTemplateHeaderAvailable, int templateHeaderIndex) {
        boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, null, dataObj, errorDetailsObj, headerVector, list, FcExecuteActionConstants.contactCreationTemplateCategoryId, loginId, rb, domainName, isTemplateHeaderAvailable, templateHeaderIndex, selectedLayoutId, false, FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb));
        return status;
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData, FcNativeProperties fcNativeProperties) throws Exception {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcContactMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
        this.getProperties(false, fromClientData, fcNativeProperties, ldapVsValueProps, "contact");
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("userName", (Object)this.userName);
        request.setAttribute("rusMessage", (Object)this.rusMessage);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        String hostId = request.getRemoteHost();
        Long tid = new Long(request.getParameter("templateId"));
        Properties toAudit = new Properties();
        toAudit.setProperty("TEMPLATE_NAME", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
        this.updateAuditEntries(null, toAudit);
    }

    public Long updateAuditEntries() {
        return this.updateAuditEntries(null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList) {
        return this.updateAuditEntries(auditObjectIdList, null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList, Properties toAudit) {
        Long audit_id = 0L;
        Long object_id = 0L;
        try {
            NotificationMacro macro;
            Properties grpList;
            Integer reportId = 3001;
            if (!this.isBulkMgmt) {
                reportId = 3009;
                String status = this.nativeStatusProps.getProperty("CREATION_STATUS");
                if (!status.equalsIgnoreCase("SEVERE")) {
                    DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"CONTACT"}, (boolean)false);
                }
            }
            if (this.isWorkflowExcution && this.workFlowType.compareTo(0L) == 0) {
                reportId = 3009;
            } else if (this.isWorkflowExcution) {
                reportId = 3001;
            }
            if (this.userName == null) {
                this.userName = "";
            }
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleName = "";
            moduleName = this.workFlowType == 2L ? this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (this.workFlowType == 1L ? this.rb.getString("admp.auto.automation.heading.automation") : (this.workFlowType == 0L ? this.rb.getString("admp.home.feature.heading.workflow") : ""));
            audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleName, (Long)this.requestId);
            object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)this.objectIndexId, (Long)FcExecuteActionConstants.contactCreationTemplateCategoryId, (String)this.userName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            if (auditObjectIdList != null && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                auditObjectIdList.add(object_id);
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            if (this.groupList != null && !this.groupList.isEmpty() && this.isADSelected) {
                grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", this.groupList);
                propList.add(grpList);
            }
            if (props.get("preventDeletion") != null) {
                Properties preventDeletionProps = new Properties();
                preventDeletionProps.put("ATTRIB_LDAP_NAME", "preventDeletion");
                preventDeletionProps.put("ATTRIB_VALUE_COUNT", (Object)1L);
                preventDeletionProps.put("ATTRIB_VALUE", (String)props.get("preventDeletion"));
                propList.add(preventDeletionProps);
            }
            if (this.usePowerShell && this.targetAddress != null && this.isADSelected) {
                Properties targetAddrList = new Properties();
                targetAddrList.put("ATTRIB_LDAP_NAME", "targetAddress");
                targetAddrList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                targetAddrList.put("ATTRIB_VALUE", this.targetAddress);
                propList.add(targetAddrList);
            }
            if (props.get("customScriptDetails") != null) {
                grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            if (this.ouName != null && this.isADSelected) {
                Properties ouProp = new Properties();
                ouProp.put("ATTRIB_LDAP_NAME", "ouName");
                ouProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                ouProp.put("ATTRIB_VALUE", this.ouName);
                propList.add(ouProp);
            }
            if (props.get("proxyAddresses") != null && this.isADSelected) {
                Properties proxyAddressProperties = new Properties();
                proxyAddressProperties.put("ATTRIB_LDAP_NAME", "proxyAddresses");
                proxyAddressProperties.put("ATTRIB_VALUE_COUNT", (Object)1L);
                proxyAddressProperties.put("ATTRIB_VALUE", props.get("proxyAddresses").toString());
                propList.add(proxyAddressProperties);
            }
            ArrayList<String> objectOUList = new ArrayList<String>();
            objectOUList.add(this.ouName);
            Properties fullNameProp = new Properties();
            fullNameProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
            fullNameProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
            fullNameProp.put("ATTRIB_VALUE", this.userName);
            propList.add(fullNameProp);
            if (this.isADSelected) {
                for (int ijk = 0; ijk < this.customList.size(); ++ijk) {
                    Hashtable customHash = this.customList.get(ijk);
                    Properties customProp = new Properties();
                    customProp.put("ATTRIB_LDAP_NAME", customHash.get("ATTRIB_LDAP_NAME"));
                    customProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    customProp.put("ATTRIB_VALUE", customHash.get("ATTRIB_VALUE"));
                    propList.add(customProp);
                }
                if (toAudit != null) {
                    Properties propToAud = new Properties();
                    propToAud.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
                    propToAud.put("ATTRIB_VALUE", toAudit.getProperty("TEMPLATE_NAME"));
                    propList.add(propToAud);
                }
            }
            this.updateO365AuditEntries(propList, FcExecuteActionConstants.contactCreationTemplateCategoryId);
            String creationStatus = "";
            if (!this.isBulkMgmt) {
                creationStatus = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
                ArrayList creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (creationMsg != null && !creationMsg.isEmpty()) {
                    if (creationStatus != null && creationStatus.trim().length() > 0) {
                        creationStatus = creationStatus + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text_but_follng_error_occured");
                    }
                    for (int i = 0; i < creationMsg.size(); ++i) {
                        Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                        String errorCode = (String)creationMessage.get("ERROR_CODE");
                        if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                            creationStatus = creationStatus + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                        }
                        creationStatus = creationStatus + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE")) + (creationMessage.get("NATIVE_ERROR_MESSAGE") != null ? creationMessage.get("NATIVE_ERROR_MESSAGE") : "");
                    }
                }
                if (!this.rusMessage.equals("")) {
                    creationStatus = creationStatus != null && creationStatus.trim().length() > 0 ? creationStatus + ", " + this.rusMessage : creationStatus + this.rusMessage;
                }
            } else {
                creationStatus = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (this.rusMessage.trim().length() > 0) {
                    creationStatus = creationStatus + " " + this.rusMessage;
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", creationStatus);
                }
            }
            if (this.isBulkMgmt) {
                TechAuditAPI.getInstance().auditContactModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_contacts"), this.userName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), creationStatus, object_id, auditDataObj, this.rb);
            } else {
                TechAuditAPI.getInstance().auditContactModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_single_contacts"), this.userName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), creationStatus, object_id, auditDataObj, this.rb);
            }
            String statusMessage = "";
            statusMessage = creationStatus == null || creationStatus.isEmpty() ? this.rb.getString("admp.mgmt.user_mgmt.cre_single_contact.statmsg.success_created_contact") : creationStatus;
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.workFlowType != 0L && !this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 4;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.CONTACT_CREATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.CONTACT_CREATION_MANAGER_FIELD_ID) : (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.CONTACT_CREATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BCC_LAYOUT_VIEW_ID;
                this.triggerNotifiation(audit_id, object_id, this.userName, manager, null, userObjectId, ReportsUtil.SINGLE_CONTACT_CREATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
            if (this.isWorkflowExcution() && (macro = (NotificationMacro)NotificationTemplateHandler.macroMap.get(this.wfRequestId)) != null && AutomationUtil.isNotifyEnabledAutomation((Long)((Long)macro.getIds().get("automationId")))) {
                if (this.auditDataObject != null) {
                    this.auditDataObject.merge(auditDataObj);
                } else {
                    this.auditDataObject = auditDataObj;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return audit_id;
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setSingleContactErrorMessage(NativeError errHdlr, String searchString) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchString, this.rb) != null) {
            messageList = (ArrayList<Hashtable>)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList((Object)searchString);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public void setBulkContactErrorMessage(NativeError errHdlr, String searchString) {
        ArrayList errorList = new ArrayList();
        String bulkMgmtMessage = new String();
        if (errHdlr.getErrorMessage((Object)searchString, this.rb) != null) {
            bulkMgmtMessage = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (bulkMgmtMessage == null) {
                bulkMgmtMessage = new String();
            }
            errorList = errHdlr.getErrorList((Object)searchString);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                if (bulkMgmtMessage.length() == 0) {
                    bulkMgmtMessage = message;
                    continue;
                }
                bulkMgmtMessage = bulkMgmtMessage + ", " + message;
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", bulkMgmtMessage);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public Properties getSingleContactErrorMessage(NativeError statusObject, String escapedUserName) {
        String statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_contact.statmsg.success_created_contact");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            } else {
                statusProps.setProperty("STATUS_MESSAGE", "");
            }
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)ouName);
            errorSeverity = statusObject.getSeverityLevel((Object)ouName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            } else {
                statusProps.setProperty("STATUS_MESSAGE", "");
            }
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)escapedUserName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)escapedUserName);
            errorSeverity = statusObject.getSeverityLevel((Object)escapedUserName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                    statusProps.setProperty("STATUS_MESSAGE", statusMessage);
                } else {
                    statusProps.setProperty("STATUS_MESSAGE", "");
                }
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return this.nativeStatusProps;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public void setSingleUserErrorMessage(String errorMessage) {
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }

    public HashMap ldapToDisplayMapping() {
        HashMap<Integer, Properties> mapList = new HashMap<Integer, Properties>();
        try {
            ArrayList columnList = ColumnConfiguration.getColumnList((long)FcExecuteActionConstants.BCC_LAYOUT_VIEW_ID, (int)2);
            Enumeration e = this.fromClientData.elements();
            boolean isO365ManagerUpdated = false;
            int o365ManagerColumnLocation = -1;
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    Object attributeValue = fcAttribute.getAttribValue();
                    String columnName = fcAttribute.getAttribColumnName();
                    Properties prop = new Properties();
                    for (int k = 0; k < columnList.size(); ++k) {
                        HashMap map = (HashMap)columnList.get(k);
                        if (map.get("COL_NAME").toString().equalsIgnoreCase("O365MANAGER")) {
                            o365ManagerColumnLocation = k;
                        }
                        if (!map.containsValue(columnName)) continue;
                        if (columnName.equalsIgnoreCase("O365MANAGER")) {
                            isO365ManagerUpdated = true;
                        }
                        if (attributeValue == null) {
                            attributeValue = "-";
                        }
                        prop.put(map.get("COLUMN_NAME"), attributeValue);
                        mapList.put(k, prop);
                    }
                }
            }
            if (!isO365ManagerUpdated && o365ManagerColumnLocation != -1) {
                Properties prop = new Properties();
                prop.put("admp.common.attrib_disp_name.o365_manager", "-");
                mapList.put(o365ManagerColumnLocation, prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapList;
    }
}

