/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcContactModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class FcContactModificationListener
extends FcADMgmtListener {
    String fullName = "";
    String distinguishedName = "";
    String searchString = "";
    String guid = "";
    ArrayList authorizedOUList = null;
    ArrayList groupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    String legacyExchangeDN = "";
    String mailNickname = null;
    boolean isMailEnabledContact = false;
    Long msExchVersion = 0L;
    ArrayList<Hashtable> customList;
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();
    String customScriptResult = "";
    boolean preventDeletion = false;
    String[] mandatoryFields = new String[]{"name", "distinguishedName", "legacyExchangeDN", "mailNickname", "targetAddress", "proxyAddresses", "msExchVersion"};
    String[] restrictedFields = new String[]{"OUName", "msExchAdminGroup"};
    public static int NO_MAIL_CONTACT = 0;
    public static int MAIL_ENABLED_CONTACT = 1;

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId, null);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.modifyContact();
    }

    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    @Override
    public void setAuthorizedOUList(ArrayList authorizedOUList) {
        this.authorizedOUList = authorizedOUList;
    }

    @Override
    public void restrictFieldsFromEditing(FcFormDataContainer fcLayoutTabFields) {
        Enumeration e = fcLayoutTabFields.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
            for (int i = 0; i < this.restrictedFields.length; ++i) {
                if (!this.restrictedFields[i].equalsIgnoreCase(ldapName)) continue;
                fcLayoutField.setIsRestricted(Boolean.valueOf(true));
                fcLayoutField.setIsAuthorized(Boolean.valueOf(false));
            }
        }
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            if (attribList.contains("preventDeletion") && this.distinguishedName != "") {
                this.preventDeletion = ADHandler.getACEsFromDN((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)"preventDeletion", (String)"");
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(String.valueOf(this.preventDeletion));
                valuesList.put("preventDeletion", temp);
            }
            this.fillMandatoryFields(valuesList);
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Properties prop = new Properties();
                prop.put("domainName", this.domainName);
                prop.put("loginId", loginId);
                prop.put("legacyExchangeDN", this.legacyExchangeDN);
                prop.put("groupDetailsTable", this.groupDetailsTable);
                if (this.memberOfList != null && (fcLayoutField.getComponentId() == 8L || fcLayoutField.getComponentId() == 20L)) {
                    Properties tempProp = new Properties();
                    tempProp.put("memberOf", this.memberOfList);
                    fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, tempProp, prop, showADValue);
                    continue;
                }
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList proxyAddressesValueList;
            ArrayList fullNameValueList;
            ArrayList distinguishedNameValueList;
            ArrayList exchServerVersionList;
            ArrayList mailNicknameValueList;
            ArrayList targetAddressValueList;
            String legacyDN;
            int index;
            ArrayList legacyDNValueList = (ArrayList)valuesList.get("legacyExchangeDN");
            if (legacyDNValueList != null && (index = (legacyDN = (String)legacyDNValueList.get(0)).toLowerCase().lastIndexOf("/cn=recipients/cn=")) != -1) {
                this.legacyExchangeDN = legacyDN.substring(0, index);
            }
            if ((targetAddressValueList = (ArrayList)valuesList.get("targetAddress")) != null) {
                this.existingTargetAddress = (String)targetAddressValueList.get(0);
            }
            if ((mailNicknameValueList = (ArrayList)valuesList.get("mailNickname")) != null) {
                this.mailNickname = (String)mailNicknameValueList.get(0);
            }
            if ((exchServerVersionList = (ArrayList)valuesList.get("msExchVersion")) != null) {
                this.msExchVersion = Long.parseLong((String)exchServerVersionList.get(0));
            }
            if ((distinguishedNameValueList = (ArrayList)valuesList.get("distinguishedName")) != null) {
                this.distinguishedName = (String)distinguishedNameValueList.get(0);
                this.fcNativeProperties.setDN(this.distinguishedName);
            }
            if ((fullNameValueList = (ArrayList)valuesList.get("name")) != null) {
                this.fullName = (String)fullNameValueList.get(0);
            }
            if ((proxyAddressesValueList = (ArrayList)valuesList.get("proxyAddresses")) != null) {
                this.existingProxyAddresses = proxyAddressesValueList;
            }
            if (this.existingTargetAddress != null && this.mailNickname != null) {
                this.isMailEnabledContact = true;
            }
            ArrayList list = (ArrayList)valuesList.get("memberOf");
            this.setMemberOfValues(list);
            mgmtLog.log(Level.INFO, " Mail Enabled Contact : " + this.isMailEnabledContact);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMemberOfValues(ArrayList MemberOfList) {
        if (MemberOfList != null) {
            Hashtable authorizedGroupList = new Hashtable();
            this.memberOfList = new ArrayList();
            String[] columns = new String[]{"DOMAIN_NAME", "OBJECT_GUID", "DISTINGUISHED_NAME", "SID_STRING", "GROUPTYPE", "GROUP_NAME"};
            authorizedGroupList = MemberOfList.size() > 40 ? this.loadMemberOfData(MemberOfList) : GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)this.loginId, (ArrayList)MemberOfList, (String)"domain", (String[])columns);
            for (String key : authorizedGroupList.keySet()) {
                Properties properties = (Properties)authorizedGroupList.get(key);
                this.memberOfList.add((String)properties.get("DISTINGUISHED_NAME"));
            }
            this.groupDetailsTable = authorizedGroupList;
        }
    }

    @Override
    public int getSelectedSubTab() {
        if (this.isMailEnabledContact) {
            return MAIL_ENABLED_CONTACT;
        }
        return NO_MAIL_CONTACT;
    }

    public void modifyContact() {
        block10: {
            try {
                boolean isLicenseExceeded;
                mgmtLog.log(Level.INFO, " FcContact Modification Started ");
                this.isChangesFound = true;
                FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
                FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.contactModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, this.loginId, this.guid, this.domainName, this.executeFormLayout, this);
                FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
                customFieldsContainer.splitCustomFields(modifiedFieldsContainer);
                FcContactModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
                FcContactModificationMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
                if (this.isFieldModified("memberOf", modifiedFieldsContainer) && !this.isFieldModified("memberOf", this.adData)) {
                    FcFormDataContainer tempModFieldsContainer = new FcFormDataContainer();
                    tempModFieldsContainer.put((Object)520L, modifiedFieldsContainer.get((Object)520L));
                    this.getADValues(FcExecuteActionConstants.contactModificationTemplateCategoryId, tempModFieldsContainer, this.adData, this.loginId);
                }
                FcContactModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
                FcContactModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
                FcContactModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
                FcContactModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
                Properties domainProp = new Properties();
                domainProp.put("domainName", this.domainName);
                Properties ldapVsValueProps = FcContactModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
                ldapVsValueProps = FcContactModificationMgmtHandler.getInstance().getLdapVsValuesFromAD(this.fieldValueList, ldapVsValueProps);
                this.customList = this.getCustomAttribsProperties(customFieldsContainer, true, ldapVsValueProps, "contact");
                FcNativeProperties fcNativeProperties = this.fcNativeProperties;
                this.addAttributeToNativeProps(modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, "contact");
                Properties props = fcNativeProperties.getProps();
                this.groupList = fcNativeProperties.getGroupList();
                String searchDN = this.distinguishedName;
                this.searchString = "(&(objectClass=contact)(objectCategory=contact)(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)this.distinguishedName) + "))";
                mgmtLog.log(Level.INFO, " Contact Modification : domainName " + this.domainName);
                mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
                mgmtLog.log(Level.INFO, " Contact Name :" + this.fullName);
                mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
                mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
                mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
                mgmtLog.log(Level.INFO, " customList " + this.customList);
                this.auditLogProps.put("domainName", this.domainName);
                this.auditLogProps.put("userName", this.fullName);
                this.auditLogProps.put("propList", fcNativeProperties.getPropList());
                this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
                this.auditLogProps.put("groupList", this.groupList);
                this.auditLogProps.put("customList", this.customList);
                if (props.get("customScriptDetails") != null) {
                    this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
                }
                if (props.get("preventDeletion") != null) {
                    this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
                }
                if (isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"contactMgmt")) {
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    hash.put("ERROR_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    }
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                    return;
                }
                if (fcNativeProperties.getPropList().size() > 0 || this.groupList.size() > 0 || this.customList.size() > 0 || this.toBeRemovedGroupList.size() > 0 || props.size() > 0) {
                    if (this.authorizedOUList == null || this.authorizedOUList.size() == 0) {
                        Properties properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                        String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                        this.modifyContactAction(fcNativeProperties, props, this.customList, defaultNamingContext);
                        break block10;
                    }
                    for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                        String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                        String s = searchDN.toLowerCase();
                        if (!s.endsWith(dn)) continue;
                        this.modifyContactAction(fcNativeProperties, props, this.customList, (String)this.authorizedOUList.get(i));
                        break block10;
                    }
                    break block10;
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.isChangesFound = false;
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void modifyContactAction(FcNativeProperties fcNativeProperties, Properties props, ArrayList customList, String containerDN) {
        boolean usePowerShell = false;
        Integer exchType = 0;
        boolean updatePolicy = false;
        String hideAddressBook = (String)props.get("msExchHideFromAddressLists");
        Properties domainProp = new Properties();
        domainProp.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcContactModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
        String policyIncluded = (String)ldapVsValueProps.get("msExchPoliciesExcluded");
        if (this.legacyExchangeDN != null && ExchangeUtil.checkExchangeGroup2007((String)this.legacyExchangeDN, (String)this.domainName)) {
            usePowerShell = true;
        }
        if (props.get("msExchPoliciesIncluded") != null && props.get("msExchPoliciesIncluded").equals("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}") && usePowerShell) {
            updatePolicy = true;
        }
        Properties exchangeServerDetails = null;
        if (usePowerShell) {
            String exchVersion = ExchangeUtil.getExchangeVersion((Long)this.msExchVersion);
            exchangeServerDetails = ExchangeUtil.getExchangeServerDetails((String)this.domainName, (String)exchVersion);
            exchType = ExchangeUtil.getExchType((String)exchVersion);
        }
        try {
            Properties customScriptProps;
            String hideFromAddrListErr;
            this.statusObject = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)containerDN, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), (ArrayList)fcNativeProperties.getPropList(), (ArrayList)this.groupList, (boolean)false);
            this.nativeStatusProps = this.getSingleContactErrorMessage(this.statusObject);
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                NativeError customError = ADHandler.searchAndModifyContact((String)this.domainName, (Long)this.loginId, (String)containerDN, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), (ArrayList)customList, new ArrayList(), (boolean)false);
                AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
            }
            if (updatePolicy && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
            }
            if ((hideAddressBook != null || props.get("msExchPoliciesIncluded") == null && props.get("mailAlias") != null && policyIncluded.equalsIgnoreCase("true")) && usePowerShell && this.msExchVersion != 0L && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)"mailContact", (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")))).trim().length() > 0) {
                this.setNativeStatusProps(hideFromAddrListErr, "", "", "");
            }
            if (!this.toBeRemovedGroupList.isEmpty()) {
                String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                ArrayList groupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)defaultNamingContext);
                ArrayList<Properties> list = new ArrayList<Properties>();
                Properties p = new Properties();
                p.put("ATTRIB_VALUE", this.distinguishedName);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_LDAP_NAME", "member");
                p.put("DW_CONTROL_CODE", new Long(4L));
                list.add(p);
                for (int i = 0; i < this.toBeRemovedGroupList.size(); ++i) {
                    Properties prop = UserMgmtUtil.getPropertiesfromDN((String)((String)this.toBeRemovedGroupList.get(i)), (ArrayList)groupList);
                    String groupSid = null;
                    if (prop != null) {
                        groupSid = UserMgmtUtil.getGroupSIDfromRID((String)((String)prop.get("objectRID")), (ArrayList)groupList);
                    }
                    if (groupSid == null) continue;
                    try {
                        ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)groupSid, (String)this.distinguishedName, list, null);
                        continue;
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        this.setNativeStatusProps(MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout.error_while_removing_group"), (String)prop.get("Display_Name")), "SEVERE", "/images/error_icon.gif", "redtxtbold");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            if (props.get("preventDeletion") != null) {
                Properties properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                if (Boolean.valueOf(props.get("preventDeletion").toString()).booleanValue()) {
                    grpList.put("ATTRIB_VALUE", "true");
                    System.out.println("this.distinguishedName: " + this.distinguishedName);
                    String rootName = StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                    this.updatePreventDeletion(this.distinguishedName, "add");
                    if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                        this.updateParent(rootName);
                    }
                } else {
                    grpList.put("ATTRIB_VALUE", "false");
                    this.updatePreventDeletion(this.distinguishedName, "delete");
                }
                propList.add(grpList);
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                }
            }
            if (props.getProperty("userName") != null && !props.getProperty("userName").equals("") && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("severe")) {
                mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + props.getProperty("userName") + " for the Contact : " + this.distinguishedName);
                try {
                    ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)props.getProperty("userName"), null);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    this.setNativeStatusProps(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullname"), le.getMessage(this.rb)), "SEVERE", "/images/error_icon.gif", "redtxtbold");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mgmtLog.log(Level.INFO, " Fc Contact Modification Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setNativeStatusProps(String message, String status, String image, String messageStyle) {
        ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", message);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        if (!image.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_IMAGE", image);
        }
        if (!status.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_STATUS", status);
        }
        if (!messageStyle.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", messageStyle);
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer modifiedFieldsContainer, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps, String objectClass) throws Exception {
        this.getProperties(true, modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, objectClass);
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        try {
            ArrayList creationMsg;
            Properties grpList;
            request.setAttribute("statusProps", (Object)this.nativeStatusProps);
            if (!(this.isChangesFound || this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0 || this.fcNativeProperties.getModifyList() != null && this.fcNativeProperties.getModifyList().size() != 0 || this.fcNativeProperties.getTsList() != null && this.fcNativeProperties.getTsList().size() != 0 || this.fcNativeProperties.getWinNTAttributeList() != null && this.fcNativeProperties.getWinNTAttributeList().size() != 0 || this.groupList != null && this.groupList.size() != 0 || this.customList != null && this.customList.size() != 0)) {
                return;
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)3011, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)this.moduleUsed, (Long)this.requestId);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.fullName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
            if (this.groupList != null && !this.groupList.isEmpty()) {
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedGroup : this.groupList) {
                    modifiedMemberOfValues.add(addedGroup);
                }
            }
            if (this.toBeRemovedGroupList != null && !this.toBeRemovedGroupList.isEmpty()) {
                String removedHeading = (modifiedMemberOfValues.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedMemberOfValues.add(removedHeading);
                for (String removedGroup : this.toBeRemovedGroupList) {
                    modifiedMemberOfValues.add(removedGroup);
                }
            }
            if (!modifiedMemberOfValues.isEmpty()) {
                grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedMemberOfValues);
                propList.add(grpList);
            }
            if (props.get("customScriptDetails") != null) {
                grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            if (!this.customList.isEmpty()) {
                ArrayList<String> customAttributeList = new ArrayList<String>();
                for (Hashtable customAttribute : this.customList) {
                    String ldapVsValue = (String)customAttribute.get("ATTRIB_LDAP_NAME") + " : " + customAttribute.get("ATTRIB_VALUE").toString() + "<br/>";
                    customAttributeList.add(ldapVsValue);
                }
                Properties customAuditList = new Properties();
                customAuditList.put("ATTRIB_LDAP_NAME", "customAttributes");
                customAuditList.put("ATTRIB_VALUE_COUNT", (Object)customAttributeList.size());
                customAuditList.put("ATTRIB_VALUE", customAttributeList);
                propList.add(customAuditList);
            }
            if (props != null && props.containsKey("userName")) {
                Properties contactName = new Properties();
                contactName.put("ATTRIB_VALUE", props.getProperty("userName"));
                contactName.put("ATTRIB_LDAP_NAME", "name");
                propList.add(contactName);
            }
            Long tid = new Long(request.getParameter("templateId"));
            Properties propToAudit = new Properties();
            propToAudit.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
            propToAudit.put("ATTRIB_VALUE", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            propList.add(propToAudit);
            TechAuditAPI.getInstance().auditContactModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.mod_single_contacts"), this.fullName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), this.nativeStatusProps.getProperty("STATUS_MESSAGE"), object_id, auditDataObj, this.rb);
            request.setAttribute("statusProps", (Object)this.nativeStatusProps);
            request.setAttribute("customScriptResult", (Object)this.customScriptResult);
            String statusMessage = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
            if (statusMessage == null) {
                statusMessage = "";
            }
            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
            }
            if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                        statusMessage = statusMessage + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                    }
                    statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                    if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                    statusMessage = statusMessage + creationMessage.get("NATIVE_ERROR_MESSAGE");
                }
            }
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (!this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"CONTACT"}, (boolean)false);
            }
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 4;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.CONTACT_MODIFICATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.CONTACT_MODIFICATION_MANAGER_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.CONTACT_MODIFICATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BCC_LAYOUT_VIEW_ID;
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(ouName);
                this.triggerNotifiation(audit_id, object_id, this.fullName, manager, null, userObjectId, ReportsUtil.SINGLE_CONTACT_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public Properties getSingleContactErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String errStatusMessage = this.rb.getString("admp.mgmt.common.statmsg.updated_with_errors");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", errStatusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    @Override
    public boolean isAuthorizedObject() {
        boolean isAuthorizedObject = false;
        if (this.authorizedOUList == null || this.authorizedOUList.size() == 0 || this.distinguishedName == null) {
            isAuthorizedObject = true;
        } else {
            for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                String s = this.distinguishedName.toLowerCase();
                if (!s.endsWith(dn)) continue;
                isAuthorizedObject = true;
            }
        }
        return isAuthorizedObject;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

