/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcDLGroupMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;

public class FcDLGroupCreationListener
extends FcADMgmtListener {
    String groupName = null;
    String groupType = null;
    String ouName = null;
    String includedRecipients = null;
    String queryFilter = null;
    String ldapQueryFilter = null;
    ArrayList groupList = null;
    ArrayList membersList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.createGroup();
    }

    public void createGroup() {
        try {
            boolean isLicenseExceeded;
            mgmtLog.log(Level.INFO, " FcDLGroupCreation Started ");
            FcDLGroupMgmtHandler.getInstance().updateFieldsTableName(this.fromClientData);
            FcDLGroupMgmtHandler.getInstance().initDataObjForFieldsToAttributes();
            FcDLGroupMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcDLGroupMgmtHandler.getInstance().updateFieldsActionId(this.fromClientData);
            FcDLGroupMgmtHandler.getInstance().updateDefaultComponentId(this.fromClientData);
            FcDLGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            this.addAttributeToNativeProps(this.fromClientData);
            Properties props = this.fcNativeProperties.getProps();
            this.groupName = props.getProperty("name");
            this.ouName = props.getProperty("OUName");
            this.groupList = this.fcNativeProperties.getGroupList();
            if (props.getProperty("msExchQueryFilterMetadata") != null) {
                this.includedRecipients = props.getProperty("msExchQueryFilterMetadata");
            }
            if (props.getProperty("msExchQueryFilter") != null) {
                this.queryFilter = props.getProperty("msExchQueryFilter");
            }
            if (props.getProperty("msExchDynamicDLFilter") != null) {
                this.ldapQueryFilter = props.getProperty("msExchDynamicDLFilter");
            }
            String escapedGroupName = CommonUtil.escapeString((String)this.groupName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String adminGroup = null;
            String mailAlias = null;
            boolean isMailEnabled = false;
            Boolean isPowerShellEnabled = false;
            if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                adminGroup = props.getProperty("adminGroup");
            }
            if (props.get("mailAlias") != null) {
                mailAlias = props.getProperty("mailAlias");
            }
            if (adminGroup != null && mailAlias != null) {
                isMailEnabled = true;
                isPowerShellEnabled = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
            }
            if (isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"groupMgmt")) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            if (!this.msExchPoliciesExcluded) {
                ArrayList propList = this.fcNativeProperties.getPropList();
                int propCount = propList.size();
                for (int ind1 = 0; ind1 < propCount; ++ind1) {
                    String ldapName = (String)((Hashtable)propList.get(ind1)).get("ATTRIB_LDAP_NAME");
                    if (!ldapName.equalsIgnoreCase("proxyAddresses")) continue;
                    Hashtable proxyAddr = (Hashtable)propList.get(ind1);
                    proxyAddr.put("DW_CONTROL_CODE", 3);
                }
            }
            mgmtLog.log(Level.INFO, " Group Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.ouName);
            mgmtLog.log(Level.INFO, " User Name :" + this.groupName);
            mgmtLog.log(Level.INFO, " IncludedRecipients :" + this.includedRecipients);
            mgmtLog.log(Level.INFO, " RecipientFilter :" + this.queryFilter);
            mgmtLog.log(Level.INFO, " getPropsList " + this.fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " nonExchPropList " + this.fcNativeProperties.getNonExchAttributeList());
            mgmtLog.log(Level.INFO, " modifyList " + this.fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.domainName, (String)adminGroup, (Long)this.loginId);
            Integer exchType = (Integer)exchangeServerDetails.get("EXCH_TYPE");
            mgmtLog.log(Level.INFO, " exchangeServerDetails " + exchangeServerDetails);
            String canonicalOUName = StrUtil.getContainerFlowFromDN((String)this.ouName) + "/" + StrUtil.getNameFromDN((String)this.ouName);
            mgmtLog.log(Level.INFO, " canonicalOUName " + canonicalOUName);
            System.out.println("getFilterQuery(): " + this.getFilterQuery());
            if (exchType == 2003) {
                ArrayList<String> nonExch2003AttrList = new ArrayList<String>();
                nonExch2003AttrList.add("msExchSenderHintTranslations");
                nonExch2003AttrList.add("publicDelegates");
                nonExch2003AttrList.add("sendAs");
                nonExch2003AttrList.add("msExchModerationFlags");
                nonExch2003AttrList.add("msExchEnableModeration");
                nonExch2003AttrList.add("msExchModeratedByLink");
                nonExch2003AttrList.add("msExchBypassModerationLink");
                nonExch2003AttrList.add("msExchBypassModerationFromDLMembersLink");
                nonExch2003AttrList.add("msExchQueryFilterMetadata");
                nonExch2003AttrList.add("msExchDynamicDLFilter");
                ArrayList<String> nonExchAttrList = new ArrayList<String>();
                nonExchAttrList.add("name");
                nonExchAttrList.add("sAMAccountName");
                nonExchAttrList.add("cn");
                nonExchAttrList.add("name");
                nonExchAttrList.add("msExchQueryFilterMetadata");
                nonExchAttrList.add("msExchDynamicDLBaseDN");
                ArrayList propList = this.fcNativeProperties.getPropList();
                ArrayList nonExch2003PropList = new ArrayList();
                ArrayList nonExchPropList = this.fcNativeProperties.getNonExchAttributeList();
                int propCount = propList.size();
                for (int ind1 = 0; ind1 < propCount; ++ind1) {
                    String ldapName = (String)((Hashtable)propList.get(ind1)).get("ATTRIB_LDAP_NAME");
                    if (!nonExch2003AttrList.contains(ldapName)) {
                        nonExch2003PropList.add(propList.get(ind1));
                    }
                    if (!nonExchAttrList.contains(ldapName)) continue;
                    Hashtable hash = (Hashtable)propList.get(ind1);
                    if (ldapName.equalsIgnoreCase("msExchQueryFilterMetadata")) {
                        hash.put("ATTRIB_VALUE", this.getFilterQuery());
                        hash.put("ATTRIB_LDAP_NAME", "msExchDynamicDLFilter");
                    }
                    nonExchPropList.add(hash);
                }
                mgmtLog.log(Level.INFO, " nonExchPropList " + nonExchPropList);
                mgmtLog.log(Level.INFO, " nonExch2003PropList " + nonExch2003PropList);
                String filterQueryString = this.getFilterQuery();
                this.statusObject = ADHandler.addDLGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)escapedGroupName, (ArrayList)nonExchPropList);
                this.nativeStatusProps = this.getSingleGroupErrorMessage(this.statusObject, escapedGroupName);
                String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                    String searchDN = this.getSearchStringDN(this.groupName, this.ouName);
                    String searchString = "(&(objectCategory=msExchDynamicDistributionList)(objectClass=msExchDynamicDistributionList)(distinguishedName=" + searchDN + "))";
                    NativeError modifyExchPropError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, nonExch2003PropList, (ArrayList)this.groupList, (boolean)false);
                    this.setSingleGroupErrorMessage(modifyExchPropError, searchString);
                }
            } else {
                ArrayList propList = this.fcNativeProperties.getPropList();
                int propCount = propList.size();
                for (int ind1 = 0; ind1 < propCount; ++ind1) {
                    String ldapName = (String)((Hashtable)propList.get(ind1)).get("ATTRIB_LDAP_NAME");
                    if (!ldapName.equalsIgnoreCase("msExchQueryFilterMetadata")) continue;
                    propList.remove(ind1);
                    break;
                }
                mgmtLog.log(Level.INFO, " getPropsList " + propList);
                String info = ADHandler.createDynamicDistributionGroup2007((String)this.domainName, (long)this.loginId, (String)this.groupName, (String)mailAlias, (String)this.includedRecipients, (String)canonicalOUName, (Properties)exchangeServerDetails, (String)this.ouName);
                if (info.length() != 0) {
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_dl_group.statmsg.dl_group_error"), this.rb.getString(info)));
                    hash.put("NATIVE_ERROR_MESSAGE", "");
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                } else {
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_dl_group"));
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    String searchDN = this.getSearchStringDN(this.groupName, this.ouName);
                    String searchString = "(&(objectCategory=msExchDynamicDistributionList)(objectClass=msExchDynamicDistributionList)(distinguishedName=" + searchDN + "))";
                    NativeError modifyExchPropError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, (ArrayList)propList, (ArrayList)this.groupList, (boolean)false);
                    this.setSingleGroupErrorMessage(modifyExchPropError, searchString);
                }
                String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                    String hideFromAddrListErr;
                    Hashtable<String, String> errorHash;
                    ArrayList messageList;
                    String queryFilterErr;
                    String distinguishedName = "CN=" + escapedGroupName + "," + this.ouName;
                    if (this.queryFilter != null && !this.queryFilter.equalsIgnoreCase("") && (queryFilterErr = ADHandler.setQueryFilter((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)this.queryFilter, (Properties)exchangeServerDetails)).trim().length() > 0) {
                        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                        if (messageList == null) {
                            messageList = new ArrayList();
                        }
                        errorHash = new Hashtable<String, String>();
                        errorHash.put("ERROR_MESSAGE", queryFilterErr);
                        messageList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                    }
                    if (props.get("msExchHideFromAddressLists") != null && props.getProperty("msExchHideFromAddressLists").equalsIgnoreCase("true") && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)"dlGroup", (String)"true", (Properties)exchangeServerDetails)).trim().length() > 0) {
                        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                        if (messageList == null) {
                            messageList = new ArrayList();
                        }
                        errorHash = new Hashtable();
                        errorHash.put("ERROR_MESSAGE", hideFromAddrListErr);
                        messageList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                    }
                    if (props.get("sendAs") != null && exchType > 2010) {
                        Hashtable sendAsResultHash = new Hashtable();
                        String sendAsErrorMsg = "";
                        ArrayList sendAsSidList = (ArrayList)props.get("sendAs");
                        sendAsResultHash = this.updateSendAsAttribute(sendAsSidList, distinguishedName, "add");
                        sendAsErrorMsg = this.getErrorStringForSendAs(sendAsResultHash, sendAsErrorMsg);
                        if (sendAsErrorMsg.trim().length() > 0) {
                            this.setSingleGroupErrorMessage(sendAsErrorMsg);
                        }
                    }
                }
            }
            mgmtLog.log(Level.INFO, " FcDLGroupCreation Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getSearchStringDN(String groupName, String ouName) {
        String searchName = "";
        try {
            String[] ESCAPE_CHARECTERS = new String[]{"\\5c", "<", ">", "=", ",", ";", "\"", "+"};
            searchName = CommonUtil.escapeSpecialCharacters((String)groupName);
            searchName = EscapeUtil.escapeLdapSearchString((String)searchName, (String[])ESCAPE_CHARECTERS);
            LdapName name1 = new LdapName(ouName);
            List<Rdn> rdns = name1.getRdns();
            String searchOUName = "";
            for (int index = 0; index < rdns.size(); ++index) {
                Rdn rdn = rdns.get(index);
                String searchContainer = CommonUtil.escapeSpecialCharacters((String)((String)rdn.getValue()));
                searchContainer = EscapeUtil.escapeLdapSearchString((String)searchContainer, (String[])ESCAPE_CHARECTERS);
                String containerDN = rdn.toString();
                searchOUName = index == 0 ? containerDN.substring(0, 3) + searchContainer : containerDN.substring(0, 3) + searchContainer + "," + searchOUName;
            }
            searchName = "CN=" + searchName + "," + searchOUName;
        }
        catch (Exception e) {
            searchName = "CN=" + groupName + "," + ouName;
            e.printStackTrace();
        }
        return searchName;
    }

    public String getFilterQuery() {
        String query = "";
        if (this.includedRecipients.equalsIgnoreCase("AllRecipients")) {
            query = "(&(!cn=SystemMailbox{*})(&(mailnickname=*)(|(&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder))))";
        } else {
            if (this.includedRecipients.contains("MailboxUsers")) {
                query = query + "(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))";
            }
            if (this.includedRecipients.contains("MailUsers")) {
                query = query + "(&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))";
            }
            if (this.includedRecipients.contains("Resources")) {
                query = query + "(objectCategory=publicFolder)";
            }
            if (this.includedRecipients.contains("MailContacts")) {
                query = query + "(&(objectCategory=person)(objectClass=contact))";
            }
            if (this.includedRecipients.contains("MailGroups")) {
                query = query + "(&(objectCategory=group)(objectCategory=msExchDynamicDistributionList))";
            }
            query = "(&(!cn=SystemMailbox{*})(&(mailnickname=*)(|" + query + ")))";
        }
        if (this.ldapQueryFilter != null && !this.ldapQueryFilter.equalsIgnoreCase("")) {
            query = "(&" + query + this.ldapQueryFilter + ")";
        }
        System.out.println("query: " + query);
        return query;
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData) throws Exception {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcDLGroupMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        this.getProperties(false, fromClientData, this.fcNativeProperties, ldapVsValueProps, "msExchDynamicDistributionList");
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("userName", (Object)this.groupName);
        request.setAttribute("rusMessage", (Object)this.rusMessage);
        this.auditLogProps.put("domainName", this.domainName);
        this.auditLogProps.put("userName", this.groupName);
        this.auditLogProps.put("propList", this.fcNativeProperties.getPropList());
        this.auditLogProps.put("nonExchPropList", this.fcNativeProperties.getNonExchAttributeList());
        this.auditLogProps.put("modifyList", this.fcNativeProperties.getModifyList());
        this.auditLogProps.put("groupList", this.groupList);
        String statusMessage = "";
        try {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"Group"}, (boolean)false);
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)4101, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.groupName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties ouProp = new Properties();
            ouProp.put("ATTRIB_LDAP_NAME", "ouName");
            ouProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
            ouProp.put("ATTRIB_VALUE", this.ouName);
            propList.add(ouProp);
            ArrayList<String> objectOUList = new ArrayList<String>();
            objectOUList.add(this.ouName);
            Properties includedRecipientsProp = new Properties();
            includedRecipientsProp.put("ATTRIB_LDAP_NAME", "msExchQueryFilterMetadata");
            includedRecipientsProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
            includedRecipientsProp.put("ATTRIB_VALUE", this.includedRecipients);
            propList.add(includedRecipientsProp);
            if (this.queryFilter != null && !this.queryFilter.equalsIgnoreCase("")) {
                Properties filterProp = new Properties();
                filterProp.put("ATTRIB_LDAP_NAME", "msExchQueryFilter");
                filterProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                filterProp.put("ATTRIB_VALUE", this.queryFilter);
                propList.add(filterProp);
            }
            if (this.ldapQueryFilter != null && !this.ldapQueryFilter.equalsIgnoreCase("")) {
                Properties ldapFilterProp = new Properties();
                ldapFilterProp.put("ATTRIB_LDAP_NAME", "msExchDynamicDLFilter");
                ldapFilterProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                ldapFilterProp.put("ATTRIB_VALUE", this.ldapQueryFilter);
                propList.add(ldapFilterProp);
            }
            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_dl_group");
            } else {
                ArrayList creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (creationMsg != null && !creationMsg.isEmpty()) {
                    for (int i = 0; i < creationMsg.size(); ++i) {
                        Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                        String errorCode = (String)creationMessage.get("ERROR_CODE");
                        if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                            statusMessage = statusMessage + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + creationMessage.get("ERROR_CODE") + " : ";
                        }
                        statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE")) + creationMessage.get("NATIVE_ERROR_MESSAGE");
                    }
                } else {
                    statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_dl_group");
                }
            }
            if (!this.rusMessage.equals("")) {
                statusMessage = statusMessage + this.rusMessage;
            }
            TechAuditAPI.getInstance().auditGroupModification(this.loginId, this.rb.getString("admp.mgmt.grp_mgmt.cre_single_dl_grp.mgmtname.dlGroup_creation"), this.groupName, this.domainName, propList, this.rb.getString(statusMessage), object_id, auditDataObj, this.rb);
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 2;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.DL_GROUP_MODIFICATION_MANAGED_BY_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.DL_GROUP_MODIFICATION_MANAGED_BY_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.DL_GROUP_MODIFICATION_MANAGED_BY_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BGC_LAYOUT_VIEW_ID;
                this.triggerNotifiation(audit_id, object_id, this.groupName, manager, null, userObjectId, ReportsUtil.SINGLE_DL_GROUP_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setSingleGroupErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.length() == 0) {
            return;
        }
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }

    public void setSingleGroupErrorMessage(NativeError errHdlr, String searchString) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchString, this.rb) != null) {
            messageList = (ArrayList<Hashtable>)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList((Object)searchString);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public Properties getSingleGroupErrorMessage(NativeError statusObject, String escapedGroupName) {
        String statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_dl_group");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)ouName);
            errorSeverity = statusObject.getSeverityLevel((Object)ouName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)escapedGroupName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)escapedGroupName);
            errorSeverity = statusObject.getSeverityLevel((Object)escapedGroupName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

