/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.formats.AdvancedFormatUtil;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcAvoidDuplication;
import com.adventnet.sym.adsm.common.server.layout.FcDefaultLayout;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcGroupMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutRhsConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcSubTab;
import com.adventnet.sym.adsm.common.server.layout.FcSubTabGroup;
import com.adventnet.sym.adsm.common.server.layout.FcTab;
import com.adventnet.sym.adsm.common.server.layout.FcUserModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.layout.LayoutDataProvider;
import com.adventnet.sym.adsm.common.server.layout.component.FcAdditionalCustomAttribute;
import com.adventnet.sym.adsm.common.server.layout.component.FcConfigMemberOfWithPG;
import com.adventnet.sym.adsm.common.server.layout.component.FcLyncPolicySelection;
import com.adventnet.sym.adsm.common.server.layout.component.FcNamingFormat;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.layout.component.FcPassword;
import com.adventnet.sym.adsm.common.server.layout.component.FcPhotoFileUpload;
import com.adventnet.sym.adsm.common.server.layout.dataprovider.IDataProvider;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleConfigurations;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.ScheduledRequest;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.FcFormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcExecuteFormFlow
implements FcLayoutRhsConstants {
    private static Logger logg = Logger.getLogger("FcLogger");
    private static Logger mgmtLog = Logger.getLogger("ADMangLogger");
    private static String[] productLyncLdapNames = new String[]{"lyncMobilityPolicy", "lyncLocationPolicy", "lyncExternalAccessPolicy", "lyncArchivingPolicy", "lyncClientVersionPolicy", "lyncRegistrarPoolName", "lyncVoicePolicy", "lyncConferencePolicy", "lyncSipAddress", "lyncDialPlanPolicy", "IsPINSet", "lyncLineUri", "lyncPinPolicy", "lyncLineServerUri", "lyncClientPolicy"};
    private static String[] nativeLyncAttributeNames = new String[]{"MobilityPolicy", "LocationPolicy", "ExternalAccessPolicy", "ArchivingPolicy", "ClientVersionPolicy", "RegistrarPool", "VoicePolicy", "ConferencingPolicy", "SipAddress", "DialPlan", "IsPINSet", "LineURI", "PinPolicy", "LineServerURI", "ClientPolicy"};
    private static String[] tsAttributes = new String[]{"tsProfilePath", "tsHomeDir", "tsHomeDirDrive", "tsServerRemoteHomeDir", "tsAllowLogon", "tsInheritInitialProgram", "tsIntialProgram", "tsWorkingDir", "tsDeviceClientDrives", "tsDeviceClientPrinters", "tsDeviceClientDefaultPrinter", "tsTimeOutSettingsDisConnections", "tsTimeOutSettingsConnections", "tsTimeOutSettingsIdle", "tsBrokenTimeOutSettings", "tsReConnectSettings", "tsShadowSettings"};

    public static void initDataContainerData(HttpServletRequest request, FcLayout fcExecuteFormLayout) {
        FcFormDataContainer fromClientData = new FcFormDataContainer();
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        FcFormDataContainer userData = new FcFormDataContainer();
        fcExecuteFormBean.setUserData(userData);
        FcFormDataContainer templateData = new FcFormDataContainer();
        FcLayout templateDataLayout = fcExecuteFormLayout.clone();
        templateData.init(templateDataLayout);
        fcExecuteFormBean.setTemplateData(templateData);
        FcFormDataContainer adData = new FcFormDataContainer();
        fcExecuteFormBean.setADData(adData);
        FcFormDataContainer toClientData = new FcFormDataContainer();
        FcLayout toClientExecuteFormLayout = fcExecuteFormLayout.clone();
        toClientData.init(toClientExecuteFormLayout);
        fcExecuteFormBean.setToClientData(toClientData);
    }

    public static Long getDefaultLayoutId(Long loginId, Long templateCategoryId, String domainName, boolean isExecutionPage, boolean isWorkflowMode) {
        Long defaultLayoutId = FcLayoutViewHandler.getAuthorizedDefaultLayoutId((Long)loginId, (Long)templateCategoryId, (boolean)isWorkflowMode, (String)domainName);
        if (defaultLayoutId == null) {
            defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)isExecutionPage);
        } else {
            ArrayList list = null;
            list = isWorkflowMode ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)"");
            boolean isAuthorized = false;
            for (int i = 0; i < list.size(); ++i) {
                Properties prop = (Properties)list.get(i);
                Long layoutId = (Long)prop.get("LAYOUT_ID");
                if (defaultLayoutId.compareTo(layoutId) != 0) continue;
                isAuthorized = true;
                break;
            }
            if (!isAuthorized) {
                defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)isExecutionPage);
            }
        }
        return defaultLayoutId;
    }

    public static ArrayList<FcLayoutField> updateUserData(Long templateCategoryId, FcFormDataContainer fromClientData, FcFormDataContainer toClientData, FcFormDataContainer userData) {
        ArrayList<FcLayoutField> list = new ArrayList<FcLayoutField>();
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        FcExecuteFormFlow.removeDuplicateCustomAttributes(fromClientData, toClientData, userData, iMgmtHandler);
        logg.log(Level.INFO, " Update User Data started");
        Enumeration e = fromClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField userChangedField;
            FcLayoutField fromClientField = (FcLayoutField)e.nextElement();
            FcLayoutField toClientField = (FcLayoutField)toClientData.get((Object)fromClientField.getFieldId());
            if (toClientField != null && fromClientField.isUserChangedField(toClientField)) {
                userChangedField = fromClientField.clone();
                iMgmtHandler.updateFieldsAttributes(userChangedField);
                if (userChangedField.getIsCustomField().booleanValue()) {
                    if (toClientField.getIsHidden().booleanValue() || toClientField.getIsReadOnly().booleanValue()) {
                        fromClientData.remove((Object)userChangedField.getFieldId());
                        continue;
                    }
                    FcLayoutField userDataField = userData.getCustomField(userChangedField);
                    if (userDataField != null) {
                        userData.put((Object)userDataField.getFieldId(), (Object)userChangedField);
                        continue;
                    }
                    userData.put((Object)fromClientField.getFieldId(), (Object)userChangedField);
                    continue;
                }
                userChangedField.mergeUserData((FcLayoutField)userData.get((Object)userChangedField.getFieldId()));
                userData.put((Object)fromClientField.getFieldId(), (Object)userChangedField);
                continue;
            }
            if (toClientField != null) continue;
            userChangedField = fromClientField.clone();
            iMgmtHandler.updateFieldsAttributes(userChangedField);
            if (userChangedField.getIsCustomField().booleanValue()) {
                boolean customFieldAvailable = false;
                FcLayoutField userDataField = userData.getCustomField(userChangedField);
                if (userDataField != null) {
                    if (!userDataField.getIsHidden().booleanValue() && !userDataField.getIsReadOnly().booleanValue()) {
                        userData.put((Object)userDataField.getFieldId(), (Object)userChangedField);
                    } else {
                        fromClientData.remove((Object)userChangedField.getFieldId());
                    }
                    customFieldAvailable = true;
                }
                if (customFieldAvailable) continue;
                userData.put((Object)fromClientField.getFieldId(), (Object)userChangedField);
                continue;
            }
            logg.log(Level.INFO, "Looks some error. Custom fields alone should come");
        }
        e = toClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField removedField;
            FcLayoutField toClientDataField = (FcLayoutField)e.nextElement();
            FcLayoutField fromClientField = (FcLayoutField)fromClientData.get((Object)toClientDataField.getFieldId());
            if (fromClientField != null || (removedField = userData.remove(toClientDataField)) == null) continue;
            list.add(removedField);
        }
        logg.log(Level.INFO, " Update User Data finished ");
        return list;
    }

    private static void removeDuplicateCustomAttributes(FcFormDataContainer fromClientData, FcFormDataContainer toClientData, FcFormDataContainer userData, IMgmtHandler iMgmtHandler) {
        try {
            Enumeration e = fromClientData.elements();
            while (e.hasMoreElements()) {
                FcLayoutField userChangedField = (FcLayoutField)e.nextElement();
                if (!userChangedField.getIsCustomField().booleanValue()) continue;
                iMgmtHandler.updateFieldsAttributes(userChangedField);
                FcLayoutField toClientField = (FcLayoutField)toClientData.get((Object)userChangedField.getFieldId());
                if (toClientField != null) continue;
                boolean available = false;
                toClientField = toClientData.getCustomField(userChangedField);
                if (toClientField != null) {
                    FcLayoutField existingFromClientDataField;
                    if (!toClientField.getIsHidden().booleanValue() && !toClientField.getIsReadOnly().booleanValue() && (existingFromClientDataField = (FcLayoutField)fromClientData.get((Object)toClientField.getFieldId())) != null) {
                        existingFromClientDataField.fillCustomValue(userChangedField.getCustomFieldLdapName(), ((FcAdditionalCustomAttribute)userChangedField.getIComponent()).getLdapValue());
                    }
                    FcLayoutField rem = (FcLayoutField)fromClientData.remove((Object)userChangedField.getFieldId());
                    available = true;
                }
                if (available) continue;
                FcLayoutField userDataField = userData.getCustomField(userChangedField);
                if (userDataField != null && !userChangedField.getFieldId().equals(userDataField.getFieldId())) {
                    FcLayoutField rem = (FcLayoutField)fromClientData.remove((Object)userDataField.getFieldId());
                }
                ArrayList customFields = fromClientData.getCustomFields(userChangedField);
                for (int i = 1; i < customFields.size(); ++i) {
                    FcLayoutField rem = (FcLayoutField)fromClientData.remove((Object)((FcLayoutField)customFields.get(i)).getFieldId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateToBeRemovedGroupListForUserData(FcFormDataContainer userData, FcFormDataContainer adData) {
        try {
            if (userData.get((Object)2516L) != null && adData.get((Object)2516L) != null) {
                ArrayList removeGroupOptionList = ((FcConfigMemberOfWithPG)((FcLayoutField)userData.get((Object)2516L)).getIComponent()).getToBeRemovedGroupsOptionList();
                FcConfigMemberOfWithPG adMemberOf = (FcConfigMemberOfWithPG)((FcLayoutField)adData.get((Object)2516L)).getIComponent();
                ArrayList adValues = adMemberOf.getFcOptionList();
                FcConfigMemberOfWithPG userMemberOf = (FcConfigMemberOfWithPG)((FcLayoutField)userData.get((Object)2516L)).getIComponent();
                ArrayList userValues = userMemberOf.getFcOptionList();
                for (FcOption fcOption : adValues) {
                    if (adMemberOf.contains(userValues, fcOption)) continue;
                    removeGroupOptionList.add(fcOption);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getObjectPropertiesForSingleComponent(FcFormDataContainer fromClientData, ArrayList ldapNamesArray) {
        ArrayList<String> AttributesList = new ArrayList<String>();
        ArrayList<String> ldapNamesArray1 = new ArrayList<String>();
        try {
            Enumeration e = fromClientData.elements();
            while (e.hasMoreElements()) {
                FcLayoutField field = (FcLayoutField)e.nextElement();
                ArrayList fcAttributesListt = field.getFcAttributeList();
                if (fcAttributesListt == null || fcAttributesListt.size() == 0) continue;
                for (FcAttributes fcAttribute : fcAttributesListt) {
                    Object obj = fcAttribute.getAttribValue();
                    String attribValue = "";
                    if (!(obj instanceof Integer) && !(obj instanceof Long) && !(obj instanceof String) && !(obj instanceof Boolean) || !(attribValue = fcAttribute.getAttribValue().toString()).equalsIgnoreCase("")) continue;
                    AttributesList.add(fcAttribute.getAttribLdapName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String searchKey : AttributesList) {
            if (ldapNamesArray.contains(searchKey)) continue;
            ldapNamesArray1.add(searchKey);
        }
        return ldapNamesArray1;
    }

    public static void updateToClientData(FcFormDataContainer adData, FcFormDataContainer toClientData) {
        Enumeration e = adData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField adField = (FcLayoutField)e.nextElement();
            FcLayoutField toClientField = (FcLayoutField)toClientData.get((Object)adField.getFieldId());
            toClientField.applyTemplate(adField);
        }
    }

    public static void applyTemplate(FcFormDataContainer newToClientData, FcFormDataContainer userData) {
        Enumeration e = newToClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField toClientField = (FcLayoutField)e.nextElement();
            FcLayoutField userDataField = (FcLayoutField)userData.get((Object)toClientField.getFieldId());
            if (userDataField == null || toClientField.getIsHidden().booleanValue() || toClientField.getIsReadOnly().booleanValue() || !toClientField.getIsAuthorized().booleanValue()) continue;
            toClientField.applyTemplate(userDataField);
        }
    }

    public static ArrayList<Long> getNamingFormatFields(FcFormDataContainer templateData) {
        ArrayList<Long> fcNamingFormatFields = new ArrayList<Long>();
        Enumeration e = templateData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            if (fcLayoutField.getComponentId().intValue() != 9 && fcLayoutField.getComponentId().intValue() != 24 && fcLayoutField.getComponentId().intValue() != 25) continue;
            fcNamingFormatFields.add(fcLayoutField.getFieldId());
        }
        Collections.sort(fcNamingFormatFields);
        return fcNamingFormatFields;
    }

    public static String applyNamingFormat(Properties ldapVsValueProps, ArrayList<Long> namingFormatFields, FcFormDataContainer fromClientData, FcFormDataContainer userData) {
        Hashtable<Long, String> m = new Hashtable<Long, String>();
        for (Long namingFormatField : namingFormatFields) {
            FcLayoutField fcLayoutField = (FcLayoutField)fromClientData.get((Object)namingFormatField);
            Long fieldId = fcLayoutField.getFieldId();
            FcNamingFormat fcNamingFormat = (FcNamingFormat)fcLayoutField.getIComponent();
            if ((!userData.containsKey((Object)fieldId) || fcLayoutField.getIsHidden().booleanValue() || fcLayoutField.getIsReadOnly().booleanValue() || !fcLayoutField.getIsAuthorized().booleanValue()) && fcNamingFormat.getFormatId().intValue() != -1) {
                String formattedValue = FcExecuteNamingFormat.getFormattedValue(ldapVsValueProps, fcNamingFormat);
                fcNamingFormat.setFormattedValue(formattedValue);
                fcNamingFormat.setAttributesToAD(fcLayoutField, true);
                String formattedAttribValue = "";
                if (!fcNamingFormat.hasEmptyValue()) {
                    formattedAttribValue = (String)((FcAttributes)fcLayoutField.getFcAttributeList().get(0)).getAttribValue();
                }
                ldapVsValueProps.setProperty(((FcAttributes)fcLayoutField.getFcAttributeList().get(0)).getAttribLdapName(), formattedAttribValue);
                if (fcLayoutField.getFcAttributeList().size() > 1) {
                    ldapVsValueProps.setProperty(((FcAttributes)fcLayoutField.getFcAttributeList().get(1)).getAttribLdapName(), formattedValue);
                }
                m.put(fcLayoutField.getFieldId(), fcNamingFormat.getFormattedValue());
                continue;
            }
            m.put(fcLayoutField.getFieldId(), fcNamingFormat.getFormattedValue());
        }
        JSONObject jsonObject = new JSONObject(m);
        logg.log(Level.INFO, "After applying Naming Format Json string: " + jsonObject.toString());
        return jsonObject.toString();
    }

    public static ArrayList<Hashtable> applyNamingFormatAndUpdateFcAttributes(Properties ldapVsValueProps, ArrayList<Long> namingFormatFields, FcFormDataContainer fromClientData, FcFormDataContainer userData) {
        ArrayList<Hashtable> updatedFcAttributes = new ArrayList<Hashtable>();
        for (Long namingFormatField : namingFormatFields) {
            String formattedValue;
            FcLayoutField fcLayoutField = (FcLayoutField)fromClientData.get((Object)namingFormatField);
            Long fieldId = fcLayoutField.getFieldId();
            FcNamingFormat fcNamingFormat = (FcNamingFormat)fcLayoutField.getIComponent();
            String oldFormattedValue = fcNamingFormat.getFormattedValue();
            if (userData.containsKey((Object)fieldId) || fcNamingFormat.getFormatId().intValue() == -1 || oldFormattedValue.equalsIgnoreCase(formattedValue = FcExecuteNamingFormat.getFormattedValue(ldapVsValueProps, fcNamingFormat))) continue;
            String existingFormatValue = fcNamingFormat.getFormattedValue();
            fcNamingFormat.setFormattedValue(formattedValue);
            fcNamingFormat.setAttributesToAD(fcLayoutField, false);
            fcNamingFormat.setFormattedValue(existingFormatValue);
            ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
            for (FcAttributes fcAttribute : fcAttributeList) {
                ldapVsValueProps.setProperty(fcAttribute.getAttribLdapName(), fcAttribute.getAttribValue().toString());
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("attr", fcAttribute);
                hash.put("value", fcAttribute.getAttribValue());
                updatedFcAttributes.add(hash);
            }
        }
        return updatedFcAttributes;
    }

    public static ArrayList<Long> getFormatParticipatingFields(Long templateCategoryId, FcFormDataContainer toClientData, ArrayList<Long> namingFormatFields) {
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        iMgmtHandler.updateFieldsAttributes(toClientData);
        ArrayList<Long> formatParticipatingFields = new ArrayList<Long>();
        for (Long namingFormatField : namingFormatFields) {
            FcLayoutField fcLayoutField = (FcLayoutField)toClientData.get((Object)namingFormatField);
            FcNamingFormat fcNamingFormat = (FcNamingFormat)fcLayoutField.getIComponent();
            Long formatId = fcNamingFormat.getFormatId();
            String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
            ArrayList<Object> formatList = new ArrayList<String>();
            if (formatType.equalsIgnoreCase("ADVANCED")) {
                formatList = FcExecuteNamingFormat.getAllFormatsForId(formatId);
            } else {
                formatList.add(fcNamingFormat.getFormatValue());
            }
            for (String string : formatList) {
                logg.log(Level.INFO, "Format Value " + string + " for finding the Participating naming format fields");
                int prevIndex = 0;
                int index = string.indexOf("%");
                int length = string.length();
                StringBuffer value = new StringBuffer();
                while (index != -1) {
                    int nextIndex = string.indexOf("%", index + 1);
                    String prevStr = string.substring(prevIndex, index);
                    if (!(prevStr = prevStr.replaceAll("\"", "")).equals("[L]") && !prevStr.equals("[U]")) {
                        value.append(prevStr);
                    }
                    if (nextIndex != -1) {
                        String ldapName = string.substring(index + 1, nextIndex);
                        Long matchingFieldId = FcFormatClientUtil.getMathcingField(ldapName, toClientData);
                        if (matchingFieldId != null && !formatParticipatingFields.contains(matchingFieldId)) {
                            formatParticipatingFields.add(matchingFieldId);
                            logg.log(Level.INFO, "Matching Field Id " + matchingFieldId);
                        }
                        logg.log(Level.INFO, "Participated ldap name " + ldapName);
                        prevIndex = nextIndex + 1;
                        index = string.indexOf("%", nextIndex + 1);
                        continue;
                    }
                    prevIndex = index;
                    index = nextIndex;
                }
            }
            if (!formatType.equalsIgnoreCase("ADVANCED")) continue;
            ArrayList<String> involvedLDAPValues = FcExecuteNamingFormat.getInvolvedLDAPAttributes(formatId);
            for (String ldapName : involvedLDAPValues) {
                Long matchingFieldId = FcFormatClientUtil.getMathcingField(ldapName, toClientData);
                if (matchingFieldId == null || formatParticipatingFields.contains(matchingFieldId)) continue;
                formatParticipatingFields.add(matchingFieldId);
            }
        }
        return formatParticipatingFields;
    }

    public static void setDomainSpecificFieldValues(FcFormDataContainer fcFormDataContainer, String domainName, AdventNetResourceBundle rb, Long loginId, Long templateCategoryId) {
        FcExecuteFormFlow.setDomainSpecificFieldValues(FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb), fcFormDataContainer, domainName, rb, loginId, templateCategoryId);
    }

    public static void setDomainSpecificFieldValues(Hashtable dpValues, FcFormDataContainer fcFormDataContainer, String domainName, AdventNetResourceBundle rb, Long loginId, Long templateCategoryId) {
        try {
            if (dpValues == null) {
                dpValues = FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb);
            }
            if (dpValues != null && dpValues.isEmpty()) {
                dpValues.putAll(FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb));
            }
            dpValues.put("templateCategoryId", templateCategoryId);
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcField = (FcLayoutField)e.nextElement();
                if (!fcField.getIsDomainSpecificField().booleanValue()) continue;
                String providerClassName = fcField.getDomainSpecificDataProviderClassName();
                Class<?> domainSpecificDataProviderClass = Class.forName(providerClassName);
                IDataProvider iDataProvider = (IDataProvider)domainSpecificDataProviderClass.newInstance();
                Long componentId = fcField.getComponentId();
                iDataProvider.setDefaultValue(dpValues, fcField.getIComponent(), componentId.intValue(), domainName, rb, loginId);
            }
        }
        catch (Exception e) {
            logg.log(Level.INFO, "Error occurred while setting Domain Specific Values");
            e.printStackTrace();
        }
    }

    public static void addCustomField(Long templateCategoryId, Integer attributeId, Long customAttribId, String displayName, String greyText, Long componentId, ArrayList<Long> supportedComponents, String dataType) throws Exception {
        Long maxCustomFieldId = FcLayoutViewHandler.getMaxCustomFieldId();
        if (maxCustomFieldId == null) {
            maxCustomFieldId = FcExecuteActionConstants.minCustomFieldId - 1L;
        }
        Long newCustomFieldId = maxCustomFieldId + 1L;
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Long fieldGroupId = FcLayoutUtil.getLHScustomFieldGroupId((Long)templateCategoryId);
        FcLayoutUpdateHandler.saveCustomFieldInProductData((Long)newCustomFieldId, (Long)componentId, (String)displayName, (Long)fieldGroupId, (String)dataType, (DataObject)dataObj);
        FcLayoutUpdateHandler.addCustomToAttributeMapping((Long)templateCategoryId, (Integer)attributeId, (Long)customAttribId, (Long)newCustomFieldId, (DataObject)dataObj);
        FcLayoutUpdateHandler.mapFieldToAttribute((Long)newCustomFieldId, (Integer)attributeId, (DataObject)dataObj);
        FcLayoutUpdateHandler.mapFieldToTemplateCategoryId((Long)newCustomFieldId, (Long)templateCategoryId, (DataObject)dataObj);
        FcLayoutUpdateHandler.mapFieldToComponents((Long)newCustomFieldId, supportedComponents, (DataObject)dataObj);
        FcLayoutUpdateHandler.mapFieldToDialogMenus((Long)newCustomFieldId, supportedComponents, (DataObject)dataObj);
        FcLayoutUpdateHandler.addCustomFieldInDefaultLayout((Long)templateCategoryId, (Long)newCustomFieldId, (Long)componentId, (String)displayName, (String)greyText, (String)dataType, (DataObject)dataObj);
        FcLayoutUpdateHandler.addCustomFieldToModificationRules((Long)templateCategoryId, (Long)newCustomFieldId, (DataObject)dataObj, (String)dataType);
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        FcDefaultLayout.getInstance().reLoad(templateCategoryId);
        MgmtRuleConfigurations.getInstance().reLoad();
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        iMgmtHandler.initDataObjForFieldsToAttributes();
    }

    public static void updateCustomFieldName(Long templateCategoryId, Long customAttributeId, String displayName) throws Exception {
        HashMap map = FcLayoutViewHandler.getDetailsInCustomToAttribMapping((Long)templateCategoryId, (Long)customAttributeId, null, null);
        Long fieldId = (Long)map.get("FIELD_ID");
        FcLayoutUpdateHandler.updateFieldNameInProductData((Long)fieldId, (String)displayName);
        FcLayoutUpdateHandler.updateFieldNameInConfiguredData((Long)fieldId, (String)displayName);
        FcDefaultLayout.getInstance().reLoad(templateCategoryId);
        MgmtRuleConfigurations.getInstance().reLoad();
    }

    public static void deleteCustomField(Long templateCategoryId, Long fieldId) throws Exception {
        FcLayoutUpdateHandler.deleteCustomFieldInProductData((Long)fieldId);
        FcLayoutUpdateHandler.deleteCustomFieldInAllLayout((Long)fieldId);
        FcDefaultLayout.getInstance().reLoad(templateCategoryId);
        MgmtRuleConfigurations.getInstance().reLoad();
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        iMgmtHandler.initDataObjForFieldsToAttributes();
    }

    public static IMgmtHandler getMgmtHandlerInstance(Long templateCategoryId) {
        IMgmtHandler iMgmtHandler = null;
        try {
            Properties prop = FcLayoutViewHandler.getTemplateCategoryDetails((Long)templateCategoryId);
            String className = (String)prop.get("MGMT_HANDLER_CLASS_NAME");
            Class<?> mgmtHandlerClass = Class.forName(className);
            Method fn = mgmtHandlerClass.getMethod("getInstance", new Class[0]);
            iMgmtHandler = (IMgmtHandler)fn.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iMgmtHandler;
    }

    public static LayoutDataProvider getLayoutDataProviderInstance(boolean isWorkflow) {
        LayoutDataProvider layoutDataProvider = null;
        try {
            String className = "com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtDataProvider";
            if (isWorkflow) {
                className = "com.adventnet.sym.adsm.common.webclient.workflow.FcWorkflowDataProvider";
            }
            Class<?> handlerClass = Class.forName(className);
            layoutDataProvider = (LayoutDataProvider)handlerClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layoutDataProvider;
    }

    public static void getADValues(FcLayoutTab fcRhsLayoutTab, Long loginId, FcExecuteFormBean fcExecuteFormBean) {
        FcExecuteFormFlow.getADValues(fcRhsLayoutTab, loginId, fcExecuteFormBean, null);
    }

    public static void getADValues(FcLayoutTab fcRhsLayoutTab, Long loginId, FcExecuteFormBean fcExecuteFormBean, HttpServletRequest request) {
        FcLayoutField fcLayoutField;
        FcConfigMemberOfWithPG fcConfigMemberPG;
        FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
        fcFormDataContainer.init(fcRhsLayoutTab);
        IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
        iMgmtListener.getADValues(fcExecuteFormBean.getTemplateCategoryId(), fcFormDataContainer, fcExecuteFormBean.getADData(), loginId);
        iMgmtListener.restrictFieldsFromEditing(fcFormDataContainer);
        FcExecuteFormFlow.applyTemplate(fcFormDataContainer, fcExecuteFormBean.getUserData());
        boolean isCopyObjectApplied = false;
        boolean isAppendGroup = false;
        if (request.getParameter("isCopyObjectApplied") != null) {
            isCopyObjectApplied = Boolean.parseBoolean(request.getParameter("isCopyObjectApplied"));
        }
        if (request.getParameter("isAppendGroup") != null) {
            isAppendGroup = Boolean.parseBoolean(request.getParameter("isAppendGroup"));
        }
        FcFormDataContainer adData = fcExecuteFormBean.getADData();
        if (fcFormDataContainer.get((Object)2516L) != null && adData.get((Object)2516L) != null && isCopyObjectApplied && isAppendGroup && !(fcConfigMemberPG = (FcConfigMemberOfWithPG)(fcLayoutField = (FcLayoutField)fcFormDataContainer.get((Object)2516L)).getIComponent()).isRemoveExistingGroup()) {
            fcConfigMemberPG.mergeADValuesAppendGroup((FcLayoutField)adData.get((Object)2516L));
        }
        FcFormDataContainer toClientData = fcExecuteFormBean.getToClientData();
        FcExecuteFormFlow.updateToClientData(fcFormDataContainer, fcExecuteFormBean.getToClientData());
    }

    public static Long getActionIdForAdditionalCustomField(Long templateCategoryId) {
        String columnName = "";
        boolean isModifyObjectCategory = FcLayoutUtil.isModifyObjectCategory((Long)templateCategoryId);
        columnName = isModifyObjectCategory ? "MODIFY_ID" : "ACTION_ID";
        return FcLayoutViewHandler.getActionIdForAdditionalCustomField((Long)templateCategoryId, (String)columnName);
    }

    public static void addRuleFieldsLdapNames(FcExecuteFormBean fcExecuteFormBean, ArrayList ldapNamesArray) {
        ArrayList ruleConditionFieldsArray = FcLayoutViewHandler.getLDAPNames(fcExecuteFormBean.getMgmtRuleConditionFields());
        ArrayList ruleResultFieldsArray = FcLayoutViewHandler.getLDAPNames(fcExecuteFormBean.getMgmtRuleResultFields());
        ldapNamesArray.addAll(ruleConditionFieldsArray);
        ldapNamesArray.addAll(ruleResultFieldsArray);
    }

    public static void addNamingFormatFieldsLdapNames(FcFormDataContainer fcFormDataContainer, ArrayList ldapNamesArray) {
        ArrayList namingFormatFieldsLdapNamesArray = FcFormatClientUtil.getNamingFormatLdapNames(fcFormDataContainer);
        ldapNamesArray.addAll(namingFormatFieldsLdapNamesArray);
    }

    public static void addTemplateMandatoryLdapNames(FcFormDataContainer fcFormDataContainer, ArrayList ldapNameList) {
        ArrayList mandatoryFieldIds = FcLayoutViewHandler.getMandatoryFieldIds((FcFormDataContainer)fcFormDataContainer);
        ArrayList mandatoryFieldLdapNames = FcLayoutViewHandler.getLDAPNames((ArrayList)mandatoryFieldIds);
        ldapNameList.addAll(mandatoryFieldLdapNames);
    }

    public static void addFirstDisplyTabLdapNames(FcLayout fcLayout, ArrayList ldapNamesArray, boolean isExecuteFormPage, Long templateCategoryId) {
        Long displayTabId = FcExecuteFormFlow.getFirstDisplayTabId(fcLayout, isExecuteFormPage);
        FcLayoutTab fcRhsLayoutTab = fcLayout.getTabObject(displayTabId);
        FcFormDataContainer tabFieldsDataContainer = new FcFormDataContainer();
        tabFieldsDataContainer.init(fcRhsLayoutTab);
        ldapNamesArray.addAll(FcExecuteFormFlow.getLDAPNames(templateCategoryId, tabFieldsDataContainer));
    }

    public static Long getFirstDisplayTabId(FcLayout fcLayout, boolean isExecuteFormPage) {
        if (!isExecuteFormPage) {
            return ((FcLayoutTab)fcLayout.getFcLayoutTabList().get(0)).getTabId();
        }
        for (FcLayoutTab fcLayoutTab : fcLayout.getFcLayoutTabList()) {
            if (fcLayoutTab.getIsHidden().booleanValue()) continue;
            return fcLayoutTab.getTabId();
        }
        return 1L;
    }

    private static void checkIfPhotoDirectoryExists() {
        try {
            String ADPhotosDir = System.getProperty("server.home") + "\\webapps\\adsm\\temp\\userPhotos\\layoutCachedPhotos\\ADPhotos\\";
            ArrayList<String> photoAttribs = new ArrayList<String>();
            photoAttribs.add("thumbnailPhoto");
            photoAttribs.add("thumbnailLogo");
            photoAttribs.add("photo");
            photoAttribs.add("jpegPhoto");
            photoAttribs.add("exchangePhoto");
            for (String s : photoAttribs) {
                File photoDirectory = new File(ADPhotosDir + s);
                if (photoDirectory.exists()) continue;
                photoDirectory.mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Properties getObjectProperties(String guid, String domainName, Long loginId, ArrayList ldapNamesArray) throws Exception {
        ArrayList members;
        String distinguishedName;
        mgmtLog.log(Level.INFO, "Getting Object Properties for Guid: " + guid);
        String guidStr = "";
        String bindString = "";
        boolean hasTerminalAttributes = false;
        boolean isADDomain = FcLayoutUtil.getIsADDomain((String)domainName);
        if (isADDomain) {
            guidStr = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            bindString = "<GUID=" + guidStr + ">";
            hasTerminalAttributes = false;
            ArrayList<String> TsAttributesList = new ArrayList<String>(Arrays.asList(tsAttributes));
            for (String searchKey : TsAttributesList) {
                if (!ldapNamesArray.contains(searchKey)) continue;
                hasTerminalAttributes = true;
                ldapNamesArray.remove(searchKey);
            }
            if (ldapNamesArray.contains("userPhoto")) {
                ldapNamesArray.addAll(Arrays.asList(UserPhotoMgmtUtil.photoAttribLdapNames));
                FcExecuteFormFlow.checkIfPhotoDirectoryExists();
            }
        } else {
            guidStr = guid;
        }
        Properties valuesProp = null;
        if (hasTerminalAttributes) {
            valuesProp = ADHandler.getObjectPropertiesWithMemberOfDN((String)domainName, (Long)loginId, (String)bindString, (ArrayList)ldapNamesArray, (boolean)true);
            ArrayList<String> tslist = new ArrayList<String>();
            tslist.add("TerminalService");
            Properties tsDetails = ADHandler.getUserTerminalObjects((String)domainName, (Long)loginId, (String)guidStr, tslist);
            if (tsDetails != null) {
                valuesProp.putAll((Map<?, ?>)((Properties)tsDetails.get("TerminalService")));
            }
        } else if (!isADDomain) {
            valuesProp = O365MgmtHandler.getO365ObjectProperties((String)domainName, (String)guidStr, (ArrayList)ldapNamesArray);
        } else {
            ArrayList<String> temp;
            String value;
            String managerDomainName;
            valuesProp = ADHandler.getObjectPropertiesWithMemberOfDN((String)domainName, (Long)loginId, (String)bindString, (ArrayList)ldapNamesArray, (boolean)true);
            ArrayList distinguishedNameValueList = (ArrayList)valuesProp.get("distinguishedName");
            distinguishedName = null;
            if (distinguishedNameValueList != null) {
                distinguishedName = (String)distinguishedNameValueList.get(0);
            }
            ArrayList managerList = (ArrayList)valuesProp.get("managedBy");
            String manager = null;
            String managerSid = null;
            if (managerList != null && (managerSid = UserMgmtUtil.getSIDFromDN((String)domainName, (String)(manager = (String)managerList.get(0)))) == null) {
                managerSid = UserMgmtUtil.getSIDFromDNGeneral((String)manager);
            }
            if (managerSid == null && manager != null && manager.isEmpty() && (managerDomainName = DomainUtil.getDomainNamefromDN((String)manager)) != null && !managerDomainName.isEmpty()) {
                ArrayList<String> attrList = new ArrayList<String>();
                attrList.add("objectSid");
                Properties domainProps = ADHandler.getDomainDetails((String)managerDomainName, (Long)1L);
                String searchString = "(distinguishedName=" + manager + ")";
                ArrayList managerPropList = ADHandler.getObjectsWithOutListener((Properties)domainProps, (String)((String)domainProps.get("DEFAULT_NAMING_CONTEXT")), attrList, (String)searchString);
                if (managerPropList != null && managerPropList.size() > 0) {
                    Properties prop = (Properties)managerPropList.get(0);
                    managerSid = StrUtil.getString((Properties)prop, (String)"objectSid");
                }
            }
            if (ldapNamesArray.contains("preventDeletion") && distinguishedName != null) {
                value = String.valueOf(ADHandler.getACEsFromDN((String)domainName, (Long)loginId, (String)distinguishedName, (String)"preventDeletion", (String)""));
                temp = new ArrayList<String>();
                temp.add(value);
                valuesProp.put("preventDeletion", temp);
            }
            if (ldapNamesArray.contains("managerCanUpdateMembers") && distinguishedName != null && manager != null) {
                value = "FALSE";
                if (managerSid != null) {
                    value = String.valueOf(ADHandler.getACEsFromDN((String)domainName, (Long)loginId, (String)distinguishedName, (String)"managerCanUpdateMembers", (String)managerSid));
                }
                temp = new ArrayList();
                temp.add(value);
                valuesProp.put("managerCanUpdateMembers", temp);
            }
        }
        ArrayList distinguishedNameList = (ArrayList)valuesProp.get("distinguishedName");
        if (distinguishedNameList != null && (distinguishedName = (String)distinguishedNameList.get(0)) != null) {
            String mailBoxServer = "";
            if (ldapNamesArray.contains("fullPermission")) {
                ArrayList fullPermList;
                ArrayList mailBoxServerValueList = (ArrayList)valuesProp.get("msExchHomeServerName");
                if (mailBoxServerValueList != null) {
                    mailBoxServer = (String)mailBoxServerValueList.get(0);
                }
                if ((fullPermList = FcExecuteFormFlow.getFullPermissionDetails(domainName, loginId, distinguishedName, mailBoxServer)) != null) {
                    valuesProp.put("fullPermission", fullPermList);
                }
            }
            if (ldapNamesArray.contains("sendAs")) {
                ArrayList<Object> sendAsSIDList = new ArrayList();
                sendAsSIDList = FcExecuteFormFlow.getSendAsList(domainName, loginId, distinguishedName);
                if (sendAsSIDList != null) {
                    valuesProp.put("sendAs", sendAsSIDList);
                }
            }
        }
        if ((members = (ArrayList)valuesProp.get("member")) != null && !members.isEmpty()) {
            Collections.sort(members);
        }
        mgmtLog.log(Level.INFO, " Value List of the object " + guid + " : " + valuesProp);
        return valuesProp;
    }

    public static ArrayList getFullPermissionDetails(String domainName, Long loginId, String distinguishedName, String mailBoxServer) throws Exception {
        ArrayList dbValuesList = new ArrayList();
        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailBoxServer);
        String result = ADHandler.getMailBoxFullPermissionList((String)domainName, (long)loginId, (Properties)exchangeServerDetails, (String)distinguishedName);
        if (!result.equals("")) {
            JSONArray domainDetailsArray = new JSONArray(result);
            String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
            ArrayList fullPermissionList = FcLayoutUtil.getFullPermissionDetails((String[])tableArray, (JSONArray)domainDetailsArray, (String)domainName, dbValuesList);
        }
        return dbValuesList;
    }

    public static ArrayList<String> getSendAsList(String domainName, Long loginId, String distinguishedName) {
        ArrayList<String> resultSIDList = new ArrayList<String>();
        try {
            ArrayList aceList;
            Properties aclProp = ADHandler.getACLsFromDNWithoutLookup((String)domainName, (Long)loginId, (String)distinguishedName);
            if (aclProp != null && (aceList = (ArrayList)aclProp.get("acls")) != null && !aceList.isEmpty()) {
                for (int index = 0; index < aceList.size(); ++index) {
                    String trusteeSid;
                    Properties aceProps = (Properties)aceList.get(index);
                    String objectTypeGUID = (String)aceProps.get("objectTypeGUID");
                    if (!"{AB721A54-1E2F-11D0-9819-00AA0040529B}".equalsIgnoreCase(objectTypeGUID) || "S-1-5-10".equalsIgnoreCase(trusteeSid = (String)aceProps.get("sid"))) continue;
                    resultSIDList.add(trusteeSid);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultSIDList;
    }

    public static Properties getLyncProperties(String distinguishedName, String rtcHomeServer, String dcFqdn, ArrayList nativeAttribs, String domainName, Long loginId) throws Exception {
        Properties lyncProps = new Properties();
        Properties lcsServerDetails = LCSServerHandler.getLCSLyncServerProperties((String)rtcHomeServer);
        if (lcsServerDetails != null && lcsServerDetails.get("DNS_HOST_NAME") != null) {
            String dnsName = (String)lcsServerDetails.get("DNS_HOST_NAME");
            Properties nativeProps = ADHandler.getLyncProperties((String)distinguishedName, (ArrayList)nativeAttribs, (String)domainName, (Long)loginId, (String)dnsName, (String)dcFqdn);
            if (!nativeProps.isEmpty()) {
                for (int i = 0; i < productLyncLdapNames.length; ++i) {
                    String productLdapName = productLyncLdapNames[i];
                    String nativeAttribName = nativeLyncAttributeNames[i];
                    if (nativeProps.get(nativeAttribName) == null) continue;
                    lyncProps.put(productLdapName, (ArrayList)nativeProps.get(nativeAttribName));
                }
                if (nativeProps.get("EnterpriseVoiceEnabled") != null && nativeProps.get("RemoteCallControlTelephonyEnabled") != null && nativeProps.get("AudioVideoDisabled") != null) {
                    boolean isAudioVideoDisabled;
                    ArrayList<String> valueList = new ArrayList<String>();
                    ArrayList list1 = (ArrayList)nativeProps.get("EnterpriseVoiceEnabled");
                    boolean isEnterpriseVoiceEnabled = ((String)list1.get(0)).equalsIgnoreCase("true");
                    list1 = (ArrayList)nativeProps.get("RemoteCallControlTelephonyEnabled");
                    boolean isRemoreCallControlTelephonyEnabled = ((String)list1.get(0)).equalsIgnoreCase("true");
                    list1 = (ArrayList)nativeProps.get("AudioVideoDisabled");
                    boolean bl = isAudioVideoDisabled = ((String)list1.get(0)).equalsIgnoreCase("true");
                    if (!isEnterpriseVoiceEnabled && !isRemoreCallControlTelephonyEnabled && isAudioVideoDisabled) {
                        valueList.add("AudioVideoDisabled");
                    } else if (!(isEnterpriseVoiceEnabled || isRemoreCallControlTelephonyEnabled || isAudioVideoDisabled)) {
                        valueList.add("PcToPcOnly");
                    } else if (isEnterpriseVoiceEnabled && !isRemoreCallControlTelephonyEnabled && !isAudioVideoDisabled) {
                        valueList.add("EnterpriseVoiceEnabled");
                    } else if (!isEnterpriseVoiceEnabled && isRemoreCallControlTelephonyEnabled && !isAudioVideoDisabled) {
                        valueList.add("RemoteCallControlTelephonyEnabled");
                    } else if (!isEnterpriseVoiceEnabled && isRemoreCallControlTelephonyEnabled && isAudioVideoDisabled) {
                        valueList.add("RemoteCallControlOnly");
                    }
                    lyncProps.put("lyncTelephonyType", valueList);
                }
            } else {
                logg.log(Level.INFO, "cannot connect to lync server-" + dnsName + " while getting lync properties");
            }
        }
        return lyncProps;
    }

    public static ArrayList getLDAPNames(Long templateCategoryId, FcFormDataContainer fcFormDataContainer) {
        ArrayList<String> ldapNamesArray = new ArrayList<String>();
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        iMgmtHandler.updateFieldsAttributes(fcFormDataContainer);
        Enumeration e = fcFormDataContainer.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            if (fcLayoutField.getComponentId().intValue() == 16) {
                FcAdditionalCustomAttribute additionalCustomAttr = (FcAdditionalCustomAttribute)fcLayoutField.getIComponent();
                ldapNamesArray.add(additionalCustomAttr.getLdapName());
                continue;
            }
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            for (FcAttributes fcAttributes : fcAttributesList) {
                ldapNamesArray.add(fcAttributes.getAttribLdapName());
            }
        }
        return ldapNamesArray;
    }

    public static void setTemplateData(FcExecuteFormBean fcExecuteFormBean) {
        FcFormDataContainer templateDataContainer = new FcFormDataContainer();
        FcLayout fcLayout = fcExecuteFormBean.getExecuteFormLayout().clone();
        templateDataContainer.init(fcLayout);
        fcExecuteFormBean.setTemplateData(templateDataContainer);
    }

    public static JSONArray getOptionSubTabIds(Locale locale, Long templateCategoryId) {
        JSONArray idsJsonArray = new JSONArray();
        try {
            ArrayList tabList = FcDefaultLayout.getInstance().getFcLhsTabList(templateCategoryId, locale);
            for (FcTab fcTab : tabList) {
                ArrayList fcSubTabGroupList = fcTab.fcSubTabGroupList;
                for (FcSubTabGroup fcSubTabGroup : fcSubTabGroupList) {
                    if (!fcSubTabGroup.isOptionTab.booleanValue()) continue;
                    ArrayList fcSubTabList = fcSubTabGroup.fcSubTabList;
                    for (FcSubTab fcSubTab : fcSubTabList) {
                        idsJsonArray.put((Object)fcSubTab.subTabId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idsJsonArray;
    }

    public static JSONArray getOptionSubTabIdsWithType(Locale locale, Long templateCategoryId) {
        JSONArray idCollectionWithTypeList = new JSONArray();
        try {
            ArrayList tabList = FcDefaultLayout.getInstance().getFcLhsTabList(templateCategoryId, locale);
            for (FcTab fcTab : tabList) {
                ArrayList fcSubTabGroupList = fcTab.fcSubTabGroupList;
                for (FcSubTabGroup fcSubTabGroup : fcSubTabGroupList) {
                    if (!fcSubTabGroup.isOptionTab.booleanValue()) continue;
                    ArrayList fcSubTabList = fcSubTabGroup.fcSubTabList;
                    JSONArray idsJsonArray = new JSONArray();
                    for (FcSubTab fcSubTab : fcSubTabList) {
                        idsJsonArray.put((Object)fcSubTab.subTabId);
                    }
                    JSONObject idCollectionWithType = new JSONObject();
                    idCollectionWithType.put("optionTabType", (Object)fcSubTabGroup.optionTabType);
                    idCollectionWithType.put("idList", (Object)idsJsonArray);
                    idCollectionWithTypeList.put((Object)idCollectionWithType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idCollectionWithTypeList;
    }

    public static JSONArray getModifiedFieldsList(Long templateCategoryId, FcFormDataContainer fromClientData, FcFormDataContainer adData, AdventNetResourceBundle rb, boolean isSummaryPage, FcExecuteFormBean fcExecuteFormBean, Long loginId) {
        return FcExecuteFormFlow.getModifiedFieldsList(templateCategoryId, fromClientData, adData, rb, isSummaryPage, fcExecuteFormBean, loginId, true, false);
    }

    public static JSONArray getModifiedFieldsList(Long templateCategoryId, FcFormDataContainer fromClientData, FcFormDataContainer adData, AdventNetResourceBundle rb, boolean isSummaryPage, FcExecuteFormBean fcExecuteFormBean, Long loginId, boolean isOverwrtiteAdData, boolean isCopyObjectApplied) {
        JSONArray resultFieldsJsonArray = new JSONArray();
        FcFormDataContainer toBeFilledFieldsContainer = new FcFormDataContainer();
        try {
            Enumeration e = fromClientData.elements();
            if (isSummaryPage) {
                FcLayoutField fcLayoutField;
                FcConfigMemberOfWithPG fcConfigMemberPG;
                while (e.hasMoreElements()) {
                    FcConfigMemberOfWithPG fcConfigMemberPG2;
                    FcLayoutField fromClientField = (FcLayoutField)e.nextElement();
                    Long fieldId = fromClientField.getFieldId();
                    FcLayoutField adField = (FcLayoutField)adData.get((Object)fieldId);
                    if (fromClientField.getComponentId() == 62L && adField != null && (fcConfigMemberPG2 = (FcConfigMemberOfWithPG)adField.getIComponent()) != null && fcConfigMemberPG2.getFcOptionList().size() == 1) {
                        toBeFilledFieldsContainer.put((Object)fieldId, (Object)fromClientField);
                    }
                    if (fromClientField.getIComponent().hasEmptyValue(true) || adField != null) continue;
                    toBeFilledFieldsContainer.put((Object)fieldId, (Object)fromClientField);
                }
                if (toBeFilledFieldsContainer.size() > 0) {
                    ArrayList ldapNamesArray = FcExecuteFormFlow.getLDAPNames(templateCategoryId, toBeFilledFieldsContainer);
                    Properties fieldsvaluesList = new Properties();
                    fcExecuteFormBean.getIMgmtListener().removeLyncAttributes(ldapNamesArray);
                    if (!ldapNamesArray.isEmpty()) {
                        fieldsvaluesList = FcExecuteFormFlow.getObjectProperties(fcExecuteFormBean.getIMgmtListener().getGuid(), fcExecuteFormBean.getDomainName(), loginId, ldapNamesArray);
                    }
                    fcExecuteFormBean.getIMgmtListener().fillMandatoryFields(fieldsvaluesList);
                    Properties lyncAttribValuesList = fcExecuteFormBean.getIMgmtListener().getLyncAttributeValues();
                    if (lyncAttribValuesList != null) {
                        fieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
                    }
                    fcExecuteFormBean.getIMgmtListener().fillADValues(toBeFilledFieldsContainer, adData, fieldsvaluesList, loginId, true);
                }
                if (toBeFilledFieldsContainer.get((Object)2516L) != null && adData.get((Object)2516L) != null && isCopyObjectApplied && !isOverwrtiteAdData && !(fcConfigMemberPG = (FcConfigMemberOfWithPG)(fcLayoutField = (FcLayoutField)toBeFilledFieldsContainer.get((Object)2516L)).getIComponent()).isRemoveExistingGroup()) {
                    fcConfigMemberPG.removeValues((FcLayoutField)adData.get((Object)2516L));
                }
            }
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(adData);
            e = fromClientData.elements();
            while (e.hasMoreElements()) {
                Long lyncServerVersion;
                FcLayoutField fromClientField = (FcLayoutField)e.nextElement();
                if (fromClientField.getComponentId() == 56L && isSummaryPage && ((FcLyncPolicySelection)fromClientField.getIComponent()).getPolicyType().equalsIgnoreCase("mobility_policy") && (lyncServerVersion = fcExecuteFormBean.getIMgmtListener().getLyncServerVersion()).compareTo(327680L) <= 0) continue;
                Long fieldId = fromClientField.getFieldId();
                FcLayoutField adField = (FcLayoutField)adData.get((Object)fieldId);
                boolean canIncludeField = false;
                if (!isSummaryPage || isSummaryPage && !fromClientField.getIsHidden().booleanValue()) {
                    canIncludeField = true;
                }
                if (!canIncludeField || (fromClientField.getIComponent().hasEmptyValue(true) || adField != null) && (adField == null || !fromClientField.isUserChangedField(adField, true))) continue;
                String existingValue = " - ";
                if (adField != null) {
                    existingValue = adField.getIComponent().getRuleFieldListDisplayValue(rb, false);
                }
                JSONObject fieldJsonObj = new JSONObject();
                fieldJsonObj.put("fieldObject", (Object)fromClientField.serializeToJsonObject());
                if (fromClientField.getComponentId() == 159L) {
                    FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(fromClientData);
                    FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(fromClientData);
                    Properties ldapVsValueProps = FcGroupMgmtHandler.getInstance().getLdapVsValues(fromClientData, null);
                    String newValue = FcExecuteNamingFormat.getFormatValue(((FcPhotoFileUpload)fromClientField.getIComponent()).getPhotoFilePath(), null, ldapVsValueProps);
                    existingValue = ((FcPhotoFileUpload)adField.getIComponent()).getPhotoFilePath();
                    String photoHtml = ((FcPhotoFileUpload)fromClientField.getIComponent()).getMatchingFileAsHtml(newValue, rb);
                    String existingHtml = ((FcPhotoFileUpload)fromClientField.getIComponent()).getMatchingFileAsHtml(existingValue, rb);
                    if (photoHtml.length() == 0) {
                        photoHtml = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.photo_mgmt.status_file_not_readable"), newValue);
                    }
                    if (existingHtml.length() == 0) {
                        existingHtml = "-";
                    }
                    fieldJsonObj.put("newValue", (Object)rb.getString(photoHtml));
                    fieldJsonObj.put("existingValue", (Object)rb.getString(existingHtml));
                } else {
                    if (adField != null) {
                        existingValue = adField.getIComponent().getRuleFieldListDisplayValue(rb, false);
                    }
                    fieldJsonObj.put("newValue", (Object)fromClientField.getIComponent().getRuleFieldListDisplayValue(rb, true));
                    fieldJsonObj.put("existingValue", (Object)existingValue);
                    if (fromClientField.getFieldId().equals(2515L)) {
                        fieldJsonObj.put("pwdType", (Object)((FcPassword)fromClientField.getIComponent()).getPasswordType());
                    }
                }
                resultFieldsJsonArray.put((Object)fieldJsonObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultFieldsJsonArray;
    }

    public static void fillModifiedFields(Long templateCategoryId, FcFormDataContainer modifiedFieldsContainer, FcFormDataContainer fromClientData, FcFormDataContainer adData, AdventNetResourceBundle rb, FcExecuteFormBean fcExecuteFormBean, Long loginId) {
        FcExecuteFormFlow.fillModifiedFields(templateCategoryId, modifiedFieldsContainer, fromClientData, adData, rb, fcExecuteFormBean, loginId, null, null, null, null, true, false);
    }

    public static void fillModifiedFields(Long templateCategoryId, FcFormDataContainer modifiedFieldsContainer, FcFormDataContainer fromClientData, FcFormDataContainer adData, AdventNetResourceBundle rb, FcExecuteFormBean fcExecuteFormBean, Long loginId, String guid, String domainName, FcLayout executeFormLayout, IMgmtListener listener) {
        FcExecuteFormFlow.fillModifiedFields(templateCategoryId, modifiedFieldsContainer, fromClientData, adData, rb, fcExecuteFormBean, loginId, guid, domainName, executeFormLayout, listener, true, false);
    }

    public static void fillModifiedFields(Long templateCategoryId, FcFormDataContainer modifiedFieldsContainer, FcFormDataContainer fromClientData, FcFormDataContainer adData, AdventNetResourceBundle rb, FcExecuteFormBean fcExecuteFormBean, Long loginId, String guid, String domainName, FcLayout executeFormLayout, IMgmtListener listener, boolean isOverwrtiteAdData, boolean isCopyObjectApplied) {
        try {
            JSONArray modifiedFieldsArray = FcExecuteFormFlow.getModifiedFieldsList(templateCategoryId, fromClientData, adData, rb, false, fcExecuteFormBean, loginId, isOverwrtiteAdData, isCopyObjectApplied);
            for (int i = 0; i < modifiedFieldsArray.length(); ++i) {
                JSONObject fieldDetailsJsonObj = modifiedFieldsArray.getJSONObject(i);
                JSONObject fieldObj = fieldDetailsJsonObj.getJSONObject("fieldObject");
                FcLayoutField fcField = new FcLayoutField();
                fcField.init(fieldObj);
                modifiedFieldsContainer.put((Object)fcField.getFieldId(), (Object)fcField.clone());
            }
            if (executeFormLayout != null) {
                IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
                ArrayList ldapNamesArray = FcExecuteFormFlow.getLDAPNames(templateCategoryId, modifiedFieldsContainer);
                FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
                fcFormDataContainer.init(executeFormLayout);
                ArrayList ldapNamesArray1 = FcExecuteFormFlow.getObjectPropertiesForSingleComponent(fcFormDataContainer, ldapNamesArray);
                ldapNamesArray1.removeAll(Arrays.asList(tsAttributes));
                Properties fieldsvaluesList1 = FcExecuteFormFlow.getObjectProperties(guid, domainName, loginId, ldapNamesArray1);
                listener.setFieldValueList(fieldsvaluesList1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getPreferredDomianName(HttpServletRequest request, Long actionId) {
        ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, actionId);
        String defaultDomain = DomainUtil.getDefaultDomain();
        String domainName = null;
        if (domainNameList.contains(defaultDomain)) {
            domainName = defaultDomain;
        } else if (!domainNameList.isEmpty()) {
            domainName = domainNameList.get(0);
        }
        return domainName;
    }

    public static String getPreferredDomianNameForWF(HttpServletRequest request, Long loginId) {
        ArrayList domainNameList = WorkFlowUserHandler.getAuthorizedDomainList((Long)loginId, (Integer)5);
        String defaultDomain = DomainUtil.getDefaultDomain();
        String domainName = null;
        if (domainNameList.contains(defaultDomain)) {
            domainName = defaultDomain;
        } else if (!domainNameList.isEmpty()) {
            domainName = (String)domainNameList.get(0);
        }
        return domainName;
    }

    public static String getNamingFormatExampleValue(Long formatId, Properties ldapVsValueProps) {
        String value = "";
        try {
            String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
            if (formatType.equals("ADVANCED")) {
                Long defFormatId;
                formatId = defFormatId = AdvancedFormatUtil.getDefaultNamingFormatRule((Long)formatId);
            }
            String format = FormatUtil.getStringColumnValue((String)"ADSMFormats", (String)"FORMAT_ID", (Long)formatId, (String)"FORMAT_VALUE");
            value = FcExecuteNamingFormat.getFormatValue(format, formatId, ldapVsValueProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static Long getNewObjectCreationId() {
        return FcLayoutUpdateHandler.getNewObjectCreationId();
    }

    public static Long getNewObjectIndexId(Long objectCreationId, Long layoutId) {
        return FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, layoutId, null);
    }

    public static Long getNewObjectIndexId(Long objectCreationId, Long layoutId, String modifyObjectGuid) {
        Long objectIndexId = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row objectIndexIdRow = new Row("FcBulkObjectIndexDetails");
            objectIndexIdRow.set("OBJECT_CREATION_ID", (Object)objectCreationId);
            objectIndexIdRow.set("LAYOUT_ID", (Object)layoutId);
            if (modifyObjectGuid != null) {
                objectIndexIdRow.set("OBJECT_GUID", (Object)modifyObjectGuid);
            }
            dataObj.addRow(objectIndexIdRow);
            DataAccess.fillGeneratedValues((DataObject)dataObj);
            objectIndexId = (Long)objectIndexIdRow.get("OBJECT_INDEX_ID");
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectIndexId;
    }

    public static String getModifiedObjectGuid(Long objectIndexId) {
        String guid = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkObjectIndexDetails", criteria);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("FcBulkObjectIndexDetails");
                guid = (String)r.get("OBJECT_GUID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guid;
    }

    public static int getLdapNameIndex(Vector vector, String ldapName) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object = vector.get(i);
            if (!object.toString().equalsIgnoreCase(ldapName)) continue;
            return i;
        }
        return -1;
    }

    public static FcFormDataContainer getDefaultLayoutFormContainer(Long templateCategoryId, AdventNetResourceBundle rb, String domainName, Long loginId, Hashtable dpValues) {
        FcFormDataContainer defaultLayoutContainer = new FcFormDataContainer();
        Long defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false);
        FcExecuteFormFlow.fillFormDataContainer(defaultLayoutId, defaultLayoutContainer, templateCategoryId, rb, domainName, loginId, dpValues);
        return defaultLayoutContainer;
    }

    public static FcFormDataContainer getDefaultLayoutFormContainer(Long templateCategoryId, AdventNetResourceBundle rb, String domainName, Long loginId, Hashtable dpValues, Integer execType) {
        FcFormDataContainer defaultLayoutContainer = new FcFormDataContainer();
        Long defaultLayoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (Integer)execType);
        FcExecuteFormFlow.fillFormDataContainer(defaultLayoutId, defaultLayoutContainer, templateCategoryId, rb, domainName, loginId, dpValues);
        return defaultLayoutContainer;
    }

    private static void fillFormDataContainer(Long defaultLayoutId, FcFormDataContainer defaultLayoutContainer, Long templateCategoryId, AdventNetResourceBundle rb, String domainName, Long loginId, Hashtable dpValues) {
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
        FcLayout defaultLayout = new FcLayout(defaultLayoutId, rb, domainName);
        defaultLayoutContainer.init(defaultLayout);
        FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, defaultLayoutContainer, domainName, rb, loginId, templateCategoryId);
        iMgmtHandler.updateFieldsAttributes(defaultLayoutContainer);
    }

    public static Row cloneRow(Row row, String tableName, ArrayList notFillColumns) {
        Row newRow = new Row(tableName);
        try {
            List columnsList = row.getColumns();
            for (String columnName : columnsList) {
                if (notFillColumns.contains(columnName)) continue;
                newRow.set(columnName, row.get(columnName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newRow;
    }

    public static boolean deleteSingleObject(Long objectCreationId, Long objectIndexId, Long templateCategoryId) {
        boolean returnValue = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)objectCreationId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkObjectIndexDetails", criteria);
            dataObj.deleteRows("FcBulkObjectIndexDetails", criteria);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
            returnValue = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static void reInsertUnSucceededObjects(Long oldObjectCreationId, Long newObjectCreationId, Long templateCategoryId) {
        try {
            String tempTable;
            TableDefinition td;
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            HashMap pwdMap = null;
            if (templateCategoryId.equals(5L) && oldObjectCreationId != null && (td = MetaDataUtil.getTableDefinitionByName((String)(tempTable = "ADSMUserBUCDetails_" + String.valueOf(oldObjectCreationId)))) != null) {
                pwdMap = FcLayoutBulkViewHandler.getFromBulkUserLayoutTempTable((String)tempTable);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_CREATION_ID"), (Object)oldObjectCreationId, 0);
            Criteria criteria = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"CREATION_STATUS"), (Object)"SEVERE", 0);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"CREATION_STATUS"), null, 0));
            crit = crit.and(criteria);
            DataObject objectCreationDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkObjectIndexDetails", crit);
            Iterator it = objectCreationDetailsDO.getRows("FcBulkObjectIndexDetails");
            while (it.hasNext()) {
                Row objectIndexRow = (Row)it.next();
                Long objectIndexId = (Long)objectIndexRow.get("OBJECT_INDEX_ID");
                FcExecuteFormFlow.copySingleObject(objectIndexId, templateCategoryId, newObjectCreationId, pwdMap);
            }
            logg.log(Level.INFO, " Un Created Users are re-inserted successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean copySingleObject(Long objectIndexId, Long templateCategoryId, Long objectCreationId) {
        return FcExecuteFormFlow.copySingleObject(objectIndexId, templateCategoryId, objectCreationId, null);
    }

    public static boolean copySingleObject(Long objectIndexId, Long templateCategoryId, Long objectCreationId, HashMap pwdMap) {
        boolean returnValue = false;
        try {
            Row newRow;
            Row r;
            Criteria crit = new Criteria(Column.getColumn((String)"FcBulkObjectIndexDetails", (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkObjectIndexDetails", crit);
            Row row = dataObj.getFirstRow("FcBulkObjectIndexDetails");
            Long layoutId = (Long)row.get("LAYOUT_ID");
            if (objectCreationId == null) {
                objectCreationId = (Long)row.get("OBJECT_CREATION_ID");
            }
            String validationStatusMsg = (String)row.get("VALIDATION_STATUS_MESSAGE");
            DataObject newDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row objectIndexIdRow = new Row("FcBulkObjectIndexDetails");
            objectIndexIdRow.set("OBJECT_CREATION_ID", (Object)objectCreationId);
            objectIndexIdRow.set("LAYOUT_ID", (Object)layoutId);
            objectIndexIdRow.set("VALIDATION_STATUS_MESSAGE", (Object)validationStatusMsg);
            newDataObj.addRow(objectIndexIdRow);
            DataAccess.fillGeneratedValues((DataObject)newDataObj);
            Long newObjectIndexId = (Long)objectIndexIdRow.get("OBJECT_INDEX_ID");
            ArrayList<String> notFillColumns = new ArrayList<String>();
            notFillColumns.add("UNIQUE_ID");
            notFillColumns.add("OBJECT_INDEX_ID");
            String singleValueTableName = FcLayoutUtil.getSingleValueTableName((Long)templateCategoryId);
            Criteria singleValCrit = new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
            DataObject singleValueDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(singleValueTableName, singleValCrit);
            Iterator it = singleValueDO.getRows(singleValueTableName);
            while (it.hasNext()) {
                Row r2 = (Row)it.next();
                Row newRow2 = FcExecuteFormFlow.cloneRow(r2, singleValueTableName, notFillColumns);
                newRow2.set("OBJECT_INDEX_ID", (Object)newObjectIndexId);
                if (pwdMap != null && newRow2.getColumns().contains("PASSWORD")) {
                    newRow2.set("PASSWORD", (Object)((String)pwdMap.get(objectIndexId)));
                }
                newDataObj.addRow(newRow2);
            }
            String[] multiValueTables = FcLayoutUtil.getFcBulkMultiValuesTables((Long)templateCategoryId);
            for (int i = 0; i < multiValueTables.length; ++i) {
                Criteria multiValCrit = new Criteria(Column.getColumn((String)multiValueTables[i], (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
                DataObject multiValueDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(multiValueTables[i], multiValCrit);
                Iterator ite = multiValueDO.getRows(multiValueTables[i]);
                while (ite.hasNext()) {
                    r = (Row)ite.next();
                    newRow = FcExecuteFormFlow.cloneRow(r, multiValueTables[i], notFillColumns);
                    newRow.set("OBJECT_INDEX_ID", (Object)newObjectIndexId);
                    newDataObj.addRow(newRow);
                }
            }
            String custAttrTableName = FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId);
            Criteria customAttrValCrit = new Criteria(Column.getColumn((String)custAttrTableName, (String)"OBJECT_INDEX_ID"), (Object)objectIndexId, 0);
            DataObject customAttrValueDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(custAttrTableName, customAttrValCrit);
            Iterator iterator = customAttrValueDO.getRows(custAttrTableName);
            while (iterator.hasNext()) {
                r = (Row)iterator.next();
                newRow = FcExecuteFormFlow.cloneRow(r, custAttrTableName, notFillColumns);
                newRow.set("OBJECT_INDEX_ID", (Object)newObjectIndexId);
                newDataObj.addRow(newRow);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(newDataObj);
            returnValue = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static DataObject getSingleObjectDetailsFromDB(Long objectIndexId, Integer objectIndexType, Long templateCategoryId) {
        return FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, objectIndexType, templateCategoryId, false, null);
    }

    public static DataObject getSingleObjectDetailsFromDB(Long objectIndexId, Integer objectIndexType, Long templateCategoryId, boolean fetchArchiveData, Long archiveTime) {
        Hashtable dataObjects = FcExecuteFormFlow.getObjectDetailsFromDB(new Long[]{objectIndexId}, new Integer[]{objectIndexType}, templateCategoryId, fetchArchiveData, archiveTime);
        return (DataObject)dataObjects.get(objectIndexId + "_" + objectIndexType);
    }

    public static Hashtable getObjectDetailsFromDB(Long[] objectIndexIds, Integer[] objectIndexTypes, Long templateCategoryId) {
        return FcExecuteFormFlow.getObjectDetailsFromDB(objectIndexIds, objectIndexTypes, templateCategoryId, false, null);
    }

    public static Hashtable getObjectDetailsFromDB(Long[] objectIndexIds, Integer[] objectIndexTypes, Long templateCategoryId, boolean isArchiveData, Long archiveTime) {
        Hashtable dataObjects = new Hashtable();
        try {
            DataObject finalDO = null;
            finalDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            FcExecuteFormFlow.initializeTableDO(dataObjects, objectIndexIds, objectIndexTypes);
            String singleValueTableName = FcLayoutUtil.getSingleValueTableName((Long)templateCategoryId);
            if (isArchiveData) {
                singleValueTableName = singleValueTableName + "_" + archiveTime;
            }
            Criteria objectIndexTypeCrit = new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexTypes, 8);
            int chunk = 1000;
            Long[] chunkArray = null;
            for (int index = 0; index < objectIndexIds.length; index += chunk) {
                chunkArray = Arrays.copyOfRange(objectIndexIds, index, Math.min(objectIndexIds.length, index + chunk));
                Criteria crit = new Criteria(Column.getColumn((String)singleValueTableName, (String)"OBJECT_INDEX_ID"), (Object)chunkArray, 8);
                crit = crit.and(objectIndexTypeCrit);
                DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(singleValueTableName, crit);
                FcExecuteFormFlow.fillDataObjects(dObj, dataObjects, chunkArray, objectIndexTypes, singleValueTableName);
            }
            String[] multiValueTables = FcLayoutUtil.getFcBulkMultiValuesTables((Long)templateCategoryId);
            for (int i = 0; i < multiValueTables.length; ++i) {
                String multiValuetable = multiValueTables[i];
                if (isArchiveData) {
                    multiValuetable = multiValuetable + "_" + archiveTime;
                }
                objectIndexTypeCrit = new Criteria(Column.getColumn((String)multiValuetable, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexTypes, 8);
                chunkArray = null;
                for (int index = 0; index < objectIndexIds.length; index += chunk) {
                    chunkArray = Arrays.copyOfRange(objectIndexIds, index, Math.min(objectIndexIds.length, index + chunk));
                    Criteria crit = new Criteria(Column.getColumn((String)multiValuetable, (String)"OBJECT_INDEX_ID"), (Object)chunkArray, 8);
                    crit = crit.and(objectIndexTypeCrit);
                    DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(multiValuetable, crit);
                    FcExecuteFormFlow.fillDataObjects(dObj, dataObjects, chunkArray, objectIndexTypes, multiValuetable);
                }
            }
            String custAttrTableName = FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId);
            if (isArchiveData) {
                custAttrTableName = custAttrTableName + "_" + archiveTime;
            }
            objectIndexTypeCrit = new Criteria(Column.getColumn((String)custAttrTableName, (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexTypes, 8);
            chunkArray = null;
            for (int index = 0; index < objectIndexIds.length; index += chunk) {
                chunkArray = Arrays.copyOfRange(objectIndexIds, index, Math.min(objectIndexIds.length, index + chunk));
                Criteria crit = new Criteria(Column.getColumn((String)custAttrTableName, (String)"OBJECT_INDEX_ID"), (Object)chunkArray, 8);
                crit = crit.and(objectIndexTypeCrit);
                DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(custAttrTableName, crit);
                FcExecuteFormFlow.fillDataObjects(dObj, dataObjects, chunkArray, objectIndexTypes, custAttrTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObjects;
    }

    private static void initializeTableDO(Hashtable dataObjects, Long[] objectIndexIds, Integer[] objectIndexTypes) {
        try {
            for (Long objectIndexId : objectIndexIds) {
                for (Integer objectIndexType : objectIndexTypes) {
                    DataObject dataObject = null;
                    if (dataObjects.get(objectIndexId + "_" + objectIndexType) != null) continue;
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObjects.put(objectIndexId + "_" + objectIndexType, dataObject);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fillDataObjects(DataObject dataObj, Hashtable dataObjects, Long[] objectIndexIds, Integer[] objectIndexTypes, String tableName) {
        try {
            List splitDataObjects = ((WritableDataObject)dataObj).getDataObjects();
            for (DataObject individualDataObject : splitDataObjects) {
                Row individualRow = individualDataObject.getFirstRow(tableName);
                Long objectIndexId = (Long)individualRow.get("OBJECT_INDEX_ID");
                Integer objectIndexType = (Integer)individualRow.get("OBJECT_INDEX_TYPE");
                DataObject tableDataObject = (DataObject)dataObjects.get(objectIndexId + "_" + objectIndexType);
                if (tableDataObject == null) {
                    tableDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObjects.put(objectIndexId + "_" + objectIndexType, tableDataObject);
                }
                tableDataObject.merge(individualDataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAvailableColumnsList(JSONArray objectDetailsArray, JSONObject columnsList) {
        FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList, null);
    }

    public static void updateAvailableColumnsList(JSONArray objectDetailsArray, JSONObject columnsList, Long templateCategoryId) {
        try {
            for (int i = 0; i < objectDetailsArray.length(); ++i) {
                JSONObject objectDetailsObj = objectDetailsArray.getJSONObject(i);
                FcFormDataContainer fcFormDataContainer = (FcFormDataContainer)objectDetailsObj.get("objectDetails");
                Enumeration e = fcFormDataContainer.elements();
                while (e.hasMoreElements()) {
                    ArrayList fcAttributesList;
                    FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                    if (templateCategoryId != null && templateCategoryId.compareTo(6L) == 0 && fcLayoutField.getIComponent().hasEmptyValue() || (fcAttributesList = fcLayoutField.getFcAttributeList()) == null || fcAttributesList.size() <= 0) continue;
                    for (FcAttributes fcAttr : fcAttributesList) {
                        if (columnsList.has(fcAttr.getAttribLdapName())) continue;
                        columnsList.put(fcAttr.getAttribLdapName(), (Object)fcAttr);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean needsSpecialHandling(String ldapName) {
        return "userAccountControl".equalsIgnoreCase(ldapName) || "msRTCSIP-OptionFlags".equalsIgnoreCase(ldapName);
    }

    public static Object getSpecialAttributeValue(JSONObject objectRowDetails, String ldapName, Object value) {
        try {
            if ("userAccountControl".equalsIgnoreCase(ldapName)) {
                JSONObject valueDetails;
                Long returnValue = 512L;
                if (objectRowDetails.has(ldapName) && (valueDetails = objectRowDetails.getJSONObject(ldapName)).get("value") != null) {
                    returnValue = new Long((String)valueDetails.get("value"));
                }
                if (value != null && !value.equals("")) {
                    Long newValue = new Long((String)value);
                    returnValue = returnValue | newValue;
                }
                return returnValue.toString();
            }
            if ("msRTCSIP-OptionFlags".equalsIgnoreCase(ldapName)) {
                JSONObject valueDetails;
                Integer returnValue = 0;
                if (objectRowDetails.has(ldapName) && (valueDetails = objectRowDetails.getJSONObject(ldapName)).get("value") != null) {
                    returnValue = (Integer)valueDetails.get("value");
                }
                if (value != null) {
                    Integer newValue = (Integer)value;
                    returnValue = returnValue + newValue;
                }
                return returnValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject getSingleObjValuesList(FcFormDataContainer fcFormDataContainer) {
        JSONObject objectRowDetails = new JSONObject();
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                ArrayList fcAttributesList;
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                if (fcLayoutField.getIsHidden().booleanValue() || (fcAttributesList = fcLayoutField.getFcAttributeList()) == null || fcAttributesList.size() <= 0) continue;
                for (FcAttributes fcAttr : fcAttributesList) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("canEdit", fcLayoutField.canEditInBulkMgmtUI(fcAttr.getAttribColumnName()));
                    Object value = fcAttr.getAttribValue();
                    if (FcExecuteFormFlow.needsSpecialHandling(fcAttr.getAttribLdapName())) {
                        value = FcExecuteFormFlow.getSpecialAttributeValue(objectRowDetails, fcAttr.getAttribLdapName(), value);
                    }
                    jsonObj.put("value", value);
                    jsonObj.put("validationIds", (Object)fcLayoutField.getValidationIds());
                    jsonObj.put("maxLength", (Object)fcLayoutField.getMaxLen());
                    objectRowDetails.put(fcAttr.getAttribLdapName(), (Object)jsonObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectRowDetails;
    }

    public static boolean isSingleObjPropsAvailableForAudit(Long templateCategoryId, Long objectIndexId, boolean fetchArchiveData, Long archiveTime) {
        boolean returnValue = false;
        DataObject dataObj = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.resultDataId, templateCategoryId, fetchArchiveData, archiveTime);
        if (!dataObj.isEmpty()) {
            returnValue = true;
        }
        return returnValue;
    }

    public static HashMap getSingleObjPropsForAudit(Long templateCategoryId, Long objectIndexId, String domainName, Long loginId, AdventNetResourceBundle rb, boolean fetchArchiveData, Long archiveTime) {
        HashMap<String, Object> objectProperties = new HashMap<String, Object>();
        try {
            boolean savePassword = PasswordUtil.getSavePasswordValue();
            Hashtable dpValues = FcLayoutUtil.getDPValues((Long)templateCategoryId, (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)false);
            boolean isModification = templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0;
            FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getResultDataContainer(objectIndexId, templateCategoryId, rb, domainName, loginId, null, null, null, null, false, dpValues, fetchArchiveData, archiveTime);
            Properties prop = new Properties();
            prop.put("domainName", domainName);
            prop.put("loginId", loginId);
            prop.put("dpValues", dpValues);
            DataObject dataObj = FcExecuteFormFlow.getSingleObjectDetailsFromDB(objectIndexId, FcExecuteActionConstants.resultDataId, templateCategoryId, fetchArchiveData, archiveTime);
            FcBulkExecuteFormFlow.fillFieldsFromBulkLayoutTables(resultDataContainer, dataObj, templateCategoryId, prop, rb);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(resultDataContainer);
            long userAccountControl = 512L;
            long lcsOptionFlags = 0L;
            Long layoutId = FcLayoutBulkViewHandler.getLayoutIdForObjectIndexId((Long)objectIndexId, (boolean)fetchArchiveData, (Long)archiveTime);
            String templateName = FcLayoutViewHandler.getLayoutName((Long)layoutId, (AdventNetResourceBundle)rb);
            ArrayList<Object> selectIamAppIds = new ArrayList<Object>();
            Iterator itr = dataObj.getRows("FcBulkUserSelectedIamAppVals");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                selectIamAppIds.add(row.get("IAMAPP_ID"));
            }
            if (selectIamAppIds.size() == 0) {
                selectIamAppIds.add(1);
            }
            objectProperties.put(rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"), templateName);
            Enumeration e = resultDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Integer iamAppId = fcLayoutField.getIamAppId();
                int componentId = fcLayoutField.getComponentId().intValue();
                if (fcLayoutField.getIComponent().hasEmptyValue(isModification) && componentId != 4 || iamAppId != null && !selectIamAppIds.contains(iamAppId) && (fcLayoutField.getChildFieldArr() == null || fcLayoutField.getChildFieldArr().size() <= 0)) continue;
                fcLayoutField.setValueForAuditDisplay(prop, resultDataContainer);
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    Object object;
                    String ldapName = fcAttribute.getAttribLdapName();
                    String keyForHashMap = rb.getString(fcAttribute.getAttribDisplayName());
                    if (fcLayoutField.getIsCustomField().booleanValue()) {
                        keyForHashMap = fcAttribute.getAttribLdapName();
                    }
                    if (fcLayoutField.getComponentId() == 159L) {
                        keyForHashMap = ((FcPhotoFileUpload)fcLayoutField.getIComponent()).getPhotoAttribute();
                    }
                    if ((object = fcAttribute.getAttribValue()) == null) continue;
                    if (ldapName.equals("userAccountControl")) {
                        userAccountControl |= Long.parseLong(object.toString());
                        continue;
                    }
                    if (ldapName.equals("msRTCSIP-OptionFlags")) {
                        lcsOptionFlags += Long.parseLong(object.toString());
                        continue;
                    }
                    if (ldapName.equals("userFlags")) {
                        objectProperties.put(rb.getString("admp.common.attrib_disp_name.user_flags"), object.toString());
                        continue;
                    }
                    if (ldapName.equals("dLMemRejectPerms") || ldapName.equals("dLMemSubmitPerms") || ldapName.equals("authOrig") || ldapName.equals("unauthOrig")) {
                        ArrayList attribVal = (ArrayList)objectProperties.get(keyForHashMap);
                        ArrayList objLst = (ArrayList)object;
                        if (attribVal != null && !attribVal.contains(objLst.get(0))) {
                            attribVal.add(objLst.get(0));
                            objectProperties.put(keyForHashMap, attribVal);
                            continue;
                        }
                        objectProperties.put(keyForHashMap, objLst);
                        continue;
                    }
                    if (ldapName.equalsIgnoreCase("SimpleDisplayName") || ldapName.equalsIgnoreCase("O365Manager") || ldapName.equalsIgnoreCase("O365HiddenFromAddressListsEnabled")) {
                        keyForHashMap = keyForHashMap + " (O365)";
                        objectProperties.put(keyForHashMap, fcAttribute.getAttribValue().toString());
                        continue;
                    }
                    if (ldapName.equalsIgnoreCase("password") && !savePassword) continue;
                    if (object instanceof String) {
                        String value = object.toString().trim();
                        if (value.length() <= 0) continue;
                        objectProperties.put(keyForHashMap, value);
                        continue;
                    }
                    objectProperties.put(keyForHashMap, object.toString());
                }
            }
            if (userAccountControl > 0L && (templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0)) {
                objectProperties.put(rb.getString("admp.common.attrib_disp_name.account_status"), userAccountControl);
            }
            if (lcsOptionFlags > 0L) {
                objectProperties.put(rb.getString("reports.user.option_flag"), lcsOptionFlags);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectProperties;
    }

    public static Hashtable getMultipleObjPropsForAudit(Hashtable detailsTable, Long loginId, AdventNetResourceBundle rb, ArrayList columnNameList, boolean fetchArchiveData, Long archiveTime) {
        Hashtable objToResult = new Hashtable();
        String domainName = null;
        ArrayList<Long> userIndexVals = new ArrayList<Long>();
        ArrayList<String> objectDomainsList = new ArrayList<String>();
        Iterator i$ = detailsTable.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry ent;
            Map.Entry entry = ent = i$.next();
            Long key = (Long)entry.getKey();
            Hashtable value = (Hashtable)entry.getValue();
            if (value.get("USER_INDEX") == null) continue;
            userIndexVals.add((Long)value.get("USER_INDEX"));
            if (objectDomainsList.contains((String)value.get("OBJECT_DOMAIN"))) continue;
            objectDomainsList.add((String)value.get("OBJECT_DOMAIN"));
        }
        String[] objectDomains = new String[objectDomainsList.size()];
        objectDomains = objectDomainsList.toArray(objectDomains);
        Long[] userIndexArray = new Long[userIndexVals.size()];
        userIndexArray = userIndexVals.toArray(userIndexArray);
        Hashtable dataObjects = FcExecuteFormFlow.getObjectDetailsFromDB(userIndexArray, new Integer[]{FcExecuteActionConstants.resultDataId}, FcExecuteActionConstants.userCreationTemplateCategoryId, fetchArchiveData, archiveTime);
        Hashtable dpValuesList = FcLayoutUtil.getDPValues((Long[])new Long[]{FcExecuteActionConstants.userCreationTemplateCategoryId, FcExecuteActionConstants.groupCreationTemplateCategoryId, FcExecuteActionConstants.contactCreationTemplateCategoryId, FcExecuteActionConstants.userModificationTemplateCategoryId}, (Long)loginId, (String[])objectDomains, (AdventNetResourceBundle)rb, (boolean)false);
        Iterator i$2 = detailsTable.entrySet().iterator();
        while (i$2.hasNext()) {
            Map.Entry ent;
            Map.Entry entry = ent = i$2.next();
            Long key = (Long)entry.getKey();
            Hashtable detailsHash = (Hashtable)entry.getValue();
            ArrayList objectProperties = new ArrayList();
            DataObject dataObj = (DataObject)dataObjects.get(detailsHash.get("USER_INDEX") + "_" + new Integer(FcExecuteActionConstants.resultDataId).toString());
            Long userIndexId = null;
            Long objectId = null;
            Long tempCategoryId = null;
            userIndexId = (Long)detailsHash.get("USER_INDEX");
            try {
                Hashtable<String, Object> objectPropertiesRow;
                objectId = key;
                domainName = (String)detailsHash.get("OBJECT_DOMAIN");
                tempCategoryId = (Long)detailsHash.get("TEMPLATE_CATEGORY_ID");
                if (tempCategoryId == null) {
                    tempCategoryId = FcExecuteActionConstants.userCreationTemplateCategoryId;
                }
                Hashtable dpValues = (Hashtable)dpValuesList.get(tempCategoryId.toString() + "_" + domainName);
                FcFormDataContainer resultDataContainer = FcBulkExecuteFormFlow.getResultDataContainer(userIndexId, tempCategoryId, rb, domainName, loginId, null, null, null, null, false, dpValues, fetchArchiveData, archiveTime);
                Properties prop = new Properties();
                prop.put("domainName", domainName);
                prop.put("loginId", loginId);
                prop.put("dpValues", dpValues);
                FcBulkExecuteFormFlow.fillFieldsFromBulkLayoutTables(resultDataContainer, dataObj, tempCategoryId, prop, rb);
                IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(tempCategoryId);
                iMgmtHandler.updateFieldsAttributes(resultDataContainer);
                long userAccountControl = 512L;
                long lcsOptionFlags = 0L;
                Criteria uacCri = new Criteria(new Column("FcBulkUserSingleVals", "OBJECT_INDEX_ID"), (Object)userIndexId, 0);
                Row uacRow = dataObj.getRow("FcBulkUserSingleVals", uacCri);
                String uacDBValue = "";
                if (uacRow != null && uacRow.get("ACCOUNT_STATUS") != null) {
                    uacDBValue = (String)uacRow.get("ACCOUNT_STATUS");
                }
                if (columnNameList != null) {
                    // empty if block
                }
                boolean isModification = tempCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0;
                Enumeration e = resultDataContainer.elements();
                while (e.hasMoreElements()) {
                    FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                    int componentId = fcLayoutField.getComponentId().intValue();
                    if (fcLayoutField.getIComponent().hasEmptyValue(isModification) && componentId != 4) continue;
                    fcLayoutField.setValueForAuditDisplay(prop, resultDataContainer);
                    ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                    for (FcAttributes fcAttribute : fcAttributeList) {
                        String value;
                        Hashtable<String, String> objectPropertiesRow2;
                        Object object;
                        String ldapName = fcAttribute.getAttribLdapName();
                        String columnName = fcAttribute.getAttribColumnName();
                        String keyForHashMap = rb.getString(fcAttribute.getAttribDisplayName());
                        if (fcLayoutField.getIsCustomField().booleanValue()) {
                            keyForHashMap = fcAttribute.getAttribLdapName();
                        }
                        if (fcLayoutField.getComponentId() == 159L) {
                            keyForHashMap = ((FcPhotoFileUpload)fcLayoutField.getIComponent()).getPhotoAttribute();
                        }
                        if ((object = fcAttribute.getAttribValue()) == null || columnNameList != null && !columnNameList.contains(columnName)) continue;
                        if (ldapName.equals("userAccountControl")) {
                            userAccountControl |= Long.parseLong(object.toString());
                            continue;
                        }
                        if (ldapName.equals("msRTCSIP-OptionFlags")) {
                            lcsOptionFlags += Long.parseLong(object.toString());
                            continue;
                        }
                        if (ldapName.equals("userFlags")) {
                            objectPropertiesRow2 = new Hashtable<String, String>();
                            objectPropertiesRow2.put(new String("AttrName"), rb.getString("admp.common.attrib_disp_name.user_flags"));
                            objectPropertiesRow2.put(new String("AttrValue"), object.toString());
                            objectProperties.add(objectPropertiesRow2);
                            continue;
                        }
                        if (ldapName.equals("password")) {
                            if (!PasswordUtil.getSavePasswordValue()) continue;
                            objectPropertiesRow2 = new Hashtable();
                            objectPropertiesRow2.put(new String("AttrName"), keyForHashMap);
                            if (PasswordUtil.getShowPasswordValue()) {
                                objectPropertiesRow2.put(new String("AttrValue"), new String("********"));
                            } else {
                                objectPropertiesRow2.put(new String("AttrValue"), object.toString().trim());
                            }
                            objectProperties.add(objectPropertiesRow2);
                            continue;
                        }
                        if (object instanceof ArrayList) {
                            value = "";
                            ArrayList ar = (ArrayList)object;
                            if (ar.size() > 0) {
                                value = "[" + ar.get(0) + "]";
                            }
                            for (int i = 1; i < ar.size(); ++i) {
                                value = value + ", [" + ar.get(i) + "]";
                            }
                            if (value.length() <= 0) continue;
                            Hashtable<String, String> objectPropertiesRow3 = new Hashtable<String, String>();
                            objectPropertiesRow3.put(new String("AttrName"), keyForHashMap);
                            objectPropertiesRow3.put(new String("AttrValue"), value);
                            objectProperties.add(objectPropertiesRow3);
                            continue;
                        }
                        if (object instanceof String) {
                            value = object.toString().trim();
                            if (value.length() <= 0) continue;
                            Hashtable<String, String> objectPropertiesRow4 = new Hashtable<String, String>();
                            objectPropertiesRow4.put(new String("AttrName"), keyForHashMap);
                            objectPropertiesRow4.put(new String("AttrValue"), value);
                            objectProperties.add(objectPropertiesRow4);
                            continue;
                        }
                        objectPropertiesRow2 = new Hashtable();
                        objectPropertiesRow2.put(new String("AttrName"), keyForHashMap);
                        objectPropertiesRow2.put(new String("AttrValue"), object.toString());
                        objectProperties.add(objectPropertiesRow2);
                    }
                }
                if (userAccountControl > 0L && (tempCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0 || tempCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 || tempCategoryId.compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0 || tempCategoryId.compareTo(FcExecuteActionConstants.computerModificationTemplateCategoryId) == 0)) {
                    objectPropertiesRow = new Hashtable<String, Object>();
                    objectPropertiesRow.put(new String("AttrName"), rb.getString("admp.common.attrib_disp_name.account_status"));
                    if (uacDBValue != null && !uacDBValue.isEmpty()) {
                        objectPropertiesRow.put(new String("AttrValue"), uacDBValue);
                    } else {
                        objectPropertiesRow.put(new String("AttrValue"), userAccountControl);
                    }
                    objectProperties.add(objectPropertiesRow);
                }
                if (lcsOptionFlags > 0L) {
                    objectPropertiesRow = new Hashtable();
                    objectPropertiesRow.put(new String("AttrName"), rb.getString("reports.user.option_flag"));
                    objectPropertiesRow.put(new String("AttrValue"), lcsOptionFlags);
                    objectProperties.add(objectPropertiesRow);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            objToResult.put(objectId, objectProperties);
        }
        return objToResult;
    }

    public static JSONArray getValuesList(JSONArray objectDetailsArray) {
        JSONArray objectsList = new JSONArray();
        try {
            for (int i = 0; i < objectDetailsArray.length(); ++i) {
                JSONObject objectDetailsObj = objectDetailsArray.getJSONObject(i);
                JSONObject singleObjectDetails = new JSONObject();
                FcFormDataContainer fcFormDataContainer = (FcFormDataContainer)objectDetailsObj.get("objectDetails");
                Long objectIndexId = objectDetailsObj.getLong("objectIndexId");
                JSONObject objectRowDetails = FcExecuteFormFlow.getSingleObjValuesList(fcFormDataContainer);
                singleObjectDetails.put("objectIndexId", (Object)objectIndexId);
                singleObjectDetails.put("validationStatusMsg", (Object)objectDetailsObj.getString("validationStatusMsg"));
                singleObjectDetails.put("objectRowDetails", (Object)objectRowDetails);
                objectsList.put((Object)singleObjectDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectsList;
    }

    public static void fillAuthorizedFields(HttpServletRequest request, FcFormDataContainer fcFormDataContainer, Long templateCategoryId, String domainName, Long parentactionId) {
        FcExecuteFormFlow.fillAuthorizedFields(request, fcFormDataContainer, templateCategoryId, domainName, parentactionId, null);
    }

    public static void fillAuthorizedFields(HttpServletRequest request, FcFormDataContainer fcFormDataContainer, Long templateCategoryId, String domainName, Long parentactionId, Hashtable layoutCache) {
        FcExecuteFormFlow.fillAuthorizedFields(ClientUtil.getAuthObject(request), fcFormDataContainer, templateCategoryId, domainName, parentactionId, layoutCache);
    }

    public static void fillAuthorizedFields(ADMPAuthObject authObject, FcFormDataContainer fcFormDataContainer, Long templateCategoryId, String domainName, Long parentactionId) {
        FcExecuteFormFlow.fillAuthorizedFields(authObject, fcFormDataContainer, templateCategoryId, domainName, parentactionId, null);
    }

    public static void fillAuthorizedFields(ADMPAuthObject authObject, FcFormDataContainer fcFormDataContainer, Long templateCategoryId, String domainName, Long parentactionId, Hashtable layoutCache) {
        try {
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(fcFormDataContainer);
            boolean isModifyObjectCategory = FcLayoutUtil.isModifyObjectCategory((Long)templateCategoryId);
            boolean isADDomain = FcLayoutUtil.getIsADDomain((String)domainName);
            ArrayList domainList = new ArrayList();
            if (!isADDomain) {
                domainList = DomainUtil.getConfiguredDomainNamesList();
            }
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcField = (FcLayoutField)e.nextElement();
                ArrayList fcAttributesList = fcField.getFcAttributeList();
                if (fcAttributesList == null || fcAttributesList.size() <= 0) continue;
                FcAttributes fcAttributes = (FcAttributes)fcAttributesList.get(0);
                Long actionId = null;
                actionId = isModifyObjectCategory ? fcAttributes.getModifyId() : fcAttributes.getActionId();
                boolean isAuthorized = isADDomain ? (actionId != null ? ClientUtil.checkAuthorization(authObject, domainName, (long)actionId) : ClientUtil.checkAuthorization(authObject, domainName, (long)parentactionId)) : (actionId != null ? ClientUtil.checkAuthorization(authObject, domainList, (long)actionId) : ClientUtil.checkAuthorization(authObject, domainList, (long)parentactionId));
                fcField.setIsAuthorized(Boolean.valueOf(isAuthorized));
                JSONObject authorizationDetails = new JSONObject();
                authorizationDetails.put("authObject", (Object)authObject);
                authorizationDetails.put("domainName", (Object)domainName);
                authorizationDetails.put("templateCategoryId", (Object)templateCategoryId);
                for (FcAttributes fcAttr : fcAttributesList) {
                    actionId = isModifyObjectCategory ? fcAttr.getModifyId() : fcAttr.getActionId();
                    if (actionId == null) continue;
                    if (isADDomain) {
                        authorizationDetails.put(fcAttr.getAttribColumnName(), ClientUtil.checkAuthorization(authObject, domainName, (long)actionId));
                        continue;
                    }
                    authorizationDetails.put(fcAttr.getAttribColumnName(), ClientUtil.checkAuthorization(authObject, domainList, (long)actionId));
                }
                if (layoutCache != null) {
                    Hashtable fieldCache = new Hashtable();
                    if (layoutCache.containsKey(fcField.getFieldId())) {
                        fieldCache = (Hashtable)layoutCache.get(fcField.getFieldId());
                    }
                    fcField.getIComponent().setAuthorizationDetails(fcField, authorizationDetails, fieldCache);
                    layoutCache.put(fcField.getFieldId(), fieldCache);
                    continue;
                }
                fcField.getIComponent().setAuthorizationDetails(fcField, authorizationDetails);
            }
        }
        catch (Exception e) {
            logg.log(Level.INFO, "Error occurred while setting Authorized fields");
            e.printStackTrace();
        }
    }

    public static Long createWorkFlowRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb) {
        return FcExecuteFormFlow.createWorkFlowRequest(objectCreationId, templateCategoryId, loginId, domainName, wfCreateRequestJson, rb, true);
    }

    public static Long createWorkFlowRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb, boolean isBulk) {
        if (templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
            return FcExecuteFormFlow.createUserCreationRequest(objectCreationId, templateCategoryId, loginId, domainName, wfCreateRequestJson, rb, isBulk);
        }
        if (templateCategoryId.compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
            return FcExecuteFormFlow.createGroupCreationRequest(objectCreationId, templateCategoryId, loginId, domainName, wfCreateRequestJson, rb);
        }
        if (templateCategoryId.compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
            return FcExecuteFormFlow.createContactCreationRequest(objectCreationId, templateCategoryId, loginId, domainName, wfCreateRequestJson, rb);
        }
        if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
            return FcExecuteFormFlow.createUserModificationRequest(objectCreationId, templateCategoryId, loginId, domainName, wfCreateRequestJson, rb);
        }
        return -1L;
    }

    public static Long createUserCreationRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb, boolean isBulk) {
        Long requestId = -1L;
        try {
            ArrayList actionDetails = new ArrayList();
            HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
            if (isBulk) {
                actionToPerform.put("RequestAction", Long.valueOf(22L));
            } else {
                actionToPerform.put("RequestAction", Long.valueOf(21L));
            }
            ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
            AdmpInput admpInput = new AdmpInput("templateCategoryId", templateCategoryId.toString(), false);
            multipleInputs.add(admpInput);
            actionToPerform.put("MultipleInputs", multipleInputs);
            actionDetails.add(actionToPerform);
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(actionDetails);
            wfRequest.setUserCreationId(objectCreationId);
            wfRequest.setDomainName(domainName);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setPriority(Integer.valueOf(wfCreateRequestJson.getInt("priority")));
            Long automationId = null;
            if (wfCreateRequestJson.has("automationId") && wfCreateRequestJson.getLong("automationId") != 0L) {
                automationId = wfCreateRequestJson.getLong("automationId");
                ScheduledRequest robo = new ScheduledRequest(automationId, Boolean.valueOf(false));
                robo.setUserCreationId(objectCreationId);
                robo.setRb(rb);
                if (AutomationUtil.isPolicyBasedAutomation((Long)automationId).booleanValue()) {
                    robo.setPolicyBasedAutomation(AutomationUtil.isPolicyBasedAutomation((Long)automationId).booleanValue());
                    Long mgmtPolicyId = AutomationUtil.getMgmtPolicyId((Long)automationId);
                    robo.setRequestAction(mgmtPolicyId);
                    robo.setMgmtPolicy(mgmtPolicyId);
                }
                wfRequest.setRequestMode(AutomationConstants.REQUEST_ROBO_MODE);
                wfRequest.setRobo(robo);
                requestId = wfRequest.createRequest(loginId, automationId, wfCreateRequestJson.getString("subject"), wfCreateRequestJson.getString("description"), Integer.valueOf(1), Integer.valueOf(5));
            } else {
                requestId = wfRequest.createRequest(loginId, null, wfCreateRequestJson.getString("subject"), wfCreateRequestJson.getString("description"), Integer.valueOf(1), Integer.valueOf(5));
            }
            WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
            executeRule.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public static Long createGroupCreationRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb) {
        Long requestId = -1L;
        try {
            ArrayList actionDetails = new ArrayList();
            HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
            actionToPerform.put("RequestAction", Long.valueOf(43L));
            ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
            AdmpInput admpInput = new AdmpInput("templateCategoryId", templateCategoryId.toString(), false);
            multipleInputs.add(admpInput);
            actionToPerform.put("MultipleInputs", multipleInputs);
            actionDetails.add(actionToPerform);
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(actionDetails);
            wfRequest.setUserCreationId(objectCreationId);
            wfRequest.setDomainName(domainName);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setPriority(Integer.valueOf(wfCreateRequestJson.getInt("priority")));
            requestId = wfRequest.createRequest(loginId, null, wfCreateRequestJson.getString("subject"), wfCreateRequestJson.getString("description"), Integer.valueOf(2), Integer.valueOf(6));
            WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
            executeRule.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public static Long createUserModificationRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb) {
        Long requestId = -1L;
        try {
            ArrayList actionDetails = new ArrayList();
            HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
            actionToPerform.put("RequestAction", Long.valueOf(24L));
            ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
            AdmpInput admpInput = new AdmpInput("templateCategoryId", templateCategoryId.toString(), false);
            multipleInputs.add(admpInput);
            actionToPerform.put("MultipleInputs", multipleInputs);
            actionDetails.add(actionToPerform);
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(actionDetails);
            wfRequest.setUserCreationId(objectCreationId);
            wfRequest.setDomainName(domainName);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setPriority(Integer.valueOf(wfCreateRequestJson.getInt("priority")));
            requestId = wfRequest.createRequest(loginId, null, wfCreateRequestJson.getString("subject"), wfCreateRequestJson.getString("description"), Integer.valueOf(1), Integer.valueOf(5));
            WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
            executeRule.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public static Long createContactCreationRequest(Long objectCreationId, Long templateCategoryId, Long loginId, String domainName, JSONObject wfCreateRequestJson, AdventNetResourceBundle rb) {
        Long requestId = -1L;
        try {
            ArrayList actionDetails = new ArrayList();
            HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
            actionToPerform.put("RequestAction", Long.valueOf(52L));
            ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
            AdmpInput admpInput = new AdmpInput("templateCategoryId", templateCategoryId.toString(), false);
            multipleInputs.add(admpInput);
            actionToPerform.put("MultipleInputs", multipleInputs);
            actionDetails.add(actionToPerform);
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(actionDetails);
            wfRequest.setUserCreationId(objectCreationId);
            wfRequest.setDomainName(domainName);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setPriority(Integer.valueOf(wfCreateRequestJson.getInt("priority")));
            requestId = wfRequest.createRequest(loginId, null, wfCreateRequestJson.getString("subject"), wfCreateRequestJson.getString("description"), Integer.valueOf(4), Integer.valueOf(7));
            WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
            executeRule.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public static ADMPAuthObject getAuthObject(HttpServletRequest request) {
        return ClientUtil.getAuthObject(request);
    }

    public static void csvImport(HttpServletRequest request, AdventNetResourceBundle rb) throws Exception {
        try {
            DiskFileUpload upload = new DiskFileUpload();
            List items = upload.parseRequest(request);
            FileInputStream fileInputStream = null;
            UploadedFileItem uploadedFileItem = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                File file = uploadedFileItem.getUploadedFile();
                fileInputStream = new FileInputStream(file);
            }
            FileInputStream stream = fileInputStream;
            CSVReader csvReader = new CSVReader(stream, "UTF-8", rb);
            Vector headerVector = new Vector();
            int headerSize = 0;
            ArrayList<Vector> list = new ArrayList<Vector>();
            try {
                headerVector = csvReader.getAllFieldsInLine();
                headerSize = headerVector.size();
            }
            catch (Exception headerVectorException) {
                if (headerVectorException instanceof EOFException) {
                    csvReader.close();
                }
                headerVectorException.printStackTrace();
                csvReader.close();
                throw new Exception(headerVectorException.getMessage());
            }
            Properties prop = FcExecuteFormFlow.validateCSVHeader(headerVector, rb);
            String header = (String)prop.get("header");
            if (header.equalsIgnoreCase("false")) {
                throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            }
            request.setAttribute("csvHeaders", (Object)headerVector);
            try {
                while (true) {
                    Vector valuesVector;
                    if ((valuesVector = csvReader.getAllFieldsInLine()).size() != headerSize) {
                        csvReader.close();
                        throw new Exception(rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal"));
                    }
                    list.add(valuesVector);
                }
            }
            catch (EOFException eofexception) {
                csvReader.close();
                request.setAttribute("csvList", list);
                request.setAttribute("propList", (Object)prop);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    private static Properties validateCSVHeader(Vector headerVector, AdventNetResourceBundle rb) throws Exception {
        Properties prop = new Properties();
        boolean header = false;
        boolean keyHeader = false;
        String[] keyLdapNames = new String[]{"samAccountName", "userPrincipalName", "distinguishedName", "DN", "cn", "name", "givenName", "sn", "displayName", "canonicalName", "profilePath", "scriptPath"};
        String keyLdapName = null;
        Vector<String> attributeList = new Vector<String>();
        for (int j = 0; j < headerVector.size(); ++j) {
            String s = (String)headerVector.get(j);
            for (int i = 0; i < keyLdapNames.length; ++i) {
                String s1 = keyLdapNames[i];
                if (!s1.equalsIgnoreCase(s)) continue;
                header = true;
                if (i > 5) continue;
                if (keyLdapName == null) {
                    prop.put("keyPos", new Integer(attributeList.size()));
                    keyLdapName = s;
                }
                keyHeader = true;
                attributeList.add(s);
            }
            if (s.equalsIgnoreCase("DN") || s.equalsIgnoreCase("distinguishedName")) {
                prop.put("dnPos", (Object)j);
                continue;
            }
            if (!s.equalsIgnoreCase("cn") && !s.equalsIgnoreCase("name")) continue;
            prop.put("cnPos", (Object)j);
        }
        if (header) {
            if (!keyHeader) {
                throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            }
            prop.put("attributeList", attributeList);
        } else {
            int dnPos = -1;
            for (int i = 0; i < headerVector.size(); ++i) {
                String s = headerVector.get(i).toString().toLowerCase();
                if (s.indexOf("cn=") == 0 || s.indexOf("dc=") == 0) continue;
                prop.put("keyPos", (Object)i);
                dnPos = i;
                keyLdapName = "distinguishedName";
                prop.put("dnPos", (Object)i);
                break;
            }
            if (dnPos == -1) {
                throw new Exception(rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.add_members.statmsg.first_line_csv_file_contain_one_of_following_attrbs"));
            }
        }
        prop.put("keyLdapName", keyLdapName);
        prop.put("header", String.valueOf(header));
        return prop;
    }

    public static void validateAndFillList(Properties prop, String[] validSelected, String keyLdapName, Long loginId, String domainName, String groupType, String groupScope, boolean crossDomain, boolean isWorkflowMode) {
        try {
            ArrayList<String> duplicateCheckList = new ArrayList<String>();
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList containerList = null;
            Long componentId = (Long)prop.get("componentId");
            Hashtable<String, ArrayList> domainOUList = new Hashtable<String, ArrayList>();
            containerList = isWorkflowMode ? WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId) : FcExecuteFormFlow.getContainerList(loginId, domainName);
            Hashtable includeExcludeGroupOUMap = null;
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList validList = (ArrayList)prop.get("validList");
            ArrayList notExistsList = (ArrayList)prop.get("notExistsList");
            Hashtable membersList = (Hashtable)prop.get("membersList");
            for (int index = 0; index < validSelected.length; ++index) {
                ArrayList list;
                String value = validSelected[index];
                if ((keyLdapName.equalsIgnoreCase("distinguishedName") || keyLdapName.equalsIgnoreCase("dn")) && !DirectoryObjectUtil.isDomainObjectDN((String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), (String)value)) {
                    notExistsList.add(value);
                } else {
                    valueList.add(value);
                }
                if (valueList.size() <= 0 || (index == 0 || index % 15 != 0) && index + 1 != validSelected.length) continue;
                String searchString = FcExecuteFormFlow.getSearchString(valueList, keyLdapName, groupType, groupScope, crossDomain, componentId);
                ArrayList<String> attributeList = new ArrayList<String>();
                attributeList.add("distinguishedName");
                attributeList.add("cn");
                attributeList.add("objectClass");
                attributeList.add("objectGUID");
                attributeList.add(keyLdapName);
                if (componentId.intValue() == 42 || componentId.intValue() == 8 || componentId.intValue() == 62 || componentId.intValue() == 72) {
                    attributeList.add("groupType");
                }
                if ((list = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attributeList, (String)searchString)) == null || list.size() == 0) {
                    notExistsList.addAll(valueList);
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        boolean isAuthorized = false;
                        Properties p = (Properties)list.get(i);
                        value = FcExecuteFormFlow.getValue(p, keyLdapName);
                        if (!valueList.remove(value)) {
                            notExistsList.add(value);
                            continue;
                        }
                        ArrayList classList = (ArrayList)p.get("objectClass");
                        String objectClass = (String)classList.get(classList.size() - 1);
                        String dn = FcExecuteFormFlow.getValue(p, "distinguishedName");
                        Boolean isRequester = WorkFlowUserHandler.isRequester((Long)loginId);
                        if (objectClass.equalsIgnoreCase("group")) {
                            if (!isWorkflowMode || !isRequester.booleanValue()) {
                                if (includeExcludeGroupOUMap == null) {
                                    includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)domainName);
                                }
                                if (!HelpdeskUtil.isExcludedGroup((String)dn, (ArrayList)((ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU"))) && HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)((ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU")))) {
                                    isAuthorized = true;
                                }
                            } else {
                                boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                                if (domainOUList.get(domainName) == null) {
                                    domainOUList.put(domainName, containerList);
                                }
                                if (FcLayoutAuth.isHDTAuthorized((String)dn, domainOUList, (String)domainName, (boolean)isExcludeChildOu)) {
                                    isAuthorized = true;
                                }
                            }
                        } else if (!isWorkflowMode) {
                            isAuthorized = HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)containerList);
                        } else {
                            boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                            if (domainOUList.get(domainName) == null) {
                                domainOUList.put(domainName, containerList);
                            }
                            if (FcLayoutAuth.isHDTAuthorized((String)dn, domainOUList, (String)domainName, (boolean)isExcludeChildOu)) {
                                isAuthorized = true;
                            }
                        }
                        if (!isAuthorized) {
                            notExistsList.add(value);
                            continue;
                        }
                        if (duplicateCheckList.contains(dn.toLowerCase())) continue;
                        validList.add(value);
                        ArrayList<String> proplist = new ArrayList<String>();
                        proplist.add(dn);
                        proplist.add(FcExecuteFormFlow.getValue(p, "cn"));
                        proplist.add(FcExecuteFormFlow.getValue(p, "objectGUID"));
                        if (componentId.intValue() == 42 || componentId.intValue() == 8 || componentId.intValue() == 62 || componentId.intValue() == 72) {
                            String ouName = StrUtil.getContainerFlowFromDN((String)dn);
                            String cnName = FcExecuteFormFlow.getValue(p, "cn") + "[" + ouName + "]";
                            proplist.add(FcExecuteFormFlow.getValue(p, "groupType"));
                            proplist.add(cnName);
                        }
                        membersList.put(value, proplist);
                        duplicateCheckList.add(dn.toLowerCase());
                    }
                    if (valueList.size() > 0) {
                        notExistsList.addAll(valueList);
                    }
                }
                valueList = new ArrayList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMembersList(HttpServletRequest request, Hashtable members, String[] value, boolean validList) {
        for (int i = 0; i < value.length; ++i) {
            String dn = request.getParameter("dnValue" + value[i]);
            String cn = request.getParameter("cnValue" + value[i]);
            String domainName = request.getParameter("domainName");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (cn == null) {
                cn = value[i];
            }
            if (validList) {
                members.put(dn, cn);
                continue;
            }
            ArrayList containerList = FcExecuteFormFlow.getContainerList(loginId, domainName);
            for (int j = 0; j < containerList.size(); ++j) {
                String dns = (String)containerList.get(j);
                if (!dn.toLowerCase().endsWith(dns.toLowerCase())) continue;
                members.put(dn, cn);
            }
        }
    }

    private static ArrayList getContainerList(Long loginId, String domainName) {
        Properties domainDetails = new Properties();
        try {
            domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> containerList = new ArrayList<String>();
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        if (ouList.size() > 0) {
            containerList.addAll(ouList);
        } else {
            containerList.add(domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"));
        }
        return containerList;
    }

    private static String getSearchString(String value, String ldapname, String groupType, String groupScope, boolean isCrossDomain) {
        return FcExecuteFormFlow.getSearchString(value, ldapname, groupType, groupScope, isCrossDomain, (Long)0L);
    }

    private static String getSearchString(String value, String ldapname, String groupType, String groupScope, boolean isCrossDomain, Long componentId) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        return FcExecuteFormFlow.getSearchString(valueList, ldapname, groupType, groupScope, isCrossDomain, componentId);
    }

    private static String getSearchString(ArrayList valueList, String ldapname, String groupType, String groupScope, boolean isCrossDomain, Long componentId) {
        String searchString = "( | (&(objectCategory=person)(objectClass=user)) (&(objectCategory=computer)(objectClass=computer)) (&(objectCategory=person)(objectClass=contact)) ";
        String groupSearchString = "(objectcategory=group)";
        String searchStringForMemberOf = "(objectcategory=group)";
        if (groupScope.equals("universal") || isCrossDomain && !groupScope.equals("global")) {
            groupSearchString = "(&(objectcategory=group)(grouptype:1.2.840.113556.1.4.804:=2)) (&(objectcategory=group)(grouptype:1.2.840.113556.1.4.804:=8))";
            searchStringForMemberOf = "(&(objectcategory=group)(|(grouptype:1.2.840.113556.1.4.804:=8)(grouptype:1.2.840.113556.1.4.804:=4)))";
        } else if (groupScope.equals("global")) {
            groupSearchString = "(&(objectcategory=group)(grouptype:1.2.840.113556.1.4.804:=2))";
        } else if (groupScope.equals("domainLocal")) {
            searchStringForMemberOf = "(&(objectcategory=group)(grouptype:1.2.840.113556.1.4.804:=4))";
        }
        String s = "(|";
        for (int i = 0; i < valueList.size(); ++i) {
            s = s + "(" + ldapname + "=" + CommonUtil.escapeSpecialCharacters((String)((String)valueList.get(i))) + ")";
        }
        s = s + ")";
        if (componentId.intValue() == 42 || componentId.intValue() == 8 || componentId.intValue() == 62 || componentId.intValue() == 72) {
            searchString = "(& " + searchStringForMemberOf + s + " )";
            return searchString;
        }
        searchString = searchString + groupSearchString + ")";
        searchString = "(& " + searchString + s + " )";
        return searchString;
    }

    private static String getValue(Properties p, String key) {
        ArrayList list = (ArrayList)p.get(key);
        return (String)list.get(0);
    }

    public static ArrayList<Long> getImmediateDupliationCheckFields(FcFormDataContainer toClientData) {
        ArrayList<Long> immediateDupliationCheckFields = new ArrayList<Long>();
        for (Long fieldId : toClientData.keySet()) {
            FcLayoutField field = (FcLayoutField)toClientData.get((Object)fieldId);
            if (!field.getIsAvoidDuplication().booleanValue() || !field.getIsImmdeiateDuplicationCheck().booleanValue()) continue;
            immediateDupliationCheckFields.add(fieldId);
        }
        return immediateDupliationCheckFields;
    }

    public static Map getDuplicateList(FcExecuteFormBean fcExecuteFormBean, FcFormDataContainer fromClientData, Long loginId, AdventNetResourceBundle rb, String templaateCategoryId) {
        Hashtable<Long, String> dupliacteList = new Hashtable<Long, String>();
        try {
            ArrayList<Long> imediateDupliationCheckFields = fcExecuteFormBean.getImmediateDupliationCheckFields();
            FcFormDataContainer getADData = fcExecuteFormBean.getADData();
            Long templateCategoryId = Long.parseLong(templaateCategoryId);
            String objectClass = "";
            objectClass = templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0 ? "user" : (templateCategoryId.compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.contactModificationTemplateCategoryId) == 0 ? "contact" : (templateCategoryId.compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.computerModificationTemplateCategoryId) == 0 ? "computer" : (templateCategoryId.compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0 ? "group" : (templateCategoryId.compareTo(FcExecuteActionConstants.dlGroupCreationTemplateCategoryId) == 0 ? "msExchDynamicDistributionList" : (templateCategoryId.compareTo(FcExecuteActionConstants.ouCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.ouModificationTemplateCategoryId) == 0 ? "organizationalUnit" : "user")))));
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(fromClientData);
            iMgmtHandler.updateFieldValuesToAttributes(fromClientData);
            iMgmtHandler.updateFieldsAttributes(getADData);
            iMgmtHandler.updateFieldValuesToAttributes(getADData);
            String domainName = fcExecuteFormBean.getDomainName();
            Properties domainDetails = ADHandler.getDomainDetails((String)domainName, (Long)loginId);
            String ouName = FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            if (getADData != null && !getADData.isEmpty()) {
                for (int i = 0; i < imediateDupliationCheckFields.size(); ++i) {
                    Long fieldId = imediateDupliationCheckFields.get(i);
                    FcLayoutField fcLayoutField = (FcLayoutField)fromClientData.get((Object)fieldId);
                    ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                    FcLayoutField fcDupeLayoutField = null;
                    ArrayList fcDupeAttributeList = new ArrayList();
                    boolean isEmptyField = false;
                    if (getADData.get((Object)imediateDupliationCheckFields.get(i)) != null) {
                        fcDupeLayoutField = (FcLayoutField)getADData.get((Object)imediateDupliationCheckFields.get(i));
                        fcDupeAttributeList = fcDupeLayoutField.getFcAttributeList();
                    } else {
                        isEmptyField = true;
                    }
                    for (int j = 0; j < fcAttributeList.size(); ++j) {
                        FcAttributes fcAttribute = (FcAttributes)fcAttributeList.get(j);
                        Object attribValue = fcAttribute.getAttribValue();
                        Object dupeattribValue = null;
                        FcAttributes fcDupeAttribute = null;
                        if (isEmptyField) {
                            dupeattribValue = "";
                        } else {
                            fcDupeAttribute = (FcAttributes)fcDupeAttributeList.get(j);
                            dupeattribValue = fcDupeAttribute.getAttribValue();
                        }
                        String layoutTableName = fcAttribute.getBulkLayoutTableName();
                        if (attribValue != null && !attribValue.equals(dupeattribValue)) {
                            FcExecuteFormFlow.checkForDupliactes(fcLayoutField, fcAttribute, new Properties(), ouName, domainDetails, null, dupliacteList, false, rb, objectClass);
                            continue;
                        }
                        if (layoutTableName == null || layoutTableName.equalsIgnoreCase("")) continue;
                        dupliacteList.put(fieldId, "");
                    }
                }
            } else {
                for (Long fieldId : imediateDupliationCheckFields) {
                    FcLayoutField fcLayoutField = (FcLayoutField)fromClientData.get((Object)fieldId);
                    ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                    for (FcAttributes fcAttribute : fcAttributeList) {
                        Object attribValue = fcAttribute.getAttribValue();
                        String layoutTableName = fcAttribute.getBulkLayoutTableName();
                        if (attribValue != null) {
                            FcExecuteFormFlow.checkForDupliactes(fcLayoutField, fcAttribute, new Properties(), ouName, domainDetails, null, dupliacteList, false, rb, objectClass);
                            continue;
                        }
                        if (layoutTableName == null || layoutTableName.equalsIgnoreCase("")) continue;
                        dupliacteList.put(fieldId, "");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dupliacteList;
    }

    public static Hashtable getNewValueToAvoidDuplication(FcLayoutField fcLayoutField, FcAttributes fcAttribute, Properties ldapValueProps, String ouName, Properties domainDetails, ArrayList duplicateProxyAddressList, String objectClass) {
        return FcExecuteFormFlow.checkForDupliactes(fcLayoutField, fcAttribute, ldapValueProps, ouName, domainDetails, duplicateProxyAddressList, null, true, null, objectClass);
    }

    public static Hashtable checkForDupliactes(FcLayoutField fcLayoutField, FcAttributes fcAttribute, Properties ldapValueProps, String ouName, Properties domainDetails, ArrayList duplicateProxyAddressList, Map m, boolean getNewValue, AdventNetResourceBundle rb, String objectClass) {
        Hashtable<String, Object> duplicates = new Hashtable<String, Object>();
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        String attributeName = fcAttribute.getAttribLdapName();
        Object attribValue = fcAttribute.getAttribValue();
        String layoutTableName = fcAttribute.getBulkLayoutTableName();
        String attribDisplayName = fcLayoutField.getAttribDisplayText();
        duplicates.put("stopExecution", false);
        ArrayList attribList = new ArrayList();
        if ((layoutTableName == null || layoutTableName.equalsIgnoreCase("")) && !fcLayoutField.getIsCustomField().booleanValue()) {
            duplicates.put("newAttributeValue", attribValue);
            return duplicates;
        }
        String oldAttribValue = attribValue.toString();
        String newAttribValue = attribValue.toString();
        try {
            String defaultNamingContext;
            int index;
            String domainDNSName = "";
            if ((attributeName.equalsIgnoreCase("userPrincipalName") || attributeName.equals("mail") || attributeName.equals("targetAddress")) && (index = newAttribValue.lastIndexOf("@")) != -1) {
                domainDNSName = (String)newAttribValue.subSequence(index + 1, newAttribValue.length());
                newAttribValue = newAttribValue.substring(0, index);
                oldAttribValue = oldAttribValue.substring(0, index);
            }
            String searchScope = defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
            String duplicationLevel = fcLayoutField.getFcAvoidDuplicationDetails().getDuplicationLevel();
            if (duplicationLevel.equals("container")) {
                searchScope = ouName;
            } else if (duplicationLevel.equals("forest")) {
                searchScope = (String)domainDetails.get("ROOT_DOMAIN_NAMING_CONTEXT");
            }
            String searchAttributeValue = newAttribValue;
            ArrayList objectsList = new ArrayList();
            if (attributeName.equalsIgnoreCase("proxyAddresses")) {
                attribList = (ArrayList)attribValue;
                duplicateProxyAddressList.clear();
                ArrayList proxyAddressList = UserMgmtUtil.getADObjectsList((String)duplicationLevel, (String)attributeName, (ArrayList)attribList, (String)searchScope, (Properties)domainDetails);
                if (proxyAddressList != null) {
                    duplicateProxyAddressList.addAll(proxyAddressList);
                }
                return duplicates;
            }
            objectsList = UserMgmtUtil.getADObjectsList((String)duplicationLevel, (String)attributeName, (String)searchAttributeValue, (String)searchScope, (Properties)domainDetails, (String)objectClass);
            String iterationValue = "";
            Long startingIndex = fcLayoutField.getFcAvoidDuplicationDetails().getAppendStartIndex();
            boolean isObjectAvailable = FcExecuteFormFlow.checkObjectExists(objectsList, attributeName, newAttribValue, domainDNSName);
            if (!getNewValue) {
                if (isObjectAvailable) {
                    m.put(fcLayoutField.getFieldId(), MessageFormat.format(rb.getString("admp.mgmt.fc_layout_error.a_" + objectClass + "_with_same_value_already_exists"), attribDisplayName));
                    if (fcLayoutField.getFcAvoidDuplicationDetails().getStopExecution()) {
                        m.put("stopExecution", true);
                    }
                } else {
                    m.put(fcLayoutField.getFieldId(), "");
                }
                return null;
            }
            if (isObjectAvailable) {
                if (fcLayoutField.getFcAvoidDuplicationDetails().getIsApplyNamingFormat()) {
                    String formatIdList = fcLayoutField.getFcAvoidDuplicationDetails().getFormatIdList();
                    if (formatIdList.length() <= 0) {
                        Long formatId = fcLayoutField.getFcAvoidDuplicationDetails().getFormatId();
                        formatIdList = "[" + String.valueOf(formatId) + "]";
                    }
                    newAttribValue = FcExecuteFormFlow.getAttributeValue(formatIdList, duplicationLevel, attributeName, searchScope, domainDetails, objectClass, domainDNSName, ldapValueProps);
                } else if (fcLayoutField.getFcAvoidDuplicationDetails().getIsAppendingNumber()) {
                    while (isObjectAvailable) {
                        iterationValue = FcExecuteFormFlow.getIterationValue(fcLayoutField.getFcAvoidDuplicationDetails(), startingIndex);
                        newAttribValue = FcExecuteFormFlow.getNewAttributeValue(oldAttribValue, iterationValue, fcLayoutField);
                        if (!searchAttributeValue.startsWith(newAttribValue)) {
                            objectsList = UserMgmtUtil.getADObjectsList((String)duplicationLevel, (String)attributeName, (String)newAttribValue, (String)searchScope, (Properties)domainDetails, (String)objectClass);
                            searchAttributeValue = newAttribValue;
                        }
                        Long l = startingIndex;
                        Long l2 = startingIndex = Long.valueOf(startingIndex + 1L);
                        isObjectAvailable = FcExecuteFormFlow.checkObjectExists(objectsList, attributeName, newAttribValue, domainDNSName);
                    }
                } else if (fcLayoutField.getFcAvoidDuplicationDetails().getStopExecution()) {
                    duplicates.put("stopExecution", true);
                }
            }
            if (attributeName.equalsIgnoreCase("userPrincipalName")) {
                ((FcAttributes)fcLayoutField.getFcAttributeList().get(0)).setAttributeValue((Object)(newAttribValue + "@" + domainDNSName));
                ((FcAttributes)fcLayoutField.getFcAttributeList().get(1)).setAttributeValue((Object)newAttribValue);
                ldapValueProps.put(attributeName, newAttribValue + "@" + domainDNSName);
                ldapValueProps.put(((FcAttributes)fcLayoutField.getFcAttributeList().get(1)).getAttribLdapName(), newAttribValue);
            } else if (!domainDNSName.equals("")) {
                ldapValueProps.put(attributeName, newAttribValue + "@" + domainDNSName);
            } else {
                ldapValueProps.put(attributeName, newAttribValue);
            }
            if (!domainDNSName.equals("")) {
                newAttribValue = newAttribValue + "@" + domainDNSName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        duplicates.put("newAttributeValue", newAttribValue);
        return duplicates;
    }

    private static String getIterationValue(FcAvoidDuplication fcAvoidDuplicationDetails, Long startingIndex) {
        String iterationVal = startingIndex.toString();
        if (fcAvoidDuplicationDetails.getIsAppendCharsSpecified()) {
            Long suffixLength = fcAvoidDuplicationDetails.getSuffixLength();
            String charToBeFilled = fcAvoidDuplicationDetails.getFillingChars();
            int fixedLengthVal = suffixLength.intValue();
            int itLen = iterationVal.length();
            while (itLen < fixedLengthVal) {
                iterationVal = charToBeFilled + iterationVal;
                itLen = iterationVal.length();
            }
            if (itLen >= fixedLengthVal) {
                int startingIndexLen = startingIndex.toString().length();
                iterationVal = iterationVal.substring(0, fixedLengthVal - startingIndexLen);
                iterationVal = iterationVal + startingIndex;
            }
        }
        return iterationVal;
    }

    private static String getNewAttributeValue(String attributeValue, String iterationValue, FcLayoutField fcLayoutField) {
        int attribValLen;
        Integer restrictedLength;
        String newAttribValue = attributeValue + iterationValue;
        Long formatId = FcLayoutUtil.getFormatId((FcLayoutField)fcLayoutField);
        if (formatId != null && (restrictedLength = FormatClientUtil.getNamingFormatRestrictedLength(formatId)) != null && (attribValLen = newAttribValue.length()) > restrictedLength) {
            int endIndex = restrictedLength - iterationValue.length();
            newAttribValue = newAttribValue.substring(0, endIndex) + iterationValue;
        }
        return newAttribValue;
    }

    private static boolean checkObjectExists(ArrayList objectsList, String ldapName, String ldapValue, String domainDNSName) {
        if (!domainDNSName.equals("")) {
            ldapValue = ldapValue + "@" + domainDNSName;
        }
        for (int i = 0; i < objectsList.size(); ++i) {
            Properties prop = (Properties)objectsList.get(i);
            ArrayList valueList = (ArrayList)prop.get(ldapName);
            String value = (String)valueList.get(0);
            if (!value.equalsIgnoreCase(ldapValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectAvailableInAD(String duplicationLevel, String attributeName, String searchScope, Properties domainDetails, String objectClass, String domainDNSName, String newAttribValue) {
        ArrayList objectsList = new ArrayList();
        boolean isObjectAvailable = false;
        objectsList = UserMgmtUtil.getADObjectsList((String)duplicationLevel, (String)attributeName, (String)newAttribValue, (String)searchScope, (Properties)domainDetails, (String)objectClass);
        isObjectAvailable = FcExecuteFormFlow.checkObjectExists(objectsList, attributeName, newAttribValue, domainDNSName);
        return isObjectAvailable;
    }

    public static String getAttributeValue(String formats, String duplicationLevel, String attributeName, String searchScope, Properties domainDetails, String objectClass, String domainDNSName, Properties ldapValueProps) {
        String newAttribValue = "";
        try {
            Long[] longFormatIdList = StrUtil.getLongArrayFromString((JSONArray)new JSONArray(formats));
            JSONObject formatIdVsFormatValue = FormatUtil.getFormatIdVsFormatValue((Long[])longFormatIdList);
            for (Long formatId : longFormatIdList) {
                String formatValue = "";
                if (formatIdVsFormatValue.has(String.valueOf(formatId))) {
                    formatValue = (String)formatIdVsFormatValue.get(String.valueOf(formatId));
                }
                if (FcExecuteFormFlow.isObjectAvailableInAD(duplicationLevel, attributeName, searchScope, domainDetails, objectClass, domainDNSName, newAttribValue = FcExecuteNamingFormat.getFormattedValue(formatValue, formatId, ldapValueProps))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newAttribValue;
    }
}

