/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.formats.AdvancedFormatUtil;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcNamingFormat;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FcExecuteNamingFormat {
    private static Logger log = Logger.getLogger("FcLogger");

    public static String getFormattedValue(Properties ldapVsValueProps, FcNamingFormat fcNamingFormat) {
        String formattedName = "";
        Long formatId = new Long(fcNamingFormat.getFormatId());
        String formatValue = fcNamingFormat.getFormatValue();
        return FcExecuteNamingFormat.getFormattedValue(formatValue, formatId, ldapVsValueProps);
    }

    public static String getFormattedValue(String formatValue, Long formatId, Properties ldapVsValueProps) {
        String formattedName = "";
        try {
            if (formatId != null) {
                String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
                if (formatType.equals("ADVANCED")) {
                    String defaultFormat;
                    String defaultFormattedName;
                    Long defaultFormatId = AdvancedFormatUtil.getDefaultNamingFormatRule((Long)formatId);
                    if ((formatId = FcExecuteNamingFormat.getAdvancedFormatIdValue(formatId, ldapVsValueProps, defaultFormatId, (defaultFormattedName = FcExecuteNamingFormat.getFormatValue(defaultFormat = FormatUtil.getStringColumnValue((String)"ADSMFormats", (String)"FORMAT_ID", (Long)defaultFormatId, (String)"FORMAT_VALUE"), defaultFormatId, ldapVsValueProps)).length())).equals(defaultFormatId)) {
                        formatValue = defaultFormat;
                        formattedName = defaultFormattedName;
                    } else {
                        formatValue = FormatUtil.getStringColumnValue((String)"ADSMFormats", (String)"FORMAT_ID", (Long)formatId, (String)"FORMAT_VALUE");
                    }
                }
                log.log(Level.INFO, " Naming Format Id :" + formatId + " value " + formatValue);
            }
            if (formattedName.length() == 0) {
                formattedName = FcExecuteNamingFormat.getFormatValue(formatValue, formatId, ldapVsValueProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedName;
    }

    public static Long getAdvancedFormatIdValue(Long formatId, Properties ldapVsValueProps, Long defaultFormatId, int defaultFormatLength) {
        Long resultantFormatId = 0L;
        try {
            ArrayList conditionIdList = AdvancedFormatUtil.getCondnIds((Long)formatId);
            for (int conditionIndex = 0; conditionIndex < conditionIdList.size() && resultantFormatId == 0L; ++conditionIndex) {
                Long conditionId = (Long)conditionIdList.get(conditionIndex);
                String matchingCriteria = FormatUtil.getStringColumnValue((String)"ADSMFormatRuleConditions", (String)"CONDITION_ID", (Long)conditionId, (String)"MATCHING_CRITERIA");
                ArrayList criteriaIdList = AdvancedFormatUtil.getConditionCritIds((Long)conditionId);
                Boolean conditionResult = false;
                if (matchingCriteria.equals("AND")) {
                    conditionResult = true;
                }
                for (Long criteriaId : criteriaIdList) {
                    Boolean criteriaResult = null;
                    criteriaResult = FcExecuteNamingFormat.checkCriteria(criteriaId, ldapVsValueProps, defaultFormatLength);
                    if (matchingCriteria.equals("AND")) {
                        conditionResult = conditionResult != false && criteriaResult != false;
                        continue;
                    }
                    if (!matchingCriteria.equals("OR")) continue;
                    conditionResult = conditionResult != false || criteriaResult != false;
                }
                if (!conditionResult.booleanValue()) continue;
                resultantFormatId = AdvancedFormatUtil.getResultantFormatId((Long)conditionId);
            }
            if (resultantFormatId == 0L) {
                resultantFormatId = defaultFormatId;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultantFormatId;
    }

    public static Boolean checkCriteria(Long criteriaId, Properties ldapVsValueProps, int defaultFormatLength) {
        Boolean returnValue = null;
        try {
            Properties criteriaProp = new Properties();
            criteriaProp = AdvancedFormatUtil.getCritprops((Long)criteriaId);
            String attributeName = criteriaProp.getProperty("ATTRIBUTE_NAME");
            String ldapAttribVal = ldapVsValueProps.getProperty(attributeName, "");
            returnValue = AdvancedFormatUtil.getResult((Properties)criteriaProp, (String)ldapAttribVal, (int)defaultFormatLength);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    public static String getFormatValue(String formatName, Long formatId, Properties ldapVsValueProps) {
        return FcExecuteNamingFormat.getFormatValue(formatName, formatId, ldapVsValueProps, false);
    }

    public static String getFormatValue(String formatName, Long formatId, Properties ldapVsValueProps, boolean forCustomScript) {
        String formattedName = formatName;
        String regexForStringContainingANamingFormat = "(.)*([%].+[%])+(.)*";
        String customTxt = "\"%\"";
        formattedName.replaceAll(customTxt, ":PER:");
        if (formatId == null && !formattedName.matches(regexForStringContainingANamingFormat)) {
            return formattedName.replaceAll("(:PER:)", "%");
        }
        if (ldapVsValueProps != null) {
            formattedName = FcExecuteNamingFormat.getFormattedName(formatName, formatId, ldapVsValueProps, new ArrayList<String>(), forCustomScript);
        }
        if (formatId != null) {
            formattedName = FormatUtil.applyFormatRestrictions((Long)formatId, (String)formattedName);
        }
        return formattedName;
    }

    private static String getFormattedName(String format, Long formatId, Properties ldapVsValueProps, ArrayList<String> ldapList, boolean forCustomScript) {
        Long loginId = (Long)ldapVsValueProps.get("loginId");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        log.log(Level.FINE, " format " + format + " ldapVsValue props" + ldapVsValueProps);
        int prevIndex = 0;
        String customTxt = "\"%\"";
        format = format.replaceAll(customTxt, ":PER:");
        int index = format.indexOf("%");
        int length = format.length();
        StringBuffer value = new StringBuffer();
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            if (!forCustomScript) {
                prevStr = prevStr.replaceAll("\"", "");
            }
            if (!prevStr.equals("[L]") && !prevStr.equals("[U]")) {
                value.append(prevStr);
            }
            if (nextIndex != -1) {
                String noOfLetters = "";
                noOfLetters = FormatUtil.getNoOfLetters((String)format, (int)nextIndex, (int)length);
                String ldapName = format.substring(index + 1, nextIndex);
                String attribValue = ldapVsValueProps.getProperty(ldapName);
                if (ldapName.equalsIgnoreCase("accountExpires")) {
                    SimpleDateFormat selectedFormat = DateTimeUtil.getOnlyDateFormat((Long)((Long)ldapVsValueProps.get("loginId")));
                    attribValue = selectedFormat.format(new Date(attribValue));
                }
                if (ldapName.equalsIgnoreCase("rand")) {
                    attribValue = FormatUtil.getRandomNumber((String)noOfLetters);
                }
                if (attribValue == null) {
                    if (ldapName.equalsIgnoreCase("createdTime")) {
                        attribValue = DateTimeUtil.getTimeZoneDate((Long)loginId);
                    }
                    if (ldapName.equalsIgnoreCase("Technician")) {
                        attribValue = rb.getString(HelpdeskUtil.getLoginUserName((Long)loginId));
                    }
                    Enumeration<?> e = ldapVsValueProps.propertyNames();
                    String currentKey = null;
                    while (e.hasMoreElements()) {
                        currentKey = (String)e.nextElement();
                        if (!ldapName.equalsIgnoreCase(currentKey)) continue;
                        attribValue = ldapVsValueProps.getProperty(currentKey);
                        break;
                    }
                }
                log.log(Level.FINE, " Ldap name " + ldapName + " ldap value " + attribValue + " is used in Naming Format ");
                if (attribValue != null && !ldapList.contains(ldapName)) {
                    if (attribValue.indexOf("%") != -1) {
                        ldapList.add(ldapName);
                        attribValue = FcExecuteNamingFormat.getFormattedName(attribValue, formatId, ldapVsValueProps, ldapList, forCustomScript);
                        ldapVsValueProps.setProperty(ldapName, attribValue);
                    }
                    nextIndex = FormatUtil.applyFormatsToAttribute((String)format, (String)attribValue, (String)noOfLetters, (int)nextIndex, (StringBuffer)value);
                } else {
                    value.append("");
                    String actions = FormatUtil.getFormatActionString((String)format, (int)(nextIndex + 1));
                    nextIndex += actions.length();
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex);
        if (!forCustomScript) {
            lastStr = lastStr.replaceAll("\"", "");
        }
        if (!lastStr.equals("[L]") && !lastStr.equals("[U]")) {
            value.append(lastStr);
        }
        String s = value.toString().replaceAll("(:PER:)", "%");
        return s;
    }

    public static ArrayList<String> getAllFormatsForId(Long formatId) {
        ArrayList<String> returnList = new ArrayList<String>();
        try {
            String formatType = AdvancedFormatUtil.getFormatType((Long)formatId);
            Long defaultFormatId = AdvancedFormatUtil.getDefaultNamingFormatRule((Long)formatId);
            returnList.add(FormatUtil.getStringColumnValue((String)"ADSMFormats", (String)"FORMAT_ID", (Long)defaultFormatId, (String)"FORMAT_VALUE"));
            ArrayList<Long> formatIdList = FcExecuteNamingFormat.getAllConditionFormats(formatId);
            for (Long conditionFormatId : formatIdList) {
                String formatValue = FormatUtil.getStringColumnValue((String)"ADSMFormats", (String)"FORMAT_ID", (Long)conditionFormatId, (String)"FORMAT_VALUE");
                if (returnList.contains(formatValue)) continue;
                returnList.add(formatValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnList;
    }

    public static ArrayList<String> getInvolvedLDAPAttributes(Long formatId) {
        ArrayList<String> returnList = new ArrayList<String>();
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMFormatRules", (String)"FORMAT_ID"), (Object)formatId, 0);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMFormatRules"));
        query.addSelectColumn(new Column(null, "*"));
        query.addJoin(new Join("ADSMFormatRules", "ADSMFormatRuleConditions", new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 2));
        query.addJoin(new Join("ADSMFormatRuleConditions", "ADSMFormatRuleCondnCrits", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        query.setCriteria(criteria);
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("ADSMFormatRuleCondnCrits");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String ldapName = (String)r.get("ATTRIBUTE_NAME");
                    if (ldapName == null || returnList.contains(ldapName)) continue;
                    returnList.add(ldapName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnList;
    }

    public static ArrayList<Long> getAllConditionFormats(Long advancedFormatId) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"ADSMFormatRuleConditions", (String)"FORMAT_ID"), (Object)advancedFormatId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRuleConditions", cri);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("ADSMFormatRuleConditions");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long formatId = (Long)r.get("RESULTANT_FORMAT");
                    if (formatId == null || returnList.contains(formatId)) continue;
                    returnList.add(formatId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnList;
    }
}

