/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcGroupModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class FcGroupModificationListener
extends FcADMgmtListener {
    String fullName = "";
    String distinguishedName = "";
    String oldDistinguishedName = "";
    String searchString = "";
    String guid = "";
    ArrayList authorizedOUList = null;
    ArrayList includeGroupOuList = null;
    ArrayList excludeGroupOuList = null;
    HashMap adCrossForestMembersMap = new HashMap();
    ArrayList groupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    String legacyExchangeDN = "";
    String mailNickname = null;
    boolean isMailEnabledGroup = false;
    boolean managerCanUpdateMembers = false;
    boolean isBuiltInGroup = false;
    String modifiedFullName = null;
    String newManagerCanUpdateMembers = null;
    boolean preventDeletion = false;
    String customScriptResult = "";
    Long msExchVersion = 0L;
    ArrayList<Hashtable> customList;
    ArrayList<String> sendAsSIDList = new ArrayList();
    boolean isSendAsListUpdated = false;
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();
    String manager = "";
    String CREATION_STATUS = null;
    String[] mandatoryFields = new String[]{"name", "distinguishedName", "groupType", "legacyExchangeDN", "mailNickname", "targetAddress", "proxyAddresses", "msExchVersion", "managedBy"};
    String[] restrictedFields = new String[]{"msExchAdminGroup"};
    public static int NO_MAIL_GROUP = 0;
    public static int MAIL_ENABLED_GROUP = 1;

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId, null);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.modifyGroup();
    }

    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    @Override
    public void setAuthorizedOUList(ArrayList authorizedOUList) {
        this.authorizedOUList = authorizedOUList;
    }

    @Override
    public void setIncludeGroupOuList(ArrayList includeGroupOuList) {
        this.includeGroupOuList = includeGroupOuList;
    }

    @Override
    public void setExcludeGroupOuList(ArrayList excludeGroupOuList) {
        this.excludeGroupOuList = excludeGroupOuList;
    }

    @Override
    public void restrictFieldsFromEditing(FcFormDataContainer fcLayoutTabFields) {
        Enumeration e = fcLayoutTabFields.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
            for (int i = 0; i < this.restrictedFields.length; ++i) {
                if (!this.restrictedFields[i].equalsIgnoreCase(ldapName)) continue;
                fcLayoutField.setIsRestricted(Boolean.valueOf(true));
                fcLayoutField.setIsAuthorized(Boolean.valueOf(false));
            }
        }
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList<String> temp;
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            if (attribList.contains("sendAs")) {
                this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
                this.isSendAsListUpdated = true;
            }
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            if (this.isSendAsListUpdated) {
                valuesList.put("sendAs", this.sendAsSIDList);
            }
            if (attribList.contains("managerCanUpdateMembers") && !this.manager.equals("")) {
                this.managerCanUpdateMembers = this.getManagerCanUpdateList(this.distinguishedName, this.manager);
                temp = new ArrayList<String>();
                temp.add(String.valueOf(this.managerCanUpdateMembers));
                valuesList.put("managerCanUpdateMembers", temp);
            }
            if (attribList.contains("preventDeletion") && this.distinguishedName != "") {
                this.preventDeletion = ADHandler.getACEsFromDN((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)"preventDeletion", (String)"");
                temp = new ArrayList();
                temp.add(String.valueOf(this.preventDeletion));
                valuesList.put("preventDeletion", temp);
            }
            this.fillMandatoryFields(valuesList);
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSendAsList(ArrayList clientDNList) {
        if (!this.isSendAsListUpdated) {
            this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
            this.isSendAsListUpdated = true;
        }
        ArrayList addSIDList = new ArrayList();
        ArrayList removeSIDList = new ArrayList();
        ArrayList sIDListFromAD = (ArrayList)this.sendAsSIDList.clone();
        ArrayList clientDNListCopy = (ArrayList)clientDNList.clone();
        String sIDString = "";
        for (int i = 0; i < clientDNListCopy.size(); ++i) {
            sIDString = (String)clientDNListCopy.get(i);
            if (!sIDListFromAD.contains(sIDString)) continue;
            sIDListFromAD.remove(sIDString);
            clientDNListCopy.remove(sIDString);
            --i;
        }
        Hashtable resultPropAdd = new Hashtable();
        Hashtable resultPropDelete = new Hashtable();
        String errorMsg = "";
        if (!sIDListFromAD.isEmpty()) {
            resultPropDelete = this.updateSendAsAttribute(sIDListFromAD, this.distinguishedName, "delete");
            errorMsg = this.getErrorStringForSendAs(resultPropDelete, errorMsg);
        }
        if (!clientDNListCopy.isEmpty()) {
            resultPropAdd = this.updateSendAsAttribute(clientDNListCopy, this.distinguishedName, "add");
            errorMsg = this.getErrorStringForSendAs(resultPropAdd, errorMsg);
        }
        if (!errorMsg.equals("")) {
            this.setSendAsErrorMsg(errorMsg);
        }
    }

    public void setSendAsErrorMsg(String testString) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("ERROR_MESSAGE", testString);
        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
        }
        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            prop.put("loginId", loginId);
            prop.put("legacyExchangeDN", this.legacyExchangeDN);
            prop.put("managerCanUpdateMembers", (Object)this.managerCanUpdateMembers);
            prop.put("isBuiltInGroup", (Object)this.isBuiltInGroup);
            prop.put("excludedMembersList", this.excludedMembersList);
            prop.put("adCrossForestMembersMap", this.adCrossForestMembersMap);
            prop.put("groupDetailsTable", this.groupDetailsTable);
            prop.put("preventDeletion", (Object)this.preventDeletion);
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                if (this.memberOfList != null && (fcLayoutField.getComponentId() == 8L || fcLayoutField.getComponentId() == 72L)) {
                    Properties tempProp = new Properties();
                    tempProp.put("memberOf", this.memberOfList);
                    fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, tempProp, prop, showADValue);
                    continue;
                }
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList GroupTypeList;
            ArrayList proxyAddressesValueList;
            ArrayList fullNameValueList;
            ArrayList distinguishedNameValueList;
            ArrayList exchServerVersionList;
            ArrayList mailNicknameValueList;
            String legacyDN;
            int index;
            ArrayList legacyDNValueList = (ArrayList)valuesList.get("legacyExchangeDN");
            if (legacyDNValueList != null && (index = (legacyDN = (String)legacyDNValueList.get(0)).toLowerCase().lastIndexOf("/cn=recipients/cn=")) != -1) {
                this.legacyExchangeDN = legacyDN.substring(0, index);
            }
            if ((mailNicknameValueList = (ArrayList)valuesList.get("mailNickname")) != null) {
                this.mailNickname = (String)mailNicknameValueList.get(0);
            }
            if ((exchServerVersionList = (ArrayList)valuesList.get("msExchVersion")) != null) {
                this.msExchVersion = Long.parseLong((String)exchServerVersionList.get(0));
            }
            if ((distinguishedNameValueList = (ArrayList)valuesList.get("distinguishedName")) != null) {
                this.distinguishedName = (String)distinguishedNameValueList.get(0);
                this.fcNativeProperties.setDN(this.distinguishedName);
            }
            if ((fullNameValueList = (ArrayList)valuesList.get("name")) != null) {
                this.fullName = (String)fullNameValueList.get(0);
            }
            if ((proxyAddressesValueList = (ArrayList)valuesList.get("proxyAddresses")) != null) {
                this.existingProxyAddresses = proxyAddressesValueList;
            }
            if (this.mailNickname != null) {
                this.isMailEnabledGroup = true;
            }
            ArrayList list = (ArrayList)valuesList.get("memberOf");
            this.setMemberOfValues(list);
            this.setMembersValue((ArrayList)valuesList.get("member"));
            ArrayList managerList = (ArrayList)valuesList.get("managedBy");
            if (managerList != null) {
                this.manager = (String)managerList.get(0);
            }
            if ((GroupTypeList = (ArrayList)valuesList.get("groupType")) != null) {
                Long groupTypeValue = Long.parseLong((String)GroupTypeList.get(0));
                this.groupScope = (groupTypeValue & 2L) == 2L ? 2 : ((groupTypeValue & 4L) == 4L ? 4 : 8);
                if ((groupTypeValue & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                    this.groupType = Integer.MIN_VALUE;
                }
                if ((groupTypeValue & 1L) == 1L) {
                    this.isBuiltInGroup = true;
                }
            }
            mgmtLog.log(Level.INFO, " Mail Enabled Group : " + this.isMailEnabledGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMembersValue(ArrayList MembersList) {
        Hashtable<String, ArrayList> includeOUMap = new Hashtable<String, ArrayList>();
        Hashtable<String, ArrayList> includeGroupMap = new Hashtable<String, ArrayList>();
        Hashtable<String, ArrayList> excludeGroupMap = new Hashtable<String, ArrayList>();
        Hashtable<String, ArrayList> excludeOUMap = new Hashtable<String, ArrayList>();
        Hashtable<String, ArrayList> domainOUMap = new Hashtable<String, ArrayList>();
        domainOUMap.put(this.domainName, this.authorizedOUList);
        String foreignSecurityPrincipalContainerDN = "CN=ForeignSecurityPrincipals," + DomainUtil.getDefaultNamingContext((String)this.domainName);
        if (MembersList != null) {
            this.membersList = new ArrayList();
            for (int i = 0; i < MembersList.size(); ++i) {
                String adValue = (String)MembersList.get(i);
                Integer sidIdentifier = null;
                String memberDomainName = null;
                String memberDN = null;
                if (StrUtil.getContainerDNFromDN((String)adValue).equalsIgnoreCase(foreignSecurityPrincipalContainerDN)) {
                    Properties memberProps = CommonUtil.getPropsforFSP((String)adValue, (String)this.domainName);
                    String name = (String)memberProps.get("OBJECT_NAME");
                    memberDN = (String)memberProps.get("DN");
                    this.adCrossForestMembersMap.put(memberDN, name);
                    memberDomainName = DomainUtil.getDomainNamefromDN((String)memberDN);
                } else {
                    memberDN = adValue;
                    memberDomainName = DomainUtil.getDomainNamefromDN((String)memberDN);
                }
                this.membersList.add(memberDN);
                MembersList.set(i, memberDN);
                if (excludeGroupMap.get(memberDomainName) == null) {
                    Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOU((Long)this.loginId, (String)memberDomainName);
                    excludeGroupMap.put(memberDomainName, (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUP"));
                    excludeOUMap.put(memberDomainName, (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_OU"));
                    includeGroupMap.put(memberDomainName, (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUP"));
                    includeOUMap.put(memberDomainName, (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_OU"));
                }
                Boolean isGroup = Boolean.FALSE;
                if (HelpdeskUtil.isExcludedGroup((String)memberDN, (ArrayList)((ArrayList)excludeGroupMap.get(memberDomainName)))) {
                    this.excludedMembersList.add(adValue);
                    isGroup = Boolean.TRUE;
                } else if (HelpdeskUtil.isExcludedGroup((String)memberDN, (ArrayList)((ArrayList)excludeOUMap.get(memberDomainName)))) {
                    sidIdentifier = UserMgmtUtil.getSIDIdentifierFromDN((String)memberDomainName, (String)memberDN);
                    if (sidIdentifier != null && sidIdentifier == 2) {
                        this.excludedMembersList.add(adValue);
                        isGroup = Boolean.TRUE;
                    }
                } else if (HelpdeskUtil.isAuthorizedGroupCheck((String)memberDN, (ArrayList)((ArrayList)includeGroupMap.get(memberDomainName)))) {
                    isGroup = Boolean.TRUE;
                } else if (HelpdeskUtil.isAuthorizedGroupCheck((String)memberDN, (ArrayList)((ArrayList)includeOUMap.get(memberDomainName))) && (sidIdentifier = UserMgmtUtil.getSIDIdentifierFromDN((String)memberDomainName, (String)memberDN)) != null && sidIdentifier == 2) {
                    isGroup = Boolean.TRUE;
                }
                if (isGroup.booleanValue()) continue;
                if (domainOUMap.get(memberDomainName) == null) {
                    domainOUMap.put(memberDomainName, HelpdeskUtil.getOUList((String)memberDomainName, (Long)this.loginId));
                }
                if (HelpdeskUtil.isAuthorizedGroup((String)memberDN, (ArrayList)((ArrayList)domainOUMap.get(memberDomainName)))) continue;
                this.excludedMembersList.add(adValue);
            }
        }
    }

    public void setMemberOfValues(ArrayList MemberOfList) {
        if (MemberOfList != null) {
            this.memberOfList = new ArrayList();
            Hashtable authorizedGroupList = new Hashtable();
            String[] columns = new String[]{"DOMAIN_NAME", "OBJECT_GUID", "DISTINGUISHED_NAME", "SID_STRING", "GROUPTYPE", "GROUP_NAME"};
            authorizedGroupList = MemberOfList.size() > 40 ? this.loadMemberOfData(MemberOfList) : GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)this.loginId, (ArrayList)MemberOfList, (String)"domain", (String[])columns);
            for (String key : authorizedGroupList.keySet()) {
                Properties properties = (Properties)authorizedGroupList.get(key);
                this.memberOfList.add((String)properties.get("DISTINGUISHED_NAME"));
            }
            this.groupDetailsTable = authorizedGroupList;
        }
    }

    @Override
    public int getSelectedSubTab() {
        if (this.isMailEnabledGroup) {
            return MAIL_ENABLED_GROUP;
        }
        return NO_MAIL_GROUP;
    }

    public void modifyGroup() {
        try {
            Properties customScriptProps;
            Hashtable errHash;
            String defaultNamingContext;
            Properties properties;
            mgmtLog.log(Level.INFO, " Group Modification Started ");
            this.isChangesFound = true;
            String STATUS_MESSAGE = "";
            boolean isModuleLicensed = LicenseMgr.getInstance().isModuleLicensed("Group Management");
            if (!isModuleLicensed) {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("ERROR_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
            FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.groupModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, this.loginId, this.guid, this.domainName, this.executeFormLayout, this);
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            customFieldsContainer.splitCustomFields(modifiedFieldsContainer);
            FcGroupModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
            FcGroupModificationMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            if (this.isFieldModified("memberOf", modifiedFieldsContainer) && !this.isFieldModified("memberOf", this.adData) || this.isFieldModified("member", modifiedFieldsContainer) && !this.isFieldModified("member", this.adData)) {
                FcFormDataContainer tempModFieldsContainer = new FcFormDataContainer();
                if (this.isFieldModified("memberOf", modifiedFieldsContainer) && !this.isFieldModified("memberOf", this.adData)) {
                    tempModFieldsContainer.put((Object)3111L, modifiedFieldsContainer.get((Object)3111L));
                }
                if (this.isFieldModified("member", modifiedFieldsContainer) && !this.isFieldModified("member", this.adData)) {
                    tempModFieldsContainer.put((Object)3109L, modifiedFieldsContainer.get((Object)3109L));
                }
                this.getADValues(FcExecuteActionConstants.groupModificationTemplateCategoryId, tempModFieldsContainer, this.adData, this.loginId);
            }
            FcGroupModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcGroupModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
            FcGroupModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            FcGroupModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            Properties domainProp = new Properties();
            domainProp.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcGroupModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
            ldapVsValueProps = FcGroupModificationMgmtHandler.getInstance().getLdapVsValuesFromAD(this.fieldValueList, ldapVsValueProps);
            this.customList = this.getCustomAttribsProperties(customFieldsContainer, true, ldapVsValueProps, "group");
            ArrayList propList = this.fcNativeProperties.getPropList();
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.addAttributeToNativeProps(modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, "group");
            Properties props = fcNativeProperties.getProps();
            this.groupList = fcNativeProperties.getGroupList();
            this.nativeStatusProps = new Properties();
            if (props.get("OUName") != null) {
                String OUName = (String)props.get("OUName");
                if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)OUName)) {
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), OUName));
                    return;
                }
                String newdistinguishedName = "CN=" + CommonUtil.escapeString((String)this.fullName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + OUName;
                if (!this.distinguishedName.equals(newdistinguishedName)) {
                    this.oldDistinguishedName = this.distinguishedName;
                    try {
                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)this.oldDistinguishedName, (String)OUName);
                        this.distinguishedName = newdistinguishedName;
                        STATUS_MESSAGE = this.rb.getString("admp.mgmt.common.statmsg.successfully_updated");
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("usermanagement.messages.unable_modify_group"), le.getMessage(this.rb)));
                        hash.put("NATIVE_ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_group.statmsg.error_moving_group"), le.getMessage(this.rb)));
                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                        }
                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String searchDN = this.distinguishedName;
            this.searchString = "(&(objectClass=group)(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)this.distinguishedName) + "))";
            mgmtLog.log(Level.INFO, " Group Modification : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " Group Name :" + this.fullName);
            mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            mgmtLog.log(Level.INFO, " customList " + this.customList);
            mgmtLog.log(Level.INFO, " crossForestMembersList " + this.crossForestMembersList);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.fullName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("groupList", this.groupList);
            this.auditLogProps.put("customList", this.customList);
            this.auditLogProps.put("crossForestMembersList", this.crossForestMembersList);
            if (props.get("customScriptDetails") != null) {
                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
            }
            if (props.get("preventDeletion") != null) {
                this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
            }
            if (fcNativeProperties.getPropList().size() > 0 || this.groupList.size() > 0 || this.customList.size() > 0 || modifiedFieldsContainer.size() > 0) {
                properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                String s = searchDN.toLowerCase();
                if (HelpdeskUtil.isExcludedGroup((String)s, (ArrayList)this.excludeGroupOuList) || !HelpdeskUtil.isAuthorizedGroup((String)s, (ArrayList)this.includeGroupOuList)) {
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("usermanagement.messages.unable_modify_group"), this.rb.getString("client.reports.ReportMgmtHandler.access_denied")));
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    }
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    return;
                }
                String containerName = DirectoryObjectUtil.getOUNameFromDN((String)searchDN);
                this.modifyGroupAction(fcNativeProperties, props, this.customList, containerName);
            } else {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                STATUS_MESSAGE = STATUS_MESSAGE.equals("") ? this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found") : STATUS_MESSAGE;
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", STATUS_MESSAGE);
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.isChangesFound = false;
            }
            if (!this.crossForestMembersList.isEmpty() && (errHash = this.addCrossForestMembers(this.distinguishedName, this.nativeStatusProps)) == null) {
                String statusMessage = this.rb.getString("admp.mgmt.common.statmsg.successfully_updated");
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", statusMessage);
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            }
            if (!this.toBeRemovedGroupList.isEmpty()) {
                String defaultNamingContext2 = DomainUtil.getDefaultNamingContext((String)this.domainName);
                ArrayList groupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)defaultNamingContext2);
                ArrayList<Properties> list = new ArrayList<Properties>();
                Properties p = new Properties();
                p.put("ATTRIB_VALUE", this.distinguishedName);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_LDAP_NAME", "member");
                p.put("DW_CONTROL_CODE", new Long(4L));
                list.add(p);
                for (int i = 0; i < this.toBeRemovedGroupList.size(); ++i) {
                    Properties prop = UserMgmtUtil.getPropertiesfromDN((String)((String)this.toBeRemovedGroupList.get(i)), (ArrayList)groupList);
                    String groupSid = null;
                    if (prop != null) {
                        groupSid = UserMgmtUtil.getGroupSIDfromRID((String)((String)prop.get("objectRID")), (ArrayList)groupList);
                    }
                    if (groupSid == null) continue;
                    try {
                        ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)groupSid, (String)this.distinguishedName, list, null);
                        continue;
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout.error_while_removing_group"), (String)prop.get("Display_Name")));
                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                        }
                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
            }
            this.setManagerCanUpdateList(props);
            if (props.getProperty("userName") != null && !props.getProperty("userName").equals("")) {
                this.modifiedFullName = props.getProperty("userName");
                mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + props.getProperty("userName") + " for the User : " + this.distinguishedName);
                try {
                    ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)this.modifiedFullName, null);
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                    this.distinguishedName = "CN=" + this.modifiedFullName + "," + StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_group.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    }
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (props.get("sendAs") != null) {
                this.setSendAsList((ArrayList)props.get("sendAs"));
            }
            this.CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (props.get("preventDeletion") != null) {
                properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                if (Boolean.valueOf(props.get("preventDeletion").toString()).booleanValue()) {
                    grpList.put("ATTRIB_VALUE", "true");
                    String rootName = StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                    this.updatePreventDeletion(this.distinguishedName, "add");
                    if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                        this.updateParent(rootName);
                    }
                } else {
                    grpList.put("ATTRIB_VALUE", "false");
                    this.updatePreventDeletion(this.distinguishedName, "delete");
                }
                propList.add(grpList);
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (this.CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && this.CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                }
            }
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
        }
    }

    private void modifyGroupAction(FcNativeProperties fcNativeProperties, Properties props, ArrayList customList, String containerDN) {
        boolean usePowerShell = false;
        Integer exchType = 0;
        boolean updatePolicy = false;
        String hideAddressBook = (String)props.get("msExchHideFromAddressLists");
        Properties domainProp = new Properties();
        domainProp.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcGroupModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
        String policyIncluded = (String)ldapVsValueProps.get("msExchPoliciesExcluded");
        if (this.legacyExchangeDN != null && ExchangeUtil.checkExchangeGroup2007((String)this.legacyExchangeDN, (String)this.domainName)) {
            usePowerShell = true;
        }
        if (props.get("msExchPoliciesIncluded") != null && props.get("msExchPoliciesIncluded").equals("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}") && usePowerShell) {
            updatePolicy = true;
        }
        Properties exchangeServerDetails = null;
        if (usePowerShell) {
            String exchVersion = ExchangeUtil.getExchangeVersion((Long)this.msExchVersion);
            exchangeServerDetails = ExchangeUtil.getExchangeServerDetails((String)this.domainName, (String)exchVersion);
            exchType = ExchangeUtil.getExchType((String)exchVersion);
        }
        try {
            String hideFromAddrListErr;
            this.statusObject = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)containerDN, (String)this.searchString, null, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)this.groupList, (boolean)false);
            this.nativeStatusProps = this.getSingleGroupErrorMessage(this.statusObject);
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                NativeError customError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)containerDN, (String)this.searchString, null, (ArrayList)customList, new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                }
            }
            if (updatePolicy && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
            }
            if ((hideAddressBook != null && exchType == 2013 || props.get("msExchPoliciesIncluded") == null && props.get("mailAlias") != null && policyIncluded.equalsIgnoreCase("true")) && usePowerShell && this.msExchVersion != 0L && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)"group", (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")))).trim().length() > 0) {
                this.setNativeStatusProps(hideFromAddrListErr, "", "", "");
            }
            mgmtLog.log(Level.INFO, " Group Modification Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setNativeStatusProps(String message, String status, String image, String messageStyle) {
        ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", message);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        if (!image.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_IMAGE", image);
        }
        if (!status.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_STATUS", status);
        }
        if (!messageStyle.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", messageStyle);
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer modifiedFieldsContainer, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps, String objectClass1) throws Exception {
        this.getProperties(true, modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, objectClass1);
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        try {
            ArrayList creationMsg;
            Properties grpList;
            Properties props = this.fcNativeProperties.getProps();
            request.setAttribute("statusProps", (Object)this.nativeStatusProps);
            if (!(this.isChangesFound || this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0 || this.fcNativeProperties.getModifyList() != null && this.fcNativeProperties.getModifyList().size() != 0 || this.fcNativeProperties.getTsList() != null && this.fcNativeProperties.getTsList().size() != 0 || this.fcNativeProperties.getWinNTAttributeList() != null && this.fcNativeProperties.getWinNTAttributeList().size() != 0 || this.groupList != null && this.groupList.size() != 0 || this.customList != null && this.customList.size() != 0)) {
                return;
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)4002, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)this.moduleUsed, (Long)this.requestId);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.fullName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
            if (this.groupList != null && !this.groupList.isEmpty()) {
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedGroup : this.groupList) {
                    modifiedMemberOfValues.add(addedGroup);
                }
            }
            if (this.toBeRemovedGroupList != null && !this.toBeRemovedGroupList.isEmpty()) {
                String removedHeading = (modifiedMemberOfValues.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedMemberOfValues.add(removedHeading);
                for (String removedGroup : this.toBeRemovedGroupList) {
                    modifiedMemberOfValues.add(removedGroup);
                }
            }
            ArrayList<String> modifiedMemberValues = new ArrayList<String>();
            if (this.addedMembersList != null && !this.addedMembersList.isEmpty()) {
                modifiedMemberValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedObject : this.addedMembersList) {
                    modifiedMemberValues.add(addedObject);
                }
            }
            if (this.crossForestMembersList != null && !this.crossForestMembersList.isEmpty()) {
                if (modifiedMemberValues.isEmpty()) {
                    modifiedMemberValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                }
                for (String addedObject : this.crossForestMembersDNList) {
                    modifiedMemberValues.add(addedObject);
                }
            }
            if (this.toBeRemovedMembersList != null && !this.toBeRemovedMembersList.isEmpty()) {
                String removedHeading = (modifiedMemberValues.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedMemberValues.add(removedHeading);
                for (String removedObject : this.toBeRemovedMembersList) {
                    modifiedMemberValues.add(removedObject);
                }
            }
            ArrayList<String> movedGroupAudit = new ArrayList<String>();
            if (!this.oldDistinguishedName.equals("")) {
                String ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.oldDistinguishedName);
                String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + "</B><br/>" + ouname;
                ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + "</B><br/>" + ouname;
                movedGroupAudit.add(movedFrom);
                movedGroupAudit.add(movedTo);
            }
            if (!movedGroupAudit.isEmpty()) {
                Properties movedList = new Properties();
                movedList.put("ATTRIB_LDAP_NAME", "container");
                movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                movedList.put("ATTRIB_VALUE", movedGroupAudit);
                propList.add(movedList);
            }
            if (!modifiedMemberOfValues.isEmpty()) {
                grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedMemberOfValues);
                propList.add(grpList);
            }
            if (!modifiedMemberValues.isEmpty()) {
                grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "member");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedMemberValues);
                propList.add(grpList);
            }
            if (this.modifiedFullName != null) {
                Properties nameList = new Properties();
                nameList.put("ATTRIB_LDAP_NAME", "name");
                nameList.put("ATTRIB_VALUE", this.modifiedFullName);
                propList.add(nameList);
            }
            if (this.newManagerCanUpdateMembers != null) {
                Properties prop = new Properties();
                prop.put("ATTRIB_LDAP_NAME", "managerCanUpdateMembers");
                prop.put("ATTRIB_VALUE", this.newManagerCanUpdateMembers);
                propList.add(prop);
            }
            if (props.get("customScriptDetails") != null) {
                grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            if (!this.customList.isEmpty()) {
                ArrayList<String> customAttributeList = new ArrayList<String>();
                for (Hashtable customAttribute : this.customList) {
                    String ldapVsValue = (String)customAttribute.get("ATTRIB_LDAP_NAME") + " : " + customAttribute.get("ATTRIB_VALUE") + "<br/>";
                    customAttributeList.add(ldapVsValue);
                }
                Properties customAuditList = new Properties();
                customAuditList.put("ATTRIB_LDAP_NAME", "customAttributes");
                customAuditList.put("ATTRIB_VALUE_COUNT", (Object)customAttributeList.size());
                customAuditList.put("ATTRIB_VALUE", customAttributeList);
                propList.add(customAuditList);
            }
            if (props.get("sendAs") != null) {
                ArrayList sIDList = (ArrayList)props.get("sendAs");
                ArrayList<String> dNList = new ArrayList<String>();
                ArrayList remainingSIDs = (ArrayList)sIDList.clone();
                String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                String[] requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                String criteriaColumn = "SID_STRING";
                ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                for (int i = 0; i < dbValuesList.size(); ++i) {
                    Properties dbValueProp = (Properties)dbValuesList.get(i);
                    dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                    remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                }
                if (!remainingSIDs.isEmpty()) {
                    dNList.addAll(remainingSIDs);
                }
                Properties sendAsProps = new Properties();
                sendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                sendAsProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.send_as"));
                sendAsProps.put("ATTRIB_VALUE", dNList);
                propList.add(sendAsProps);
            }
            Long tid = new Long(request.getParameter("templateId"));
            Properties propToAudit = new Properties();
            propToAudit.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
            propToAudit.put("ATTRIB_VALUE", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            propList.add(propToAudit);
            request.setAttribute("statusProps", (Object)this.nativeStatusProps);
            request.setAttribute("customScriptResult", (Object)this.customScriptResult);
            String statusMessage = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
            if (statusMessage == null) {
                statusMessage = "";
            }
            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
            }
            if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                        statusMessage = statusMessage + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                    }
                    statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                    if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                    statusMessage = statusMessage + creationMessage.get("NATIVE_ERROR_MESSAGE");
                }
            }
            TechAuditAPI.getInstance().auditGroupModification(this.loginId, this.rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.mgmtname.mod_sing_group"), this.fullName, this.domainName, propList, this.fcNativeProperties.getModifyList(), null, statusMessage, object_id, auditDataObj, this.rb);
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            if (!this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"Group"}, (boolean)false);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 2;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.GROUP_MODIFICATION_MANAGED_BY_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.GROUP_MODIFICATION_MANAGED_BY_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.GROUP_MODIFICATION_MANAGED_BY_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BGC_LAYOUT_VIEW_ID;
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(ouName);
                this.triggerNotifiation(audit_id, object_id, this.fullName, manager, null, userObjectId, ReportsUtil.SINGLE_GROUP_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public Properties getSingleGroupErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String errStatusMessage = this.rb.getString("admp.mgmt.common.statmsg.updated_with_errors");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", errStatusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private Boolean getManagerCanUpdateList(String distinguishedName, String managerDN) {
        Boolean returnValue = false;
        try {
            String managerSid = UserMgmtUtil.getSIDFromDN((String)this.domainName, (String)managerDN);
            if (managerSid == null) {
                managerSid = UserMgmtUtil.getSIDFromDNGeneral((String)managerDN);
            }
            if (managerSid == null && managerDN != null && !managerDN.isEmpty()) {
                String managerDomainName = DomainUtil.getDomainNamefromDN((String)managerDN);
                if (managerDomainName == null || managerDomainName.isEmpty()) {
                    return Boolean.FALSE;
                }
                ArrayList<String> attrList = new ArrayList<String>();
                attrList.add("objectSid");
                Properties domainProps = ADHandler.getDomainDetails((String)managerDomainName, (Long)1L);
                String searchString = "(distinguishedName=" + managerDN + ")";
                ArrayList managerPropList = ADHandler.getObjectsWithOutListener((Properties)domainProps, (String)((String)domainProps.get("DEFAULT_NAMING_CONTEXT")), attrList, (String)searchString);
                if (managerPropList != null && managerPropList.size() > 0) {
                    Properties prop = (Properties)managerPropList.get(0);
                    managerSid = StrUtil.getString((Properties)prop, (String)"objectSid");
                }
            }
            if (managerSid == null) {
                mgmtLog.log(Level.INFO, "manager sid is null for managerDN: " + managerDN + " for group: " + this.fullName);
                return Boolean.FALSE;
            }
            String[] trusteeToFilter = new String[]{managerSid};
            returnValue = ADHandler.getACEsFromDN((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)"managerCanUpdateMembers", (String)managerSid);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return returnValue;
    }

    private void setManagerCanUpdateList(Properties props) {
        try {
            boolean removePreviousManagerPermission = false;
            boolean addCurrentManagerPermission = false;
            String newManager = (String)props.get("manager");
            this.newManagerCanUpdateMembers = (String)props.get("managerCanUpdate");
            if (this.newManagerCanUpdateMembers != null) {
                if (this.newManagerCanUpdateMembers.equalsIgnoreCase("true")) {
                    addCurrentManagerPermission = true;
                } else {
                    removePreviousManagerPermission = true;
                }
            }
            if (newManager != null && this.newManagerCanUpdateMembers == null && this.managerCanUpdateMembers) {
                addCurrentManagerPermission = true;
                removePreviousManagerPermission = true;
            }
            if (removePreviousManagerPermission && !this.manager.equals("")) {
                this.updateManagerCanUpdateMembers(this.manager, this.distinguishedName, "delete");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
            }
            if (addCurrentManagerPermission) {
                if (newManager != null) {
                    this.updateManagerCanUpdateMembers(newManager, this.distinguishedName, "add");
                } else if (!this.manager.equals("")) {
                    this.updateManagerCanUpdateMembers(this.manager, this.distinguishedName, "add");
                }
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isAuthorizedObject() {
        return !HelpdeskUtil.isExcludedGroup((String)this.distinguishedName, (ArrayList)this.excludeGroupOuList) && HelpdeskUtil.isAuthorizedGroup((String)this.distinguishedName, (ArrayList)this.includeGroupOuList);
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

