/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.LocaleThreadLocal;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPAuthUtil;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcDefaultLayout;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutFieldGroup;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutSubTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.dataprovider.IDataProvider;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcLayoutClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FcLayoutAction
extends DispatchAction {
    Logger logg = Logger.getLogger("FcLogger");

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String templateCategoryId = request.getParameter("templateCategoryId") != null ? request.getParameter("templateCategoryId") : FcExecuteActionConstants.defaultTemplateCategoryId.toString();
        request.setAttribute("templateCategoryId", (Object)templateCategoryId);
        request.setAttribute("operation", (Object)request.getParameter("operation"));
        return mapping.findForward("layoutPage");
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = "layout";
        return mapping.findForward(forward);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Save Layout Called");
        String saveMessage = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        String action = fcExecuteFormBean.getAction();
        try {
            String layoutDetailsStr = request.getParameter("layoutDetails");
            JSONObject layoutDetailsJsonObj = new JSONObject(layoutDetailsStr);
            String layoutName = layoutDetailsJsonObj.getString("layoutName");
            String domainName = layoutDetailsJsonObj.getString("domainName");
            String description = layoutDetailsJsonObj.getString("description");
            Integer defaultValue = new Integer(layoutDetailsJsonObj.getInt("defaultValue"));
            JSONArray selectedIamAppsJsonArray = layoutDetailsJsonObj.getJSONArray("selectedIamApps");
            String fcLayoutJsonStr = request.getParameter("FcLayoutJsonStr");
            String mgmtRuleJsonStr = request.getParameter("MgmtRuleJsonStr");
            FcLayout fcRhsLayout = new FcLayout();
            if (fcLayoutJsonStr == null) {
                fcRhsLayout = fcExecuteFormBean.getExecuteFormLayout();
                if (!fcRhsLayout.getDomainName().equals(domainName)) {
                    FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
                    fcFormDataContainer.init(fcRhsLayout);
                    FcExecuteFormFlow.setDomainSpecificFieldValues(FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode()), fcFormDataContainer, domainName, rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
                }
            } else {
                JSONObject fcLayoutJsonObj = new JSONObject(fcLayoutJsonStr);
                fcRhsLayout.init(fcLayoutJsonObj);
            }
            fcRhsLayout.setDomainName(domainName);
            fcRhsLayout.setLayoutName(layoutName);
            fcRhsLayout.setDescription(description);
            fcRhsLayout.setModifiedTime(Long.valueOf(new Date().getTime()));
            fcRhsLayout.setDefaultValue(defaultValue);
            fcRhsLayout.setSelectedIamAppsJsonArray(selectedIamAppsJsonArray);
            if ("update".equalsIgnoreCase(action) && FcLayoutViewHandler.isSystemDefaultLayout((Long)fcRhsLayout.getLayoutId())) {
                this.logg.log(Level.INFO, "ERROR: trying to update system default template. Possible reason is template creation and modification  is used in different tab in the same browser simultaneously ");
                saveMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_error_occurred_while_saving_the_template");
            } else {
                Long layoutId = FcLayoutUpdateHandler.saveLayout((FcLayout)fcRhsLayout, (String)action, (Long)loginId);
                if (mgmtRuleJsonStr != null) {
                    MgmtRuleHandler.saveMgmtRule((String)mgmtRuleJsonStr, (Long)layoutId, (String)fcRhsLayout.getDomainName(), (Long)fcRhsLayout.getTemplateCategoryId(), (String)action);
                }
                FcLayoutUpdateHandler.changeDomainForDefaultTemplate((long)fcExecuteFormBean.getTemplateCategoryId(), (long)layoutId, (String)fcRhsLayout.getDomainName());
                saveMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_successfully_saved_the_template") + " '" + fcRhsLayout.getLayoutName() + "'";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            saveMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_error_occurred_while_saving_the_template");
        }
        request.setAttribute("saveMessage", (Object)saveMessage);
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, fcExecuteFormBean.getActionId());
        request.setAttribute("templateList", (Object)FcLayoutViewHandler.getTemplates((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (String)"LAYOUT_NAME", (Boolean)true, (Long)fcExecuteFormBean.getTemplateCategoryId(), null, domainList));
        ArrayList defaultLayoutIdList = FcLayoutViewHandler.getAuthorizedDefaultLayoutIdList((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (boolean)fcExecuteFormBean.getIsWorkFlowMode());
        request.setAttribute("defaultLayoutId", (Object)defaultLayoutIdList);
        request.setAttribute("sortColumn", (Object)"LAYOUT_NAME");
        request.setAttribute("isAscending", (Object)true);
        request.setAttribute("domainList", domainList);
        return mapping.findForward("viewFcTemplateList");
    }

    public ActionForward createField(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fcLayoutFieldJsonStr = request.getParameter("FcLayoutFieldJsonStr");
        try {
            JSONObject fcLayoutFieldJsonObj = new JSONObject(fcLayoutFieldJsonStr);
            FcLayoutField fcRhsField = new FcLayoutField();
            fcRhsField.init(fcLayoutFieldJsonObj);
            request.setAttribute("FcLayoutField", (Object)fcRhsField);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("createField");
    }

    public ActionForward checkLayoutName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " check Layout Name Called");
        String templateName = request.getParameter("templateName");
        response.setContentType("application/json");
        try {
            FcLayout fcLayout;
            boolean isAvailable = true;
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templatecategoryId = fcExecuteFormBean.getTemplateCategoryId();
            String action = fcExecuteFormBean.getAction();
            isAvailable = "Update".equals(action) ? ((fcLayout = fcExecuteFormBean.getExecuteFormLayout()).getLayoutName().equalsIgnoreCase(templateName) ? false : FcLayoutViewHandler.isTemplateAvailable((String)templateName, (Long)templatecategoryId)) : FcLayoutViewHandler.isTemplateAvailable((String)templateName, (Long)templatecategoryId);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("isTemplateAvailable", isAvailable);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward fillComponentValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Fill Component Values Called");
        String fcLayoutFieldJsonStr = request.getParameter("FcLayoutFieldJsonStr");
        response.setContentType("application/json");
        try {
            JSONObject fcLayoutFieldJsonObj = new JSONObject(fcLayoutFieldJsonStr);
            FcLayoutField fcRhsField = new FcLayoutField();
            fcRhsField.init(fcLayoutFieldJsonObj);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            if (fcRhsField.getIsDomainSpecificField().booleanValue()) {
                Locale locale = request.getLocale();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
                this.logg.log(Level.INFO, "Going to set the Default Value -- Field Name : " + fcRhsField.getAttribDisplayText());
                String providerClassName = fcRhsField.getDomainSpecificDataProviderClassName();
                Class<?> domainSpecificDataProviderClass = Class.forName(providerClassName);
                IDataProvider iDataProvider = (IDataProvider)domainSpecificDataProviderClass.newInstance();
                Long componentId = fcRhsField.getComponentId();
                Hashtable dpValues = FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)fcExecuteFormBean.getDomainName(), (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode());
                dpValues.put("templateCategoryId", fcExecuteFormBean.getTemplateCategoryId());
                iDataProvider.setDefaultValue(dpValues, fcRhsField.getIComponent(), componentId.intValue(), fcExecuteFormBean.getDomainName(), rb, loginId);
            }
            PrintWriter writer = response.getWriter();
            writer.print(fcRhsField.serializeToJsonObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward createFieldGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Create Field Group Called");
        String fcLayoutFieldGroupJsonStr = request.getParameter("FcLayoutFieldGroupJsonStr");
        try {
            JSONObject fcLayoutFieldGroupJsonObj = new JSONObject(fcLayoutFieldGroupJsonStr);
            FcLayoutFieldGroup fcRhsFieldGroup = new FcLayoutFieldGroup();
            fcRhsFieldGroup.init(fcLayoutFieldGroupJsonObj);
            request.setAttribute("FcLayoutFieldGroup", (Object)fcRhsFieldGroup);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mapping.findForward("createFieldGroup");
    }

    public ActionForward createTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Create Tab Called");
        request.setAttribute("tabId", (Object)request.getParameter("tabId"));
        request.setAttribute("tabName", (Object)request.getParameter("tabName"));
        return mapping.findForward("createTab");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, "Editing Layout Started ");
        this.logg.log(Level.INFO, " " + request.getParameter("paramName"));
        String paramvalue = request.getParameter("paramName").toString();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = new JSONObject(paramvalue);
            Long l = jsonObject.getLong("id");
            String empty = jsonObject.getString("empty");
            String paramName = jsonObject.getString("paramName");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.logg.log(Level.INFO, " " + jsonObject.toString());
        return null;
    }

    public ActionForward copyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logg.log(Level.INFO, "Going to copy Layout");
        String forwardPage = "viewFcTemplateList";
        String layoutId = request.getParameter("layoutId");
        String newLayoutName = request.getParameter("newLayoutName");
        String statusMessage = "";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
        JSONObject jsonObj = new JSONObject();
        try {
            if (layoutId != null && !FcLayoutViewHandler.isTemplateAvailable((String)newLayoutName, (Long)templateCategoryId)) {
                FcLayoutUpdateHandler.copyLayout((Long)new Long(layoutId), (String)newLayoutName, (Long)loginId);
                statusMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_successfully_saved_the_template") + " '" + EscapeUtil.escSplCharsAsHTML((Object)newLayoutName) + "'";
            } else {
                statusMessage = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.template_same_name_already_exists");
            }
            jsonObj.put("statusMessage", (Object)statusMessage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            statusMessage = rb.getString(ex.getMessage());
            jsonObj.put("statusMessage", (Object)statusMessage);
        }
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward deleteTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, "Going to delete Layout");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String layoutId = request.getParameter("layoutId");
            if (layoutId != null) {
                FcLayoutUpdateHandler.deleteLayout((Long)new Long(layoutId));
            }
            String statusMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_successfully_deleted_the_template");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("statusMessage", (Object)statusMessage);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward showTemplateDependentsList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String statusMessage = rb.getString("admp.mgmt.user_mgmt.cre_template.alert_delete_template_used_in_workflow");
            JSONObject jsonObj = new JSONObject();
            JSONObject associatedObj = new JSONObject();
            jsonObj.put("statusMessage", (Object)statusMessage);
            String wfList = FcLayoutClientUtil.getWFList(request.getParameter("layoutId"));
            String automationPolicyList = FcLayoutClientUtil.getAutomationPolicyList(request.getParameter("layoutId"));
            String automationList = FcLayoutClientUtil.getAutomationList(request.getParameter("layoutId"));
            if (!wfList.equals("")) {
                associatedObj.put(rb.getString("admp.common.text.workflow"), (Object)wfList);
            }
            if (!automationPolicyList.equals("")) {
                associatedObj.put(rb.getString("admp.auto.auto_policy.heading.automation_policy"), (Object)automationPolicyList);
            }
            if (!automationList.equals("")) {
                associatedObj.put(rb.getString("admp.common.text.automation"), (Object)automationList);
            }
            jsonObj.put("tableRows", (Object)associatedObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward setDefaultTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, "Going to set default template");
        String statusMessage = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String layoutId = request.getParameter("layoutId");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long templateCategoryId = new Long(request.getParameter("templateCategoryId"));
            if (layoutId != null) {
                statusMessage = FcLayoutUpdateHandler.toggleDefaultLayoutId((long)loginId, (long)templateCategoryId, (long)new Long(layoutId));
            }
            statusMessage = rb.getString(statusMessage);
            ArrayList defaultTemplateList = FcLayoutViewHandler.getAuthorizedDefaultLayoutIdList((Long)loginId, (Long)templateCategoryId, (boolean)false);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("statusMessage", (Object)statusMessage);
            jsonObj.put("defaultTemplateList", (Object)defaultTemplateList);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward fcRhsLayoutTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Get Single Tab Html method in FcLayoutAction started");
        String fcLayoutJsonStr = request.getParameter("tab").toString();
        FcLayoutTab fcRhsLayoutTab = new FcLayoutTab();
        try {
            JSONObject fcLayoutTabJsonObj = new JSONObject(fcLayoutJsonStr);
            fcRhsLayoutTab.init(fcLayoutTabJsonObj);
            request.setAttribute("FcLayoutTab", (Object)fcRhsLayoutTab);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mapping.findForward("fcRhsLayoutTab");
    }

    public ActionForward getSupportedComponents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fieldId_str = request.getParameter("fieldId");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        response.setContentType("application/json");
        try {
            PrintWriter writer = response.getWriter();
            writer.print(FcLayoutViewHandler.getSupportedComponents((String)fieldId_str, (AdventNetResourceBundle)rb));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward templatesList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Template List Action started");
        String forwardPage = "viewFcTemplateList";
        Long templateCategoryId = FcExecuteActionConstants.defaultTemplateCategoryId;
        String domainName = null;
        try {
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            if (fcExecuteFormBean == null) {
                fcExecuteFormBean = new FcExecuteFormBean();
                session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            }
            fcExecuteFormBean.initForTemplatesList(request);
            templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, fcExecuteFormBean.getActionId());
            if (LicenseMgr.getInstance().isFreeEdition()) {
                domainName = domainList.get(0);
            }
            request.setAttribute("domainList", domainList);
            request.setAttribute("domainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logg.log(Level.INFO, " Template List Action finished");
        return mapping.findForward(forwardPage);
    }

    public ActionForward templatesListRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Template List Action started");
        String forwardPage = "viewFcTemplateListRows";
        Boolean isAscending = true;
        String sortColumn = "LAYOUT_NAME";
        Long templateCategoryId = FcExecuteActionConstants.defaultTemplateCategoryId;
        String domainName = null;
        String searchText = "";
        Boolean isAllDomainSelected = Boolean.FALSE;
        Boolean isNavigation = Boolean.TRUE;
        try {
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            if (fcExecuteFormBean == null) {
                fcExecuteFormBean = new FcExecuteFormBean();
                session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            }
            fcExecuteFormBean.initForTemplatesList(request);
            templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, fcExecuteFormBean.getActionId());
            JSONObject params = new JSONObject(request.getParameter("params"));
            if (params.has("ascending")) {
                isAscending = new Boolean(params.getString("ascending"));
            }
            if (params.has("isAllDomainSelected")) {
                isAllDomainSelected = new Boolean(params.getString("isAllDomainSelected"));
            }
            if (params.has("isNavigation")) {
                isNavigation = new Boolean(params.getString("isNavigation"));
            }
            if (params.has("sortColumn")) {
                sortColumn = new String(params.getString("sortColumn"));
            }
            if (params.has("searchText")) {
                searchText = new String(params.getString("searchText"));
            }
            ArrayList<String> selectedDomainList = new ArrayList<String>();
            if (request.getParameter("selectedDomains") != null && !isAllDomainSelected.booleanValue()) {
                String selectedDomains = request.getParameter("selectedDomains");
                JSONArray jsonArray = new JSONArray(selectedDomains);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    selectedDomainList.add(jsonArray.getString(i));
                }
            }
            ArrayList<Long> selectedTemplatesList = new ArrayList<Long>();
            if (request.getParameter("selectedTemplatesList") != null) {
                String selectedtemplateStr = request.getParameter("selectedTemplatesList");
                JSONArray jsonArray = new JSONArray(selectedtemplateStr);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    selectedTemplatesList.add(new Long(jsonArray.getString(i)));
                }
            }
            if (LicenseMgr.getInstance().isFreeEdition()) {
                domainName = domainList.get(0);
            }
            Integer range = null;
            if (params.has("range")) {
                range = new Integer(params.getString("range"));
                NavigateRangeUtil.setDefaultRange((String)"UserTemplates", (int)range, (Long)loginId);
                request.setAttribute("range", (Object)range);
            }
            Integer startIndex = null;
            if (params.has("startIndex")) {
                startIndex = new Integer(params.getString("startIndex"));
            }
            ArrayList templateList = FcLayoutViewHandler.getTemplates((Long)loginId, (String)sortColumn, (Boolean)isAscending, (Long)templateCategoryId, (String)domainName, domainList, (String)searchText, selectedDomainList);
            if (startIndex != null && templateList.size() < startIndex && startIndex - range > 0) {
                startIndex = startIndex - range;
            }
            request.setAttribute("templateList", (Object)templateList);
            ArrayList defaultLayoutIdList = FcLayoutViewHandler.getAuthorizedDefaultLayoutIdList((Long)loginId, (Long)templateCategoryId, (boolean)false);
            request.setAttribute("defaultLayoutId", (Object)defaultLayoutIdList);
            request.setAttribute("sortColumn", (Object)sortColumn);
            request.setAttribute("isAscending", (Object)isAscending);
            request.setAttribute("domainList", domainList);
            request.setAttribute("domainName", (Object)domainName);
            if (params.has("startIndex")) {
                request.setAttribute("startIndex", (Object)startIndex);
                request.setAttribute("isNavigation", (Object)isNavigation);
                request.setAttribute("toIndex", (Object)new Integer(params.getString("toIndex")));
                request.setAttribute("isbulkDeleteEnabled", (Object)new Boolean(params.getString("isbulkDeleteEnabled")));
                request.setAttribute("selectedDomainList", selectedDomainList);
                request.setAttribute("selectedTemplatesList", selectedTemplatesList);
                request.setAttribute("searchText", (Object)searchText);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logg.log(Level.INFO, " Template List Action finished");
        return mapping.findForward(forwardPage);
    }

    public ActionForward templateEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Edit Layout started");
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        if (fcExecuteFormBean == null) {
            fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
        }
        fcExecuteFormBean.initForTemplateEdit(request);
        this.logg.log(Level.INFO, " Edit Layout finshed");
        return mapping.findForward("fcLayout");
    }

    public ActionForward templateCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Template Creation started");
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        if (fcExecuteFormBean == null) {
            fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
        }
        fcExecuteFormBean.initForCreation(request);
        this.logg.log(Level.INFO, " Template creation finsihed");
        return mapping.findForward("fcLayout");
    }

    public ActionForward getLayoutCreationPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
        Locale locale = LocaleThreadLocal.get();
        if (locale == null) {
            locale = I18NUtil.getServerLocale();
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(locale);
        ArrayList tabList = FcLayoutViewHandler.getTabList((Long)templateCategoryId, (AdventNetResourceBundle)rb, (String)fcExecuteFormBean.getDomainName());
        request.setAttribute("LhsTabWithFields", (Object)tabList);
        return mapping.findForward("layoutCreationPage");
    }

    public ActionForward getDefaultSubTabObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, "Gettting Default SubTabs started");
        try {
            String subTabIdsArray = request.getParameter("subTabIdsArray");
            JSONObject subTabIdsJsonObj = new JSONObject(subTabIdsArray);
            JSONArray subTabIdsJsonArr = subTabIdsJsonObj.getJSONArray("subTabIds");
            JSONObject resultSubTabsJsonObj = new JSONObject();
            JSONArray resultSubTabJsonArr = new JSONArray();
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            Long defaultLayoutId_HDT = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false);
            FcLayout fcLayout = new FcLayout(defaultLayoutId_HDT, rb, domainName);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcLayout);
            FcExecuteFormFlow.setDomainSpecificFieldValues(fcExecuteFormBean.getDPValues(loginId, rb), fcFormDataContainer, fcExecuteFormBean.getDomainName(), rb, loginId, templateCategoryId);
            for (int i = 0; i < subTabIdsJsonArr.length(); ++i) {
                JSONObject obj = subTabIdsJsonArr.getJSONObject(i);
                FcLayoutSubTab fcLayoutSubTab = fcLayout.getDefaultSubTab(Long.valueOf(obj.getLong("id")));
                if (fcLayoutSubTab == null) continue;
                resultSubTabJsonArr.put((Object)fcLayoutSubTab.serializeToJsonObject());
            }
            resultSubTabsJsonObj.put("FcDefaultSubTabs", (Object)resultSubTabJsonArr);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(resultSubTabsJsonObj.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward changeDomainSpecificFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = "layoutCreationPage";
        try {
            String domainName = request.getParameter("domainName");
            String fcLayoutJsonStr = request.getParameter("FcLayoutJsonStr");
            String isBTM = request.getParameter("isBTM");
            if (isBTM != null && isBTM.equalsIgnoreCase("true")) {
                forwardPage = "bulkEditTemplateLayout";
            }
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable delegatedLinkedDomainsHash = authObject.getDelegatedLinkedDomains();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            fcExecuteFormBean.setDomainName(domainName);
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject fcLayoutJsonObj = new JSONObject(fcLayoutJsonStr);
            FcLayout fcLayout = new FcLayout();
            fcLayout.init(fcLayoutJsonObj);
            Long layoutId = fcLayout.getLayoutId();
            fcLayout.setDomainName(domainName);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(fcLayout);
            FcLayout toClientExecuteLayout = new FcLayout(layoutId, rb, domainName);
            toClientExecuteLayout.setDomainName(domainName);
            FcFormDataContainer newToClientData = new FcFormDataContainer();
            newToClientData.init(toClientExecuteLayout);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldsAttributes(newToClientData);
            FcFormDataContainer userData = new FcFormDataContainer();
            FcExecuteFormFlow.updateUserData(fcExecuteFormBean.getTemplateCategoryId(), fromClientData, newToClientData, userData);
            Hashtable dpValues = FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode());
            fcExecuteFormBean.setDPValues(dpValues);
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, userData, fcExecuteFormBean.getDomainName(), rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
            FcExecuteFormFlow.applyTemplate(newToClientData, userData);
            Long templateCategoryId = fcLayout.getTemplateCategoryId();
            ArrayList tabList = FcLayoutViewHandler.getTabList((Long)templateCategoryId, (AdventNetResourceBundle)rb, (String)domainName, (Hashtable)delegatedLinkedDomainsHash);
            request.setAttribute("LhsTabWithFields", (Object)tabList);
            toClientExecuteLayout.removeUnConfiguredIamAppsFieldsList(delegatedLinkedDomainsHash);
            toClientExecuteLayout.removeEmptyTab();
            fcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
            if (isBTM != null && isBTM.equalsIgnoreCase("true")) {
                fcExecuteFormBean.setIamApps(new FcIamApps(templateCategoryId, layoutId, rb));
            } else {
                fcExecuteFormBean.setIamApps(new FcIamApps(templateCategoryId, layoutId, rb));
            }
            this.logg.log(Level.INFO, "Going to set Domain specific datas in Layout.. Id : " + fcLayout.getLayoutId());
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, newToClientData, fcExecuteFormBean.getDomainName(), rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
            if (fcExecuteFormBean.getIsCopyAvailable()) {
                request.setAttribute("copyObjectDetails", (Object)FcLayoutViewHandler.getCopyObjectDetails((Long)templateCategoryId, (AdventNetResourceBundle)rb).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward changeDomainSpecificFieldsInBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String domainName = request.getParameter("domainName");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            fcExecuteFormBean.setDomainName(domainName);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
            Hashtable dpValues = FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode());
            fcExecuteFormBean.setDPValues(dpValues);
            FcExecuteFormFlow.setDomainSpecificFieldValues(fcExecuteFormBean.getDPValues(loginId, rb), fcFormDataContainer, domainName, rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getLayoutSpecificVariables(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = LocaleThreadLocal.get();
            if (locale == null) {
                locale = I18NUtil.getServerLocale();
            }
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Long firstDisplayTabId = FcExecuteFormFlow.getFirstDisplayTabId(fcExecuteFormBean.getExecuteFormLayout(), fcExecuteFormBean.getIsExecuteFormPage());
            JSONArray mandatoryFieldsArray = FcLayoutViewHandler.getMandatoryFieldsJSONObject((Long)templateCategoryId, (AdventNetResourceBundle)rb);
            JSONArray idsJsonArray = FcExecuteFormFlow.getOptionSubTabIds(locale, templateCategoryId);
            JSONArray idsJsonArrayWithTabType = FcExecuteFormFlow.getOptionSubTabIdsWithType(locale, templateCategoryId);
            ArrayList<Integer> componentIds = new ArrayList<Integer>();
            componentIds.add(16);
            componentIds.add(43);
            componentIds.add(44);
            componentIds.add(24);
            componentIds.add(25);
            componentIds.add(64);
            componentIds.add(8);
            componentIds.add(66);
            Hashtable componentvsfield = FcLayoutViewHandler.getFieldIdsFromComponentIds((Long)templateCategoryId, componentIds);
            Long additionalCustomAttrFieldId = (Long)componentvsfield.get(16);
            Long mailBoxServerAttrFieldId = (Long)componentvsfield.get(43);
            Long mailBoxStoreAttrFieldId = FcLayoutViewHandler.getMailBoxStoreAttrFieldId((Long)templateCategoryId);
            Long archiveMailboxAttrFieldId = FcLayoutViewHandler.getArchiveMailboxAttrFieldId((Long)templateCategoryId);
            Long emailAttributeFieldId = FcLayoutUpdateHandler.getFieldIdFromAttribColumnName((String)"EMAIL_ADDRESS", (Long)templateCategoryId);
            Long logonNameFieldId = (Long)componentvsfield.get(24);
            Long samAccountNameFieldId = (Long)componentvsfield.get(25);
            ArrayList<String> ldapList = new ArrayList<String>();
            ldapList.add("targetAddress");
            Hashtable ldapvsField = FcLayoutViewHandler.getFieldIdFromLDAPNames((Long)templateCategoryId, ldapList);
            Long targetAddressFieldId = (Long)ldapvsField.get("targetAddress");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONArray mailBoxServerDetails = FcLayoutViewHandler.getMailBoxServerDetailsList((String)fcExecuteFormBean.getDomainName());
            JSONArray dagServerDetails = FcLayoutViewHandler.getDagVsServerDetailsList((String)fcExecuteFormBean.getDomainName(), (Long)loginId);
            Long storageLimitsAttrFieldId = FcLayoutViewHandler.getStorageLimitsAttrFieldId((Long)templateCategoryId);
            Long mailBoxEnabledProxyAddressesFieldId = FcLayoutViewHandler.getProxyAddressesFieldId((Long)templateCategoryId, (String)"mailbox", (AdventNetResourceBundle)rb);
            Long mailEnabledProxyAddressesFieldId = FcLayoutViewHandler.getProxyAddressesFieldId((Long)templateCategoryId, (String)"mailEnabled", (AdventNetResourceBundle)rb);
            Long mailBoxEnabledMsExchPoliciesExcluded = FcLayoutViewHandler.getMsExchPoliciesExcludedFieldId((Long)templateCategoryId, (String)"mailbox", (AdventNetResourceBundle)rb);
            Long mailEnabledMsExchPoliciesExcluded = FcLayoutViewHandler.getMsExchPoliciesExcludedFieldId((Long)templateCategoryId, (String)"mailEnabled", (AdventNetResourceBundle)rb);
            Long exchOnlineAdditionalEmailAddressesFieldId = FcLayoutViewHandler.getExchOnlineAdditionalEmailAddressesFieldId((Long)templateCategoryId, null, (AdventNetResourceBundle)rb);
            Long mailBoxMsExchPoliciesExcluded = FcLayoutViewHandler.getMsExchPoliciesExcludedFieldId((Long)templateCategoryId, null, (AdventNetResourceBundle)rb);
            JSONObject exchOnlineDetails = FcLayoutViewHandler.getExchOnlineDetails((String)DomainInfoCache.getInstance().getO365Account(fcExecuteFormBean.getDomainName()));
            JSONArray mutuallyExclusiveFields = FcLayoutViewHandler.getMutuallyExclusiveFields((Long)templateCategoryId);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("firstDisplayTabId", (Object)firstDisplayTabId);
            jsonObj.put("mandatoryFieldsArray", (Object)mandatoryFieldsArray);
            jsonObj.put("subTabIds", (Object)idsJsonArray);
            jsonObj.put("subTabIdsWithType", (Object)idsJsonArrayWithTabType);
            jsonObj.put("additionalCustomAttrFieldId", (Object)additionalCustomAttrFieldId);
            jsonObj.put("logonNameFieldId", (Object)logonNameFieldId);
            jsonObj.put("samAccountNameFieldId", (Object)samAccountNameFieldId);
            jsonObj.put("emailAttributeFieldId", (Object)emailAttributeFieldId);
            jsonObj.put("mailBoxServerAttrFieldId", (Object)mailBoxServerAttrFieldId);
            jsonObj.put("mailBoxStoreAttrFieldId", (Object)mailBoxStoreAttrFieldId);
            jsonObj.put("archiveMailboxAttrFieldId", (Object)archiveMailboxAttrFieldId);
            jsonObj.put("mailBoxServerDetails", (Object)mailBoxServerDetails);
            jsonObj.put("dagServerDetails", (Object)dagServerDetails);
            jsonObj.put("storageLimitsAttrFieldId", (Object)storageLimitsAttrFieldId);
            jsonObj.put("mailBoxEnabledMsExchPoliciesExcludedFieldId", (Object)mailBoxEnabledMsExchPoliciesExcluded);
            jsonObj.put("mailEnabledMsExchPoliciesExcludedFieldId", (Object)mailEnabledMsExchPoliciesExcluded);
            jsonObj.put("mailBoxEnabledProxyAddressesFieldId", (Object)mailBoxEnabledProxyAddressesFieldId);
            jsonObj.put("mailEnabledProxyAddressesFieldId", (Object)mailEnabledProxyAddressesFieldId);
            jsonObj.put("mailBoxMsExchPoliciesExcluded", (Object)mailBoxMsExchPoliciesExcluded);
            jsonObj.put("exchOnlineAdditionalEmailAddressesFieldId", (Object)exchOnlineAdditionalEmailAddressesFieldId);
            jsonObj.put("targetAddressField", (Object)targetAddressFieldId);
            jsonObj.put("groupScopeFieldId", (Object)((Long)componentvsfield.get(64)));
            jsonObj.put("memberOfFieldId", (Object)((Long)componentvsfield.get(8)));
            jsonObj.put("memberFieldId", (Object)((Long)componentvsfield.get(66)));
            jsonObj.put("exchOnlineDetails", (Object)exchOnlineDetails);
            jsonObj.put("mutuallyExclusiveFields", (Object)(mutuallyExclusiveFields == null ? new JSONArray() : mutuallyExclusiveFields));
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getNamingFormatExampleValue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long formatId = new Long(request.getParameter("formatId"));
            Properties ldapVsValueProps = new Properties();
            ldapVsValueProps.put("givenName", rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_first_name"));
            ldapVsValueProps.put("initials", rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_intial"));
            ldapVsValueProps.put("sn", rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_last_name"));
            ldapVsValueProps.put("displayName", rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_group_display_name"));
            Long logonNameFormatId = null;
            if (request.getParameter("logonNameFormatId") != null) {
                logonNameFormatId = new Long(request.getParameter("logonNameFormatId"));
                ldapVsValueProps.put("upn", FcExecuteFormFlow.getNamingFormatExampleValue(logonNameFormatId, ldapVsValueProps));
            }
            Long samAccountNameFormatId = null;
            if (request.getParameter("samAccountNameFormatId") != null) {
                samAccountNameFormatId = new Long(request.getParameter("samAccountNameFormatId"));
                ldapVsValueProps.put("sAMAccountName", FcExecuteFormFlow.getNamingFormatExampleValue(samAccountNameFormatId, ldapVsValueProps));
            }
            if (request.getParameter("emailFormatId") != null && request.getParameter("emailComponentId") != null) {
                int componentId = Integer.parseInt(request.getParameter("emailComponentId"));
                String emailValue = "";
                if (componentId == 1) {
                    emailValue = request.getParameter("emailFormatId");
                } else if (componentId == 24) {
                    Long emailFormatId = new Long(request.getParameter("emailFormatId"));
                    String emailFormatValue = FcExecuteFormFlow.getNamingFormatExampleValue(emailFormatId, ldapVsValueProps);
                    String emailDomainName = request.getParameter("emailDomain");
                    emailValue = emailFormatValue + "@" + emailDomainName;
                } else {
                    this.logg.log(Level.INFO, "Exception: Unable to determine Email Attribute Component Id. Report this Exception");
                }
                ldapVsValueProps.put("mail", emailValue);
            }
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            ldapVsValueProps.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            String value = FcExecuteFormFlow.getNamingFormatExampleValue(formatId, ldapVsValueProps);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("value", (Object)EscapeUtil.escSplCharsAsHTML((Object)value));
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardLocation = null;
        try {
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            String fieldJsonTxt = request.getParameter("fieldJsonTxt");
            JSONObject fieldJsonObj = new JSONObject(fieldJsonTxt);
            FcLayoutField currField = new FcLayoutField();
            currField.init(fieldJsonObj);
            JSONObject fieldInfoJson = FcLayoutClientUtil.updateFieldForUIDisplay(fcExecuteFormBean, currField);
            Long newComponentId = new Long(request.getParameter("newComponentId"));
            currField.setComponentId(newComponentId);
            currField.initComponentObject();
            forwardLocation = FcDefaultLayout.getInstance().getComponentForwardLocation(newComponentId);
            request.setAttribute("fieldInfoJson", (Object)fieldInfoJson);
            request.setAttribute("fcRhsField", (Object)currField);
            session.setAttribute("fcExecuteFormBean", (Object)fcExecuteFormBean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardLocation);
    }

    public ActionForward getBulkEditTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, " Template Creation started");
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        if (fcExecuteFormBean == null) {
            fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
        }
        fcExecuteFormBean.initForBulkEdit(request);
        return mapping.findForward("bulkEditLayout");
    }

    public ActionForward bulkUpdateLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String saveMessage = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        ArrayList<Hashtable> resultList = new ArrayList<Hashtable>();
        try {
            String layoutDetailsStr = request.getParameter("layoutDetails");
            JSONObject layoutDetailsJsonObj = new JSONObject(layoutDetailsStr);
            String domainName = layoutDetailsJsonObj.getString("domainName");
            Integer defaultValue = new Integer(layoutDetailsJsonObj.getInt("defaultValue"));
            Boolean addDeletedComponent = layoutDetailsJsonObj.getBoolean("addDeletedComponent");
            String fcLayoutJsonStr = request.getParameter("FcLayoutJsonStr");
            JSONObject selectedTemplates = new JSONObject(request.getParameter("selectedTemplates"));
            JSONArray selectedIamAppsJsonArray = layoutDetailsJsonObj.getJSONArray("selectedIamApps");
            JSONArray bulkEditSelectedIamApps = layoutDetailsJsonObj.getJSONArray("bulkEditSelectedIamAppsTabs");
            ArrayList<Integer> selectedIamApps = new ArrayList<Integer>();
            for (int i = 0; i < selectedIamAppsJsonArray.length(); ++i) {
                selectedIamApps.add((Integer)selectedIamAppsJsonArray.get(i));
            }
            ArrayList<Integer> bulkEditedIamApps = new ArrayList<Integer>();
            for (int i = 0; i < bulkEditSelectedIamApps.length(); ++i) {
                bulkEditedIamApps.add((Integer)bulkEditSelectedIamApps.get(i));
            }
            FcLayout fcRhsLayout = new FcLayout();
            if (fcLayoutJsonStr == null) {
                fcRhsLayout = fcExecuteFormBean.getExecuteFormLayout();
                if (!fcRhsLayout.getDomainName().equals(domainName)) {
                    FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
                    fcFormDataContainer.init(fcRhsLayout);
                    FcExecuteFormFlow.setDomainSpecificFieldValues(FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)domainName, (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode()), fcFormDataContainer, domainName, rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
                }
            } else {
                JSONObject fcLayoutJsonObj = new JSONObject(fcLayoutJsonStr);
                fcRhsLayout.init(fcLayoutJsonObj);
            }
            fcRhsLayout.setDomainName(domainName);
            fcRhsLayout.setModifiedTime(Long.valueOf(new Date().getTime()));
            fcRhsLayout.setDefaultValue(defaultValue);
            Iterator itr = selectedTemplates.keys();
            while (itr.hasNext()) {
                Long templateId = Long.valueOf((String)itr.next());
                Hashtable resultHash = new Hashtable();
                if (FcLayoutViewHandler.isSystemDefaultLayout((Long)templateId)) {
                    resultHash.put("IS_SUCCESS", Boolean.FALSE);
                    resultHash.put("STATUS", rb.getString("admp.mgmt.fc_layout_common.text_status_msg_error_occurred_while_saving_the_template"));
                } else {
                    resultHash = FcLayoutUpdateHandler.updateLayout((FcLayout)fcRhsLayout, (AdventNetResourceBundle)rb, (Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)templateId, (Boolean)addDeletedComponent, selectedIamApps, bulkEditedIamApps);
                }
                resultHash.put("TEMPLATE_NAME", selectedTemplates.getString(templateId.toString()));
                resultList.add(resultHash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            saveMessage = rb.getString("admp.mgmt.fc_layout_common.text_status_msg_error_occurred_while_saving_the_template");
        }
        int successCount = 0;
        for (Hashtable hash : resultList) {
            Boolean isSuccess = Boolean.FALSE;
            if (hash.containsKey("IS_SUCCESS")) {
                isSuccess = (Boolean)hash.get("IS_SUCCESS");
            }
            if (!isSuccess.booleanValue()) continue;
            ++successCount;
        }
        saveMessage = resultList.size() == successCount ? rb.getString("admp.mgmt.fc_layout_common.text_status_msg_successfully_updated_the_template") : (successCount == 0 ? rb.getString("admp.mgmt.fc_layout_common.text_status_msg_error_occurred_while_saving_the_template") : rb.getString("admp.mgmt.fc_layout_common.text_status_msg_partial_successfully_updated_the_template"));
        request.setAttribute("saveMessage", (Object)saveMessage);
        request.setAttribute("resultList", resultList);
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, fcExecuteFormBean.getActionId());
        request.setAttribute("templateList", (Object)FcLayoutViewHandler.getTemplates((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (String)"LAYOUT_NAME", (Boolean)true, (Long)fcExecuteFormBean.getTemplateCategoryId(), null, domainList));
        ArrayList defaultLayoutIdList = FcLayoutViewHandler.getAuthorizedDefaultLayoutIdList((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (boolean)fcExecuteFormBean.getIsWorkFlowMode());
        request.setAttribute("defaultLayoutId", (Object)defaultLayoutIdList);
        request.setAttribute("sortColumn", (Object)"LAYOUT_NAME");
        request.setAttribute("isAscending", (Object)true);
        request.setAttribute("domainList", domainList);
        return mapping.findForward("viewFcTemplateList");
    }

    public ActionForward bulkdeleteTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.logg.log(Level.INFO, "Going to delete Layout");
        String forwardPage = "viewFcTemplateList";
        String domainName = null;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (request.getParameter("domainName") != null && !"".equals(request.getParameter("domainName"))) {
            domainName = request.getParameter("domainName");
        }
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        try {
            int i;
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, fcExecuteFormBean.getActionId());
            ArrayList templateList = FcLayoutViewHandler.getTemplates((Long)loginId, (String)"LAYOUT_NAME", (Boolean)true, (Long)templateCategoryId, null, domainList);
            ArrayList<Long> selectedTemplatesList = new ArrayList<Long>();
            if (request.getParameter("selectedTemplatesList") != null) {
                String selectedtemplateStr = request.getParameter("selectedTemplatesList");
                JSONArray jsonArray = new JSONArray(selectedtemplateStr);
                for (i = 0; i < jsonArray.length(); ++i) {
                    selectedTemplatesList.add(new Long(jsonArray.getString(i)));
                }
            }
            Properties templateActionDetails = FcLayoutViewHandler.getTemplateActionDetails((Long)templateCategoryId);
            ArrayList resultList = new ArrayList();
            for (i = 0; i < templateList.size(); ++i) {
                Properties prop = (Properties)templateList.get(i);
                Long l = (Long)prop.get("LAYOUT_ID");
                if (!selectedTemplatesList.contains(l)) continue;
                String currLayoutDomainName = (String)prop.get("DOMAIN_NAME");
                Boolean allowDeleteLayout = Boolean.FALSE;
                allowDeleteLayout = currLayoutDomainName.length() > 0 ? Boolean.valueOf(ClientUtil.checkAuthorization(request, currLayoutDomainName, (long)((Long)templateActionDetails.get("DELETE_TEMPLATE_ACTION_ID")))) : Boolean.valueOf(ClientUtil.checkAuthorization(request, (Long)templateActionDetails.get("DELETE_TEMPLATE_ACTION_ID")));
                Hashtable<String, Object> resultHash = new Hashtable<String, Object>();
                if (allowDeleteLayout.booleanValue()) {
                    FcLayoutUpdateHandler.deleteLayout((Long)new Long(l));
                    resultHash.put("IS_SUCCESS", Boolean.TRUE);
                    resultHash.put("STATUS", rb.getString("admp.mgmt.common.text.successfully_deleted"));
                } else {
                    resultHash.put("IS_SUCCESS", Boolean.FALSE);
                    resultHash.put("STATUS", rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.u_not_authorized_to_del_template"));
                }
                String templateName = (String)prop.get("LAYOUT_NAME");
                resultHash.put("TEMPLATE_NAME", templateName);
                resultList.add(resultHash);
            }
            int successCount = 0;
            for (Hashtable hashtable : resultList) {
                Boolean isSuccess = Boolean.FALSE;
                if (hashtable.containsKey("IS_SUCCESS")) {
                    isSuccess = (Boolean)hashtable.get("IS_SUCCESS");
                }
                if (!isSuccess.booleanValue()) continue;
                ++successCount;
            }
            String saveMessage = "";
            saveMessage = resultList.size() == successCount ? rb.getString("admp.mgmt.fc_layout_common.text_status_msg_successfully_deleted_the_template") : (successCount == 0 ? rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.u_not_authorized_to_del_template") : rb.getString("admp.mgmt.fc_layout_common.text_status_msg_partial_successfully_delete_the_template"));
            request.setAttribute("saveMessage", (Object)saveMessage);
            request.setAttribute("resultList", resultList);
            request.setAttribute("templateList", (Object)FcLayoutViewHandler.getTemplates((Long)loginId, (String)"LAYOUT_NAME", (Boolean)true, (Long)templateCategoryId, (String)domainName, domainList));
            Long l = FcLayoutViewHandler.getAuthorizedDefaultLayoutId((Long)loginId, (Long)templateCategoryId, (boolean)fcExecuteFormBean.getIsWorkFlowMode(), (String)domainName);
            request.setAttribute("defaultLayoutId", (Object)l);
            request.setAttribute("sortColumn", (Object)"LAYOUT_NAME");
            request.setAttribute("isAscending", (Object)true);
            request.setAttribute("domainList", domainList);
            request.setAttribute("domainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getGroupList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            String optionHtml = "<option class=\"groupSelectOption blacktxt1\" value=\"";
            StringBuilder optionStr = new StringBuilder();
            JSONObject addParams = new JSONObject(request.getParameter("additionalParams"));
            String primaryDN = request.getParameter("primaryDN");
            String domainName = DomainUtil.getDomainNamefromDN((String)primaryDN);
            Long templateCategoryId = Long.valueOf(request.getParameter("templateCategoryId"));
            String guid = request.getParameter("objectGuid");
            Boolean isWorkFlowMode = null;
            if (request.getParameter("isWorkFlowMode") != null) {
                isWorkFlowMode = new Boolean(request.getParameter("isWorkFlowMode"));
            }
            boolean primGrpAuth = true;
            if (templateCategoryId == 5L || templateCategoryId == 6L || templateCategoryId == 3L) {
                primGrpAuth = GroupHandler.isGroupAuthorised((Long)loginId, (String)primaryDN, (Long)templateCategoryId);
            }
            boolean appendPrimaryGrp = Boolean.valueOf(request.getParameter("appendPrimaryGrp"));
            boolean isExecutePage = Boolean.valueOf(request.getParameter("isExecutePage"));
            boolean isTemplateEdit = false;
            Hashtable authGrps = new Hashtable();
            if (!isExecutePage && loginId != ADMPAuthUtil.ADMIN_LOGIN_ID) {
                ArrayList<String> dnList = new ArrayList<String>();
                Iterator keys = addParams.keys();
                while (keys.hasNext()) {
                    dnList.add((String)keys.next());
                }
                authGrps = GroupHandler.getGroupsPropFromDN((String)domainName, (Long)loginId, dnList);
                isTemplateEdit = true;
            }
            String memberOfDivClass = request.getParameter("memberOfDivClass");
            Iterator itr = addParams.keys();
            ArrayList<String> keys = new ArrayList<String>();
            while (itr.hasNext()) {
                keys.add((String)itr.next());
            }
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
            String defNamContxt = "";
            if (domainName != null && !domainName.isEmpty()) {
                defNamContxt = DomainUtil.getDefaultNamingContext((String)domainName);
            }
            Hashtable authorizedGroupList = null;
            if (isWorkFlowMode != null) {
                Criteria ouCrit = null;
                if (isWorkFlowMode.booleanValue() && WorkFlowUserHandler.isRequester((Long)loginId).booleanValue()) {
                    ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
                    ouCrit = HelpdeskUtil.getOUCriteria((ArrayList)ouList, (String)domainName);
                } else {
                    ouCrit = HelpdeskUtil.getOUCriteria((Long)loginId, (String)domainName);
                }
                if (ouCrit != null) {
                    authorizedGroupList = GroupHandler.getGroupsPropFromDN((String)domainName, (Long)loginId, keys, (Criteria)ouCrit);
                }
            }
            for (int i = 0; i < keys.size(); ++i) {
                String objectGuid;
                String value = (String)keys.get(i);
                if (authorizedGroupList != null && !authorizedGroupList.containsKey(value.toLowerCase())) continue;
                String dispName = StrUtil.getNameFromDN((String)value);
                String ouPath = OUUtil.getOULocationProp((String)domainName, (String)value, (String)defNamContxt).getProperty("OU_PATH");
                if (!addParams.has(value) || isTemplateEdit && !authGrps.containsKey(value.toLowerCase()) || appendPrimaryGrp && !primGrpAuth && value.equalsIgnoreCase(primaryDN)) continue;
                JSONObject param = addParams.getJSONObject(value);
                String groupType1 = param.has("grouptype") ? param.getString("grouptype") : "";
                String string = objectGuid = param.has("object_guid") ? param.getString("object_guid") : "";
                if (templateCategoryId == FcExecuteActionConstants.groupModificationTemplateCategoryId && objectGuid.equalsIgnoreCase(guid)) continue;
                optionStr.append(optionHtml + "" + ClientUtil.htmlEscape(value) + "\" dispName=\"" + ClientUtil.htmlEscape(dispName) + "\" object_guid=\"" + objectGuid + "\" groupType=\"" + groupType1 + "\" title=\"" + ClientUtil.htmlEscape(value) + "\">" + ClientUtil.htmlEscape(ouPath) + "</option>");
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("value", (Object)optionStr.toString());
            jsonObj.put("memberOfDivClass", (Object)memberOfDivClass);
            jsonObj.put("isPgAuth", (Object)String.valueOf(primGrpAuth));
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

