/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutRhsConstants;
import com.adventnet.sym.adsm.common.server.layout.component.FcAdditionalCustomAttribute;
import com.adventnet.sym.adsm.common.server.layout.component.IComponent;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class FcLayoutClientUtil
implements FcLayoutRhsConstants {
    public static JSONObject updateFieldForUIDisplay(FcExecuteFormBean fcExecuteFormBean, FcLayoutField fcRhsField) {
        String fieldLabelClass = "field-label";
        String disabled = "";
        boolean canLinkPlaced = true;
        Long componentId = fcRhsField.getComponentId();
        boolean isExecutionPage = false;
        if (fcExecuteFormBean != null) {
            isExecutionPage = fcExecuteFormBean.getIsExecuteFormPage();
        }
        IComponent iComponent = fcRhsField.getIComponent();
        if (isExecutionPage) {
            if (fcRhsField.getIsAuthorized().booleanValue()) {
                if (fcRhsField.getIsReadOnly().booleanValue()) {
                    disabled = "disabled=\"disabled\"";
                    canLinkPlaced = false;
                } else if (componentId.intValue() == 16 && fcRhsField.getLayoutFieldId() > 100L && !((FcAdditionalCustomAttribute)iComponent).canDeleteField().booleanValue()) {
                    canLinkPlaced = false;
                }
            } else {
                disabled = "disabled=\"disabled\"";
                canLinkPlaced = false;
            }
        } else {
            if (!fcRhsField.getIsAuthorized().booleanValue()) {
                disabled = "disabled=\"disabled\"";
                canLinkPlaced = false;
            }
            if (fcRhsField.getIsHidden().booleanValue()) {
                fieldLabelClass = "field-label-disable";
            }
        }
        JSONObject fieldInfoJson = new JSONObject();
        try {
            fieldInfoJson.put("disabled", (Object)disabled);
            fieldInfoJson.put("canLinkPlaced", canLinkPlaced);
            fieldInfoJson.put("fieldLabelClass", (Object)fieldLabelClass);
            fieldInfoJson.put("IComponent", (Object)fcRhsField.getIComponent());
            fieldInfoJson.put("fcRhsField", (Object)fcRhsField);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        return fieldInfoJson;
    }

    public static String getObjectName(String guid, String domainName, Long templateCategoryId) {
        String objectName = "";
        try {
            String baseTableName = "";
            String nameColumn = "";
            String domainColumn = "DOMAIN_NAME";
            String guidColumn = "OBJECT_GUID";
            if (templateCategoryId.compareTo(FcExecuteActionConstants.contactModificationTemplateCategoryId) == 0) {
                baseTableName = "ADSMContactGeneralDetails";
                nameColumn = "DISPLAY_NAME";
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                baseTableName = "ADSMUserGeneralDetails";
                nameColumn = "DISPLAY_NAME";
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                baseTableName = "ADSMGroupGeneralDetails";
                nameColumn = "GROUP_NAME";
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId) == 0) {
                baseTableName = "ADSMMailBoxObjects";
                nameColumn = "NAME";
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.ouModificationTemplateCategoryId) == 0) {
                baseTableName = "ADSMOUDetails";
                nameColumn = "NAME";
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.o365DistGroupModificationTemplateCategoryId) == 0) {
                baseTableName = "O365GroupGeneralDetails";
                nameColumn = "DISPLAY_NAME";
                domainColumn = "WAAD_TENANT_ID";
                guidColumn = "OBJECT_ID";
            } else {
                return objectName;
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)nameColumn));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)guidColumn));
            Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)guidColumn), (Object)guid, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)baseTableName, (String)domainColumn), (Object)domainName, 0));
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Row row = dataObject.getRow(baseTableName);
            if (row != null) {
                String displayName = (String)row.get(nameColumn);
                objectName = displayName != null ? domainName + "\\" + displayName : domainName + "\\-";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectName;
    }

    public static String getWFList(String layoutId) {
        ArrayList<String> taskIdList = new ArrayList<String>();
        ArrayList<String> taskSetIdList = new ArrayList<String>();
        ArrayList<String> reqMonitorIdList = new ArrayList<String>();
        ArrayList<String> requestIdList = new ArrayList<String>();
        String workFlowListString = "";
        try {
            String variableName = "templateName";
            Criteria varValCriteria = new Criteria(Column.getColumn((String)"ReqMonitorTaskInputToADSMBoard", (String)"VARIABLE_NAME"), (Object)variableName, 0);
            varValCriteria = varValCriteria.and(new Criteria(Column.getColumn((String)"ReqMonitorTaskInputToADSMBoard", (String)"VALUE"), (Object)layoutId, 0));
            DataObject taskInputDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ReqMonitorTaskInputToADSMBoard", varValCriteria);
            if (!taskInputDO.isEmpty()) {
                Iterator layoutToTaskIterator = taskInputDO.getRows("ReqMonitorTaskInputToADSMBoard");
                String taskIdValue = new String();
                while (layoutToTaskIterator.hasNext()) {
                    Row taskIdRow = (Row)layoutToTaskIterator.next();
                    taskIdValue = taskIdRow.get("REQ_MONITOR_TASK_ID") != null ? taskIdRow.get("REQ_MONITOR_TASK_ID").toString() : "";
                    if (taskIdValue.isEmpty()) continue;
                    taskIdList.add(taskIdValue);
                }
                Criteria taskCriteria = new Criteria(Column.getColumn((String)"ADSMReqMonitorTask", (String)"REQ_MONITOR_TASK_ID"), (Object)StrUtil.getStringArray(taskIdList), 8);
                DataObject reqMonitorTaskDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReqMonitorTask", taskCriteria);
                if (!reqMonitorTaskDO.isEmpty()) {
                    Iterator taskToTaskSetIterator = reqMonitorTaskDO.getRows("ADSMReqMonitorTask");
                    String taskSetValue = new String();
                    while (taskToTaskSetIterator.hasNext()) {
                        Row taskSetRow = (Row)taskToTaskSetIterator.next();
                        taskSetValue = taskSetRow.get("REQ_MONITOR_TASKSET_ID") != null ? taskSetRow.get("REQ_MONITOR_TASKSET_ID").toString() : "";
                        if (taskSetValue.isEmpty()) continue;
                        taskSetIdList.add(taskSetValue);
                    }
                    Criteria taskSetCriteria = new Criteria(Column.getColumn((String)"ADSMReqMonitorTaskSet", (String)"REQ_MONITOR_TASKSET_ID"), (Object)StrUtil.getStringArray(taskSetIdList), 8);
                    DataObject reqMonitorTaskSetDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReqMonitorTaskSet", taskSetCriteria);
                    if (!reqMonitorTaskSetDO.isEmpty()) {
                        Iterator taskSetToMonitorIterator = reqMonitorTaskSetDO.getRows("ADSMReqMonitorTaskSet");
                        String reqMonitorIdValue = new String();
                        while (taskSetToMonitorIterator.hasNext()) {
                            Row reqMonitorRow = (Row)taskSetToMonitorIterator.next();
                            reqMonitorIdValue = reqMonitorRow.get("REQ_MONITOR_ID") != null ? reqMonitorRow.get("REQ_MONITOR_ID").toString() : "";
                            if (reqMonitorIdValue.isEmpty()) continue;
                            reqMonitorIdList.add(reqMonitorIdValue);
                        }
                        Criteria reqMonitorCriteria = new Criteria(Column.getColumn((String)"ADSMRequestsToReqMonitorMap", (String)"REQ_MONITOR_ID"), (Object)StrUtil.getStringArray(reqMonitorIdList), 8);
                        DataObject requestToReqMonitorDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMRequestsToReqMonitorMap", reqMonitorCriteria);
                        if (!requestToReqMonitorDO.isEmpty()) {
                            Iterator requesToReqMonitorIterator = requestToReqMonitorDO.getRows("ADSMRequestsToReqMonitorMap");
                            String reqestIdValue = new String();
                            while (requesToReqMonitorIterator.hasNext()) {
                                Row requestIdRow = (Row)requesToReqMonitorIterator.next();
                                reqestIdValue = requestIdRow.get("REQUEST_ID") != null ? requestIdRow.get("REQUEST_ID").toString() : "";
                                if (reqestIdValue.isEmpty()) continue;
                                requestIdList.add(reqestIdValue);
                            }
                            Criteria requestCriteria = new Criteria(Column.getColumn((String)"ADSMRequestDetails", (String)"REQUEST_ID"), (Object)StrUtil.getStringArray(requestIdList), 8);
                            DataObject requestDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMRequestDetails", requestCriteria);
                            if (!requestDetailsDO.isEmpty()) {
                                Iterator taskToSubjectIterator = requestDetailsDO.getRows("ADSMRequestDetails");
                                String subjectValue = new String();
                                while (taskToSubjectIterator.hasNext()) {
                                    Row subjectRow = (Row)taskToSubjectIterator.next();
                                    subjectValue = subjectRow.get("SUBJECT") != null ? subjectRow.get("SUBJECT").toString() : "";
                                    if (subjectValue.isEmpty()) continue;
                                    workFlowListString = workFlowListString + subjectValue + ", ";
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (workFlowListString.length() > 2) {
            workFlowListString = workFlowListString.substring(0, workFlowListString.length() - 2);
        }
        return workFlowListString;
    }

    public static String getAutomationList(String layoutId) {
        ArrayList<String> actionDetailsList = new ArrayList<String>();
        ArrayList<String> automationIdList = new ArrayList<String>();
        String automationListString = "";
        try {
            String variableName = "template";
            Criteria varValCriteria = new Criteria(Column.getColumn((String)"AutoReqActionInputDetails", (String)"VARIABLE_NAME"), (Object)variableName, 0);
            varValCriteria = varValCriteria.and(new Criteria(Column.getColumn((String)"AutoReqActionInputDetails", (String)"VALUE"), (Object)layoutId, 0));
            DataObject actionInputsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AutoReqActionInputDetails", varValCriteria);
            if (!actionInputsDO.isEmpty()) {
                Iterator layoutToDetailsIterator = actionInputsDO.getRows("AutoReqActionInputDetails");
                String detailsIdValue = new String();
                while (layoutToDetailsIterator.hasNext()) {
                    Row actionDetailsRow = (Row)layoutToDetailsIterator.next();
                    detailsIdValue = actionDetailsRow.get("AUTO_REQACTION_DETAILS_ID") != null ? actionDetailsRow.get("AUTO_REQACTION_DETAILS_ID").toString() : "";
                    if (detailsIdValue.isEmpty()) continue;
                    actionDetailsList.add(detailsIdValue);
                }
                Criteria detailsCriteria = new Criteria(Column.getColumn((String)"ADSMAutomationRequestActions", (String)"AUTO_REQACTION_DETAILS_ID"), (Object)StrUtil.getStringArray(actionDetailsList), 8);
                DataObject requestActionsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomationRequestActions", detailsCriteria);
                if (!requestActionsDO.isEmpty()) {
                    Iterator detailToAutomationIterator = requestActionsDO.getRows("ADSMAutomationRequestActions");
                    String automationIdValue = new String();
                    while (detailToAutomationIterator.hasNext()) {
                        Row automationIdRow = (Row)detailToAutomationIterator.next();
                        automationIdValue = automationIdRow.get("AUTOMATION_ID") != null ? automationIdRow.get("AUTOMATION_ID").toString() : "";
                        if (automationIdValue.isEmpty()) continue;
                        automationIdList.add(automationIdValue);
                    }
                    Criteria automationCriteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"AUTOMATION_ID"), (Object)StrUtil.getStringArray(automationIdList), 8);
                    DataObject automationDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomation", automationCriteria);
                    if (!automationDO.isEmpty()) {
                        Iterator automationToNameIterator = automationDO.getRows("ADSMAutomation");
                        String autoNameValue = new String();
                        while (automationToNameIterator.hasNext()) {
                            Row subjectRow = (Row)automationToNameIterator.next();
                            autoNameValue = subjectRow.get("SUBJECT") != null ? subjectRow.get("AUTOMATION_NAME").toString() : "";
                            if (autoNameValue.isEmpty()) continue;
                            automationListString = automationListString + autoNameValue + ", ";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (automationListString.length() > 2) {
            automationListString = automationListString.substring(0, automationListString.length() - 2);
        }
        return automationListString;
    }

    public static String getAutomationPolicyList(String layoutId) {
        ArrayList<String> taskDetailsList = new ArrayList<String>();
        ArrayList<String> policyList = new ArrayList<String>();
        ArrayList<String> taskSetList = new ArrayList<String>();
        String automationPolicyListString = "";
        try {
            String variableName = "template";
            Criteria varValCriteria = new Criteria(Column.getColumn((String)"ADSMTaskInputDetails", (String)"VARIABLE_NAME"), (Object)variableName, 0);
            varValCriteria = varValCriteria.and(new Criteria(Column.getColumn((String)"ADSMTaskInputDetails", (String)"VALUE"), (Object)layoutId, 0));
            DataObject taskInputsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMTaskInputDetails", varValCriteria);
            if (!taskInputsDO.isEmpty()) {
                Iterator layoutTotaskIterator = taskInputsDO.getRows("ADSMTaskInputDetails");
                String detailsIdValue = new String();
                while (layoutTotaskIterator.hasNext()) {
                    Row taskDetailsRow = (Row)layoutTotaskIterator.next();
                    detailsIdValue = taskDetailsRow.get("ADTASK_DETAILS_ID") != null ? taskDetailsRow.get("ADTASK_DETAILS_ID").toString() : "";
                    if (detailsIdValue.isEmpty()) continue;
                    taskDetailsList.add(detailsIdValue);
                }
                Criteria taskDetailsCriteria = new Criteria(Column.getColumn((String)"ADSMTaskSetDetails", (String)"ADTASK_DETAILS_ID"), (Object)StrUtil.getStringArray(taskDetailsList), 8);
                DataObject taskSetDetailDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMTaskSetDetails", taskDetailsCriteria);
                if (!taskSetDetailDO.isEmpty()) {
                    Iterator taskToTaskSetIterator = taskSetDetailDO.getRows("ADSMTaskSetDetails");
                    String taskSetValue = new String();
                    while (taskToTaskSetIterator.hasNext()) {
                        Row taskSetRow = (Row)taskToTaskSetIterator.next();
                        taskSetValue = taskSetRow.get("ADTASK_SET_ID") != null ? taskSetRow.get("ADTASK_SET_ID").toString() : "";
                        if (taskSetValue.isEmpty()) continue;
                        taskSetList.add(taskSetValue);
                    }
                    Criteria taskCriteria = new Criteria(Column.getColumn((String)"ADSMTaskSet", (String)"ADTASK_SET_ID"), (Object)StrUtil.getStringArray(taskSetList), 8);
                    DataObject taskSetDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMTaskSet", taskCriteria);
                    if (!taskSetDO.isEmpty()) {
                        Iterator taskToPolicyIdIterator = taskSetDO.getRows("ADSMTaskSet");
                        String policyIdValue = new String();
                        while (taskToPolicyIdIterator.hasNext()) {
                            Row autoPolicyRow = (Row)taskToPolicyIdIterator.next();
                            policyIdValue = autoPolicyRow.get("AUTO_POLICY_ID") != null ? autoPolicyRow.get("AUTO_POLICY_ID").toString() : "";
                            if (policyIdValue.isEmpty()) continue;
                            policyList.add(policyIdValue);
                        }
                        Criteria policyCriteria = new Criteria(Column.getColumn((String)"ADSMAutomationPolicy", (String)"AUTO_POLICY_ID"), (Object)StrUtil.getStringArray(policyList), 8);
                        DataObject automationPolicyDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomationPolicy", policyCriteria);
                        if (!automationPolicyDO.isEmpty()) {
                            Iterator policyIdToNameIterator = automationPolicyDO.getRows("ADSMAutomationPolicy");
                            String autoPolicyNameValue = new String();
                            while (policyIdToNameIterator.hasNext()) {
                                Row policyNameRow = (Row)policyIdToNameIterator.next();
                                autoPolicyNameValue = policyNameRow.get("AUTO_POLICY_NAME") != null ? policyNameRow.get("AUTO_POLICY_NAME").toString() : "";
                                if (autoPolicyNameValue.isEmpty()) continue;
                                automationPolicyListString = automationPolicyListString + autoPolicyNameValue + ", ";
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (automationPolicyListString.length() > 2) {
            automationPolicyListString = automationPolicyListString.substring(0, automationPolicyListString.length() - 2);
        }
        return automationPolicyListString;
    }
}

