/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.FcOUModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class FcOuModificationListener
extends FcADMgmtListener {
    String fullName = "";
    String distinguishedName = "";
    String oldDistinguishedName = null;
    String searchString = "";
    String guid = "";
    ArrayList authorizedOUList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    boolean preventDeletion = false;
    ArrayList<Hashtable> customList;
    String customScriptResult = "";
    String modifiedFullName = "";
    Long objectIndexId = 0L;
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();
    String[] mandatoryFields = new String[]{"name", "distinguishedName", "memberOf"};

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId, null);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.modifyOU();
    }

    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    @Override
    public void setAuthorizedOUList(ArrayList authorizedOUList) {
        this.authorizedOUList = authorizedOUList;
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            if (attribList.contains("preventDeletion") && this.distinguishedName != "") {
                this.preventDeletion = ADHandler.getACEsFromDN((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)"preventDeletion", (String)"");
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(String.valueOf(this.preventDeletion));
                valuesList.put("preventDeletion", temp);
            }
            this.fillMandatoryFields(valuesList);
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Properties prop = new Properties();
                prop.put("domainName", this.domainName);
                prop.put("loginId", loginId);
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList fullNameValueList;
            ArrayList distinguishedNameValueList = (ArrayList)valuesList.get("distinguishedName");
            if (distinguishedNameValueList != null) {
                this.distinguishedName = (String)distinguishedNameValueList.get(0);
                this.fcNativeProperties.setDN(this.distinguishedName);
            }
            if ((fullNameValueList = (ArrayList)valuesList.get("name")) != null) {
                this.fullName = (String)fullNameValueList.get(0);
            }
            if (this.distinguishedName != "") {
                this.preventDeletion = this.getProtectAccidentalDeletion(this.distinguishedName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void modifyOU() {
        try {
            String defaultNamingContext;
            mgmtLog.log(Level.INFO, " FcOU Modification Started ");
            this.isChangesFound = true;
            boolean isLicenseExceeded = LicenseMgr.getInstance().isModuleLicensed("OU Management");
            if (!isLicenseExceeded) {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("ERROR_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                }
                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
            FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.ouModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, this.loginId, this.guid, this.domainName, this.executeFormLayout, this);
            this.customFieldsContainer = new FcFormDataContainer();
            this.customFieldsContainer.splitCustomFields(modifiedFieldsContainer);
            FcOUModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
            FcOUModificationMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
            FcOUModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcOUModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
            FcOUModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
            FcOUModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            Properties domainProp = new Properties();
            domainProp.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcOUModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
            ldapVsValueProps = FcOUModificationMgmtHandler.getInstance().getLdapVsValuesFromAD(this.fieldValueList, ldapVsValueProps);
            this.customList = this.getCustomAttribsProperties(this.customFieldsContainer, true, ldapVsValueProps, "organizationalUnit");
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.addAttributeToNativeProps(modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps);
            this.nativeStatusProps = new Properties();
            Properties props = fcNativeProperties.getProps();
            ArrayList propList = this.fcNativeProperties.getPropList();
            String searchDN = this.distinguishedName;
            this.searchString = "(&(objectCategory=organizationalUnit)(objectClass=organizationalUnit)(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)this.distinguishedName) + "))";
            mgmtLog.log(Level.INFO, " OU Modification : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.fullName);
            mgmtLog.log(Level.INFO, " props " + fcNativeProperties.getProps());
            mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " customList " + this.customList);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.fullName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("customList", this.customList);
            if (props.get("OUName") != null) {
                String OUName = (String)props.get("OUName");
                String newdistinguishedName = "OU=" + CommonUtil.escapeString((String)this.fullName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + OUName;
                if (!this.distinguishedName.equals(newdistinguishedName)) {
                    this.oldDistinguishedName = this.distinguishedName;
                    NativeError nErr = new NativeError();
                    try {
                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)this.oldDistinguishedName, (String)OUName, (NativeError)nErr);
                        this.distinguishedName = newdistinguishedName;
                        this.searchString = "(&(objectCategory=organizationalUnit)(objectClass=organizationalUnit)(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)this.distinguishedName) + "))";
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.reports.common.status_msg.successfully_updated"));
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        String errorCode = "";
                        if (nErr != null && nErr.getErrorDetails((Object)this.oldDistinguishedName) != null) {
                            if (nErr.getErrorDetails((Object)this.oldDistinguishedName).get("NATIVE_ERROR_MESSAGE") != null) {
                                errorCode = " " + nErr.getErrorDetails((Object)this.oldDistinguishedName).get("NATIVE_ERROR_MESSAGE");
                            }
                            if (nErr.getErrorDetails((Object)this.oldDistinguishedName).get("ERROR_CODE") != null) {
                                errorCode = errorCode + " " + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + nErr.getErrorDetails((Object)this.oldDistinguishedName).get("ERROR_CODE");
                            }
                        }
                        if (le.getMessage() != null) {
                            hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_ou_error_occured"), this.rb.getString(le.getMessage())));
                            hash.put("NATIVE_ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_moving_ou"), this.rb.getString(le.getMessage())) + errorCode);
                        } else {
                            hash.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_ou_error_occured"));
                            hash.put("NATIVE_ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_moving_ou"), errorCode));
                        }
                        if (!this.isBulkMgmt) {
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                            }
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                        } else if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                            this.nativeStatusProps.put("CREATION_MESSAGE", (String)hash.get("NATIVE_ERROR_MESSAGE"));
                        } else {
                            this.nativeStatusProps.put("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + (String)hash.get("NATIVE_ERROR_MESSAGE"));
                        }
                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (fcNativeProperties.getPropList().size() > 0 || this.customList.size() > 0 || props.size() > 0) {
                if (this.authorizedOUList == null || this.authorizedOUList.size() == 0) {
                    this.modifiedFullName = props.getProperty("userName");
                    Properties properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                    defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                    this.modifyOUAction(fcNativeProperties, props, this.customList, defaultNamingContext);
                    if (this.modifiedFullName != null) {
                        this.distinguishedName = "OU=" + this.modifiedFullName + "," + StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                    }
                } else {
                    for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                        String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                        String s = searchDN.toLowerCase();
                        if (!s.endsWith(dn)) continue;
                        this.modifyOUAction(fcNativeProperties, props, this.customList, (String)this.authorizedOUList.get(i));
                        break;
                    }
                }
            } else {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.isChangesFound = false;
            }
            if (props.get("preventDeletion") != null) {
                Properties properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                if (Boolean.valueOf(props.get("preventDeletion").toString()).booleanValue()) {
                    grpList.put("ATTRIB_VALUE", "true");
                    String rootName = StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                    this.updatePreventDeletion(this.distinguishedName, "add");
                    if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                        this.updateParent(rootName);
                    }
                } else {
                    grpList.put("ATTRIB_VALUE", "false");
                    this.updatePreventDeletion(this.distinguishedName, "delete");
                }
                propList.add(grpList);
            }
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            Properties customScriptProps = (Properties)props.get("customScriptDetails");
            if (customScriptProps != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                }
            }
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void modifyOUAction(FcNativeProperties fcNativeProperties, Properties props, ArrayList customList, String containerDN) {
        try {
            this.statusObject = ADHandler.searchAndModifyOU((String)this.domainName, (Long)this.loginId, (String)containerDN, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), (ArrayList)fcNativeProperties.getPropList());
            this.nativeStatusProps = this.getSingleOUErrorMessage(this.statusObject);
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (props.getProperty("userName") != null && !props.getProperty("userName").equals("") && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("severe")) {
                this.modifiedFullName = props.getProperty("userName");
                mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + props.getProperty("userName") + " for the OU : " + this.distinguishedName);
                try {
                    ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)props.getProperty("userName"), (String)"OU", null);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    this.setNativeStatusProps(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_ous.statmsg.error_modifying_fullname"), le.getMessage(this.rb)), "SEVERE", "/images/error_icon.gif", "redtxtbold");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Properties domainProp = new Properties();
            domainProp.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcOUModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, domainProp);
            mgmtLog.log(Level.INFO, " Fc OU Modification Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setNativeStatusProps(String message, String status, String image, String messageStyle) {
        ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", message);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        if (!image.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_IMAGE", image);
        }
        if (!status.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_STATUS", status);
        }
        if (!messageStyle.equals("")) {
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", messageStyle);
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer modifiedFieldsContainer, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps) throws Exception {
        this.getProperties(true, modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, "organizationalUnit");
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        try {
            request.setAttribute("statusProps", (Object)this.nativeStatusProps);
            request.setAttribute("customScriptResult", (Object)this.customScriptResult);
            Long tid = new Long(request.getParameter("templateId"));
            Properties toAudit = new Properties();
            toAudit.setProperty("TEMPLATE_NAME", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            this.updateAuditEntries(toAudit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAuditEntries() {
        this.updateAuditEntries(null);
    }

    public void updateAuditEntries(Properties toAudit) {
        try {
            ArrayList creationMsg;
            String statusMessage;
            if (!(this.isChangesFound || this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0 || this.fcNativeProperties.getModifyList() != null && this.fcNativeProperties.getModifyList().size() != 0 || this.fcNativeProperties.getTsList() != null && this.fcNativeProperties.getTsList().size() != 0 || this.fcNativeProperties.getWinNTAttributeList() != null && this.fcNativeProperties.getWinNTAttributeList().size() != 0 || this.customList != null && this.customList.size() != 0)) {
                return;
            }
            this.creationId = FcExecuteFormFlow.getNewObjectCreationId();
            this.objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(this.creationId, this.executeLayout.getLayoutId());
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            JSONArray selectedIamAppsJsonArray = this.executeLayout.getSelectedIamAppsJsonArray();
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)this.objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)FcExecuteActionConstants.ouModificationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.fromClientData, FcExecuteActionConstants.ouModificationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.ouModificationTemplateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)9008, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)this.objectIndexId, (Long)FcExecuteActionConstants.ouModificationTemplateCategoryId, (String)this.fullName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            if (props.get("customScriptDetails") != null) {
                Properties grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            if (this.modifiedFullName != null && this.modifiedFullName.length() > 0) {
                Properties nameList = new Properties();
                nameList.put("ATTRIB_LDAP_NAME", "name");
                nameList.put("ATTRIB_VALUE", this.modifiedFullName);
                propList.add(nameList);
            }
            if (props.get("OUName") != null) {
                Properties containerName = new Properties();
                containerName.put("ATTRIB_LDAP_NAME", "container");
                containerName.put("ATTRIB_VALUE", (String)props.get("OUName"));
                propList.add(containerName);
            }
            if (toAudit != null) {
                Properties propToAud = new Properties();
                propToAud.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
                propToAud.put("ATTRIB_VALUE", toAudit.getProperty("TEMPLATE_NAME"));
                propList.add(propToAud);
            }
            TechAuditAPI.getInstance().auditOUModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.modify_single_ou"), this.fullName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), this.nativeStatusProps.getProperty("STATUS_MESSAGE"), object_id, auditDataObj, this.rb);
            if (!this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"OU"}, (boolean)false);
            }
            if ((statusMessage = this.nativeStatusProps.getProperty("STATUS_MESSAGE")) == null) {
                statusMessage = "";
            }
            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
            }
            if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                        statusMessage = statusMessage + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                    }
                    statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                    if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                    statusMessage = statusMessage + creationMessage.get("NATIVE_ERROR_MESSAGE");
                }
            }
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 5;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.OU_MODIFICATION_MANAGED_BY_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.OU_MODIFICATION_MANAGED_BY_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.OU_MODIFICATION_MANAGED_BY_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BOC_LAYOUT_VIEW_ID;
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(ouName);
                this.triggerNotifiation(audit_id, object_id, this.fullName, manager, null, userObjectId, ReportsUtil.SINGLE_OU_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public Properties getSingleOUErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String errStatusMessage = this.rb.getString("admp.mgmt.common.statmsg.updated_with_errors");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", errStatusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    @Override
    public boolean isAuthorizedObject() {
        boolean isAuthorizedObject = false;
        if (this.authorizedOUList == null || this.authorizedOUList.size() == 0 || this.distinguishedName == null) {
            isAuthorizedObject = true;
        } else {
            for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                String s = this.distinguishedName.toLowerCase();
                if (!s.endsWith(dn)) continue;
                isAuthorizedObject = true;
            }
        }
        return isAuthorizedObject;
    }

    private Boolean getProtectAccidentalDeletion(String distinguishedName) {
        Boolean returnValue;
        block3: {
            returnValue = false;
            try {
                ArrayList aceList;
                Properties aclProp = ADHandler.getACLsFromDNWithoutLookup((String)this.domainName, (Long)this.loginId, (String)distinguishedName);
                if (aclProp == null || (aceList = (ArrayList)aclProp.get("acls")) == null || aceList.isEmpty()) break block3;
                for (int index = 0; index < aceList.size(); ++index) {
                    Properties aceProps = (Properties)aceList.get(index);
                    String trusteeSid = (String)aceProps.get("sid");
                    String aceType = (String)aceProps.get("aceType");
                    String accessMask = (String)aceProps.get("accessMask");
                    if (!aceType.equalsIgnoreCase("admp.common.native.permissions.accesstype_deny") || !trusteeSid.equalsIgnoreCase("S-1-1-0") || !accessMask.equalsIgnoreCase("65600")) continue;
                    returnValue = true;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return returnValue;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

